/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.formplugin.MalMakeOrderCorePlugin;
import kd.scm.mal.formplugin.util.MalJdProductUtil;
import kd.scm.mal.formplugin.util.MalMakeOrderHelper;
import kd.scm.mal.formplugin.util.MalProductUtil;

public class MalJDMakeOrderPlugin
extends MalMakeOrderCorePlugin {
    private static Log log = LogFactory.getLog(MalJDMakeOrderPlugin.class);
    protected static final String PAYTYPE = "paytype";

    @Override
    protected Map<String, Map<Long, Long>> getProdMatMappingMap(List<Long> skuList) {
        HashMap<String, Map<Long, Long>> resultMap = new HashMap<String, Map<Long, Long>>();
        ArrayList<Long> prodIdList = new ArrayList<Long>();
        HashMap<Long, Long> prodMatIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> purTypeMatIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> catMatIdMap = new HashMap<Long, Long>();
        HashMap prodCatIdMap = new HashMap();
        ArrayList skuIdList = new ArrayList();
        skuList.forEach(id -> skuIdList.add(String.valueOf(id)));
        QFilter filters = new QFilter("number", "in", skuIdList);
        DynamicObjectCollection goodsDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id", (QFilter[])new QFilter[]{filters});
        for (DynamicObject goodsdyo : goodsDyoCol) {
            prodIdList.add(goodsdyo.getLong("id"));
        }
        String selectedFields = "goods.id,goods.number,material.id,category.id,purchasetype.id";
        QFilter mappingfilters = new QFilter("goods", "in", prodIdList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectedFields, (QFilter[])new QFilter[]{mappingfilters});
        if (null != dyoCol && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                Long goodsId = dyo.getLong("goods.number");
                Long categoryId = dyo.getLong("category.id");
                Long purchaseTypeId = dyo.getLong("purchasetype.id");
                Long materialId = dyo.getLong("material.id");
                prodMatIdMap.put(goodsId, materialId);
                catMatIdMap.put(categoryId, materialId);
                purTypeMatIdMap.put(purchaseTypeId, materialId);
            }
        }
        resultMap.put("prodMat", prodMatIdMap);
        resultMap.put("prodCat", purTypeMatIdMap);
        resultMap.put("catMat", catMatIdMap);
        resultMap.put("prodPurType", prodCatIdMap);
        return resultMap;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            this.getModel().setValue("freight", (Object)this.getFreight());
            this.handleFee();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if (StringUtils.equals((CharSequence)PAYTYPE, (CharSequence)fieldKey)) {
            String newPayType = String.valueOf(changedData[0].getNewValue());
            String oldPayType = String.valueOf(changedData[0].getOldValue());
            if (StringUtils.isNotBlank((CharSequence)newPayType) && !StringUtils.equalsIgnoreCase((CharSequence)newPayType, (CharSequence)oldPayType)) {
                model.setValue("freight", (Object)this.getFreight());
                this.handleFee();
            }
        }
        if (StringUtils.equals((CharSequence)"invoiceid", (CharSequence)fieldKey)) {
            DynamicObject newValue = (DynamicObject)changedData[0].getNewValue();
            if (null != newValue) {
                Object number = newValue.get("number");
                if ("1".equals(number)) {
                    this.getModel().setValue("invoicetype", (Object)"3");
                } else {
                    this.getModel().setValue("invoicetype", (Object)"2");
                }
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u53d1\u7968\u7c7b\u578b\u3002", (String)"MalJDMakeOrderPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void bindAccountData(BigDecimal paramAmount) {
        super.bindAccountData(paramAmount);
        this.getModel().setValue("freight", (Object)this.getFreight());
        log.info("@@@bindAccountData1:" + this.getModel().getValue("freight"));
        this.getModel().setValue("sumamount", (Object)paramAmount.add(CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("freight"))));
        this.handleFee();
        log.info("@@@bindAccountData2:" + this.getModel().getValue("freight"));
    }

    protected void handleFee() {
        MalFeeHandleHelper.calAvgFreight4Jd((DynamicObject)this.getModel().getDataEntity(true));
        this.getView().updateView();
    }

    @Override
    public void makeOrder() {
        IFormView view = this.getView();
        Map featureMap = FeatureCheckUtil.checkMalJdFeature();
        if (null != featureMap && null != featureMap.get("hasLicense") && null != featureMap.get("licenseMsg") && !((Boolean)featureMap.get("hasLicense")).booleanValue()) {
            view.showMessage(String.valueOf(featureMap.get("licenseMsg")));
            return;
        }
        List<String> skuList = Arrays.asList(this.getPageCache().get("prodId").split(","));
        List<String> offList = MalJdProductUtil.checkJdSkuStates(skuList);
        if (null != offList && offList.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalJDMakeOrderPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalJDMakeOrderPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(offList), MessageTypes.Default);
            return;
        }
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        MalMakeOrderHelper makeOrderHelper = new MalMakeOrderHelper();
        Map<String, Object> resultMsg = makeOrderHelper.makeOrder(ProductSourceEnum.PRODUCTSOURCE_JD.getVal(), sourceDyo);
        boolean flag = (Boolean)resultMsg.get("isSucess");
        if (flag) {
            Long malOrderBillPk = (Long)resultMsg.get("billid");
            if (null != malOrderBillPk) {
                BillShowParameter billShowParameter;
                this.createAttachment(malOrderBillPk);
                boolean isCloseMakeOrder = true;
                if (MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()) == ShowType.NewWindow) {
                    billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.EDIT, (long)malOrderBillPk, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "afterSubmit"));
                    isCloseMakeOrder = false;
                } else {
                    billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()), (OperationStatus)OperationStatus.EDIT, (long)malOrderBillPk, null, null);
                }
                this.getView().showForm((FormShowParameter)billShowParameter);
                HashMap<String, Boolean> returnData = new HashMap<String, Boolean>();
                returnData.put("sucessMakeOrder", Boolean.TRUE);
                this.getView().returnDataToParent(returnData);
                if (isCloseMakeOrder) {
                    this.getView().close();
                }
            }
        } else if (resultMsg.get("errMsg") instanceof String && StringUtils.isNotBlank((Object)resultMsg.get("errMsg"))) {
            view.showMessage(ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u4e0b\u5355\u5931\u8d25\u3002", (String)"MalJDMakeOrderPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]), String.valueOf(resultMsg.get("errMsg")), MessageTypes.Default);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_productdetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IDataModel entryOperate = this.getModel();
        int currentIndex = entryOperate.getEntryCurrentRowIndex("entryentity");
        String goodsId = entryOperate.getEntryRowEntity("entryentity", currentIndex).getString("goods");
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        String token = MalJdProductUtil.getAccessToken();
        String str = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/product/getDetail", (String)("&token=" + token + "&sku=" + goodsId));
        detailParamMap.put("productJD", str);
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    @Override
    public String checkNotNull() {
        super.checkNotNull();
        StringBuilder sb = new StringBuilder();
        if (null == this.getModel().getValue(PAYTYPE)) {
            sb.append(ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u5f0f,", (String)"MalJDMakeOrderPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if (null == this.getModel().getValue("invoiceid")) {
            sb.append(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b,", (String)"MalJDMakeOrderPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if (null == this.getModel().getValue("invoicecontent")) {
            sb.append(ResManager.loadKDString((String)"\u53d1\u7968\u5185\u5bb9,", (String)"MalJDMakeOrderPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    @Override
    public String checkPurchaseType() {
        if (!ApiConfigUtil.hasCQScmConfig()) {
            return super.checkPurchaseType();
        }
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entryColl = ((AbstractFormDataModel)this.getModel()).getEntryEntity("entryentity");
        DataEntityPropertyCollection properties = entryColl.getDynamicObjectType().getProperties();
        DynamicObject purchaseType = null;
        DynamicObject oldpurchaseType = null;
        for (DynamicObject entry : entryColl) {
            DynamicProperty purchaseTypePro = (DynamicProperty)properties.get((Object)"purtype");
            purchaseType = (DynamicObject)purchaseTypePro.getValue((Object)entry);
            if (purchaseType != null && oldpurchaseType != null && !StringUtils.equals((CharSequence)purchaseType.getString("id"), (CharSequence)oldpurchaseType.getString("id"))) {
                sb.append(ResManager.loadKDString((String)"\u540c\u4e00\u6b21\u4e0b\u5355\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u91c7\u8d2d\u7c7b\u578b\u3002", (String)"MalJDMakeOrderPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                break;
            }
            oldpurchaseType = purchaseType;
        }
        return sb.toString();
    }

    private BigDecimal getFreight() {
        BigDecimal freight = BigDecimal.ZERO;
        String addressId = String.valueOf(this.getModel().getValue("receipt"));
        String paymentType = String.valueOf(this.getModel().getValue(PAYTYPE));
        if (StringUtils.isNotBlank((CharSequence)addressId) && StringUtils.isNotBlank((CharSequence)paymentType)) {
            HashMap<String, Integer> sku_qtyMap = new HashMap<String, Integer>();
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("entryentity");
            for (DynamicObject dyo : entryDyoCol) {
                String sku = dyo.getString("goods");
                sku_qtyMap.put(sku, dyo.getInt("qty"));
            }
            String[] area = "19_1607_3155_0".split("_");
            String jdAddress = MalJdProductUtil.getRecieptInfo(addressId).get("receiptjdadress");
            if (StringUtils.isNotBlank((CharSequence)jdAddress)) {
                area = jdAddress.split("_");
                freight = JdApiUtil.getFreight(sku_qtyMap, (String[])area, (String)paymentType);
            }
        }
        return freight;
    }
}

