/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.SystemProperties;
import kd.scm.common.util.BillFormUtil;
import kd.scm.mal.formplugin.sqlscipt.MalTransInner;

public class MalKSQLExpPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String PARTITION = ",";
    private static final String ENTITYID = "entityid";
    private static final String MAL_SELECTDATA = "mal_selectdata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"onekey", "btnselectdata", "translate", "detail", "check"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (!this.checkPassword()) {
            this.getView().showErrorNotification("password error");
            evt.setCancel(true);
        }
    }

    private boolean checkPassword() {
        if (Stream.of("tenant_devscm_dev", "tenant_feature_sit_scm_test", "tenant_feature_sit_smoke", "tenant_feature_sit_scm_smoke", "tenant_patchscm_smoke", "patchscm", "baseline_a", "baseline_b", "baseline_c", "baseline_d", "baseline_smoke", "tenant_devscm_test").anyMatch(tenantCode -> StringUtils.equals((CharSequence)RequestContext.get().getTenantCode(), (CharSequence)tenantCode))) {
            return true;
        }
        return StringUtils.equals((CharSequence)String.valueOf(this.getModel().getValue("sqlpwdstr")), (CharSequence)SystemProperties.getWithEnv((String)"MAL_KSQL_PWDSTR"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        switch (bt.getKey()) {
            case "onekey": {
                this.oneKeyGenerateSQL();
                break;
            }
            case "btnselectdata": {
                this.openSelectDataWin();
                break;
            }
            case "translate": {
                this.openKSQLTransWindow();
                break;
            }
            case "detail": {
                this.openDetail();
                break;
            }
            case "check": {
                this.checkksql();
                break;
            }
        }
    }

    private void checkksql() {
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        String sqls = codeSQLshow.getText();
        DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("entity");
        if (entityDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"MalKSQLExpPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityKey = entityDyn.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        String dbRouteKey = mainEntityType.getDBRouteKey();
        String error = MalTransInner.checkKsql(dbRouteKey, sqls);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            this.getView().showTipNotification(error);
        } else {
            this.getView().showTipNotification("check success!");
        }
    }

    private void openDetail() {
        String ids = (String)this.getModel().getValue("id");
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] idArr = ids.split(PARTITION);
            String entityId = this.getEntityId();
            if (idArr.length == 1) {
                BillShowParameter billShowParameter = BillFormUtil.assembleShowBillFormParam((String)entityId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(idArr[0]), null, null);
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId(entityId);
                listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                listShowParameter.setStatus(OperationStatus.VIEW);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                HashSet<Long> idSet = new HashSet<Long>(32);
                for (String id : idArr) {
                    idSet.add(Long.valueOf(id));
                }
                qFilters.add(new QFilter("id", "in", idSet));
                listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    protected void openSelectDataWin() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(MAL_SELECTDATA);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        String entityId = this.getEntityId();
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        fsp.setCustomParam(ENTITYID, (Object)entityId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MAL_SELECTDATA));
        this.getView().showForm(fsp);
    }

    private String getEntityId() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("entity");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"MalKSQLExpPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return "";
        }
        return dynamicObject.getString("number");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object retrunData;
        super.closedCallBack(closedCallBackEvent);
        if (MAL_SELECTDATA.equals(closedCallBackEvent.getActionId()) && (retrunData = closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("id", retrunData);
        }
    }

    protected void oneKeyGenerateSQL() {
        String idsStr = (String)this.getModel().getValue("id");
        if (StringUtils.isEmpty((CharSequence)idsStr)) {
            return;
        }
        String[] ids = idsStr.split(PARTITION);
        DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("entity");
        if (entityDyn == null) {
            return;
        }
        String entityKey = entityDyn.getString("number");
        String sql = MalTransInner.generateSQL(entityKey, ids);
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        sql = sql.replaceAll("0E-10", "0");
        codeSQLshow.setText(sql);
    }

    public void openKSQLTransWindow() {
        IFormView parentView = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_frame_ksqltrans");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("900px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCaption(ResManager.loadKDString((String)"KSQL\u7ffb\u8bd1\u5de5\u5177", (String)"MalKSQLExpPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        parentView.showForm(parameter);
    }
}

