/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.mal.common.org.IMalOrgService;
import kd.scm.mal.common.org.MalOrgServiceFactory;
import kd.scm.mal.formplugin.jdcenter.JdPriceCenter;
import kd.scm.mal.formplugin.util.MalProductUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MalMakeOrderCorePlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener,
AttachmentMarkListener {
    private static Log log = LogFactory.getLog(MalMakeOrderCorePlugin.class);
    protected static final String PRODLIST_ETNRY = "entryentity";
    protected static final String ADD_RECEIPT = "addreceipt";
    protected static final String MODIFY_RECEIPT = "modifyreceipt";
    protected static final String TOTALAMOUNT = "totalamount";
    protected static final String FREIGHT = "freight";
    protected static final String TOTAL_PAYAMOUNT = "totalpayamount";
    protected static final String TOTAL_REALPAY = "sumamount";
    protected static final String MAKE_ORDER = "makeorder";
    protected static final String DELETEENTRY = "deleteentry";
    protected static final String PRODPANEL = "prodinfopanel";
    protected static final String BIZFLOW_PARAM = "2";
    protected static final String PRODMATMAPPING_PARAM = "0";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl(PRODLIST_ETNRY);
        grid.addRowClickListener((RowClickEventListener)this);
        Button makeOrderBtn = (Button)this.getView().getControl(MAKE_ORDER);
        makeOrderBtn.addClickListener((ClickListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit depEdit = (BasedataEdit)this.getView().getControl("deporg");
        depEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rcvEdit = (BasedataEdit)this.getView().getControl("rcvorg");
        rcvEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleEdit = (BasedataEdit)this.getView().getControl("settleorg");
        settleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Container prodinfoContainer = (Container)this.getControl(PRODPANEL);
        prodinfoContainer.addClickListener((ClickListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addMarkListener((AttachmentMarkListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urlMsgs;
        JSONArray urls = new JSONArray();
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
            urls = JSONArray.fromObject((Object)tempUploadUrl);
        }
        if ((urlMsgs = evt.getUrls()) != null && urlMsgs.length > 0) {
            for (int i = 0; i < urlMsgs.length; ++i) {
                Map urlMsg = (Map)urlMsgs[i];
                JSONObject map = new JSONObject();
                for (Map.Entry entry : urlMsg.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                urls.add((Object)map);
            }
        }
        this.getPageCache().put("tempuploadurl", urls.toString());
    }

    public void remove(UploadEvent evt) {
        Object[] urlMsgs = evt.getUrls();
        if (urlMsgs != null && urlMsgs.length > 0) {
            JSONArray urls = new JSONArray();
            String tempUploadUrl = this.getPageCache().get("tempuploadurl");
            if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
                urls = JSONArray.fromObject((Object)tempUploadUrl);
            }
            Map urlMsg = (Map)urlMsgs[0];
            Iterator urlItr = urls.iterator();
            while (urlItr.hasNext()) {
                JSONObject jo = (JSONObject)urlItr.next();
                if (!StringUtils.isNotBlank((CharSequence)jo.getString("uid")) || !StringUtils.equals((CharSequence)jo.getString("uid"), (CharSequence)String.valueOf(urlMsg.get("uid")))) continue;
                urlItr.remove();
            }
            this.getPageCache().put("tempuploadurl", urls.toString());
        }
    }

    public void mark(AttachmentMarkEvent evt) {
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        JSONArray urlMsgs = JSONArray.fromObject((Object)tempUploadUrl);
        JSONArray urls = new JSONArray();
        for (int i = 0; i < urlMsgs.size(); ++i) {
            Map urlMsg = (Map)urlMsgs.get(i);
            JSONObject map = new JSONObject();
            for (Map.Entry entry : urlMsg.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            String id = (String)map.get("uid");
            String uid = evt.getUid();
            String description = evt.getDescription();
            if (id.equals(uid)) {
                map.put((Object)"description", (Object)description);
            }
            urls.add((Object)map);
        }
        this.getPageCache().put("tempuploadurl", urls.toString());
    }

    public void createAttachment(Long billPkId) {
        JSONArray urlMsgs;
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl) && (urlMsgs = JSONArray.fromObject((Object)tempUploadUrl)) != null && urlMsgs.size() > 0) {
            ArrayList attachList = new ArrayList(urlMsgs.size());
            for (int i = 0; i < urlMsgs.size(); ++i) {
                HashMap<String, Object> attachMap = new HashMap<String, Object>();
                JSONObject urlMsg = urlMsgs.getJSONObject(i);
                attachMap.put("lastModified", urlMsg.get("lastModified"));
                attachMap.put("name", urlMsg.get("name"));
                attachMap.put("size", urlMsg.get("size"));
                attachMap.put("status", urlMsg.get("status"));
                attachMap.put("type", urlMsg.get("type"));
                attachMap.put("uid", urlMsg.get("uid"));
                attachMap.put("url", urlMsg.get("url"));
                attachMap.put("description", urlMsg.get("description"));
                attachList.add(attachMap);
            }
            HashMap atts = new HashMap();
            if (attachList.size() > 0) {
                atts.put("attachmentpanel", attachList);
            }
            AttachmentServiceHelper.saveTempAttachments((String)"mal_order", (Object)billPkId, (String)"mal", atts);
        }
    }

    protected void setDefualtCurrency() {
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
    }

    protected void setBizPersonAndReciept(Map<String, Object> showParameterMap) {
        Object receipt;
        Object person = showParameterMap.get("person");
        if (person != null) {
            this.getModel().setValue("person", person);
        }
        if ((receipt = showParameterMap.get("receipt")) != null) {
            String selectFields = "id,name,phone,wholeaddress,email,address";
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", receipt)});
            this.fillReceipt(dynamicObject);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefualtCurrency();
        this.initReceiptInfoData();
        this.initDefualOrgUnit();
        this.initDefualtBizflow();
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if (showParameterMap != null) {
            List entryArray = (List)showParameterMap.get("slectProd");
            Object amount = showParameterMap.get("param_amount");
            if (entryArray != null && amount != null) {
                BigDecimal paramAmount = CommonUtil.getBigDecimalPro(amount);
                if (showParameterMap.containsKey("isfromerpreq")) {
                    this.getPageCache().put("isfromerpreq", "1");
                    this.lockMaterial();
                }
                this.bindEntryData(entryArray);
                this.bindAccountData(paramAmount);
                this.setBizPersonAndReciept(showParameterMap);
            }
            this.setFromCartValue(showParameterMap);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u754c\u9762\u521d\u59cb\u5316\u53c2\u6570\u4f20\u9012\u5931\u8d25\u3002", (String)"MalMakeOrderCorePlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    protected void setFromCartValue(Map<String, Object> showParameterMap) {
        Object fromCart = showParameterMap.get("fromCart");
        if (fromCart instanceof String) {
            this.getModel().setValue("fromcart", (Object)"true".equals(fromCart));
        }
    }

    protected void lockMaterial() {
        DynamicObjectCollection dyoCol = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(PRODLIST_ETNRY);
        for (int i = 0; i < dyoCol.size(); ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"material"});
        }
    }

    protected void initReceiptInfoData() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter filter = new QFilter("creator", "=", (Object)userId).and(new QFilter("default", "=", (Object)"1"));
        String selectFields = "id,name,phone,wholeaddress,email,address";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{filter});
        this.fillReceipt(dynamicObject);
    }

    public void fillReceipt(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            this.getModel().setValue("receipt", (Object)dynamicObject.getString("id"));
            this.getModel().setValue("addressid", (Object)dynamicObject.getString("address"));
            ((Label)this.getControl("receiptname")).setText(dynamicObject.getString("name"));
            ((Label)this.getControl("receiptaddress")).setText(this.formatAddress(dynamicObject.getString("wholeaddress")));
            ((Label)this.getControl("receiptphone")).setText(dynamicObject.getString("phone"));
            ((Label)this.getControl("receiptemail")).setText(dynamicObject.getString("email"));
        }
    }

    protected String formatAddress(String address) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)address.trim())) {
            String[] addr;
            for (String str : addr = address.split("_")) {
                sb.append(str);
            }
        }
        return sb.toString();
    }

    protected void initDefualtBizflow() {
        String param = BIZFLOW_PARAM;
        if (StringUtils.equals((CharSequence)param, (CharSequence)BIZFLOW_PARAM)) {
            this.getModel().setValue("bizflow", (Object)BIZFLOW_PARAM);
        }
    }

    protected void bindAccountData(BigDecimal paramAmount) {
        this.getModel().setValue(TOTALAMOUNT, (Object)paramAmount);
        this.getModel().setValue(FREIGHT, (Object)BigDecimal.ZERO);
        this.getModel().setValue(TOTAL_PAYAMOUNT, (Object)paramAmount);
        this.getModel().setValue(TOTAL_REALPAY, (Object)paramAmount);
    }

    protected void initDefualOrgUnit() {
        String personId = RequestContext.get().getUserId();
        Date deliDate = DateUtil.getNextDay((Date)new Date());
        this.getModel().setValue("delidate", (Object)deliDate);
        this.getModel().beginInit();
        this.getModel().setValue("reqperson", (Object)personId);
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        Long dptOrgId = malOrgService.getDefaultDemandOrgByUser(Long.valueOf(personId));
        if (dptOrgId == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u4eba\u4e3b\u804c\u4f4d\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalMakeOrderCorePlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("deporg", (Object)dptOrgId);
        this.getModel().setValue("costorg", (Object)dptOrgId);
        Long purOrg = malOrgService.getDefaultPurchaseOrg(dptOrgId);
        this.setOrg("org", purOrg);
        Long invOrg = 0L;
        invOrg = MalOrgServiceFactory.hasDelegantRalation() ? malOrgService.getDefaultInvOrg(dptOrgId) : (purOrg != 0L ? malOrgService.getDefaultInvOrg(purOrg) : null);
        this.getModel().setValue("rcvorg", (Object)invOrg);
        Long settleOrg = malOrgService.getDefaultSettleOrg(purOrg, invOrg);
        this.setOrg("settleorg", settleOrg);
        this.setOrg("invoiceorg", settleOrg);
        this.getModel().endInit();
    }

    @Deprecated
    protected void setDefualtPurchaseOrg(Long depOrgId, Long orgUnitId) {
        List<Long> toOrgIdList = this.getPurOrgIdList(depOrgId);
        this.setDefualtOrg(toOrgIdList, depOrgId, orgUnitId, "org");
    }

    @Deprecated
    protected void setDefualtInventoryOrg(Long depOrgId, Long orgUnitId) {
        List<Long> toOrgIdList = this.getInvOrgIdList(depOrgId);
        this.setDefualtOrg(toOrgIdList, depOrgId, orgUnitId, "rcvorg");
    }

    @Deprecated
    protected void setDefualtSettleOrg(Long depOrgId, Long orgUnitId, Long purOrgId, Long invOrgId) {
        List<Long> toOrgIdList = this.getSettleOrgIdList(purOrgId, invOrgId);
        this.setDefualtOrg(toOrgIdList, depOrgId, orgUnitId, "settleorg");
    }

    @Deprecated
    protected List<Long> getSettleOrgIdList(Long purOrgId, Long invOrgId) {
        ArrayList<Long> settleOrgIds = new ArrayList<Long>();
        if (purOrgId != 0L) {
            settleOrgIds.addAll(OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)purOrgId));
        }
        if (invOrgId != 0L) {
            settleOrgIds.addAll(OrgUtil.getToOrg((String)OrgTypeEnum.INVENTORY.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)invOrgId));
        }
        return settleOrgIds;
    }

    @Deprecated
    protected List<Long> getPurOrgIdList(Long depOrgId) {
        return OrgUtil.getToOrg((String)OrgTypeEnum.ADMINISTRATIVE.getVal(), (String)OrgTypeEnum.PURCHASE.getVal(), (Long)depOrgId);
    }

    @Deprecated
    protected List<Long> getInvOrgIdList(Long dptOrgId) {
        List<Long> toPurOrgIds = this.getPurOrgIdList(dptOrgId);
        ArrayList<Long> invOrgIds = new ArrayList<Long>();
        if (toPurOrgIds != null && toPurOrgIds.size() > 0 && toPurOrgIds.get(0) != 0L) {
            for (Long purOrgId : toPurOrgIds) {
                invOrgIds.addAll(OrgUtil.getFromOrgs((String)OrgTypeEnum.PURCHASE.getVal(), (Long)purOrgId, (String)OrgTypeEnum.INVENTORY.getVal()));
            }
        }
        return invOrgIds;
    }

    private void setOrg(String orgKey, Long orgId) {
        orgId = orgId != 0L ? orgId : null;
        this.getModel().setValue(orgKey, (Object)orgId);
    }

    @Deprecated
    protected void setDefualtOrg(List<Long> toOrgIdList, Long depOrgId, Long orgUnitId, String orgType) {
        if (toOrgIdList != null && toOrgIdList.size() > 0 && toOrgIdList.get(0) != 0L) {
            if (toOrgIdList.contains(depOrgId)) {
                this.getModel().setValue(orgType, (Object)depOrgId);
            } else if (toOrgIdList.contains(orgUnitId)) {
                this.getModel().setValue(orgType, (Object)orgUnitId);
            } else {
                this.getModel().setValue(orgType, (Object)toOrgIdList.get(0));
            }
        } else {
            this.getModel().setValue(orgType, null);
        }
    }

    @Deprecated
    protected DynamicObject getOrgUnitDyoById(Long orgId) {
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase,fisinventory,fisaccounting", (QFilter[])new QFilter[]{idFilter});
    }

    @Deprecated
    protected Map<String, Object> getDeporg(String personId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        QFilter idsFilter = new QFilter("id", "=", (Object)personId);
        QFilter partJobFilter = new QFilter("entryentity.ispartjob", "=", (Object)PRODMATMAPPING_PARAM);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"bos_user", (String)"entryentity.dpt.id", (QFilter[])new QFilter[]{idsFilter});
        DynamicObject mainDyo = QueryServiceHelper.queryOne((String)"bos_user", (String)"entryentity.dpt.id", (QFilter[])new QFilter[]{idsFilter, partJobFilter});
        if (null != dyoCol && dyoCol.size() > 0) {
            result.put("allDpt", MalProductUtil.getListByProperty(dyoCol, "entryentity.dpt.id"));
        }
        if (null != mainDyo) {
            result.put("mainDpt", mainDyo.getLong("entryentity.dpt.id"));
        }
        return result;
    }

    protected void bindEntryData(List<Map<String, Object>> entryArray) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        ArrayList<Long> prodIdList = new ArrayList<Long>(entryArray.size());
        ArrayList<String> skuList = new ArrayList<String>(entryArray.size());
        for (int i = 0; i < entryArray.size(); ++i) {
            Map<String, Object> dyoMap = entryArray.get(i);
            String key = (String)dyoMap.get("cart_goods");
            Long prodId = Long.valueOf(key);
            prodIdList.add(prodId);
            skuList.add(key);
        }
        String prodIdStr = ((Object)prodIdList).toString();
        this.getPageCache().put("prodId", prodIdStr.substring(1, prodIdStr.length() - 1));
        Map<String, Map<Long, Long>> resultMap = this.getProdMatMappingMap(prodIdList);
        Map<Long, Long> prodMatIdMap = resultMap.get("prodMat");
        Map<Long, Long> prodCatIdMap = resultMap.get("prodCat");
        Map<Long, Long> catMatIdMap = resultMap.get("catMat");
        HashMap<Long, BigDecimal> taxPriceMap = new HashMap<Long, BigDecimal>();
        Map<Object, Object> priceMap = new HashMap();
        if (null != entryArray.get(0)) {
            if (entryArray.get(0).get("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                QFilter filter = new QFilter("id", "in", prodIdList);
                DynamicObjectCollection dynamicObjectCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,shopprice", (QFilter[])new QFilter[]{filter});
                if (null != dynamicObjectCol && dynamicObjectCol.size() > 0) {
                    for (int i = 0; i < dynamicObjectCol.size(); ++i) {
                        Long pkId = ((DynamicObject)dynamicObjectCol.get(i)).getLong("id");
                        BigDecimal shopPrice = ((DynamicObject)dynamicObjectCol.get(i)).getBigDecimal("shopprice");
                        taxPriceMap.put(pkId, shopPrice);
                    }
                }
            } else if (entryArray.get(0).get("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                JdPriceCenter price = new JdPriceCenter();
                priceMap = price.getPrice(null, RequestContext.get().getTenantId(), skuList);
            }
        }
        String isFromErpReq = this.getPageCache().get("isfromerpreq");
        for (int i = 0; i < entryArray.size(); ++i) {
            BigDecimal price;
            Object cartErpmat;
            Map<String, Object> entryMap = entryArray.get(i);
            Long prodId = Long.valueOf((String)entryMap.get("cart_goods"));
            vs.set("goods", (Object)prodId, i);
            vs.set("goodsimg", entryMap.get("cart_pic"), i);
            vs.set("goodsnum", entryMap.get("cart_number"), i);
            vs.set("goodsname", entryMap.get("cart_name"), i);
            Object cartPurtype = entryMap.get("cart_purtype");
            if (cartPurtype != null) {
                vs.set("purtype", cartPurtype, i);
                if (StringUtils.equals((CharSequence)"1", (CharSequence)isFromErpReq)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"purtype"});
                }
            }
            if ((cartErpmat = entryMap.get("cart_erpmat")) != null) {
                vs.set("material", cartErpmat, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"material"});
            } else {
                Long prodMatId = prodMatIdMap.get(prodId);
                if (prodMatId != null) {
                    vs.set("material", (Object)prodMatId, i);
                } else {
                    Long prodCatId = catMatIdMap.get(prodCatIdMap.get(prodId));
                    if (prodCatId != null) {
                        vs.set("material", (Object)prodCatId, i);
                    }
                }
            }
            vs.set("goodsmodel", entryMap.get("cart_desc"), i);
            vs.set("supplier", entryMap.get("cart_supplier"), i);
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entryMap.get("cart_qty"));
            if (entryMap.get("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                vs.set("stockqty", (Object)CommonUtil.getBigDecimalPro((Object)entryMap.get("cart_stock_qty")), i);
                price = (BigDecimal)taxPriceMap.get(prodId);
                vs.set("goodprice", (Object)price, i);
                vs.set("goodamount", (Object)price.multiply(qty), i);
            } else {
                price = priceMap.get(prodId.toString()) != null ? CommonUtil.getBigDecimalPro((Object)((PriceInfo)priceMap.get(prodId.toString())).getShowprice()) : BigDecimal.ZERO;
                vs.set("goodprice", (Object)price, i);
                vs.set("goodamount", (Object)price.multiply(qty), i);
            }
            vs.set("qty", (Object)qty, i);
            vs.set("unit", entryMap.get("cart_unit"), i);
            if (!entryMap.containsKey("cart_billid") || !entryMap.containsKey("cart_entryid")) continue;
            vs.set("erpsourceid", entryMap.get("cart_billid"), i);
            vs.set("erpsourceentryid", entryMap.get("cart_entryid"), i);
        }
        model.batchCreateNewEntryRow(PRODLIST_ETNRY, vs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject settleOrgDyo;
        Long orgId;
        DynamicObject newDptDyo;
        IMalOrgService malOrgService;
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        this.qtyPropertyChange(fieldKey, changedData, model);
        if (StringUtils.equals((CharSequence)"reqperson", (CharSequence)fieldKey)) {
            DynamicObject reqPersonDyo = (DynamicObject)changedData[0].getNewValue();
            if (StringUtils.isBlank((Object)reqPersonDyo)) {
                return;
            }
            malOrgService = MalOrgServiceFactory.getMalOrgService();
            Long dptOrgId = malOrgService.getDefaultDemandOrgByUser(Long.valueOf(reqPersonDyo.getLong("id")));
            if (dptOrgId != 0L) {
                List dptList = malOrgService.getDemandOrgList(Long.valueOf(reqPersonDyo.getLong("id")));
                DynamicObject currDpt = (DynamicObject)this.getModel().getValue("deporg");
                if (MalOrgServiceFactory.hasDelegantRalation()) {
                    if (null != currDpt) {
                        Long curDptPk = currDpt.getLong("id");
                        if (!dptList.contains(curDptPk)) {
                            this.getModel().setValue("deporg", (Object)dptOrgId);
                            this.getModel().setValue("costorg", (Object)dptOrgId);
                        }
                        QFilter filter = new QFilter("id", "in", (Object)dptList);
                        BasedataEdit depEdit = (BasedataEdit)this.getView().getControl("deporg");
                        depEdit.setQFilter(filter);
                    }
                } else {
                    this.getModel().setValue("deporg", (Object)dptOrgId);
                    this.getModel().setValue("costorg", (Object)dptOrgId);
                }
            } else {
                this.clearOrg();
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u4eba\u6240\u5c5e\u90e8\u95e8\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalMakeOrderCorePlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)"deporg", (CharSequence)fieldKey) && null != (newDptDyo = (DynamicObject)changedData[0].getNewValue())) {
            DynamicObject purOrg;
            Long purOrgId;
            Long newDptId;
            malOrgService = MalOrgServiceFactory.getMalOrgService();
            List purOrgList = malOrgService.getPurchaseOrgList(newDptId = Long.valueOf(newDptDyo.getLong("id")));
            if (!purOrgList.contains(purOrgId = Long.valueOf((purOrg = (DynamicObject)this.getModel().getValue("org")) != null ? purOrg.getLong("id") : 0L))) {
                Long orgId2 = null;
                Long defaultOrgId = malOrgService.getDefaultPurchaseOrg(newDptId);
                orgId2 = null != defaultOrgId && defaultOrgId != 0L ? defaultOrgId : malOrgService.getSelectDefault(purOrgList, newDptId);
                this.setOrg("org", orgId2);
            }
            this.getModel().setValue("costorg", (Object)newDptId);
        }
        if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey)) {
            DynamicObject purOrg = (DynamicObject)changedData[0].getNewValue();
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            IMalOrgService malOrgService2 = MalOrgServiceFactory.getMalOrgService();
            try {
                Long invOrgId = malOrgService2.getDefaultInvOrg(purOrgId);
                this.setOrg("rcvorg", invOrgId);
                orgId = 0L;
                if (MalOrgServiceFactory.hasDelegantRalation()) {
                    orgId = malOrgService2.getDefaultSettleOrg(purOrgId, invOrgId);
                } else {
                    DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
                    Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
                    orgId = malOrgService2.getDefaultSettleOrg(dptOrgId, purOrgId);
                }
                this.setOrg("settleorg", orgId);
            }
            catch (Exception exception) {
                this.getView().showTipNotification(exception.getMessage());
            }
        }
        if (StringUtils.equals((CharSequence)"rcvorg", (CharSequence)fieldKey)) {
            DynamicObject invOrg = (DynamicObject)changedData[0].getNewValue();
            DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
            Long invOrgId = invOrg != null ? invOrg.getLong("id") : 0L;
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            orgId = 0L;
            IMalOrgService malOrgService3 = MalOrgServiceFactory.getMalOrgService();
            if (MalOrgServiceFactory.hasDelegantRalation()) {
                orgId = malOrgService3.getDefaultSettleOrg(purOrgId, invOrgId);
            } else {
                DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
                Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
                orgId = malOrgService3.getDefaultSettleOrg(dptOrgId, purOrgId);
            }
            this.setOrg("settleorg", orgId);
        }
        if (StringUtils.equals((CharSequence)"settleorg", (CharSequence)fieldKey) && null != (settleOrgDyo = (DynamicObject)changedData[0].getNewValue())) {
            this.getModel().setValue("invoiceorg", (Object)settleOrgDyo.getLong("id"));
        }
    }

    protected void qtyPropertyChange(String fieldKey, ChangeData[] changedData, IDataModel model) {
        if (StringUtils.equals((CharSequence)"qty", (CharSequence)fieldKey)) {
            BigDecimal newVal;
            int rowIndex = changedData[0].getRowIndex();
            DynamicObject rowEntity = model.getEntryRowEntity(PRODLIST_ETNRY, rowIndex);
            BigDecimal price = rowEntity.getBigDecimal("goodprice");
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            if (oldVal.compareTo(newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue())) == 0) {
                return;
            }
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                model.setValue("qty", (Object)oldVal, rowIndex);
            } else {
                this.handleQtyChanged(rowIndex, newVal, price);
                this.getView().updateView("entryentity.qty");
            }
        }
    }

    protected void handleQtyChanged(int rowIndex, BigDecimal newVal, BigDecimal price) {
        BigDecimal amount = newVal.multiply(price);
        this.getModel().setValue("goodamount", (Object)amount, rowIndex);
        this.bindAccountData(this.calTotalAmount());
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Long purOrgId;
        DynamicObject purOrg;
        QFilter filter;
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        boolean hasRelation = MalOrgServiceFactory.hasDelegantRalation();
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"deporg") && hasRelation) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8", (String)"MalMakeOrderCorePlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            DynamicObject person = (DynamicObject)this.getModel().getValue("reqperson");
            if (null != person) {
                Long personId = person.getLong("id");
                filter = new QFilter("id", "in", (Object)malOrgService.getDemandOrgList(personId));
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
            Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
            filter = new QFilter("id", "in", (Object)malOrgService.getPurchaseOrgList(dptOrgId));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"rcvorg")) {
            purOrg = (DynamicObject)this.getModel().getValue("org");
            purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            filter = new QFilter("id", "in", (Object)malOrgService.getInvOrgList(purOrgId));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"settleorg") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"invoiceorg")) {
            DynamicObject dptOrg;
            DynamicObject invOrg;
            purOrg = (DynamicObject)this.getModel().getValue("org");
            purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            Long orgId = 0L;
            orgId = hasRelation ? Long.valueOf((invOrg = (DynamicObject)this.getModel().getValue("rcvorg")) != null ? invOrg.getLong("id") : 0L) : Long.valueOf((dptOrg = (DynamicObject)this.getModel().getValue("deporg")) != null ? dptOrg.getLong("id") : 0L);
            QFilter filter2 = new QFilter("id", "in", (Object)malOrgService.getSettleOrgList(purOrgId, orgId));
            log.info("@@@\u7ed3\u7b97\u7ec4\u7ec7F7\u6253\u5f00\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter2);
            showParameter.getListFilterParameter().getQFilters().add(filter2);
        }
        this.setMaterialF7Filter(fieldKey, showParameter);
    }

    public void setMaterialF7Filter(String fieldKey, ListShowParameter showParameter) {
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            QFilter filter = new QFilter("enablepur", "=", (Object)"1").and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)purOrgId));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void clearOrg() {
        this.getModel().beginInit();
        this.getModel().setValue("deporg", null);
        this.getModel().setValue("org", null);
        this.getModel().setValue("rcvorg", null);
        this.getModel().setValue("settleorg", null);
        this.getModel().setValue("invoiceorg", null);
        this.getModel().setValue("costorg", null);
        this.getModel().endInit();
    }

    protected Map<String, Map<Long, Long>> getProdMatMappingMap(List<Long> prodIdList) {
        return null;
    }

    protected BigDecimal calTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObjectCollection dyoCol = this.getModel().getEntryEntity(PRODLIST_ETNRY);
        for (DynamicObject dyo : dyoCol) {
            totalAmount = totalAmount.add(CommonUtil.getBigDecimalPro((Object)dyo.get("goodamount")));
        }
        return totalAmount;
    }

    protected void showDetailPage(String productId) {
    }

    protected void addReceipt() {
        BaseShowParameter param = new BaseShowParameter();
        param.setFormId("mal_address");
        param.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u6536\u8d27\u4eba\u4fe1\u606f", (String)"MalMakeOrderCorePlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        HashMap<String, Boolean> customFilter = new HashMap<String, Boolean>();
        customFilter.put("isCallByMakeOrder", Boolean.TRUE);
        param.setCustomParams(customFilter);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_address"));
        this.openPage((FormShowParameter)param);
    }

    protected void modifyReceipt() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("mal_receiptlist");
        param.setCaption(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f\u5217\u8868", (String)"MalMakeOrderCorePlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_receiptlist"));
        this.openPage(param);
    }

    protected void openPage(FormShowParameter param) {
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.setReturnData(closedCallBackEvent);
        if ("afterSubmit".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }

    protected void setReturnData(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        if (("mal_address".equals(closedCallBackEvent.getActionId()) || "mal_receiptlist".equals(closedCallBackEvent.getActionId())) && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null) {
            this.setReceiptInfo(returnData);
        }
    }

    protected void setReceiptInfo(Map<String, String> returnData) {
        String receipt = (String)this.getModel().getValue("receipt");
        if (!StringUtils.equals((CharSequence)receipt, (CharSequence)returnData.get("id"))) {
            this.getModel().setValue("receipt", (Object)returnData.get("id"));
            this.getModel().setValue("addressid", (Object)returnData.get("address"));
            ((Label)this.getControl("receiptname")).setText(returnData.get("name"));
            ((Label)this.getControl("receiptaddress")).setText(this.formatAddress(returnData.get("wholeaddress")));
            ((Label)this.getControl("receiptphone")).setText(returnData.get("phone"));
            ((Label)this.getControl("receiptemail")).setText(returnData.get("email"));
            this.handleFeeByAddressChanged();
        }
    }

    protected void handleFeeByAddressChanged() {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getView().updateView(PRODLIST_ETNRY);
        this.bindAccountData(this.calTotalAmount());
        this.getView().updateView();
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection dyoCol = this.getModel().getEntryEntity(PRODLIST_ETNRY);
        int[] selectIndex = this.getSelectIndex();
        if (dyoCol.size() == selectIndex.length || dyoCol.size() < 2) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u624d\u80fd\u8fdb\u884c\u7ed3\u7b97\uff0c\u4e0d\u80fd\u5168\u90e8\u5220\u9664\u3002", (String)"MalMakeOrderCorePlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected int[] getSelectIndex() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(PRODLIST_ETNRY);
        return grid.getEntryState().getSelectedRows();
    }

    public void makeOrder() {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "addreceipt": {
                this.addReceipt();
                break;
            }
            case "modifyreceipt": {
                this.modifyReceipt();
                break;
            }
            case "makeorder": {
                this.checkFrieght();
                break;
            }
            case "deleteentry": {
                int[] selectIndex = this.getSelectIndex();
                if (selectIndex.length >= 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"MalMakeOrderCorePlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                break;
            }
        }
    }

    public void checkFrieght() {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(PRODLIST_ETNRY);
        DynamicObject currObj = (DynamicObject)this.getModel().getDataEntity(true).get("curr");
        String curr = String.valueOf(currObj.get("name"));
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        List entryArray = (List)showParameterMap.get("slectProd");
        StringBuilder sb = new StringBuilder();
        Set supplierSet = entryDyoCol.stream().map(x -> x.get("supplier")).collect(Collectors.toSet());
        for (Object supplierid : supplierSet) {
            BigDecimal freightTotal = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (DynamicObject goodsObject : entryDyoCol) {
                if (!supplierid.equals(goodsObject.get("supplier"))) continue;
                BigDecimal avgfreight = goodsObject.getBigDecimal("avgfreight");
                BigDecimal goodamount = goodsObject.getBigDecimal("goodamount");
                freightTotal = freightTotal.add(avgfreight);
                totalAmount = totalAmount.add(goodamount);
            }
            if (freightTotal.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (((Map)entryArray.get(0)).get("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                String addressId = (String)this.getModel().getValue("addressid");
                BigDecimal freightFree = MalFeeHandleHelper.getFreightFree((String)addressId, (String)String.valueOf(supplierid));
                if (freightFree.compareTo(BigDecimal.ZERO) <= 0) continue;
                QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(supplierid)));
                QFilter[] filters = new QFilter[]{filter};
                DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"name", (QFilter[])filters);
                String differenceAmount = String.valueOf(freightFree.subtract(totalAmount).setScale(currObj.getInt("amtprecision"), 4));
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u8ba2\u5355\u8fd8\u5dee%2$s%3$s\u5305\u90ae\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalMakeOrderCorePlugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0]), String.valueOf(supplier.get("name")), differenceAmount, curr);
                sb.append(msg).append('\n');
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u4eac\u4e1c\u5546\u57ce\u7684\u8ba2\u5355\u5305\u542b\u8fd0\u8d39\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalMakeOrderCorePlugin_30", (String)"scm-mal-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sb.length() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("make_order", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u60a8\u7684\u8ba2\u5355\u5305\u542b\u8fd0\u8d39\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalMakeOrderCorePlugin_31", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, String.valueOf(sb), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.makeOrder();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"make_order", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.makeOrder();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent var1) {
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)MAKE_ORDER)) {
            String content;
            DynamicObjectCollection entryColl;
            String content2;
            StringBuilder sb = new StringBuilder();
            if (null == model.getValue("reqperson")) {
                sb.append(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba,", (String)"MalMakeOrderCorePlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("deporg")) {
                sb.append(ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7,", (String)"MalMakeOrderCorePlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)model.getValue("remark"))) {
                sb.append(ResManager.loadKDString((String)"\u7533\u8bf7\u4e8b\u7531,", (String)"MalMakeOrderCorePlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("receipt") || StringUtils.isBlank((Object)model.getValue("receipt"))) {
                sb.append(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f,", (String)"MalMakeOrderCorePlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("settleorg")) {
                sb.append(ResManager.loadKDString((String)"\u6838\u7b97\u516c\u53f8,", (String)"MalMakeOrderCorePlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("rcvorg")) {
                sb.append(ResManager.loadKDString((String)"\u6536\u8d27\u7ec4\u7ec7,", (String)"MalMakeOrderCorePlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("org")) {
                sb.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7,", (String)"MalMakeOrderCorePlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (null == model.getValue("invoiceorg")) {
                sb.append(ResManager.loadKDString((String)"\u8d27\u4e3b,", (String)"MalMakeOrderCorePlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            sb.append(this.checkNotNull());
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(ResManager.loadKDString((String)"\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MalMakeOrderCorePlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u5f55\u5b57\u6bb5\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"MalMakeOrderCorePlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                evt.setCancel(true);
            }
            if (!evt.isCancel() && StringUtils.isNotBlank((CharSequence)(content2 = this.fitNullValue(entryColl = model.getEntryEntity(PRODLIST_ETNRY))))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u6e05\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MalMakeOrderCorePlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]), content2, MessageTypes.Default);
                evt.setCancel(true);
            }
            if (!evt.isCancel() && StringUtils.isNotBlank((CharSequence)(content = this.checkPurchaseType()))) {
                this.getView().showMessage(content);
                evt.setCancel(true);
            }
            if (!evt.isCancel() && MalOrgServiceFactory.hasDelegantRalation()) {
                DynamicObject pursettleOrg = (DynamicObject)model.getValue("settleorg");
                DynamicObject purOrg = (DynamicObject)model.getValue("org");
                DynamicObject invOrg = (DynamicObject)model.getValue("rcvorg");
                Long purToSetOrgId = 0L;
                Long invToSettOrgId = 0L;
                List purTSetIdList = new ArrayList();
                List invToSettIdList = new ArrayList();
                if (null != purOrg) {
                    purTSetIdList = OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)purOrg.getLong("id"));
                    Long l = purToSetOrgId = purTSetIdList.size() > 0 ? (Long)purTSetIdList.get(0) : Long.valueOf(0L);
                }
                if (null != invOrg) {
                    invToSettIdList = OrgUtil.getToOrg((String)OrgTypeEnum.INVENTORY.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)invOrg.getLong("id"));
                    Long l = invToSettOrgId = invToSettIdList.size() > 0 ? (Long)invToSettIdList.get(0) : Long.valueOf(0L);
                }
                if (purTSetIdList.size() < 1 || invToSettIdList.size() < 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u6216\u5e93\u5b58\u7ec4\u7ec7\u672a\u59d4\u6258\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u59d4\u6258\u5173\u7cfb\u3002", (String)"MalMakeOrderCorePlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                if (pursettleOrg.getLong("id") != purToSetOrgId.longValue() && pursettleOrg.getLong("id") != invToSettOrgId.longValue()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u7b97\u516c\u53f8\u4e0e\u91c7\u8d2d\u7ec4\u7ec7\u3001\u6536\u8d27\u7ec4\u7ec7\u7684\u5173\u7cfb\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u6838\u7b97\u516c\u53f8\u3002", (String)"MalMakeOrderCorePlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
            if (MalOrderUtil.hasAttachmentUploading((IFormView)this.getView())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MalMakeOrderCorePlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)PRODPANEL, (CharSequence)source.getKey())) {
            String productId = String.valueOf(source.getModel().getValue("goods"));
            this.showDetailPage(productId);
        }
    }

    public String checkPurchaseType() {
        return "";
    }

    public String checkNotNull() {
        return null;
    }

    public String fitNullValue(DynamicObjectCollection dynamicObjectsParam) {
        int rowCount = 1;
        StringBuilder contentRow = new StringBuilder();
        if (dynamicObjectsParam.size() > this.getLimitRows()) {
            return contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1\u6e05\u5355\u5206\u5f55\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7{0}\u884c\u3002", (String)"MalMakeOrderCorePlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getLimitRows())).toString();
        }
        DataEntityPropertyCollection properties = dynamicObjectsParam.getDynamicObjectType().getProperties();
        for (DynamicObject dynamicObject : dynamicObjectsParam) {
            DynamicProperty materialPro = (DynamicProperty)properties.get((Object)"material");
            Object material = materialPro.getValue((Object)dynamicObject);
            DynamicProperty purchaseTypePro = (DynamicProperty)properties.get((Object)"purtype");
            Object purchaseType = purchaseTypePro.getValue((Object)dynamicObject);
            if ((null == material || null == purchaseType) && rowCount == 1) {
                contentRow.append(ResManager.loadKDString((String)"\u5546\u54c1\u6e05\u5355\u5206\u5f55\uff1a", (String)"MalMakeOrderCorePlugin_22", (String)"scm-mal-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (null == material) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"MalMakeOrderCorePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), rowCount));
                contentRow.append(materialPro.getDisplayName());
                contentRow.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"MalMakeOrderCorePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                contentRow.append('\n');
            }
            if (null == purchaseType) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"MalMakeOrderCorePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), rowCount));
                contentRow.append(purchaseTypePro.getDisplayName());
                contentRow.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"MalMakeOrderCorePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                contentRow.append('\n');
            }
            ++rowCount;
        }
        return contentRow.toString();
    }

    public int getLimitRows() {
        return 50;
    }
}

