/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MalMapOperationPlugin
extends AbstractBasePlugIn
implements MapSelectListener {
    public static final String KEY_MAP_ADDRESS = "mapaddress";
    public static final String KEY_SHOWMAP_ID = "pbd_map";
    public static final String KEY_MAP_CITY = "mapcity";
    public static final String KEY_NAME = "name";
    public static final String KEY_NUMBER = "number";
    public static final String BD_ADMINDIVISION = "bd_admindivision";
    public static final String KEY_MAP_CONTROLAP = "mapcontrolap";
    private static final String ADDRESS = "address";
    private static final String MAPADDRESS = "mapaddress";
    private static final String JDADDRESSNUM = "jdaddressnum";

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        this.setMapPoint(model);
    }

    private void setMapPoint(IDataModel model) {
        String[] latlng;
        String area;
        MapControl map = (MapControl)this.getView().getControl(KEY_MAP_CONTROLAP);
        MapSelectPointOption mapPoint = new MapSelectPointOption();
        String address = model.getValue("mapaddress").toString();
        mapPoint.setAddress(address);
        mapPoint.setTitle(address);
        Long addressNumber = this.getModelAddress(model);
        if (StringUtils.isBlank((Object)addressNumber) || addressNumber == 0L) {
            return;
        }
        String addressFullname = this.getAreaFullName(addressNumber);
        String[] names = addressFullname.split("_");
        if (names.length > 1) {
            mapPoint.setProvince(names[0]);
            mapPoint.setCity(names[1]);
        }
        if (null != (area = (String)model.getValue("area")) && null != (latlng = area.split("&")) && latlng.length == 2) {
            Double lng = Double.valueOf(latlng[0]);
            Double lat = Double.valueOf(latlng[1]);
            mapPoint.setLat(lat.doubleValue());
            mapPoint.setLng(lng.doubleValue());
            map.selectPoint(mapPoint);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        MapControl map = (MapControl)this.getView().getControl(KEY_MAP_CONTROLAP);
        Long addressNumber = this.getModelAddress(model);
        switch (property) {
            case "address": {
                this.getView().setVisible(Boolean.valueOf(this.isShowMap(addressNumber)), new String[]{KEY_MAP_CONTROLAP});
                if (null == addressNumber || addressNumber == 0L) {
                    return;
                }
                String address = this.getAreaFullName(addressNumber);
                if (StringUtils.isNotBlank((CharSequence)model.getValue("mapaddress").toString())) {
                    address = address + model.getValue("mapaddress");
                }
                map.selectAddress(address);
                break;
            }
            case "mapaddress": {
                String address = null != addressNumber ? this.getAreaFullName(addressNumber) : "";
                String mapaddress = address + model.getValue("mapaddress");
                map.selectAddress(mapaddress);
            }
        }
    }

    private Long getModelAddress(IDataModel model) {
        Long addressNumber = 0L;
        Object address = model.getValue(ADDRESS);
        if (address == null || StringUtils.isEmpty((CharSequence)String.valueOf(address))) {
            return addressNumber;
        }
        return Long.valueOf(String.valueOf(address));
    }

    public boolean isShowMap(Long addressNumber) {
        QFilter idFilter = new QFilter("id", "=", (Object)addressNumber);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject queryResult = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"level,country.number,country.twocountrycode", (QFilter[])filters);
        return queryResult != null && ("001".equals(queryResult.getString("country.number")) || "CN".equals(queryResult.getString("country.twocountrycode")));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mapaddress"});
        MapControl map = (MapControl)this.getView().getControl(KEY_MAP_CONTROLAP);
        map.addSelectListener((MapSelectListener)this);
    }

    public void select(MapSelectEvent evt) {
        this.setSelectData(evt);
    }

    private void setSelectData(MapSelectEvent evt) {
        Map map = evt.getPoint();
        IDataModel model = this.getView().getModel();
        BigDecimal latitude = (BigDecimal)map.get("latitude");
        BigDecimal longitude = (BigDecimal)map.get("longitude");
        if (null != latitude && null != longitude) {
            String area = longitude + "&" + latitude;
            model.setValue("area", (Object)area);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(KEY_MAP_CONTROLAP, "showSearchBox", (Object)Boolean.FALSE);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setClick(evt);
    }

    private void setClick(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equalsIgnoreCase("mapaddress")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(KEY_SHOWMAP_ID);
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u8be6\u7ec6\u5730\u5740", (String)"MalMapOperationPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SHOWMAP_ID));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.setReturnData(closedCallBackEvent);
    }

    private void setReturnData(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        String flocaleId = String.valueOf(RequestContext.get().getLang().getLocale());
        IDataModel iDataModel = this.getModel();
        if (KEY_SHOWMAP_ID.equals(closedCallBackEvent.getActionId()) && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null) {
            HashMap cityMap = (HashMap)returnData.get(KEY_MAP_CITY);
            HashMap addressMap = (HashMap)returnData.get("mapaddress");
            String city = String.valueOf(cityMap.get(flocaleId));
            String address = String.valueOf(addressMap.get(flocaleId));
            iDataModel.setValue("mapaddress", (Object)address);
        }
    }

    private String getAreaFullName(Long city) {
        QFilter idfilter = new QFilter("id", "=", (Object)city);
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,fullname,name", (QFilter[])new QFilter[]{idfilter});
        if (address == null) {
            return "";
        }
        String fullname = address.getString("fullname");
        return fullname;
    }

    public static final String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }
}

