/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Video;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsSortField;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.history.MalProBrowsingHistoryService;
import kd.scm.mal.business.model.comment.MalCommentEsSearchParam;
import kd.scm.mal.business.model.comment.MalCommentEsSearchResult;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.business.service.MalCommentEsSearchService;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalGoodsConverter;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSameKindGoods;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.model.recommend.RecommendRule;
import kd.scm.mal.domain.model.recommend.SearchParam;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalConverRuleService;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.domain.service.impl.MalLadderPriceRangeServiceImpl;
import kd.scm.mal.formplugin.util.MalAddToOftenBuyUtil;
import kd.scm.mal.formplugin.util.MalProductDetailUtil;
import kd.scm.malcore.domain.GoodsSameRule;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.util.MalConfigUtil;

public class MalNewProductDetailPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(MalNewProductDetailPlugin.class);
    private static final String ADD_PURCHASE = "add_purchase";
    private static final String SEARCHCONTAINER = "searchcontainer";
    private static final String ADD_OFTEN_BTN = "add_often_btn";
    private static final String ADD_CART_BTN = "add_cart_btn";
    private static final String QUERYHISTORYPRICE = "queryhistoryprice";
    private static final String COMPARE_NUM = "compare_num";
    private static final String VECTORAP21 = "vectorap21";
    private static final String ORIGIN_PUR = "pur";
    private static final String ORIGIN_SUP = "sup";
    private static final String ADDQTY = "addqty";
    private static final String HISTORYTRENDCONTAINER = "historytrendcontainer";
    private static final String SHOWHISTORYPRICE = "showHistoryPrice";
    private static final String COMPARE_DELETE = "compare_delete";
    private static final String COMPARE_FLOAT_FLEX = "compare_float_flex";
    private static final String MAL_PURCHASE = "mal_purchase";
    private static final String ADD_COMPARE_CONTAINER = "add_compare_container";
    private static final String RECOMMENDTAB = "recommendtab";
    private static final String ADD_OFTEN_CONTAINER = "add_often_container";
    private static final String MAL_NEWPRODUCTDETAIL = "mal_newproductdetail";
    private static final String HEADER_FLEX = "header_flex";
    private static final String CENTRALPURTYPE = "centralpurtype";
    private static final String STOCK = "stock";
    private static final String CACHE_SOURCE = "source";
    private static final String DETAIL_IMAGEAP = "imageap";
    private static final String DETAIL_IMAGEAP1 = "imageap1";
    private static final String DETAIL_IMAGEAP2 = "imageap2";
    private static final String DETAIL_IMAGEAP3 = "imageap3";
    private static final String DETAIL_IMAGEAP4 = "imageap4";
    private static final String DETAIL_IMAGEAP5 = "imageap5";
    private static final String DETAIL_NAME = "name";
    private static final String DETAIL_PRICE = "price";
    private static final String DETAIL_PRICE_T = "price_t";
    private static final String DETAIL_SUPPLIER = "supplier";
    private static final String DETAIL_PRODUCT_PK = "product_pk";
    private static final String DETAIL_UNIT = "unit";
    private static final String HTML_DETAIL = "html_detail";
    private static final String HTML_PARAM = "html_param";
    private static final String HTML_WARE = "html_ware";
    private static final String HTML_AFTERSALE = "html_aftersale";
    private static final String TAXRATE = "taxrate";
    private static final String MINORDERQTY = "minorderqty";
    private static final String DETAIL_AVAILABLEQTY = "availableqty";
    @Deprecated
    private static final String CACHE_PRODUCTID = "CACHE_PRODUCTID";
    private static final String CACHE_GOODSINFO = "CACHE_GOODSINFO";
    private static final String JUMP_PRODUCTSELFID = "productSelfId";
    private static final String DETAIL_ADD_CART_BTN = "add_cart_btn";
    private static final String MYCART_FLEX = "mycartflex";
    private static final String JUMP_ORIGIN = "origin";
    private static final String JUMP_PRODUCTJDSKU = "productJdSku";
    private static final String PROMISETIPS = "promisetips";
    private static final String NOREASONTORETURN_TEXT = "noreasontoreturn";
    private static final String SPLIT = "-";
    private static final String ATTR_FLEX = "attr_flex";
    private static final String SIMILAR_CONTAINER = "similar_container";
    private static final String SALENAME_LABEL = "salename_label";
    private static final String ATTRVALUE_FLEX = "attrvalue_flex";
    private static final String DOT = ",";
    private static final String ATTR_VALUE_LABEL_KEYS = "attr_value_label_keys";
    private static final String PREFIX_ATTR = "attr_";
    private static final String CURRENCY = "currency";
    private static final String ADMINDIVISIONFIELD = "admindivisionfield";
    private static final String PRICEDOWN = "pricedown";
    private static final String CHECKMINORDERQTY = "checkminorderqty";
    private static final String CACHE_MALGOODS_ID = "cache_malgoods_id";
    private static final String LADPRICE = "ladprice";
    private static final String LEADTIME = "leadtime";
    private static final String NUMBER = "number";
    private static final String ADD_2_OFTENBUY = "add2oftenbuy";
    private static final String ADDQTY_LABEL = "instocklable1";
    private static final String LADDERPRICE_DETAIL = "ladderprice_detail";
    private static final String QTY_FLEX = "flexpanelap91";
    private static final String TAB_SELECT = "tab_select";
    private static final String TAB_COMMENT = "tabcomment";
    private static final String TAB_SAMECLASS = "tabsameclassgoods";
    private static final String TAB_SAMEKINDGOODS = "samekindgoods_tab";
    private static final String FLEX_RECOMMEND = "flex_recommend";
    private static final String BTN_EC_SYNC = "btn_ec_sync";
    private static final String ASYNC_EC_AYNC = "async_ec_sync";
    private static final String MAL_ECSEARCH_V1 = "mal_ecsearch_v1";
    private static final String FLEX_SHOPPRICE = "flex_shopprice";
    private static final String FLEX_SALES = "flexpanelap722";
    private static final String CACHE_PRODUCTNUMBER = "CACHE_PRODUCTNUMBER";
    private static final String PARAM_PRODUCTNUMBER = "param_productnumber";
    private static final String PARAM_PRODUCTID = "param_productid";
    private static final String PARAM_PRODUCTSOURCE = "productsource";
    private static final String COMPAREINFO_FLEX = "compareinfo_flex";

    public void afterCreateNewData(EventObject e) {
        String sku;
        super.afterCreateNewData(e);
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)defaultCurrency)) {
            this.getModel().setValue(CURRENCY, (Object)defaultCurrency);
        }
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        String source = Parser.toString(customParams.get(PARAM_PRODUCTSOURCE));
        this.getPageCache().put(CACHE_SOURCE, source);
        String goodsIdStr = (String)customParams.get(JUMP_PRODUCTSELFID);
        if (StringUtils.isBlank((CharSequence)goodsIdStr)) {
            goodsIdStr = (String)customParams.get(PARAM_PRODUCTID);
        }
        if (StringUtils.isNotBlank((CharSequence)goodsIdStr)) {
            this.getPageCache().put(CACHE_MALGOODS_ID, goodsIdStr);
        }
        if (StringUtils.isBlank((CharSequence)(sku = (String)customParams.get(JUMP_PRODUCTJDSKU)))) {
            sku = (String)customParams.get(PARAM_PRODUCTNUMBER);
        }
        if (StringUtils.isNotBlank((CharSequence)sku)) {
            this.getPageCache().put(CACHE_PRODUCTNUMBER, sku);
        }
        this.initView();
        this.sendAction("loadSimilarGoods");
    }

    private void initView() {
        MalGoods malGoods;
        Long header_org_id = (Long)this.getModel().getValue("header_org_id");
        MalReceipt defaultReceipt = ((MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class)).getDefaultReceiptByOrg(header_org_id);
        String addressId = "";
        if (0L != defaultReceipt.getReceiptId()) {
            addressId = defaultReceipt.getAdmindivisionId();
            this.getView().getModel().setValue(ADMINDIVISIONFIELD, (Object)addressId);
        }
        if ((malGoods = this.getMalGoods()) == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)addressId) && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u5e76\u7ef4\u62a4\u5b8c\u6574\uff0c\u518d\u91cd\u65b0\u8fdb\u5165\u6b64\u9875\u9762\u3002", (String)"MalNewProductDetailPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        malGoods.setShippingAddress(addressId);
        if ((ShowType.NewWindow == this.getView().getFormShowParameter().getOpenStyle().getShowType() || ShowType.InContainer == this.getView().getFormShowParameter().getOpenStyle().getShowType() || ShowType.Default == this.getView().getFormShowParameter().getOpenStyle().getShowType()) && StringUtils.isNotEmpty((CharSequence)malGoods.getProductName())) {
            this.getView().executeClientCommand("setCaption", new Object[]{malGoods.getProductName()});
        }
        this.fillMainField(malGoods);
        this.getPageCache().put(CACHE_GOODSINFO, JSON.toJSONString((Object)MalGoodsConverter.convert2GoodsInfo((MalGoods)malGoods)));
        this.getPageCache().put(CACHE_PRODUCTID, malGoods.getProductId());
        this.getPageCache().put(CACHE_SOURCE, malGoods.getProductSource());
        this.getPageCache().put(CACHE_PRODUCTNUMBER, malGoods.getProductNumber());
        this.getPageCache().remove(TAB_SELECT);
        this.sendAction("loadGoodsOtherInfo");
        this.sendAction("loadLadderPrice");
        this.sendAction("loadGoodsDetail");
        this.sendAction("loadGoodsComment");
        this.sendAction("loadRecommendedGoods");
        this.sendAction("recordBrowsingHistory");
        this.sendAction("loadPurchasePackageDetail");
    }

    private void fillMainField(MalGoods malGoods) {
        Label noReasonToReturnCnlt;
        this.setImages(malGoods);
        this.setVideo(malGoods);
        this.getView().getPageCache().put("pk", malGoods.getProductNumber());
        this.getView().getModel().setValue(DETAIL_PRODUCT_PK, (Object)malGoods.getProductNumber());
        Label name = (Label)this.getView().getControl(DETAIL_NAME);
        if (null != name) {
            name.setText(malGoods.getProductName() + "\t" + malGoods.getProductModel());
        }
        this.getView().getModel().setValue(DETAIL_PRICE, (Object)malGoods.getTaxPrice());
        this.getView().getModel().setValue(DETAIL_PRICE_T, (Object)malGoods.getTaxPrice());
        Label priceDown = (Label)this.getView().getControl(PRICEDOWN);
        if (null != priceDown) {
            priceDown.setText(MainPageUtils.isPriceDown((String)malGoods.getProductId()) ? ResManager.loadKDString((String)"\u964d\u4ef7", (String)"MalNewProductDetailPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]) : "");
        }
        this.getModel().setValue("shopprice", (Object)malGoods.getShopPrice());
        this.getView().setVisible(Boolean.TRUE, new String[]{DETAIL_PRICE});
        this.getModel().setValue(MINORDERQTY, (Object)(malGoods.getMinOrderQty() == null ? BigDecimal.ZERO : malGoods.getMinOrderQty()));
        this.getModel().setValue(TAXRATE, (Object)malGoods.getTaxRate());
        this.getModel().setValue("sales_desc", (Object)malGoods.getSalesDesc());
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) {
            this.fillSelfStock(malGoods.getStockDesc());
        } else {
            Label stock = (Label)this.getView().getControl(STOCK);
            stock.setText(malGoods.getStockDesc());
            this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_AVAILABLEQTY, "noinventorycontainer", "noinventorytext"});
        }
        Html promisetips = (Html)this.getView().getControl(PROMISETIPS);
        if (null != promisetips) {
            String promiseTips = malGoods.getPromiseTips() == null ? "" : malGoods.getPromiseTips();
            promisetips.setConent("<div>" + malGoods.getTipsContent() + promiseTips + "</div>");
        }
        if (null != (noReasonToReturnCnlt = (Label)this.getView().getControl(NOREASONTORETURN_TEXT))) {
            noReasonToReturnCnlt.setText(malGoods.getNoReasonToReturnText());
            if (StringUtils.isBlank((CharSequence)malGoods.getNoReasonToReturnText())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap3"});
            }
        }
        this.getModel().setValue(ADDQTY, (Object)(malGoods.getMinOrderQty() == null || malGoods.getMinOrderQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : malGoods.getMinOrderQty()));
        this.getView().getModel().setValue(DETAIL_UNIT, (Object)malGoods.getProductUnitID());
    }

    private void setVideo(MalGoods malGoods) {
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            Object autoplay = this.getModel().getValue("autoplay");
            List attachments = AttachmentServiceHelper.getAttachments((String)"pmm_prodmanage", (Object)Long.parseLong(malGoods.getProductId()), (String)"videoattachment");
            if (attachments.size() > 0) {
                if (malGoods.getGoodsInfo().getVideoLocation()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"beforevideobtn"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{DETAIL_IMAGEAP});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"videoap"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"aftervideobtn"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"videoap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_IMAGEAP});
                    Video videoCtl = (Video)this.getView().getControl("videoap");
                    videoCtl.setSrc(String.valueOf(((Map)attachments.get(0)).get("url")));
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("autoPlay", Boolean.parseBoolean(String.valueOf(autoplay)));
                    dataMap.put("k", "videoap");
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("u", dataMap);
                }
                this.getPageCache().put("videosrc", String.valueOf(((Map)attachments.get(0)).get("url")));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"beforevideobtn", "aftervideobtn", "videoap"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"beforevideobtn", "aftervideobtn", "videoap"});
        }
    }

    private void loadLadderPrice(MalGoods malGoods) {
        this.getView().getModel().setValue(LADPRICE, (Object)malGoods.getTaxPrice());
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param) && this.getIsExistLadprice()) {
            this.setLadderPriceRangeContent(malGoods, CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY)));
        }
    }

    private void loadGoodsOtherInfo(MalGoods malGoods) {
        this.getModel().setValue(NUMBER, (Object)malGoods.getNumber());
        this.getModel().setValue("materialnumber", (Object)malGoods.getMaterialId());
        this.getModel().setValue("materialname", (Object)malGoods.getMaterialId());
        this.getModel().setValue("categoryname", (Object)malGoods.getCategoryName());
        this.getModel().setValue("centralpurtype_field", (Object)malGoods.getCentralpurtype());
        Label supplier = (Label)this.getView().getControl(DETAIL_SUPPLIER);
        supplier.setText(malGoods.getSupplierName());
        Label centralpurtype = (Label)this.getView().getControl(CENTRALPURTYPE);
        if (null != centralpurtype && null != malGoods.getCentralpurtype()) {
            centralpurtype.setText("1".equals(malGoods.getCentralpurtype()) ? ResManager.loadKDString((String)"\u7b7e\u7ea6\u5546\u54c1", (String)"MalNewProductDetailPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]) : "");
        }
        this.getModel().setValue("protocolbillno", (Object)malGoods.getProtocolBillno());
        this.getModel().setValue("supplierphone", (Object)malGoods.getSupplierPhone());
        this.getModel().setValue(LEADTIME, (Object)malGoods.getLeadtime());
        this.fillBarcode(malGoods);
    }

    private void loadPurchasePackageDetail(MalGoods malGoods) {
        long goodid = malGoods.getId();
        QFilter fiter = new QFilter("entryentity.goods.id", "=", (Object)goodid);
        QFilter isprimaryFiter = new QFilter("entryentity.isprimary", "=", (Object)Character.valueOf('1'));
        QFilter orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_packageselection", (Long)RequestContext.get().getOrgId());
        fiter.and(new QFilter("enable", "=", (Object)"1"));
        fiter.and(new QFilter("status", "=", (Object)"C"));
        fiter.and(new QFilter("type", "=", (Object)"3"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pmm_packageselection", (String)"id,name", (QFilter[])new QFilter[]{orgfilter, fiter, isprimaryFiter}, (String)"createtime desc");
        int colSize = col.size();
        if (colSize == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_pacage"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_pacage"});
        int size = 7;
        for (int i = 1; i < size; ++i) {
            TabPage tab = (TabPage)this.getControl("tab_pakage_page" + i);
            if (colSize >= i) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tab_pakage_page" + i});
                DynamicObject pakageInfo = (DynamicObject)col.get(i - 1);
                LocaleString name = new LocaleString(pakageInfo.getString(DETAIL_NAME));
                tab.setText(name);
                this.getView().getPageCache().put("tab_pakage_page" + i, pakageInfo.get("id").toString());
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tab_pakage_page" + i});
        }
        if (colSize > 0) {
            this.showPurchasePackageDetail(((DynamicObject)col.get(0)).getLong("id"), "tab_pakage_page1");
        }
    }

    private void showPurchasePackageDetail(Long pakageId, String tabneme) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_package");
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pacageid", pakageId);
        paramMap.put("addressid", String.valueOf(this.getModel().getValue(ADMINDIVISIONFIELD)));
        paramMap.put("orgid", this.getOrgId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(tabneme);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tabpurchasepackagedetail"));
        showParameter.setCustomParams(paramMap);
        this.getView().showForm(showParameter);
    }

    private void loadGoodsDetail(MalGoods malGoods) {
        Html aftersale;
        String guarantee;
        Html ware;
        String packinglist;
        Html htmlParam;
        Html detailInHtml = (Html)this.getView().getControl(HTML_DETAIL);
        if (null != detailInHtml) {
            detailInHtml.setConent(malGoods.getProductDetail());
        }
        if (null != (htmlParam = (Html)this.getView().getControl(HTML_PARAM))) {
            htmlParam.setConent(malGoods.getSpecification());
        }
        String string = packinglist = malGoods.getPackinglist() == null ? "" : malGoods.getPackinglist();
        if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(malGoods.getProductSource())) {
            packinglist = packinglist.replaceAll("<", "&#60");
        }
        if (null != (ware = (Html)this.getView().getControl(HTML_WARE))) {
            ware.setConent(packinglist);
        }
        this.getView().getModel().setValue("packinglist", (Object)packinglist);
        String string2 = guarantee = malGoods.getGuarantee() == null ? "" : malGoods.getGuarantee();
        if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(malGoods.getProductSource())) {
            guarantee = guarantee.replaceAll("<", "&#60");
        }
        if (null != (aftersale = (Html)this.getView().getControl(HTML_AFTERSALE))) {
            aftersale.setConent(guarantee);
        }
        this.getView().getModel().setValue("guarantee", (Object)guarantee);
    }

    private void loadSimilarGoods(MalGoods malGoods) {
        this.fillSimilarGoods(malGoods.getMalSimilarGoodsList());
    }

    private void loadGoodsComment() {
        MalCommentEsSearchResult result = this.doCommentSearch(this.getDefaultCommentEsFilterFields());
        this.setCommentNum(result);
    }

    private void loadRecommendedGoods() {
        this.jumpRecommendedGoods();
    }

    private void recordBrowsingHistory(MalGoods malGoods) {
        MalProBrowsingHistoryService malProBrowsingHistoryService = (MalProBrowsingHistoryService)DomainServiceFactory.serviceOf(MalProBrowsingHistoryService.class);
        malProBrowsingHistoryService.addProductToBrowsingHistory(malGoods);
    }

    private void sendAction(String name) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put(DETAIL_NAME, name);
        param.put("duration", 0);
        param.put("async", Boolean.TRUE);
        proxy.addAction("addClientCallBack", param);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (Objects.nonNull(e) && !StringUtils.isEmpty((CharSequence)e.getName())) {
            MalGoods malGoods = this.getMalGoods();
            switch (e.getName()) {
                case "loadGoodsOtherInfo": {
                    this.loadGoodsOtherInfo(malGoods);
                    break;
                }
                case "loadLadderPrice": {
                    this.loadLadderPrice(malGoods);
                    break;
                }
                case "loadGoodsDetail": {
                    this.loadGoodsDetail(malGoods);
                    break;
                }
                case "loadSimilarGoods": {
                    this.loadSimilarGoods(malGoods);
                    break;
                }
                case "loadGoodsComment": {
                    this.loadGoodsComment();
                    break;
                }
                case "loadRecommendedGoods": {
                    this.loadRecommendedGoods();
                    break;
                }
                case "recordBrowsingHistory": {
                    this.recordBrowsingHistory(malGoods);
                    break;
                }
                case "loadPurchasePackageDetail": {
                    this.loadPurchasePackageDetail(malGoods);
                    break;
                }
            }
        }
    }

    private void setCommentNum(MalCommentEsSearchResult result) {
        int num = (int)result.getTotals();
        String numString = this.getQtyText(num);
        HashMap map = new HashMap();
        HashMap<String, String> map1 = new HashMap<String, String>();
        String title = ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\uff08{0}\uff09", (String)"MalNewProductDetailPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[]{numString});
        map.put("text", map1);
        map1.put(RequestContext.get().getLang().name(), title);
        this.getView().updateControlMetadata(TAB_COMMENT, map);
    }

    private String getQtyText(int qty) {
        String numString = String.valueOf(qty);
        if (qty > 1000) {
            numString = "1000+";
        }
        return numString;
    }

    private List<EsFilterField> getDefaultCommentEsFilterFields() {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        EsFilterField esFilterField = new EsFilterField("goodsid", "=", new Object[]{this.getGoodsId()});
        esFilterField.and(new EsFilterField("billstatus", "=", new Object[]{"C"}));
        esFilterFields.add(esFilterField);
        return esFilterFields;
    }

    private MalGoods getMalGoods() {
        Long goodsId = this.getGoodsId();
        MalGoods malGoods = MalGoods.getFromCache((String)this.getView().getPageId(), (Long)goodsId);
        if (malGoods != null) {
            return malGoods;
        }
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY));
        String sku = this.getPageCache().get(CACHE_PRODUCTNUMBER);
        String source = this.getPageCache().get(CACHE_SOURCE);
        if (StringUtils.isBlank((CharSequence)source)) {
            source = EcPlatformEnum.ECPLATFORM_SELF.getVal();
        }
        malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)sku, (String)source, (BigDecimal)qty, (String)String.valueOf(this.getModel().getValue(ADMINDIVISIONFIELD)), (Long)this.getOrgId()), (boolean)true, (boolean)true);
        MalGoods.cache((String)this.getView().getPageId(), (Long)goodsId, (MalGoods)malGoods);
        return malGoods;
    }

    private MalGoods getNoDeatialMalGoods() {
        Long goodsId = this.getGoodsId();
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY));
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        String source = Parser.toString(customParams.get(PARAM_PRODUCTSOURCE));
        if (StringUtils.isBlank((CharSequence)source)) {
            source = EcPlatformEnum.ECPLATFORM_SELF.getVal();
        }
        String sku = (String)customParams.get(JUMP_PRODUCTJDSKU);
        return MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)sku, (String)source, (BigDecimal)qty, (String)String.valueOf(this.getModel().getValue(ADMINDIVISIONFIELD)), (Long)this.getOrgId()), (boolean)false, (boolean)false);
    }

    private Long getGoodsId() {
        String cacheMalgoodsId = this.getPageCache().get(CACHE_MALGOODS_ID);
        if (StringUtils.isNotBlank((CharSequence)cacheMalgoodsId)) {
            return Long.valueOf(cacheMalgoodsId);
        }
        String sku = this.getPageCache().get(CACHE_PRODUCTNUMBER);
        String source = this.getPageCache().get(CACHE_SOURCE);
        if (StringUtils.isNotBlank((CharSequence)sku)) {
            return this.getGoodsIdByNumber(source, sku);
        }
        return 0L;
    }

    private Long getGoodsIdByNumber(String source, String number) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        qFilter.and(new QFilter(CACHE_SOURCE, "=", (Object)source));
        DynamicObject ecGoods = QueryServiceHelper.queryOne((String)"pbd_mallgoods", (String)"id", (QFilter[])qFilter.toArray());
        if (ecGoods != null) {
            this.getPageCache().put(CACHE_MALGOODS_ID, ecGoods.getString("id"));
            return ecGoods.getLong("id");
        }
        return 0L;
    }

    public void pageRelease(EventObject e) {
        MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String attrValueLabelKeys = this.getPageCache().get(ATTR_VALUE_LABEL_KEYS);
        if (StringUtils.isNotEmpty((CharSequence)attrValueLabelKeys)) {
            for (String attrValueLabelKey : attrValueLabelKeys.split(DOT)) {
                if (!StringUtils.equals((CharSequence)attrValueLabelKey, (CharSequence)e.getKey())) continue;
                Label label = new Label();
                label.setView(this.getView());
                label.setKey(e.getKey());
                label.addClickListener((ClickListener)this);
                e.setControl((Control)label);
                return;
            }
        }
    }

    private void fillSimilarGoods(List<MalSimilarGoods> malSimilarGoodsList) {
        if (Objects.isNull(malSimilarGoodsList)) {
            return;
        }
        Container container = (Container)this.getControl(SIMILAR_CONTAINER);
        ArrayList<Map> controls = new ArrayList<Map>(malSimilarGoodsList.size());
        Map<String, String> keyConvertMap = this.keyConvert(malSimilarGoodsList);
        ArrayList<String> attrFlexKeys = new ArrayList<String>(malSimilarGoodsList.size());
        String attrValueLabelKeysInCache = this.getPageCache().get(ATTR_VALUE_LABEL_KEYS);
        StringBuilder attrValueLabelKeys = new StringBuilder(attrValueLabelKeysInCache == null ? "" : attrValueLabelKeysInCache);
        for (MalSimilarGoods skuGoodsInfo : malSimilarGoodsList) {
            FlexPanelAp attrFlex = this.createAttrFlex(skuGoodsInfo, keyConvertMap, attrValueLabelKeys);
            attrFlexKeys.add(attrFlex.getKey());
            controls.add(attrFlex.createControl());
        }
        this.getView().getPageCache().put(ATTR_VALUE_LABEL_KEYS, attrValueLabelKeys.toString());
        container.deleteControls(attrFlexKeys.toArray(new String[0]));
        container.addControls(controls);
        this.getView().updateView(SIMILAR_CONTAINER);
    }

    private FlexPanelAp createAttrFlex(MalSimilarGoods malSimilarGoods, Map<String, String> keyConvertMap, StringBuilder attrValueLabelKeys) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId("attr_flex-" + malSimilarGoods.getDim());
        res.setKey("attr_flex-" + malSimilarGoods.getDim());
        res.setGrow(0);
        res.setShrink(0);
        res.setJustifyContent("flex-start");
        res.setWidth(new LocaleString("100%"));
        res.setWrap(false);
        LabelAp saleNameLabel = this.createSaleNameLabel(malSimilarGoods);
        MalGoods malGoods = this.getMalGoods();
        Set<Long> saleGoodsIds = this.getSalesGoods(malSimilarGoods, malGoods);
        FlexPanelAp attrvalueFlex = this.createAttrValueFlex(malSimilarGoods, keyConvertMap, attrValueLabelKeys, saleGoodsIds, malGoods);
        res.getItems().add(saleNameLabel);
        res.getItems().add(attrvalueFlex);
        return res;
    }

    private FlexPanelAp createAttrValueFlex(MalSimilarGoods malSimilarGoods, Map<String, String> keyConvertMap, StringBuilder attrValueLabelKeys, Set<Long> salesGoods, MalGoods malGoods) {
        FlexPanelAp res = new FlexPanelAp();
        res.setKey("attrvalue_flex-" + malSimilarGoods.getDim());
        res.setId("attrvalue_flex-" + malSimilarGoods.getDim());
        res.setAlignContent("center");
        res.setAlignItems("center");
        res.setIndex(1);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("10px");
        style.setMargin(margin);
        res.setStyle(style);
        List<LabelAp> attrValueLables = this.createAttrValueLabels(malSimilarGoods, keyConvertMap, attrValueLabelKeys, salesGoods, malGoods);
        for (LabelAp attrValueLabel : attrValueLables) {
            res.getItems().add(attrValueLabel);
        }
        return res;
    }

    private List<LabelAp> createAttrValueLabels(MalSimilarGoods malSimilarGoods, Map<String, String> keyConvertMap, StringBuilder attrValueLabelKeys, Set<Long> saleGoodsIds, MalGoods malGoods) {
        ArrayList<LabelAp> res = new ArrayList<LabelAp>(keyConvertMap.size());
        for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
            LabelAp attrValueLabel = new LabelAp();
            attrValueLabel.setKey("attrvalue-" + malSimilarGoods.getDim() + SPLIT + keyConvertMap.get(malSaleAttr.getSaleValue()));
            attrValueLabel.setId(attrValueLabel.getKey());
            if (attrValueLabelKeys.indexOf(attrValueLabel.getKey()) < 0) {
                attrValueLabelKeys.append(attrValueLabel.getKey()).append(DOT);
            }
            attrValueLabel.setClickable(true);
            attrValueLabel.setLabelStyle("1");
            attrValueLabel.setRadius("2px");
            attrValueLabel.setHeight(new LocaleString("32px"));
            attrValueLabel.setTextAlign("center");
            attrValueLabel.setName(new LocaleString(malSaleAttr.getSaleValue()));
            Style style = new Style();
            Border border = new Border();
            if (malSaleAttr.isSelected()) {
                border.setRight("1px_solid_themeColor");
                border.setLeft("1px_solid_themeColor");
                border.setBottom("1px_solid_themeColor");
                border.setTop("1px_solid_themeColor");
                attrValueLabel.setForeColor("themeColor");
            } else {
                String similarSku;
                border.setRight("1px_solid_rgba(187,187,187,1)");
                border.setLeft("1px_solid_rgba(187,187,187,1)");
                border.setBottom("1px_solid_rgba(187,187,187,1)");
                border.setTop("1px_solid_rgba(187,187,187,1)");
                attrValueLabel.setForeColor("#666666");
                boolean goodsSoldOut = false;
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                    for (Object skuId : malSaleAttr.getSkuIds()) {
                        if (!saleGoodsIds.contains(skuId)) continue;
                        goodsSoldOut = true;
                        break;
                    }
                } else {
                    goodsSoldOut = true;
                }
                if (StringUtils.isBlank((CharSequence)(similarSku = malGoods.getSimilarSku(malSimilarGoods.getDim().intValue(), malSaleAttr.getSaleValue()))) || !goodsSoldOut) {
                    attrValueLabel.setLock("new,edit,view");
                    attrValueLabel.setForeColor("#d9d9d9");
                    border.setRight("1px_solid_#d9d9d9");
                    border.setLeft("1px_solid_#d9d9d9");
                    border.setBottom("1px_solid_#d9d9d9");
                    border.setTop("1px_solid_#d9d9d9");
                }
            }
            style.setBorder(border);
            Padding padding = new Padding();
            padding.setTop("6px");
            padding.setLeft("20px");
            padding.setBottom("6px");
            padding.setRight("20px");
            style.setPadding(padding);
            Margin margin = new Margin();
            margin.setTop("10px");
            margin.setLeft("10px");
            style.setMargin(margin);
            attrValueLabel.setStyle(style);
            res.add(attrValueLabel);
        }
        return res;
    }

    private Set<Long> getSalesGoods(MalSimilarGoods malSimilarGoods, MalGoods malGoods) {
        HashSet<Long> saleGoodsIds = new HashSet<Long>();
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            ArrayList<Long> goodsIds = new ArrayList<Long>();
            for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                for (Object skuId : malSaleAttr.getSkuIds()) {
                    goodsIds.add((Long)skuId);
                }
            }
            Long header_org_id = (Long)this.getModel().getValue("header_org_id");
            QFilter qFilter = new QFilter("goods", "in", goodsIds);
            DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods,mallstatus,salestatus,entryentity.orgname.id", (QFilter[])qFilter.toArray());
            for (DynamicObject prodPool : prodPools) {
                if (!MallStatusEnum.SOLD.getVal().equals(prodPool.get("mallstatus")) || !"A".equals(prodPool.getString("salestatus")) && (!"C".equals(prodPool.getString("salestatus")) || !header_org_id.equals(prodPool.getLong("entryentity.orgname.id")))) continue;
                saleGoodsIds.add(prodPool.getLong("goods"));
            }
        }
        return saleGoodsIds;
    }

    private Map<String, String> keyConvert(List<MalSimilarGoods> malSimilarGoodsList) {
        HashMap<String, String> res = new HashMap<String, String>(16);
        HashMap<String, String> reverseMap = new HashMap<String, String>(16);
        int keyUsed = 1;
        for (MalSimilarGoods malSimilarGoods : malSimilarGoodsList) {
            for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                res.put(malSaleAttr.getSaleValue(), PREFIX_ATTR + keyUsed);
                reverseMap.put(PREFIX_ATTR + keyUsed, malSaleAttr.getSaleValue());
                ++keyUsed;
            }
        }
        this.getPageCache().put(reverseMap);
        return res;
    }

    private String keyReverse(String input) {
        return this.getPageCache().get(input);
    }

    private LabelAp createSaleNameLabel(MalSimilarGoods malSimilarGoods) {
        LabelAp res = new LabelAp();
        res.setLabelStyle("1");
        res.setId("salename_label-" + malSimilarGoods.getDim());
        res.setKey("salename_label-" + malSimilarGoods.getDim());
        res.setAlignSelf("center");
        res.setForeColor("#666666");
        res.setAutoTextWrap(true);
        res.setWidth(new LocaleString("72px"));
        res.setName(new LocaleString(malSimilarGoods.getSaleName()));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("10px");
        margin.setTop("10px");
        style.setMargin(margin);
        res.setStyle(style);
        return res;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        if (RECOMMENDTAB.equals(tabSelectEvent.getTabKey())) {
            this.jumpRecommendedGoods();
        }
        if (TAB_COMMENT.equals(tabSelectEvent.getTabKey())) {
            if (!TAB_COMMENT.equals(this.getPageCache().get(TAB_SELECT))) {
                this.commentView();
                this.getPageCache().put(TAB_SELECT, TAB_COMMENT);
            }
        } else {
            this.getPageCache().remove(TAB_SELECT);
        }
        if (TAB_SAMECLASS.equals(tabSelectEvent.getTabKey())) {
            this.sameClassGoodsView();
        } else if (TAB_SAMEKINDGOODS.equals(tabSelectEvent.getTabKey())) {
            this.sameKindGoodsView();
        }
        if (tabSelectEvent.getTabKey().contains("tab_pakage_page")) {
            Long pakageId = Long.parseLong(this.getPageCache().get(tabSelectEvent.getTabKey()));
            this.showPurchasePackageDetail(pakageId, tabSelectEvent.getTabKey());
        }
    }

    private void showSameGoods() {
        MalGoods malGoods = this.getMalGoods();
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"MalPriceMonitorDetailPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0])));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long goodsId = malGoods.getId();
        String source = this.getPageCache().get(CACHE_SOURCE);
        Long purchase_org = this.getOrgId();
        GoodsSameRule goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
        if (null != goodsSameRule.getEsFilterFields() && goodsSameRule.getEsFilterFields().size() != 0) {
            List<Map<String, Object>> resultData = this.getMinSameGoodsData(goodsSameRule, goodsId, source);
            if (null != resultData && resultData.size() > 1) {
                List<Map<String, Object>> maxResultData = this.getMaxSameGoodsData(goodsSameRule, goodsId, source);
                BigDecimal lowPrice = BigDecimal.ZERO;
                if (null != resultData.get(0).get(DETAIL_PRICE)) {
                    lowPrice = new BigDecimal(String.valueOf(resultData.get(0).get(DETAIL_PRICE)));
                }
                BigDecimal hightPrice = BigDecimal.ZERO;
                if (null != maxResultData.get(0).get(DETAIL_PRICE)) {
                    hightPrice = new BigDecimal(String.valueOf(maxResultData.get(0).get(DETAIL_PRICE)));
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("mal_samegoods");
                HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
                MalSearchParam malSearchParam = new MalSearchParam();
                malSearchParam.setSort(goodsSameRule.getSort());
                malSearchParam.setCustomEsFilterFields(goodsSameRule.getEsFilterFields());
                malSearchParam.setPageSize(3);
                searchParamMap.put("param_search", SerializationUtils.toJsonString((Object)malSearchParam));
                searchParamMap.put("firstgoodsid", goodsId);
                searchParamMap.put("sourceForm", customParams.get("sourceForm"));
                searchParamMap.put("purchase_org", ((Object)purchase_org).toString());
                if (lowPrice.compareTo(hightPrice) != 0) {
                    searchParamMap.put("maxprice", String.valueOf(hightPrice));
                    searchParamMap.put("minprice", String.valueOf(lowPrice));
                }
                showParameter.getOpenStyle().setTargetKey("samekindgoods_container");
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "samegoods"));
                showParameter.setCustomParams(searchParamMap);
                this.getView().showForm(showParameter);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
                this.getView().hideLoading();
            }
        }
    }

    private List<Map<String, Object>> getMinSameGoodsData(GoodsSameRule goodsSameRule, Object goodsId, Object source) {
        if (null == goodsSameRule) {
            goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
            if (null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
                // empty if block
            }
            return null;
        }
        MalSearchParam res = new MalSearchParam();
        res.setPageNum(0);
        res.setPageSize(10);
        res.setSort("price_true");
        res.getCustomEsFilterFields().addAll(goodsSameRule.getEsFilterFields());
        MalSearchService malSearchService = (MalSearchService)MalBusinessFactory.serviceOf(MalSearchService.class);
        MalSearchResult search = malSearchService.search(res, null);
        return search.getResultData();
    }

    private List<Map<String, Object>> getMaxSameGoodsData(GoodsSameRule goodsSameRule, Object goodsId, Object source) {
        if (null == goodsSameRule) {
            goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
            if (null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
                // empty if block
            }
            return null;
        }
        MalSearchParam res = new MalSearchParam();
        res.setPageNum(0);
        res.setPageSize(10);
        res.setSort("price_false");
        res.getCustomEsFilterFields().addAll(goodsSameRule.getEsFilterFields());
        MalSearchService malSearchService = (MalSearchService)MalBusinessFactory.serviceOf(MalSearchService.class);
        MalSearchResult search = malSearchService.search(res, null);
        return search.getResultData();
    }

    private void sameKindGoodsView() {
        MalGoods malGoods = this.getMalGoods();
        List malSameKindGoods = malGoods.getMalSameKindGoods();
        if (malSameKindGoods == null || malSameKindGoods.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap152"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"emptycontainer"});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_samegoodsdetail");
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        searchParamMap.put("malSameKindGoods", SerializationUtils.toJsonString((Object)malSameKindGoods));
        searchParamMap.put("addressid", String.valueOf(this.getModel().getValue(ADMINDIVISIONFIELD)));
        searchParamMap.put("orgid", this.getOrgId());
        searchParamMap.put("goodsprice", malGoods.getTaxPrice());
        searchParamMap.put("maingoodsid", malGoods.getId());
        searchParamMap.put("mainsource", malGoods.getPlatform());
        searchParamMap.put(JUMP_ORIGIN, this.getView().getFormShowParameter().getCustomParams().get(JUMP_ORIGIN));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("samekindgoods_container");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tabsameKindclassgoods"));
        showParameter.setCustomParams(searchParamMap);
        this.getView().showForm(showParameter);
    }

    private void sameClassGoodsView() {
        MalGoods malGoods = this.getMalGoods();
        List malSimilarGoodsList = malGoods.getAllSelfSimilarGoodsList();
        HashSet<Long> goodsIds = new HashSet<Long>(1024);
        HashSet<String> goodsNumbers = new HashSet<String>(1024);
        for (MalSimilarGoods mal : malSimilarGoodsList) {
            List malSaleAttrs = mal.getMalSaleAttrs();
            for (MalSaleAttr attr : malSaleAttrs) {
                for (Object id : attr.getSkuIds()) {
                    if (id instanceof Long) {
                        goodsIds.add(Long.parseLong(String.valueOf(id)));
                        continue;
                    }
                    goodsNumbers.add(String.valueOf(id));
                }
            }
        }
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(1024);
        EsFilterField esFilterField = new EsFilterField("goodsid", "in", goodsIds.toArray());
        esFilterField.or(new EsFilterField(NUMBER, "in", goodsNumbers.toArray()));
        esFilterFields.add(esFilterField);
        FormShowParameter showParameter = new FormShowParameter();
        if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getCustomParams().get(JUMP_ORIGIN))) {
            showParameter.setFormId("mal_sameclasspickgoods");
        } else {
            showParameter.setFormId("mal_sameclassgoods");
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        HashMap<String, String> searchParamMap = new HashMap<String, String>();
        searchParamMap.put("esfilter", SerializationUtils.toJsonString(esFilterFields));
        searchParamMap.put("attrs", SerializationUtils.toJsonString((Object)malSimilarGoodsList));
        searchParamMap.put("firstgoodsid", malGoods.getProductId());
        searchParamMap.put("purchase_org", (String)this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("sameclastab_container");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAB_SAMECLASS));
        showParameter.setCustomParams(searchParamMap);
        this.getView().showForm(showParameter);
    }

    private void jumpRecommendedGoods() {
        MalGoods malGoods = this.getMalGoods();
        if (!malGoods.isSimilar()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_RECOMMEND});
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SAMECLASS});
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setShowTitle(false);
        fsp.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalRecommendedGoodsKey());
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recommended"));
        fsp.getOpenStyle().setTargetKey("flexpanelap_recommend");
        RecommendRule recommendRule = new RecommendRule();
        recommendRule.setMalGoods(malGoods);
        ArrayList<RecommendRule> recommendRuleList = new ArrayList<RecommendRule>();
        recommendRuleList.add(recommendRule);
        MalConverRuleService malConverRuleService = (MalConverRuleService)DomainServiceFactory.serviceOf(MalConverRuleService.class);
        SearchParam searchParam = malConverRuleService.converRuleToSearchParam(recommendRuleList);
        HashMap<String, String> showParameterMap = new HashMap<String, String>(1);
        showParameterMap.put("searchParam", SerializationUtils.toJsonString((Object)searchParam));
        showParameterMap.put(CACHE_SOURCE, "productDetail");
        fsp.setCustomParams(showParameterMap);
        this.getView().showForm(fsp);
        this.getView().getPageCache().put("recommended_pageid", fsp.getPageId());
        this.getView().updateView("recommended_flex");
    }

    private void commentView() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_goodsallcomment");
        fsp.setCustomParam("commentPageSource", (Object)MAL_NEWPRODUCTDETAIL);
        fsp.setCustomParam("goodsId", (Object)this.getGoodsId());
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("commenttab_container");
        this.getView().showForm(fsp);
    }

    private MalCommentEsSearchResult doCommentSearch(List<EsFilterField> esFilterFields) {
        MalCommentEsSearchParam malCommentEsSearchParam = new MalCommentEsSearchParam();
        EsSearchParam esSearchParam = new EsSearchParam();
        esSearchParam.setPageNum(0);
        esSearchParam.setPageSize(1);
        esSearchParam.setEsFilterFields(esFilterFields);
        EsSortField esSortField = new EsSortField("createtime", false);
        esSearchParam.setEsSortFields(new EsSortField[]{esSortField});
        malCommentEsSearchParam.setEsSearchParam(esSearchParam);
        MalCommentEsSearchService malCommentEsSearchService = new MalCommentEsSearchService();
        return malCommentEsSearchService.search(malCommentEsSearchParam);
    }

    public void registerListener(EventObject e) {
        Tab pakagetab;
        Tab tab;
        Label autocompare;
        Label entercomparelabel;
        super.registerListener(e);
        Button button = (Button)this.getView().getControl("add_cart_btn");
        Button image1 = (Button)this.getView().getControl(DETAIL_IMAGEAP1);
        Button image2 = (Button)this.getView().getControl(DETAIL_IMAGEAP2);
        Button image3 = (Button)this.getView().getControl(DETAIL_IMAGEAP3);
        Button image4 = (Button)this.getView().getControl(DETAIL_IMAGEAP4);
        Button image5 = (Button)this.getView().getControl(DETAIL_IMAGEAP5);
        Button button1 = (Button)this.getView().getControl(QUERYHISTORYPRICE);
        button.addClickListener((ClickListener)this);
        image1.addClickListener((ClickListener)this);
        image2.addClickListener((ClickListener)this);
        image3.addClickListener((ClickListener)this);
        image4.addClickListener((ClickListener)this);
        image5.addClickListener((ClickListener)this);
        button1.addClickListener((ClickListener)this);
        Button beforevideobtn = (Button)this.getView().getControl("beforevideobtn");
        Button aftervideobtn = (Button)this.getView().getControl("aftervideobtn");
        beforevideobtn.addClickListener((ClickListener)this);
        aftervideobtn.addClickListener((ClickListener)this);
        Container cartFlex = (Container)this.getView().getControl(MYCART_FLEX);
        cartFlex.addClickListener((ClickListener)this);
        Label supplierLabel = (Label)this.getControl(DETAIL_SUPPLIER);
        if (supplierLabel != null) {
            supplierLabel.addClickListener((ClickListener)this);
        }
        if ((entercomparelabel = (Label)this.getControl("entercomparelabel")) != null) {
            entercomparelabel.addClickListener((ClickListener)this);
        }
        if ((autocompare = (Label)this.getControl("autocompare")) != null) {
            autocompare.addClickListener((ClickListener)this);
        }
        if ((tab = (Tab)this.getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((pakagetab = (Tab)this.getControl("tab_pakage")) != null) {
            pakagetab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String admindivisionId;
        DynamicObject admindivisionDyn;
        if (StringUtils.equals((CharSequence)ADDQTY, (CharSequence)e.getProperty().getName())) {
            ChangeData[] changedData = e.getChangeSet();
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            BigDecimal newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue());
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue(ADDQTY, (Object)oldVal);
            }
            MalGoods malGoods = this.getMalGoods();
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
                malGoods = this.getMalGoods();
            }
            this.getView().getModel().setValue(LADPRICE, (Object)malGoods.getTaxPrice());
            String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
            if (Boolean.parseBoolean(param) && this.getIsExistLadprice()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"viewladderpriceflex"});
                this.setLadderPriceRangeContent(malGoods, CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY)));
                BigDecimal price = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(DETAIL_PRICE));
                BigDecimal ladprice = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(LADPRICE));
                if (price.compareTo(ladprice) != 0) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapladdprice"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{DETAIL_PRICE_T});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_PRICE});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapladdprice"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_PRICE_T});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{DETAIL_PRICE});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewladderprice"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_PRICE_T});
            }
        }
        if ("header_org".equals(e.getProperty().getName())) {
            this.getView().getFormShowParameter().setCustomParam("purchase_org", (Object)String.valueOf(this.getModel().getValue("header_org_id")));
            MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
            this.doRefresh();
        }
        if (ADMINDIVISIONFIELD.equals(e.getProperty().getName()) && (admindivisionDyn = MalAddressUtil.getAdmindivisionById((String)(admindivisionId = String.valueOf(e.getChangeSet()[0].getNewValue())))) != null && admindivisionDyn.getInt("level") > 2) {
            Label stock = (Label)this.getView().getControl(STOCK);
            Html promisetipsHtml = (Html)this.getView().getControl(PROMISETIPS);
            MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
            MalGoods malGoods = this.getMalGoods();
            malGoods.setShippingAddress(admindivisionId);
            stock.setText(malGoods.getStockDesc());
            String promiseTips = malGoods.getPromiseTips();
            if (promiseTips != null) {
                promisetipsHtml.setConent("<div>" + malGoods.getTipsContent() + promiseTips + "</div>");
            } else {
                promisetipsHtml.setConent(" ");
            }
            this.setBtnStatusByGoods(malGoods);
        }
    }

    private void doRefresh() {
        this.initView();
        MalGoods malGoods = this.getMalGoods();
        if (malGoods != null) {
            this.loadSimilarGoods(malGoods);
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabdetail");
            this.getView().updateView();
        }
    }

    private void setLadderPriceRangeContent(MalGoods malgoods, BigDecimal qty) {
        String unitName = ((DynamicObject)this.getModel().getValue(DETAIL_UNIT)).getString(DETAIL_NAME);
        String currencySign = ((DynamicObject)this.getModel().getValue(CURRENCY)).getString("sign");
        MalLadderPriceRangeServiceImpl ladderPriceRangeService = new MalLadderPriceRangeServiceImpl();
        String content = ladderPriceRangeService.getLadderPriceContent(malgoods, qty, unitName, currencySign);
        Html ladderPriceDetail = (Html)this.getView().getControl(LADDERPRICE_DETAIL);
        ladderPriceDetail.setConent(content);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{HISTORYTRENDCONTAINER});
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param) && this.getIsExistLadprice()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"viewladderpriceflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapladdprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewladderpriceflex", "flexpanelapladdprice"});
        }
        MalGoods malGoods = this.getMalGoods();
        if (!malGoods.isSimilar()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_RECOMMEND});
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SAMECLASS});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_RECOMMEND});
            this.getView().setVisible(Boolean.TRUE, new String[]{TAB_SAMECLASS});
        }
        this.pageControlsSettings(malGoods);
        this.setBtnStatusByGoods(malGoods);
    }

    private void setBtnStatusByGoods(MalGoods malGoods) {
        String msg = this.getButtonMsg(malGoods);
        String btnKey = "add_cart_btn";
        if (msg.length() > 0) {
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(8);
            map.put("text", new LocaleString(msg));
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(customParams.get(JUMP_ORIGIN)) && Stream.of(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey(), "mal_compare_detail").noneMatch(parentFromId -> StringUtils.equals((CharSequence)parentFromId, (CharSequence)this.getView().getFormShowParameter().getParentFormId()))) {
                btnKey = ADD_PURCHASE;
            }
            this.getView().updateControlMetadata(btnKey, map);
            this.getView().setEnable(Boolean.FALSE, new String[]{btnKey});
        } else {
            msg = ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66", (String)"MalNewProductDetailPlugin_35", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(8);
            map.put("text", new LocaleString(msg));
            this.getView().updateControlMetadata(btnKey, map);
            this.getView().setEnable(Boolean.TRUE, new String[]{btnKey});
        }
    }

    private String getButtonMsg(MalGoods malGoods) {
        String msg = "";
        if (!malGoods.validateOrgSaleable(this.getOrgId())) {
            msg = ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u53ef\u552e\uff0c\u901b\u901b\u5176\u4ed6", (String)"MalNewProductDetailPlugin_34", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (!malGoods.validateMallStatus()) {
            msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u901b\u901b\u5176\u4ed6", (String)"MalNewProductDetailPlugin_33", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY))) && (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !MalOrderParamUtil.isSelfInventoryUnlimited() || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()))) {
            msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u552e\u7f44\uff0c\u901b\u901b\u5176\u4ed6", (String)"MalNewProductDetailPlugin_32", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    private void pageControlsSettings(MalGoods malGoods) {
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.FALSE, new String[]{ADD_PURCHASE});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_SHOPPRICE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EC_SYNC});
        boolean searchV1 = MalConfigUtil.isSearchV1();
        if (searchV1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TAB_SAMECLASS, TAB_COMMENT, FLEX_RECOMMEND});
            if (malGoods.isSamekind()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{COMPAREINFO_FLEX});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPAREINFO_FLEX});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SAMECLASS, TAB_COMMENT, FLEX_RECOMMEND, COMPAREINFO_FLEX});
        }
        if (ORIGIN_SUP.equals(customParams.get(JUMP_ORIGIN)) || ORIGIN_PUR.equals(customParams.get(JUMP_ORIGIN))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEARCHCONTAINER, ADD_OFTEN_BTN, "add_cart_btn", QUERYHISTORYPRICE, ADD_COMPARE_CONTAINER, VECTORAP21, RECOMMENDTAB, HEADER_FLEX, QTY_FLEX, TAB_COMMENT, FLEX_RECOMMEND, COMPARE_FLOAT_FLEX, TAB_SAMECLASS, COMPAREINFO_FLEX});
            this.getView().setEnable(Boolean.FALSE, new String[]{DETAIL_SUPPLIER});
        } else if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(customParams.get(JUMP_ORIGIN))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEARCHCONTAINER, ADD_OFTEN_BTN, "add_cart_btn", ADDQTY, ADD_OFTEN_CONTAINER, COMPAREINFO_FLEX, COMPARE_FLOAT_FLEX, RECOMMENDTAB, ADD_COMPARE_CONTAINER, "vector_org", FLEX_RECOMMEND});
            if (Stream.of(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey(), "mal_compare_detail").noneMatch(parentFromId -> StringUtils.equals((CharSequence)parentFromId, (CharSequence)this.getView().getFormShowParameter().getParentFormId()))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ADD_PURCHASE});
            }
        } else if (MAL_PURCHASE.equals(customParams.get(JUMP_ORIGIN))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ADD_PURCHASE});
            this.getView().setVisible(Boolean.FALSE, new String[]{SEARCHCONTAINER, ADD_OFTEN_BTN, "add_cart_btn", ADDQTY, ADD_OFTEN_CONTAINER, COMPARE_FLOAT_FLEX, ADD_COMPARE_CONTAINER, RECOMMENDTAB, "vector_org", ADDQTY_LABEL, DETAIL_UNIT, TAB_SAMECLASS, COMPAREINFO_FLEX});
        } else if (MAL_ECSEARCH_V1.equals(customParams.get(JUMP_ORIGIN)) || StringUtils.equals((CharSequence)malGoods.getProductId(), (CharSequence)"0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"add_cart_btn", ADD_OFTEN_CONTAINER, HEADER_FLEX, SEARCHCONTAINER, TAB_COMMENT, TAB_SAMECLASS, RECOMMENDTAB, FLEX_RECOMMEND, FLEX_SALES, QUERYHISTORYPRICE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EC_SYNC, FLEX_SHOPPRICE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"add_cart_btn", ADD_OFTEN_CONTAINER, HEADER_FLEX, SEARCHCONTAINER, TAB_COMMENT, TAB_SAMECLASS, RECOMMENDTAB, FLEX_RECOMMEND, FLEX_SALES, QUERYHISTORYPRICE});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EC_SYNC, FLEX_SHOPPRICE});
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PROMISETIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{NOREASONTORETURN_TEXT});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_PRICE_T});
    }

    private boolean getIsExistLadprice() {
        if (null == this.getPageCache().get(CACHE_MALGOODS_ID)) {
            return false;
        }
        String goodsId = this.getPageCache().get(CACHE_MALGOODS_ID);
        QFilter qFilter = new QFilter("goods.id", "=", (Object)Long.parseLong(String.valueOf(goodsId)));
        QFilter orgQFilter = new QFilter("isgoodvisible", "=", (Object)Boolean.TRUE).or(new QFilter("isgoodvisible", "=", (Object)Boolean.FALSE).and(new QFilter("entryentity.orgname", "=", (Object)this.getOrgId())));
        qFilter.and(orgQFilter);
        qFilter.and(new QFilter("mallstatus", "=", (Object)"B"));
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"priceentry.qtyfrom qtyfrom,priceentry.qtyto qtyto,priceentry.ladprice ladprice", (QFilter[])qFilter.toArray());
        if (prodPools.size() > 0) {
            boolean isEmptyrRow = false;
            for (DynamicObject row : prodPools) {
                if (row.getBigDecimal(LADPRICE).compareTo(BigDecimal.ZERO) != 0) continue;
                isEmptyrRow = true;
                break;
            }
            return !isEmptyrRow;
        }
        return false;
    }

    private Long getOrgId() {
        DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
        return orgDyn == null ? 0L : orgDyn.getLong("id");
    }

    private void fillSelfStock(String stockDesc) {
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        this.getView().getModel().setValue(DETAIL_AVAILABLEQTY, (Object)stockDesc);
        this.getView().setVisible(Boolean.FALSE, new String[]{STOCK});
        if ("".equals(stockDesc)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_AVAILABLEQTY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"noinventorycontainer", "noinventorytext"});
            Label selfStockLabel = (Label)this.getView().getControl("labelap111");
            selfStockLabel.setText(ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalNewProductDetailPlugin_29", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            BigDecimal stockQty = new BigDecimal(stockDesc);
            if (stockQty.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_AVAILABLEQTY});
                if (selfInventoryUnlimited) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"noinventorycontainer", "noinventorycontainer1", "noinventorytext"});
                    Label selfStockLabel = (Label)this.getView().getControl("labelap111");
                    selfStockLabel.setText(ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalNewProductDetailPlugin_29", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"leadtime_flex1"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"add_cart_btn", ADD_PURCHASE});
                    Label selfStockLabel = (Label)this.getView().getControl("labelap111");
                    selfStockLabel.setText(ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewProductDetailPlugin_30", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"noinventorycontainer", "noinventorycontainer1", "noinventorytext"});
            }
        }
    }

    private void fillBarcode(MalGoods malGoods) {
        String malNewSearchKey = ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey();
        if (StringUtils.isEmpty((CharSequence)malGoods.getBarcode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"barcoder_flex"});
        }
        if ("mal_newsearch_v1".equals(malNewSearchKey) && malGoods.isSamekind()) {
            QRCode barcodeap = (QRCode)this.getControl("barcodeap");
            barcodeap.setUrl(malGoods.getBarcode());
            if (null != malGoods.getMalSameKindGoods() && malGoods.getMalSameKindGoods().size() > 0) {
                ArrayList<String> attrFlexKeys = new ArrayList<String>(1024);
                Container purSchemeFlexAp = (Container)this.getView().getControl("compareinfo_content_flex");
                List malSameKindGoods = malGoods.getMalSameKindGoods();
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                int count = 0;
                for (MalSameKindGoods sameKindGoods : malSameKindGoods) {
                    if (count > 5) break;
                    FlexPanelAp goodsInfoFlex = this.createGoodsInfoFlex(list, sameKindGoods, malGoods);
                    attrFlexKeys.add(goodsInfoFlex.getKey());
                    ++count;
                }
                purSchemeFlexAp.deleteControls(attrFlexKeys.toArray(new String[0]));
                purSchemeFlexAp.addControls(list);
                this.getView().updateView("compareinfo_content_flex");
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_nogoods"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entercomparelabel", "titlecompare_flex", "autocompare"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_nogoods"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_nogoods"});
        }
    }

    private FlexPanelAp createGoodsInfoFlex(List<Map<String, Object>> list, MalSameKindGoods sameKindGoods, MalGoods malGoods) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId(sameKindGoods.getGoodsId().toString() + "all");
        res.setKey(sameKindGoods.getGoodsId().toString() + "all");
        res.setWidth(new LocaleString("100%"));
        res.setJustifyContent("flex-start");
        res.setAlignItems("flex-start");
        res.setName(new LocaleString(sameKindGoods.getGoodsId().toString() + "all"));
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("10px");
        padding.setBottom("10px");
        style.setPadding(padding);
        res.setStyle(style);
        LabelAp attrItemLabel = this.createSupplierLabel(sameKindGoods);
        res.getItems().add(attrItemLabel);
        FlexPanelAp priceFlexs = this.createPriceFlex(sameKindGoods, malGoods);
        res.getItems().add(priceFlexs);
        list.add(res.createControl());
        return res;
    }

    private FlexPanelAp createPriceFlex(MalSameKindGoods sameKindGoods, MalGoods malGoods) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId(sameKindGoods.getGoodsId().toString() + "priceflex");
        res.setKey(sameKindGoods.getGoodsId().toString() + "priceflex");
        res.setWidth(new LocaleString("35%"));
        res.setJustifyContent("flex-start");
        res.setAlignItems("flex-start");
        res.setName(new LocaleString(sameKindGoods.getGoodsId().toString() + "all"));
        LabelAp attrItemLabel1 = this.createPriceLabel(sameKindGoods);
        res.getItems().add(attrItemLabel1);
        LabelAp attrItemLabel2 = this.createSignLabel(sameKindGoods, malGoods);
        res.getItems().add(attrItemLabel2);
        res.setWrap(false);
        return res;
    }

    private LabelAp createPriceLabel(MalSameKindGoods sameKindGoods) {
        LabelAp res = new LabelAp();
        res.setKey(sameKindGoods.getGoodsId() + DETAIL_PRICE);
        res.setId(sameKindGoods.getGoodsId() + DETAIL_PRICE);
        res.setWidth(new LocaleString("80%"));
        res.setForeColor("#ff5f1f");
        DynamicObject currency = (DynamicObject)this.getModel().getValue(CURRENCY);
        BigDecimal price = sameKindGoods.getPrice();
        String priceBigDecimal = "0";
        if (null != price && price.compareTo(BigDecimal.ZERO) != 0) {
            priceBigDecimal = price.stripTrailingZeros().toPlainString();
        }
        String keyName = currency.getString("sign") + " " + priceBigDecimal + "/" + sameKindGoods.getUnitName() + " ";
        res.setName(new LocaleString(keyName));
        res.setFontSize(14);
        return res;
    }

    private LabelAp createSignLabel(MalSameKindGoods sameKindGoods, MalGoods malGoods) {
        BigDecimal price = malGoods.getTaxPrice();
        BigDecimal sameKindPrice = sameKindGoods.getPrice();
        LabelAp res = new LabelAp();
        res.setKey(sameKindGoods.getGoodsId() + "sign");
        res.setId(sameKindGoods.getGoodsId() + "sign");
        res.setLabelStyle("1");
        Style style = new Style();
        Border border = new Border();
        Margin margin = new Margin();
        margin.setLeft("5px");
        style.setMargin(margin);
        if (price.compareTo(sameKindPrice) == 0) {
            res.setForeColor("#ff5f1f");
            border.setBottom("1px_solid_#ff5f1f");
            border.setTop("1px_solid_#ff5f1f");
            border.setLeft("1px_solid_#ff5f1f");
            border.setRight("1px_solid_#ff5f1f");
            res.setName(new LocaleString(ResManager.loadKDString((String)"\u5e73", (String)"MalNewProductDetailPlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0])));
        }
        if (price.compareTo(sameKindPrice) < 0) {
            res.setForeColor("#fb2323");
            border.setBottom("1px_solid_#fb2323");
            border.setTop("1px_solid_#fb2323");
            border.setLeft("1px_solid_#fb2323");
            border.setRight("1px_solid_#fb2323");
            res.setName(new LocaleString(ResManager.loadKDString((String)"\u9ad8", (String)"MalNewProductDetailPlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0])));
        }
        if (price.compareTo(sameKindPrice) > 0) {
            res.setForeColor("#1ba854");
            border.setBottom("1px_solid_#1ba854");
            border.setTop("1px_solid_#1ba854");
            border.setLeft("1px_solid_#1ba854");
            border.setRight("1px_solid_#1ba854");
            res.setName(new LocaleString(ResManager.loadKDString((String)"\u7701", (String)"MalNewProductDetailPlugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0])));
        }
        style.setBorder(border);
        res.setStyle(style);
        return res;
    }

    private LabelAp createSupplierLabel(MalSameKindGoods sameKindGoods) {
        LabelAp res = new LabelAp();
        res.setKey(sameKindGoods.getGoodsId() + DETAIL_SUPPLIER);
        res.setId(sameKindGoods.getGoodsId() + DETAIL_SUPPLIER);
        res.setName(new LocaleString(sameKindGoods.getSupplierName()));
        res.setFontSize(14);
        res.setWidth(new LocaleString("60%"));
        return res;
    }

    private void setImages(MalGoods malGoods) {
        Image image = (Image)this.getView().getControl(DETAIL_IMAGEAP);
        Image image1 = (Image)this.getView().getControl(DETAIL_IMAGEAP1);
        Image image2 = (Image)this.getView().getControl(DETAIL_IMAGEAP2);
        Image image3 = (Image)this.getView().getControl(DETAIL_IMAGEAP3);
        Image image4 = (Image)this.getView().getControl(DETAIL_IMAGEAP4);
        Image image5 = (Image)this.getView().getControl(DETAIL_IMAGEAP5);
        image.setUrl(malGoods.getThumbnail());
        image1.setUrl(malGoods.getThumbnail());
        if (StringUtils.isNotBlank((CharSequence)malGoods.getPicture1())) {
            image2.setUrl(malGoods.getPicture1());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_IMAGEAP2});
        }
        if (StringUtils.isNotBlank((CharSequence)malGoods.getPicture2())) {
            image3.setUrl(malGoods.getPicture2());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_IMAGEAP3});
        }
        if (StringUtils.isNotBlank((CharSequence)malGoods.getPicture3())) {
            image4.setUrl(malGoods.getPicture3());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_IMAGEAP4});
        }
        if (StringUtils.isNotBlank((CharSequence)malGoods.getPicture4())) {
            image5.setUrl(malGoods.getPicture4());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DETAIL_IMAGEAP5});
        }
    }

    public void click(EventObject evt) {
        String videosrc;
        FormShowParameter showParameter;
        MalGoods malGoods;
        super.click(evt);
        Button button = null;
        Container container = null;
        String clickKey = "";
        if (evt.getSource() instanceof Button) {
            button = (Button)evt.getSource();
            clickKey = button.getKey();
        }
        if (evt.getSource() instanceof Container) {
            container = (Container)evt.getSource();
        }
        if (button != null && DETAIL_IMAGEAP1.equals(clickKey) || DETAIL_IMAGEAP2.equals(clickKey) || DETAIL_IMAGEAP3.equals(clickKey) || DETAIL_IMAGEAP4.equals(clickKey) || DETAIL_IMAGEAP5.equals(clickKey)) {
            malGoods = this.getMalGoods();
            Image image = (Image)this.getView().getControl(DETAIL_IMAGEAP);
            if (null != malGoods) {
                if (DETAIL_IMAGEAP1.equals(clickKey)) {
                    image.setUrl(malGoods.getThumbnail());
                }
                if (DETAIL_IMAGEAP2.equals(clickKey)) {
                    image.setUrl(malGoods.getPicture1());
                }
                if (DETAIL_IMAGEAP3.equals(clickKey)) {
                    image.setUrl(malGoods.getPicture2());
                }
                if (DETAIL_IMAGEAP4.equals(clickKey)) {
                    image.setUrl(malGoods.getPicture3());
                }
                if (DETAIL_IMAGEAP5.equals(clickKey)) {
                    image.setUrl(malGoods.getPicture4());
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"videoap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{DETAIL_IMAGEAP});
            }
        }
        if (container != null && MYCART_FLEX.equals(container.getKey())) {
            showParameter = new FormShowParameter();
            showParameter.setFormId("mal_newshopcart");
            showParameter.setAppId("mal");
            showParameter.setCustomParam("opentype", (Object)ShowType.NewWindow);
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            this.getView().showForm(showParameter);
            return;
        }
        if (button != null && DETAIL_SUPPLIER.equals(button.getKey())) {
            showParameter = new FormShowParameter();
            showParameter.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey());
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            HashMap<String, String> searchParamMap = new HashMap<String, String>();
            searchParamMap.put("searchText", this.getMalGoods().getSupplierName());
            searchParamMap.put("searchfield", "suppliername|like");
            searchParamMap.put("opentype", (String)ShowType.NewWindow);
            showParameter.setCustomParams(searchParamMap);
            this.getView().showForm(showParameter);
            return;
        }
        if (button != null && "entercomparelabel".equals(button.getKey())) {
            malGoods = this.getMalGoods();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            FormShowParameter showParameter2 = new FormShowParameter();
            if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getCustomParams().get(JUMP_ORIGIN))) {
                showParameter2.setFormId("mal_pickgoods_v1");
            } else {
                showParameter2.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey());
            }
            GoodsSameRule goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(malGoods.getProductId())), malGoods.getProductSource()});
            if (null != goodsSameRule) {
                showParameter2.getOpenStyle().setShowType(ShowType.NewWindow);
                HashMap<String, String> searchParamMap = new HashMap<String, String>();
                searchParamMap.put("esfilter", SerializationUtils.toJsonString((Object)goodsSameRule.getEsFilterFields()));
                searchParamMap.put("orderby", goodsSameRule.getSort());
                searchParamMap.put("firstgoodsid", malGoods.getProductId());
                searchParamMap.put(CACHE_SOURCE, MAL_NEWPRODUCTDETAIL);
                searchParamMap.put("purchase_org", (String)customParams.get("purchase_org"));
                searchParamMap.put(JUMP_ORIGIN, (String)customParams.get(JUMP_ORIGIN));
                searchParamMap.put("opentype", (String)ShowType.NewWindow);
                showParameter2.setCustomParams(searchParamMap);
                this.getView().showForm(showParameter2);
            }
            return;
        }
        if (button != null && "autocompare".equals(button.getKey())) {
            malGoods = this.getMalGoods();
            List malSameKindGoods = malGoods.getMalSameKindGoods();
            HashSet<Long> goodsIds = new HashSet<Long>(1024);
            goodsIds.add(Long.parseLong(malGoods.getProductId()));
            for (MalSameKindGoods sameGoods : malSameKindGoods) {
                goodsIds.add(sameGoods.getGoodsId());
                if (goodsIds.size() != 10) continue;
                break;
            }
            ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(null, Long.valueOf(RequestContext.get().getCurrUserId()));
            ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addCompareRecords(goodsIds, Long.valueOf(RequestContext.get().getCurrUserId()), 0);
            this.getModel().setValue(COMPARE_NUM, (Object)goodsIds.size());
            this.getView().invokeOperation("start_compare");
            return;
        }
        String attrValueLabelKeys = this.getPageCache().get(ATTR_VALUE_LABEL_KEYS);
        if (StringUtils.isNotEmpty((CharSequence)attrValueLabelKeys)) {
            StringBuilder logStr = new StringBuilder();
            MalGoods malGoods2 = this.getMalGoods();
            List malSimilarGoodsList = malGoods2.getMalSimilarGoodsList();
            String clickAttrValueLabelKey = "";
            for (String attrValueLabelKey : attrValueLabelKeys.split(DOT)) {
                if (button == null || !StringUtils.equals((CharSequence)attrValueLabelKey, (CharSequence)button.getKey())) continue;
                clickAttrValueLabelKey = attrValueLabelKey;
            }
            if (StringUtils.isNotBlank((CharSequence)clickAttrValueLabelKey)) {
                String[] attrValueLabelKeySplit = clickAttrValueLabelKey.split(SPLIT);
                int dim = Integer.parseInt(attrValueLabelKeySplit[attrValueLabelKeySplit.length - 2]);
                String saleAttrName = this.keyReverse(attrValueLabelKeySplit[attrValueLabelKeySplit.length - 1]);
                for (MalSimilarGoods malSimilarGoods : malSimilarGoodsList) {
                    if (dim != malSimilarGoods.getDim()) continue;
                    for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                        if (!StringUtils.equals((CharSequence)malSaleAttr.getSaleValue(), (CharSequence)saleAttrName) || !malSaleAttr.isSelected()) continue;
                        return;
                    }
                }
                logStr.append("kd.scm.mal.formplugin.MalNewProductDetailPlugin#getSimilarSku.dim:").append(dim).append(",saleAttrName:").append(saleAttrName).append(System.lineSeparator());
                String similarSku = malGoods2.getSimilarSku(dim, saleAttrName);
                if (StringUtils.isNotBlank((CharSequence)similarSku)) {
                    this.toSimilarPage(similarSku);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u76f8\u4f3c\u5546\u54c1\u3002", (String)"MalNewProductDetailPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
            }
            log.info(logStr.toString());
        }
        if (button != null && ("beforevideobtn".equals(button.getKey()) || "aftervideobtn".equals(button.getKey())) && !StringUtils.isEmpty((CharSequence)(videosrc = this.getPageCache().get("videosrc")))) {
            Object autoplay = this.getModel().getValue("autoplay");
            Video videoCtl = (Video)this.getView().getControl("videoap");
            videoCtl.setSrc(videosrc);
            this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_IMAGEAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{"videoap"});
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("autoPlay", Boolean.parseBoolean(String.valueOf(autoplay)));
            dataMap.put("k", "videoap");
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("u", dataMap);
        }
    }

    private void toSimilarPage(String similarSku) {
        MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
        this.getPageCache().remove(ATTR_VALUE_LABEL_KEYS);
        this.getPageCache().remove(CACHE_MALGOODS_ID);
        String source = this.getView().getPageCache().get(CACHE_SOURCE);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            this.getPageCache().put(CACHE_MALGOODS_ID, similarSku);
        } else {
            this.getPageCache().put(CACHE_PRODUCTNUMBER, similarSku);
        }
        this.doRefresh();
    }

    private void updateCompareNum(int compareNum) {
        this.getModel().setValue(COMPARE_NUM, (Object)Math.max(compareNum, 0));
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (COMPARE_DELETE.equals(arg0.getFieldName())) {
            String recommendedPageid = this.getPageCache().get("recommended_pageid");
            SessionManager sm = SessionManager.getCurrent();
            if (Objects.nonNull(recommendedPageid) && Objects.nonNull(sm)) {
                IFormView formView = sm.getView(recommendedPageid);
                formView.invokeOperation("update_compare_checkstatus");
                this.getView().sendFormAction(formView);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)"add_cart", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.addCart();
        }
        if (StringUtils.equals((CharSequence)ADD_PURCHASE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.addPurchase();
        }
    }

    private void checkStock(String operateKey, MalGoods malGoods) {
        if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY)))) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !MalOrderParamUtil.isSelfInventoryUnlimited()) {
                if (operateKey.equals("addcart")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MalNewProductDetailPlugin_27", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u9009\u8d2d\u3002", (String)"MalNewProductDetailPlugin_28", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                String confirmTip;
                ConfirmCallBackListener confirmCallBacks;
                if (operateKey.equals("addcart")) {
                    confirmCallBacks = new ConfirmCallBackListener("add_cart", (IFormPlugin)this);
                    confirmTip = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u8d2d\u7269\u8f66\u5417\uff1f", (String)"MalNewProductDetailPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                } else {
                    confirmCallBacks = new ConfirmCallBackListener(ADD_PURCHASE, (IFormPlugin)this);
                    confirmTip = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u9009\u8d2d\u5417\uff1f", (String)"MalNewProductDetailPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                }
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
        }
        if (operateKey.equals("addcart")) {
            this.addCart();
        } else {
            this.addPurchase();
        }
    }

    private void addPurchase() {
        MalGoods malGoods = this.getMalGoods();
        this.getView().returnDataToParent((Object)malGoods.getId());
        this.getView().close();
    }

    private void addCart() {
        MalGoods malGoods = this.getMalGoods();
        this.minOrderQtyCheck();
        BigDecimal addQty = (BigDecimal)this.getModel().getValue(ADDQTY);
        ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).addToCart(malGoods.getId(), malGoods.getPlatform(), addQty);
        this.getView().showSuccessNotification(malGoods.getProductName() + "\t" + ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalNewProductDetailPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getView().updateView();
    }

    private void minOrderQtyCheck() {
        BigDecimal minOrderQty;
        DynamicObject malProductDetailObj = this.getModel().getDataEntity();
        MalProductDetail malProductDetail = new MalProductDetail(malProductDetailObj);
        Boolean checkMinOrderQty = (Boolean)malProductDetail.getDefValue(CHECKMINORDERQTY);
        BigDecimal addQty = (BigDecimal)this.getModel().getValue(ADDQTY);
        if (checkMinOrderQty.booleanValue() && addQty.subtract(minOrderQty = malProductDetailObj.getBigDecimal(MINORDERQTY)).compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fbe\u5230\u6700\u5c0f\u8ba2\u8d27\u91cf\u8981\u6c42\uff0c\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25\u3002", (String)"MalNewProductDetailPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        MalGoods malGoods = this.getMalGoods();
        switch (args.getOperateKey()) {
            case "updateview": {
                this.getView().updateView();
                break;
            }
            case "compare_clear": {
                String recommendedPageid = this.getPageCache().get("recommended_pageid");
                SessionManager sm = SessionManager.getCurrent();
                if (!Objects.nonNull(recommendedPageid) || !Objects.nonNull(sm)) break;
                IFormView formView = sm.getView(recommendedPageid);
                formView.invokeOperation("compare_clear");
                this.getView().sendFormAction(formView);
                break;
            }
            case "add_compare": {
                Map sku2IdMap;
                if (MAL_ECSEARCH_V1.equals(this.getView().getFormShowParameter().getCustomParam(JUMP_ORIGIN)) && (malGoods.getId() == 0L || malGoods.getId() == null) && !(sku2IdMap = MalGoods.ecSync(Collections.singletonList(malGoods.getNumber()), (String)malGoods.getPlatform())).isEmpty()) {
                    Long goodsId = (Long)new ArrayList(sku2IdMap.values()).get(0);
                    MalGoods.removeCache((String)this.getView().getPageId(), (Long)this.getGoodsId());
                    this.getPageCache().put(CACHE_MALGOODS_ID, String.valueOf(goodsId));
                    malGoods.getGoodsInfo().setProductId(String.valueOf(goodsId));
                    MalGoods.cache((String)this.getView().getPageId(), (Long)goodsId, (MalGoods)malGoods);
                }
                ArrayList<Long> prodIds = new ArrayList<Long>(1);
                prodIds.add(Long.parseLong(malGoods.getProductId()));
                Boolean isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"addcompare");
                if (isView.booleanValue()) {
                    return;
                }
                try {
                    this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addCompareRecord(Long.valueOf(malGoods.getProductId()), Long.valueOf(RequestContext.get().getCurrUserId()), 0));
                    this.getView().invokeOperation("refresh_compare");
                }
                catch (KDBizException exception) {
                    this.getView().showErrorNotification(exception.getMessage());
                    this.getView().invokeOperation("refresh_compare");
                }
                break;
            }
            case "wechat": {
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5546\u57ce\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u5ba2\u670d\u6c9f\u901a\u3002", (String)"MalNewProductDetailPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                MalProductDetailUtil.weChat(this.getView(), malGoods.getId().toString());
                break;
            }
            case "addcart": {
                this.checkStock(args.getOperateKey(), malGoods);
                break;
            }
            case "entercart": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("mal_newshopcart");
                showParameter.setAppId("mal");
                showParameter.setCustomParam("opentype", (Object)ShowType.NewWindow);
                showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm(showParameter);
                break;
            }
            case "add2oftenbuy": {
                BigDecimal addQty = (BigDecimal)this.getModel().getValue(ADDQTY);
                HashMap<Long, BigDecimal> goodsId2QtyMap = new HashMap<Long, BigDecimal>(1);
                goodsId2QtyMap.put(malGoods.getId(), addQty);
                boolean success = MalAddToOftenBuyUtil.add(goodsId2QtyMap);
                if (success) {
                    this.getView().showSuccessNotification(malGoods.getProductName() + "\t" + ResManager.loadKDString((String)"\u5546\u54c1\u6dfb\u52a0\u6211\u7684\u5e38\u4e70\u6210\u529f\u3002", (String)"MalNewProductDetailPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(malGoods.getProductName() + "\t" + ResManager.loadKDString((String)"\u5546\u54c1\u6dfb\u52a0\u6211\u7684\u5e38\u4e70\u5931\u8d25\u3002", (String)"MalNewProductDetailPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "add_purchase": {
                Boolean isView;
                ArrayList<Long> prodIds = new ArrayList<Long>(1);
                prodIds.add(Long.parseLong(malGoods.getProductId()));
                String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
                long orgId = RequestContext.get().getOrgId();
                if (purchaseOrg != null) {
                    orgId = Long.parseLong(purchaseOrg);
                }
                if ((isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"addpurchase", (Long)orgId)).booleanValue()) {
                    return;
                }
                this.checkStock(args.getOperateKey(), malGoods);
                break;
            }
            case "queryhistoryprice": {
                this.showPriceTrend();
                break;
            }
            case "async_ec_sync": {
                MalGoods.asyncEcSync(Collections.singletonList(malGoods.getNumber()), (String)malGoods.getPlatform());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(SHOWHISTORYPRICE)) {
            Map returnData;
            String hasData;
            if (closedCallBackEvent.getReturnData() != null && "false".equals(hasData = (String)(returnData = (Map)closedCallBackEvent.getReturnData()).get("hasData"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u770b\u534a\u5e74\u5185\u5546\u54c1\u7684\u8d2d\u4e70\u8bb0\u5f55\u548c\u4f9b\u5e94\u5546\u8c03\u4ef7\u4fe1\u606f\uff0c\u6682\u65e0\u76f8\u5173\u8bb0\u5f55\u3002", (String)"MalNewProductDetailPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{HISTORYTRENDCONTAINER});
            this.getView().updateView(HISTORYTRENDCONTAINER);
        }
        if (actionId.equals(TAB_SAMECLASS) && closedCallBackEvent.getReturnData() != null) {
            Long pk = Long.parseLong(String.valueOf(closedCallBackEvent.getReturnData()));
            this.getView().returnDataToParent((Object)pk);
            this.getView().close();
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(customParams.get(JUMP_ORIGIN)) && (actionId.equals("samegoods") || actionId.equals(MAL_NEWPRODUCTDETAIL)) && closedCallBackEvent.getReturnData() != null) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
        }
        if (actionId.equals(MAL_NEWPRODUCTDETAIL)) {
            String recommendedPageid = this.getPageCache().get("recommended_pageid");
            SessionManager sm = SessionManager.getCurrent();
            if (Objects.nonNull(recommendedPageid) && Objects.nonNull(sm)) {
                IFormView formView = sm.getView(recommendedPageid);
                formView.invokeOperation("update_compare_checkstatus");
                this.getView().sendFormAction(formView);
            }
            this.getView().invokeOperation("refresh_compare");
            if ("mal_addcomparegoods".equals(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"scmsearch"});
            }
        }
    }

    private void showPriceTrend() {
        Object pricemonitortab = this.getModel().getValue("pricemonitortab");
        ArrayList<String> invisibletabs = new ArrayList<String>(16);
        if (null != pricemonitortab) {
            String[] tabs;
            for (String tab : tabs = String.valueOf(pricemonitortab).split(DOT)) {
                if (StringUtils.isEmpty((CharSequence)tab)) continue;
                invisibletabs.add(tab);
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_pricemonitordetail");
        MalGoods malGoods = this.getMalGoods();
        fsp.setCustomParam("goodsId", (Object)malGoods.getProductId());
        fsp.setCustomParam(CACHE_SOURCE, (Object)malGoods.getPlatform());
        fsp.setCustomParam("org", (Object)this.getOrgId());
        fsp.setCustomParam("invisibletabs", (Object)SerializationUtils.toJsonString(invisibletabs));
        fsp.setCustomParam("sourceForm", (Object)MAL_NEWPRODUCTDETAIL);
        fsp.setCustomParam("purchase_org", this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "samegoods"));
        this.getView().showForm(fsp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"viewladderprice")) {
            String goodsId = this.getPageCache().get(CACHE_PRODUCTID);
            String goodsSource = this.getPageCache().get(CACHE_SOURCE);
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsSource)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pbd_ladderprice");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
                detailParamMap.put("status", "1");
                detailParamMap.put("goodsId", goodsId);
                detailParamMap.put("orgId", this.getOrgId());
                showParameter.setCustomParams(detailParamMap);
                this.getView().showForm(showParameter);
            }
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)QUERYHISTORYPRICE)) {
            MalPriceMonitorService service;
            Object pricemonitortab = this.getModel().getValue("pricemonitortab");
            ArrayList<String> invisibletabs = new ArrayList<String>(16);
            if (null != pricemonitortab) {
                String[] tabs;
                for (String tab : tabs = String.valueOf(pricemonitortab).split(DOT)) {
                    if (StringUtils.isEmpty((CharSequence)tab)) continue;
                    invisibletabs.add(tab);
                }
            }
            if (!(service = new MalPriceMonitorService()).checkIsShowPriceMonitorForm(this.getNoDeatialMalGoods(), invisibletabs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6bd4\u4ef7\u8bb0\u5f55\u3001\u540c\u6b3e\u5546\u54c1\u3001\u534a\u5e74\u5185\u7684\u5386\u53f2\u4ef7\u683c\u548c\u672c\u7ec4\u7ec7\u4ea4\u6613\u4ef7\u6570\u636e\u3002", (String)"MalNewProductDetailPlugin_31", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

