/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.mal.business.shopcart.service.impl.MalShopCartServiceImpl;
import kd.scm.mal.business.shopcart.vo.MalAddCartParam;
import kd.scm.mal.business.shopcart.vo.MalCarResultVO;
import kd.scm.mal.formplugin.DataSheetHandler;

public class MalNewShopCartImpExpPlugin
extends AbstractBillPlugIn
implements UploadListener {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final int MATERIALNUMBER = 0;
    private static final int MATERIALNAME = 1;
    private static final int GOODSNUMBER = 2;
    private static final int GOODSNAME = 3;
    private static final int PLATFORM = 4;
    private static final int SUPPLIERNUMBER = 5;
    private static final int SUPPLIERNAME = 6;
    private static final int QTY = 7;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button importBtn = (Button)this.getControl("btn_import");
        importBtn.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "export": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u51fa\u4e2d\u3002", (String)"MalNewShopCartImpExpPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])));
                    break;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String url = (String)evt.getUrls()[0];
        this.log.info("@@uploadurl:" + url);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        fileService.download(url, (OutputStream)outStream, "httpclient");
        ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
        ExcelReader reader = new ExcelReader();
        DataSheetHandler handler = new DataSheetHandler();
        try {
            reader.read((InputStream)input, (SheetHandler)handler);
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        Map<Integer, Map<Integer, String>> rows = handler.getRows();
        String importDataStr = JSON.toJSONString(rows);
        this.getPageCache().put("importDataByMaterial", importDataStr);
    }

    public void afterUpload(UploadEvent evt) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u5165\u4e2d", (String)"MalNewShopCartImpExpPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0])));
            this.getPageCache().put("isTreeNodeClick", null);
            this.importDataByMaterial();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void importDataByMaterial() {
        MalShopCartServiceImpl malShopCartService = new MalShopCartServiceImpl();
        String importDataStr = this.getPageCache().get("importDataByMaterial");
        Map rows = (Map)JSONObject.parseObject((String)importDataStr, Map.class);
        if (rows == null || rows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u3002", (String)"MalNewShopCartImpExpPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> materialNumberSet = new HashSet<String>(16);
        HashSet<String> supplierNumberSet = new HashSet<String>(16);
        HashSet<String> malgoodsSet = new HashSet<String>(16);
        HashSet<String> pmmgoodsSet = new HashSet<String>(16);
        ArrayList<MalAddCartParam> malAddCartParams = new ArrayList<MalAddCartParam>(16);
        for (int i = 2; i < rows.size(); ++i) {
            Map row = (Map)rows.get(i);
            String platform = (String)row.get(0);
            if (row.get(0) != null) {
                materialNumberSet.add((String)row.get(0));
            } else if (platform == null && row.get(5) == null) {
                pmmgoodsSet.add((String)row.get(2));
                malgoodsSet.add((String)row.get(2));
            } else if (platform == null && row.get(5) != null) {
                pmmgoodsSet.add((String)row.get(2));
            } else if (platform != null && platform.equals("1")) {
                pmmgoodsSet.add((String)row.get(2));
            } else if (platform != null && !platform.equals("1")) {
                malgoodsSet.add((String)row.get(2));
            }
            if (row.get(5) == null) continue;
            supplierNumberSet.add((String)row.get(5));
        }
        Map<String, List<DynamicObject>> goodsMap = this.getGoodsDynMap(pmmgoodsSet, malgoodsSet);
        Map<String, Long> materialNumberMatIdMap = this.queryMaterialIdByMaterialNumber(materialNumberSet);
        Map<Long, List<DynamicObject>> materialIdMatGoodsDynMap = this.queryGoodsMappingByMaterial(materialNumberMatIdMap.values());
        Map<String, Long> supplierNumberMatIdMap = this.querySupplierIdBySupplierNumber(supplierNumberSet);
        ArrayList<List<Object>> rowDatas = new ArrayList<List<Object>>();
        HashMap<Long, DynamicObject> malGoodsIdMap = new HashMap<Long, DynamicObject>();
        for (int i = 2; i < rows.size(); ++i) {
            String errorMsg = "";
            Map row = (Map)rows.get(i);
            String materialNumber = (String)row.get(0);
            String materialName = (String)row.get(0);
            String goodsNumber = (String)row.get(2);
            String goodsName = (String)row.get(3);
            String platform = (String)row.get(4);
            String supplierNumber = (String)row.get(5);
            String qty = (String)row.get(7);
            String source = null;
            if (platform == null && row.get(5) == null) {
                source = "1";
            }
            if (!StringUtils.isEmpty((CharSequence)platform)) {
                source = EcPlatformEnum.getEnumValue((String)platform);
            }
            if (StringUtils.isEmpty((CharSequence)materialNumber)) {
                if (StringUtils.isEmpty((CharSequence)goodsNumber)) {
                    if (StringUtils.isEmpty((CharSequence)goodsName) || StringUtils.isEmpty((CharSequence)materialName)) {
                        errorMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MalNewShopCartImpExpPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                        rowDatas.add(this.createErrorData(row, errorMsg));
                        continue;
                    }
                    errorMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u53d1\u8d77\u76ee\u5f55\u5916\u8bf7\u8d2d\u3002", (String)"MalNewShopCartImpExpPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    rowDatas.add(this.createErrorData(row, errorMsg));
                    continue;
                }
                List<DynamicObject> goodsList = goodsMap.get(goodsNumber);
                if (goodsList == null || goodsList.size() == 0) {
                    errorMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u53d1\u8d77\u76ee\u5f55\u5916\u8bf7\u8d2d\u3002", (String)"MalNewShopCartImpExpPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    rowDatas.add(this.createErrorData(row, errorMsg));
                    continue;
                }
                boolean iscontinue = false;
                Long supplierid = supplierNumberMatIdMap.get(supplierNumber);
                boolean hassupplier = supplierid != null && supplierid != 0L;
                DynamicObject curgood = null;
                for (DynamicObject good : goodsList) {
                    if (StringUtils.isEmpty((CharSequence)supplierNumber) && StringUtils.isEmpty((CharSequence)source)) {
                        malAddCartParams.add(this.createMalAddCartParam(good, qty));
                        malGoodsIdMap.put(good.getLong("id"), good);
                        iscontinue = true;
                        continue;
                    }
                    if (source.equals("1") && good.getString("source").equals(source)) {
                        if (!hassupplier) {
                            malAddCartParams.add(this.createMalAddCartParam(good, qty));
                            malGoodsIdMap.put(good.getLong("id"), good);
                            iscontinue = true;
                            continue;
                        }
                        if (!hassupplier || supplierid.equals(good.getLong("supplier"))) {
                            curgood = good;
                            iscontinue = true;
                            break;
                        }
                    }
                    if (!good.getString("source").equals(source)) continue;
                    curgood = good;
                    iscontinue = true;
                    break;
                }
                if (curgood != null) {
                    malAddCartParams.add(this.createMalAddCartParam(curgood, qty));
                    malGoodsIdMap.put(curgood.getLong("id"), curgood);
                    continue;
                }
                if (!iscontinue) {
                    errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5546\u54c1\u5728\u5bf9\u5e94\u4f9b\u5e94\u5546\u4e0b\u672a\u627e\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u53d1\u8d77\u76ee\u5f55\u5916\u8bf7\u8d2d\u3002", (String)"MalNewShopCartImpExpPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    rowDatas.add(this.createErrorData(row, errorMsg));
                    continue;
                }
                if (!iscontinue) continue;
            }
            Long materialId = materialNumberMatIdMap.get(materialNumber);
            if (materialId == null || materialId == 0L) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u7269\u6599\u7f16\u7801\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MalNewShopCartImpExpPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                rowDatas.add(this.createErrorData(row, errorMsg));
                continue;
            }
            List<DynamicObject> goodsList = materialIdMatGoodsDynMap.get(materialId);
            if (goodsList == null || goodsList.size() == 0) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u627e\u4e0d\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u53d1\u8d77\u76ee\u5f55\u5916\u8bf7\u8d2d\u3002", (String)"MalNewShopCartImpExpPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                rowDatas.add(this.createErrorData(row, errorMsg));
                continue;
            }
            boolean iscontinue = false;
            Long supplierid = supplierNumberMatIdMap.get(supplierNumber);
            boolean hassupplier = supplierid != null && supplierid != 0L;
            DynamicObject curgood = null;
            for (DynamicObject good : goodsList) {
                if (StringUtils.isEmpty((CharSequence)supplierNumber) && StringUtils.isEmpty((CharSequence)source)) {
                    malAddCartParams.add(this.createMalAddCartParam(good, qty));
                    malGoodsIdMap.put(good.getLong("id"), good);
                    iscontinue = true;
                    continue;
                }
                if (source.equals("1") && good.getString("source").equals(source)) {
                    if (!hassupplier) {
                        malAddCartParams.add(this.createMalAddCartParam(good, qty));
                        malGoodsIdMap.put(good.getLong("id"), good);
                        iscontinue = true;
                        continue;
                    }
                    if (!hassupplier || supplierid.equals(good.getLong("supplier"))) {
                        curgood = good;
                        iscontinue = true;
                        break;
                    }
                }
                if (!good.getString("source").equals(source)) continue;
                curgood = good;
                iscontinue = true;
                break;
            }
            if (curgood != null) {
                malAddCartParams.add(this.createMalAddCartParam(curgood, qty));
                malGoodsIdMap.put(curgood.getLong("id"), curgood);
                continue;
            }
            if (!iscontinue) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u5728\u8be5\u4f9b\u5e94\u5546\u4e0b\u672a\u627e\u5230\u5408\u9002\u7684\u5546\u54c1\uff0c\u8bf7\u53d1\u8d77\u76ee\u5f55\u5916\u8bf7\u8d2d\u3002", (String)"MalNewShopCartImpExpPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                rowDatas.add(this.createErrorData(row, errorMsg));
                continue;
            }
            if (!iscontinue) continue;
        }
        if (malAddCartParams.size() > 0) {
            List malCarResultList = malShopCartService.batchAddToCartHasResult(malAddCartParams);
            rowDatas.add(this.createNullData());
            for (MalCarResultVO result : malCarResultList) {
                rowDatas.add(this.createErrorDataByGoods((DynamicObject)malGoodsIdMap.get(result.getGoodsId()), result.getErrorMessage()));
            }
        }
        if (rowDatas.size() > 0) {
            this.exportErrorMessage(this.getView(), this.getPageCache(), rowDatas);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8d2d\u7269\u8f66\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\uff0c\u5177\u4f53\u8bf7\u53c2\u8003\u201c\u5bfc\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u4fe1\u606f.xlsx\u201d\u4e2d\u7684\u5931\u8d25\u539f\u56e0", (String)"MalNewShopCartImpExpPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalNewShopCartImpExpPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private MalAddCartParam createMalAddCartParam(DynamicObject goodsData, String qty) {
        MalAddCartParam malAddCartParam = new MalAddCartParam();
        malAddCartParam.setGoodsId(Long.valueOf(goodsData.getLong("id")));
        malAddCartParam.setGoodsNumber(goodsData.getString("number"));
        malAddCartParam.setPlatform(goodsData.getString("source"));
        if (qty != null) {
            malAddCartParam.setQty(new BigDecimal(qty));
        } else {
            malAddCartParam.setQty(BigDecimal.ONE);
        }
        return malAddCartParam;
    }

    public Map<String, List<DynamicObject>> getGoodsDynMap(Set<String> selfGoodsNumbers, Set<String> ecGoodsNumbers) {
        HashMap<String, List<DynamicObject>> goodsNumberDynMap = new HashMap<String, List<DynamicObject>>(16);
        if (selfGoodsNumbers != null && !selfGoodsNumbers.isEmpty()) {
            String selfSlector = "name,number,source,supplier";
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)selfSlector, (QFilter[])new QFilter[]{new QFilter("number", "in", selfGoodsNumbers), new QFilter("source", "=", (Object)"1")});
            selfGoodsEntryCol.forEach(row -> {
                List goodsDynList = goodsNumberDynMap.computeIfAbsent(row.getString("munber"), k -> new ArrayList());
                DynamicObject goodsDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmanage");
                goodsDyn.set("id", (Object)row.getLong("id"));
                goodsDyn.set("name", (Object)row.getString("name"));
                goodsDyn.set("number", (Object)row.getString("number"));
                goodsDyn.set("source", (Object)row.getString("source"));
                goodsDyn.set("supplier", (Object)row.getLong("supplier"));
                goodsDynList.add(goodsDyn);
            });
        }
        if (ecGoodsNumbers != null && !ecGoodsNumbers.isEmpty()) {
            String malSlector = "id,name,number,source";
            DynamicObjectCollection ecGoodsPriceEntryCol = QueryServiceHelper.query((String)"pbd_mallgoods", (String)malSlector, (QFilter[])new QFilter[]{new QFilter("number", "in", ecGoodsNumbers)});
            ecGoodsPriceEntryCol.forEach(row -> {
                List goodsDynList = goodsNumberDynMap.computeIfAbsent(row.getString("number"), k -> new ArrayList());
                DynamicObject goodsDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmanage");
                goodsDyn.set("id", (Object)row.getLong("id"));
                goodsDyn.set("name", (Object)row.getString("name"));
                goodsDyn.set("number", (Object)row.getString("number"));
                goodsDyn.set("source", (Object)row.getString("source"));
                goodsDynList.add(goodsDyn);
            });
        }
        return goodsNumberDynMap;
    }

    private Map<Long, List<DynamicObject>> queryGoodsMappingByMaterial(Collection<Long> materialIdList) {
        HashMap<Long, List<DynamicObject>> materialIdMatGoodsDynMap = new HashMap<Long, List<DynamicObject>>(16);
        String selector = "id,platform,goods.id,material.id,ecgoods.id,ecgoods.name,ecgoods.number,ecgoods.source,goods.name,goods.number,goods.source,goods.supplier,goods.mallstatus";
        QFilter qFilter = new QFilter("material.id", "in", materialIdList);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_prodmatmapping", (String)selector, (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                List goodsDynList = materialIdMatGoodsDynMap.computeIfAbsent(row.getLong("material.id"), k -> new ArrayList());
                DynamicObject goodsDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmanage");
                if ("1".equals(row.getString("platform"))) {
                    goodsDyn.set("id", (Object)row.getLong("goods.id"));
                    goodsDyn.set("name", (Object)row.getString("goods.name"));
                    goodsDyn.set("number", (Object)row.getString("goods.number"));
                    goodsDyn.set("source", (Object)row.getString("goods.source"));
                    goodsDyn.set("supplier", (Object)row.getLong("goods.supplier"));
                } else {
                    goodsDyn.set("id", (Object)row.getLong("ecgoods.id"));
                    goodsDyn.set("name", (Object)row.getString("ecgoods.name"));
                    goodsDyn.set("number", (Object)row.getString("ecgoods.number"));
                    goodsDyn.set("source", (Object)row.getString("ecgoods.source"));
                }
                goodsDynList.add(goodsDyn);
            });
        }
        return materialIdMatGoodsDynMap;
    }

    private Map<String, Long> queryMaterialIdByMaterialNumber(Set<String> materialNumberSet) {
        HashMap<String, Long> materialNumberMatIdMap = new HashMap<String, Long>(16);
        if (materialNumberSet.size() == 0) {
            return materialNumberMatIdMap;
        }
        String selector = "id,number";
        QFilter qFilter = new QFilter("number", "in", materialNumberSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)RequestContext.get().getOrgId());
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)selector, (QFilter[])new QFilter[]{qFilter, statusFilter, enableFilter, orgFilter});
        for (DynamicObject material : materials) {
            materialNumberMatIdMap.put(material.getString("number"), material.getLong("id"));
        }
        return materialNumberMatIdMap;
    }

    private Map<String, Long> querySupplierIdBySupplierNumber(Set<String> supplierNumberSet) {
        HashMap<String, Long> supplierNumberMatIdMap = new HashMap<String, Long>(16);
        if (supplierNumberSet.size() == 0) {
            return supplierNumberMatIdMap;
        }
        String selector = "id,number";
        QFilter qFilter = new QFilter("number", "in", supplierNumberSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)selector, (QFilter[])new QFilter[]{qFilter, statusFilter, enableFilter});
        for (DynamicObject supplier : suppliers) {
            supplierNumberMatIdMap.put(supplier.getString("number"), supplier.getLong("id"));
        }
        return supplierNumberMatIdMap;
    }

    private List<Object> createErrorData(Map<Integer, String> row, String error) {
        ArrayList<Object> errorData = new ArrayList<Object>();
        errorData.add(row.get(0));
        errorData.add(row.get(1));
        errorData.add(row.get(2));
        errorData.add(row.get(3));
        errorData.add(row.get(4));
        errorData.add(row.get(5));
        errorData.add(row.get(6));
        errorData.add(row.get(7));
        errorData.add(error);
        return errorData;
    }

    private List<Object> createErrorDataByGoods(DynamicObject goods, String error) {
        ArrayList<Object> errorData = new ArrayList<Object>();
        errorData.add(null);
        errorData.add(null);
        errorData.add(goods.getString("number"));
        errorData.add(goods.getString("name"));
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(error);
        return errorData;
    }

    private List<Object> createNullData() {
        ArrayList<Object> errorData = new ArrayList<Object>();
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        errorData.add(null);
        return errorData;
    }

    public void exportErrorMessage(IFormView view, IPageCache cache, List<List<Object>> rowDatas) {
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u5bfc\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u4fe1\u606f.xlsx", (String)"MalNewShopCartImpExpPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            MalNewShopCartImpExpPlugin.setColumn(excelDataEntity);
            this.setExcelHeader(excelDataEntity);
            this.setEexclBody(excelDataEntity, rowDatas);
            excelDataEntity.setExcelHeaderStyle(1, 4);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"MalNewShopCartImpExpPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.log.error("\u5bfc\u51fa\u5931\u8d25" + e.getMessage());
        }
    }

    private static void setColumn(ExcelDataEntity excelDataEntity) {
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("materialnumber");
        columnList.add("materialname");
        columnList.add("goodsnumber");
        columnList.add("goodsname");
        columnList.add("platform");
        columnList.add("suppliernumber");
        columnList.add("suppliername");
        columnList.add("qty");
        columnList.add("errormessage");
        excelDataEntity.setColumnKeyList(columnList);
    }

    private void setExcelHeader(ExcelDataEntity excelDataEntity) throws IOException {
        ArrayList<String> columnTitle = new ArrayList<String>();
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"MalNewShopCartImpExpPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"MalNewShopCartImpExpPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801", (String)"MalNewShopCartImpExpPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"MalNewShopCartImpExpPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7535\u5546\u5e73\u53f0", (String)"MalNewShopCartImpExpPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"MalNewShopCartImpExpPlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"MalNewShopCartImpExpPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5546\u54c1\u6570\u91cf", (String)"MalNewShopCartImpExpPlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"MalNewShopCartImpExpPlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        excelDataEntity.setExcelHeader(columnTitle);
    }

    private void setEexclBody(ExcelDataEntity excelDataEntity, List<List<Object>> rowDatas) throws IOException {
        int index = 0;
        for (List<Object> rowData : rowDatas) {
            excelDataEntity.createRow(0, index + 1);
            excelDataEntity.setRowValue(0, rowData, index + 1);
            ++index;
        }
    }
}

