/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.service.MalGoodsMonitorLogService;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.ecadmit.MalEcAdmit;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import kd.scm.mal.formplugin.util.MalAddToOftenBuyUtil;
import kd.scm.mal.formplugin.util.MalShopCartUtil;

public class MalNewShopCartPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(MalNewShopCartPlugin.class);
    private static final String CART_GOODS = "cart_goods";
    private static final String CART_ENTRYENTITY = "cart_entryentity";
    private static final String CART_QTY = "cart_qty";
    private static final String CART_PRICE = "cart_price";
    private static final String CART_AMOUNT = "cart_amount";
    private static final String CART_NUMBER = "cart_number";
    private static final String CART_GOODSOURCE = "cart_goodsource";
    private static final String FLEX_MYCARTFLE1 = "mycartfle1";
    private static final String FLEX_OFTENBUYFLEX = "oftenbuyflex";
    private static final String SELECTGROUPBTN = "groupselectallbtn";
    private static final String UNSELECTGROUPBTN = "groupunselectallbtn";
    private static final String MAL_SAVEPURSCHEME = "mal_savepurscheme";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl(CART_ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{FLEX_MYCARTFLE1, FLEX_OFTENBUYFLEX, SELECTGROUPBTN, UNSELECTGROUPBTN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])});
        this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalNewShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("cartcheckall", "true");
        this.getPageCache().put("fromCart", "true");
        this.initCurrency();
        this.initAddress();
        this.allotInitDynamicData();
        this.createPurSchemeLabels();
        this.showInShopCenter();
    }

    private void initCurrency() {
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)defaultCurrency)) {
            this.getModel().setValue("currency", (Object)defaultCurrency);
        }
    }

    private void showInShopCenter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object srcname = customParams.get("srcname");
        IFormView view = this.getView();
        if ("oftenbuy".equals(srcname)) {
            view.setVisible(Boolean.FALSE, new String[]{"searchcontainer", "flexpanelap6", "searchpanel", "header_flex"});
            this.showOftenBuy();
            this.getPageCache().put("cache_isscheme", "1");
            this.getPageCache().put("fromCart", "false");
        } else if ("purscheme".equals(srcname)) {
            String purschemeid = String.valueOf(customParams.get("purschemeid"));
            view.setVisible(Boolean.FALSE, new String[]{"searchcontainer", "flexpanelap6", "searchpanel", "header_flex"});
            if ("NULL".equals(purschemeid)) {
                this.getModel().deleteEntryData(CART_ENTRYENTITY);
                return;
            }
            if (null != purschemeid) {
                this.getPageCache().put("oftencheckall", purschemeid);
                this.getPageCache().put("cartcheckall", null);
                this.getPageCache().put("cache_isscheme", "2");
                this.showPurSchemeInCart(purschemeid);
                this.getPageCache().put("fromCart", "false");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCardMode();
        this.setEnableLadprice();
        this.refreshGroupView();
        this.refreshProtocol();
    }

    private void refreshProtocol() {
        DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        for (int i = 0; i < entryCols.size(); ++i) {
            DynamicObject row = (DynamicObject)entryCols.get(i);
            cardEntry.setChildVisible(!StringUtils.isEmpty((CharSequence)row.getString("cart_protocol")), i, new String[]{"protocolpanelap11", "protocolinfopanelap11"});
        }
    }

    private void setCardMode() {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("k", CART_ENTRYENTITY);
        data.put("cardmode", 1);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", data);
    }

    private void refreshGroupView() {
        this.doShowGroupSelectBtn(false);
        DynamicObjectCollection shopCartDynList = this.getModel().getEntryEntity(CART_ENTRYENTITY);
        if (shopCartDynList.isEmpty()) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        String groupKey = (String)this.getModel().getValue("groupkey");
        String[] groupFields = groupKey.split("_");
        if (groupFields.length > 1) {
            String firstGroupValue = ((DynamicObject)shopCartDynList.get(0)).getString("groupvalue");
            for (int i = 1; i < shopCartDynList.size(); ++i) {
                DynamicObject shopCartDyn = (DynamicObject)shopCartDynList.get(i);
                String groupValue = shopCartDyn.getString("groupvalue");
                if (StringUtils.equals((CharSequence)firstGroupValue, (CharSequence)groupValue)) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"grouppanel"});
                    continue;
                }
                firstGroupValue = groupValue;
            }
        } else {
            cardEntry.setChildVisible(false, -1, new String[]{"grouppanel"});
        }
    }

    private void setEnableLadprice() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        ArrayList<Long> goodsIdSet = new ArrayList<Long>(1024);
        if (!Boolean.parseBoolean(param)) {
            for (DynamicObject row : entrys) {
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
            }
            return;
        }
        for (DynamicObject row : entrys) {
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString(CART_GOODSOURCE))) continue;
            goodsIdSet.add(row.getLong(CART_GOODS));
        }
        Map goodsMap = MalGoods.batchGetLadderPrice(goodsIdSet, (Long)this.getOrgId());
        for (DynamicObject row : entrys) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString(CART_GOODSOURCE))) {
                if (null != goodsMap.get(row.getLong(CART_GOODS))) {
                    cardEntry.setChildVisible(true, row.getInt("seq") - 1, new String[]{"viewladderprice"});
                    continue;
                }
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
                continue;
            }
            cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
        }
    }

    private void initAddress() {
        if (null == this.getPageCache().get("staddress")) {
            Long header_org = (Long)this.getModel().getValue("header_org_id");
            MalReceipt defaultReceipt = ((MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class)).getDefaultReceiptByOrg(header_org);
            if (0L == defaultReceipt.getReceiptId()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u3002", (String)"MalNewShopCartPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            Label labeurge = (Label)this.getView().getControl("labeurge");
            String msg = ResManager.loadKDString((String)"\u914d\u9001\u81f3\uff1a", (String)"MalNewShopCartPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            labeurge.setText(msg + defaultReceipt.getMapAddress());
            this.getPageCache().put("address", String.valueOf(defaultReceipt.getAdmindivisionId()));
            this.getPageCache().put("staddress", String.valueOf(defaultReceipt.getReceiptId()));
        }
    }

    private void allotInitDynamicData() {
        DynamicObjectCollection shopCartDyns = this.queryShopCartDyns();
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(shopCartDyns.size());
        String admindivisionId = this.getPageCache().get("address");
        for (DynamicObject shopCartDyn : shopCartDyns) {
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)shopCartDyn.getLong("goods.id"), (String)shopCartDyn.getString("goodsource"), (BigDecimal)shopCartDyn.getBigDecimal("qty"), (String)admindivisionId, (Long)this.getOrgId());
            param.setCompareId(Long.valueOf(0L));
            malMatGoodsInitParams.add(param);
        }
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
        if (shopCartDyns.size() > 0) {
            this.showEntryList((List<DynamicObject>)shopCartDyns, malGoodsMap);
            MalShopCartUtil.setDefualAcountValue(this.getView());
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"groupkey"});
    }

    private DynamicObjectCollection queryShopCartDyns() {
        String selectFields = this.getSelectFields();
        String orderBy = this.getOrderBy();
        QFilter qFilter = this.queryShopCartDynFilter();
        log.info("orderBy:" + orderBy + System.lineSeparator() + "selectFields:" + selectFields);
        return QueryServiceHelper.query((String)"mal_shopcartbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBy);
    }

    private String getSelectFields() {
        String selectFields = "id,goods.id,goods.source,goods.thumbnail,goods.number,remark,goods.name,goods.model,goodsdesc,stockqty,taxprice,qty,goods.unit.id,taxamount,goodsource,supplier.id,supplier.number supplier,org,billdate,supplier.name";
        String group = (String)this.getModel().getValue("groupkey");
        Object[] groupFields = group.split("_");
        if (groupFields.length > 1) {
            selectFields = selectFields + "," + StringUtils.join((Object[])groupFields, (String)",");
        }
        return selectFields;
    }

    private String getOrderBy() {
        String orderByFromCart;
        String group = (String)this.getModel().getValue("groupkey");
        String[] groupFields = group.split("_");
        String orderBy = "";
        if (groupFields.length > 1) {
            orderBy = groupFields[0];
        }
        if (StringUtils.isNotBlank((CharSequence)(orderByFromCart = (String)this.getModel().getValue("orderby")))) {
            Object[] splits = orderByFromCart.split(",");
            ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(splits));
            splitList.removeIf(str -> StringUtils.isBlank((CharSequence)str));
            splits = splitList.toArray(new String[0]);
            orderBy = !StringUtils.isBlank((CharSequence)orderBy) ? orderBy + "," + StringUtils.join((Object[])splits, (String)",") : StringUtils.join((Object[])splits, (String)",");
        }
        return orderBy;
    }

    private QFilter queryShopCartDynFilter() {
        QFilter qFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId()).and(new QFilter("goods.number", "is not null", null));
        QFilter orgFilter = new QFilter("org", "=", (Object)0L);
        long currentOrgId = this.getOrgId();
        orgFilter.or(new QFilter("org", "=", (Object)currentOrgId));
        qFilter.and(orgFilter);
        return qFilter;
    }

    private long getOrgId() {
        long orgId = RequestContext.get().getOrgId();
        if (this.getModel().getValue("header_org") != null) {
            DynamicObject purchaseOrg = (DynamicObject)this.getModel().getValue("header_org");
            orgId = purchaseOrg.getLong("id");
        }
        return orgId;
    }

    private void showEntryList(List<DynamicObject> shopcartDynList, Map<Long, MalGoods> malGoodsMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        shopcartDynList = this.handleGroup(shopcartDynList, malGoodsMap, selfInventoryUnlimited);
        int index = 0;
        for (int i = 0; i < shopcartDynList.size(); ++i) {
            DynamicObject shopcartDyn = shopcartDynList.get(i);
            Long goodsId = shopcartDyn.getLong("goods.id");
            MalGoods malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null) continue;
            this.setVsShopCart(malGoods, shopcartDyn, index, vs, selfInventoryUnlimited);
            ++index;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(CART_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(CART_ENTRYENTITY);
    }

    private LinkedList<DynamicObject> handleGroup(List<DynamicObject> shopcartDynList, Map<Long, MalGoods> malGoodsMap, boolean selfInventoryUnlimited) {
        Map<String, Set<Long>> differentColMap = this.getDifferentColMap(shopcartDynList, malGoodsMap, selfInventoryUnlimited);
        Set<Long> downGoodsIds = differentColMap.get("down");
        Set<Long> noStockGoodsIds = differentColMap.get("nostock");
        Set<Long> noSoldGoodsIds = differentColMap.get("nosold");
        LinkedHashMap groupToShopcartDynListMap = new LinkedHashMap();
        String group = (String)this.getModel().getValue("groupkey");
        String[] groupFields = group.split("_");
        if (groupFields.length > 1) {
            for (DynamicObject shopcartDyn : shopcartDynList) {
                Object groupValue = shopcartDyn.get(groupFields[0]);
                LinkedList<DynamicObject> groupToShopcartDynList = groupToShopcartDynListMap.getOrDefault(groupValue, new LinkedList());
                groupToShopcartDynList.add(shopcartDyn);
                groupToShopcartDynListMap.put(groupValue, groupToShopcartDynList);
            }
        } else {
            groupToShopcartDynListMap.put(" ", new LinkedList<DynamicObject>(shopcartDynList));
        }
        LinkedList<DynamicObject> groupSortShopCartDynList = new LinkedList<DynamicObject>();
        ArrayList notGroupSortCartDynList = new ArrayList(shopcartDynList.size());
        for (Map.Entry groupShopCartListEntry : groupToShopcartDynListMap.entrySet()) {
            ArrayList<DynamicObject> downGoodsShopCartList = new ArrayList<DynamicObject>(((LinkedList)groupShopCartListEntry.getValue()).size());
            ArrayList<DynamicObject> noStockShopCartList = new ArrayList<DynamicObject>(((LinkedList)groupShopCartListEntry.getValue()).size());
            ArrayList<DynamicObject> noSoldShopCartList = new ArrayList<DynamicObject>(((LinkedList)groupShopCartListEntry.getValue()).size());
            for (DynamicObject shopCartDyn : (LinkedList)groupShopCartListEntry.getValue()) {
                if (downGoodsIds.contains(shopCartDyn.getLong("goods.id"))) {
                    downGoodsShopCartList.add(shopCartDyn);
                }
                if (noStockGoodsIds.contains(shopCartDyn.getLong("goods.id"))) {
                    noStockShopCartList.add(shopCartDyn);
                }
                if (!noSoldGoodsIds.contains(shopCartDyn.getLong("goods.id"))) continue;
                noSoldShopCartList.add(shopCartDyn);
            }
            ((LinkedList)groupShopCartListEntry.getValue()).removeAll(downGoodsShopCartList);
            for (DynamicObject shopCartDyn : downGoodsShopCartList) {
                ((LinkedList)groupShopCartListEntry.getValue()).addLast(shopCartDyn);
            }
            ((LinkedList)groupShopCartListEntry.getValue()).removeAll(noStockShopCartList);
            for (DynamicObject shopCartDyn : noStockShopCartList) {
                ((LinkedList)groupShopCartListEntry.getValue()).addLast(shopCartDyn);
            }
            ((LinkedList)groupShopCartListEntry.getValue()).removeAll(noSoldShopCartList);
            for (DynamicObject shopCartDyn : noSoldShopCartList) {
                ((LinkedList)groupShopCartListEntry.getValue()).addLast(shopCartDyn);
            }
            if (ObjectUtils.isEmpty(groupShopCartListEntry.getKey()) || groupShopCartListEntry.getKey().toString().equals("0")) {
                notGroupSortCartDynList.addAll((Collection)groupShopCartListEntry.getValue());
                continue;
            }
            groupSortShopCartDynList.addAll((Collection)groupShopCartListEntry.getValue());
        }
        groupSortShopCartDynList.addAll(notGroupSortCartDynList);
        return groupSortShopCartDynList;
    }

    private Map<String, Set<Long>> getDifferentColMap(List<DynamicObject> shopcartDynList, Map<Long, MalGoods> malGoodsMap, boolean selfInventoryUnlimited) {
        HashSet<Long> downGoodsIds = new HashSet<Long>(16);
        HashSet<Long> noStockGoodsIds = new HashSet<Long>(16);
        HashSet<Long> noSoldGoodsIds = new HashSet<Long>(16);
        for (int i = 0; i < shopcartDynList.size(); ++i) {
            DynamicObject shopcartDyn = shopcartDynList.get(i);
            Long goodsId = shopcartDyn.getLong("goods.id");
            MalGoods malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null) continue;
            String desc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewShopCartPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            String stockDesc = this.getStockDesc(malGoods, selfInventoryUnlimited);
            String goodsource = shopcartDyn.getString("goods.source");
            if (!malGoods.validateOrgSaleable(Long.valueOf(this.getOrgId()))) {
                noSoldGoodsIds.add(goodsId);
                continue;
            }
            if (!malGoods.validateMallStatus()) {
                downGoodsIds.add(goodsId);
                continue;
            }
            if ((!desc.equals(stockDesc) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource)) && (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) || malGoods.validateStock(BigDecimal.ONE))) continue;
            noStockGoodsIds.add(goodsId);
        }
        HashMap<String, Set<Long>> returnMap = new HashMap<String, Set<Long>>(16);
        returnMap.put("nostock", noStockGoodsIds);
        returnMap.put("down", downGoodsIds);
        returnMap.put("nosold", noSoldGoodsIds);
        return returnMap;
    }

    private void setVsShopCart(MalGoods malGoods, DynamicObject shopcartDyn, int i, TableValueSetter vs, boolean selfInventoryUnlimited) {
        String group = (String)this.getModel().getValue("groupkey");
        String[] groupFields = group.split("_");
        if (group.split("_").length > 1) {
            vs.set("groupvalue", shopcartDyn.get(groupFields[0]), i);
            vs.set("groupname", shopcartDyn.get(groupFields[1]), i);
        }
        BigDecimal shopcartPrice = shopcartDyn.getBigDecimal("taxprice");
        Long goodsId = shopcartDyn.getLong("goods.id");
        vs.set("cart_pk", shopcartDyn.get("id"), i);
        vs.set(CART_GOODS, (Object)Long.parseLong(malGoods.getProductId()), i);
        vs.set("goods_id", (Object)Long.parseLong(malGoods.getProductId()), i);
        vs.set(CART_NUMBER, (Object)malGoods.getNumber(), i);
        if (BigDecimal.ZERO.compareTo(malGoods.getPriceChange()) != 0) {
            String str;
            DynamicObject currObj = (DynamicObject)this.getModel().getDataEntity(true).get("currency");
            if (malGoods.priceChange(shopcartPrice).compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal reducePrice = malGoods.getPriceChange().setScale(currObj.getInt("priceprecision"), 4).abs();
                str = ResManager.loadKDString((String)"\u6bd4\u52a0\u5165\u65f6\u964d\uffe5", (String)"MalNewShopCartPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                vs.set("cart_pricedesc", (Object)(str + reducePrice), i);
            }
            if (malGoods.priceChange(shopcartPrice).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal risePrice = malGoods.getPriceChange().setScale(currObj.getInt("priceprecision"), 4);
                str = ResManager.loadKDString((String)"\u6bd4\u52a0\u5165\u65f6\u6da8\uffe5", (String)"MalNewShopCartPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                vs.set("cart_pricedesc", (Object)(str + risePrice), i);
            }
        }
        vs.set(CART_PRICE, (Object)malGoods.getTaxPrice(), i);
        this.fillGoodsStockQty(malGoods, selfInventoryUnlimited, vs, i);
        vs.set("cart_taxrate", (Object)malGoods.getTaxrateId(), i);
        vs.set("cart_protocol", (Object)malGoods.getProtocolBillno(), i);
        vs.set("cart_desc", (Object)malGoods.getModel(), i);
        vs.set("cart_pic", (Object)malGoods.getThumbnail(), i);
        vs.set("cart_name", (Object)malGoods.getName(), i);
        vs.set(CART_QTY, (Object)shopcartDyn.getBigDecimal("qty"), i);
        vs.set("cart_unit", (Object)malGoods.getProductUnitID(), i);
        vs.set("unit", (Object)malGoods.getProductUnitID(), i);
        vs.set("cart_leadtime", (Object)malGoods.getLeadtime(), i);
        vs.set(CART_AMOUNT, (Object)shopcartDyn.getBigDecimal("qty").multiply(malGoods.getTaxPrice()), i);
        vs.set(CART_GOODSOURCE, shopcartDyn.get("goodsource"), i);
        vs.set("cart_supplier", shopcartDyn.get("supplier.id"), i);
        vs.set("cart_minorderqty", (Object)malGoods.getMinOrderQty(), i);
        if (null == malGoods.getComparePrices() || malGoods.getComparePrices().size() == 0) {
            vs.set("cart_compareresult", (Object)ResManager.loadKDString((String)"\u672a\u6bd4\u4ef7", (String)"MalNewShopCartPlugin_32", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
        } else {
            List comparePrices = malGoods.getComparePrices();
            boolean isLowPrice = false;
            for (ComparePriceInfo priceInfo : comparePrices) {
                if (!priceInfo.getGoodsId().equals(goodsId) || !priceInfo.getCompareResult().equals("1")) continue;
                isLowPrice = true;
            }
            if (isLowPrice) {
                vs.set("cart_compareresult", (Object)ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7", (String)"MalNewShopCartPlugin_33", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            } else {
                vs.set("cart_compareresult", (Object)ResManager.loadKDString((String)"\u975e\u6700\u4f4e\u4ef7", (String)"MalNewShopCartPlugin_34", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            }
        }
        this.setGoodsStatus(malGoods, vs, i);
    }

    private void setGoodsStatus(MalGoods malGoods, TableValueSetter vs, int i) {
        if (!malGoods.validateOrgSaleable(Long.valueOf(this.getOrgId()))) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u552e", (String)"MalNewShopCartPlugin_45", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            return;
        }
        if (!malGoods.validateMallStatus()) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalNewShopCartPlugin_44", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            return;
        }
        String goodsource = malGoods.getProductSource();
        String stockDesc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewShopCartPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        String desc = String.valueOf(vs.get("cart_stock_qty", i));
        if (desc.equals(stockDesc) && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) && !malGoods.validateStock(BigDecimal.ONE)) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalNewShopCartPlugin_43", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
        }
    }

    private void fillGoodsStockQty(MalGoods malGoods, boolean selfInventoryUnlimited, TableValueSetter vs, int i) {
        String desc;
        String stockDesc = this.getStockDesc(malGoods, selfInventoryUnlimited);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && (desc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewShopCartPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0])).equals(stockDesc)) {
            vs.set("cart_isinventorylimited", (Object)"1", i);
        }
        vs.set("cart_stock_qty", (Object)stockDesc, i);
    }

    private String getStockDesc(MalGoods malGoods, boolean selfInventoryUnlimited) {
        String stockDesc = malGoods.getStockDesc();
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            if ("".equals(stockDesc)) {
                stockDesc = ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalNewShopCartPlugin_38", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            } else {
                BigDecimal stockQty = new BigDecimal(stockDesc);
                if (stockQty.compareTo(BigDecimal.ZERO) <= 0) {
                    stockDesc = selfInventoryUnlimited ? ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalNewShopCartPlugin_38", (String)"scm-mal-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewShopCartPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return stockDesc;
    }

    private void showPurSchemeInCart(String purSchemeId) {
        this.getModel().deleteEntryData(CART_ENTRYENTITY);
        DynamicObjectCollection querySchemeInCart = this.querySchemeInCart(purSchemeId);
        if (querySchemeInCart.size() > 0) {
            long currentOrgId = this.getOrgId();
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(querySchemeInCart.size());
            String addressId = this.getPageCache().get("address");
            for (DynamicObject schemeDyn : querySchemeInCart) {
                malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku((Long)schemeDyn.getLong("goods.id"), (String)schemeDyn.getString("goodsentry.goods.number"), (String)schemeDyn.getString("goods.source"), (BigDecimal)BigDecimal.ONE, (String)addressId, (Long)currentOrgId));
            }
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            this.showPurScheme(querySchemeInCart, malGoodsMap);
        }
        MalShopCartUtil.setDefualAcountValue(this.getView());
        this.getPageCache().put("cache_schemeid", purSchemeId);
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        for (int i = 0; i < querySchemeInCart.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"protocolpanelap11", "protocolinfopanelap11"});
        }
        cardEntry.setChildVisible(false, -1, new String[]{"grouppanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"groupkey"});
        this.getView().updateView();
    }

    private DynamicObjectCollection querySchemeInCart(String purSchemeId) {
        String selectFields = "goodsentry.goods.id goods.id,goodsentry.goods.number,goodsentry.goods.thumbnail,goodsentry.goods.name,goodsentry.goods.description,goodsentry.goods.model,goodsentry.goods.remark,goodsentry.goods.source goods.source,goodsentry.goods.supplier.id,goodsentry.goods.unit.id,goodsentry.goods.taxrate,goodsentry.goods.price,goodsentry.goods.shopprice,goodsentry.qty,goodsentry.note goodsdesc";
        Long id = purSchemeId == null ? 0L : Long.parseLong(purSchemeId);
        return QueryServiceHelper.query((String)"mal_purscheme", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, (String)"goodsentry.goods.supplier.id,goodsentry.goods.number asc");
    }

    private void showPurScheme(DynamicObjectCollection querySchemeInCart, Map<Long, MalGoods> malGoodsMap) {
        MalGoods malGoods;
        Long goodsId;
        DynamicObject shopcartDyn;
        int i;
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map<String, Set<Long>> differentColMap = this.getDifferentColMap((List<DynamicObject>)querySchemeInCart, malGoodsMap, selfInventoryUnlimited);
        Set<Long> downGoodsIds = differentColMap.get("down");
        Set<Long> noStockGoodsIds = differentColMap.get("nostock");
        Set<Long> noSoldGoodsIds = differentColMap.get("nosold");
        int index = 0;
        for (i = 0; i < querySchemeInCart.size(); ++i) {
            shopcartDyn = (DynamicObject)querySchemeInCart.get(i);
            goodsId = shopcartDyn.getLong("goods.id");
            malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null || noSoldGoodsIds.contains(goodsId) || downGoodsIds.contains(goodsId) || noStockGoodsIds.contains(goodsId)) continue;
            this.setVsSchemeCart(malGoods, shopcartDyn, index, vs, selfInventoryUnlimited);
            ++index;
        }
        for (i = 0; i < querySchemeInCart.size(); ++i) {
            shopcartDyn = (DynamicObject)querySchemeInCart.get(i);
            goodsId = shopcartDyn.getLong("goods.id");
            malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null || !noSoldGoodsIds.contains(goodsId)) continue;
            this.setVsSchemeCart(malGoods, shopcartDyn, index, vs, selfInventoryUnlimited);
            ++index;
        }
        for (i = 0; i < querySchemeInCart.size(); ++i) {
            shopcartDyn = (DynamicObject)querySchemeInCart.get(i);
            goodsId = shopcartDyn.getLong("goods.id");
            malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null || !downGoodsIds.contains(goodsId)) continue;
            this.setVsSchemeCart(malGoods, shopcartDyn, index, vs, selfInventoryUnlimited);
            ++index;
        }
        for (i = 0; i < querySchemeInCart.size(); ++i) {
            shopcartDyn = (DynamicObject)querySchemeInCart.get(i);
            goodsId = shopcartDyn.getLong("goods.id");
            malGoods = malGoodsMap.get(goodsId);
            if (malGoods == null || !noStockGoodsIds.contains(goodsId)) continue;
            this.setVsSchemeCart(malGoods, shopcartDyn, index, vs, selfInventoryUnlimited);
            ++index;
        }
        model.batchCreateNewEntryRow(CART_ENTRYENTITY, vs);
    }

    private void setVsSchemeCart(MalGoods malGoods, DynamicObject schemeDyn, int i, TableValueSetter vs, boolean selfInventoryUnlimited) {
        String source = schemeDyn.getString("goods.source");
        Long goodsId = schemeDyn.getLong("goods.id");
        String sku = schemeDyn.getString("goodsentry.goods.number");
        this.fillGoodsStockQty(malGoods, selfInventoryUnlimited, vs, i);
        vs.set("cart_desc", schemeDyn.get("goodsentry.goods.model"), i);
        vs.set(CART_PRICE, (Object)malGoods.getTaxPrice(), i);
        vs.set("cart_pk", (Object)goodsId, i);
        vs.set(CART_GOODS, (Object)goodsId, i);
        vs.set("goods_id", (Object)goodsId, i);
        vs.set(CART_NUMBER, (Object)sku, i);
        vs.set("cart_pic", schemeDyn.get("goodsentry.goods.thumbnail"), i);
        vs.set("cart_name", schemeDyn.get("goodsentry.goods.name"), i);
        vs.set(CART_QTY, (Object)schemeDyn.getBigDecimal("goodsentry.qty"), i);
        vs.set("cart_unit", schemeDyn.get("goodsentry.goods.unit.id"), i);
        vs.set("unit", schemeDyn.get("goodsentry.goods.unit.id"), i);
        vs.set("cart_leadtime", (Object)malGoods.getLeadtime(), i);
        BigDecimal amount = schemeDyn.getBigDecimal("goodsentry.qty").multiply(malGoods.getTaxPrice());
        vs.set(CART_AMOUNT, (Object)amount, i);
        vs.set(CART_GOODSOURCE, (Object)source, i);
        vs.set("cart_supplier", schemeDyn.get("goodsentry.goods.supplier.id"), i);
        vs.set("cart_minorderqty", (Object)malGoods.getMinOrderQty(), i);
        if (!malGoods.validateOrgSaleable(Long.valueOf(RequestContext.get().getOrgId()))) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u552e", (String)"MalNewShopCartPlugin_45", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            return;
        }
        if (!malGoods.validateMallStatus()) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalNewShopCartPlugin_44", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            return;
        }
        String goodsource = malGoods.getProductSource();
        String stockDesc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalNewShopCartPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        String desc = String.valueOf(vs.get("cart_stock_qty", i));
        if (desc.equals(stockDesc) && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) && !malGoods.validateStock(BigDecimal.ONE)) {
            vs.set("cart_goodsstatus", (Object)1, i);
            vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalNewShopCartPlugin_43", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
        }
    }

    private DynamicObjectCollection getPurSchemes() {
        QFilter qfilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return QueryServiceHelper.query((String)"mal_purscheme", (String)"id,number,name", (QFilter[])new QFilter[]{qfilter}, (String)"modifytime desc");
    }

    private void createPurSchemeLabels() {
        String enablePurscheme = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"enable_purscheme");
        if (Boolean.parseBoolean(enablePurscheme)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"del_purscheme"});
            return;
        }
        DynamicObjectCollection purSchemeDyns = this.getPurSchemes();
        Container purSchemeFlexAp = (Container)this.getView().getControl("purschemeflexap");
        purSchemeFlexAp.deleteControls(new String[]{this.getPageCache().get("cache_schemeid")});
        ArrayList<Map> list = new ArrayList<Map>();
        Style style = new Style();
        String color = "#666666";
        LabelAp labelAp = new LabelAp();
        int count = 0;
        for (DynamicObject dyn : purSchemeDyns) {
            purSchemeFlexAp.deleteControls(new String[]{dyn.getString("id")});
            if (count >= 5 || ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalNewShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]).equals(dyn.getString("name"))) continue;
            labelAp.setId(dyn.getString("id"));
            labelAp.setClickable(true);
            labelAp.setName(new LocaleString(dyn.getString("name")));
            labelAp.setKey(dyn.getString("id"));
            labelAp.setFontSize(14);
            labelAp.setForeColor(color);
            labelAp.setWidth(new LocaleString("136px"));
            labelAp.setLineHeight("31px");
            labelAp.setStyle(style);
            labelAp.setTextAlign("center");
            list.add(labelAp.createControl());
            ++count;
        }
        purSchemeFlexAp.addControls(list);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        Boolean flas = Boolean.FALSE;
        String schemeId = this.getPageCache().get("cache_schemeid");
        String isscheme = this.getPageCache().get("cache_isscheme");
        if (StringUtils.equals((CharSequence)this.getPageCache().get("delete_key"), (CharSequence)"batchdelete")) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)isscheme) || StringUtils.equals((CharSequence)"2", (CharSequence)isscheme)) {
                String[] goodsId = this.getPageCache().get("cache_goodsid").split(",");
                flas = MalShopCartUtil.realDeleteSchemeData(this.getView(), schemeId, goodsId);
            } else {
                MalShopCartUtil.realDeleteData(this.getPageCache().get("slectPks").split(","));
            }
            MalShopCartUtil.updateAcountValue(this.getView(), new int[0]);
        }
        if (flas.booleanValue() && StringUtils.equals((CharSequence)"2", (CharSequence)isscheme)) {
            this.delScheme();
        } else {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(CART_ENTRYENTITY);
            cardEntry.selectRows(new int[0], 0);
        }
        this.getView().updateView();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        if (CART_ENTRYENTITY.equals(grid.getKey())) {
            Control entryentity = this.getView().getControl(CART_ENTRYENTITY);
            int[] selectedIndexs = MalShopCartUtil.getSelectIndex(entryentity);
            MalShopCartUtil.updateAcountValue(this.getView(), selectedIndexs);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("acountnew".equals(operateKey)) {
            this.openMakeOrderPage();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "refreshcart": {
                this.refresh();
                break;
            }
            case "deleteselectentry": {
                this.getPageCache().put("delete_key", "batchdelete");
                ConfirmCallBackListener confir = new ConfirmCallBackListener("key_deleteselect", (IFormPlugin)this);
                MalShopCartUtil.deleteSelectedEntry(this.getView(), confir);
                break;
            }
            case "acountnew": {
                this.checkAccountNew(event);
                break;
            }
            case "save_purscheme": {
                this.savePurScheme();
                break;
            }
            case "add2oftenbuy": {
                this.add2Oftenbuy();
                break;
            }
            case "understock": {
                this.underStock();
                break;
            }
            case "delscheme": {
                this.delScheme();
                break;
            }
            case "checkall": {
                this.checkall();
                break;
            }
            case "staddress": {
                this.modifyReceipt();
                break;
            }
        }
    }

    private void checkAccountNew(BeforeDoOperationEventArgs event) {
        if (null != this.getPageCache().get("continue")) {
            this.getPageCache().remove("continue");
            return;
        }
        Control entryentity = this.getView().getControl(CART_ENTRYENTITY);
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(entryentity);
        if (selectedIndexs.length > 0) {
            DynamicObjectCollection shopcartDynCol = MalShopCartUtil.getSelectedDyObject(selectedIndexs, entryentity);
            HashMap<String, List<String>> sourceCartsGoodsIdMap = new HashMap<String, List<String>>(8);
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(shopcartDynCol.size());
            HashMap<Long, BigDecimal> goodsIdToQtyMap = new HashMap<Long, BigDecimal>();
            String admindivisionId = this.getPageCache().get("address");
            for (DynamicObject dyn : shopcartDynCol) {
                DynamicObject supplier = (DynamicObject)dyn.get("cart_supplier");
                if (null == supplier) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u7535\u5546\u4f9b\u5e94\u5546\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7535\u5546\u6388\u6743\u3002", (String)"MalNewShopCartPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                List sourceCartGoodsIdList = sourceCartsGoodsIdMap.computeIfAbsent(dyn.getString(CART_GOODSOURCE), s -> new ArrayList());
                sourceCartGoodsIdList.add(dyn.getString(CART_GOODS));
                MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)dyn.getLong(CART_GOODS), (String)dyn.getString(CART_GOODSOURCE), (BigDecimal)dyn.getBigDecimal(CART_QTY), (String)admindivisionId, (Long)this.getOrgId());
                param.setCompareId(Long.valueOf(0L));
                malMatGoodsInitParams.add(param);
                goodsIdToQtyMap.put(dyn.getLong(CART_GOODS), dyn.getBigDecimal(CART_QTY));
            }
            if (!this.validateEcSkuLimitNum(sourceCartsGoodsIdMap)) {
                event.setCancel(true);
                return;
            }
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            if (!this.validateGoods(malGoodsMap, goodsIdToQtyMap)) {
                event.setCancel(true);
                return;
            }
            if (!this.validateMalGoodsMonitorRule(malGoodsMap)) {
                event.setCancel(true);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalNewShopCartPlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    private boolean validateGoods(Map<Long, MalGoods> malGoodsMap, Map<Long, BigDecimal> goodsIdToQtyMap) {
        MalPlaceOrderValidateResult malPlaceOrderValidateResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).validateGoodsForPlaceOrder(goodsIdToQtyMap, malGoodsMap, true, RequestContext.get().getOrgId());
        if (!malPlaceOrderValidateResult.getErrorInfos().isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002", (String)"MalNewShopCartPlugin_49", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg, String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private boolean validateMalGoodsMonitorRule(Map<Long, MalGoods> malGoodsMap) {
        MalGoodsMonitorLogService malGoodsMonitorLogService;
        Collection goodsMonitorLogs;
        ArrayList<String> goodIds = new ArrayList<String>(16);
        ArrayList<Long> goodsPoolIds = new ArrayList<Long>(16);
        for (Map.Entry<Long, MalGoods> map : malGoodsMap.entrySet()) {
            MalGoods malGoods = map.getValue();
            if (null == malGoods) continue;
            goodIds.add(malGoods.getProductId());
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) continue;
            goodsPoolIds.add(malGoods.getGoodsInfo().getProdPoolId());
        }
        if (goodIds.size() > 0 && (goodsMonitorLogs = (malGoodsMonitorLogService = new MalGoodsMonitorLogService()).getGoodsMonitorLogs(goodIds, goodsPoolIds)) != null && goodsMonitorLogs.size() > 0) {
            String disableDeatialMsg = malGoodsMonitorLogService.getDisableDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)disableDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u7981\u6b62\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 \u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalNewShopCartPlugin_40", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, disableDeatialMsg, MessageTypes.Default);
                return false;
            }
            String notifyDeatialMsg = malGoodsMonitorLogService.getNotifyDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)notifyDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalNewShopCartPlugin_41", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u4e0b\u5355", (String)"MalNewShopCartPlugin_42", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, notifyDeatialMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("notifymsg", (IFormPlugin)this), btnNameMaps);
                return false;
            }
        }
        return true;
    }

    private void modifyReceipt() {
        Long header_org = (Long)this.getModel().getValue("header_org_id");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("mal_receiptlist");
        param.setCaption(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f\u5217\u8868", (String)"MalNewShopCartPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_receiptlist"));
        param.setCustomParam("query_org", (Object)String.valueOf(header_org));
        this.getView().showForm(param);
    }

    private void delScheme() {
        String isScheme = this.getPageCache().get("cache_isscheme");
        String cacheSchemeId = this.getPageCache().get("cache_schemeid");
        if (StringUtils.isEmpty((CharSequence)cacheSchemeId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5957\u9910\u3002", (String)"MalNewShopCartPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        long schemeId = Long.parseLong(cacheSchemeId);
        if (null != isScheme && !"0".equals(isScheme) && !"1".equals(isScheme)) {
            DeleteServiceHelper.delete((String)"mal_purscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getPageCache().get("cache_schemeid")});
            this.getPageCache().put("cache_isscheme", "0");
            this.getPageCache().put("cache_schemeid", null);
            this.setIsClicking(FLEX_MYCARTFLE1, false, "themeColor", "themeColor", "themeColor");
            this.refresh();
            this.getPageCache().put("cartcheckall", "true");
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5957\u9910\u3002", (String)"MalNewShopCartPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void add2Oftenbuy() {
        Control entryentity = this.getView().getControl(CART_ENTRYENTITY);
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(entryentity);
        if (selectedIndexs.length > 0) {
            DynamicObjectCollection dyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, entryentity);
            List prodIdList = MalProductUtil.getListByProperty((DynamicObjectCollection)dyObject, (String)CART_GOODS);
            List prodNumberList = MalProductUtil.checkProdSupplierStates((List)prodIdList);
            if (prodNumberList.size() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalNewShopCartPlugin_27", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalNewShopCartPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + String.join((CharSequence)",", prodNumberList), MessageTypes.Default);
                return;
            }
            if (MalAddToOftenBuyUtil.add(prodIdList)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6dfb\u52a0\u6211\u7684\u5e38\u4e70\u6210\u529f\u3002", (String)"MalNewShopCartPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6dfb\u52a0\u6211\u7684\u5e38\u4e70\u5931\u8d25\u3002", (String)"MalNewShopCartPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalNewShopCartPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void showOftenBuy() {
        DynamicObject oftenbuyDyn = MalShopCartUtil.getOftenBuy();
        if (oftenbuyDyn == null) {
            this.getPageCache().put("myoften", null);
            this.getModel().deleteEntryData(CART_ENTRYENTITY);
            this.getView().updateView();
            return;
        }
        this.getPageCache().put("myoften", oftenbuyDyn.getString("id"));
        this.showPurSchemeInCart(oftenbuyDyn.getString("id"));
        this.getPageCache().put("oftencheckall", oftenbuyDyn.getString("id"));
        this.getPageCache().put("cartcheckall", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        MalShopCartUtil.updateQty(e, this.getModel(), e.getProperty().getName(), this.getView());
        if (StringUtils.equals((CharSequence)"header_org", (CharSequence)fieldKey)) {
            this.refresh();
        }
        if (StringUtils.equals((CharSequence)"groupkey", (CharSequence)e.getProperty().getName())) {
            this.refresh();
        }
    }

    private void checkall() {
        int entryRowCount = this.getModel().getEntryRowCount(CART_ENTRYENTITY);
        int[] intArray = new int[entryRowCount];
        for (int i = 0; i < entryRowCount; ++i) {
            intArray[i] = i;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(CART_ENTRYENTITY);
        String or = this.getPageCache().get("or");
        if (StringUtils.isNotBlank((CharSequence)or) && Integer.parseInt(or) == 1) {
            cardEntry.selectRows(new int[0], 0);
            this.getPageCache().put("or", null);
            MalShopCartUtil.updateAcountValue(this.getView(), new int[0]);
            this.doShowGroupSelectBtn(false);
        } else {
            cardEntry.selectRows(intArray, 0);
            this.getPageCache().put("or", "1");
            this.doShowGroupSelectBtn(true);
        }
    }

    private void underStock() {
        DynamicObjectCollection query = this.queryShopCartDyns();
        if (query.isEmpty()) {
            return;
        }
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
        String admindivisionId = this.getPageCache().get("address");
        long orgId = this.getOrgId();
        for (DynamicObject dyn : query) {
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam((Long)dyn.getLong("goods.id"), (String)dyn.getString("goodsource"), (BigDecimal)dyn.getBigDecimal("qty"), (String)admindivisionId, (Long)orgId));
        }
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        Map<String, Set<Long>> differentColMap = this.getDifferentColMap((List<DynamicObject>)query, malGoodsMap, selfInventoryUnlimited);
        ArrayList<Long> delGoodsIds = new ArrayList<Long>();
        for (Set<Long> invalidGoodsIdSet : differentColMap.values()) {
            delGoodsIds.addAll(invalidGoodsIdSet);
        }
        if (!delGoodsIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"mal_shopcartbill", (QFilter[])new QFilter[]{new QFilter("goods", "in", delGoodsIds).and(this.queryShopCartDynFilter())});
            this.refresh();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        int i;
        CardEntry cardEntry;
        DynamicObjectCollection entryCols;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        IPageCache pageCache = this.getPageCache();
        if (source.getKey().equalsIgnoreCase(FLEX_MYCARTFLE1)) {
            this.getPageCache().put("cartcheckall", "true");
            this.getPageCache().put("oftencheckall", null);
            this.getPageCache().put("cache_isscheme", "0");
            this.getPageCache().put("cache_schemeid", null);
            this.refresh();
            this.cancelClicking();
            this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalNewShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            pageCache.put("fromCart", "true");
            this.setIsClicking(FLEX_MYCARTFLE1, false, "themeColor", "themeColor", "themeColor");
            this.setIsClicking(FLEX_OFTENBUYFLEX, false, "#666666", "#666666", "#ffffff");
            this.getView().setVisible(Boolean.TRUE, new String[]{"comparepricelable"});
            entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
            cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
            for (i = 0; i < entryCols.size(); ++i) {
                cardEntry.setChildVisible(true, i, new String[]{"comprice"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"compriceflex"});
            pageCache.put("cache_isscheme", "0");
        }
        if (source.getKey().equalsIgnoreCase(FLEX_OFTENBUYFLEX)) {
            this.showOftenBuy();
            this.cancelClicking();
            this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalNewShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            pageCache.put("fromCart", "false");
            this.setIsClicking(FLEX_OFTENBUYFLEX, false, "themeColor", "themeColor", "themeColor");
            this.setIsClicking(FLEX_MYCARTFLE1, false, "#666666", "#666666", "#ffffff");
            entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
            cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
            for (i = 0; i < entryCols.size(); ++i) {
                cardEntry.setChildVisible(false, i, new String[]{"comprice"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"compriceflex"});
            pageCache.put("cache_isscheme", "1");
            this.getView().updateView();
        }
        DynamicObjectCollection purSchemes = MalShopCartUtil.getPurSchemes();
        String selectedPurSchemeId = "";
        for (DynamicObject dyn : purSchemes) {
            String purSchemeId = dyn.getString("id");
            if (source.getKey().equals(purSchemeId)) {
                selectedPurSchemeId = purSchemeId;
                continue;
            }
            this.setIsClicking(dyn.getString("id"), false, "#666666", "#666666", "#ffffff");
        }
        if (StringUtils.isNotEmpty((CharSequence)selectedPurSchemeId)) {
            this.showSelectedPurScheme(selectedPurSchemeId);
        }
        this.getPageCache().put("or", null);
        this.getPageCache().put("cart", null);
    }

    private void showSelectedPurScheme(String purSchemeId) {
        this.showPurSchemeInCart(purSchemeId);
        this.setIsClicking(purSchemeId, true, "themeColor", "themeColor", "themeColor");
        this.setIsClicking(FLEX_MYCARTFLE1, false, "#666666", "#666666", "#ffffff");
        this.setIsClicking(FLEX_OFTENBUYFLEX, false, "#666666", "#666666", "#ffffff");
        this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalNewShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        for (int i = 0; i < entryCols.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"comprice"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"compriceflex"});
        this.getView().getPageCache().put("cache_isscheme", "2");
        this.getView().getPageCache().put("fromCart", "false");
        this.getView().getPageCache().put("oftencheckall", purSchemeId);
        this.getView().getPageCache().put("cartcheckall", null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(CART_ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        switch (key) {
            case "groupselectallbtn": {
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), index, new String[]{UNSELECTGROUPBTN});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{SELECTGROUPBTN});
                this.doSelectGroup(index, true);
                this.updateAcount();
                break;
            }
            case "groupunselectallbtn": {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{UNSELECTGROUPBTN});
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), index, new String[]{SELECTGROUPBTN});
                this.doSelectGroup(index, false);
                this.updateAcount();
                break;
            }
        }
    }

    private void updateAcount() {
        Control entryentity = this.getView().getControl(CART_ENTRYENTITY);
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(entryentity);
        MalShopCartUtil.updateAcountValue(this.getView(), selectedIndexs);
    }

    private void doSelectGroup(Integer row, boolean isSelect) {
        DynamicObjectCollection shopCartDynCol = this.getModel().getEntryEntity(CART_ENTRYENTITY);
        DynamicObject groupData = (DynamicObject)shopCartDynCol.get(row.intValue());
        String groupKey = groupData.getString("groupvalue");
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        List selectRowsIndexList = Arrays.stream(cardEntry.getSelectRows()).boxed().collect(Collectors.toList());
        Integer i = row;
        while (i < shopCartDynCol.size()) {
            DynamicObject shopCartDyn = (DynamicObject)shopCartDynCol.get(i.intValue());
            if (StringUtils.equals((CharSequence)groupKey, (CharSequence)shopCartDyn.getString("groupvalue"))) {
                if (isSelect) {
                    if (!selectRowsIndexList.contains(i)) {
                        selectRowsIndexList.add(i);
                    }
                } else {
                    selectRowsIndexList.remove(i);
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        cardEntry.selectRows(selectRowsIndexList.stream().mapToInt(Integer::valueOf).toArray(), -1);
    }

    private void doShowGroupSelectBtn(boolean isSelectAll) {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(CART_ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
        for (int i = 0; i < itemList.size(); ++i) {
            cardEntry.setChildVisible(!isSelectAll, i, new String[]{SELECTGROUPBTN});
            cardEntry.setChildVisible(isSelectAll, i, new String[]{UNSELECTGROUPBTN});
        }
    }

    private void cancelClicking() {
        for (DynamicObject dyn : MalShopCartUtil.getPurSchemes()) {
            this.setIsClicking(dyn.getString("id"), false, "#666666", "#666666", "ffffff");
        }
    }

    private void setIsClicking(String key, boolean isClicking, String foreColor, String borderColor, String backColor) {
        HashMap<String, Object> uiParam = new HashMap<String, Object>();
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("b", "2px_solid_" + backColor);
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>();
        style.put("b", b);
        uiParam.put("s", style);
        uiParam.put("fc", foreColor);
        this.getView().updateControlMetadata(key, uiParam);
    }

    private void savePurScheme() {
        DynamicObjectCollection saveScheme = MalShopCartUtil.saveScheme(this.getView());
        if (null != saveScheme) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, MAL_SAVEPURSCHEME);
            this.openSavePurScheme(this.getView(), closeCallBack);
        }
    }

    private void openSavePurScheme(IFormView view, CloseCallBack closeCallBack) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(MAL_SAVEPURSCHEME);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }

    private void saveGoods2PurScheme(Map<String, Object> info) {
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(this.getView().getControl(CART_ENTRYENTITY));
        if (null != info.get("name") && selectedIndexs.length > 0) {
            String schemeName;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            QFilter qFilter = new QFilter("creator", "=", (Object)userId).and(new QFilter("name", "=", (Object)(schemeName = String.valueOf(info.get("name")))));
            DynamicObject schemeDyo = BusinessDataServiceHelper.loadSingle((String)"mal_purscheme", (String)"id,name,status,enable,goodsentry,goodsentry.goods,goodsentry.unit,goodsentry.qty,creator.id,modifytime", (QFilter[])new QFilter[]{qFilter});
            if (schemeDyo == null) {
                schemeDyo = ORM.create().newDynamicObject("mal_purscheme");
            }
            DynamicObjectCollection saveDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, this.getView().getControl(CART_ENTRYENTITY));
            schemeDyo.set("name", (Object)schemeName);
            schemeDyo.set("creator_id", (Object)userId);
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)schemeDyo.get("goodsentry");
            HashMap<Long, DynamicObject> existGoodsEntryMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject entry : entryDyoCol) {
                existGoodsEntryMap.put(entry.getLong("goods_id"), entry);
            }
            for (DynamicObject dyo : saveDyObject) {
                Long goodsId = Long.parseLong(dyo.getString(CART_GOODS));
                DynamicObject schemeEntry = (DynamicObject)existGoodsEntryMap.get(goodsId);
                if (schemeEntry != null) {
                    schemeEntry.set("unit", dyo.get("cart_unit"));
                    schemeEntry.set("qty", (Object)schemeEntry.getBigDecimal("qty").add(dyo.getBigDecimal(CART_QTY)));
                    continue;
                }
                DynamicObject entryDyo = ORMUtil.newDynamicObject((DynamicObjectType)entryDyoCol.getDynamicObjectType());
                entryDyo.set("goods_id", (Object)goodsId);
                entryDyo.set("unit", dyo.get("cart_unit"));
                entryDyo.set("qty", dyo.get(CART_QTY));
                entryDyoCol.add((Object)entryDyo);
            }
            schemeDyo.set("goodsentry", (Object)entryDyoCol);
            schemeDyo.set("enable", (Object)"1");
            schemeDyo.set("status", (Object)"C");
            schemeDyo.set("modifytime", (Object)TimeServiceHelper.now());
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            CommonUtil.check((OperationResult)SaveServiceHelper.saveOperate((String)"save", (String)"mal_purscheme", (DynamicObject[])new DynamicObject[]{schemeDyo}, (OperateOption)option));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u91c7\u8d2d\u65b9\u6848\u5931\u8d25\u3002", (String)"MalNewShopCartPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        Label label = new Label();
        label.addClickListener((ClickListener)this);
        MalShopCartUtil.saveSchemeId(e, this.getView(), label);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        HashMap returnData = (HashMap)event.getReturnData();
        if (null != returnData && MAL_SAVEPURSCHEME.equals(actionId)) {
            this.saveGoods2PurScheme(returnData);
            this.createPurSchemeLabels();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MalNewShopCartPlugin_46", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if ("mal_receiptlist".equals(actionId) && null != returnData) {
            Label labeurge = (Label)this.getView().getControl("labeurge");
            String msg = ResManager.loadKDString((String)"\u914d\u9001\u81f3\uff1a", (String)"MalNewShopCartPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            labeurge.setText(msg + returnData.get("mapaddress"));
            this.getPageCache().put("address", (String)returnData.get("address"));
            this.getPageCache().put("staddress", (String)returnData.get("id"));
            this.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent enent) {
        super.confirmCallBack(enent);
        MalShopCartUtil.confirmScheme(enent, this.getView(), new CloseCallBack((IFormPlugin)this, "mal_purscheme"));
        String callBackId = enent.getCallBackId();
        if ("notifymsg".equals(callBackId) && enent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("continue", "false");
            this.getView().invokeOperation("acountnew");
        }
    }

    private void refresh() {
        this.getModel().deleteEntryData(CART_ENTRYENTITY);
        this.initAddress();
        String isscheme = this.getPageCache().get("cache_isscheme");
        String schemeid = this.getPageCache().get("cache_schemeid");
        if (StringUtils.equals((CharSequence)isscheme, (CharSequence)"1")) {
            this.showPurSchemeInCart(this.getPageCache().get("myoften"));
            this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setIsClicking(schemeid, true, "themeColor", "themeColor", "themeColor");
        } else if (StringUtils.equals((CharSequence)isscheme, (CharSequence)"2")) {
            this.showPurSchemeInCart(schemeid);
            this.getModel().setValue("mycart1", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalNewShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setIsClicking(schemeid, true, "themeColor", "themeColor", "themeColor");
        } else {
            this.allotInitDynamicData();
        }
        if (StringUtils.equals((CharSequence)isscheme, (CharSequence)"1") || StringUtils.equals((CharSequence)isscheme, (CharSequence)"2")) {
            DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(CART_ENTRYENTITY);
            CardEntry cardEntry = (CardEntry)this.getControl(CART_ENTRYENTITY);
            for (int i = 0; i < entryCols.size(); ++i) {
                cardEntry.setChildVisible(false, i, new String[]{"comprice"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"compriceflex"});
        }
        this.setEnableLadprice();
        this.refreshGroupView();
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        MalShopCartUtil.saveAllChangedQty(this.getView());
        int currentIndex = this.getModel().getEntryCurrentRowIndex(CART_ENTRYENTITY);
        DynamicObject row = this.getModel().getEntryRowEntity(CART_ENTRYENTITY, currentIndex);
        String source = row.getString(CART_GOODSOURCE);
        String goodsId = row.getString(CART_GOODS);
        if ("comparedetail".equals(arg0.getFieldName())) {
            Object pricemonitortab = this.getModel().getValue("pricemonitortab");
            ArrayList<String> invisibletabs = new ArrayList<String>(16);
            if (null != pricemonitortab) {
                String[] tabs;
                for (String tab : tabs = String.valueOf(pricemonitortab).split(",")) {
                    if (StringUtils.isEmpty((CharSequence)tab)) continue;
                    invisibletabs.add(tab);
                }
            }
            MalPriceMonitorService service = new MalPriceMonitorService();
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
            String admindivisionId = this.getPageCache().get("address");
            long orgId = this.getOrgId();
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)row.getLong(CART_GOODS), (String)source, (BigDecimal)BigDecimal.ONE, (String)admindivisionId, (Long)orgId);
            param.setCompareId(Long.valueOf(0L));
            malMatGoodsInitParams.add(param);
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            if (!service.checkIsShowPriceMonitorForm((MalGoods)malGoodsMap.get(row.getLong(CART_GOODS)), invisibletabs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6bd4\u4ef7\u8bb0\u5f55\u3001\u540c\u6b3e\u5546\u54c1\u3001\u534a\u5e74\u5185\u7684\u5386\u53f2\u4ef7\u683c\u548c\u672c\u7ec4\u7ec7\u4ea4\u6613\u4ef7\u6570\u636e\u3002", (String)"MalNewShopCartPlugin_36", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mal_pricemonitordetail");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
            detailParamMap.put("goodsId", goodsId);
            detailParamMap.put("source", source);
            detailParamMap.put("org", this.getOrgId());
            detailParamMap.put("sourceForm", this.getModel().getDataEntity().getDataEntityType().getName());
            detailParamMap.put("invisibletabs", SerializationUtils.toJsonString(invisibletabs));
            detailParamMap.put("purchase_org", this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
            showParameter.setCustomParams(detailParamMap);
            this.getView().showForm(showParameter);
            return;
        }
        if ("viewladderprice".equals(arg0.getFieldName())) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                ArrayList<Long> goodsIds = new ArrayList<Long>(1);
                goodsIds.add(Long.parseLong(goodsId));
                Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)this.getOrgId());
                if (null != goodsMap.get(Long.parseLong(goodsId))) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("pbd_ladderprice");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    HashMap<String, String> detailParamMap = new HashMap<String, String>();
                    detailParamMap.put("status", "1");
                    detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(goodsMap.get(Long.parseLong(goodsId))));
                    showParameter.setCustomParams(detailParamMap);
                    this.getView().showForm(showParameter);
                }
            }
            return;
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)row.getString(CART_GOODS), (String)source, (String)row.getString("cart_name"), (ShowType)ShowType.NewWindow);
        } else {
            MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)row.getString(CART_NUMBER), (String)source, (String)row.getString("cart_name"), (ShowType)ShowType.NewWindow);
        }
        Object src = arg0.getSource();
        if (src instanceof CardEntry && CART_ENTRYENTITY.equals(((CardEntry)src).getEntryKey())) {
            this.updateAcount();
        }
    }

    private void openMakeOrderPage() {
        Control entryentity = this.getView().getControl(CART_ENTRYENTITY);
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(entryentity);
        if (selectedIndexs.length > 0) {
            DynamicObjectCollection shopcartDynCol = MalShopCartUtil.getSelectedDyObject(selectedIndexs, entryentity);
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(shopcartDynCol.size());
            String admindivisionId = this.getPageCache().get("address");
            for (DynamicObject dyn : shopcartDynCol) {
                MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)dyn.getLong(CART_GOODS), (String)dyn.getString(CART_GOODSOURCE), (BigDecimal)dyn.getBigDecimal(CART_QTY), (String)admindivisionId, (Long)this.getOrgId());
                param.setCompareId(Long.valueOf(0L));
                malMatGoodsInitParams.add(param);
            }
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
            HashMap<Long, String> priceMap = new HashMap<Long, String>(1024);
            for (DynamicObject info : shopcartDynCol) {
                Long goodsId = info.getLong(CART_GOODS);
                MalGoods malGoods = (MalGoods)malGoodsMap.get(goodsId);
                if (null == malGoods.getComparePrices() || malGoods.getComparePrices().size() <= 0) continue;
                priceMap.put(goodsId, ((ComparePriceInfo)malGoods.getComparePrices().get(0)).getPageId().toString());
            }
            this.open(shopcartDynCol, priceMap);
        }
    }

    private void open(DynamicObjectCollection shopcartDynCol, Map<Long, String> priceMap) {
        HashMap<String, Object> customFilter = new HashMap<String, Object>(5);
        customFilter.put("slectProd", MalShopCartUtil.dyoColToMap(shopcartDynCol));
        customFilter.put("param_amount", this.getPageCache().get("cart_select_amount"));
        customFilter.put("address", this.getPageCache().get("staddress"));
        customFilter.put("orgId", this.getOrgId());
        customFilter.put("compareprice", SerializationUtils.toJsonString(priceMap));
        ShowType showType = MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter());
        customFilter.put("opentype", showType);
        customFilter.put("fromCart", this.getPageCache().get("fromCart"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mal_placeorder");
        parameter.setCustomParams(customFilter);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowClose(false);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    private boolean validateEcSkuLimitNum(Map<String, List<String>> sourceCartsGoodsIdMap) {
        Map ecSkuNumLimitMap = MalEcAdmit.getEcSkuLimitNum();
        if (!ecSkuNumLimitMap.isEmpty()) {
            StringBuilder tipMsg = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : sourceCartsGoodsIdMap.entrySet()) {
                String source = entry.getKey();
                Integer limit = (Integer)ecSkuNumLimitMap.get(source);
                if (limit == null || limit >= entry.getValue().size()) continue;
                tipMsg.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\u7ed3\u7b97\u5546\u54c1\u4e2a\u6570\u8d85\u8fc7\u7535\u5546\u9650\u5236\u6570{1}\uff0c", (String)"MalNewShopCartPlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)source).getName(), ecSkuNumLimitMap.get(source)));
            }
            if (tipMsg.length() > 0) {
                tipMsg.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7ed3\u7b97\u5546\u54c1\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"MalNewShopCartPlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showMessage(tipMsg.toString());
                return false;
            }
        }
        return true;
    }
}

