/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.mal.business.shopcenter.INewShopCenterService;
import kd.scm.mal.business.shopcenter.MalAddressService;
import kd.scm.mal.business.shopcenter.MalDefaultService;
import kd.scm.mal.business.shopcenter.MalInstockService;
import kd.scm.mal.business.shopcenter.MalMyCheckDataService;
import kd.scm.mal.business.shopcenter.MalMyInvoiceService;
import kd.scm.mal.business.shopcenter.MalMyOrderCommentService;
import kd.scm.mal.business.shopcenter.MalMyOrderService;
import kd.scm.mal.business.shopcenter.MalOftenBuyBillService;
import kd.scm.mal.business.shopcenter.MalPackageSelectionService;
import kd.scm.mal.business.shopcenter.MalPurschemeService;
import kd.scm.mal.business.shopcenter.MalReceiptReturnService;
import kd.scm.mal.business.shopcenter.MalReceiptService;
import kd.scm.mal.business.shopcenter.MalReturnReqService;
import kd.scm.mal.business.shopcenter.MalReturnService;
import kd.scm.mal.business.shopcenter.MalStartCheckService;
import kd.scm.mal.business.shopcenter.MalStartInvoiceService;
import kd.scm.mal.formplugin.util.MalProductDetailUtil;

public class MalNewShopCenterPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log log = LogFactory.getLog(MalNewShopCenterPlugin.class);
    public static final String LINK_QUERY_PK_IDS = "LINK_QUERY_PK_IDS";
    private static final String BILL = "1";
    private static final String DYNAMICFORM = "2";
    private static final String REPORT = "3";
    private static final String CACHE_LINK_QUERY_PK_IDS = "CACHE_LINK_QUERY_PK_IDS";
    private static final String CACHE_MENUID = "menuid";
    private static Map<String, INewShopCenterService> serviceMap = new HashMap<String, INewShopCenterService>(8);
    public static final String ENTERCART = "entercart";
    public static final String ENTERORDER = "enterorder";
    public static final String TAKE = "take";
    public static final String INSTOCK = "instock";
    public static final String RETURNREQ = "returnreq";
    public static final String RECEIPTRETURN = "receiptreturn";
    public static final String INSTOCKRETURN = "instockreturn";
    public static final String INVOICEREQUEST = "invoicerequest";
    public static final String CHECK = "check";
    public static final String INVOICE = "invoice";
    public static final String CHECKDATAIMPORT = "checkdataimport";
    public static final String ADDRESS = "address";
    public static final String HEADFLEX = "headflex_";
    public static final String VECTOR = "vector_";
    private static final Set<String> checkSet;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("showFormId");
        List linkQueryPkIds = (List)this.getView().getFormShowParameter().getCustomParam(LINK_QUERY_PK_IDS);
        if (!ObjectUtils.isEmpty((Object)linkQueryPkIds)) {
            this.getPageCache().put(CACHE_LINK_QUERY_PK_IDS, JSON.toJSONString((Object)linkQueryPkIds));
        }
        if (null != this.getPageCache().get("showFormId")) {
            formId = this.getPageCache().get("showFormId");
        }
        this.createMenus(formId);
        this.getPageCache().put("showFormId", formId);
        this.createDynamic(formId);
        Tab tab = (Tab)this.getView().getControl("tabap");
        String tabkey = this.getPageCache().get("tabkey");
        tab.activeTab(tabkey);
        this.doAttationOn(formId);
        this.getView().setVisible(Boolean.FALSE, new String[]{"compare_flex"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        String formId = this.getPageCache().get("showFormId");
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        INewShopCenterService service = this.getService(formId, this.getPageCache().get(CACHE_MENUID));
        if ("pmm_packageselection_org".equals(tabKey)) {
            service = new MalPackageSelectionService();
        }
        if ("mal_purscheme".equals(tabKey)) {
            service = new MalPurschemeService();
        }
        this.showContent(service, tabKey);
    }

    protected void showContent(INewShopCenterService service, String tabKey) {
        Map paramMap = service.getBillParams(tabKey);
        String formId = service.getFormId();
        boolean permission = service.checkPermission();
        if (!permission) {
            return;
        }
        String string = formId = service.getFormId() == null ? formId : service.getFormId();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            String formType = service.getFormType();
            ListShowParameter fsp = null;
            if (BILL.equals(formType)) {
                fsp = new ListShowParameter();
                String cacheLinkQueryPkIds = this.getPageCache().get(CACHE_LINK_QUERY_PK_IDS);
                if (StringUtils.isNotEmpty((CharSequence)cacheLinkQueryPkIds)) {
                    JSONArray linkQueryPkIdsJa = JSON.parseArray((String)cacheLinkQueryPkIds);
                    if (!ObjectUtils.isEmpty((Object)linkQueryPkIdsJa)) {
                        for (Object linkQueryPkId : linkQueryPkIdsJa) {
                            fsp.addLinkQueryPkId((Object)Long.valueOf(String.valueOf(linkQueryPkId)));
                        }
                        this.getView().getFormShowParameter().getCustomParams().remove(LINK_QUERY_PK_IDS);
                    }
                    this.getPageCache().remove(CACHE_LINK_QUERY_PK_IDS);
                }
                fsp.setBillFormId(formId);
                if ("pur_invoice".equals(formId)) {
                    fsp.setSelectedEntity("entryentity1");
                }
                if (null != paramMap.get("qf")) {
                    QFilter qFilter = (QFilter)paramMap.get("qf");
                    fsp.getListFilterParameter().getQFilters().add(qFilter);
                }
            } else if (DYNAMICFORM.equals(formType)) {
                fsp = new FormShowParameter();
                fsp.setFormId(formId);
            } else if (REPORT.equals(formType)) {
                fsp = new ReportShowParameter();
                fsp.setFormId(formId);
            }
            if (fsp != null) {
                fsp.getOpenStyle().setShowType(ShowType.InContainer);
                fsp.getOpenStyle().setTargetKey("content");
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "content"));
                fsp.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
                if (null != paramMap) {
                    fsp.getCustomParams().putAll(paramMap);
                }
                fsp.setAppId("mal");
                fsp.setHasRight(true);
                this.getView().showForm((FormShowParameter)fsp);
            }
        }
    }

    private INewShopCenterService getService(String formId, String menuid) {
        Object service = null;
        service = serviceMap.get(formId) == null ? new MalDefaultService(formId, menuid) : serviceMap.get(formId);
        return service;
    }

    public void onGetControl(OnGetControlArgs e) {
        String labelStr;
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.contains("tabap")) {
            TabPage tabPage = new TabPage();
            tabPage.setKey(e.getKey());
            tabPage.setView(this.getView());
            e.setControl((Control)tabPage);
        }
        if (null != (labelStr = this.getPageCache().get("labelids"))) {
            List objects = (List)SerializationUtils.fromJsonString((String)labelStr, List.class);
            for (String labelKey : objects) {
                if (!labelKey.equals(e.getKey())) continue;
                Label label = new Label();
                label.addClickListener((ClickListener)this);
                label.setKey(labelKey);
                label.setView(this.getView());
                e.setControl((Control)label);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, "tabap");
        this.addClickListeners(new String[]{"menuflex"});
        Container purSchemeFlexAp = (Container)this.getView().getControl("menuflex");
        purSchemeFlexAp.addClickListener((ClickListener)this);
    }

    protected void addTabSelectListener(TabSelectListener form, String ... tabName) {
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    private void createDynamic(String formId) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (null != this.getPageCache().get("removetabkey")) {
            String removetabkey = this.getPageCache().get("removetabkey");
            List tabkeyList = (List)SerializationUtils.fromJsonString((String)removetabkey, List.class);
            tab.deleteControls(tabkeyList.toArray(new String[0]));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object tabNumber = customParams.get("showTab");
        ArrayList<Map> items = new ArrayList<Map>();
        List<Map<String, Object>> datas = this.getDatas(formId);
        ArrayList<String> tabKey = new ArrayList<String>(1024);
        String cacheTabPageId = "";
        if (datas != null) {
            for (int i = 0; i < datas.size(); ++i) {
                String id = datas.get(i).get("id").toString();
                String name = datas.get(i).get("name").toString();
                String type = datas.get(i).get("type").toString();
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(id);
                tabPageAp.setName(new LocaleString(name));
                if (null != tabNumber && StringUtils.isEmpty((CharSequence)this.getPageCache().get("tabkey"))) {
                    type = "0";
                    if (id.equals(tabNumber)) {
                        type = BILL;
                    }
                }
                if (StringUtils.equals((CharSequence)type, (CharSequence)BILL)) {
                    cacheTabPageId = id;
                }
                tabKey.add(id);
                Map tabPageMap = tabPageAp.createControl();
                tabPageMap.put(id, tabPageAp);
                items.add(tabPageMap);
            }
            if (StringUtils.isNotEmpty((CharSequence)cacheTabPageId)) {
                this.getPageCache().put("tabkey", cacheTabPageId);
            }
            if (null != tabNumber) {
                this.getView().getFormShowParameter().getCustomParams().remove("showTab");
            }
            this.getPageCache().put("removetabkey", SerializationUtils.toJsonString(tabKey));
        }
        tab.addControls(items);
    }

    private List<Map<String, Object>> getDatas(String formId) {
        formId = formId == null ? "mal_order" : formId;
        INewShopCenterService service = this.getService(formId, this.getPageCache().get(CACHE_MENUID));
        return service.getTabData();
    }

    private void createMenus(String formId) {
        Container purSchemeFlexAp = (Container)this.getView().getControl("menuflex");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String Alllabelids = this.getPageCache().get("Alllabelids");
        if (null != Alllabelids) {
            List ids = (List)SerializationUtils.fromJsonString((String)Alllabelids, List.class);
            purSchemeFlexAp.deleteControls(ids.toArray(new String[0]));
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)BILL));
        if (checkSet.contains(formId)) {
            qFilter.and(new QFilter("entity.number", "in", checkSet));
        } else {
            qFilter.and(new QFilter("entity.number", "not in", checkSet));
        }
        DynamicObjectCollection mal_menuclass = QueryServiceHelper.query((String)"mal_menu", (String)"menuseq,name,id,class.enable,class.name,class.id,entity.number,entity.bizappid,class.vector", (QFilter[])qFilter.toArray(), (String)"class.mseq,menuseq");
        HashMap malMenus = new HashMap(1024);
        ArrayList<String> menusList = new ArrayList<String>(1024);
        for (DynamicObject info : mal_menuclass) {
            String classes = info.getString("class.name");
            String classEnable = info.getString("class.enable");
            if ("0".equals(classEnable)) continue;
            List<Object> menus = new ArrayList<DynamicObject>(1024);
            if (null != malMenus.get(classes)) {
                menus = (List)malMenus.get(classes);
            }
            menus.add(info);
            malMenus.put(classes, menus);
            if (menusList.contains(classes)) continue;
            menusList.add(classes);
        }
        ArrayList<String> labelApIds = new ArrayList<String>(1024);
        ArrayList<String> allLabelApIds = new ArrayList<String>(1024);
        String menuId = this.getPageCache().get(CACHE_MENUID);
        for (String type : menusList) {
            List menus = (List)malMenus.get(type);
            if (null == menus || menus.size() <= 0) continue;
            this.createHeadLabel(list, (DynamicObject)menus.get(0));
            allLabelApIds.add(HEADFLEX + ((DynamicObject)menus.get(0)).getString("class.id"));
            for (DynamicObject info : menus) {
                this.createLabel(list, info, menuId);
                labelApIds.add(info.getString("id"));
                allLabelApIds.add(info.getString("id"));
            }
        }
        this.getPageCache().put("labelids", SerializationUtils.toJsonString(labelApIds));
        this.getPageCache().put("Alllabelids", SerializationUtils.toJsonString(allLabelApIds));
        purSchemeFlexAp.addControls(list);
    }

    private void createHeadLabel(List<Map<String, Object>> list, DynamicObject info) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId(HEADFLEX + info.getString("class.id"));
        res.setKey(HEADFLEX + info.getString("class.id"));
        res.setGrow(0);
        res.setShrink(0);
        res.setWrap(false);
        res.setAlignItems("center");
        res.setIndex(1);
        res.setJustifyContent("center");
        res.setName(new LocaleString(info.getString("class.name")));
        res.setWidth(new LocaleString("136px"));
        res.setClickable(false);
        Margin margin = new Margin();
        margin.setTop("16px");
        Style style = new Style();
        style.setMargin(margin);
        res.setStyle(style);
        this.createHeadIconAndLable(res, info);
        list.add(res.createControl());
    }

    private void createHeadIconAndLable(FlexPanelAp res, DynamicObject info) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setParentId(res.getId());
        vectorAp.setKey(VECTOR + info.getString("class.id"));
        vectorAp.setId(VECTOR + info.getString("class.id"));
        vectorAp.setFontSize(16);
        vectorAp.setClickable(false);
        vectorAp.setForeColor("themeColor");
        vectorAp.setNeedHoverClass(false);
        vectorAp.setfontClass(info.getString("class.vector"));
        Margin vectorMargin = new Margin();
        vectorMargin.setLeft("-22px");
        Style vectorStyle = new Style();
        vectorStyle.setMargin(vectorMargin);
        vectorAp.setStyle(vectorStyle);
        res.getItems().add(vectorAp);
        LabelAp labelAp = new LabelAp();
        labelAp.setParentId(res.getId());
        labelAp.setId(info.getString("class.id"));
        labelAp.setName(new LocaleString(info.getString("class.name")));
        labelAp.setKey(info.getString("class.id"));
        labelAp.setFontSize(15);
        labelAp.setFontWeight("bolder");
        labelAp.setForeColor("#333333");
        labelAp.setLineHeight("31px");
        Margin labelMargin = new Margin();
        labelMargin.setLeft("6px");
        Style labelStyle = new Style();
        labelStyle.setMargin(labelMargin);
        labelAp.setStyle(labelStyle);
        labelAp.setTextAlign("center");
        res.getItems().add(labelAp);
    }

    private void createLabel(List<Map<String, Object>> list, DynamicObject info, String menuid) {
        String name = info.getString("name");
        String entityNumber = info.getString("entity.number");
        INewShopCenterService service = this.getService(entityNumber, menuid);
        if (!service.checkPermission()) {
            return;
        }
        String id = info.getString("id");
        Style style = new Style();
        String color = "#333333";
        LabelAp labelAp = new LabelAp();
        labelAp.setId(id);
        labelAp.setClickable(true);
        labelAp.setName(new LocaleString(name));
        labelAp.setKey(id);
        labelAp.setFontSize(14);
        labelAp.setForeColor(color);
        labelAp.setWidth(new LocaleString("136px"));
        labelAp.setLineHeight("31px");
        labelAp.setStyle(style);
        labelAp.setTextAlign("center");
        list.add(labelAp.createControl());
    }

    private void doAttationOn(String formId) {
        QFilter qFilter = new QFilter("entity.number", "=", (Object)formId);
        DynamicObject menu = QueryServiceHelper.queryOne((String)"mal_menu", (String)"id", (QFilter[])qFilter.toArray());
        if (null != menu) {
            this.UpdateLabelColor(menu.getString("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        String formId = null;
        switch (operateKey) {
            case "entercart": {
                MalProductDetailUtil.showCat(this.getView());
                break;
            }
            case "enterorder": {
                formId = "mal_order";
                break;
            }
            case "take": {
                formId = "pur_receipt";
                break;
            }
            case "instock": {
                formId = "pur_instock";
                break;
            }
            case "returnreq": {
                formId = "mal_returnreq";
                break;
            }
            case "receiptreturn": {
                formId = "pur_receipt_return";
                break;
            }
            case "instockreturn": {
                formId = "pur_return";
                break;
            }
            case "invoicerequest": {
                formId = "pur_invoicerequest";
                break;
            }
            case "check": {
                formId = "pur_thirddatafilter";
                break;
            }
            case "invoice": {
                formId = "pur_invoice";
                break;
            }
            case "checkdataimport": {
                formId = "pur_thirddata";
                break;
            }
            case "address": {
                formId = "mal_address";
                break;
            }
        }
        if (formId == null) {
            return;
        }
        INewShopCenterService service = this.getService(formId, this.getPageCache().get(CACHE_MENUID));
        boolean permission = service.checkPermission();
        if (!permission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"MalNewShopCenterPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("entity.id", "=", (Object)formId);
        DynamicObject menu = QueryServiceHelper.queryOne((String)"mal_menu", (String)"id", (QFilter[])qFilter.toArray());
        if (null != menu) {
            this.createMenus(formId);
            this.UpdateLabelColor(menu.getString("id"));
            this.createDynamic(formId);
            this.getPageCache().put("showFormId", formId);
            Tab tab = (Tab)this.getView().getControl("tabap");
            String tabkey = this.getPageCache().get("tabkey");
            tab.activeTab(tabkey);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            Label label = (Label)source;
            this.UpdateLabelColor(label.getKey());
            String formId = null;
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(label.getKey()));
            DynamicObject menu = QueryServiceHelper.queryOne((String)"mal_menu", (String)"entity.number", (QFilter[])qFilter.toArray());
            formId = menu.getString("entity.number");
            INewShopCenterService service = this.getService(formId, label.getKey());
            boolean permission = service.checkPermission();
            if (!permission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"MalNewShopCenterPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_MENUID, label.getKey());
            this.createDynamic(formId);
            this.getPageCache().put("showFormId", formId);
            Tab tab = (Tab)this.getView().getControl("tabap");
            String tabkey = this.getPageCache().get("tabkey");
            tab.activeTab(tabkey);
        }
    }

    public void UpdateLabelColor(String labelname) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "themeColor");
        this.getView().updateControlMetadata(labelname, map);
        if (null != this.getView().getPageCache().get("label")) {
            String srcLabel = this.getView().getPageCache().get("label");
            if (srcLabel.equals(labelname)) {
                return;
            }
            HashMap<String, String> srcmap = new HashMap<String, String>();
            srcmap.put("fc", "#666666");
            this.getView().updateControlMetadata(srcLabel, srcmap);
        }
        this.getView().getPageCache().put("label", labelname);
    }

    static {
        serviceMap.put("mal_order", (INewShopCenterService)new MalMyOrderService());
        serviceMap.put("pur_receipt", (INewShopCenterService)new MalReceiptService());
        serviceMap.put("pur_instock", (INewShopCenterService)new MalInstockService());
        serviceMap.put("mal_returnreq", (INewShopCenterService)new MalReturnReqService());
        serviceMap.put("pur_receipt_return", (INewShopCenterService)new MalReceiptReturnService());
        serviceMap.put("pur_return", (INewShopCenterService)new MalReturnService());
        serviceMap.put("mal_oftenbuybill", (INewShopCenterService)new MalOftenBuyBillService());
        serviceMap.put("mal_purscheme", (INewShopCenterService)new MalPurschemeService());
        serviceMap.put("mal_address", (INewShopCenterService)new MalAddressService());
        serviceMap.put("pur_invoicerequest", (INewShopCenterService)new MalStartInvoiceService());
        serviceMap.put("pur_thirddata", (INewShopCenterService)new MalMyCheckDataService());
        serviceMap.put("pur_thirddatafilter", (INewShopCenterService)new MalStartCheckService());
        serviceMap.put("pur_invoice", (INewShopCenterService)new MalMyInvoiceService());
        serviceMap.put("mal_order_comment", (INewShopCenterService)new MalMyOrderCommentService());
        serviceMap.put("pmm_packageselection", (INewShopCenterService)new MalPackageSelectionService());
        checkSet = new HashSet<String>(8);
        checkSet.add("pur_invoicerequest");
        checkSet.add("pur_thirddata");
        checkSet.add("pur_thirddatafilter");
        checkSet.add("pur_invoice");
    }
}

