/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.es.storage.EsSuggestParam;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.mal.common.addcart.impl.MalSelfAddToCart;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.formplugin.util.MalProductDetailUtil;
import net.sf.json.JSONObject;

public class MalNewShopPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(MalNewShopPlugin.class);
    private static final String BILL = "1";
    private static final String DYNAMICFORM = "2";
    private static final String REPORT = "3";
    private static final String EMPTY = "";
    public static final String ENTERCART = "entercart";
    public static final String ENTERORDER = "enterorder";
    public static final String TORECEIPT = "toreceipt";
    public static final String TAKE = "take";
    public static final String INSTOCK = "instock";
    public static final String ORDER = "order";
    public static final String RETURNREQ = "returnreq";
    public static final String RECEIPTRETURN = "receiptreturn";
    public static final String INSTOCKRETURN = "instockreturn";
    public static final String INVOICEREQUEST = "invoicerequest";
    public static final String CHECK = "check";
    public static final String INVOICE = "invoice";
    public static final String CHECKDATAIMPORT = "checkdataimport";
    public static final String ADDRESS = "address";
    private static final String SEARCH_KEY = "search_key";
    private static final String ESCONFIG_SUGGEST = "esconfig_suggest";
    private static final String TO_SEARCH_FLEX = "to_search_flex";
    private static final String SEARCHAP = "searchap";
    public static final String REFRESH_SEARCH = "refreshSearch";
    private static final String OP_SEARCH = "search";
    private static final String PORTAL = "portal";
    private static final String APP = "app";
    private static final String OP_OFFCATALOG = "offcatalog";
    private static final String PM_REQUIRAPPLYBILL = "pm_requirapplybill";
    private static final long BILLTYPE_OFF_CATALOG = 1908705014403167232L;
    private static final String CLI_UPDATE_SHOP_CART_NUM = "updateShopCartNum";
    public static final String HEADER_ORG = "header_org";
    public static final String PURCHASE_ORG = "purchase_org";
    public static final String VECTOR_ORG = "vector_org";

    public void registerListener(EventObject e) {
        Vector orgVector;
        Container toSearchFlex;
        Search search;
        Container imgflex;
        super.registerListener(e);
        Container mycartflex = (Container)this.getControl("mycartflex");
        if (mycartflex != null) {
            mycartflex.addClickListener((ClickListener)this);
        }
        if ((imgflex = (Container)this.getControl("imgflex")) != null) {
            imgflex.addClickListener((ClickListener)this);
        }
        if ((search = (Search)this.getControl(SEARCHAP)) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((toSearchFlex = (Container)this.getControl(TO_SEARCH_FLEX)) != null) {
            toSearchFlex.addClickListener((ClickListener)this);
        }
        if ((orgVector = (Vector)this.getControl(VECTOR_ORG)) != null) {
            orgVector.addClickListener((ClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "entercart": {
                MalProductDetailUtil.showCat(this.getView());
                break;
            }
            case "toreceipt": {
                HashSet<String> logStatus = new HashSet<String>();
                logStatus.add(LogisticsStatusEnum.CONFIRM.getVal());
                logStatus.add(LogisticsStatusEnum.ALLOUTSTOCK.getVal());
                logStatus.add(LogisticsStatusEnum.PARTOUTSTOCK.getVal());
                logStatus.add(LogisticsStatusEnum.PARTRECIPT.getVal());
                logStatus.add(LogisticsStatusEnum.PARTINSTOCK.getVal());
                logStatus.add(EMPTY);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("logStatus", logStatus);
                this.showForm("mal_order", ResManager.loadKDString((String)"\u5f85\u6536\u8d27\u8ba2\u5355", (String)"MalNewShopPlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, params);
            }
        }
        if (this.getView().getEntityId().equals("mal_newshopcenter") && !operateKey.equals(PORTAL) && !operateKey.equals(APP)) {
            return;
        }
        switch (operateKey) {
            case "enterorder": {
                this.showForm("mal_order", ResManager.loadKDString((String)"\u6211\u7684\u8ba2\u5355", (String)"MalNewShopPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "take": {
                this.showForm("pur_receipt", ResManager.loadKDString((String)"\u6536\u8d27\u67e5\u8be2", (String)"MalNewShopPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "instock": {
                this.showForm("pur_instock", ResManager.loadKDString((String)"\u5165\u5e93\u67e5\u8be2", (String)"MalNewShopPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "order": {
                HashMap<String, Object> orderRetReqParams = new HashMap<String, Object>();
                orderRetReqParams.put("aftersaleReq", BILL);
                this.showForm("mal_order", ResManager.loadKDString((String)"\u552e\u540e\u7533\u8bf7", (String)"MalNewShopPlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, orderRetReqParams);
                break;
            }
            case "returnreq": {
                this.showForm("mal_returnreq", ResManager.loadKDString((String)"\u552e\u540e\u67e5\u8be2", (String)"MalNewShopPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "receiptreturn": {
                this.showForm("pur_receipt_return", ResManager.loadKDString((String)"\u9000\u8d27\u67e5\u8be2", (String)"MalNewShopPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "instockreturn": {
                this.showForm("pur_return", ResManager.loadKDString((String)"\u9000\u5e93\u67e5\u8be2", (String)"MalNewShopPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "invoicerequest": {
                this.showForm("pur_invoicerequest", ResManager.loadKDString((String)"\u7535\u5546\u5f00\u7968", (String)"MalNewShopPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]), REPORT, null);
                break;
            }
            case "check": {
                this.showForm("pur_thirddatafilter", ResManager.loadKDString((String)"\u7535\u5546\u5bf9\u8d26", (String)"MalNewShopPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]), DYNAMICFORM, null);
                break;
            }
            case "invoice": {
                this.showForm("pur_invoice", ResManager.loadKDString((String)"\u53d1\u7968\u7b7e\u6536", (String)"MalNewShopPlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "checkdataimport": {
                this.showForm("pur_thirddata", ResManager.loadKDString((String)"\u7535\u5546\u5bf9\u8d26\u6570\u636e\u5bfc\u5165\u3002", (String)"MalNewShopPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "address": {
                this.showForm("mal_address", ResManager.loadKDString((String)"\u6211\u7684\u5730\u5740", (String)"MalNewShopPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]), BILL, null);
                break;
            }
            case "portal": {
                this.toPortal();
                break;
            }
            case "app": {
                this.toApp();
                break;
            }
        }
    }

    private void toApp() {
        this.getView().openUrl(UrlService.getDomainContextUrl());
    }

    protected void showForm(String entityKey, String caption, String formType, Map<String, Object> params) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_newshopcenter");
        fsp.setCustomParam("showFormId", (Object)entityKey);
        fsp.setCustomParam("formCaption", (Object)caption);
        fsp.setCustomParam("formType", (Object)formType);
        if (params != null && !params.isEmpty()) {
            fsp.getCustomParams().putAll(params);
        }
        fsp.getOpenStyle().setShowType(ShowType.NewWindow);
        if (!this.checkViewPermission(entityKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"MalNewShopPlugin_22", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm(fsp);
    }

    private boolean checkViewPermission(String entityKey) {
        return PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"mal").getId(), (String)entityKey);
    }

    private long getOrgId() {
        long orgId = RequestContext.get().getOrgId();
        if (this.getModel().getValue(HEADER_ORG) != null) {
            DynamicObject purchaseOrg = (DynamicObject)this.getModel().getValue(HEADER_ORG);
            orgId = purchaseOrg.getLong("id");
        }
        return orgId;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String controlK = EMPTY;
        if (evt.getSource() instanceof Container) {
            Container container = (Container)evt.getSource();
            controlK = container.getKey();
        }
        if (evt.getSource() instanceof Label) {
            Label label = (Label)evt.getSource();
            controlK = label.getKey();
        }
        if (evt.getSource() instanceof Vector) {
            Vector vector = (Vector)evt.getSource();
            controlK = vector.getKey();
        }
        if ("mycartflex".equals(controlK)) {
            MalProductDetailUtil.showCat(this.getView());
        }
        if ("imgflex".equals(controlK)) {
            this.toPortal();
        }
        if (StringUtils.equals((CharSequence)TO_SEARCH_FLEX, (CharSequence)controlK) && null == this.getPageCache().get(REFRESH_SEARCH)) {
            this.toSearch(new ArrayList<String>(), this.getPageCache().get(SEARCH_KEY));
        }
        if (VECTOR_ORG.equals(controlK)) {
            this.showSwitchOrg();
        }
    }

    private void toPortal() {
        if (ParamConfigUtil.getCacheBooleanParamConfig((String)"enableMainPage_v1").booleanValue()) {
            this.getView().openUrl(UrlService.getDomainContextUrl() + "/kingdee/scm/mainpage_v1/malmainpage.html#/");
        } else {
            this.getView().openUrl(UrlService.getDomainContextUrl() + "/kingdee/scm/mainpagenew/mainpage.html#/");
        }
    }

    private void showSwitchOrg() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pbd_switchorg");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7", (String)"MalNewShopPlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "svg_switchorg");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("mal_newsearch_v1".equals(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"searchbar_flex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"scmsearch"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"searchbar_flex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"scmsearch"});
        }
        this.setOrg();
        this.setLogo();
    }

    private void setOrg() {
        String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam(PURCHASE_ORG);
        if (purchaseOrg != null) {
            this.getModel().setValue(HEADER_ORG, (Object)purchaseOrg);
        } else {
            this.getModel().setValue(HEADER_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    private void setLogo() {
        try {
            Boolean isDefaultLogo = (Boolean)this.getModel().getValue("isdefaultlogo");
            if (!isDefaultLogo.booleanValue()) {
                Map dataMap;
                LoginMCService mcService = LoginMCService.create();
                String urlFromMC = mcService.getMCData(RequestContext.get().getTenantId(), "_tenant_login_config_values_");
                String url = null;
                if (StringUtils.isNotEmpty((CharSequence)urlFromMC) && !StringUtils.isBlank((CharSequence)(url = (String)(dataMap = (Map)SerializationUtils.fromJsonString((String)urlFromMC, Map.class)).get("lefttoplogoimg")))) {
                    String img = UrlService.getImageFullUrl((String)url);
                    this.getModel().setValue("logoimg", (Object)img);
                }
            }
        }
        catch (Exception e1) {
            log.error("img decode error[UnsupportedEncodingException]!\n" + e1.getMessage(), (Throwable)e1);
        }
    }

    @Deprecated
    protected void showContent() {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if ("content".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
        if ("svg_switchorg".equals(closedCallBackEvent.getActionId()) && returnData instanceof Map) {
            Map map = (Map)returnData;
            this.switchOrg(map);
        }
    }

    private void switchOrg(Map<String, Object> returnData) {
        long orgId = (Long)returnData.get("orgId");
        this.getModel().setValue(HEADER_ORG, (Object)orgId);
        this.updateShopCartNum(orgId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            this.sendAction(CLI_UPDATE_SHOP_CART_NUM);
            this.sendDataToCustomControl();
        }
        catch (UnsupportedEncodingException e1) {
            log.error("kd.scm.mal.formplugin.MalNewShopPlugin.afterBindData:" + ExceptionUtil.getStackTrace((Throwable)e1));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (Objects.nonNull(e) && CLI_UPDATE_SHOP_CART_NUM.equals(e.getName())) {
            this.updateShopCartNum(this.getOrgId());
        }
    }

    private void sendAction(String name) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("name", name);
        param.put("duration", 0);
        param.put("async", Boolean.TRUE);
        proxy.addAction("addClientCallBack", param);
    }

    private void sendDataToCustomControl() throws UnsupportedEncodingException {
        CustomControl customControl = (CustomControl)this.getView().getControl("scmsearch");
        HashMap<String, String> data = new HashMap<String, String>();
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if (null != showParameterMap.get("onShow")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap2"});
        }
        if (null != showParameterMap.get("searchText")) {
            String searchText = showParameterMap.get("searchText").toString();
            if (Objects.nonNull(showParameterMap.get("searchFields"))) {
                String searchFields = showParameterMap.get("searchFields").toString();
                if (!searchFields.contains(",")) {
                    searchFields = StringUtils.strip((String)searchFields, (String)"[]");
                    searchFields = StringUtils.strip((String)searchFields, (String)"\"\"");
                }
                data.put("fields", this.decode(searchFields, "UTF-8"));
            }
            data.put("inputvalue", this.decode(searchText, "UTF-8"));
        }
        data.put("goods", URLDecoder.decode(ResManager.loadKDString((String)"\u5546\u54c1", (String)"MalNewShopPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put("supplierNmae", URLDecoder.decode(ResManager.loadKDString((String)"\u5546\u5bb6", (String)"MalNewShopPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put(OP_SEARCH, URLDecoder.decode(ResManager.loadKDString((String)"\u641c\u7d22", (String)"MalNewShopPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put("test", URLDecoder.decode(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22", (String)"MalNewShopPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put("brand", URLDecoder.decode(ResManager.loadKDString((String)"\u54c1\u724c", (String)"MalNewShopPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put("models", URLDecoder.decode(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"MalNewShopPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        data.put("classify", URLDecoder.decode(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"MalNewShopPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]), "UTF-8"));
        if (customControl != null) {
            customControl.setData(data);
        }
    }

    private void updateShopCartNum(Long orgId) {
        if (Objects.nonNull(this.getControl("cartno"))) {
            Label cartNo = (Label)this.getControl("cartno");
            BigDecimal currNo = new MalSelfAddToCart().getShopCartNum(orgId);
            if (cartNo != null) {
                cartNo.setText(currNo.stripTrailingZeros().toPlainString());
            }
        }
    }

    private String decode(String keyWords, String encode) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((CharSequence)keyWords)) {
            try {
                keyWords = URLDecoder.decode(keyWords, encode);
            }
            catch (IllegalArgumentException e) {
                keyWords = URLDecoder.decode(keyWords.replaceAll("%", "%25"), encode);
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return keyWords;
    }

    public void customEvent(CustomEventArgs e) {
        if (null == this.getPageCache().get(REFRESH_SEARCH) && "click".equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            JSONObject jo = JSONObject.fromObject((Object)eventArgs);
            String select = jo.getString("select");
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(select);
            String input = jo.getString("input");
            this.toSearch(list, input);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (OP_SEARCH.equals(afterDoOperationEventArgs.getOperateKey()) && null == this.getPageCache().get(REFRESH_SEARCH)) {
            this.toSearch(new ArrayList<String>(), this.getPageCache().get(SEARCH_KEY));
        }
        if (OP_OFFCATALOG.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.toPmRequirApplyBill();
        }
    }

    private void toPmRequirApplyBill() {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(PM_REQUIRAPPLYBILL);
        bsp.setBillStatus(BillOperationStatus.ADDNEW);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setCustomParam("billtype", (Object)1908705014403167232L);
        bsp.addCustPlugin("kd.scm.pssc.formplugin.edit.PsscOffCatalogReqApplyBillEdit");
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void toSearch(List<String> searchFields, String input) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey());
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        searchParamMap.put("searchText", input);
        searchParamMap.put("searchFields", searchFields);
        searchParamMap.put("searchfield", this.getModel().getValue("searchfield"));
        searchParamMap.put("opentype", ShowType.NewWindow);
        showParameter.setCustomParams(searchParamMap);
        this.getView().showForm(showParameter);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (null == this.getPageCache().get(REFRESH_SEARCH)) {
            this.getView().getPageCache().put(SEARCH_KEY, searchEnterEvent.getText());
            this.toSearch(new ArrayList<String>(), searchEnterEvent.getText());
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        DynamicObjectCollection esFieldEntryCol;
        this.getView().getPageCache().put(SEARCH_KEY, evt.getText());
        DynamicObject suggestEsconfgDyn = (DynamicObject)this.getModel().getValue(ESCONFIG_SUGGEST);
        if (suggestEsconfgDyn != null && !(esFieldEntryCol = suggestEsconfgDyn.getDynamicObjectCollection("entryentity")).isEmpty()) {
            String suggestField = ((DynamicObject)esFieldEntryCol.get(0)).getString("esmapping.number");
            return ((MalEsSearchService)DomainServiceFactory.serviceOf(MalEsSearchService.class)).suggest(new EsSuggestParam(suggestField, evt.getText()), Long.valueOf(suggestEsconfgDyn.getLong("id")));
        }
        return new ArrayList<String>();
    }
}

