/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalGoodsMapping;

public class MalPickGoodsPlugin
extends AbstractFormPlugin {
    private static final String ADD_PURCHASE = "add_purchase";
    private static final String SCMSEARCH = "scmsearch";

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)ADD_PURCHASE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            Long pk = Long.valueOf((String)this.getModel().getValue("searchgoods_pk", this.getSelectIndex()[0]));
            this.addPurchase(pk);
        }
    }

    private void checkStock(long pk) {
        MalGoods malGoods = MalGoods.of((Long)pk);
        if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, BigDecimal.ONE)) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !MalOrderParamUtil.isSelfInventoryUnlimited()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u9009\u8d2d\u3002", (String)"MalPickGoodsPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ADD_PURCHASE, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u9009\u8d2d\u5417\uff1f", (String)"MalPickGoodsPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
        }
        this.addPurchase(pk);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (ADD_PURCHASE.equals(operateKey)) {
            Boolean isView;
            Long pk = Long.valueOf((String)this.getModel().getValue("searchgoods_pk", this.getSelectIndex()[0]));
            ArrayList<Long> prodIds = new ArrayList<Long>(1);
            prodIds.add(pk);
            String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
            if (purchaseOrg != null && (isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"addpurchase", (Long)Long.parseLong(purchaseOrg))).booleanValue()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (ADD_PURCHASE.equals(afterDoOperationEventArgs.getOperateKey())) {
            long pk = Long.parseLong((String)this.getModel().getValue("searchgoods_pk", this.getSelectIndex()[0]));
            this.checkStock(pk);
        }
    }

    private void addPurchase(Long pk) {
        Long materialId = (Long)this.getView().getFormShowParameter().getCustomParam("material");
        if (ObjectUtils.isEmpty((Object)materialId)) {
            return;
        }
        HashMap<String, Long> retrunDateMap = new HashMap<String, Long>();
        retrunDateMap.put("goodsmapping", MalGoodsMapping.mapping((Long)pk, (Long)materialId));
        this.getView().returnDataToParent(retrunDateMap);
        this.getView().close();
    }

    private int[] getSelectIndex() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("search_entryentity");
        return grid.getEntryState().getSelectedRows();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (this.getView().getEntityId().equals(closedCallBackEvent.getActionId())) {
            if (!ObjectUtils.isEmpty((Object)closedCallBackEvent.getReturnData())) {
                this.addPurchase((Long)closedCallBackEvent.getReturnData());
                this.getView().close();
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{SCMSEARCH});
                this.getView().invokeOperation("refresh_compare");
                this.getView().invokeOperation("update_compare_checkstatus");
            }
        }
    }
}

