/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.org.entity.MalOrgRelation;
import kd.scm.mal.business.org.service.MalOrgRelationService;
import kd.scm.mal.business.placeorder.entity.MalCreateOrderResult;
import kd.scm.mal.business.placeorder.entity.MalFreightInfo;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderEntity;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.placeorder.vo.MalPlaceOrderVo;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.service.MalGoodsMonitorLogService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.org.IMalOrgService;
import kd.scm.mal.common.org.MalOrgServiceFactory;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalStock;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.domain.service.MalMaxPurchaseQtyService;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class MalPlaceOrderPlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener,
AttachmentMarkListener {
    private static final Log log = LogFactory.getLog(MalPlaceOrderPlugin.class);
    protected static final String PRODLIST_ETNRY = "entryentity";
    protected static final String ADD_RECEIPT = "addreceipt";
    protected static final String MODIFY_RECEIPT = "modifyreceipt";
    protected static final String FREIGHT = "freight";
    protected static final String TOTAL_REALPAY = "sumamount";
    protected static final String MAKE_ORDER = "makeorder";
    protected static final String PRODPANEL = "prodinfopanel";
    protected static final String BIZFLOW_PARAM = "2";
    protected static final String PRODMATMAPPING_PARAM = "0";
    private static final String CLOSEMAKEORDER = "closeMakeOrder";
    private static final String ISGOODSBIZTYPE = "isGoodsBizType";
    private static final String OLDBIZTYPE = "oldBizType";
    private static final int MAX_ENTRYENTITY_COUNT = 10;
    private static final String FROM_CART = "fromCart";
    private static final String REPAIRE_QTY = "reset_qty";
    private static final String MAX_PURCHASE_PREFIX = "MAX_PURCHASE_PREFIX-";
    private static final String DESC_QTY = "desc_qty";
    private static final String DELETESELECTENTRY = "deleteselectentry";
    private static final String AFTER_SUBMIT = "afterSubmit";
    private static final String CACHE_MAL_TO_PLACE_ORDER_PARAM = "malToPlaceOrderParam";
    private static final String NEW_DEPT_ORG_ID = "newDeptOrgId";
    private static final String OLD_DEPT_ORG_ID = "oldDeptOrgId";
    private static final String MAL_PLACE_ORDER_VO = "malPlaceOrderVo";
    private static final String FIRST_DEPORG = "fristDeporg";
    private static final String COMPAREPRICE = "compareprice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        int groupSize = this.getSupplierGroupSize();
        for (int i = 1; i <= groupSize; ++i) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(PRODLIST_ETNRY + i);
            grid.addRowClickListener((RowClickEventListener)this);
            grid.addHyperClickListener((HyperLinkClickListener)this);
            Container prodinfoContainer = (Container)this.getControl(PRODPANEL + i);
            prodinfoContainer.addClickListener((ClickListener)this);
            BasedataEdit invoicetypebd = (BasedataEdit)this.getView().getControl("invoicetypebd" + i);
            invoicetypebd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Button makeOrderBtn = (Button)this.getView().getControl(MAKE_ORDER);
        makeOrderBtn.addClickListener((ClickListener)this);
        BasedataEdit depEdit = (BasedataEdit)this.getView().getControl("deporg");
        depEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rcvEdit = (BasedataEdit)this.getView().getControl("rcvorg");
        rcvEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleEdit = (BasedataEdit)this.getView().getControl("settleorg");
        settleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bussinessType = (BasedataEdit)this.getView().getControl("businesstype");
        bussinessType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit expenseorgEdit = (BasedataEdit)this.getView().getControl("expenseorg");
        expenseorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costprojectEdit = (BasedataEdit)this.getView().getControl("costproject");
        costprojectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        for (int i = 1; i <= groupSize; ++i) {
            BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material" + i);
            BasedataEdit purTypeEdit = (BasedataEdit)this.getView().getControl("purtype" + i);
            BasedataEdit goodsUseEdit = (BasedataEdit)this.getView().getControl("goodsuse" + i);
            BasedataEdit entryCostProjectEdit = (BasedataEdit)this.getControl("entrycostproject" + i);
            if (entryCostProjectEdit != null) {
                entryCostProjectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (materialEdit != null) {
                materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (purTypeEdit != null) {
                purTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (goodsUseEdit == null) continue;
            goodsUseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addMarkListener((AttachmentMarkListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.initReqPerson();
            MalToPlaceOrderParam malToPlaceOrderParam = this.initMalToPlaceOrderParam();
            this.initPage(malToPlaceOrderParam);
            this.cacheFirstDepOrg();
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u5546\u57ce\u4e0b\u5355", (String)"MalPlaceOrderPlugin_78", (String)"scm-mal-formplugin", (Object[])new Object[0])});
        }
        catch (Exception error) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)error));
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fe1\u606f\u53d1\u751f\u4e86\u9519\u8bef\uff1a{0}\u3002", (String)"MalPlaceOrderPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]), error.getMessage()));
        }
    }

    private void initPage(MalToPlaceOrderParam malToPlaceOrderParam) {
        this.getPageCache().put(CACHE_MAL_TO_PLACE_ORDER_PARAM, SerializationUtils.toJsonString((Object)malToPlaceOrderParam));
        MalPlaceOrderVo malPlaceOrderVo = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).toPlaceOrder(malToPlaceOrderParam);
        this.initPageByMalPlaceOrderVo(malPlaceOrderVo);
    }

    private void updatePage(MalToPlaceOrderParam malToPlaceOrderParam) {
        this.getPageCache().put(CACHE_MAL_TO_PLACE_ORDER_PARAM, SerializationUtils.toJsonString((Object)malToPlaceOrderParam));
        MalPlaceOrderVo malPlaceOrderVo = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).toPlaceOrder(malToPlaceOrderParam);
        this.syncMalPlaceOrderVo(malPlaceOrderVo);
        this.initPageByMalPlaceOrderVo(malPlaceOrderVo);
    }

    private void syncMalPlaceOrderVo(MalPlaceOrderVo malPlaceOrderVo) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int index = 1;
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().values()) {
            malPlaceOrderEntity.setBusinessTypeId(Long.valueOf(dataEntity.getLong("businesstype.id")));
            malPlaceOrderEntity.setReqPersonId(Long.valueOf(dataEntity.getLong("reqperson.id")));
            malPlaceOrderEntity.setDeliDate(dataEntity.getDate("delidate"));
            malPlaceOrderEntity.setPersonId(Long.valueOf(dataEntity.getLong("person.id")));
            malPlaceOrderEntity.setRemark(dataEntity.getString("remark"));
            malPlaceOrderEntity.setInvoiceTypeId(dataEntity.getString("invoicetypebd" + index + ".id"));
            MalOrgRelation malOrgRelation = new MalOrgRelation();
            malOrgRelation.setDepOrgId(Long.valueOf(dataEntity.getLong("deporg.id")));
            malOrgRelation.setInvoiceOrgId(Long.valueOf(dataEntity.getLong("invoiceorg.id")));
            malOrgRelation.setRcvOrgId(Long.valueOf(dataEntity.getLong("rcvorg.id")));
            malOrgRelation.setSettleOrgId(Long.valueOf(dataEntity.getLong("settleorg.id")));
            malOrgRelation.setExpenseOrgId(Long.valueOf(dataEntity.getLong("expenseorg.id")));
            malOrgRelation.setPurOrgId(Long.valueOf(dataEntity.getLong("org.id")));
            malOrgRelation.setCostOrgId(Long.valueOf(dataEntity.getLong("costorg.id")));
            malPlaceOrderEntity.setMalOrgRelation(malOrgRelation);
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(PRODLIST_ETNRY + index);
            for (MalPlaceOrderItem malPlaceOrderItem : malPlaceOrderEntity.getPlaceOrderItemList()) {
                for (DynamicObject entry : entryCol) {
                    if (!StringUtils.equals((CharSequence)entry.getString("goods" + index), (CharSequence)String.valueOf(malPlaceOrderItem.getGoodsId()))) continue;
                    malPlaceOrderItem.setGoodsUseId(Long.valueOf(entry.getLong("goodsuse" + index + ".id")));
                    malPlaceOrderItem.setCostProjectId(Long.valueOf(entry.getLong("entrycostproject" + index + ".id")));
                    if (malPlaceOrderItem.getMaterialId() != null && malPlaceOrderItem.getMaterialId() != 0L) {
                        malPlaceOrderItem.setMaterialId(Long.valueOf(entry.getLong("material" + index + ".id")));
                    }
                    malPlaceOrderItem.setAutoMappingMaterialId(Long.valueOf(entry.getLong("material" + index + ".id")));
                    malPlaceOrderItem.setPurTypeId(Long.valueOf(entry.getLong("purtype" + index + ".id")));
                    malPlaceOrderItem.setLineTypeId(Long.valueOf(entry.getLong("linetype" + index + ".id")));
                    if (malPlaceOrderItem.getCompareId() == null || malPlaceOrderItem.getCompareId() == 0L) {
                        malPlaceOrderItem.setCompareRemark(null);
                    } else {
                        malPlaceOrderItem.setCompareRemark(entry.getString("compareremark" + index));
                    }
                    malPlaceOrderItem.setTaxRateId(Long.valueOf(entry.getLong("taxrateid" + index + ".id")));
                    malPlaceOrderItem.setTaxRate(entry.getBigDecimal("taxrate" + index));
                    malPlaceOrderItem.setNote(dataEntity.getString("remark" + index));
                }
            }
            ++index;
        }
    }

    private void initPageByMalPlaceOrderVo(MalPlaceOrderVo malPlaceOrderVo) {
        Map malPlaceOrderEntityMap = malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap();
        this.cachePlaceOrderVo(malPlaceOrderVo);
        if (malPlaceOrderEntityMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u5355\u6570\u636e\u51c6\u5907\u5931\u8d25\u3002", (String)"MalPlaceOrderPlugin_82", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        MalPlaceOrderEntity firstMalPlaceOrderEntity = (MalPlaceOrderEntity)new ArrayList(malPlaceOrderEntityMap.values()).get(0);
        this.getModel().setValue("curr", (Object)firstMalPlaceOrderEntity.getCurr());
        this.initFromPurchase();
        this.setFromPurcahse();
        this.setFromCart();
        this.initDefualOrgUnit(firstMalPlaceOrderEntity);
        this.initDefualtBizflow();
        this.initDeliDate(firstMalPlaceOrderEntity);
        this.initReceipt(firstMalPlaceOrderEntity);
        this.initPerson(firstMalPlaceOrderEntity);
        this.initBizType(firstMalPlaceOrderEntity);
        try {
            this.initExtFiled();
        }
        catch (Exception e) {
            log.error("load ExtFiled error:", (Throwable)e);
        }
        this.initByPlaceOrderEntity(malPlaceOrderEntityMap);
        this.getModel().setValue(TOTAL_REALPAY, (Object)malPlaceOrderVo.getSumAmount());
        this.getView().updateView();
    }

    private void initExtFiled() {
        Map<String, Object> customParams = this.getCustomParams();
        if (customParams.get("headFiledmap") != null && customParams.get("headFiledmap") instanceof Map) {
            Map headFiledmap = (Map)customParams.get("headFiledmap");
            DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
            for (Map.Entry extMapping : headFiledmap.entrySet()) {
                if (!customParams.containsKey(extMapping.getKey()) || !properties.containsKey(extMapping.getValue())) continue;
                this.getModel().setValue((String)extMapping.getValue(), customParams.get(extMapping.getKey()));
            }
        }
    }

    private void setExtMalToPlaceOrderItem(MalToPlaceOrderItem malToPlaceOrderItem, Map<String, Object> selectProd) {
        Map map = malToPlaceOrderItem.getExtFiledMap();
        Map<String, Object> customParams = this.getCustomParams();
        if (customParams.get("entryFiledmap") != null && customParams.get("entryFiledmap") instanceof Map) {
            Map entryFiledmap = (Map)customParams.get("entryFiledmap");
            for (Map.Entry extMapping : entryFiledmap.entrySet()) {
                if (!selectProd.containsKey(extMapping.getKey())) continue;
                map.put(extMapping.getValue(), selectProd.get(extMapping.getKey()));
            }
        }
    }

    private void cachePlaceOrderVo(MalPlaceOrderVo malPlaceOrderVo) {
        this.getView().getPageCache().put(MAL_PLACE_ORDER_VO, SerializationUtils.toJsonString((Object)malPlaceOrderVo));
    }

    private MalToPlaceOrderParam initMalToPlaceOrderParam() {
        Object person;
        Map<String, Object> customParams = this.getCustomParams();
        String malToPlaceOrderParamFromFsp = (String)customParams.get("MAL_TO_PLACEORDER_PARAM");
        if (StringUtils.isNotBlank((CharSequence)malToPlaceOrderParamFromFsp)) {
            return (MalToPlaceOrderParam)JSON.parseObject((String)malToPlaceOrderParamFromFsp, MalToPlaceOrderParam.class);
        }
        MalToPlaceOrderParam malToPlaceOrderParam = new MalToPlaceOrderParam();
        malToPlaceOrderParam.setValidateGoodsForPlaceOrder(false);
        Object businessType = customParams.get("businesstype");
        if (businessType != null) {
            malToPlaceOrderParam.setBusinessType(Long.valueOf(businessType.toString()));
        }
        if ((person = customParams.get("person")) != null) {
            malToPlaceOrderParam.setPersonId(Long.valueOf(person.toString()));
        }
        long depOrgId = RequestContext.get().getOrgId();
        Object depOrgIdObj = customParams.get("orgId");
        if (depOrgIdObj != null) {
            depOrgId = Long.parseLong(String.valueOf(depOrgIdObj));
        } else if (null != this.getModel().getValue("deporg")) {
            DynamicObject deporgDyn = (DynamicObject)this.getModel().getValue("deporg");
            depOrgId = deporgDyn.getLong("id");
        }
        malToPlaceOrderParam.setDptOrgId(Long.valueOf(depOrgId));
        Object receipt = customParams.get("receipt");
        if (receipt == null) {
            receipt = customParams.get("address");
        }
        if (receipt != null) {
            malToPlaceOrderParam.setReceiptId(Long.valueOf(receipt.toString()));
        }
        Object compareStr = customParams.get(COMPAREPRICE);
        Map compareMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(compareStr), Map.class);
        List selectProds = (List)this.getCustomParams().get("slectProd");
        ArrayList<MalToPlaceOrderItem> malToPlaceOrderItems = new ArrayList<MalToPlaceOrderItem>(selectProds.size());
        for (Map selectProd : selectProds) {
            String goodsId = (String)selectProd.get("cart_goods");
            String goodsNumber = (String)selectProd.get("cart_number");
            String source = (String)selectProd.get("cart_goodsource");
            BigDecimal qty = CommonUtil.getBigDecimalPro(selectProd.get("cart_qty"));
            Long goodsUseId = selectProd.get("cart_goodsuse") == null ? 0L : Long.parseLong(String.valueOf(selectProd.get("cart_goodsuse")));
            Long costProjectId = selectProd.get("cart_entrycostproject") == null ? 0L : Long.parseLong(String.valueOf(selectProd.get("cart_entrycostproject")));
            Long purTypeId = selectProd.get("cart_purtype") == null ? 0L : Long.parseLong(String.valueOf(selectProd.get("cart_purtype")));
            Long lineTypeId = selectProd.get("cart_linetype") == null ? 0L : Long.parseLong(String.valueOf(selectProd.get("cart_linetype")));
            MalToPlaceOrderItem malToPlaceOrderItem = new MalToPlaceOrderItem();
            malToPlaceOrderItem.setGoodsId(Long.valueOf(goodsId));
            malToPlaceOrderItem.setGoodsNumber(goodsNumber);
            malToPlaceOrderItem.setPlatform(source);
            malToPlaceOrderItem.setQty(qty);
            malToPlaceOrderItem.setCostProjectId(costProjectId);
            malToPlaceOrderItem.setGoodsUseId(goodsUseId);
            malToPlaceOrderItem.setPurTypeId(purTypeId);
            malToPlaceOrderItem.setLineTypeId(lineTypeId);
            if (null != compareMap && null != compareMap.get(goodsId)) {
                malToPlaceOrderItem.setCompareId(Long.valueOf(Long.parseLong((String)compareMap.get(goodsId))));
            } else {
                malToPlaceOrderItem.setCompareId(Long.valueOf(0L));
            }
            malToPlaceOrderItems.add(malToPlaceOrderItem);
            Object cartBilltype = selectProd.get("cart_billtype");
            if (cartBilltype != null) {
                malToPlaceOrderItem.setErpSourceBillType(String.valueOf(selectProd.get("cart_billtype")));
                malToPlaceOrderItem.setErpSourceId(String.valueOf(selectProd.get("cart_billid")));
                malToPlaceOrderItem.setErpSourceEntryId(String.valueOf(selectProd.get("cart_entryid")));
            }
            this.setExtMalToPlaceOrderItem(malToPlaceOrderItem, selectProd);
        }
        malToPlaceOrderParam.setMalToPlaceOrderItemList(malToPlaceOrderItems);
        return malToPlaceOrderParam;
    }

    private void cacheFirstDepOrg() {
        if (null == this.getPageCache().get(FIRST_DEPORG)) {
            Object org = this.getModel().getValue("deporg");
            if (org instanceof DynamicObject) {
                this.getPageCache().put(FIRST_DEPORG, ((DynamicObject)org).getString("id"));
            } else {
                this.getPageCache().put(FIRST_DEPORG, String.valueOf(org));
            }
        }
    }

    private void setFromPurcahse() {
        this.getModel().setValue("frompurchase", (Object)this.isFromPurchase());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFromPurchase()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"deporg"});
        }
        this.setEnableLadprice();
        this.setEnbaleCompare();
        this.setEnableExpense();
        this.setEnbaleInvoiceType();
    }

    private void setEnbaleInvoiceType() {
        int countSize = this.getSupplierGroupSize();
        for (int i = 1; i <= countSize; ++i) {
            Object goodsSource = this.getModel().getValue("source" + i);
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsSource)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoicetypebd" + i});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"invoicetypebd" + i});
        }
    }

    private void setEnableExpense() {
        String lockIndexSetJson = this.getPageCache().get("entrycostproject_lock");
        if (StringUtils.isNotBlank((CharSequence)lockIndexSetJson)) {
            Set lockIndexSet = (Set)SerializationUtils.fromJsonString((String)lockIndexSetJson, Set.class);
            for (String lockIndex : lockIndexSet) {
                String rowIndex = lockIndex.split("_")[0];
                String index = lockIndex.split("_")[1];
                this.getView().setEnable(Boolean.FALSE, Integer.parseInt(rowIndex), new String[]{"entrycostproject" + index});
            }
        }
    }

    private void setEnbaleCompare() {
        int countSize = this.getSupplierGroupSize();
        for (int i = 1; i <= countSize; ++i) {
            String entryKey = PRODLIST_ETNRY + i;
            CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject row = (DynamicObject)entryCol.get(j);
                if (StringUtils.isEmpty((CharSequence)row.getString("compareid" + i)) || StringUtils.equals((CharSequence)PRODMATMAPPING_PARAM, (CharSequence)row.getString("compareid" + i))) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), j, new String[]{"comparedetail" + i});
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"compareremark" + i});
                    continue;
                }
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), j, new String[]{"comparedetail" + i});
                this.getView().setEnable(Boolean.TRUE, j, new String[]{"compareremark" + i});
            }
        }
    }

    private void setEnableLadprice() {
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        int supplierGroupSize = this.getSupplierGroupSize();
        if (!Boolean.parseBoolean(param)) {
            this.setVisibleLabPrice();
            return;
        }
        MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
        int entryRowCount = malToPlaceOrderParam.getMalToPlaceOrderItemList().size();
        ArrayList<Long> goodsIds = new ArrayList<Long>(entryRowCount);
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            goodsIds.add(malToPlaceOrderItem.getGoodsId());
        }
        Object deporg = this.getModel().getValue("deporg");
        if (goodsIds.size() == 0 || null == deporg) {
            this.setVisibleLabPrice();
            return;
        }
        Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)((DynamicObject)deporg).getLong("id"));
        for (int i = 1; i <= supplierGroupSize; ++i) {
            CardEntry cardEntry = (CardEntry)this.getControl(PRODLIST_ETNRY + i);
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(PRODLIST_ETNRY + i);
            Object goodsSource = this.getModel().getValue("source" + i);
            for (DynamicObject row : entrys) {
                cardEntry.setChildVisible(EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsSource) && null != goodsMap.get(row.getLong("goods" + i)), row.getInt("seq") - 1, new String[]{"viewladderprice" + i});
            }
        }
    }

    private void setVisibleLabPrice() {
        int supplierGroupSize = this.getSupplierGroupSize();
        for (int i = 1; i <= supplierGroupSize; ++i) {
            CardEntry cardEntry = (CardEntry)this.getControl(PRODLIST_ETNRY + i);
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(PRODLIST_ETNRY + i);
            for (DynamicObject row : entrys) {
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice" + i});
            }
        }
    }

    private void setFromCart() {
        this.getModel().setValue("fromcart", (Object)"true".equals(this.getCustomParams().get(FROM_CART)));
    }

    private void initByPlaceOrderEntity(Map<String, MalPlaceOrderEntity> malPlaceOrderEntityMap) {
        this.hiddenInvalidSupplier(malPlaceOrderEntityMap);
        int count = 0;
        HashMap<String, List> productIdsMap = new HashMap<String, List>(8);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderEntityMap.values()) {
            Long supplierId = 0L;
            boolean isUpdate = false;
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(PRODLIST_ETNRY + ++count);
            if (entryCol.size() == malPlaceOrderEntity.getPlaceOrderItemList().size()) {
                isUpdate = true;
            }
            for (int i = 0; i < malPlaceOrderEntity.getPlaceOrderItemList().size(); ++i) {
                MalPlaceOrderItem malPlaceOrderItem = (MalPlaceOrderItem)malPlaceOrderEntity.getPlaceOrderItemList().get(i);
                List productIdList = productIdsMap.getOrDefault(malPlaceOrderItem.getPlatform(), new ArrayList());
                productIdList.add(malPlaceOrderItem.getPlatform().equals(EcPlatformEnum.ECPLATFORM_SELF.getVal()) ? String.valueOf(malPlaceOrderItem.getGoodsId()) : malPlaceOrderItem.getGoodsNumber());
                productIdsMap.put(malPlaceOrderItem.getPlatform(), productIdList);
                if (supplierId != 0L) continue;
                supplierId = malPlaceOrderItem.getSupplierId();
            }
            if (!isUpdate) {
                this.createEntryCol(count, malPlaceOrderEntity);
            } else {
                this.updateEntryCol(count, malPlaceOrderEntity);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"goodspanelap" + count});
            this.getModel().setValue("supplier" + count, (Object)supplierId);
            this.getModel().setValue("source" + count, (Object)malPlaceOrderEntity.getPlatform());
            if (!malPlaceOrderEntity.getPlatform().equals(EcPlatformEnum.ECPLATFORM_SELF.getVal()) && !StringUtils.isEmpty((CharSequence)malPlaceOrderEntity.getInvoiceTypeId())) {
                this.getModel().setValue("invoicetypebd" + count, (Object)Long.parseLong(malPlaceOrderEntity.getInvoiceTypeId()));
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("invoicetype" + count))) {
                this.getModel().setValue("invoicetype" + count, (Object)malPlaceOrderEntity.getInvoiceType());
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("paytype" + count))) {
                this.getModel().setValue("paytype" + count, (Object)malPlaceOrderEntity.getPayType());
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("invoicestate" + count))) {
                this.getModel().setValue("invoicestate" + count, (Object)"1");
            }
            this.getModel().setValue("totalextamount" + count, (Object)malPlaceOrderEntity.getTotalExtAmount());
            this.getModel().setValue("totalgoodsamt" + count, (Object)malPlaceOrderEntity.getTotalGoodsAmt());
            this.getModel().setValue(FREIGHT + count, (Object)malPlaceOrderEntity.getFreight());
            this.getModel().setValue("subtotalamount" + count, (Object)malPlaceOrderEntity.getSubTotalAmount());
            if (!StringUtils.isNotBlank((CharSequence)malPlaceOrderEntity.getRemark())) continue;
            this.getModel().setValue("remark", (Object)malPlaceOrderEntity.getRemark());
        }
        String productIdStr = SerializationUtils.toJsonString(productIdsMap);
        this.getPageCache().put("productIdsMap", productIdStr);
        this.setFieldVisible(malPlaceOrderEntityMap);
        List entryArray = (List)this.getCustomParams().get("slectProd");
        if (entryArray != null) {
            this.bindEntryData(entryArray, (DynamicObject)this.getModel().getValue("businesstype"));
        }
    }

    private void updateEntryCol(int count, MalPlaceOrderEntity malPlaceOrderEntity) {
        for (int i = 0; i < malPlaceOrderEntity.getPlaceOrderItemList().size(); ++i) {
            MalPlaceOrderItem malPlaceOrderItem = (MalPlaceOrderItem)malPlaceOrderEntity.getPlaceOrderItemList().get(i);
            DynamicObject entry = this.getModel().getEntryRowEntity(PRODLIST_ETNRY + count, i);
            entry.set("goodsimg" + count, (Object)malPlaceOrderItem.getThumbnail());
            entry.set("goodsnum" + count, (Object)malPlaceOrderItem.getGoodsNumber());
            entry.set("goodsname" + count, (Object)malPlaceOrderItem.getGoodsName());
            entry.set("purtype" + count + "_id", (Object)malPlaceOrderItem.getPurTypeId());
            entry.set("linetype" + count + "_id", (Object)malPlaceOrderItem.getLineTypeId());
            entry.set("stockqty" + count, (Object)malPlaceOrderItem.getStockDesc());
            entry.set("qty" + count, (Object)malPlaceOrderItem.getQty());
            entry.set("goodprice" + count, (Object)malPlaceOrderItem.getGoodsPrice());
            entry.set("goodamount" + count, (Object)malPlaceOrderItem.getGoodsAmount());
            entry.set("unit" + count + "_id", (Object)malPlaceOrderItem.getProductUnitId());
            entry.set("minorderqty" + count, (Object)malPlaceOrderItem.getMinOrderQty());
            entry.set("minorderqty_unit" + count + "_id", (Object)malPlaceOrderItem.getProductUnitId());
            entry.set("erpsourcebilltype" + count, (Object)malPlaceOrderItem.getErpSourceBillType());
            entry.set("erpsourceid" + count, (Object)malPlaceOrderItem.getErpSourceId());
            entry.set("erpsourceentryid" + count, (Object)malPlaceOrderItem.getErpSourceEntryId());
            entry.set("compareid" + count, (Object)malPlaceOrderItem.getCompareId());
            entry.set("compareresult" + count, (Object)malPlaceOrderItem.getCompareResult());
            entry.set("compareremark" + count, (Object)malPlaceOrderItem.getCompareRemark());
            entry.set("goodsuse" + count + "_id", (Object)malPlaceOrderItem.getGoodsUseId());
            entry.set("entrycostproject" + count + "_id", (Object)malPlaceOrderItem.getCostProjectId());
            if (malPlaceOrderItem.getMaterialId() != null && malPlaceOrderItem.getMaterialId() != 0L) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"material" + count});
                entry.set("material" + count + "_id", (Object)malPlaceOrderItem.getMaterialId());
            } else {
                entry.set("material" + count + "_id", (Object)malPlaceOrderItem.getAutoMappingMaterialId());
            }
            entry.set("goodsmodel" + count, (Object)malPlaceOrderItem.getProductModel());
            if (StringUtils.isNotBlank((CharSequence)malPlaceOrderItem.getProtocolNo())) {
                entry.set("protocolno" + count, (Object)malPlaceOrderItem.getProtocolNo());
            }
            entry.set("goods" + count, (Object)malPlaceOrderItem.getGoodsId());
            entry.set("extamount" + count, (Object)malPlaceOrderItem.getExtAmount());
            entry.set("avgfreight" + count, (Object)malPlaceOrderItem.getAvgFreight());
            entry.set("taxprice" + count, (Object)malPlaceOrderItem.getTaxPrice());
            entry.set("taxamount" + count, (Object)malPlaceOrderItem.getTaxAmount());
            entry.set("taxrate" + count, (Object)malPlaceOrderItem.getTaxRate());
            entry.set("taxrateid" + count + "_id", (Object)malPlaceOrderItem.getTaxRateId());
            this.updateExtEntryFiled(entry, count, malPlaceOrderItem);
        }
    }

    private void updateExtEntryFiled(DynamicObject entry, int count, MalPlaceOrderItem malPlaceOrderItem) {
        Map extFiledMap = malPlaceOrderItem.getExtFiledMap();
        if (extFiledMap == null || extFiledMap.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
        for (Map.Entry extMapping : extFiledMap.entrySet()) {
            if (!properties.containsKey(extMapping.getKey())) continue;
            entry.set((String)extMapping.getKey() + count, extMapping.getValue());
        }
    }

    private void createEntryCol(int index, MalPlaceOrderEntity malPlaceOrderEntity) {
        this.getModel().deleteEntryData(PRODLIST_ETNRY + index);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < malPlaceOrderEntity.getPlaceOrderItemList().size(); ++i) {
            MalPlaceOrderItem malPlaceOrderItem = (MalPlaceOrderItem)malPlaceOrderEntity.getPlaceOrderItemList().get(i);
            vs.set("goodsimg" + index, (Object)malPlaceOrderItem.getThumbnail(), i);
            vs.set("goodsnum" + index, (Object)malPlaceOrderItem.getGoodsNumber(), i);
            vs.set("goodsname" + index, (Object)malPlaceOrderItem.getGoodsName(), i);
            vs.set("purtype" + index, (Object)malPlaceOrderItem.getPurTypeId(), i);
            vs.set("linetype" + index, (Object)malPlaceOrderItem.getLineTypeId(), i);
            vs.set("stockqty" + index, (Object)malPlaceOrderItem.getStockDesc(), i);
            vs.set("qty" + index, (Object)malPlaceOrderItem.getQty(), i);
            vs.set("goodprice" + index, (Object)malPlaceOrderItem.getGoodsPrice(), i);
            vs.set("goodamount" + index, (Object)malPlaceOrderItem.getGoodsAmount(), i);
            vs.set("unit" + index, (Object)malPlaceOrderItem.getProductUnitId(), i);
            vs.set("minorderqty" + index, (Object)malPlaceOrderItem.getMinOrderQty(), i);
            vs.set("minorderqty_unit" + index, (Object)malPlaceOrderItem.getProductUnitId(), i);
            vs.set("erpsourcebilltype" + index, (Object)malPlaceOrderItem.getErpSourceBillType(), i);
            vs.set("erpsourceid" + index, (Object)malPlaceOrderItem.getErpSourceId(), i);
            vs.set("erpsourceentryid" + index, (Object)malPlaceOrderItem.getErpSourceEntryId(), i);
            vs.set("compareid" + index, (Object)malPlaceOrderItem.getCompareId(), i);
            if (!StringUtils.isBlank((Object)malPlaceOrderItem.getCompareId()) && 0L != malPlaceOrderItem.getCompareId()) {
                vs.set("compareresult" + index, (Object)malPlaceOrderItem.getCompareResult(), i);
            }
            vs.set("goodsuse" + index, (Object)malPlaceOrderItem.getGoodsUseId(), i);
            vs.set("entrycostproject" + index, (Object)malPlaceOrderItem.getCostProjectId(), i);
            if (malPlaceOrderItem.getMaterialId() != null && malPlaceOrderItem.getMaterialId() != 0L) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"material" + index});
                vs.set("material" + index, (Object)malPlaceOrderItem.getMaterialId(), i);
            } else {
                vs.set("material" + index, (Object)malPlaceOrderItem.getAutoMappingMaterialId(), i);
            }
            vs.set("goodsmodel" + index, (Object)malPlaceOrderItem.getProductModel(), i);
            if (StringUtils.isNotBlank((CharSequence)malPlaceOrderItem.getProtocolNo())) {
                vs.set("protocolno" + index, (Object)malPlaceOrderItem.getProtocolNo(), i);
            }
            vs.set("goods" + index, (Object)malPlaceOrderItem.getGoodsId(), i);
            vs.set("extamount" + index, (Object)malPlaceOrderItem.getExtAmount(), i);
            vs.set("avgfreight" + index, (Object)malPlaceOrderItem.getAvgFreight(), i);
            vs.set("taxprice" + index, (Object)malPlaceOrderItem.getTaxPrice(), i);
            vs.set("taxamount" + index, (Object)malPlaceOrderItem.getTaxAmount(), i);
            vs.set("taxrate" + index, (Object)malPlaceOrderItem.getTaxRate(), i);
            vs.set("taxrateid" + index + "_id", (Object)malPlaceOrderItem.getTaxRateId(), i);
            this.insertExtEntryFiled(vs, index, i, malPlaceOrderItem);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(PRODLIST_ETNRY + index, vs);
    }

    private void insertExtEntryFiled(TableValueSetter vs, int index, int i, MalPlaceOrderItem malPlaceOrderItem) {
        Map extFiledMap = malPlaceOrderItem.getExtFiledMap();
        if (extFiledMap == null || extFiledMap.size() == 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(PRODLIST_ETNRY + index);
        DataEntityPropertyCollection properties = entryCol.getDynamicObjectType().getProperties();
        for (Map.Entry extMapping : extFiledMap.entrySet()) {
            if (!properties.containsKey((Object)((String)extMapping.getKey() + index))) continue;
            vs.set((String)extMapping.getKey() + index, extMapping.getValue(), i);
        }
    }

    private void setFieldVisible(Map<String, MalPlaceOrderEntity> malPlaceOrderEntityMap) {
        ArrayList<MalPlaceOrderEntity> malPlaceOrderEntities = new ArrayList<MalPlaceOrderEntity>(malPlaceOrderEntityMap.values());
        for (int i = 1; i <= malPlaceOrderEntities.size(); ++i) {
            List malPlaceOrderItems = ((MalPlaceOrderEntity)malPlaceOrderEntities.get(i - 1)).getPlaceOrderItemList();
            CardEntry cardEntry = (CardEntry)this.getControl(PRODLIST_ETNRY + i);
            if (cardEntry == null) continue;
            for (int j = 0; j < malPlaceOrderItems.size(); ++j) {
                MalPlaceOrderItem malPlaceOrderItem = (MalPlaceOrderItem)malPlaceOrderItems.get(j);
                if (StringUtils.isBlank((CharSequence)malPlaceOrderItem.getProtocolNo())) {
                    cardEntry.setChildVisible(false, j, new String[]{"protocolpanelap" + i, "protocolinfopanelap" + i});
                }
                if (null != malPlaceOrderItem.getCompareId() && 0L != malPlaceOrderItem.getCompareId()) {
                    this.getView().setEnable(Boolean.TRUE, j, new String[]{"compareremark" + i});
                    continue;
                }
                cardEntry.setChildVisible(false, j, new String[]{"comparedetail" + i});
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"compareremark" + i});
            }
        }
    }

    private void initPerson(MalPlaceOrderEntity firstMalPlaceOrderEntity) {
        if (this.getModel().getValue("person") == null) {
            this.getModel().setValue("person", (Object)firstMalPlaceOrderEntity.getPersonId());
        }
    }

    private Map<String, Object> getCustomParams() {
        return this.getView().getFormShowParameter().getShowParameter().getCustomParams();
    }

    private void initReceipt(MalPlaceOrderEntity firstMalPlaceOrderEntity) {
        Object receipt = this.getModel().getValue("receipt");
        if (StringUtils.isBlank((Object)receipt) || PRODMATMAPPING_PARAM.equals(receipt)) {
            this.fillReceipt(firstMalPlaceOrderEntity.getMalReceipt());
        }
    }

    private void initFromPurchase() {
        DynamicObject malPlan;
        List selectProds;
        Map<String, Object> showParameterMap = this.getCustomParams();
        if (this.isFromPurchase() && !(selectProds = (List)showParameterMap.get("slectProd")).isEmpty() && (malPlan = MalPlan.queryMalPlanBySrcEntryId((String)String.valueOf(((Map)selectProds.get(0)).get("cart_entryid")))) != null) {
            this.getModel().setValue("reqperson", (Object)malPlan.getLong("entryentity.entryreqperson.id"));
            this.getModel().setValue("person", (Object)malPlan.getLong("person"));
            this.getModel().setValue("businesstype", (Object)malPlan.getLong("businesstype"));
            this.getModel().setValue("remark", (Object)malPlan.getString("remark"));
            this.getModel().setValue("delidate", (Object)malPlan.getString("entryentity.reqdate"));
            this.getModel().setValue("deporg", (Object)malPlan.getLong("entryentity.entryreqorg.id"));
            this.getModel().setValue("costorg", (Object)malPlan.getLong("entryentity.entryreqorg.id"));
            this.getModel().setValue("org", (Object)malPlan.getLong("org.id"));
            this.getModel().setValue("rcvorg", (Object)malPlan.getLong("entryentity.entryrcvorg.id"));
        }
    }

    private boolean isFromPurchase() {
        return "1".equals(this.getCustomParams().get("frompurchase"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String receipt;
        HashMap returnData;
        super.closedCallBack(closedCallBackEvent);
        if (("mal_address".equals(closedCallBackEvent.getActionId()) || "mal_receiptlist".equals(closedCallBackEvent.getActionId())) && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null && StringUtils.isNotBlank((CharSequence)(receipt = (String)returnData.get("id")))) {
            this.fillReceipt(((MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class)).getReceiptById(Long.valueOf(receipt)));
            MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
            malToPlaceOrderParam.setReceiptId(Long.valueOf(receipt));
            this.updatePage(malToPlaceOrderParam);
        }
        if (AFTER_SUBMIT.equals(closedCallBackEvent.getActionId()) || CLOSEMAKEORDER.equals(closedCallBackEvent.getActionId())) {
            this.getView().returnDataToParent((Object)"PLACED_ORDER");
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject bizType;
        String index;
        Long settlOrgId;
        DynamicObject settlOrg;
        List bizTypeIds;
        DynamicObject billType;
        QFilter filter;
        Long purOrgId;
        Object purOrg;
        QFilter filter2;
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        boolean hasRelation = MalOrgServiceFactory.hasDelegantRalation();
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        int rowIndex = arg0.getRow();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"deporg") && hasRelation) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8", (String)"MalPlaceOrderPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            DynamicObject person = (DynamicObject)this.getModel().getValue("reqperson");
            if (null != person) {
                Long personId = person.getLong("id");
                filter2 = new QFilter("id", "in", (Object)malOrgService.getDemandOrgList(personId));
                showParameter.getListFilterParameter().getQFilters().add(filter2);
            }
        }
        if (fieldKey.contains("invoicetypebd")) {
            String index2 = fieldKey.replace("invoicetypebd", "");
            Object goodsSource = this.getModel().getValue("source" + index2);
            filter2 = new QFilter("emaltype", "=", goodsSource);
            showParameter.getListFilterParameter().getQFilters().add(filter2);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
            Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
            filter2 = new QFilter("id", "in", (Object)malOrgService.getPurchaseOrgList(dptOrgId));
            showParameter.getListFilterParameter().getQFilters().add(filter2);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"rcvorg")) {
            purOrg = (DynamicObject)this.getModel().getValue("org");
            purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            filter2 = new QFilter("id", "in", (Object)malOrgService.getInvOrgList(purOrgId));
            showParameter.getListFilterParameter().getQFilters().add(filter2);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"settleorg") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"invoiceorg")) {
            DynamicObject dptOrg;
            DynamicObject invOrg;
            purOrg = (DynamicObject)this.getModel().getValue("org");
            purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            long orgId = hasRelation ? ((invOrg = (DynamicObject)this.getModel().getValue("rcvorg")) != null ? invOrg.getLong("id") : 0L) : ((dptOrg = (DynamicObject)this.getModel().getValue("deporg")) != null ? dptOrg.getLong("id") : 0L);
            filter = new QFilter("id", "in", (Object)malOrgService.getSettleOrgList(purOrgId, Long.valueOf(orgId)));
            log.info("@@@\u7ed3\u7b97\u7ec4\u7ec7F7\u6253\u5f00\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"businesstype") && !Objects.isNull(billType = (DynamicObject)this.getModel().getValue("billtype")) && !CollectionUtils.isEmpty((Collection)(bizTypeIds = BizTypeHelper.getAllBizTypes((String)"mal_order", (Long)billType.getLong("id"))))) {
            QFilter filter3 = new QFilter("id", "in", (Object)bizTypeIds);
            showParameter.getListFilterParameter().getQFilters().add(filter3);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"expenseorg")) {
            settlOrg = (DynamicObject)this.getModel().getValue("settleorg");
            settlOrgId = settlOrg != null ? settlOrg.getLong("id") : 0L;
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(settlOrgId);
            List subOrgIds = OrgUnitServiceHelper.getAdminOrgRelation(orgIds, (boolean)true);
            filter = new QFilter("id", "in", (Object)subOrgIds);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"costproject") || StringUtils.startsWith((CharSequence)fieldKey, (CharSequence)"entrycostproject")) {
            settlOrg = (DynamicObject)this.getModel().getValue("settleorg");
            settlOrgId = settlOrg != null ? settlOrg.getLong("id") : 0L;
            QFilter filter4 = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)settlOrgId);
            showParameter.getListFilterParameter().getQFilters().add(filter4);
        }
        if (fieldKey.startsWith("material")) {
            QFilter qFilter;
            purOrg = this.getModel().getValue("org");
            if (Objects.isNull(purOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"MalPlaceOrderPlugin_44", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            purOrgId = purOrg.getLong("id");
            QFilter filter5 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)purOrgId).and(new QFilter("enablepur", "=", (Object)"1"));
            index = fieldKey.substring("material".length());
            DynamicObject purTypeDyn = (DynamicObject)this.getModel().getValue("purtype" + index, rowIndex);
            if (purTypeDyn != null && !Parser.toBoolean((Object)this.getPageCache().get(ISGOODSBIZTYPE))) {
                DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)purTypeDyn.getLong("linetype.id"), (String)"bd_linetype");
                if (null != lineType && null != lineType.getDynamicObject("serviceattribute")) {
                    filter5.and(QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + lineType.getDynamicObject("serviceattribute").getPkValue() + " ) ")));
                } else {
                    filter5.and("serviceattribute.fbasedataid_id", "is null", null);
                }
            }
            if ((qFilter = this.getMaterialQFilterByCategoryMapping(arg0)) != null) {
                filter5.and(qFilter);
            }
            showParameter.getListFilterParameter().getQFilters().add(filter5);
        }
        if (fieldKey.startsWith("purtype") && (bizType = (DynamicObject)this.getModel().getValue("businesstype")) != null) {
            Set lineTypeIds;
            List filters = showParameter.getListFilterParameter().getQFilters();
            if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)bizType)) {
                filters.add(new QFilter("linetype.number", "like", (Object)"060%"));
            }
            if (!CollectionUtils.isEmpty((Collection)(lineTypeIds = BizTypeHelper.getAllLineTypeIds((Long)bizType.getLong("id"))))) {
                filters.add(new QFilter("linetype", "in", (Object)lineTypeIds));
            }
            if (this.isFromPurchase()) {
                index = fieldKey.substring("purtype".length());
                DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("material" + index, rowIndex);
                Set serviceAttrIdSet = MalPlaceOrderUtils.getServiceAttrIdSetByMaterial((DynamicObject)materialDyn);
                if (!serviceAttrIdSet.isEmpty()) {
                    filters.add(new QFilter("linetype.serviceattribute.id", "in", (Object)serviceAttrIdSet));
                } else {
                    filters.add(new QFilter("linetype", "is null", null));
                }
            }
        }
        if (fieldKey.startsWith("goodsuse")) {
            List filters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject settleorg = (DynamicObject)this.getModel().getValue("settleorg");
            Long orgId = settleorg != null ? settleorg.getLong("id") : 0L;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_goods_use", (Long)orgId);
            filters.add(baseDataFilter);
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
    }

    private QFilter getMaterialQFilterByCategoryMapping(BeforeF7SelectEvent arg0) {
        String entryEntityName = arg0.getProperty().getParent().getExtendName();
        Long goodsId = this.getModel().getEntryRowEntity(entryEntityName, arg0.getRow()).getLong("goods" + arg0.getProperty().getName().substring(8));
        DynamicObject goods = QueryServiceHelper.queryOne((String)"pbd_goods", (String)"category", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)goodsId)});
        long categoryId = goods.getLong("category");
        Map goodsCategoryMapping = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmMatMappingService", (String)"getMaterialIdsByGoodsCategoryMapping", (Object[])new Object[]{categoryId});
        List materialIds = (List)goodsCategoryMapping.get(categoryId);
        if (materialIds == null) {
            return null;
        }
        return new QFilter("id", "in", (Object)materialIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "addreceipt": {
                this.addReceipt();
                break;
            }
            case "modifyreceipt": {
                this.modifyReceipt();
                break;
            }
            case "makeorder": {
                MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
                this.getPageCache().put(CACHE_MAL_TO_PLACE_ORDER_PARAM, SerializationUtils.toJsonString((Object)malToPlaceOrderParam));
                MalPlaceOrderVo malPlaceOrderVo = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).toPlaceOrder(malToPlaceOrderParam);
                this.syncMalPlaceOrderVo(malPlaceOrderVo);
                malPlaceOrderVo.setClearOrderedGoodsInShopCart(this.getModel().getDataEntity().getBoolean("fromcart"));
                this.cachePlaceOrderVo(malPlaceOrderVo);
                if (!this.checkMaxPurchaseQty()) {
                    event.setCancel(true);
                    return;
                }
                if (!this.checkSelfStock()) {
                    event.setCancel(true);
                    return;
                }
                if (!this.checkFreight()) {
                    event.setCancel(true);
                    return;
                }
                if (this.validateMalGoodsMonitorRule()) break;
                event.setCancel(true);
                return;
            }
            case "deleteselectentry": {
                this.deleteSelectedEntry();
                break;
            }
        }
    }

    private boolean validateMalGoodsMonitorRule() {
        MalGoodsMonitorLogService malGoodsMonitorLogService;
        Collection collection;
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        Map supplierIdToPlaceOrderEntityMap = malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap();
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(16);
        long orgId = RequestContext.get().getOrgId();
        Object deporg = this.getModel().getValue("deporg");
        if (null != deporg) {
            orgId = ((DynamicObject)deporg).getLong("id");
        }
        for (Map.Entry map : supplierIdToPlaceOrderEntityMap.entrySet()) {
            MalPlaceOrderEntity value = (MalPlaceOrderEntity)map.getValue();
            List placeOrderItemList = value.getPlaceOrderItemList();
            Iterator iterator = placeOrderItemList.iterator();
            while (iterator.hasNext()) {
                MalPlaceOrderItem item = (MalPlaceOrderItem)iterator.next();
                MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)item.getGoodsId(), (String)item.getPlatform(), (BigDecimal)BigDecimal.ONE, null, (Long)orgId);
                malMatGoodsInitParams.add(param);
            }
        }
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
        ArrayList<String> goodIds = new ArrayList<String>(16);
        ArrayList<Long> goodsPoolIds = new ArrayList<Long>(16);
        for (Map.Entry entry : malGoodsMap.entrySet()) {
            MalGoods malGoods = (MalGoods)entry.getValue();
            if (null == malGoods) continue;
            goodIds.add(malGoods.getProductId());
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) continue;
            goodsPoolIds.add(malGoods.getGoodsInfo().getProdPoolId());
        }
        if (goodIds.size() > 0 && (collection = (malGoodsMonitorLogService = new MalGoodsMonitorLogService()).getGoodsMonitorLogs(goodIds, goodsPoolIds)) != null && collection.size() > 0) {
            String disableDeatialMsg = malGoodsMonitorLogService.getDisableDetailMsg(collection);
            if (!StringUtils.isEmpty((CharSequence)disableDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u7981\u6b62\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 \u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalPlaceOrderPlugin_85", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, disableDeatialMsg, MessageTypes.Default);
                return false;
            }
            String notifyDeatialMsg = malGoodsMonitorLogService.getNotifyDetailMsg(collection);
            if (!StringUtils.isEmpty((CharSequence)notifyDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalPlaceOrderPlugin_86", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u4e0b\u5355", (String)"MalPlaceOrderPlugin_87", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, notifyDeatialMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("notifymsg", (IFormPlugin)this), btnNameMaps);
                return false;
            }
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (MAKE_ORDER.equals(operateKey)) {
            this.makeOrder();
        }
    }

    private boolean checkMaxPurchaseQty() {
        if (this.isFromPurchase()) {
            Map srcEntryIdMaxPurchaseMap;
            int supplierSize = this.getSupplierGroupSize();
            HashMap<String, Object> erpSourceEntryidOrderEntryMap = new HashMap<String, Object>();
            DynamicObject sourceDyo = this.getModel().getDataEntity(true);
            HashMap<String, BigDecimal> srcEntryIdQtyMap = new HashMap<String, BigDecimal>();
            String erpSourceBillType = "";
            for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
                DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection(PRODLIST_ETNRY + supplierIndex);
                for (Object dyo : dyoCol) {
                    String string = dyo.getString("erpsourceentryid" + supplierIndex);
                    if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
                    erpSourceBillType = dyo.getString("erpsourcebilltype" + supplierIndex);
                    erpSourceEntryidOrderEntryMap.put(string, dyo);
                    srcEntryIdQtyMap.put(string, dyo.getBigDecimal("qty" + supplierIndex));
                }
            }
            if (ObjectUtils.isEmpty(erpSourceEntryidOrderEntryMap)) {
                return true;
            }
            MalMaxPurchaseQtyService malMaxPurchaseQtyService = MalMaxPurchaseQtyService.getInstance((String)erpSourceBillType);
            if (malMaxPurchaseQtyService != null && !(srcEntryIdMaxPurchaseMap = malMaxPurchaseQtyService.checkMaxPurchaseQty(srcEntryIdQtyMap)).isEmpty()) {
                HashMap<String, String> tempCacheMap = new HashMap<String, String>(srcEntryIdMaxPurchaseMap.size() << 2);
                for (Map.Entry entry : srcEntryIdMaxPurchaseMap.entrySet()) {
                    tempCacheMap.put(this.getMaxPurchaseKey((String)entry.getKey()), ((BigDecimal)entry.getValue()).stripTrailingZeros().toPlainString());
                    if (((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) > 0) continue;
                    DynamicObject orderEntry = (DynamicObject)erpSourceEntryidOrderEntryMap.get(entry.getKey());
                    String suffix = orderEntry.getDynamicObjectType().getName().substring(orderEntry.getDynamicObjectType().getName().length() - 1);
                    String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5546\u54c1\u201c{0}\u201d\u7684\u6700\u5927\u53ef\u7533\u8bf7\u6570\u91cf\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u3002", (String)"MalPlaceOrderPlugin_65", (String)"scm-mal-formplugin", (Object[])new Object[]{orderEntry.getString("goodsname" + suffix)});
                    this.getView().showMessage(msg);
                    return false;
                }
                this.getPageCache().put(tempCacheMap);
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u5546\u54c1\u7684\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u6700\u5927\u7533\u8bf7\u6570\u91cf\uff0c\u662f\u5426\u81ea\u52a8\u4fee\u6539\u4e3a\u6700\u5927\u53ef\u7533\u8bf7\u6570\u91cf\uff1f", (String)"MalPlaceOrderPlugin_61", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(REPAIRE_QTY, (IFormPlugin)this));
                return false;
            }
        }
        return true;
    }

    private String getMaxPurchaseKey(String srcEntryId) {
        return MAX_PURCHASE_PREFIX + srcEntryId;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object entity = arg0.getSource();
        String fieldName = arg0.getFieldName();
        long orgId = RequestContext.get().getOrgId();
        Object deporg = this.getModel().getValue("deporg");
        if (null != deporg) {
            orgId = ((DynamicObject)deporg).getLong("id");
        }
        if (entity instanceof CardEntry && ((CardEntry)entity).getKey().startsWith(PRODLIST_ETNRY)) {
            String entityKey = ((Control)entity).getKey();
            String supplierIndex = entityKey.replace(PRODLIST_ETNRY, "");
            int currentIndex = this.getModel().getEntryCurrentRowIndex(PRODLIST_ETNRY + supplierIndex);
            DynamicObject row = this.getModel().getEntryRowEntity(PRODLIST_ETNRY + supplierIndex, currentIndex);
            String source = this.getModel().getValue("source" + supplierIndex).toString();
            String goodsId = null;
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                goodsId = row.getString("goods" + supplierIndex);
                if (fieldName.contains("viewladderprice")) {
                    ArrayList<Long> goodsIds = new ArrayList<Long>(1);
                    goodsIds.add(Long.parseLong(goodsId));
                    Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)orgId);
                    if (null != goodsMap.get(Long.parseLong(goodsId))) {
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setFormId("pbd_ladderprice");
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        HashMap<String, String> detailParamMap = new HashMap<String, String>();
                        detailParamMap.put("status", "1");
                        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(goodsMap.get(Long.parseLong(goodsId))));
                        showParameter.setCustomParams(detailParamMap);
                        this.getView().showForm(showParameter);
                    }
                    return;
                }
            } else {
                goodsId = row.getString("goodsnum" + supplierIndex);
            }
            if (fieldName.contains("comparedetail")) {
                String newGoodsId = goodsId;
                List entryArray = (List)this.getCustomParams().get("slectProd");
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                    for (Map map : entryArray) {
                        Object goodsNum = map.get("cart_number");
                        if (!goodsNum.equals(goodsId)) continue;
                        newGoodsId = String.valueOf(map.get("cart_goods"));
                    }
                }
                Object pricemonitortab = this.getModel().getValue("pricemonitortab");
                ArrayList<String> invisibletabs = new ArrayList<String>(16);
                if (null != pricemonitortab) {
                    String[] tabs;
                    for (String tab : tabs = String.valueOf(pricemonitortab).split(",")) {
                        if (StringUtils.isEmpty((CharSequence)tab)) continue;
                        invisibletabs.add(tab);
                    }
                }
                MalPriceMonitorService service = new MalPriceMonitorService();
                ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
                MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)Long.parseLong(newGoodsId), (String)source, (BigDecimal)BigDecimal.ONE, null, (Long)orgId);
                param.setCompareId(Long.valueOf(row.getLong("compareid" + supplierIndex)));
                malMatGoodsInitParams.add(param);
                Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
                if (!service.checkIsShowPriceMonitorForm((MalGoods)malGoodsMap.get(Long.parseLong(newGoodsId)), invisibletabs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6bd4\u4ef7\u8bb0\u5f55\u3001\u540c\u6b3e\u5546\u54c1\u3001\u534a\u5e74\u5185\u7684\u5386\u53f2\u4ef7\u683c\u548c\u672c\u7ec4\u7ec7\u4ea4\u6613\u4ef7\u6570\u636e\u3002", (String)"MalPlaceOrderPlugin_88", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("mal_pricemonitordetail");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
                detailParamMap.put("goodsId", newGoodsId);
                detailParamMap.put("source", source);
                detailParamMap.put("org", orgId);
                detailParamMap.put("compareid", row.getLong("compareid" + supplierIndex));
                detailParamMap.put("sourceForm", this.getModel().getDataEntity().getDataEntityType().getName());
                detailParamMap.put("invisibletabs", SerializationUtils.toJsonString(invisibletabs));
                detailParamMap.put("purchase_org", this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
                showParameter.setCustomParams(detailParamMap);
                this.getView().showForm(showParameter);
                return;
            }
            String caption = row.getString("goodsname" + supplierIndex);
            MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)goodsId, (String)source, (String)caption, (ShowType)ShowType.NewWindow);
        }
    }

    public void makeOrder() {
        long start = System.currentTimeMillis();
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        Map<String, DynamicObject> platformToMalOrderDynMap = this.prepareMalOrderDyn(malPlaceOrderVo);
        MalCreateOrderResult malCreateOrderResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).createMalOrder(malPlaceOrderVo, platformToMalOrderDynMap);
        if (malCreateOrderResult.getErrorMsgs().isEmpty()) {
            HashSet<Long> successIds = new HashSet<Long>(2);
            String tempUploadUrl = this.getPageCache().get("tempuploadurl");
            for (DynamicObject malOrderDyn : platformToMalOrderDynMap.values()) {
                this.createAttachment(malOrderDyn.getLong("id"), tempUploadUrl);
                successIds.add(malOrderDyn.getLong("id"));
            }
            this.doAuto2ComparePriceRecord(successIds);
            this.showOrderList(successIds);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u4e0b\u5355\u5931\u8d25\u3002", (String)"MalPlaceOrderPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]), StringUtils.join((Object[])malCreateOrderResult.getErrorMsgs().toArray(), (String)System.lineSeparator()), MessageTypes.Default);
        }
        log.info("\u4e0b\u5355\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    private void doAuto2ComparePriceRecord(Set<Long> successIds) {
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        Map supplierIdToPlaceOrderEntityMap = malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        ArrayList<Long> goodsIds = new ArrayList<Long>(16);
        for (Map.Entry map : supplierIdToPlaceOrderEntityMap.entrySet()) {
            MalPlaceOrderEntity value = (MalPlaceOrderEntity)map.getValue();
            List placeOrderItemList = value.getPlaceOrderItemList();
            for (MalPlaceOrderItem item : placeOrderItemList) {
                if (item.getCompareId() != null && 0L != item.getCompareId()) continue;
                long goodsId = item.getGoodsId();
                goodsIds.add(goodsId);
            }
        }
        if (goodsIds.size() == 0) {
            return;
        }
        dataMap.put("goodsIds", goodsIds);
        dataMap.put("orderIds", successIds);
        dataMap.put("opuserId", RequestContext.get().getCurrUserId());
        DynamicObject depOrgDyn = (DynamicObject)this.getModel().getValue("deporg");
        dataMap.put("orgId", depOrgDyn.getLong("id"));
        EventServiceHelper.triggerEventSubscribe((String)"mal_placeorder_makeorder", (String)SerializationUtils.toJsonString(dataMap));
    }

    private Map<String, DynamicObject> prepareMalOrderDyn(MalPlaceOrderVo malPlaceOrderVo) {
        HashMap<String, DynamicObject> res = new HashMap<String, DynamicObject>(16);
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        int supplierIndex = 0;
        for (Map.Entry supplierIdToPlaceOrderEntityEntry : malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().entrySet()) {
            MalPlaceOrderEntity malPlaceOrderEntity = (MalPlaceOrderEntity)supplierIdToPlaceOrderEntityEntry.getValue();
            DynamicObject malOrderDyn = res.getOrDefault(malPlaceOrderEntity.getPlatform(), CommonUtil.createDefaultDyn((String)"mal_order"));
            this.handleOrderHeadInfo(malOrderDyn, sourceDyo);
            this.handleOrderEntryInfo(sourceDyo, malOrderDyn, ++supplierIndex);
            res.put(malPlaceOrderEntity.getPlatform(), malOrderDyn);
        }
        return res;
    }

    public void handleOrderEntryInfo(DynamicObject sourceDyo, DynamicObject orderDyo, int supplierIndex) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)orderDyo.get(PRODLIST_ETNRY);
        EntryProp sourceEntryProp = (EntryProp)sourceDyo.getDataEntityType().getProperties().get((Object)(PRODLIST_ETNRY + supplierIndex));
        List sourceEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)sourceEntryProp.getItemType());
        sourceEntryProList.remove("id");
        EntryProp orderEntryProp = (EntryProp)orderDyo.getDataEntityType().getProperties().get((Object)PRODLIST_ETNRY);
        List orderEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)orderEntryProp.getItemType());
        DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection(PRODLIST_ETNRY + supplierIndex);
        for (DynamicObject dyo : dyoCol) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("supplier", sourceDyo.get("supplier" + supplierIndex));
            entryDyo.set("note", sourceDyo.get("remark" + supplierIndex));
            for (String proKey : sourceEntryProList) {
                String key = proKey.replace(String.valueOf(supplierIndex), "");
                if (!orderEntryProList.contains(key)) continue;
                entryDyo.set(key, dyo.get(proKey));
            }
        }
        orderDyo.set(PRODLIST_ETNRY, (Object)entryDyoCol);
    }

    private void handleOrderHeadInfo(DynamicObject malOrderDyn, DynamicObject sourceDyo) {
        ArrayList<String> sourcePropertyList = new ArrayList<String>();
        DataEntityPropertyCollection sourcePropertyCol = sourceDyo.getDataEntityType().getProperties();
        for (IDataEntityProperty sourceProperty : sourcePropertyCol) {
            sourcePropertyList.add(sourceProperty.getName());
        }
        ArrayList<String> orderPropertyList = new ArrayList<String>();
        DataEntityPropertyCollection orderPropertyCol = malOrderDyn.getDataEntityType().getProperties();
        for (IDataEntityProperty orderProperty : orderPropertyCol) {
            orderPropertyList.add(orderProperty.getName());
        }
        for (String proKey : sourcePropertyList) {
            if (!orderPropertyList.contains(proKey) || proKey.startsWith(PRODLIST_ETNRY)) continue;
            malOrderDyn.set(proKey, sourceDyo.get(proKey));
        }
    }

    private boolean checkSelfStock() {
        boolean selfInventoryUnlimited;
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        Map supplierIdToPlaceOrderEntityMap = malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap();
        ArrayList malMatGoodsInitParamList = new ArrayList(supplierIdToPlaceOrderEntityMap.size());
        HashMap goodsIdAndPlaceQtyMap = new HashMap(supplierIdToPlaceOrderEntityMap.size());
        HashMap goodsIdAndNumberMap = new HashMap(supplierIdToPlaceOrderEntityMap.size());
        supplierIdToPlaceOrderEntityMap.forEach((supplierId, entity) -> {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(entity.getPlatform())) {
                List placeOrderItemList = entity.getPlaceOrderItemList();
                for (MalPlaceOrderItem malPlaceOrderItem : placeOrderItemList) {
                    MalMatGoodsInitParam malMatGoodsInitParam = new MalMatGoodsInitParam();
                    malMatGoodsInitParam.setGoodsId(malPlaceOrderItem.getGoodsId());
                    malMatGoodsInitParam.setPlatform(malPlaceOrderItem.getPlatform());
                    malMatGoodsInitParamList.add(malMatGoodsInitParam);
                    goodsIdAndPlaceQtyMap.put(malPlaceOrderItem.getGoodsId(), malPlaceOrderItem.getQty());
                    goodsIdAndNumberMap.put(malPlaceOrderItem.getGoodsId(), malPlaceOrderItem.getGoodsNumber());
                }
            }
        });
        if (malMatGoodsInitParamList.isEmpty()) {
            return true;
        }
        Map stockMap = MalStock.batchInstanceOfGoodsInitParam(malMatGoodsInitParamList);
        StringBuilder goodsNumberSb = new StringBuilder();
        stockMap.forEach((id, stock) -> {
            BigDecimal placeQty = (BigDecimal)goodsIdAndPlaceQtyMap.get(id);
            if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(stock, placeQty)) {
                goodsNumberSb.append((String)goodsIdAndNumberMap.get(id)).append("\n");
            }
        });
        if (goodsNumberSb.length() > 0 && !(selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4e0b\u5355\u3002", (String)"MalPlaceOrderPlugin_84", (String)"scm-mal-formplugin", (Object[])new Object[0]), goodsNumberSb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    @Deprecated
    protected void checkFrieght() {
    }

    private boolean checkFreight() {
        DynamicObject currObj = (DynamicObject)this.getModel().getDataEntity(true).get("curr");
        String curr = String.valueOf(currObj.get("name"));
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        Map supplierIdToPlaceOrderEntityMap = malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap();
        StringBuilder msg = new StringBuilder();
        for (MalPlaceOrderEntity malPlaceOrderEntity : supplierIdToPlaceOrderEntityMap.values()) {
            BigDecimal freight;
            MalFreightInfo malFreightInfo = malPlaceOrderEntity.getMalFreightInfo();
            if (malFreightInfo == null || (freight = malFreightInfo.getFreight()).compareTo(BigDecimal.ZERO) <= 0) continue;
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malPlaceOrderEntity.getPlatform()) && malFreightInfo.getDifferenceAmount().compareTo(BigDecimal.ZERO) > 0) {
                msg.append(ResManager.loadKDString((String)"{0}\u7684\u8ba2\u5355\u8fd8\u5dee{1}{2}\u5305\u90ae\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalPlaceOrderPlugin_79", (String)"scm-mal-formplugin", (Object[])new Object[]{malFreightInfo.getSupplierName(), malFreightInfo.getDifferenceAmount().stripTrailingZeros(), curr})).append(System.lineSeparator());
                continue;
            }
            msg.append(ResManager.loadKDString((String)"{0}\u7684\u8ba2\u5355\u5305\u542b\u8fd0\u8d39\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalPlaceOrderPlugin_80", (String)"scm-mal-formplugin", (Object[])new Object[]{malFreightInfo.getSupplierName()})).append(System.lineSeparator());
        }
        if (msg.length() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("make_order", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u60a8\u7684\u8ba2\u5355\u5305\u542b\u8fd0\u8d39\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MalPlaceOrderPlugin_53", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, String.valueOf(msg), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return false;
        }
        return true;
    }

    private MalPlaceOrderVo getMalPlaceOrderVo() {
        String content = this.getPageCache().get(MAL_PLACE_ORDER_VO);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            return (MalPlaceOrderVo)SerializationUtils.fromJsonString((String)content, MalPlaceOrderVo.class);
        }
        return new MalPlaceOrderVo();
    }

    @Deprecated
    protected String checkMaterialAndPurType(DynamicObjectCollection entryentityCol, int supplierIndex) {
        return "";
    }

    protected boolean checkMaterialAndPurTypeUseServAttr(DynamicObject materialDyn, DynamicObject purtypeDyn) {
        if (materialDyn != null && purtypeDyn != null) {
            Set serviceAttrIdSet = MalPlaceOrderUtils.getServiceAttrIdSetByMaterial((DynamicObject)materialDyn);
            Long serviceAttrIdByPurType = this.getServiceAttrByPurType(purtypeDyn);
            return serviceAttrIdSet.isEmpty() && serviceAttrIdByPurType == 0L || serviceAttrIdSet.contains(serviceAttrIdByPurType);
        }
        return false;
    }

    public void showOrderList(Set<Long> billIdSet) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_newshopcenter");
        fsp.setCustomParam("showFormId", (Object)"mal_order");
        fsp.setCustomParam("formType", (Object)"1");
        fsp.setCustomParam("LINK_QUERY_PK_IDS", new ArrayList<Long>(billIdSet));
        fsp.setAppId("mal");
        fsp.setShowTitle(false);
        fsp.setShowClose(false);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSEMAKEORDER));
        fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm(fsp);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        DynamicObject settleOrgDyo;
        Long orgId;
        int rowIndex;
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if (fieldKey.startsWith("qty")) {
            BigDecimal newVal;
            String index = fieldKey.substring(3);
            rowIndex = changedData[0].getRowIndex();
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            if (oldVal.compareTo(newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue())) == 0) {
                return;
            }
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                model.setValue("qty" + index, (Object)oldVal, rowIndex);
            } else {
                try {
                    MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
                    for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
                        String goods = String.valueOf(this.getModel().getValue("goods" + index, rowIndex));
                        if (!String.valueOf(malToPlaceOrderItem.getGoodsId()).equals(goods) && !malToPlaceOrderItem.getGoodsNumber().equals(goods)) continue;
                        malToPlaceOrderItem.setQty(newVal);
                    }
                    this.updatePage(malToPlaceOrderParam);
                }
                catch (Exception exception) {
                    model.setValue("qty" + index, (Object)oldVal, rowIndex);
                    this.getView().showMessage(exception.getMessage());
                    return;
                }
                this.updateQtyDesc(newVal, index, rowIndex);
                this.getView().updateView();
            }
        }
        if (StringUtils.equals((CharSequence)"reqperson", (CharSequence)fieldKey)) {
            DynamicObject reqPersonDyo = (DynamicObject)changedData[0].getNewValue();
            if (StringUtils.isBlank((Object)reqPersonDyo)) {
                return;
            }
            IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
            Long dptOrgId = malOrgService.getDefaultDemandOrgByUser(Long.valueOf(reqPersonDyo.getLong("id")));
            if (dptOrgId != 0L) {
                List dptList = malOrgService.getDemandOrgList(Long.valueOf(reqPersonDyo.getLong("id")));
                DynamicObject currDpt = (DynamicObject)this.getModel().getValue("deporg");
                if (MalOrgServiceFactory.hasDelegantRalation()) {
                    if (null != currDpt) {
                        Long curDptPk = currDpt.getLong("id");
                        if (!dptList.contains(curDptPk)) {
                            this.getModel().setValue("deporg", (Object)dptOrgId);
                        }
                        QFilter filter = new QFilter("id", "in", (Object)dptList);
                        BasedataEdit depEdit = (BasedataEdit)this.getView().getControl("deporg");
                        depEdit.setQFilter(filter);
                    }
                } else {
                    this.getModel().setValue("deporg", (Object)dptOrgId);
                }
            } else {
                this.clearOrg();
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u4eba\u6240\u5c5e\u90e8\u95e8\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalPlaceOrderPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)"deporg", (CharSequence)fieldKey)) {
            this.doDeptOrgProchange(e);
        }
        if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey)) {
            DynamicObject purOrg = (DynamicObject)changedData[0].getNewValue();
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
            try {
                Long invOrgId = malOrgService.getDefaultInvOrg(purOrgId);
                this.setOrg("rcvorg", invOrgId);
                if (MalOrgServiceFactory.hasDelegantRalation()) {
                    orgId = malOrgService.getDefaultSettleOrg(purOrgId, invOrgId);
                } else {
                    DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
                    Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
                    orgId = malOrgService.getDefaultSettleOrg(dptOrgId, purOrgId);
                }
                this.setOrg("settleorg", orgId);
            }
            catch (Exception exception) {
                this.getView().showTipNotification(exception.getMessage());
            }
        }
        if (StringUtils.equals((CharSequence)"rcvorg", (CharSequence)fieldKey)) {
            DynamicObject invOrg = (DynamicObject)changedData[0].getNewValue();
            DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
            Long invOrgId = invOrg != null ? invOrg.getLong("id") : 0L;
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
            if (MalOrgServiceFactory.hasDelegantRalation()) {
                orgId = malOrgService.getDefaultSettleOrg(purOrgId, invOrgId);
            } else {
                DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("deporg");
                Long dptOrgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
                orgId = malOrgService.getDefaultSettleOrg(dptOrgId, purOrgId);
            }
            this.setOrg("settleorg", orgId);
        }
        if (StringUtils.equals((CharSequence)"settleorg", (CharSequence)fieldKey) && null != (settleOrgDyo = (DynamicObject)changedData[0].getNewValue())) {
            this.getModel().setValue("invoiceorg", (Object)settleOrgDyo.getLong("id"));
        }
        if (StringUtils.equals((CharSequence)"businesstype", (CharSequence)fieldKey)) {
            Object oldBizType = changedData[0].getOldValue();
            if (!Objects.isNull(oldBizType)) {
                this.getPageCache().put(OLDBIZTYPE, ((DynamicObject)oldBizType).getString("id"));
            }
            DynamicObject newBizType = (DynamicObject)changedData[0].getNewValue();
            boolean isGoodsBizType = MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)newBizType);
            this.getPageCache().put(ISGOODSBIZTYPE, String.valueOf(isGoodsBizType));
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("change_biztype", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u4fee\u6539\u4e1a\u52a1\u7c7b\u578b\u4f1a\u91cd\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u7684\u91c7\u8d2d\u7c7b\u578b\u5e76\u6e05\u7a7aERP\u7269\u6599\uff0c\u662f\u5426\u4fee\u6539\uff1f", (String)"MalPlaceOrderPlugin_42", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
        if (StringUtils.equals((CharSequence)"settleorg", (CharSequence)fieldKey)) {
            this.doSettleOrgChange(changedData);
        }
        if (fieldKey.startsWith("material")) {
            int rowIndex2 = e.getChangeSet()[0].getRowIndex();
            Object newValue2 = e.getChangeSet()[0].getNewValue();
            if (newValue2 != null) {
                DynamicObject materialDyn = (DynamicObject)newValue2;
                String index = fieldKey.substring("material".length());
                Object purTypeDyn = this.getModel().getValue("purtype" + index, rowIndex2);
                if (purTypeDyn != null && !Parser.toBoolean((Object)this.getPageCache().get(ISGOODSBIZTYPE)) && !this.checkMaterialAndPurTypeUseServAttr(materialDyn, (DynamicObject)purTypeDyn)) {
                    this.getModel().setValue("purtype" + index, null, rowIndex2);
                }
            }
        }
        if (fieldKey.startsWith("purtype") && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            Object materialDyn;
            rowIndex = e.getChangeSet()[0].getRowIndex();
            String index = fieldKey.substring("purtype".length());
            DynamicObject lineType = ((DynamicObject)newValue).getDynamicObject("linetype");
            if (!Objects.isNull(lineType)) {
                this.getModel().setValue("linetype" + index, (Object)lineType.getLong("id"), rowIndex);
            }
            if ((materialDyn = this.getModel().getValue("material" + index, rowIndex)) != null && !this.checkMaterialAndPurTypeUseServAttr((DynamicObject)materialDyn, (DynamicObject)newValue)) {
                this.getModel().setValue("material" + index, null, rowIndex);
            }
        }
        if (fieldKey.startsWith("goodsuse")) {
            this.doGoodsUseChange(e);
        }
        if ("costproject".equals(fieldKey)) {
            this.doCostProjectChange(e);
        }
        if (fieldKey.startsWith("taxrateid")) {
            String index = fieldKey.substring("taxrateid".length());
            DynamicObject newValue3 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue3 != null) {
                this.getModel().setValue("taxrate" + index, (Object)newValue3.getBigDecimal("taxrate").stripTrailingZeros());
            } else {
                this.getModel().setValue("taxrate" + index, (Object)BigDecimal.ZERO);
            }
        }
    }

    private MalToPlaceOrderParam getMalToPlaceOrderParam() {
        return (MalToPlaceOrderParam)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_MAL_TO_PLACE_ORDER_PARAM), MalToPlaceOrderParam.class);
    }

    private void doSettleOrgChange(ChangeData[] changedData) {
        DynamicObject settleOrgDyo = (DynamicObject)changedData[0].getNewValue();
        if (null != settleOrgDyo) {
            this.getModel().setValue("expenseorg", null);
        }
        this.cleanCostProject();
    }

    private void cleanCostProject() {
        this.getModel().setValue("costproject", null);
        int supplierSize = this.getSupplierGroupSize();
        for (int i = 1; i <= supplierSize; ++i) {
            int totalRows = this.getModel().getEntryEntity(PRODLIST_ETNRY + i).size();
            for (int index = 0; index < totalRows; ++index) {
                this.getModel().setValue("entrycostproject" + i, null, index);
                this.getModel().setValue("goodsuse" + i, null, index);
            }
        }
    }

    private void doCostProjectChange(PropertyChangedArgs e) {
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int supplierSize = this.getSupplierGroupSize();
        for (int i = 1; i <= supplierSize; ++i) {
            int totalRows = this.getModel().getEntryEntity(PRODLIST_ETNRY + i).size();
            for (int index = 0; index < totalRows; ++index) {
                if (this.getModel().getValue("entrycostproject" + i, index) != null) continue;
                this.getModel().setValue("entrycostproject" + i, (Object)newValue.getLong("id"), index);
            }
        }
    }

    private void doGoodsUseChange(PropertyChangedArgs e) {
        DynamicObject newDyo = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String index = e.getProperty().getName().substring(8);
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"entrycostproject" + index});
        Set<String> lockIndexSet = new HashSet();
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("entrycostproject_lock"))) {
            lockIndexSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("entrycostproject_lock"), Set.class);
            lockIndexSet.remove(rowIndex + index);
        }
        if (newDyo == null) {
            return;
        }
        DynamicObject targetCurrDyn = (DynamicObject)this.getModel().getValue("curr");
        Long targetCurr = targetCurrDyn != null ? targetCurrDyn.getLong("id") : 0L;
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(PRODLIST_ETNRY + index, rowIndex);
        BigDecimal goodsPrice = rowEntity.getBigDecimal("goodprice" + index);
        BigDecimal goodsAmount = rowEntity.getBigDecimal("goodamount" + index);
        Object sku = rowEntity.get("goods" + index);
        long goodsId = Long.parseLong(String.valueOf(sku));
        if (goodsId == 0L) {
            log.info("\u901a\u8fc7sku\u83b7\u53d6\u7535\u5546id\u5931\u8d25\uff1a\u7535\u5546\u7f16\u7801\uff1a" + rowEntity.getLong("goods" + index));
            return;
        }
        DynamicObject goods = QueryServiceHelper.queryOne((String)"pbd_goods", (String)"category", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)goodsId)});
        QFilter qFilter = new QFilter("gooduse", "=", (Object)newDyo.getLong("id"));
        DynamicObject dptOrg = (DynamicObject)this.getModel().getValue("settleorg");
        Long orgId = dptOrg != null ? dptOrg.getLong("id") : 0L;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_goods_expense", (Long)orgId);
        qFilter.and(baseDataFilter);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("group", "=", (Object)goods.getLong("category"));
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"pmm_goods_expense", (String)"curr,controltype,entryentity.qtyfrom qtyfrom,entryentity.qtyto qtyto,entryentity.pricefrom pricefrom,entryentity.priceto priceto,entryentity.expenseitem expenseitem", (QFilter[])qFilter.toArray());
        HashMap<Long, BigDecimal> exchangeMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject row : dataSet) {
            if (exchangeMap.containsKey(row.getLong("curr"))) continue;
            exchangeMap.put(row.getLong("curr"), ExchangeHelper.getExChangeRateByOrg((Long)targetCurr, (Long)row.getLong("curr"), (Long)orgId));
        }
        for (DynamicObject row : dataSet) {
            String compareToField;
            String compareFromField;
            BigDecimal compareNum;
            BigDecimal exChangeRate = (BigDecimal)exchangeMap.get(row.getLong("curr"));
            if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exChangeRate = BigDecimal.ONE;
            }
            if (PRODMATMAPPING_PARAM.equals(row.getString("controltype"))) {
                compareNum = goodsPrice;
                compareFromField = "pricefrom";
                compareToField = "priceto";
            } else {
                compareNum = goodsAmount;
                compareFromField = "qtyfrom";
                compareToField = "qtyto";
            }
            if (compareNum.compareTo(row.getBigDecimal(compareFromField).multiply(exChangeRate)) < 0 || row.getBigDecimal(compareToField).compareTo(BigDecimal.ZERO) != 0 && compareNum.compareTo(row.getBigDecimal(compareToField).multiply(exChangeRate)) >= 0) continue;
            this.getModel().setValue("entrycostproject" + index, (Object)row.getLong("expenseitem"), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entrycostproject" + index});
            lockIndexSet.add(rowIndex + "_" + index);
            break;
        }
        if (!lockIndexSet.isEmpty()) {
            this.getPageCache().put("entrycostproject_lock", SerializationUtils.toJsonString(lockIndexSet));
        }
        this.getView().updateView();
    }

    private void doDeptOrgProchange(PropertyChangedArgs e) {
        MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
        boolean showConfirm = false;
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malToPlaceOrderItem.getPlatform())) continue;
            showConfirm = true;
            break;
        }
        DynamicObject newDeptOrgDyn = (DynamicObject)e.getChangeSet()[0].getNewValue();
        String newDeptOrgId = "";
        if (newDeptOrgDyn != null) {
            newDeptOrgId = newDeptOrgDyn.getString("id");
        }
        if (showConfirm) {
            DynamicObject oldDeptOrgDyn = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldDeptOrgId = "";
            if (oldDeptOrgDyn != null) {
                oldDeptOrgId = oldDeptOrgDyn.getString("id");
            }
            this.getPageCache().put(NEW_DEPT_ORG_ID, newDeptOrgId);
            this.getPageCache().put(OLD_DEPT_ORG_ID, oldDeptOrgId);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deptorg", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5546\u54c1\u5b58\u5728\u7ec4\u7ec7\u9694\u79bb\uff0c\u5207\u6362\u7533\u8bf7\u7ec4\u7ec7\uff0c\u5c06\u5220\u9664\u4e0d\u53ef\u89c1\u7684\u5546\u54c1\uff0c\u786e\u8ba4\u8981\u5207\u6362\u5417\uff1f", (String)"MalPlaceOrderPlugin_63", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.updateByDeptOrgChange(StringUtils.isBlank((CharSequence)newDeptOrgId) ? 0L : Long.parseLong(newDeptOrgId));
        }
    }

    private void updateByDeptOrgChange(Long newDeptOrgId) {
        MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
        malToPlaceOrderParam.setDptOrgId(newDeptOrgId);
        String firstDeporg = this.getPageCache().get(FIRST_DEPORG);
        Object compareStr = this.getView().getFormShowParameter().getCustomParam(COMPAREPRICE);
        if (!ObjectUtils.isEmpty((Object)compareStr)) {
            Map compareMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(compareStr), Map.class);
            for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
                if (!StringUtils.equals((CharSequence)String.valueOf(newDeptOrgId), (CharSequence)firstDeporg)) {
                    malToPlaceOrderItem.setCompareId(Long.valueOf(0L));
                    continue;
                }
                String compareId = (String)compareMap.get(String.valueOf(malToPlaceOrderItem.getGoodsId()));
                malToPlaceOrderItem.setCompareId(Long.valueOf(StringUtils.isBlank((CharSequence)compareId) ? 0L : Long.parseLong(compareId)));
            }
        }
        this.updatePage(malToPlaceOrderParam);
        MalOrgRelation malOrgRelation = ((MalOrgRelationService)MalBusinessFactory.serviceOf(MalOrgRelationService.class)).getOrgRelationByDptOrgId(newDeptOrgId);
        this.fillOrg(malOrgRelation);
        if (!"A".equals(this.getModel().getValue("receipttype"))) {
            List userAllReceipt = ((MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class)).getAllSharingReceiptByOrg(newDeptOrgId);
            Set receiptIds = userAllReceipt.stream().map(MalReceipt::getReceiptId).collect(Collectors.toSet());
            if (StringUtils.isBlank((Object)this.getModel().getValue("receipt")) || !receiptIds.contains(Long.valueOf((String)this.getModel().getValue("receipt")))) {
                if (userAllReceipt.isEmpty()) {
                    this.fillReceipt(new MalReceipt());
                } else {
                    this.fillReceipt((MalReceipt)userAllReceipt.get(0));
                }
            }
        }
        this.cleanCostProject();
        this.getView().updateView();
    }

    private void fillOrg(MalOrgRelation malOrgRelation) {
        this.getModel().beginInit();
        this.getModel().setValue("deporg", (Object)malOrgRelation.getDepOrgId());
        this.getModel().setValue("costorg", (Object)malOrgRelation.getCostOrgId());
        this.getModel().setValue("org", (Object)malOrgRelation.getPurOrgId());
        this.getModel().setValue("rcvorg", (Object)malOrgRelation.getRcvOrgId());
        this.getModel().setValue("settleorg", (Object)malOrgRelation.getSettleOrgId());
        this.getModel().setValue("invoiceorg", (Object)malOrgRelation.getInvoiceOrgId());
        this.getModel().setValue("expenseorg", (Object)malOrgRelation.getExpenseOrgId());
        this.getModel().endInit();
    }

    private void updateQtyDesc(BigDecimal newQty, String index, int rowIndex) {
        String erpSourceEntryId = (String)this.getModel().getValue("erpsourceentryid" + index, rowIndex);
        String maxPurchaseQtyStr = this.getPageCache().get(this.getMaxPurchaseKey(erpSourceEntryId));
        this.getModel().setValue(DESC_QTY + index, (Object)this.getQtyDesc(newQty, maxPurchaseQtyStr), rowIndex);
    }

    private Long getServiceAttrByPurType(DynamicObject purTypeDyn) {
        DynamicObject lineType;
        Object lineTypeId;
        if (purTypeDyn != null && (lineTypeId = purTypeDyn.get("linetype.id")) != null && (lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype")) != null) {
            return lineType.getLong("serviceattribute.id");
        }
        return 0L;
    }

    private void deleteSelectedEntry() {
        int supplierSize = this.getSupplierGroupSize();
        int selectedSum = 0;
        int totalGoods = 0;
        for (int i = 1; i <= supplierSize; ++i) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(PRODLIST_ETNRY + i);
            DynamicObjectCollection dyoCol = this.getModel().getEntryEntity(PRODLIST_ETNRY + i);
            totalGoods += dyoCol.size();
            if (entryGrid == null) continue;
            int[] selectIndexArr = entryGrid.getEntryState().getSelectedRows();
            selectedSum += selectIndexArr.length;
        }
        if (selectedSum == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalPlaceOrderPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (totalGoods == selectedSum || totalGoods < 2) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u624d\u80fd\u8fdb\u884c\u7ed3\u7b97\uff0c\u4e0d\u80fd\u5168\u90e8\u5220\u9664\u3002", (String)"MalPlaceOrderPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("goods_remove", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u5546\u54c1\uff1f", (String)"MalPlaceOrderPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"make_order", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && this.validateMalGoodsMonitorRule()) {
            this.makeOrder();
        }
        if (StringUtils.equals((CharSequence)"notifymsg", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.makeOrder();
        }
        if (StringUtils.equals((CharSequence)"deptorg", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String newDeptOrgId = this.getPageCache().get(NEW_DEPT_ORG_ID);
                this.updateByDeptOrgChange(StringUtils.isBlank((CharSequence)newDeptOrgId) ? 0L : Long.parseLong(newDeptOrgId));
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("deporg", (Object)this.getPageCache().get(OLD_DEPT_ORG_ID));
                this.getModel().endInit();
                this.getView().updateView("deporg");
            }
        }
        if (StringUtils.equals((CharSequence)"goods_remove", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            int supplierSize = this.getSupplierGroupSize();
            MalToPlaceOrderParam malToPlaceOrderParam = this.getMalToPlaceOrderParam();
            for (int i = 1; i <= supplierSize; ++i) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(PRODLIST_ETNRY + i);
                if (entryGrid == null) continue;
                int[] selectIndexArr = entryGrid.getEntryState().getSelectedRows();
                ArrayList<String> goodsIdList = new ArrayList<String>(selectIndexArr.length);
                for (int k : selectIndexArr) {
                    Object goodsId = this.getModel().getValue("goods" + i, k);
                    if (ObjectUtils.isEmpty((Object)goodsId)) continue;
                    goodsIdList.add(String.valueOf(goodsId));
                }
                this.getModel().deleteEntryRows(PRODLIST_ETNRY + i, selectIndexArr);
                malToPlaceOrderParam.getMalToPlaceOrderItemList().removeIf(malToPlaceOrderItem -> goodsIdList.contains(String.valueOf(malToPlaceOrderItem.getGoodsId())));
            }
            this.updatePage(malToPlaceOrderParam);
        }
        if (StringUtils.equals((CharSequence)"change_biztype", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int supplierSize = this.getSupplierGroupSize();
                DynamicObject biztype = (DynamicObject)this.getModel().getValue("businesstype");
                Map<String, Long> purTypeMap = this.getDefaultPurType(biztype);
                for (int i = 1; i <= supplierSize; ++i) {
                    int totalRows = this.getModel().getEntryEntity(PRODLIST_ETNRY + i).size();
                    for (int index = 0; index < totalRows; ++index) {
                        this.getModel().setValue("purtype" + i, (Object)purTypeMap.get("purtype"), index);
                        this.getModel().setValue("linetype" + i, (Object)purTypeMap.get("linetype"), index);
                        this.getModel().setValue("material" + i, null, index);
                    }
                }
                boolean isGoodsBiztype = Parser.toBoolean((Object)this.getPageCache().get(ISGOODSBIZTYPE));
                this.setGoodsBiztypeMustInput(isGoodsBiztype);
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("businesstype", (Object)this.getPageCache().get(OLDBIZTYPE));
                this.getView().updateView("businesstype");
                this.getModel().endInit();
            }
        }
        if (StringUtils.equals((CharSequence)REPAIRE_QTY, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.repaireQty();
            } else {
                this.showExceededQty();
            }
        }
    }

    private void showExceededQty() {
        int supplierSize = this.getSupplierGroupSize();
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        Map tempCacheMap = this.getPageCache().getAll();
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection(PRODLIST_ETNRY + supplierIndex);
            for (int i = 0; i < dyoCol.size(); ++i) {
                String erpSourceEntryId = ((DynamicObject)dyoCol.get(i)).getString("erpsourceentryid" + supplierIndex);
                String maxPurchaseQtyStr = (String)tempCacheMap.get(this.getMaxPurchaseKey(erpSourceEntryId));
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty" + supplierIndex, i);
                this.getModel().setValue(DESC_QTY + supplierIndex, (Object)this.getQtyDesc(qty, maxPurchaseQtyStr), i);
            }
        }
    }

    private String getQtyDesc(BigDecimal orderQty, String maxPurchaseQtyStr) {
        if (StringUtils.isEmpty((CharSequence)maxPurchaseQtyStr) || !StringUtils.isNumeric((CharSequence)maxPurchaseQtyStr)) {
            return "";
        }
        if (orderQty.compareTo(new BigDecimal(maxPurchaseQtyStr)) > 0) {
            String msg = ResManager.loadKDString((String)"\u4e0b\u5355\u91cf\u8d85", (String)"MalPlaceOrderPlugin_69", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            return msg + orderQty.subtract(new BigDecimal(maxPurchaseQtyStr)).stripTrailingZeros().toPlainString();
        }
        return "";
    }

    private void repaireQty() {
        int supplierSize = this.getSupplierGroupSize();
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        Map tempCacheMap = this.getPageCache().getAll();
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection(PRODLIST_ETNRY + supplierIndex);
            for (int i = 0; i < dyoCol.size(); ++i) {
                String erpSourceEntryId = ((DynamicObject)dyoCol.get(i)).getString("erpsourceentryid" + supplierIndex);
                String maxPurchaseQtyStr = (String)tempCacheMap.get(this.getMaxPurchaseKey(erpSourceEntryId));
                if (!StringUtils.isNotEmpty((CharSequence)maxPurchaseQtyStr) || !StringUtils.isNumeric((CharSequence)maxPurchaseQtyStr)) continue;
                this.getModel().setValue("qty" + supplierIndex, (Object)new BigDecimal(maxPurchaseQtyStr), i);
            }
        }
    }

    @Deprecated
    protected void bindEntryData(List<Map<String, Object>> entryArray) {
        this.bindEntryData(entryArray, null);
    }

    @Deprecated
    protected void bindEntryData(List<Map<String, Object>> entryArray, DynamicObject bizType) {
    }

    public void upload(UploadEvent evt) {
        Object[] urlMsgs;
        JSONArray urls = new JSONArray();
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
            urls = JSONArray.fromObject((Object)tempUploadUrl);
        }
        if ((urlMsgs = evt.getUrls()) != null && urlMsgs.length > 0) {
            for (int i = 0; i < urlMsgs.length; ++i) {
                Map urlMsg = (Map)urlMsgs[i];
                JSONObject map = new JSONObject();
                for (Map.Entry entry : urlMsg.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                urls.add((Object)map);
            }
        }
        this.getPageCache().put("tempuploadurl", urls.toString());
    }

    public void remove(UploadEvent evt) {
        Object[] urlMsgs = evt.getUrls();
        if (urlMsgs != null && urlMsgs.length > 0) {
            JSONArray urls = new JSONArray();
            String tempUploadUrl = this.getPageCache().get("tempuploadurl");
            if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
                urls = JSONArray.fromObject((Object)tempUploadUrl);
            }
            Map urlMsg = (Map)urlMsgs[0];
            Iterator urlItr = urls.iterator();
            while (urlItr.hasNext()) {
                JSONObject jo = (JSONObject)urlItr.next();
                if (!StringUtils.isNotBlank((CharSequence)jo.getString("uid")) || !StringUtils.equals((CharSequence)jo.getString("uid"), (CharSequence)String.valueOf(urlMsg.get("uid")))) continue;
                urlItr.remove();
            }
            this.getPageCache().put("tempuploadurl", urls.toString());
        }
    }

    public void mark(AttachmentMarkEvent evt) {
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        JSONArray urlMsgs = JSONArray.fromObject((Object)tempUploadUrl);
        JSONArray urls = new JSONArray();
        for (int i = 0; i < urlMsgs.size(); ++i) {
            Map urlMsg = (Map)urlMsgs.get(i);
            JSONObject map = new JSONObject();
            for (Map.Entry entry : urlMsg.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            String id = (String)map.get("uid");
            String uid = evt.getUid();
            String description = evt.getDescription();
            if (id.equals(uid)) {
                map.put((Object)"description", (Object)description);
            }
            urls.add((Object)map);
        }
        this.getPageCache().put("tempuploadurl", urls.toString());
    }

    @Deprecated
    public void createAttachment(Long billPkId) {
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        this.createAttachment(billPkId, tempUploadUrl);
    }

    private void createAttachment(Long billPkId, String tempUploadUrl) {
        Map<String, Object> attachmentMap = this.getAttachmentMap(tempUploadUrl);
        if (attachmentMap.isEmpty()) {
            return;
        }
        AttachmentServiceHelper.saveTempAttachments((String)"mal_order", (Object)billPkId, (String)"mal", attachmentMap);
    }

    private Map<String, Object> getAttachmentMap(String tempUploadUrl) {
        JSONArray urlMsgs;
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl) && (urlMsgs = JSONArray.fromObject((Object)tempUploadUrl)) != null && urlMsgs.size() > 0) {
            ArrayList attachList = new ArrayList(urlMsgs.size());
            for (int i = 0; i < urlMsgs.size(); ++i) {
                HashMap<String, Object> attachMap = new HashMap<String, Object>();
                JSONObject urlMsg = urlMsgs.getJSONObject(i);
                attachMap.put("lastModified", urlMsg.get("lastModified"));
                attachMap.put("name", urlMsg.get("name"));
                attachMap.put("size", urlMsg.get("size"));
                attachMap.put("status", urlMsg.get("status"));
                attachMap.put("type", urlMsg.get("type"));
                attachMap.put("uid", urlMsg.get("uid"));
                attachMap.put("url", urlMsg.get("url"));
                attachMap.put("description", urlMsg.get("description"));
                attachList.add(attachMap);
            }
            if (attachList.size() > 0) {
                res.put("attachmentpanel", attachList);
            }
        }
        return res;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)MAKE_ORDER) && MalOrderUtil.hasAttachmentUploading((IFormView)this.getView())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MalPlaceOrderPlugin_40", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    @Deprecated
    public String checkNotNull() {
        return "";
    }

    @Deprecated
    public boolean isMaterialMustInput() {
        if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)((DynamicObject)this.getModel().getValue("businesstype")))) {
            return false;
        }
        return (Boolean)this.getModel().getValue("needmat");
    }

    @Deprecated
    public String fitNullValue(DynamicObjectCollection dynamicObjectsParam, int i, DynamicObject supplier) {
        return "";
    }

    private void fillReceipt(MalReceipt malReceipt) {
        if (StringUtils.isBlank((CharSequence)malReceipt.getReceiptName())) {
            malReceipt = new MalReceipt();
        }
        this.getModel().setValue("receipt", (Object)malReceipt.getReceiptId());
        this.getModel().setValue("addressid", (Object)malReceipt.getAdmindivisionId());
        this.getModel().setValue("receipttype", (Object)malReceipt.getType());
        ((Label)this.getControl("receiptname")).setText(malReceipt.getReceiptName());
        ((Label)this.getControl("receiptaddress")).setText(malReceipt.toString());
        ((Label)this.getControl("receiptphone")).setText(malReceipt.getPhone());
        ((Label)this.getControl("receiptemail")).setText(malReceipt.getEmail());
        this.getModel().setValue("addrdetail", (Object)malReceipt.toString());
    }

    private void initDefualOrgUnit(MalPlaceOrderEntity firstMalPlaceOrderEntity) {
        DynamicObject expenseOrgDyn;
        DynamicObject invoiceOrgDyn;
        DynamicObject settleOrgDyn;
        DynamicObject rcvOrgDyn;
        DynamicObject orgDyn;
        DynamicObject costOrgDyn;
        this.getModel().beginInit();
        MalOrgRelation malOrgRelation = firstMalPlaceOrderEntity.getMalOrgRelation();
        DynamicObject depOrgDyn = (DynamicObject)this.getModel().getValue("deporg");
        if (depOrgDyn == null) {
            this.getModel().setValue("deporg", (Object)malOrgRelation.getDepOrgId());
        }
        if ((costOrgDyn = (DynamicObject)this.getModel().getValue("costorg")) == null) {
            this.getModel().setValue("costorg", (Object)malOrgRelation.getCostOrgId());
        }
        if ((orgDyn = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getModel().setValue("org", (Object)malOrgRelation.getPurOrgId());
        }
        if ((rcvOrgDyn = (DynamicObject)this.getModel().getValue("rcvorg")) == null) {
            this.getModel().setValue("rcvorg", (Object)malOrgRelation.getRcvOrgId());
        }
        if ((settleOrgDyn = (DynamicObject)this.getModel().getValue("settleorg")) == null) {
            this.getModel().setValue("settleorg", (Object)malOrgRelation.getSettleOrgId());
        }
        if ((invoiceOrgDyn = (DynamicObject)this.getModel().getValue("invoiceorg")) == null) {
            this.getModel().setValue("invoiceorg", (Object)malOrgRelation.getInvoiceOrgId());
        }
        if ((expenseOrgDyn = (DynamicObject)this.getModel().getValue("expenseorg")) == null) {
            this.getModel().setValue("expenseorg", (Object)malOrgRelation.getExpenseOrgId());
        }
        this.getModel().endInit();
    }

    private void initDeliDate(MalPlaceOrderEntity firstMalPlaceOrderEntity) {
        if (this.getModel().getValue("delidate") != null) {
            this.getModel().setValue("delidate", (Object)firstMalPlaceOrderEntity.getDeliDate());
        }
    }

    private void initReqPerson() {
        DynamicObject person = (DynamicObject)this.getModel().getValue("reqperson");
        if (person == null) {
            this.getModel().setValue("reqperson", (Object)RequestContext.get().getCurrUserId());
        }
    }

    private void initDefualtBizflow() {
        if (StringUtils.equals((CharSequence)BIZFLOW_PARAM, (CharSequence)BIZFLOW_PARAM)) {
            this.getModel().setValue("bizflow", (Object)BIZFLOW_PARAM);
        }
    }

    protected void initBizType(MalPlaceOrderEntity firstMalPlaceOrderEntity) {
        Object businessTypeDyn = this.getModel().getValue("businesstype");
        if (businessTypeDyn == null) {
            this.getModel().setValue("businesstype", (Object)firstMalPlaceOrderEntity.getBusinessTypeId());
        }
        boolean isGoodsBizType = MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)((DynamicObject)this.getModel().getValue("businesstype")));
        this.getPageCache().put(ISGOODSBIZTYPE, String.valueOf(isGoodsBizType));
        this.setGoodsBiztypeMustInput(isGoodsBizType);
    }

    protected void setGoodsBiztypeMustInput(boolean isGoodsBizType) {
        BasedataEdit rcvEdit = (BasedataEdit)this.getView().getControl("rcvorg");
        rcvEdit.setMustInput(!isGoodsBizType);
        int supplierSize = this.getSupplierGroupSize();
        for (int i = 1; i <= supplierSize; ++i) {
            this.getView().setVisible(Boolean.valueOf(!isGoodsBizType), new String[]{"materialflaglabelap" + i});
        }
    }

    private int getSupplierGroupSize() {
        MalPlaceOrderVo malPlaceOrderVo = this.getMalPlaceOrderVo();
        if (malPlaceOrderVo != null) {
            return malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().size();
        }
        return 0;
    }

    private void setOrg(String orgKey, Long orgId) {
        orgId = orgId != 0L ? orgId : null;
        this.getModel().setValue(orgKey, (Object)orgId);
    }

    private void clearOrg() {
        this.getModel().beginInit();
        this.getModel().setValue("deporg", null);
        this.getModel().setValue("org", null);
        this.getModel().setValue("rcvorg", null);
        this.getModel().setValue("settleorg", null);
        this.getModel().setValue("invoiceorg", null);
        this.getModel().setValue("costorg", null);
        this.getModel().endInit();
    }

    private void addReceipt() {
        BaseShowParameter param = new BaseShowParameter();
        param.setFormId("mal_address");
        param.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u6536\u8d27\u4eba\u4fe1\u606f", (String)"MalPlaceOrderPlugin_38", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        HashMap<String, Boolean> customFilter = new HashMap<String, Boolean>();
        customFilter.put("isCallByMakeOrder", Boolean.TRUE);
        param.setCustomParams(customFilter);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_address"));
        this.openPage((FormShowParameter)param);
    }

    private void openPage(FormShowParameter param) {
        this.getView().showForm(param);
    }

    private void modifyReceipt() {
        Long depOrg = (Long)this.getModel().getValue("deporg_id");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("mal_receiptlist");
        param.setCaption(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f\u5217\u8868", (String)"MalPlaceOrderPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (depOrg != null && depOrg != 0L) {
            param.setCustomParam("query_org", (Object)String.valueOf(depOrg));
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_receiptlist"));
        this.openPage(param);
    }

    private void hiddenInvalidSupplier(Map<String, MalPlaceOrderEntity> malPlaceOrderEntityMap) {
        int supplierSize = malPlaceOrderEntityMap.size();
        for (int i = 1; i <= 10; ++i) {
            if (i <= supplierSize) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{"goodspanelap" + i});
        }
    }

    private Map<String, Long> getDefaultPurType(DynamicObject bizType) {
        HashMap<String, Long> resMap = new HashMap<String, Long>(4);
        if (Objects.isNull(bizType)) {
            return resMap;
        }
        Long lineType = BizTypeHelper.getDefaultLineType((Long)bizType.getLong("id"));
        if (Objects.isNull(lineType)) {
            return resMap;
        }
        resMap.put("linetype", lineType);
        DynamicObjectCollection purTypeCol = QueryServiceHelper.query((String)"pbd_mallextdata", (String)"id", (QFilter[])new QFilter[]{new QFilter("linetype", "=", (Object)lineType)}, (String)"number desc");
        if (!Objects.isNull(purTypeCol) && purTypeCol.size() > 0) {
            resMap.put("purtype", ((DynamicObject)purTypeCol.get(0)).getLong("id"));
        }
        return resMap;
    }
}

