/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MalPreinDataSelectPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String ENTITYID = "entityid";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        String entityid = this.getEntityId((FormShowParameter)e.getSource());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        EntryAp entryAp = extendEntryentity.createDynamicEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        extendEntryentity.registDynamicProps(e);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        e.setDataEntity((Object)extendEntryentity.extendInCreateNewData(dataEntity));
    }

    public void beforeBindData(EventObject e) {
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        EntryAp dynamicEntryAp = new ExtendEntryentity(entityid, KEY_ENTRYENTITY).createDynamicEntryAp();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        boolean i = true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        if ("btnok".equals(bt.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            int[] indexs = entryGrid.getSelectRows();
            StringBuilder pksb = new StringBuilder();
            for (int i = 0; i < indexs.length; ++i) {
                DynamicObject dyn = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, indexs[i]);
                pksb.append(dyn.getString("id")).append(',');
            }
            pksb.delete(pksb.length() - 1, pksb.length());
            this.getView().returnDataToParent((Object)pksb.toString());
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    protected String getEntityId(FormShowParameter fsp) {
        return (String)fsp.getCustomParam(ENTITYID);
    }

    private static class ExtendEntryentity {
        String entityId;
        MainEntityType mainEntityType;
        List<IDataEntityProperty> dataEntityPropertyCol;
        String entryentity;
        Map<String, IDataEntityProperty> keyPropMap;

        ExtendEntryentity(String entityId, String entryentity) {
            if (entityId == null) {
                return;
            }
            this.entityId = entityId;
            this.entryentity = entryentity;
            this.mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            this.dataEntityPropertyCol = new ArrayList<IDataEntityProperty>();
            this.mainEntityType.getProperties().forEach(iDataEntityProperty -> {
                boolean notAdd;
                boolean bl = notAdd = "id".equals(iDataEntityProperty.getName()) || iDataEntityProperty instanceof LongProp || iDataEntityProperty instanceof CurrencyProp || iDataEntityProperty instanceof MuliLangTextProp || iDataEntityProperty instanceof ModifierProp || !(iDataEntityProperty instanceof DynamicSimpleProperty) || iDataEntityProperty instanceof DateTimeProp || StringUtils.isNotEmpty((CharSequence)iDataEntityProperty.getTableGroup()) || StringUtils.isEmpty((CharSequence)iDataEntityProperty.getAlias());
                if (!notAdd) {
                    this.dataEntityPropertyCol.add((IDataEntityProperty)iDataEntityProperty);
                }
            });
            TextProp idTextProp = new TextProp();
            IDataEntityProperty idProp = (IDataEntityProperty)this.mainEntityType.getProperties().get((Object)"id");
            idTextProp.setAlias(idProp.getAlias());
            idTextProp.setDisplayName(idProp.getDisplayName());
            idTextProp.setName(idProp.getName());
            this.dataEntityPropertyCol.add((IDataEntityProperty)idTextProp);
            this.keyPropMap = new HashMap<String, IDataEntityProperty>();
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                if (!iDataEntityProperty.isDbIgnore()) {
                    this.keyPropMap.put(iDataEntityProperty.getName(), (IDataEntityProperty)iDataEntityProperty);
                }
            });
        }

        EntryAp createDynamicEntryAp() {
            EntryAp entryAp = new EntryAp();
            entryAp.setKey("entryap");
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(iDataEntityProperty.getName());
                fieldAp.setKey(iDataEntityProperty.getName());
                fieldAp.setName(iDataEntityProperty.getDisplayName());
                TextField field = new TextField();
                if ("id".equals(iDataEntityProperty.getName())) {
                    fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"MalPreinDataSelectPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])));
                }
                field.setId(iDataEntityProperty.getName());
                field.setKey(iDataEntityProperty.getName());
                fieldAp.setField((Field)field);
                entryAp.getItems().add(fieldAp);
            });
            return entryAp;
        }

        void registDynamicProps(GetEntityTypeEventArgs e) {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
            }
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(this.entryentity);
            this.dataEntityPropertyCol.forEach(prop -> {
                try {
                    entryType.registerSimpleProperty((DynamicSimpleProperty)prop.clone());
                }
                catch (CloneNotSupportedException e1) {
                    throw new KDBizException(e1.getMessage());
                }
            });
            e.setNewEntityType(newMainType);
        }

        DynamicObject extendInCreateNewData(DynamicObject dataEntity) {
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(this.entryentity);
            Set<String> keySet = this.keyPropMap.keySet();
            String orderBy = this.getOrderBy(BusinessDataServiceHelper.newDynamicObject((String)this.entityId).getDynamicObjectType());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityId, (String)this.getSelectField(), null, (String)orderBy, (int)5000);){
                ds.forEach(row -> {
                    DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                    keySet.forEach(key -> {
                        if (row.get(key) != null) {
                            newRow.set(key, (Object)String.valueOf(row.get(key)));
                        }
                    });
                    rows.add((Object)newRow);
                });
            }
            return dataEntity;
        }

        private String getOrderBy(DynamicObjectType dynamicObjectType) {
            DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObjectType.getProperties();
            for (IDataEntityProperty property : dataEntityPropertyCollection) {
                if (!(property instanceof CreateDateProp)) continue;
                return property.getName() + " desc";
            }
            return "";
        }

        String getSelectField() {
            StringBuilder sb = new StringBuilder();
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                if (!iDataEntityProperty.isDbIgnore()) {
                    sb.append(iDataEntityProperty.getName()).append(',');
                }
            });
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
    }
}

