/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.model.trend.MalTrend;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import kd.scm.mal.domain.service.MalPriceTrendService;
import kd.scm.malcore.domain.GoodsSameRule;

public class MalPriceMonitorDetailPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        ArrayList<String> tabvisibleTrue = new ArrayList<String>(16);
        Tab tab = (Tab)this.getControl("tabap");
        List items = tab.getItems();
        for (Control item : items) {
            tabvisibleTrue.add(item.getKey());
        }
        MalPriceMonitorService service = new MalPriceMonitorService();
        MalGoods malGoods = this.getMalGoods();
        if (!service.isSamegoods(malGoods)) {
            tabvisibleTrue.remove("samegoods");
        }
        if (null != customParams.get("invisibletabs")) {
            List tabvisible = (List)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("invisibletabs")), List.class);
            tabvisibleTrue.removeAll(tabvisible);
        }
        if (tabvisibleTrue.size() > 0) {
            tab.activeTab((String)tabvisibleTrue.get(0));
        }
        this.getPageCache().put("tabvisibleTrue", SerializationUtils.toJsonString(tabvisibleTrue));
        this.initGoodsInfoData(malGoods);
        this.initPriceInfoData(malGoods, (String)tabvisibleTrue.get(0));
    }

    private void initPriceInfoData(MalGoods malGoods, String tab) {
        switch (tab) {
            case "comparedetail": {
                this.initComparePriceData(malGoods);
                break;
            }
            case "samegoods": {
                this.initSameGoods();
                break;
            }
            case "historyprice": 
            case "orgprice": {
                this.initPriceTrend(malGoods, tab);
                break;
            }
        }
    }

    private void initSameGoods() {
        List<Map<String, Object>> resultData = this.getMinSameGoodsData(null);
        if (null != resultData && resultData.size() > 1) {
            this.initSameGoodsData(resultData);
        }
    }

    private void initGoodsInfoData(MalGoods malGoods) {
        if (null != malGoods) {
            this.getModel().setValue("curr", (Object)malGoods.getCurrency());
            this.getPageCache().put("price", String.valueOf(malGoods.getTaxPrice()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (null != customParams.get("invisibletabs")) {
            List tabvisible = (List)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("invisibletabs")), List.class);
            this.getView().setVisible(Boolean.FALSE, tabvisible.toArray(new String[0]));
        }
        String tabvisibleTrueStr = this.getPageCache().get("tabvisibleTrue");
        List tabvisibleTrue = (List)SerializationUtils.fromJsonString((String)tabvisibleTrueStr, List.class);
        ArrayList<String> tabInvisible = new ArrayList<String>(16);
        Tab tab = (Tab)this.getControl("tabap");
        List items = tab.getItems();
        for (Control item : items) {
            if (tabvisibleTrue.contains(item.getKey())) continue;
            tabInvisible.add(item.getKey());
        }
        if (tabInvisible.size() > 0) {
            this.getView().setVisible(Boolean.FALSE, tabInvisible.toArray(new String[0]));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"lowpricefelx", "priceflex"});
    }

    private MalGoods getMalGoods() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object source = customParams.get("source");
        Object org = customParams.get("org");
        Object compareid = customParams.get("compareid");
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
        MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)Long.parseLong(String.valueOf(goodsId)), (String)String.valueOf(source), (BigDecimal)BigDecimal.ONE, null, (Long)Long.parseLong(String.valueOf(org)));
        if (null != compareid) {
            param.setCompareId(Long.valueOf(Long.parseLong(String.valueOf(compareid))));
        } else {
            param.setCompareId(Long.valueOf(0L));
        }
        malMatGoodsInitParams.add(param);
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
        if (null != malGoodsMap.get(Long.parseLong(String.valueOf(goodsId)))) {
            return (MalGoods)malGoodsMap.get(Long.parseLong(String.valueOf(goodsId)));
        }
        return null;
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        this.getView().setVisible(Boolean.TRUE, new String[]{"content"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"empathflex"});
        switch (tabKey) {
            case "comparedetail": {
                this.showCompareDetail();
                break;
            }
            case "samegoods": {
                this.showSameGoods();
                break;
            }
            case "historyprice": 
            case "orgprice": {
                this.showPricetrend(tabKey);
                break;
            }
        }
    }

    private void showSameGoods() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"MalPriceMonitorDetailPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0])));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object source = customParams.get("source");
        Object purchase_org = customParams.get("purchase_org");
        GoodsSameRule goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
        if (null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
            this.getView().hideLoading();
        } else {
            List<Map<String, Object>> resultData = this.getMinSameGoodsData(goodsSameRule);
            if (null != resultData && resultData.size() > 1) {
                List<Map<String, Object>> maxResultData = this.getMaxSameGoodsData(goodsSameRule);
                BigDecimal lowPrice = BigDecimal.ZERO;
                if (null != resultData.get(0).get("price")) {
                    lowPrice = new BigDecimal(String.valueOf(resultData.get(0).get("price")));
                }
                BigDecimal hightPrice = BigDecimal.ZERO;
                if (null != maxResultData.get(0).get("price")) {
                    hightPrice = new BigDecimal(String.valueOf(maxResultData.get(0).get("price")));
                }
                this.initSameGoodsData(resultData);
                FormShowParameter showParameter = new FormShowParameter();
                if (null != purchase_org) {
                    showParameter.setFormId("mal_samepickgoods");
                } else {
                    showParameter.setFormId("mal_samegoods");
                }
                showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                HashMap<String, String> searchParamMap = new HashMap<String, String>();
                MalSearchParam malSearchParam = new MalSearchParam();
                malSearchParam.setSort(goodsSameRule.getSort());
                malSearchParam.setCustomEsFilterFields(goodsSameRule.getEsFilterFields());
                malSearchParam.setPageSize(3);
                searchParamMap.put("param_search", SerializationUtils.toJsonString((Object)malSearchParam));
                searchParamMap.put("firstgoodsid", (String)goodsId);
                searchParamMap.put("sourceForm", (String)customParams.get("sourceForm"));
                searchParamMap.put("purchase_org", (String)purchase_org);
                if (lowPrice.compareTo(hightPrice) != 0) {
                    searchParamMap.put("maxprice", String.valueOf(hightPrice));
                    searchParamMap.put("minprice", String.valueOf(lowPrice));
                }
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("content");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "samegoods"));
                showParameter.setCustomParams(searchParamMap);
                this.getView().showForm(showParameter);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
                this.getView().hideLoading();
            }
        }
    }

    private void initSameGoodsData(List<Map<String, Object>> resultData) {
        if (null == resultData || resultData.size() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"descflex", "alldescflex"});
        BigDecimal curPrice = BigDecimal.ZERO;
        if (null != this.getPageCache().get("price")) {
            curPrice = new BigDecimal(String.valueOf(this.getPageCache().get("price")));
        }
        BigDecimal lowPrice = BigDecimal.ZERO;
        if (null != resultData.get(0).get("price")) {
            lowPrice = new BigDecimal(String.valueOf(resultData.get(0).get("price")));
        }
        if (curPrice.compareTo(lowPrice) == 0) {
            this.getModel().setValue("lowedesc", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u4ef7\u683c\u4e3a\u540c\u6b3e\u6700\u4f4e\uff0c\u5efa\u8bae\u8d2d\u4e70", (String)"MalPriceMonitorDetailPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setFlexVisible(true, false, false);
        } else {
            this.getModel().setValue("lower", (Object)ResManager.loadKDString((String)"\u5b58\u5728\u66f4\u4f4e\u4ef7\u683c\u7684\u540c\u6b3e\u5546\u54c1", (String)"MalPriceMonitorDetailPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("lowprice", (Object)lowPrice);
            this.getModel().setValue("reduceprice", (Object)curPrice.subtract(lowPrice));
            this.setFlexVisible(false, true, false);
        }
    }

    private List<Map<String, Object>> getMinSameGoodsData(GoodsSameRule goodsSameRule) {
        if (null == goodsSameRule) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Object goodsId = customParams.get("goodsId");
            Object source = customParams.get("source");
            goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
            if (null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
            }
            return null;
        }
        MalSearchParam res = new MalSearchParam();
        res.setPageNum(0);
        res.setPageSize(10);
        res.setSort("price_true");
        res.getCustomEsFilterFields().addAll(goodsSameRule.getEsFilterFields());
        MalSearchService malSearchService = (MalSearchService)MalBusinessFactory.serviceOf(MalSearchService.class);
        MalSearchResult search = malSearchService.search(res, null);
        return search.getResultData();
    }

    private List<Map<String, Object>> getMaxSameGoodsData(GoodsSameRule goodsSameRule) {
        if (null == goodsSameRule) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Object goodsId = customParams.get("goodsId");
            Object source = customParams.get("source");
            goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(String.valueOf(goodsId)), String.valueOf(source)});
            if (null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
            }
            return null;
        }
        MalSearchParam res = new MalSearchParam();
        res.setPageNum(0);
        res.setPageSize(10);
        res.setSort("price_false");
        res.getCustomEsFilterFields().addAll(goodsSameRule.getEsFilterFields());
        MalSearchService malSearchService = (MalSearchService)MalBusinessFactory.serviceOf(MalSearchService.class);
        MalSearchResult search = malSearchService.search(res, null);
        return search.getResultData();
    }

    private void showPricetrend(String tabKey) {
        MalPriceTrendService malQuotePriceTrend;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object goodsId = customParams.get("goodsId");
        if (null == goodsId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            return;
        }
        MalGoods malGoods = this.getMalGoods();
        if (null == malGoods) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            return;
        }
        if ("historyprice".equals(tabKey)) {
            malQuotePriceTrend = new MalPriceTrendService("malQuotePriceTrend");
            MalTrend quoTrend = malQuotePriceTrend.createMalTrend(malGoods);
            if (null == quoTrend) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                return;
            }
        } else {
            malQuotePriceTrend = new MalPriceTrendService("malDealPriceTrend");
            MalTrend quoTrend = malQuotePriceTrend.createMalTrend(malGoods);
            if (null == quoTrend) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
                return;
            }
        }
        this.initPriceTrend(malGoods, tabKey);
        this.getView().setVisible(Boolean.TRUE, new String[]{"descflex", "alldescflex"});
        FormShowParameter fsp = new FormShowParameter();
        fsp.setShowClose(Boolean.FALSE.booleanValue());
        fsp.setShowTitle(Boolean.FALSE.booleanValue());
        fsp.setFormId("mal_price_trend");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setCustomParam("malGood", (Object)Long.valueOf(String.valueOf(goodsId)));
        fsp.setCustomParam("tabKey", (Object)tabKey);
        fsp.setCustomParam("price", (Object)String.valueOf(malGoods.getTaxPrice()));
        fsp.getOpenStyle().setTargetKey("content");
        this.getView().showForm(fsp);
    }

    private void initPriceTrend(MalGoods malGoods, String tabKey) {
        MalPriceTrendService malQuotePriceTrend = null;
        if ("historyprice".equals(tabKey)) {
            malQuotePriceTrend = new MalPriceTrendService("malQuotePriceTrend");
            this.getModel().setValue("lowquopricedesc", (Object)ResManager.loadKDString((String)"\u5386\u53f2\u6700\u4f4e\u62a5\u4ef7", (String)"MalPriceMonitorDetailPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("firstpricedesc", (Object)ResManager.loadKDString((String)"\u9996\u6b21\u4e0a\u67b6\u4ef7\u683c", (String)"MalPriceMonitorDetailPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            malQuotePriceTrend = new MalPriceTrendService("malDealPriceTrend");
            this.getModel().setValue("lowquopricedesc", (Object)ResManager.loadKDString((String)"\u5386\u53f2\u6700\u4f4e\u6210\u4ea4\u4ef7", (String)"MalPriceMonitorDetailPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("firstpricedesc", (Object)ResManager.loadKDString((String)"\u9996\u6b21\u6210\u4ea4\u4ef7\u683c", (String)"MalPriceMonitorDetailPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        MalTrend quoTrend = malQuotePriceTrend.createMalTrend(malGoods);
        if (null == quoTrend) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"descflex", "alldescflex"});
        this.setFlexVisible(false, false, true);
        BigDecimal hundred = new BigDecimal("100");
        this.setFristPrice(malGoods, tabKey);
        BigDecimal minprice = quoTrend.getShowPoint().getPointY();
        this.getModel().setValue("lowquoprice", (Object)minprice);
        IDataModel model = this.getModel();
        BigDecimal price = malGoods.getTaxPrice();
        if (null != minprice && minprice.compareTo(BigDecimal.ZERO) > 0 && price.compareTo(minprice) != 0) {
            BigDecimal subtract = price.subtract(minprice);
            HashMap<String, String> map = new HashMap<String, String>();
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                map.put("fc", "#FF5F1F");
                this.getModel().setValue("quoratestr", (Object)ResManager.loadKDString((String)"\u4e0a\u6da8", (String)"MalPriceMonitorDetailPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            } else {
                map.put("fc", "#77c404");
                this.getModel().setValue("quoratestr", (Object)ResManager.loadKDString((String)"\u4e0b\u8dcc", (String)"MalPriceMonitorDetailPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateControlMetadata("quorate", map);
            BigDecimal protocolpricelimit = subtract.divide(minprice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
            model.setValue("quorate", (Object)(protocolpricelimit + "%"));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#000000");
            this.getView().updateControlMetadata("quorate", map);
            model.setValue("quorate", (Object)"-");
            this.getView().setVisible(Boolean.FALSE, new String[]{"quorate"});
            this.getModel().setValue("quoratestr", (Object)ResManager.loadKDString((String)"\u4e0e\u5f53\u524d\u4ef7\u683c\u6301\u5e73", (String)"MalPriceMonitorDetailPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void setFristPrice(MalGoods malGoods, String tabKey) {
        List list;
        BigDecimal taxPrice = malGoods.getTaxPrice();
        BigDecimal hundred = new BigDecimal("100");
        String type = "";
        type = "historyprice".equals(tabKey) ? "malQuotePriceTrend" : "malDealPriceTrend";
        IGetMalTrendPriceService iGetMalTrendPriceService = (IGetMalTrendPriceService)DomainServiceFactory.serviceOf(IGetMalTrendPriceService.class, (String)type);
        Map malHistoryPrice = iGetMalTrendPriceService.getMalHistoryPrice(malGoods, Integer.valueOf(0));
        BigDecimal firstPrice = BigDecimal.ZERO;
        if (malHistoryPrice.size() > 0 && (list = (List)malHistoryPrice.values().toArray()[0]).size() > 0) {
            firstPrice = (BigDecimal)list.get(0);
        }
        this.getModel().setValue("firstprice", (Object)firstPrice);
        if (taxPrice.compareTo(firstPrice) != 0) {
            BigDecimal subtract = taxPrice.subtract(firstPrice);
            HashMap<String, String> map = new HashMap<String, String>();
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                map.put("fc", "#FF5F1F");
                this.getModel().setValue("firstratestr", (Object)ResManager.loadKDString((String)"\u4e0a\u6da8", (String)"MalPriceMonitorDetailPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            } else {
                map.put("fc", "#77c404");
                this.getModel().setValue("firstratestr", (Object)ResManager.loadKDString((String)"\u4e0b\u8dcc", (String)"MalPriceMonitorDetailPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateControlMetadata("firstrate", map);
            BigDecimal protocolpricelimit = subtract.divide(firstPrice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
            this.getModel().setValue("firstrate", (Object)(protocolpricelimit + "%"));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#000000");
            this.getView().updateControlMetadata("quorate", map);
            this.getModel().setValue("firstrate", (Object)"-");
            this.getModel().setValue("firstratestr", (Object)ResManager.loadKDString((String)"\u4e0e\u5f53\u524d\u4ef7\u683c\u6301\u5e73", (String)"MalPriceMonitorDetailPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"firstrate"});
        }
    }

    private void setFlexVisible(boolean lowpricefelx, boolean priceflex, boolean pricetrendflex) {
        this.getView().setVisible(Boolean.valueOf(lowpricefelx), new String[]{"lowpricefelx"});
        this.getView().setVisible(Boolean.valueOf(priceflex), new String[]{"priceflex"});
        this.getView().setVisible(Boolean.valueOf(pricetrendflex), new String[]{"pricetrendflex"});
    }

    private void showCompareDetail() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_compareprice_detail");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("content");
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        MalGoods malGoods = this.getMalGoods();
        if (null != malGoods && null != malGoods.getComparePrices() && malGoods.getComparePrices().size() > 0) {
            this.initComparePriceData(malGoods);
            detailParamMap.put("titlevisible", "1");
            detailParamMap.put("goodsId", malGoods.getProductId());
            detailParamMap.put("comparePrices", SerializationUtils.toJsonString((Object)malGoods.getComparePrices()));
            showParameter.setCustomParams(detailParamMap);
            this.getView().showForm(showParameter);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"empathflex"});
        }
    }

    private void initComparePriceData(MalGoods malGoods) {
        if (null == malGoods || null == malGoods.getComparePrices() || malGoods.getComparePrices().size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"descflex", "alldescflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"descflex", "alldescflex"});
        BigDecimal lowPrice = malGoods.getTaxPrice();
        for (ComparePriceInfo info : malGoods.getComparePrices()) {
            if (lowPrice.compareTo(info.getPrice()) <= 0) continue;
            lowPrice = info.getPrice();
        }
        if (lowPrice.compareTo(malGoods.getTaxPrice()) == 0) {
            this.getModel().setValue("lowedesc", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u4ef7\u683c\u4e3a\u6bd4\u4ef7\u8bb0\u5f55\u6700\u4f4e,\u5efa\u8bae\u8d2d\u4e70", (String)"MalPriceMonitorDetailPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setFlexVisible(true, false, false);
        } else {
            this.getModel().setValue("lower", (Object)ResManager.loadKDString((String)"\u5b58\u5728\u66f4\u4f4e\u4ef7\u683c\u7684\u6bd4\u4ef7\u5546\u54c1", (String)"MalPriceMonitorDetailPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("lowprice", (Object)lowPrice);
            this.getModel().setValue("reduceprice", (Object)malGoods.getTaxPrice().subtract(lowPrice));
            this.setFlexVisible(false, true, false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("samegoods".equals(actionId)) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }
}

