/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.trend.MalPoint;
import kd.scm.mal.domain.model.trend.MalTrend;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;
import kd.scm.mal.domain.service.MalPriceTrendService;

public class MalPriceTrendPlugin
extends AbstractFormPlugin {
    private static final String QUOTE_TIME_FILTER_CONTAINER = "quotetimefiltercontainer";
    private static final String DEAL_TIME_FILTER_CONTAINER = "dealtimefiltercontainer";
    private static final String QUOTE_POINT_LINE_CHART_AP = "quotepointlinechartap";
    private static final String DEAL_POINT_LINE_CHART_AP = "dealpointlinechartap";
    private static final String QUOTE_MAL_TREND = "quoteMalTrend";
    private static final String DEAL_MAL_TREND = "dealMalTrend";
    private static final String CLICK_BUTTON = "clickButton";
    private static final String QUOTE_MIN_PRICE = "quoteminprice";
    private static final String QUOTE_MIN_PRICE_DATE = "quoteminpricedate";
    private static final String DEAL_MIN_PRICE = "dealminprice";
    private static final String DEAL_MIN_PRICE_DATE = "dealminpricedate";
    private static final String MAL_QUOTE_PRICE_TREND = "malQuotePriceTrend";
    private static final String MAL_DEAL_PRICE_TREND = "malDealPriceTrend";
    private static final String CURRENCY = "currency";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object malGood = fsp.getCustomParams().get("malGood");
        Object org = fsp.getCustomParams().get("orgId");
        long orgId = 0L;
        orgId = org != null && Long.parseLong(String.valueOf(org)) != 0L ? Long.parseLong(String.valueOf(org)) : RequestContext.get().getOrgId();
        boolean quoteHasData = false;
        boolean dealHasData = false;
        if (malGood != null) {
            MalGoods malGoods = MalGoods.of((Long)((Long)malGood));
            malGoods.setOrg(Long.valueOf(orgId));
            this.getModel().setValue(CURRENCY, (Object)malGoods.getCurrency());
            quoteHasData = this.initMalTrend(MAL_QUOTE_PRICE_TREND, QUOTE_TIME_FILTER_CONTAINER, QUOTE_POINT_LINE_CHART_AP, QUOTE_MAL_TREND, malGoods);
            dealHasData = this.initMalTrend(MAL_DEAL_PRICE_TREND, DEAL_TIME_FILTER_CONTAINER, DEAL_POINT_LINE_CHART_AP, DEAL_MAL_TREND, malGoods);
        } else {
            this.setIfShowMinPointView(false, QUOTE_TIME_FILTER_CONTAINER);
            this.setIfShowMinPointView(false, DEAL_TIME_FILTER_CONTAINER);
        }
        if (!quoteHasData && !dealHasData) {
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("hasData", "false");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (!quoteHasData && dealHasData) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("showTabPage", "tabpageap1");
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        Object tabKey;
        super.afterBindData(e);
        IPageCache pageCache = this.getPageCache();
        String showTabPage = pageCache.get("showTabPage");
        if ("tabpageap1".equals(showTabPage)) {
            Tab dealTab = (Tab)this.getControl("tabap");
            dealTab.activeTab("tabpageap1");
        }
        if (null != (tabKey = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("tabKey"))) {
            Tab dealTab;
            if (tabKey.equals("historyprice")) {
                dealTab = (Tab)this.getControl("tabap");
                dealTab.activeTab("tabpageap");
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            }
            if (tabKey.equals("orgprice")) {
                dealTab = (Tab)this.getControl("tabap");
                dealTab.activeTab("tabpageap1");
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            }
            HashMap<String, Boolean> propertiesMap = new HashMap<String, Boolean>();
            propertiesMap.put("hideNav", Boolean.TRUE);
            this.getView().updateControlMetadata("tabap", propertiesMap);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "buttonap"});
        }
    }

    private boolean initMalTrend(String instance, String container, String lineChartAp, String malTrendName, MalGoods malGoods) {
        MalPriceTrendService malPriceTrendService = new MalPriceTrendService(instance);
        MalTrend malTrend = malPriceTrendService.createMalTrend(malGoods);
        if (malTrend != null) {
            this.allotTimeFilterContainer(malTrend.getFilterTabMap(), container);
            Integer timeFilter = Integer.valueOf(this.getPageCache().get(container + CLICK_BUTTON).split("_")[1]);
            this.allotPointLineChart(malTrend, (PointLineChart)this.getControl(lineChartAp), timeFilter, null, malTrendName);
            this.setShowMinPointView(container);
        } else {
            this.setIfShowMinPointView(false, container);
        }
        return malTrend != null;
    }

    private void allotTimeFilterContainer(Map<String, Integer> filterTimeMap, String container) {
        Container timeFilterContainer = (Container)this.getControl(container);
        if (timeFilterContainer == null) {
            return;
        }
        ArrayList<Map> sourceLabelList = new ArrayList<Map>(filterTimeMap.size());
        LabelAp labelAp = new LabelAp();
        for (Map.Entry<String, Integer> filterTime : filterTimeMap.entrySet()) {
            String filter = filterTime.getKey();
            String clickButton = container + "_" + filterTime.getValue();
            labelAp.setClickable(true);
            labelAp.setKey(clickButton);
            labelAp.setId(String.valueOf(filterTime.getValue()));
            labelAp.setName(new LocaleString(filter));
            labelAp.setFontSize(13);
            labelAp.setStyle(MalPriceTrendPlugin.getFilterStyle());
            labelAp.setRadius("2px");
            sourceLabelList.add(labelAp.createControl());
        }
        timeFilterContainer.addControls(sourceLabelList);
        String clickButton = container + "_" + filterTimeMap.values().toArray(new Integer[0])[0];
        this.cliCkStyleChange(clickButton, true);
        this.getPageCache().put(container + CLICK_BUTTON, clickButton);
    }

    public void click(EventObject evt) {
        String container;
        Button btn = null;
        if (evt.getSource() instanceof Button) {
            btn = (Button)evt.getSource();
        }
        if (btn != null && (DEAL_TIME_FILTER_CONTAINER.equals(container = btn.getKey().split("_")[0]) || QUOTE_TIME_FILTER_CONTAINER.equals(container))) {
            String lastClickButton = this.getPageCache().get(container + CLICK_BUTTON);
            this.cliCkStyleChange(lastClickButton, false);
            this.cliCkStyleChange(btn.getKey(), true);
            this.getPageCache().put(container + CLICK_BUTTON, btn.getKey());
            this.updateLineSeries(btn.getKey());
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object tabKey = customParams.get("tabKey");
            if (null != tabKey) {
                BigDecimal minprice;
                Object quoteminpriceStr;
                if (tabKey.equals("historyprice") && null != (quoteminpriceStr = this.getModel().getValue(QUOTE_MIN_PRICE)) && null != this.getView().getParentView()) {
                    minprice = new BigDecimal(String.valueOf(quoteminpriceStr));
                    this.initPriceMonitorTrend(minprice);
                }
                if (tabKey.equals("orgprice") && null != (quoteminpriceStr = this.getModel().getValue(DEAL_MIN_PRICE)) && null != this.getView().getParentView()) {
                    minprice = new BigDecimal(String.valueOf(quoteminpriceStr));
                    this.initPriceMonitorTrend(minprice);
                }
            }
        }
    }

    private void initPriceMonitorTrend(BigDecimal minprice) {
        BigDecimal hundred = new BigDecimal("100");
        this.getView().getParentView().getModel().setValue("lowquoprice", (Object)minprice);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object priceStr = customParams.get("price");
        BigDecimal price = BigDecimal.ZERO;
        if (null != priceStr) {
            price = new BigDecimal(String.valueOf(priceStr));
        }
        if (null != minprice && minprice.compareTo(BigDecimal.ZERO) > 0 && price.compareTo(minprice) != 0) {
            BigDecimal subtract = price.subtract(minprice);
            HashMap<String, String> map = new HashMap<String, String>();
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                map.put("fc", "#FF5F1F");
            } else {
                map.put("fc", "#77c404");
            }
            this.getView().getParentView().updateControlMetadata("quorate", map);
            BigDecimal protocolpricelimit = subtract.divide(minprice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
            this.getView().getParentView().getModel().setValue("quorate", (Object)(protocolpricelimit + "%"));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#000000");
            this.getView().getParentView().updateControlMetadata("quorate", map);
            this.getView().getParentView().getModel().setValue("quorate", (Object)"-");
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void cliCkStyleChange(String key, boolean isClicking) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        list.add(key);
        if (isClicking) {
            dataMap.put("fc", "rgba(255,82,87,0.8)");
            dataMap.put("bc", "rgba(255,153,28,0.18)");
        } else {
            dataMap.put("fc", "#000000");
            dataMap.put("bc", "");
        }
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().split("_").length > 1 && (StringUtils.equals((CharSequence)QUOTE_TIME_FILTER_CONTAINER, (CharSequence)e.getKey().split("_")[0]) || StringUtils.equals((CharSequence)DEAL_TIME_FILTER_CONTAINER, (CharSequence)e.getKey().split("_")[0]))) {
            Label label = new Label();
            label.setKey(e.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    private static Style getFilterStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("15px");
        style.setMargin(margin);
        Padding padding = new Padding();
        padding.setBottom("3px");
        padding.setLeft("3px");
        padding.setRight("3px");
        padding.setTop("3px");
        style.setPadding(padding);
        return style;
    }

    private void allotPointLineChart(MalTrend malTrend, PointLineChart pointLineChart, Integer timeFilter, MalPriceTrendService malPriceTrendService, String malTrendName) {
        List pointList = malTrend.getPointList();
        ArrayList<String> dateList = new ArrayList<String>(pointList.size());
        Date filterDate = DateUtil.addDays((Date)TimeServiceHelper.now(), (int)(-timeFilter.intValue()));
        ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>(pointList.size());
        int i = 0;
        MalPoint newShowMalPoint = null;
        for (MalPoint malPoint : pointList) {
            IGetMalTrendPriceService iGetMalTrendPriceService;
            String pointX = malPoint.getPointX();
            Date date = DateUtil.string2date((String)pointX, (String)"yyyy-MM-dd");
            if (!date.after(filterDate)) continue;
            dateList.add(malPoint.getDateShowFormat());
            priceList.add(malPoint.getPointY());
            if (malPriceTrendService == null || (iGetMalTrendPriceService = malPriceTrendService.getIGetMalTrendPriceService()) == null) continue;
            newShowMalPoint = iGetMalTrendPriceService.setShowMalPoint(newShowMalPoint, new MalPoint(pointX, malPoint.getPointY()), i);
            ++i;
        }
        int splitNumber = 0;
        if (i > 2) {
            splitNumber = i - 2;
        } else if (malPriceTrendService == null) {
            splitNumber = pointList.size() - 2;
        }
        Axis categoryAxis = this.createCategoryAxis(pointLineChart, null, true);
        HashMap<String, Object> nametextStyle = new HashMap<String, Object>();
        nametextStyle.put("color", "#000000");
        nametextStyle.put("fontSize", 18);
        categoryAxis.setPropValue("nametextStyle", nametextStyle);
        categoryAxis.setPropValue("boundaryGap", (Object)new String[]{"10%", "10%"});
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        HashMap<String, String> textStyle = new HashMap<String, String>();
        textStyle.put("color", "#000000");
        textStyle.put("fontSize", "12");
        axisLabel.put("textStyle", textStyle);
        axisLabel.put("interval", splitNumber);
        axisLabel.put("rotate", "30");
        categoryAxis.setPropValue("axisLabel", axisLabel);
        HashMap<String, String> grid = new HashMap<String, String>();
        grid.put("left", "10%");
        grid.put("rigth", "10%");
        categoryAxis.setPropValue("grid", grid);
        Axis ValueAxis = this.createValueAxis(pointLineChart, null, false);
        if (newShowMalPoint == null && dateList.size() == 0) {
            malTrend.setShowPoint(new MalPoint("", BigDecimal.ZERO));
        } else if (newShowMalPoint != null) {
            malTrend.setShowPoint(newShowMalPoint);
        }
        this.getPageCache().put(malTrendName, JSONArray.toJSONString((Object)malTrend));
        categoryAxis.setCategorys(dateList);
        if (malTrendName.equals(QUOTE_MAL_TREND)) {
            this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u62a5\u4ef7", (String)"MalPriceTrendPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]), priceList, "#ff854d");
        } else if (malTrendName.equals(DEAL_MAL_TREND)) {
            this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u6210\u4ea4\u4ef7", (String)"MalPriceTrendPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), priceList, "#ff854d");
        }
        pointLineChart.setMargin(Position.top, "10px");
        HashMap<String, Object> legendTextStyle = new HashMap<String, Object>();
        legendTextStyle.put("fontSize", 18);
        legendTextStyle.put("color", "#000000");
        pointLineChart.setLegendPropValue("textStyle", legendTextStyle);
        pointLineChart.refresh();
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name, boolean isX) {
        Axis axis = isX ? pointLineChart.createXAxis(name, AxisType.category) : pointLineChart.createYAxis(name, AxisType.category);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axis.setPropValue("splitNumber", (Object)2);
        axisTick.put("show", Boolean.TRUE);
        axisTick.put("grid", (Boolean)Position.left);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = isx ? pointLineChart.createXAxis(name, AxisType.value) : pointLineChart.createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setColor("#000000");
        label.setShadowColor(color);
        expireSeries.setLabel(label);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private void updateLineSeries(String clickButton) {
        String[] clickArray = clickButton.split("_");
        String container = clickArray[0];
        Integer timeFilter = Integer.valueOf(clickArray[1]);
        Object iGetMalTrendPriceService = null;
        if (QUOTE_TIME_FILTER_CONTAINER.equals(container)) {
            this.allotPointLineChart((MalTrend)JSONArray.parseObject((String)this.getPageCache().get(QUOTE_MAL_TREND), MalTrend.class), (PointLineChart)this.getControl(QUOTE_POINT_LINE_CHART_AP), timeFilter, new MalPriceTrendService(MAL_QUOTE_PRICE_TREND), QUOTE_MAL_TREND);
        } else if (DEAL_TIME_FILTER_CONTAINER.equals(container)) {
            this.allotPointLineChart((MalTrend)JSONArray.parseObject((String)this.getPageCache().get(DEAL_MAL_TREND), MalTrend.class), (PointLineChart)this.getControl(DEAL_POINT_LINE_CHART_AP), timeFilter, new MalPriceTrendService(MAL_DEAL_PRICE_TREND), DEAL_MAL_TREND);
        }
        this.setShowMinPointView(container);
    }

    private void setShowMinPointView(String container) {
        if (QUOTE_TIME_FILTER_CONTAINER.equals(container)) {
            MalTrend malTrend = (MalTrend)JSONArray.parseObject((String)this.getPageCache().get(QUOTE_MAL_TREND), MalTrend.class);
            MalPoint malPoint = malTrend.getShowPoint();
            String pointX = malPoint.getPointX();
            this.getModel().setValue(QUOTE_MIN_PRICE_DATE, (Object)pointX);
            this.getModel().setValue(QUOTE_MIN_PRICE, (Object)malPoint.getPointY());
            if (!"".equals(pointX)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{QUOTE_MIN_PRICE, "labelap1", QUOTE_MIN_PRICE_DATE, "labelap11"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"quotenone"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{QUOTE_MIN_PRICE, "labelap1", QUOTE_MIN_PRICE_DATE, "labelap11"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"quotenone"});
            }
        } else if (DEAL_TIME_FILTER_CONTAINER.equals(container)) {
            MalTrend malTrend = (MalTrend)JSONArray.parseObject((String)this.getPageCache().get(DEAL_MAL_TREND), MalTrend.class);
            MalPoint malPoint = malTrend.getShowPoint();
            String pointX = malPoint.getPointX();
            if (!"".equals(pointX)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEAL_MIN_PRICE, "labelap12", DEAL_MIN_PRICE_DATE, "labelap111"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"dealnone"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{DEAL_MIN_PRICE, "labelap12", DEAL_MIN_PRICE_DATE, "labelap111"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"dealnone"});
            }
            this.getModel().setValue(DEAL_MIN_PRICE_DATE, (Object)pointX);
            this.getModel().setValue(DEAL_MIN_PRICE, (Object)malPoint.getPointY());
        }
    }

    private void setIfShowMinPointView(boolean visible, String container) {
        if (QUOTE_TIME_FILTER_CONTAINER.equals(container)) {
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexpanelap"});
        } else if (DEAL_TIME_FILTER_CONTAINER.equals(container)) {
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexpanelap2"});
        }
    }
}

