/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.shopcart.vo.MalAddCartParam;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.formplugin.MalPickGoodsPlugin;
import kd.scm.mal.formplugin.util.MalProductUtil;

public class MalPurchasePackageDetail
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final int PAGEROWS = 4;
    private static final String OP_TO_ORDER = "toorder";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"prepage", "nextpage"});
        CardEntry grid = (CardEntry)this.getView().getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Image) {
            Image button = (Image)evt.getSource();
            String clickKey = button.getKey();
            CardEntry billList = (CardEntry)this.getControl("entryentity");
            Integer currentPageIndex = billList.getEntryState().getCurrentPageIndex();
            if (clickKey.equals("prepage")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"next_flex"});
                if (currentPageIndex == 2) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"pre_flex"});
                }
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(currentPageIndex - 1));
                this.getView().updateView("entryentity");
            }
            if (clickKey.equals("nextpage")) {
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                int count = entrys.size();
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(currentPageIndex + 1));
                int taotalpage = count / 4;
                if (currentPageIndex >= taotalpage) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"next_flex"});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"pre_flex"});
                this.getView().updateView("entryentity");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.get("pacageid") == null) {
            return;
        }
        String pacageid = customParams.get("pacageid").toString();
        String addressid = customParams.get("addressid").toString();
        String orgid = customParams.get("orgid").toString();
        QFilter fiter = new QFilter("id", "=", (Object)Long.parseLong(pacageid));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pmm_packageselection", (String)"id,name,entryentity.id,entryentity.source,entryentity.isprimary,entryentity.goods.id,entryentity.qty,entryentity.goodssupplier", (QFilter[])new QFilter[]{fiter});
        ArrayList<MalMatGoodsInitParam> list = new ArrayList<MalMatGoodsInitParam>(col.size());
        HashMap<Long, DynamicObject> pakageMap = new HashMap<Long, DynamicObject>(col.size());
        for (DynamicObject info : col) {
            pakageMap.put(info.getLong("entryentity.goods.id"), info);
            MalMatGoodsInitParam param = new MalMatGoodsInitParam();
            param.setGoodsId(Long.valueOf(info.getLong("entryentity.goods.id")));
            if ("pmm_prodmanage".equals(info.getString("entryentity.source"))) {
                param.setPlatform("1");
            } else {
                String goodssupplier = info.getString("entryentity.goodssupplier");
                String value = EcPlatformEnum.getEnumValue((String)goodssupplier);
                param.setPlatform(value);
            }
            param.setAddressId(addressid);
            param.setOrgId(Long.valueOf(Long.parseLong(orgid)));
            param.setQty(info.getBigDecimal("entryentity.qty"));
            list.add(param);
        }
        Map malgoodsMap = MalGoods.batchInstance(list, (boolean)true, (boolean)false);
        this.loadGoodsData(malgoodsMap, pakageMap);
    }

    private void loadGoodsData(Map<Long, MalGoods> malgoodsMap, Map<Long, DynamicObject> pakageMap) {
        CardEntry billList = (CardEntry)this.getControl("entryentity");
        billList.setPageRow(4);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entrys.clear();
        int totoalqty = 0;
        BigDecimal sumAmount = BigDecimal.ZERO;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pre_flex"});
        if (pakageMap.size() <= 5) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"next_flex"});
        }
        int i = 0;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = customParams.get("orgid").toString();
        for (Map.Entry<Long, DynamicObject> row : pakageMap.entrySet()) {
            MalGoods goods = malgoodsMap.get(row.getKey());
            if (goods == null) continue;
            DynamicObject pakageentry = row.getValue();
            String issale = "0";
            String noinventorytext = "";
            if (!goods.validateMallStatus()) {
                noinventorytext = ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalPurchasePackageDetail_5", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                issale = "1";
            }
            if (!goods.validateOrgSaleable(Long.valueOf(Long.parseLong(orgid)))) {
                noinventorytext = ResManager.loadKDString((String)"\u4e0d\u53ef\u552e", (String)"MalPurchasePackageDetail_6", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                issale = "1";
            }
            if (!goods.validateStock(pakageentry.getBigDecimal("entryentity.qty"))) {
                noinventorytext = ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalPurchasePackageDetail_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                issale = "1";
            }
            if (pakageentry.getBoolean("entryentity.isprimary")) {
                this.getModel().setValue("maingoodsid", (Object)goods.getId());
                this.getModel().setValue("maingoodssku", (Object)goods.getNumber());
                this.getModel().setValue("mainpicture", (Object)goods.getThumbnail());
                this.getModel().setValue("maingoods_name", (Object)goods.getName());
                this.getModel().setValue("maingoods_price", (Object)goods.getTaxPrice());
                this.getModel().setValue("main_source", (Object)goods.getPlatform());
                this.getModel().setValue("mainsupplier", (Object)goods.getSupplierId());
                this.getModel().setValue("maingoods_qty", (Object)Integer.toString(pakageentry.getBigDecimal("entryentity.qty").intValue()));
                totoalqty += pakageentry.getBigDecimal("entryentity.qty").intValue();
                sumAmount = sumAmount.add(goods.getTaxPrice().multiply(pakageentry.getBigDecimal("entryentity.qty").setScale(0, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP));
            } else {
                DynamicObject entry = entrys.addNew();
                entry.set("goodsid", (Object)goods.getId());
                entry.set("goods_sku", (Object)goods.getNumber());
                entry.set("goods_issale", (Object)issale);
                entry.set("goods_img", (Object)goods.getThumbnail());
                entry.set("goods_name", (Object)goods.getName());
                entry.set("goods_price", (Object)goods.getTaxPrice());
                entry.set("goods_qty", (Object)pakageentry.getBigDecimal("entryentity.qty").intValue());
                entry.set("goods_source", (Object)goods.getPlatform());
                entry.set("noinventorytext", (Object)noinventorytext);
                entry.set("goods_supplier", (Object)goods.getSupplierId());
                if (issale.equals("0")) {
                    entry.set("isselect", (Object)true);
                    totoalqty += pakageentry.getBigDecimal("entryentity.qty").intValue();
                    sumAmount = sumAmount.add(goods.getTaxPrice().multiply(pakageentry.getBigDecimal("entryentity.qty").setScale(0, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP));
                }
            }
            ++i;
        }
        Label totoalqtylabel = (Label)this.getView().getControl("totalqty");
        totoalqtylabel.setText(Integer.toString(totoalqty));
        this.getModel().setValue("sumamount", (Object)sumAmount);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)"isselect", (CharSequence)e.getProperty().getName())) {
            DynamicObject info = this.getModel().getDataEntity(true);
            DynamicObjectCollection col = info.getDynamicObjectCollection("entryentity");
            int totoalqty = 0;
            BigDecimal sumAmount = BigDecimal.ZERO;
            int qty = info.getInt("maingoods_qty");
            BigDecimal price = info.getBigDecimal("maingoods_price");
            sumAmount = price.multiply(BigDecimal.valueOf(qty));
            totoalqty = qty;
            for (DynamicObject entry : col) {
                if (!entry.getBoolean("isselect")) continue;
                totoalqty += entry.getInt("goods_qty");
                sumAmount = sumAmount.add(entry.getBigDecimal("goods_price").multiply(BigDecimal.valueOf(entry.getInt("goods_qty"))));
            }
            Label totoalqtylabel = (Label)this.getView().getControl("totalqty");
            totoalqtylabel.setText(Integer.toString(totoalqty));
            this.getModel().setValue("sumamount", (Object)sumAmount);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_TO_ORDER.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.toOrder();
        } else if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && "addcar".equals(afterDoOperationEventArgs.getOperateKey())) {
            DynamicObjectCollection col = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            IDataModel model = this.getModel();
            ArrayList<MalAddCartParam> malAddCartParams = new ArrayList<MalAddCartParam>();
            MalAddCartParam malAddCartParam = new MalAddCartParam();
            malAddCartParam.setGoodsId(Long.valueOf(Long.parseLong(model.getValue("maingoodsid").toString())));
            malAddCartParam.setGoodsNumber(model.getValue("maingoodssku").toString());
            malAddCartParam.setPlatform(model.getValue("main_source").toString());
            malAddCartParam.setQty(new BigDecimal(model.getValue("maingoods_qty").toString()));
            malAddCartParams.add(malAddCartParam);
            for (DynamicObject entry : col) {
                if (!entry.getBoolean("isselect")) continue;
                malAddCartParam = new MalAddCartParam();
                malAddCartParam.setGoodsId(Long.valueOf(Long.parseLong(entry.getString("goodsid"))));
                malAddCartParam.setGoodsNumber(entry.getString("goods_sku"));
                malAddCartParam.setPlatform(entry.getString("goods_source"));
                malAddCartParam.setQty(BigDecimal.valueOf(entry.getInt("goods_qty")));
                malAddCartParams.add(malAddCartParam);
            }
            if (malAddCartParams.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u52a0\u5165\u8d2d\u7269\u8f66\u7684\u5546\u54c1\uff0c\u8bf7\u9009\u62e9\u5546\u54c1\u540e\u518d\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MalPurchasePackageDetail_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            try {
                ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).batchAddToCart(malAddCartParams);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalPurchasePackageDetail_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setCartNum();
            this.getView().getParentView().invokeOperation("updateview");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void setCartNum() {
        Label cartNo = (Label)this.getView().getParentView().getControl("cartno");
        int cartNumber = MalProductUtil.getCartNumber();
        if (cartNo != null) {
            cartNo.setText(String.valueOf(cartNumber));
        }
    }

    private void toOrder() {
        String msg;
        HashSet<String> supplier = new HashSet<String>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = customParams.get("orgid").toString();
        DynamicObjectCollection col = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<String, Serializable> malToPlaceOrderParam = new HashMap<String, Serializable>();
        ArrayList malToPlaceOrderItems = new ArrayList();
        malToPlaceOrderParam.put("dptOrgId", Long.valueOf(Long.parseLong(orgid)));
        HashMap<String, Object> malToPlaceOrderItem = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        malToPlaceOrderItem.put("goodsId", model.getValue("maingoodsid"));
        malToPlaceOrderItem.put("goodsNumber", model.getValue("maingoodssku"));
        malToPlaceOrderItem.put("platform", model.getValue("main_source"));
        malToPlaceOrderItem.put("qty", model.getValue("maingoods_qty"));
        if (model.getValue("mainsupplier") != null) {
            supplier.add(model.getValue("mainsupplier").toString());
        }
        malToPlaceOrderItems.add(malToPlaceOrderItem);
        for (DynamicObject entry : col) {
            if (!entry.getBoolean("isselect")) continue;
            malToPlaceOrderItem = new HashMap();
            malToPlaceOrderItem.put("goodsId", entry.get("goodsId"));
            malToPlaceOrderItem.put("goodsNumber", entry.get("goods_sku"));
            malToPlaceOrderItem.put("platform", entry.get("goods_source"));
            malToPlaceOrderItem.put("qty", entry.get("goods_qty"));
            malToPlaceOrderItems.add(malToPlaceOrderItem);
            if (model.getValue("mainsupplier") == null) continue;
            supplier.add(entry.getString("goods_supplier"));
        }
        if (supplier.size() > 10) {
            msg = ResManager.loadKDString((String)"\u9009\u62e9\u5546\u54c1\u5c5e\u4e8e10\u5bb6\u4ee5\u4e0a\u7684\u4e0d\u540c\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MalPurchasePackageDetail_0", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        if (malToPlaceOrderItems.size() == 0) {
            msg = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u4e0b\u5355\u7684\u5546\u54c1\uff0c\u8bf7\u9009\u62e9\u5546\u54c1\u540e\u518d\u4e0b\u5355\u3002", (String)"MalPurchasePackageDetail_1", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        malToPlaceOrderParam.put("malToPlaceOrderItemList", malToPlaceOrderItems);
        malToPlaceOrderParam.put("validateGoodsForPlaceOrder", Boolean.valueOf(true));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mal_placeorder");
        parameter.setCustomParam("MAL_TO_PLACEORDER_PARAM", (Object)JSON.toJSONString(malToPlaceOrderParam));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        CardEntry cardEntry;
        IDataModel entry;
        String fieldName = arg0.getFieldName();
        if (Stream.of("goods_name").anyMatch(fieldName::startsWith) && (entry = (cardEntry = (CardEntry)arg0.getSource()).getModel()).getValue("goodsid") != null && entry.getValue("goods_source") != null && entry.getValue("goods_name") != null && entry.getValue("goods_sku") != null) {
            String productId = entry.getValue("goodsid").toString();
            String sourceFrom = entry.getValue("goods_source").toString();
            String name = entry.getValue("goods_name").toString();
            String sku = entry.getValue("goods_sku").toString();
            this.showProdDetail(productId, sourceFrom, name, sku);
        }
    }

    private void showProdDetail(String productId, String sourceFrom, String name, String sku) {
        String origin = (String)this.getView().getFormShowParameter().getCustomParam("origin");
        if (StringUtils.isBlank((CharSequence)origin)) {
            origin = this.getView().getEntityId();
        }
        CloseCallBack closeCallBack = null;
        ShowType showType = ShowType.NewWindow;
        String caption = String.valueOf(name);
        HashMap<String, String> customParamMap = new HashMap<String, String>();
        if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getEntityId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgid = customParams.get("orgid").toString();
            customParamMap.put("purchase_org", orgid);
            origin = this.getView().getEntityId();
            closeCallBack = new CloseCallBack((IFormPlugin)new MalPickGoodsPlugin(), ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey());
            showType = ShowType.Modal;
            caption = "";
        }
        this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)productId, (String)String.valueOf(sku), (String)sourceFrom, (String)caption, (String)origin, (ShowType)showType, customParamMap, closeCallBack));
    }
}

