/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.service.MalGoodsMonitorLogService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.enums.SrcBillTypeEnum;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.ecadmit.MalEcAdmit;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalStock;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.formplugin.util.MalShopCartUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import net.sf.json.JSONArray;

public class MalPurchasePlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog((String)MalPurchasePlugin.class.getName());
    private static final String CACHE_ADDRESS = "cache_address";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADDRESS = "address";
    private static final String GOODSMAPPING = "goodsmapping";
    private static final int MAX_COUNT_SUPPLIER = 10;
    private static final String GOODSMAPPING_CLICK = "goodsmapping_click";
    private static final String PICK_GOODS = "pick_goods";
    private static final String MATERIAL = "material";
    private static final String PICK_ROW_INDEX = "pickRowIndex";
    private static final String ACOUNT = "acountnew";
    private static final String SELECTED = "selected";
    private static final String MAL_PLACEORDER = "mal_placeorder";
    private static final String CART_QTY = "cart_qty";
    private static final String CART_PRICE = "cart_price";
    private static final String CART_AMOUNT = "cart_amount";
    private static final String MAX_PURCHASEQTY = "maxpurchaseqty";
    private static final String MAL_PLAN_IDS = "malPlanIds";
    private static final String SRCENTRYIDS = "srcentryids";
    private static final String MAL_PURCHASE = "mal_purchase";
    private static final String SUCCESS_MUTEX = "successMutex";
    private static final String MUTEX = "mutex";
    private static final String CART_SELECT_AMOUNT = "cart_select_amount";
    private static final String CART_SELECT_QTY = "cart_select_qty";
    private static final String PLANENTRYID = "planentryid";
    private static final String CART_NAME = "cart_name";
    private static final String CART_GOODSOURCE = "cart_goodsource";
    private static final String CART_GOODS = "cart_goods";
    private static final String CART_NUMBER = "cart_number";
    private static final String CART_DESC = "cart_desc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit goodsMappingEdit = (BasedataEdit)this.getControl(GOODSMAPPING);
        goodsMappingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.checkMutex()) {
            return;
        }
        this.allotInitDynamicData();
    }

    private void setEnableLadprice() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        if (Boolean.parseBoolean(param)) {
            ArrayList<Long> goodsIdSet = new ArrayList<Long>(1024);
            for (DynamicObject row : entrys) {
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString(CART_GOODSOURCE))) continue;
                goodsIdSet.add(row.getLong(CART_GOODS));
            }
            Map goodsMap = MalGoods.batchGetLadderPrice(goodsIdSet, (Long)this.getOrgId());
            for (DynamicObject row : entrys) {
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString(CART_GOODSOURCE))) {
                    if (null != goodsMap.get(row.getLong(CART_GOODS))) {
                        cardEntry.setChildVisible(true, row.getInt("seq") - 1, new String[]{"viewladderprice"});
                        continue;
                    }
                    cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
                    continue;
                }
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
            }
        } else {
            for (DynamicObject row : entrys) {
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"viewladderprice"});
            }
        }
    }

    private boolean checkMutex() {
        Map<String, String> planEntryIdMaterialNumMap = this.getPlanEntryIdMaterialNumMap();
        Map mutexResultMap = MutexUtil.batchRequest(planEntryIdMaterialNumMap.keySet(), (String)MAL_PURCHASE, (String)MAL_PURCHASE);
        HashSet successMutexSet = new HashSet(planEntryIdMaterialNumMap.size());
        boolean res = true;
        String failMutex = "";
        for (Map.Entry mutexResultEntry : mutexResultMap.entrySet()) {
            if (!((Boolean)mutexResultEntry.getValue()).booleanValue()) {
                res = false;
                failMutex = (String)mutexResultEntry.getKey();
                continue;
            }
            successMutexSet.add(mutexResultEntry.getKey());
        }
        if (!res) {
            Map<String, String> lockInfo = this.getLockInfo(failMutex);
            if (!ObjectUtils.isEmpty(lockInfo) && RequestContext.get().getGlobalSessionId().equals(lockInfo.get("GLOBALSESSION"))) {
                return true;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7269\u6599{0}\u6b63\u5728\u88ab{1}\u9009\u8d2d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MalPurchasePlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[]{planEntryIdMaterialNumMap.get(failMutex), this.getMutexUserName(lockInfo)}), MessageBoxOptions.OK, new ConfirmCallBackListener(MUTEX, (IFormPlugin)this));
            MutexUtil.batchRelease(successMutexSet, (String)MAL_PURCHASE, (String)MAL_PURCHASE);
            return false;
        }
        this.getPageCache().put(SUCCESS_MUTEX, JSONArray.fromObject(planEntryIdMaterialNumMap.keySet()).toString());
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MUTEX.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
        if ("notifymsg".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("continue", "false");
            this.getView().invokeOperation(ACOUNT);
        }
    }

    private Map<String, String> getPlanEntryIdMaterialNumMap() {
        DynamicObjectCollection malPlanCol = this.queryMalPlan();
        HashMap<String, String> planEntryIdMaterialNumMap = new HashMap<String, String>();
        for (DynamicObject malPlanDyn : malPlanCol) {
            planEntryIdMaterialNumMap.put(malPlanDyn.getString("entryentity.id"), malPlanDyn.getString("entryentity.material.number"));
        }
        return planEntryIdMaterialNumMap;
    }

    private String getMutexUserName(Map<String, String> lockInfo) {
        String mutexUserName = RequestContext.get().getUserName();
        DynamicObject mutexUser = BusinessDataServiceHelper.loadSingle((Object)lockInfo.get("userid"), (String)"bos_user");
        if (mutexUser != null) {
            mutexUserName = mutexUser.getString("name");
        }
        return mutexUserName;
    }

    private Map<String, String> getLockInfo(String failMutex) {
        return MutexUtil.getLockInfo((String)failMutex, (String)MAL_PURCHASE, (String)MAL_PURCHASE);
    }

    private void releaseMutex() {
        String successMutexsStr = this.getPageCache().get(SUCCESS_MUTEX);
        if (StringUtils.isNotEmpty((CharSequence)successMutexsStr)) {
            JSONArray ja = JSONArray.fromObject((Object)successMutexsStr);
            HashSet<String> successMutexSet = new HashSet<String>(ja.size());
            for (int i = 0; i < ja.size(); ++i) {
                successMutexSet.add(ja.getString(i));
            }
            MutexUtil.batchRelease(successMutexSet, (String)MAL_PURCHASE, (String)MAL_PURCHASE);
        }
    }

    private List<Long> getMalPlanIds() {
        Object malPlanIds = this.getView().getFormShowParameter().getCustomParam(MAL_PLAN_IDS);
        if (ObjectUtils.isEmpty((Object)malPlanIds)) {
            return new ArrayList<Long>();
        }
        if (malPlanIds instanceof String) {
            log.info("kd.scm.mal.formplugin.MalPurchasePlugin.getMalPlanIds:" + malPlanIds);
            try {
                return new ArrayList<Long>((Collection<Long>)JSONArray.fromObject((Object)URLDecoder.decode((String)malPlanIds, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                throw new KDBizException((Throwable)e, new ErrorCode("UnsupportedEncodingException", e.getMessage()), new Object[0]);
            }
        }
        return (List)this.getView().getFormShowParameter().getCustomParam(MAL_PLAN_IDS);
    }

    private Set<String> getSrcEntryIds() {
        Object srcEntryIds = this.getView().getFormShowParameter().getCustomParam(SRCENTRYIDS);
        if (ObjectUtils.isEmpty((Object)srcEntryIds)) {
            return new HashSet<String>();
        }
        if (srcEntryIds instanceof String) {
            log.info("kd.scm.mal.formplugin.MalPurchasePlugin.getSrcEntryIds:" + srcEntryIds);
            try {
                return new HashSet<String>((Collection<String>)JSONArray.fromObject((Object)URLDecoder.decode((String)srcEntryIds, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                throw new KDBizException((Throwable)e, new ErrorCode("UnsupportedEncodingException", e.getMessage()), new Object[0]);
            }
        }
        return new HashSet<String>((Collection)this.getView().getFormShowParameter().getCustomParam(SRCENTRYIDS));
    }

    private void setDefaultCurrency() {
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("currency", (Object)MalOrderUtil.getDefaultCurrency());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeToCartMode();
        this.setEnableLadprice();
    }

    private void changeToCartMode() {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("k", ENTRYENTITY);
        data.put("cardmode", 1);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", data);
    }

    private void initAddress(DynamicObjectCollection planDynCol) {
        MalReceipt defaultReceipt;
        long org = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Collection)planDynCol)) {
            org = ((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id");
        }
        if (0L == (defaultReceipt = ((MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class)).getDefaultReceiptByOrg(Long.valueOf(org))).getReceiptId()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u3002", (String)"MalPurchasePlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(ADDRESS, "0");
            this.getPageCache().put(CACHE_ADDRESS, "0");
            return;
        }
        this.getModel().setValue(ADDRESS, (Object)defaultReceipt.getMapAddress());
        this.getPageCache().put(ADDRESS, defaultReceipt.getAdmindivisionId());
        this.getPageCache().put(CACHE_ADDRESS, String.valueOf(defaultReceipt.getReceiptId()));
    }

    private void allotInitDynamicData() {
        DynamicObjectCollection planDynCol = this.queryMalPlan();
        this.setDefaultCurrency();
        this.initAddress(planDynCol);
        this.initHeader(planDynCol);
        this.initEntry(planDynCol);
    }

    private void initHeader(DynamicObjectCollection planDynCol) {
        if (!planDynCol.isEmpty()) {
            this.getModel().setValue("org", (Object)((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id"));
            this.getModel().setValue("header_org", (Object)((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id"));
            this.getModel().setValue("srcbilltype", (Object)SrcBillTypeEnum.fromVal((String)((DynamicObject)planDynCol.get(0)).getString("entryentity.srcbilltype")).getName());
        }
    }

    private Map<Long, MalMatGoodsInitParam> prepareGoodsInitParam(DynamicObjectCollection planDynCol) {
        HashMap<Long, MalMatGoodsInitParam> res = new HashMap<Long, MalMatGoodsInitParam>();
        HashMap<Long, MalMatGoodsInitParam> materialIdMatGoodsInitParamMap = new HashMap<Long, MalMatGoodsInitParam>(planDynCol.size());
        String addressId = this.getPageCache().get(ADDRESS);
        for (DynamicObject planDyn : planDynCol) {
            MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.getParamForInitPurchase((DynamicObject)planDyn, (String)addressId);
            res.put(planDyn.getLong("entryentity.id"), malMatGoodsInitParam);
            materialIdMatGoodsInitParamMap.putIfAbsent(planDyn.getLong("entryentity.material.id"), malMatGoodsInitParam);
        }
        Map<Long, DynamicObject> goodsMappingDynMap = this.materialIdGoodsMappingMap(this.queryGoodsMappingByMaterial(materialIdMatGoodsInitParamMap.keySet()));
        for (Map.Entry<Long, DynamicObject> goodsMappingDynEntry : goodsMappingDynMap.entrySet()) {
            DynamicObject goodsMappingDyn = goodsMappingDynEntry.getValue();
            MalMatGoodsInitParam malMatGoodsInitParam = (MalMatGoodsInitParam)materialIdMatGoodsInitParamMap.get(goodsMappingDyn.getLong("material.id"));
            if (malMatGoodsInitParam == null || 0L == goodsMappingDyn.getLong("material.id") || 0L == goodsMappingDyn.getLong("goods.id")) continue;
            malMatGoodsInitParam.setGoodsId(Long.valueOf(goodsMappingDyn.getLong("goods.id")));
            malMatGoodsInitParam.setSku(goodsMappingDyn.getString("goods.number"));
            malMatGoodsInitParam.setPlatform(goodsMappingDyn.getString("goods.source"));
            malMatGoodsInitParam.setGoodsMappingId(Long.valueOf(goodsMappingDyn.getLong("id")));
        }
        return res;
    }

    private DynamicObjectCollection queryMalPlan() {
        if (!ObjectUtils.isEmpty(this.getSrcEntryIds())) {
            return MalPlan.queryMalPlanBySrcEntryIds(this.getSrcEntryIds());
        }
        return MalPlan.queryMalPlanByIds(this.getMalPlanIds());
    }

    private DynamicObjectCollection queryGoodsMappingByMaterial(Set<Long> materialIdSet) {
        String selectFields = "id,goods.id,material.id,goods.number,goods.source,goods.status,goods.enable,modifytime";
        return QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("material.id", "in", materialIdSet)}, (String)"modifytime asc");
    }

    private Map<Long, DynamicObject> materialIdGoodsMappingMap(DynamicObjectCollection goodsMappingDynCol) {
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>();
        HashSet<Long> goodIds = new HashSet<Long>(1024);
        for (DynamicObject goodsMappingDyn : goodsMappingDynCol) {
            if (!"1".equals(goodsMappingDyn.getString("goods.source"))) continue;
            goodIds.add(goodsMappingDyn.getLong("goods.id"));
        }
        QFilter qFilter = new QFilter("goods.id", "in", goodIds);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        DynamicObjectCollection planDynCol = this.queryMalPlan();
        long orgId = RequestContext.get().getOrgId();
        if (!planDynCol.isEmpty()) {
            orgId = ((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id");
        }
        ArrayList<Long> prodIds = new ArrayList<Long>(1024);
        prodIds.addAll(goodIds);
        List newProdIds = MalProductUtil.getProdIdsByOrg(prodIds, (Long)orgId);
        for (DynamicObject goodsMappingDyn : goodsMappingDynCol) {
            if (!"1".equals(goodsMappingDyn.getString("goods.source"))) {
                res.put(goodsMappingDyn.getLong("material.id"), goodsMappingDyn);
                continue;
            }
            if (!"C".equals(goodsMappingDyn.getString("goods.status")) || !"1".equals(goodsMappingDyn.getString("goods.enable")) || !newProdIds.contains(goodsMappingDyn.getLong("goods.id"))) continue;
            res.put(goodsMappingDyn.getLong("material.id"), goodsMappingDyn);
        }
        return res;
    }

    private Map<Long, DynamicObject> queryGoodsMappingByIds(Set<Long> goodsMappingIds) {
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>();
        String selectFields = "id,goods.id,material.id,goods.number,goods.source,goods.unit.id";
        DynamicObjectCollection prodMatMappingDynCol = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", goodsMappingIds)});
        for (DynamicObject proMatMappingDyn : prodMatMappingDynCol) {
            res.put(proMatMappingDyn.getLong("id"), proMatMappingDyn);
        }
        return res;
    }

    private void initEntry(DynamicObjectCollection planDynCol) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        Map<Long, MalMatGoodsInitParam> malGoodsInitParamMap = this.prepareGoodsInitParam(planDynCol);
        log.info("initEntry:" + malGoodsInitParamMap);
        if (malGoodsInitParamMap.isEmpty()) {
            this.getView().close();
            return;
        }
        Map malGoodsMap = MalGoods.batchInstanceOfInitParamMap(malGoodsInitParamMap);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int i = 0;
        ArrayList<Long> goodsIds = new ArrayList<Long>(16);
        for (Map.Entry<Long, MalMatGoodsInitParam> malGoodsInitParamEntry : malGoodsInitParamMap.entrySet()) {
            MalGoods malGoods;
            if (malGoodsInitParamEntry.getValue().getQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal cartQty = new BigDecimal(malGoodsInitParamEntry.getValue().getQty().toBigInteger().toString());
            vs.set("cart_erpmat", (Object)malGoodsInitParamEntry.getValue().getMaterialId(), i);
            vs.set(CART_QTY, (Object)cartQty, i);
            vs.set(MAX_PURCHASEQTY, (Object)malGoodsInitParamEntry.getValue().getQty(), i);
            vs.set("cart_pk", (Object)malGoodsInitParamEntry.getValue().getPlanId(), i);
            vs.set(PLANENTRYID, (Object)malGoodsInitParamEntry.getValue().getPlanEntryId(), i);
            vs.set("cart_billid", (Object)malGoodsInitParamEntry.getValue().getSrcBillId(), i);
            vs.set("cart_entryid", (Object)malGoodsInitParamEntry.getValue().getSrcEntryId(), i);
            vs.set("cart_billtype", (Object)malGoodsInitParamEntry.getValue().getSrcBillType(), i);
            vs.set("cart_linetype", (Object)malGoodsInitParamEntry.getValue().getLinetypeId(), i);
            vs.set("unit", (Object)malGoodsInitParamEntry.getValue().getUnitId(), i);
            vs.set("entryreqorg", (Object)malGoodsInitParamEntry.getValue().getEntryReqOrgId(), i);
            vs.set("entryrcvorg", (Object)malGoodsInitParamEntry.getValue().getEntryRcvOrgId(), i);
            if (malGoodsInitParamEntry.getValue().getGoodsMappingId() != null && (malGoods = (MalGoods)malGoodsMap.get(malGoodsInitParamEntry.getKey())) != null) {
                vs.set(GOODSMAPPING, (Object)malGoodsInitParamEntry.getValue().getGoodsMappingId(), i);
                vs.set("cart_stock_qty", (Object)this.fillGoodsStock(malGoods, selfInventoryUnlimited), i);
                vs.set("cart_supplier", (Object)malGoods.getSupplierId(), i);
                vs.set(CART_NUMBER, (Object)malGoods.getNumber(), i);
                vs.set(CART_GOODS, (Object)malGoods.getId(), i);
                vs.set("goods", (Object)malGoods.getId(), i);
                vs.set(CART_GOODSOURCE, (Object)malGoods.getPlatform(), i);
                vs.set(CART_DESC, (Object)malGoods.getModel(), i);
                vs.set("cart_pic", (Object)malGoods.getThumbnail(), i);
                vs.set(CART_NAME, (Object)malGoods.getName(), i);
                vs.set("cart_unit", (Object)malGoods.getUnitId(), i);
                vs.set(CART_PRICE, (Object)malGoods.getTaxPrice(), i);
                vs.set(CART_AMOUNT, (Object)malGoods.getTaxPrice().multiply(cartQty), i);
                vs.set("minorderqty_unit", (Object)malGoods.getUnitId(), i);
                vs.set("cart_minorderqty", (Object)malGoods.getMinOrderQty(), i);
                vs.set("cart_leadtime", (Object)malGoods.getLeadtime(), i);
                String desc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalPurchasePlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                String stockDesc = String.valueOf(vs.get("cart_stock_qty", i));
                String goodsource = malGoods.getPlatform();
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource)) {
                    goodsIds.add(malGoods.getId());
                }
                if (!malGoods.validateOrgSaleable(Long.valueOf(this.getOrgId()))) {
                    vs.set("cart_goodsstatus", (Object)1, i);
                    vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u552e", (String)"MalPurchasePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                    continue;
                }
                if (!malGoods.validateMallStatus()) {
                    vs.set("cart_goodsstatus", (Object)1, i);
                    vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalPurchasePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                    continue;
                }
                if (desc.equals(stockDesc) && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) && !malGoods.validateStock(BigDecimal.ONE)) {
                    vs.set("cart_goodsstatus", (Object)1, i);
                    vs.set("noinventorytext", (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalPurchasePlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                    continue;
                }
            }
            ++i;
        }
        if (vs.getCount() > 0) {
            this.getModel().beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
            if (goodsIds.size() > 0) {
                this.doClickPriceMonitorEvent(goodsIds);
            }
        } else {
            this.getView().close();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.updateSelectedValue();
        Set<String> planEntryIds = this.getPlanEntryIds(e.getRowIndexs());
        MutexUtil.batchRelease(planEntryIds, (String)MAL_PURCHASE, (String)MAL_PURCHASE);
    }

    private Set<String> getPlanEntryIds(int[] rowIndexs) {
        HashSet<String> res = new HashSet<String>(rowIndexs.length);
        for (int rowIndex : rowIndexs) {
            res.add((String)this.getModel().getValue(PLANENTRYID, rowIndex));
        }
        return res;
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        if (ENTRYENTITY.equals(grid.getKey())) {
            this.updateSelectedValue();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        String operateKey = ((AbstractOperate)beforeDoOperationEventArgs.getSource()).getOperateKey();
        if (ACOUNT.equals(operateKey)) {
            Boolean isView;
            if (null != this.getPageCache().get("continue")) {
                this.getPageCache().remove("continue");
                return;
            }
            Map<Long, MalMatGoodsInitParam> goodsInitParamMap = this.getGoodsInitParam(this.getSelectIndexs(), true);
            Map malGoodsMap = MalGoods.batchInstanceOfInitParamMap(goodsInitParamMap);
            if (malGoodsMap.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6709\u5546\u54c1\u7684\u884c\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"MalPurchasePlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            HashSet<String> supplierIdSet = new HashSet<String>(malGoodsMap.size());
            HashMap<String, List<String>> ecSkuMap = new HashMap<String, List<String>>(16);
            ArrayList<String> abnormalPriceSkuList = new ArrayList<String>(malGoodsMap.size());
            ArrayList<String> abnormalStockSkuList = new ArrayList<String>(malGoodsMap.size());
            ArrayList<String> abnormalMinOrderQtySkuList = new ArrayList<String>(malGoodsMap.size());
            boolean existSameGoods = false;
            HashSet<String> skuSet = new HashSet<String>(malGoodsMap.size());
            ArrayList<Long> prodIds = new ArrayList<Long>(1024);
            for (Map.Entry entry : malGoodsMap.entrySet()) {
                MalGoods malGoods = (MalGoods)entry.getValue();
                if (malGoods == null || malGoods.getProductId().isEmpty()) continue;
                prodIds.add(Long.parseLong(malGoods.getProductId()));
            }
            DynamicObjectCollection planDynCol = this.queryMalPlan();
            if (planDynCol.size() > 0 && (isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"settle", (Long)((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id"))).booleanValue()) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            for (Map.Entry entry : malGoodsMap.entrySet()) {
                MalGoods malGoods = (MalGoods)entry.getValue();
                if (malGoods == null) continue;
                supplierIdSet.add(malGoods.getSupplierId());
                List ecSkuList = ecSkuMap.computeIfAbsent(malGoods.getPlatform(), s -> new ArrayList());
                ecSkuList.add(malGoods.getNumber());
                if (malGoods.getTaxPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    abnormalPriceSkuList.add(malGoods.getNumber());
                }
                if (!malGoods.validateStock(goodsInitParamMap.get(entry.getKey()).getQty())) {
                    abnormalStockSkuList.add(malGoods.getNumber());
                }
                if (malGoods.getMinOrderQty() != null && malGoods.getMinOrderQty().compareTo(goodsInitParamMap.get(entry.getKey()).getQty()) > 0) {
                    abnormalMinOrderQtySkuList.add(malGoods.getNumber());
                }
                if (!StringUtils.isNotEmpty((CharSequence)malGoods.getNumber()) || existSameGoods) continue;
                existSameGoods = !skuSet.add(malGoods.getNumber());
            }
            if (this.validateSkuLimit(ecSkuMap)) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (!this.validSelfStock(malGoodsMap, goodsInitParamMap)) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (!abnormalPriceSkuList.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalPurchasePlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a{0}", (String)"MalPurchasePlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[]{String.join((CharSequence)",", abnormalPriceSkuList)}), MessageTypes.Default);
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (!abnormalStockSkuList.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u7f3a\u8d27\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalPurchasePlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a{0}", (String)"MalPurchasePlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[]{String.join((CharSequence)",", abnormalStockSkuList)}), MessageTypes.Default);
                beforeDoOperationEventArgs.setCancel(true);
            }
            if (!abnormalMinOrderQtySkuList.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u7684\u91c7\u8d2d\u6570\u91cf\u672a\u8fbe\u5230\u8d77\u8ba2\u91cf\u3002", (String)"MalPurchasePlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a{0}", (String)"MalPurchasePlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[]{String.join((CharSequence)",", abnormalMinOrderQtySkuList)}), MessageTypes.Default);
                beforeDoOperationEventArgs.setCancel(true);
            }
            if (supplierIdSet.size() > 10) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u6700\u5927\u652f\u630110\u4e2a\u5546\u5bb6\u540c\u65f6\u4e0b\u5355\uff0c\u8bf7\u4fee\u6539\u4e0b\u5355\u5546\u54c1\u3002", (String)"MalPurchasePlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (existSameGoods) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ed3\u7b97\u6240\u9009\u5546\u54c1\u884c\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7684\u5546\u54c1\u3002", (String)"MalPurchasePlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (this.existDifferentOrg()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u548c\u6536\u8d27\u7ec4\u7ec7\u5747\u76f8\u540c\u7684\u5546\u54c1\u884c\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"MalPurchasePlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            if (!this.validateMalGoodsMonitorRule(malGoodsMap)) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
        }
    }

    private boolean validateMalGoodsMonitorRule(Map<Long, MalGoods> malGoodsMap) {
        MalGoodsMonitorLogService malGoodsMonitorLogService;
        Collection goodsMonitorLogs;
        ArrayList<String> goodIds = new ArrayList<String>(16);
        ArrayList<Long> goodsPoolIds = new ArrayList<Long>(16);
        for (Map.Entry<Long, MalGoods> map : malGoodsMap.entrySet()) {
            MalGoods malGoods = map.getValue();
            if (null == malGoods) continue;
            goodIds.add(malGoods.getProductId());
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) continue;
            goodsPoolIds.add(malGoods.getGoodsInfo().getProdPoolId());
        }
        if (goodIds.size() > 0 && (goodsMonitorLogs = (malGoodsMonitorLogService = new MalGoodsMonitorLogService()).getGoodsMonitorLogs(goodIds, goodsPoolIds)) != null && goodsMonitorLogs.size() > 0) {
            String disableDeatialMsg = malGoodsMonitorLogService.getDisableDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)disableDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u7981\u6b62\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 \u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalPurchasePlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, disableDeatialMsg, MessageTypes.Default);
                return false;
            }
            String notifyDeatialMsg = malGoodsMonitorLogService.getNotifyDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)notifyDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalPurchasePlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u4e0b\u5355", (String)"MalPurchasePlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, notifyDeatialMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("notifymsg", (IFormPlugin)this), btnNameMaps);
                return false;
            }
        }
        return true;
    }

    private boolean existDifferentOrg() {
        int[] selectIndexs = this.getSelectIndexs();
        HashSet<Object> entryReqOrgSet = new HashSet<Object>(selectIndexs.length * 2);
        HashSet<Object> entryRcvOrgSet = new HashSet<Object>(selectIndexs.length * 2);
        for (int selectIndex : selectIndexs) {
            DynamicObject entryReqOrg = (DynamicObject)this.getModel().getValue("entryreqorg", selectIndex);
            DynamicObject entryRcvOrg = (DynamicObject)this.getModel().getValue("entryrcvorg", selectIndex);
            if (entryReqOrg != null && !ObjectUtils.isEmpty((Object)this.getModel().getValue(CART_NUMBER, selectIndex))) {
                entryReqOrgSet.add(entryReqOrg.getPkValue());
            }
            if (entryRcvOrg == null || ObjectUtils.isEmpty((Object)this.getModel().getValue(CART_NUMBER, selectIndex))) continue;
            entryRcvOrgSet.add(entryRcvOrg.getPkValue());
        }
        return entryReqOrgSet.size() > 1 || entryRcvOrgSet.size() > 1;
    }

    private boolean validateSkuLimit(Map<String, List<String>> ecSkuMap) {
        Map ecSkuNumLimitMap = MalEcAdmit.getEcSkuLimitNum();
        if (!ecSkuNumLimitMap.isEmpty()) {
            StringBuilder tipMsg = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : ecSkuMap.entrySet()) {
                if (!ecSkuNumLimitMap.containsKey(entry.getKey()) || (Integer)ecSkuNumLimitMap.get(entry.getKey()) >= entry.getValue().size()) continue;
                String msg = String.format(ResManager.loadKDString((String)"{0}\u7ed3\u7b97\u5546\u54c1\u4e2a\u6570\u8d85\u8fc7\u7535\u5546\u9650\u5236\u6570{1}\u3002", (String)"MalPurchasePlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)entry.getKey()).getName(), ecSkuNumLimitMap.get(entry.getKey()));
                tipMsg.append(msg);
                tipMsg.append(',');
            }
            if (tipMsg.length() > 0) {
                tipMsg.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7ed3\u7b97\u5546\u54c1\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"MalPurchasePlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showMessage(tipMsg.toString());
                return true;
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "refreshcart": {
                this.refresh();
                break;
            }
            case "acountnew": {
                this.openMakeOrderPage();
                break;
            }
            case "clear_nostock_goods": {
                this.clearNoStockGoods();
                break;
            }
            case "checkall": {
                this.checkAll();
                break;
            }
            case "staddress": {
                this.modifyReceipt();
                break;
            }
        }
    }

    private void pickGoods(int rowIndex) {
        this.getPageCache().put(PICK_ROW_INDEX, String.valueOf(rowIndex));
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("goods");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("cart_erpmat", rowIndex);
        if (materialDyn == null) {
            return;
        }
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        searchParamMap.put("searchText", materialDyn.getString("name"));
        searchParamMap.put(MATERIAL, materialDyn.getLong("id"));
        searchParamMap.put("searchFields", list);
        DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("org");
        if (orgDyn != null) {
            searchParamMap.put("purchase_org", orgDyn.getString("id"));
        }
        showParameter.setCustomParams(searchParamMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PICK_GOODS));
        showParameter.setShowTitle(false);
        this.getView().showForm(showParameter);
    }

    private void modifyReceipt() {
        Long org = (Long)this.getModel().getValue("org_id");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("mal_receiptlist");
        param.setCaption(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f\u5217\u8868", (String)"MalPurchasePlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (org != null && org != 0L) {
            param.setCustomParam("query_org", (Object)String.valueOf(org));
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mal_receiptlist"));
        this.getView().showForm(param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (GOODSMAPPING.equals(e.getProperty().getName())) {
            Map malGoodsMap = MalGoods.batchInstanceOfInitParamMap(this.getGoodsInitParamFromGoodsMapping(new int[]{e.getChangeSet()[0].getRowIndex()}, false));
            this.fillGoods(malGoodsMap);
            this.selectRow(e.getChangeSet()[0].getRowIndex());
            this.setEnableLadprice();
            this.setClickPriceMonitor(e.getChangeSet()[0].getRowIndex());
        }
        if (CART_QTY.equals(e.getProperty().getName())) {
            int rowIndex;
            BigDecimal newQty = (BigDecimal)e.getChangeSet()[0].getNewValue();
            if (this.validateQty(newQty, rowIndex = e.getChangeSet()[0].getRowIndex())) {
                this.updateCartAmount(newQty, rowIndex);
            } else {
                this.getModel().setValue(CART_QTY, e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        }
        this.updateSelectedValue();
    }

    private boolean validateQty(BigDecimal newQty, int rowIndex) {
        BigDecimal maxPurchaseQty = (BigDecimal)this.getModel().getValue(MAX_PURCHASEQTY, rowIndex);
        if (maxPurchaseQty.compareTo(newQty) >= 0 && newQty.compareTo(BigDecimal.ZERO) > 0) {
            return true;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u91cf\u8bf7\u586b\u5199\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u6700\u5927\u91c7\u8d2d\u91cf{0}\u7684\u503c\u3002", (String)"MalPurchasePlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[]{maxPurchaseQty}));
        return false;
    }

    private void updateCartAmount(BigDecimal newQty, int index) {
        this.setLadderPrice(index);
        BigDecimal cartPrice = (BigDecimal)this.getModel().getValue(CART_PRICE, index);
        this.getModel().setValue(CART_AMOUNT, (Object)cartPrice.multiply(newQty), index);
    }

    private void setLadderPrice(int index) {
        if (null != this.getModel().getValue(CART_GOODS, index)) {
            long goodsId = Long.parseLong(String.valueOf(this.getModel().getValue(CART_GOODS, index)));
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(CART_QTY, index));
            String source = (String)this.getModel().getValue(CART_GOODSOURCE, index);
            MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)goodsId, (String)source, (BigDecimal)qty, null, (Long)this.getOrgId()), (boolean)false, (boolean)false);
            if (null != malGoods) {
                this.getModel().setValue(CART_PRICE, (Object)malGoods.getTaxPrice(), index);
                BigDecimal cartPrice = (BigDecimal)this.getModel().getValue(CART_PRICE, index);
                this.getModel().setValue(CART_AMOUNT, (Object)cartPrice.multiply(qty), index);
            }
        }
    }

    private void fillGoods(Map<Long, MalGoods> malGoodsMap) {
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < count; ++i) {
            MalGoods malGoods;
            Object planEntryId = this.getModel().getValue(PLANENTRYID, i);
            if (ObjectUtils.isEmpty((Object)planEntryId) || (malGoods = malGoodsMap.get(Long.valueOf(String.valueOf(planEntryId)))) == null) continue;
            this.fillRowGoods(malGoods, i, selfInventoryUnlimited);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void fillRowGoods(MalGoods malGoods, int index, boolean selfInventoryUnlimited) {
        this.getModel().beginInit();
        this.getModel().setValue("cart_stock_qty", (Object)this.fillGoodsStock(malGoods, selfInventoryUnlimited), index);
        this.getModel().setValue("cart_supplier", (Object)malGoods.getSupplierId(), index);
        this.getModel().setValue(CART_NUMBER, (Object)malGoods.getNumber(), index);
        this.getModel().setValue(CART_GOODS, (Object)malGoods.getId(), index);
        this.getModel().setValue("goods", (Object)malGoods.getId(), index);
        this.getModel().setValue(CART_GOODSOURCE, (Object)malGoods.getPlatform(), index);
        this.getModel().setValue(CART_DESC, (Object)malGoods.getModel(), index);
        this.getModel().setValue("cart_pic", (Object)malGoods.getThumbnail(), index);
        this.getModel().setValue(CART_NAME, (Object)malGoods.getName(), index);
        this.getModel().setValue("cart_unit", (Object)malGoods.getUnitId(), index);
        this.getModel().setValue(CART_PRICE, (Object)malGoods.getTaxPrice(), index);
        this.getModel().setValue(CART_AMOUNT, (Object)malGoods.getTaxPrice().multiply((BigDecimal)this.getModel().getValue(CART_QTY, index)), index);
        this.getModel().setValue("minorderqty_unit", (Object)malGoods.getUnitId(), index);
        this.getModel().setValue("cart_minorderqty", (Object)malGoods.getMinOrderQty(), index);
        this.getModel().setValue("cart_leadtime", (Object)malGoods.getLeadtime(), index);
        this.setGoodsStatus(malGoods, index);
        this.getModel().endInit();
    }

    private void setGoodsStatus(MalGoods malGoods, int index) {
        String desc = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalPurchasePlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        String stockDesc = String.valueOf(this.getModel().getValue("cart_stock_qty", index));
        String goodsource = malGoods.getPlatform();
        if (!malGoods.validateOrgSaleable(Long.valueOf(this.getOrgId()))) {
            this.getModel().setValue("cart_goodsstatus", (Object)1, index);
            this.getModel().setValue("noinventorytext", (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u552e", (String)"MalPurchasePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]), index);
            return;
        }
        if (!malGoods.validateMallStatus()) {
            this.getModel().setValue("cart_goodsstatus", (Object)1, index);
            this.getModel().setValue("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalPurchasePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), index);
            return;
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource)) {
            if (!MallStatusEnum.SOLD.getVal().equals(malGoods.getGoodsInfo().getMallStatus()) || !"B".equals(malGoods.getGoodsInfo().getSupplierMallStatus())) {
                this.getModel().setValue("cart_goodsstatus", (Object)1, index);
                this.getModel().setValue("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalPurchasePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), index);
                return;
            }
        } else if (!"1".equals(malGoods.getGoodsInfo().getMallStatus()) || !"B".equals(malGoods.getGoodsInfo().getSupplierMallStatus())) {
            this.getModel().setValue("cart_goodsstatus", (Object)1, index);
            this.getModel().setValue("noinventorytext", (Object)ResManager.loadKDString((String)"\u5df2\u4e0b\u67b6", (String)"MalPurchasePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), index);
            return;
        }
        if (desc.equals(stockDesc) && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource) && !malGoods.validateStock(BigDecimal.ONE)) {
            this.getModel().setValue("cart_goodsstatus", (Object)1, index);
            this.getModel().setValue("noinventorytext", (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalPurchasePlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]), index);
            return;
        }
        this.getModel().setValue("cart_goodsstatus", (Object)0, index);
        this.getModel().setValue("noinventorytext", (Object)"");
    }

    private String fillGoodsStock(MalGoods malGoods, boolean selfInventoryUnlimited) {
        String stockDesc = malGoods.getStockDesc();
        if (stockDesc == null) {
            return ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalPurchasePlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            if ("".equals(stockDesc)) {
                stockDesc = ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalPurchasePlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            } else {
                BigDecimal stockQty = new BigDecimal(stockDesc);
                if (stockQty.compareTo(BigDecimal.ZERO) <= 0) {
                    stockDesc = selfInventoryUnlimited ? ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalPurchasePlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalPurchasePlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return stockDesc;
    }

    private Map<Long, MalMatGoodsInitParam> getGoodsInitParam(int[] rowIndexs, boolean isValidateStock) {
        HashMap<Long, MalMatGoodsInitParam> res = new HashMap<Long, MalMatGoodsInitParam>();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return res;
        }
        String addressId = this.getPageCache().get(ADDRESS);
        for (int rowIndex : rowIndexs) {
            DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("cart_erpmat", rowIndex);
            if (materialDyn == null) continue;
            MalMatGoodsInitParam malMatGoodsInitParam = new MalMatGoodsInitParam(Long.valueOf(materialDyn.getLong("id")), (BigDecimal)this.getModel().getValue(CART_QTY, rowIndex), addressId, Long.valueOf((String)this.getModel().getValue(PLANENTRYID, rowIndex)));
            DynamicObject headerOrg = (DynamicObject)this.getModel().getValue("header_org");
            if (headerOrg != null) {
                malMatGoodsInitParam.setEntryReqOrgId(Long.valueOf(headerOrg.getLong("id")));
            }
            if (!this.isGoodsNotEmpty(rowIndex)) continue;
            malMatGoodsInitParam.setGoodsId(Long.valueOf(String.valueOf(this.getModel().getValue(CART_GOODS, rowIndex))));
            malMatGoodsInitParam.setGoodsUnitId(Long.valueOf((String)this.getModel().getValue("cart_unit", rowIndex)));
            if (isValidateStock) {
                malMatGoodsInitParam.setQtyForQueryStock((BigDecimal)this.getModel().getValue(CART_QTY, rowIndex));
            }
            malMatGoodsInitParam.setSku(String.valueOf(this.getModel().getValue(CART_NUMBER, rowIndex)));
            malMatGoodsInitParam.setPlatform(String.valueOf(this.getModel().getValue(CART_GOODSOURCE, rowIndex)));
            res.put(malMatGoodsInitParam.getPlanEntryId(), malMatGoodsInitParam);
        }
        return res;
    }

    private boolean isGoodsNotEmpty(int rowIndex) {
        return !ObjectUtils.isEmpty((Object)this.getModel().getValue(CART_GOODS, rowIndex)) && !"0".equals(this.getModel().getValue(CART_GOODS, rowIndex));
    }

    private Map<Long, MalMatGoodsInitParam> getGoodsInitParamFromGoodsMapping(int[] rowIndexs, boolean isValidateStock) {
        HashMap<Long, MalMatGoodsInitParam> res = new HashMap<Long, MalMatGoodsInitParam>();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return res;
        }
        HashSet<Long> goodsMappingIds = new HashSet<Long>(rowIndexs.length);
        for (int rowIndex : rowIndexs) {
            DynamicObject goodsMappingDyn = (DynamicObject)this.getModel().getValue(GOODSMAPPING, rowIndex);
            if (goodsMappingDyn == null) continue;
            goodsMappingIds.add(goodsMappingDyn.getLong("id"));
        }
        Map<Long, DynamicObject> goodsMappingMap = this.queryGoodsMappingByIds(goodsMappingIds);
        String addressId = this.getPageCache().get(ADDRESS);
        for (int rowIndex : rowIndexs) {
            DynamicObject goodsMappingDyn;
            DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("cart_erpmat", rowIndex);
            if (materialDyn == null || (goodsMappingDyn = (DynamicObject)this.getModel().getValue(GOODSMAPPING, rowIndex)) == null) continue;
            goodsMappingDyn = goodsMappingMap.get(goodsMappingDyn.getLong("id"));
            MalMatGoodsInitParam malMatGoodsInitParam = new MalMatGoodsInitParam(Long.valueOf(materialDyn.getLong("id")), (BigDecimal)this.getModel().getValue(CART_QTY, rowIndex), addressId, Long.valueOf((String)this.getModel().getValue(PLANENTRYID, rowIndex)));
            DynamicObject headerOrg = (DynamicObject)this.getModel().getValue("header_org");
            if (headerOrg != null) {
                malMatGoodsInitParam.setEntryReqOrgId(Long.valueOf(headerOrg.getLong("id")));
            }
            malMatGoodsInitParam.setGoodsUnitId(Long.valueOf(goodsMappingDyn.getLong("goods.unit.id")));
            if (isValidateStock) {
                malMatGoodsInitParam.setQtyForQueryStock((BigDecimal)this.getModel().getValue(CART_QTY, rowIndex));
            }
            malMatGoodsInitParam.setGoodsId(Long.valueOf(goodsMappingDyn.getLong("goods.id")));
            malMatGoodsInitParam.setSku(goodsMappingDyn.getString("goods.number"));
            malMatGoodsInitParam.setPlatform(goodsMappingDyn.getString("goods.source"));
            res.put(malMatGoodsInitParam.getPlanEntryId(), malMatGoodsInitParam);
        }
        return res;
    }

    private void checkAll() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        String selected = this.getPageCache().get(SELECTED);
        if (selected != null) {
            cardEntry.selectRows(new int[0], 0);
            this.getPageCache().put(SELECTED, null);
            this.updateSelectedValue();
            return;
        }
        this.getPageCache().put(SELECTED, "1");
        cardEntry.selectRows(IntStream.range(0, this.getModel().getEntryRowCount(ENTRYENTITY)).toArray(), 0);
        this.updateSelectedValue();
    }

    private void clearNoStockGoods() {
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        Map malStockMap = MalStock.batchInstanceOfGoodsInitParam(this.getGoodsInitParam(IntStream.range(0, this.getModel().getEntryRowCount(ENTRYENTITY)).toArray(), false));
        int[] selectedIndexs = this.getSelectIndexs();
        for (int i = 0; i < this.getModel().getEntryRowCount(ENTRYENTITY); ++i) {
            DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", i);
            if (goodsDyn == null) continue;
            MalStock malStock = (MalStock)malStockMap.get(goodsDyn.getLong("id"));
            if (((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malStock, BigDecimal.ONE)) continue;
            this.fillRowGoods(MalGoods.EMPTY_GOODS, i, selfInventoryUnlimited);
            this.getModel().setValue(GOODSMAPPING, null, i);
            selectedIndexs = this.removeSelectedIndex(selectedIndexs, i);
        }
        this.getView().updateView(ENTRYENTITY);
        this.setEnableLadprice();
        if (selectedIndexs.length == 0) {
            return;
        }
        this.selectRows(selectedIndexs);
    }

    private int[] removeSelectedIndex(int[] selectedIndexs, int removeIndex) {
        return Arrays.stream(selectedIndexs).filter(index -> removeIndex != index).toArray();
    }

    private void selectRows(int[] selectedIndexArr) {
        CardEntry entry = (CardEntry)this.getControl(ENTRYENTITY);
        entry.selectRows(selectedIndexArr, selectedIndexArr[0]);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("mal_receiptlist".equals(actionId) && null != (returnData = (Map)closedCallBackEvent.getReturnData())) {
            this.getModel().setValue(ADDRESS, returnData.get("mapaddress"));
            this.getPageCache().put(ADDRESS, (String)returnData.get(ADDRESS));
            this.getPageCache().put(CACHE_ADDRESS, (String)returnData.get("id"));
            this.refresh();
        }
        if (PICK_GOODS.equals(actionId)) {
            returnData = (Map)closedCallBackEvent.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            Object goodsMapping = returnData.get(GOODSMAPPING);
            if (!ObjectUtils.isEmpty(goodsMapping)) {
                int index = Integer.parseInt(this.getPageCache().get(PICK_ROW_INDEX));
                this.getModel().setValue(GOODSMAPPING, goodsMapping, index);
                this.selectRow(index);
            }
            this.setEnableLadprice();
        }
        if (ACOUNT.equals(actionId)) {
            if ("PLACED_ORDER".equals(String.valueOf(closedCallBackEvent.getReturnData()))) {
                this.allotInitDynamicData();
            } else {
                this.refresh();
            }
        }
    }

    private void setClickPriceMonitor(int index) {
        Object cart_goods = this.getModel().getValue(CART_GOODS, index);
        Object goodsource = this.getModel().getValue("CART_GOODSOURCE", index);
        if (!ObjectUtils.isEmpty((Object)cart_goods) && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource)) {
            ArrayList<Long> goodsIds = new ArrayList<Long>(16);
            goodsIds.add(Long.parseLong(String.valueOf(cart_goods)));
            this.doClickPriceMonitorEvent(goodsIds);
        }
    }

    private void doClickPriceMonitorEvent(List<Long> goodsIds) {
        HashMap<String, List<Long>> dataMap = new HashMap<String, List<Long>>(16);
        dataMap.put("goodsIds", goodsIds);
        EventServiceHelper.triggerEventSubscribe((String)"pmm_ecgoods.pricemonitor", (String)SerializationUtils.toJsonString(dataMap));
    }

    private void selectRow(int index) {
        CardEntry entry = (CardEntry)this.getControl(ENTRYENTITY);
        entry.selectRows(new int[]{index}, index);
    }

    private void refresh() {
        Map malGoods = MalGoods.batchInstanceOfInitParamMap(this.getGoodsInitParam(IntStream.range(0, this.getModel().getEntryRowCount(ENTRYENTITY)).toArray(), false));
        this.fillGoods(malGoods);
        this.updateSelectedValue();
        this.setEnableLadprice();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object src;
        int currentIndex = hyperLinkClickEvent.getRowIndex();
        if (CART_NAME.equals(hyperLinkClickEvent.getFieldName()) || CART_NUMBER.equals(hyperLinkClickEvent.getFieldName()) || CART_DESC.equals(hyperLinkClickEvent.getFieldName())) {
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRYENTITY, currentIndex);
            String source = row.getString(CART_GOODSOURCE);
            DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
            HashMap<String, String> customParamMap = new HashMap<String, String>(1);
            if (orgDyn != null) {
                customParamMap.put("purchase_org", orgDyn.getString("id"));
            }
            this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)row.getString(CART_GOODS), (String)row.getString(CART_NUMBER), (String)source, (String)row.getString(CART_NAME), (String)MAL_PURCHASE, (ShowType)ShowType.NewWindow, customParamMap, null));
        }
        if (GOODSMAPPING_CLICK.equals(hyperLinkClickEvent.getFieldName())) {
            BasedataEdit goodsMapping = (BasedataEdit)this.getControl(GOODSMAPPING);
            goodsMapping.click();
        }
        if (PICK_GOODS.equals(hyperLinkClickEvent.getFieldName())) {
            this.pickGoods(hyperLinkClickEvent.getRowIndex());
        }
        if ((src = hyperLinkClickEvent.getSource()) instanceof CardEntry && ENTRYENTITY.equals(((CardEntry)src).getEntryKey())) {
            this.updateSelectedValue();
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject row = this.getModel().getEntryRowEntity(ENTRYENTITY, currentIndex);
        if ("viewladderprice".equals(fieldName)) {
            this.showLadderPrice(row);
            return;
        }
    }

    private void showLadderPrice(DynamicObject row) {
        String source = row.getString(CART_GOODSOURCE);
        String goodsId = row.getString(CART_GOODS);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            ArrayList<Long> goodsIds = new ArrayList<Long>(1);
            goodsIds.add(Long.parseLong(goodsId));
            Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)this.getOrgId());
            if (null != goodsMap.get(Long.parseLong(goodsId))) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("pbd_ladderprice");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, String> detailParamMap = new HashMap<String, String>();
                detailParamMap.put("status", "1");
                detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(goodsMap.get(Long.parseLong(goodsId))));
                showParameter.setCustomParams(detailParamMap);
                this.getView().showForm(showParameter);
            }
        }
    }

    private long getOrgId() {
        long orgId = RequestContext.get().getOrgId();
        if (this.getModel().getValue("header_org") != null) {
            DynamicObject purchaseOrg = (DynamicObject)this.getModel().getValue("header_org");
            orgId = purchaseOrg.getLong("id");
        }
        return orgId;
    }

    private int[] getSelectIndexs() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        return entryentity.getEntryState().getSelectedRows();
    }

    private void updateSelectedValue() {
        int[] selectedIndexs = this.getSelectIndexs();
        BigDecimal selectedQty = BigDecimal.ZERO;
        BigDecimal selectedAmount = BigDecimal.ZERO;
        if (selectedIndexs.length > 0 && selectedIndexs[0] != -1) {
            for (int selectedIndex : selectedIndexs) {
                if (!this.isGoodsNotEmpty(selectedIndex)) continue;
                selectedQty = selectedQty.add((BigDecimal)this.getModel().getValue(CART_QTY, selectedIndex));
                selectedAmount = selectedAmount.add((BigDecimal)this.getModel().getValue(CART_AMOUNT, selectedIndex));
            }
        }
        this.getModel().setValue(CART_SELECT_QTY, (Object)selectedQty);
        this.getModel().setValue(CART_SELECT_AMOUNT, (Object)selectedAmount);
        this.getView().updateView(CART_SELECT_QTY);
        this.getView().updateView(CART_SELECT_AMOUNT);
    }

    private DynamicObjectCollection getSelectedEntryCol() {
        int[] selectedIndexs = this.getSelectIndexs();
        DynamicObjectCollection selectedRowsDyObject = new DynamicObjectCollection();
        for (int selectedIndex : selectedIndexs) {
            DynamicObject selectedEntry = this.getModel().getEntryRowEntity(ENTRYENTITY, selectedIndex);
            if (!this.isGoodsNotEmpty(selectedIndex)) continue;
            selectedRowsDyObject.add((Object)selectedEntry);
        }
        return selectedRowsDyObject;
    }

    private boolean validSelfStock(Map<Long, MalGoods> malGoodsMap, Map<Long, MalMatGoodsInitParam> goodsInitParamMap) {
        boolean selfInventoryUnlimited;
        StringBuilder goodsNumberSb = new StringBuilder();
        malGoodsMap.forEach((id, malGoods) -> {
            if (malGoods != null && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, ((MalMatGoodsInitParam)goodsInitParamMap.get(id)).getQty())) {
                goodsNumberSb.append(malGoods.getNumber()).append("\n");
            }
        });
        if (goodsNumberSb.length() > 0 && !(selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002", (String)"MalPurchasePlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]), goodsNumberSb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private void openMakeOrderPage() {
        DynamicObjectCollection selectedEntryEntryCol = this.getSelectedEntryCol();
        HashMap<Long, String> priceMap = new HashMap<Long, String>(1024);
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1024);
        for (Object dyn : selectedEntryEntryCol) {
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)dyn.getLong(CART_GOODS), (String)dyn.getString(CART_GOODSOURCE), (BigDecimal)BigDecimal.ONE, null, (Long)this.getOrgId());
            param.setCompareId(Long.valueOf(0L));
            malMatGoodsInitParams.add(param);
        }
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
        for (DynamicObject info : selectedEntryEntryCol) {
            Long goodsId = info.getLong(CART_GOODS);
            MalGoods malGoods = (MalGoods)malGoodsMap.get(goodsId);
            if (null == malGoods.getComparePrices() || malGoods.getComparePrices().size() <= 0) continue;
            priceMap.put(goodsId, ((ComparePriceInfo)malGoods.getComparePrices().get(0)).getPageId().toString());
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>(5);
        customParam.put("slectProd", MalShopCartUtil.dyoColToMap(selectedEntryEntryCol));
        customParam.put("param_amount", this.getModel().getValue(CART_SELECT_AMOUNT));
        customParam.put(ADDRESS, this.getPageCache().get(CACHE_ADDRESS));
        customParam.put("opentype", MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
        customParam.put("frompurchase", "1");
        customParam.put("compareprice", SerializationUtils.toJsonString(priceMap));
        customParam.put("orgId", this.getOrgId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(MAL_PLACEORDER);
        parameter.setCustomParams(customParam);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACOUNT));
        parameter.setShowClose(true);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit goodsMappingEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        goodsMappingEdit.getDisplayProp();
        DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("cart_erpmat", beforeF7SelectEvent.getRow());
        if (materialDyn != null) {
            Long materialid = materialDyn.getLong("id");
            QFilter qFilter = new QFilter("material.id", "=", (Object)materialid);
            qFilter.and(new QFilter("goods.status", "=", (Object)"C"));
            qFilter.and(new QFilter("goods.enable", "=", (Object)"1"));
            DynamicObjectCollection pmm_prodmatmapping = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)"goods.id,goods.source", (QFilter[])qFilter.toArray());
            HashSet<Long> goodIds = new HashSet<Long>(1024);
            for (DynamicObject mapping : pmm_prodmatmapping) {
                goodIds.add(mapping.getLong("goods.id"));
            }
            DynamicObjectCollection planDynCol = this.queryMalPlan();
            List<Long> prodGoodsIds = new ArrayList<Long>(1024);
            if (!planDynCol.isEmpty()) {
                Long orgId = ((DynamicObject)planDynCol.get(0)).getLong("entryentity.entryreqorg.id");
                prodGoodsIds.addAll(goodIds);
                prodGoodsIds = MalProductUtil.getProdIdsByOrg(prodGoodsIds, (Long)orgId);
            }
            for (DynamicObject goodsMappingDyn : pmm_prodmatmapping) {
                if ("1".equals(goodsMappingDyn.getString("goods.source"))) continue;
                prodGoodsIds.add(goodsMappingDyn.getLong("goods.id"));
            }
            qFilter = new QFilter("materielfield.id", "=", (Object)materialid);
            qFilter.and(new QFilter("goods.id", "in", prodGoodsIds));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseMutex();
    }

    public void pageRelease(EventObject e) {
        this.releaseMutex();
    }
}

