/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;

public class MalRecCheckPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog((String)MalRecCheckPlugin.class.getName());
    public static final String BD_ADMINDIVISION = "bd_admindivision";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject user = (DynamicObject)this.getModel().getValue("creator");
        String userName = user.getString("name");
        this.getModel().setValue("name", (Object)userName);
    }

    public boolean beforeSave(DynamicObject dynamicObject) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            this.validateMapping();
        }
        return true;
    }

    protected void validateMapping() {
        DynamicObject addressDyn = this.getModel().getDataEntity();
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            return;
        }
        Long admindivisionId = addressDyn.getLong("address");
        StringBuilder tips = new StringBuilder();
        for (String openedMalNo : openedMalNos) {
            String longNumber = AddressUtil.getLongNumber((Long)admindivisionId, (String)openedMalNo);
            if (!StringUtils.isEmpty((CharSequence)longNumber) || "9".equals(openedMalNo)) continue;
            tips.append(EcPlatformEnum.fromVal((String)openedMalNo).getName()).append(" ");
        }
        if (tips.length() > 0) {
            String msg = ResManager.loadKDString((String)"\u5730\u5740\u4e0e\u7528\u6237\u5730\u5740\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u5730\u5740\u5bf9\u5e94\u5173\u7cfb\uff08\u5546\u57ce\u7ba1\u7406-\u57fa\u7840\u8bbe\u7f6e-\u7535\u5546\u5730\u5740\u5339\u914d\uff09\u3002", (String)"MalRecCheckPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(tips.toString().trim() + msg);
        }
    }

    @Deprecated
    public boolean validatePhone(String phone) {
        return true;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String operationKey = evt.getOperationKey();
        if ("save".equals(operationKey) && !this.beforeSave(dynamicObject)) {
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        Map paramsMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if ("save".equals(operationKey) && paramsMap != null && paramsMap.get("isCallByMakeOrder") instanceof Boolean && ((Boolean)paramsMap.get("isCallByMakeOrder")).booleanValue()) {
            CommonUtil.check((OperationResult)afterDoOperationEventArgs.getOperationResult());
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            if (!ObjectUtils.isEmpty((Object)successPkIds)) {
                String id = String.valueOf(successPkIds.get(0));
                String name = dynamicObject.getString("name");
                String wholeaddress = dynamicObject.getString("wholeaddress");
                String phone = dynamicObject.getString("phone");
                String email = dynamicObject.getString("email");
                String address = dynamicObject.getString("address");
                HashMap<String, String> returnData = new HashMap<String, String>();
                returnData.put("id", id);
                returnData.put("name", name);
                returnData.put("wholeaddress", wholeaddress);
                returnData.put("phone", phone);
                returnData.put("email", email);
                returnData.put("address", address);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    @Deprecated
    protected boolean isHasJdToken() {
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            return false;
        }
        return openedMalNos.contains(EcPlatformEnum.ECPLATFORM_JD.getVal());
    }
}

