/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.ValidateMatchUtil;

public class MalReceiptListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY_SHARING = "entryentity1";
    private static final String TAB_PRIVATE = "tab_private";
    private static final String TAB_SHARING = "tab_sharing";
    private static final String TAB_SELECT = "tabselect";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.allotInitDynamicData();
        this.getPageCache().put(TAB_SELECT, TAB_PRIVATE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderParamUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SHARING});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                this.setReturnDataToParent();
            }
        }
    }

    private void setReturnDataToParent() {
        String tabSelect = this.getPageCache().get(TAB_SELECT);
        if (TAB_PRIVATE.equals(tabSelect)) {
            this.privateAddressReturn();
        } else {
            this.sharingAddressReturn();
        }
    }

    private void privateAddressReturn() {
        int[] index = this.getSelectIndex();
        if (index.length > 0) {
            DynamicObject dyo = this.getSelectedDyObject(index[0]);
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mal_address", (String)"id,mapaddress", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dyo.getLong("id"))});
            this.returnData(dyo, queryOne.getString("mapaddress"), "");
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u3002", (String)"MalReceiptListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void returnData(DynamicObject dyo, String mapaddress, String suffix) {
        String id = dyo.getString("id" + suffix);
        String name = dyo.getString("name" + suffix);
        String wholeaddress = dyo.getString("wholeaddress" + suffix);
        String phone = dyo.getString("phone" + suffix);
        String email = dyo.getString("email" + suffix);
        String address = dyo.getString("address" + suffix);
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("id", id);
        returnData.put("name", name);
        returnData.put("wholeaddress", wholeaddress);
        returnData.put("phone", phone);
        returnData.put("email", email);
        returnData.put("address", address);
        returnData.put("mapaddress", mapaddress);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void sharingAddressReturn() {
        IDataModel gridModel;
        DynamicObject entryObject;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY_SHARING);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u3002", (String)"MalReceiptListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if ((entryObject = (gridModel = grid.getModel()).getEntryRowEntity(ENTRYENTITY_SHARING, selectedRows[0])).getBoolean("isfullinfo")) {
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mal_address", (String)"id,mapaddress", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entryObject.getLong("id1"))});
            this.returnData(entryObject, queryOne.getString("mapaddress"), "1");
        } else {
            String receiptName = entryObject.getString("name1");
            String phone = entryObject.getString("phone1");
            String email = entryObject.getString("email1");
            StringBuilder mustInputMsg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)receiptName)) {
                mustInputMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u59d3\u540d\u201d\u3002\n", (String)"MalReceiptListPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)phone)) {
                mustInputMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8054\u7cfb\u65b9\u5f0f\u201d\u3002\n", (String)"MalReceiptListPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)email)) {
                mustInputMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u90ae\u7bb1\u201d\u3002\n", (String)"MalReceiptListPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (mustInputMsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"MalReceiptListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), mustInputMsg.toString(), MessageTypes.Default);
                return;
            }
            if (!ValidateMatchUtil.isTel((String)phone) && !StringUtils.isPhoneNumberValid((String)phone)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u586b\u5199\u7684\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"MalReceiptListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!ValidateMatchUtil.isEmail((String)email)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"MalReceiptListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = this.addNewPrivateAddress(entryObject);
            this.returnData(dynamicObject, dynamicObject.getString("mapaddress"), "");
        }
    }

    private DynamicObject addNewPrivateAddress(DynamicObject entryObject) {
        DynamicObject sharingAddress = QueryServiceHelper.queryOne((String)"pmm_address", (String)"id,name,phone,address,wholeaddress,mapaddress,jdaddressnum,email,postalcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entryObject.getLong("id1"))});
        Map map = DynamicObjectUtil.object2Map((DynamicObject)sharingAddress);
        map.remove("id");
        map.remove("number");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"mal_address");
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        map.forEach((key, value) -> {
            if (properties.containsKey(key)) {
                dynamicObject.set(key, value);
            }
        });
        dynamicObject.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"mal_address", (DynamicObject)dynamicObject, null));
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("type", (Object)"A");
        dynamicObject.set("createorg", (Object)RequestContext.get().getOrgId());
        dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        dynamicObject.set("useorg", (Object)RequestContext.get().getOrgId());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
        dynamicObject.set("name", (Object)entryObject.getString("name1"));
        dynamicObject.set("phone", (Object)entryObject.getString("phone1"));
        dynamicObject.set("email", (Object)entryObject.getString("email1"));
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and(new QFilter("default", "=", (Object)"1"));
        boolean exists = QueryServiceHelper.exists((String)"mal_address", (QFilter[])qFilter.toArray());
        if (!exists) {
            dynamicObject.set("default", (Object)"1");
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        try {
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_address", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)option);
            if (!saveResult.isSuccess()) {
                StringBuilder errMsg = new StringBuilder();
                for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                    errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u4e2a\u4eba\u5730\u5740\u5931\u8d25\uff1a{0}", (String)"MalReceiptListPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[]{errMsg}));
            }
            dynamicObject.set("id", saveResult.getSuccessPkIds().get(0));
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        return dynamicObject;
    }

    private void allotInitDynamicData() {
        this.allotInitPrivateAddress();
        this.allotInitSharingAddress();
    }

    private void allotInitPrivateAddress() {
        QFilter typefilter;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String selectFields = "id,number,name,phone,wholeaddress,email,postalcode,address";
        QFilter enablefilter = new QFilter("enable", "=", (Object)"1");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter personfilter = new QFilter("creator", "=", (Object)userId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{enablefilter, personfilter, typefilter = new QFilter("type", "=", (Object)"A")});
        if (null != dynamicObjects && dynamicObjects.size() > 0) {
            EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)ENTRYENTITY);
            List propertyList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)entryProp.getItemType());
            TableValueSetter vs = DynamicFormUtil.batchBindData((DynamicObjectCollection)dynamicObjects, (List)propertyList, (String)"");
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        }
    }

    private void allotInitSharingAddress() {
        if (!MalOrderParamUtil.getDefaultMalVersion()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String query_org = (String)this.getView().getFormShowParameter().getCustomParam("query_org");
        if (StringUtils.isBlank((CharSequence)query_org)) {
            return;
        }
        long orgId = Long.parseLong(query_org);
        QFilter sharingQFilter = new QFilter("type", "=", (Object)"B");
        sharingQFilter.and("enable", "=", (Object)"1");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_address", (Long)orgId);
        sharingQFilter.and(baseDataFilter);
        String selectFields = "id,number,name,phone,wholeaddress,email,postalcode,address";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pmm_address", (String)selectFields, (QFilter[])sharingQFilter.toArray());
        if (null != dynamicObjects && dynamicObjects.size() > 0) {
            EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)ENTRYENTITY_SHARING);
            List propertyList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)entryProp.getItemType());
            TableValueSetter vs = DynamicFormUtil.batchBindData((DynamicObjectCollection)dynamicObjects, (List)propertyList, (String)"1");
            model.batchCreateNewEntryRow(ENTRYENTITY_SHARING, vs);
        }
        DynamicObjectCollection sharingEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY_SHARING);
        for (int index = 0; index < sharingEntryEntity.size(); ++index) {
            if (!StringUtils.isBlank((CharSequence)((DynamicObject)sharingEntryEntity.get(index)).getString("name1")) && !StringUtils.isBlank((CharSequence)((DynamicObject)sharingEntryEntity.get(index)).getString("phone1")) && !StringUtils.isBlank((CharSequence)((DynamicObject)sharingEntryEntity.get(index)).getString("email1"))) continue;
            this.getModel().setValue("isfullinfo", (Object)Boolean.FALSE, index);
        }
    }

    private int[] getSelectIndex() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        return grid.getEntryState().getSelectedRows();
    }

    private DynamicObject getSelectedDyObject(int selectedIndex) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        IDataModel gridModel = grid.getModel();
        DynamicObject entryObject = gridModel.getEntryRowEntity(ENTRYENTITY, selectedIndex);
        return entryObject;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent evt) {
        this.getPageCache().put(TAB_SELECT, evt.getTabKey());
    }
}

