/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.formplugin.MalPickGoodsPlugin;
import kd.scm.mal.formplugin.util.MalAddToOftenBuyUtil;

public class MalSameGoodsDetailPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final String MAL_NEWPRODUCTDETAIL = "mal_newproductdetail";

    public void registerListener(EventObject e) {
        Label entercomparelabel;
        super.registerListener(e);
        Label autocompare = (Label)this.getControl("autocompare");
        if (autocompare != null) {
            autocompare.addClickListener((ClickListener)this);
        }
        if ((entercomparelabel = (Label)this.getControl("entercomparelabel")) != null) {
            entercomparelabel.addClickListener((ClickListener)this);
        }
        CardEntry grid = (CardEntry)this.getView().getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = null;
        if (evt.getSource() instanceof Button) {
            button = (Button)evt.getSource();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.get("malSameKindGoods") == null || customParams.get("maingoodsid") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"emptycontainer"});
        String addressid = customParams.get("addressid").toString();
        String orgid = customParams.get("orgid").toString();
        String maingoodsid = customParams.get("maingoodsid").toString();
        Object mainsource = customParams.get("mainsource");
        this.getModel().setValue("maingoodsid", (Object)maingoodsid);
        this.getModel().setValue("mainsource", mainsource);
        this.getModel().setValue("goodsprice", customParams.get("goodsprice"));
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entrys.clear();
        String malSameKindGoodsstr = customParams.get("malSameKindGoods").toString();
        List malSameKindGoodsList = (List)SerializationUtils.fromJsonString((String)malSameKindGoodsstr, List.class);
        ArrayList<MalMatGoodsInitParam> list = new ArrayList<MalMatGoodsInitParam>(malSameKindGoodsList.size());
        HashMap<Long, LinkedHashMap> malsamegoodsMap = new HashMap<Long, LinkedHashMap>(malSameKindGoodsList.size());
        for (LinkedHashMap mal : malSameKindGoodsList) {
            MalMatGoodsInitParam param = new MalMatGoodsInitParam();
            param.setGoodsId(Long.valueOf(Long.parseLong(mal.get("goodsId").toString())));
            param.setPlatform(String.valueOf(mal.get("source")));
            param.setAddressId(addressid);
            param.setOrgId(Long.valueOf(Long.parseLong(orgid)));
            param.setQty(BigDecimal.ONE);
            list.add(param);
            malsamegoodsMap.put(Long.parseLong(mal.get("goodsId").toString()), mal);
        }
        Map malgoodsMap = MalGoods.batchInstance(list, (boolean)true, (boolean)false);
        this.loadGoodsData(malgoodsMap, malsamegoodsMap);
    }

    private void loadGoodsData(Map<Long, MalGoods> malgoodsMap, Map<Long, LinkedHashMap> malsamegoodsMap) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entrys.clear();
        Long maingoodsid = Long.parseLong(this.getModel().getValue("maingoodsid").toString());
        for (Map.Entry<Long, LinkedHashMap> row : malsamegoodsMap.entrySet()) {
            MalGoods goods = malgoodsMap.get(row.getKey());
            if (goods.getId().equals(maingoodsid)) continue;
            LinkedHashMap malSameKindGoods = row.getValue();
            DynamicObject entry = entrys.addNew();
            entry.set("searchgoods_img", (Object)goods.getThumbnail());
            entry.set("number", (Object)goods.getNumber());
            entry.set("name", (Object)goods.getName());
            String centralpurtype = null;
            if ("1".equals(goods.getCentralpurtype())) {
                centralpurtype = ResManager.loadKDString((String)"\u96c6\u56e2\u96c6\u91c7", (String)"MalSameGoodsDetailPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            } else if ("2".equals(goods.getCentralpurtype())) {
                centralpurtype = ResManager.loadKDString((String)"\u533a\u57df\u96c6\u91c7", (String)"MalSameGoodsDetailPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            } else if ("3".equals(goods.getCentralpurtype())) {
                centralpurtype = ResManager.loadKDString((String)"\u516c\u53f8\u81ea\u91c7", (String)"MalSameGoodsDetailPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            }
            entry.set("centralpurtype1", (Object)goods.getCentralpurtype());
            entry.set("centralpurtype", (Object)centralpurtype);
            entry.set("model", (Object)goods.getModel());
            entry.set("supplier", (Object)goods.getSupplierName());
            entry.set("brandname", (Object)goods.getBarcode());
            entry.set("leadtime", (Object)goods.getLeadtime());
            entry.set("source", (Object)goods.getPlatform());
            if (malSameKindGoods.get("unitName") != null) {
                entry.set("unitname", malSameKindGoods.get("unitName"));
            }
            entry.set("taxprice", (Object)goods.getTaxPrice());
            entry.set("qty", (Object)BigDecimal.ONE);
            entry.set("goodsid", (Object)goods.getId());
        }
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        CardEntry cardEntry;
        IDataModel entry;
        String fieldName = arg0.getFieldName();
        if (Stream.of("name", "supplier", "centralpurtype").anyMatch(fieldName::startsWith) && (entry = (cardEntry = (CardEntry)arg0.getSource()).getModel()).getValue("goodsid") != null && entry.getValue("source") != null && entry.getValue("name") != null && entry.getValue("number") != null) {
            String productId = entry.getValue("goodsid").toString();
            String sourceFrom = entry.getValue("source").toString();
            String name = entry.getValue("name").toString();
            String sku = entry.getValue("number").toString();
            this.showProdDetail(productId, sourceFrom, name, sku);
        }
    }

    private void showProdDetail(String productId, String sourceFrom, String name, String sku) {
        String origin = (String)this.getView().getFormShowParameter().getCustomParam("origin");
        if (StringUtils.isBlank((CharSequence)origin)) {
            origin = this.getView().getEntityId();
        }
        CloseCallBack closeCallBack = null;
        ShowType showType = ShowType.NewWindow;
        String caption = String.valueOf(name);
        HashMap<String, String> customParamMap = new HashMap<String, String>();
        if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getEntityId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgid = customParams.get("orgid").toString();
            customParamMap.put("purchase_org", orgid);
            origin = this.getView().getEntityId();
            closeCallBack = new CloseCallBack((IFormPlugin)new MalPickGoodsPlugin(), ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey());
            showType = ShowType.Modal;
            caption = "";
        }
        this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)productId, (String)String.valueOf(sku), (String)sourceFrom, (String)caption, (String)origin, (ShowType)showType, customParamMap, closeCallBack));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        int[] selectIndexs = this.getFocusIndexes();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"add_compare")) {
            this.getModel().setValue("isincompare", (Object)Boolean.TRUE, selectIndexs[0]);
            long pk = Long.parseLong(String.valueOf(this.getModel().getValue("goodsid", selectIndexs[0])));
            this.getPageCache().put("isfristadd", "1");
            int num = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addCompareRecord(Long.valueOf(pk), Long.valueOf(RequestContext.get().getCurrUserId()), 0);
            this.updateCompareNum(num);
        }
    }

    private void updateCompareNum(int compareNum) {
        this.getView().getParentView().getModel().setValue("compare_num", (Object)Math.max(compareNum, 0));
        this.getView().getParentView().invokeOperation("updateview");
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int[] selectIndexs = this.getFocusIndexes();
        switch (operateKey) {
            case "addcart": {
                long pk = Long.parseLong(String.valueOf(this.getModel().getValue("goodsid", selectIndexs[0])));
                MalGoods malGoods = MalGoods.of((Long)pk);
                this.checkStock(malGoods);
                if (!MAL_NEWPRODUCTDETAIL.equals(this.getView().getFormShowParameter().getParentFormId()) || this.getView().getParentView() == null) break;
                this.getView().getParentView().invokeOperation("updateview");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "add2oftenbuy": {
                DynamicObject selectDObject = this.getSelectedDyObject(selectIndexs);
                long pk = Long.parseLong(String.valueOf(this.getModel().getValue("goodsid", selectIndexs[0])));
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", selectIndexs[0]);
                HashMap<Long, BigDecimal> goodsId2QtyMap = new HashMap<Long, BigDecimal>(1);
                goodsId2QtyMap.put(pk, qty);
                boolean success = MalAddToOftenBuyUtil.add(goodsId2QtyMap);
                if (success) {
                    String msg = ResManager.loadKDString((String)"\u52a0\u5165\u5e38\u4e70\u6210\u529f\u3002", (String)"MalSearchNewListV1Plugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(selectDObject.getString("name") + "\t" + msg);
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u52a0\u5165\u5e38\u4e70\u5931\u8d25\u3002", (String)"MalSearchNewListV1Plugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(selectDObject.getString("name") + "\t" + msg);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)"add_cart", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.addToCart();
        }
    }

    private int[] getFocusIndexes() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        return grid.getEntryState().getFocusRows();
    }

    private void addToCart() {
        int[] selectedIndexs = this.getFocusIndexes();
        DynamicObject selectDObject = this.getSelectedDyObject(selectedIndexs);
        long pk = Long.parseLong(selectDObject.getString("goodsid"));
        String source = String.valueOf(selectDObject.getString("source"));
        BigDecimal addQty = selectDObject.getBigDecimal("qty");
        if (addQty.compareTo(BigDecimal.ZERO) <= 0) {
            addQty = BigDecimal.ONE;
        }
        ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).addToCart(Long.valueOf(pk), source, addQty);
        String msg = ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalSameGoodsDetailPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }

    private void checkStock(MalGoods malGoods) {
        if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, BigDecimal.ONE)) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !MalOrderParamUtil.isSelfInventoryUnlimited()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MalSearchNewListV1Plugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("add_cart", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u8d2d\u7269\u8f66\u5417\uff1f", (String)"MalSearchNewListV1Plugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
        }
        this.addToCart();
    }

    protected DynamicObject getSelectedDyObject(int[] selectedIndexs) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        IDataModel gridModel = grid.getModel();
        String entryKey = grid.getKey();
        return gridModel.getEntryRowEntity(entryKey, selectedIndexs[0]);
    }
}

