/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.StyleUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.mal.common.addcart.MalAddToCartHelper;
import kd.scm.mal.common.service.impl.SelectByNewStrategy;
import kd.scm.mal.common.service.impl.SelectBySalesStrategy;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalSearchUtils;
import kd.scm.mal.formplugin.util.MalAdd2OftenbuyUtil;
import kd.scm.mal.formplugin.util.MalProductUtil;
import net.sf.json.JSONArray;

public class MalSearchListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener,
EntryGridBindDataListener {
    private static final String SEARCHFIELDS = "searchFields";
    private static Log log = LogFactory.getLog(MalSearchListPlugin.class);
    private static final String SEARCHAP = "searchap";
    private static final String SEARCH_ENTRYENTITY = "search_entryentity";
    private static final String SEARCH_IMG = "searchgoods_img";
    private static final String SEARCH_PRICE = "searchgoods_price";
    private static final String SEARCH_NAME = "searchgoods_name";
    private static final String PRODUCT_SOURCE = "productgoods_source";
    private static final String PRODUCT_SUPPLIER = "supplier";
    private static final String SEARCH_PK = "searchgoods_pk";
    private static final String MYORDER_FLEX = "myorderflex";
    private static final String MYCART_FLEX = "mycartflex";
    private static final String CART_NO = "cartno";
    private static final String BTNCOMPLEX = "btncomplex";
    private static final String BTNPRICE = "btnprice";
    private static final String BTNSALES = "btnsales";
    private static final String CBQYSP = "cbqysp";
    private static final String TEXTFIELDPRICE0 = "textfieldprice0";
    private static final String TEXTFIELDPRICE1 = "textfieldprice1";
    private static final String BTNCONFIRM = "btnconfirm";
    private static final String LABELNUM = "labelnum";
    private static final String CACHE_STARTPRICE = "CACHE_STARTPRICE";
    private static final String CACHE_ENDPRICE = "CACHE_ENDPRICE";
    private static final String CACHE_ISQYSP = "CACHE_ISQYSP";
    private static final String CACHE_SEARCHFIELDSTR = "CACHE_SEARCHFIELDSTR";
    private static final String CACHE_SEARCHCONTENT = "CACHE_SEARCHCONTENT";
    private static final String CACHE_PRICESORT = "CACHE_PRICESORT";
    private static final String CACHE_PRODUCTLIST = "CACHE_PRODUCTLIST";
    private static final String CACHE_SALESSORT = "CACHE_SALESSORT";
    private static final String SELECTBYSTRATEGY = "strategy";
    private static final String PRICEDOWN = MalSearchListPlugin.getMsgFaileds();
    private static final String PRICEUP = MalSearchListPlugin.getMsgMap();
    private static final String SALESDOWN = MalSearchListPlugin.getMsgData();
    private static final String SALESUP = MalSearchListPlugin.getMsgOperation();
    private static final String CATEGORYFILTERCONTAINERKEY = "categoryfiltercontainer";
    private static final String MALFILTERPANELKEY = "malfiltercontainer";
    private static final String PREFIXCATEGORYLB = "filterpanel";
    private static final String CACHE_CATEGORY = "CACHE_CATEGORY";
    private static final String FILTERCATEGORYALL = "filterpanel_-1";
    private static final String FILTERMALALL = "mal_all";
    private static final String FILTERMALSELF = "mal_self";
    private static final String FILTERMALJD = "mal_jd";
    private static final String PREFIXMALLB = "mal";
    private static final String CACHE_MAL = "CACHE_MAL";
    private static final String CACHE_OLDCAT = "CACHE_OLDCAT";
    private static final String ALL = "all";

    private static String getMsgFaileds() {
        return ResManager.loadKDString((String)"\u4ef7\u683c\u2193", (String)"MalSearchListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgMap() {
        return ResManager.loadKDString((String)"\u4ef7\u683c\u2191", (String)"MalSearchListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgData() {
        return ResManager.loadKDString((String)"\u9500\u91cf\u2193", (String)"MalSearchListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgOperation() {
        return ResManager.loadKDString((String)"\u9500\u91cf\u2191", (String)"MalSearchListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List productList = new ArrayList();
        if (null != this.getPageCache().get(CACHE_PRODUCTLIST)) {
            productList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
        }
        CardEntry cardEntry = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
        int index = 0;
        for (int i = e.getStartIndex(); i < productList.size() && index < e.getRows().size(); ++index, ++i) {
            cardEntry.setChildVisible(false, index, new String[]{"pricedown"});
            cardEntry.setChildVisible(false, index, new String[]{"qysp"});
            if ("1".equals(((GoodsInfo)productList.get(i)).getCentralpurtype()) && this.getView().getControl("qysp") != null) {
                cardEntry.setChildVisible(true, index, new String[]{"qysp"});
            }
            if (!((GoodsInfo)productList.get(i)).isPriceDown()) continue;
            cardEntry.setChildVisible(true, index, new String[]{"pricedown"});
        }
    }

    public void registerListener(EventObject e) {
        Label labelMalAll;
        Label labelCategory;
        Button btnconfirm;
        Button btnsales;
        Button btnprice;
        super.registerListener(e);
        CardEntry grid = (CardEntry)this.getView().getControl(SEARCH_ENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        grid.addDataBindListener((EntryGridBindDataListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        Container imgContainer = (Container)this.getControl("card_img_content");
        imgContainer.addClickListener((ClickListener)this);
        Container myOrderContainer = (Container)this.getControl(MYORDER_FLEX);
        myOrderContainer.addClickListener((ClickListener)this);
        Container myCartContainer = (Container)this.getControl(MYCART_FLEX);
        myCartContainer.addClickListener((ClickListener)this);
        Button btncomplex = (Button)this.getView().getControl(BTNCOMPLEX);
        if (btncomplex != null) {
            btncomplex.addClickListener((ClickListener)this);
        }
        if ((btnprice = (Button)this.getView().getControl(BTNPRICE)) != null) {
            btnprice.addClickListener((ClickListener)this);
        }
        if ((btnsales = (Button)this.getView().getControl(BTNSALES)) != null) {
            btnsales.addClickListener((ClickListener)this);
        }
        if ((btnconfirm = (Button)this.getView().getControl(BTNCONFIRM)) != null) {
            btnconfirm.addClickListener((ClickListener)this);
        }
        if ((labelCategory = (Label)this.getView().getControl(FILTERCATEGORYALL)) != null) {
            labelCategory.addClickListener((ClickListener)this);
        }
        if ((labelMalAll = (Label)this.getView().getControl(FILTERMALALL)) != null) {
            labelMalAll.addClickListener((ClickListener)this);
        }
        this.updateCartNo();
    }

    public void click(EventObject evt) {
        Map<String, String> filterCache;
        List<GoodsInfo> productList;
        String changeText;
        List<GoodsInfo> productList2;
        super.click(evt);
        Container source = null;
        Button btn = null;
        if (evt.getSource() instanceof Container) {
            source = (Container)evt.getSource();
        }
        if (evt.getSource() instanceof Button) {
            btn = (Button)evt.getSource();
        }
        if (source != null && StringUtils.equals((CharSequence)"card_img_content", (CharSequence)source.getKey())) {
            String productId = String.valueOf(source.getModel().getValue(SEARCH_PK));
            String sourceFrom = String.valueOf(source.getModel().getValue(PRODUCT_SOURCE));
            MainPageUtils.showDetailPage((IFormView)this.getView(), (String)productId, (String)sourceFrom, (String)String.valueOf(source.getModel().getValue(SEARCH_NAME)), (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
        }
        this.getPageCache().put(CACHE_ISQYSP, "0");
        if (btn != null && StringUtils.equals((CharSequence)BTNCOMPLEX, (CharSequence)btn.getKey())) {
            productList2 = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
            this.setFilterPanelSizeLabel(productList2.size());
            this.clikStyleChange(BTNPRICE, false, null);
            this.clikStyleChange(BTNCOMPLEX, true, null);
            this.clikStyleChange(BTNSALES, false, null);
        }
        if (btn != null && StringUtils.equals((CharSequence)BTNPRICE, (CharSequence)btn.getKey())) {
            changeText = this.getPageCache().get(CACHE_PRICESORT);
            int orderby = 0;
            if (changeText != null) {
                if (PRICEUP.equals(changeText)) {
                    changeText = PRICEDOWN;
                    orderby = 1;
                } else {
                    changeText = PRICEUP;
                    orderby = 0;
                }
            } else {
                changeText = PRICEDOWN;
                orderby = 1;
            }
            if (this.getPageCache().get(CACHE_PRODUCTLIST) != null && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_PRODUCTLIST))) {
                productList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
                productList = this.goodsFilterByMalFromCache(productList);
                productList = this.goodsFilterByCategoryFromCache(productList);
                productList = this.goodsShoppriceFilterFromCache(productList);
                productList = this.goodsQyspFilterFromCache(productList);
                this.goodsSort(productList, orderby);
                this.setFilterPanelSizeLabel(productList.size());
                filterCache = this.getFilterCache();
                this.refreshData(productList);
                this.recache(filterCache);
                this.getPageCache().put(CACHE_PRICESORT, changeText);
            }
            this.clikStyleChange(BTNPRICE, true, changeText);
            this.clikStyleChange(BTNCOMPLEX, false, null);
            this.clikStyleChange(BTNSALES, false, null);
        }
        if (btn != null && StringUtils.equals((CharSequence)BTNSALES, (CharSequence)btn.getKey())) {
            changeText = this.getPageCache().get(CACHE_SALESSORT);
            int orderby = 0;
            if (changeText != null) {
                if (SALESUP.equals(changeText)) {
                    changeText = SALESDOWN;
                    orderby = 1;
                } else {
                    changeText = SALESUP;
                    orderby = 0;
                }
            } else {
                changeText = SALESDOWN;
                orderby = 1;
            }
            if (this.getPageCache().get(CACHE_PRODUCTLIST) != null && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_PRODUCTLIST))) {
                productList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
                this.setFilterPanelSizeLabel(productList.size());
                productList = this.goodsFilterByMalFromCache(productList);
                productList = this.goodsFilterByCategoryFromCache(productList);
                productList = this.goodsShoppriceFilterFromCache(productList);
                productList = this.goodsQyspFilterFromCache(productList);
                this.goodsSortBySales(productList, orderby);
                this.setFilterPanelSizeLabel(productList.size());
                filterCache = this.getFilterCache();
                this.refreshData(productList);
                this.recache(filterCache);
                this.getPageCache().put(CACHE_SALESSORT, changeText);
            }
            this.clikStyleChange(BTNPRICE, false, null);
            this.clikStyleChange(BTNCOMPLEX, false, null);
            this.clikStyleChange(BTNSALES, true, changeText);
        }
        if (btn != null && StringUtils.equals((CharSequence)BTNCONFIRM, (CharSequence)btn.getKey())) {
            String startPricestr = ((String)this.getModel().getValue(TEXTFIELDPRICE0)).trim();
            String endPricestr = ((String)this.getModel().getValue(TEXTFIELDPRICE1)).trim();
            if (!((startPricestr.length() <= 0 || ValidateMatchUtil.isDouble((String)startPricestr) && ValidateMatchUtil.isPositiveNumber((String)startPricestr)) && (endPricestr.length() <= 0 || ValidateMatchUtil.isDouble((String)endPricestr) && ValidateMatchUtil.isPositiveNumber((String)endPricestr)))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4ef7\u683c\u3002", (String)"MalSearchListPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            double startPrice = Double.parseDouble(startPricestr.equals("") ? "0" : startPricestr);
            double endPrice = Double.parseDouble(endPricestr.equals("") ? "2147483647" : endPricestr);
            List<GoodsInfo> productList3 = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
            productList3 = this.goodsFilterByMalFromCache(productList3);
            productList3 = this.goodsFilterByCategoryFromCache(productList3);
            productList3 = this.goodsShoppriceFilter(productList3, startPrice, endPrice);
            productList3 = this.goodsQyspFilterFromCache(productList3);
            productList3 = this.goodsSortByShopPriceFromCache(productList3);
            this.setFilterPanelSizeLabel(productList3.size());
            Map<String, String> filterMap = this.getFilterCache();
            this.refreshData(productList3);
            this.recache(filterMap);
            this.getPageCache().put(CACHE_STARTPRICE, startPrice + "");
            this.getPageCache().put(CACHE_ENDPRICE, endPrice + "");
        }
        if (btn != null && btn.getKey() != null && btn.getKey().split("_").length > 1 && StringUtils.equals((CharSequence)PREFIXCATEGORYLB, (CharSequence)btn.getKey().split("_")[0])) {
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u5206\u7c7b\u70b9\u51fb\u4e8b\u4ef6\u5f00\u59cb------------");
            log.info("@@btn.getKey()\uff1a" + btn.getKey());
            productList2 = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
            log.info("@@\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6productList\uff1a" + productList2.size());
            productList2 = this.goodsFilterByMalFromCache(productList2);
            log.info("@@\u5546\u57ce\u8fc7\u6ee4\u540eproductList\uff1a" + productList2.size());
            productList2 = this.goodsShoppriceFilterFromCache(productList2);
            log.info("@@\u4ef7\u683c\u8fc7\u6ee4\u540eproductList\uff1a" + productList2.size());
            productList2 = this.goodsQyspFilterFromCache(productList2);
            log.info("@@\u7b7e\u7ea6\u5546\u54c1\u8fc7\u6ee4\u540eproductList\uff1a" + productList2.size());
            String category = btn.getKey().split("_")[1];
            productList2 = this.goodsFilterByCategory(productList2, category);
            log.info("@@\u5206\u7c7b\u8fc7\u6ee4\u7684category\uff1a" + category);
            log.info("@@\u5206\u7c7b\u8fc7\u6ee4\u540eproductList\uff1a" + productList2.size());
            productList2 = this.goodsSortByShopPriceFromCache(productList2);
            log.info("@@\u4ef7\u683c\u6392\u5e8f\u540eproductList\uff1a" + productList2.size());
            this.setFilterPanelSizeLabel(productList2.size());
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(CACHE_CATEGORY))) {
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)FILTERCATEGORYALL, (String)"", (String)"");
            }
            if (!StringUtils.equals((CharSequence)category, (CharSequence)this.getPageCache().get(CACHE_CATEGORY))) {
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)("filterpanel_" + this.getPageCache().get(CACHE_CATEGORY)), (String)"", (String)"");
            }
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)btn.getKey(), (String)"#FFFFFF", (String)"#FC8555");
            Map<String, String> filterMap = this.getFilterCache();
            this.refreshData(productList2);
            this.recache(filterMap);
            this.getPageCache().put(CACHE_CATEGORY, category);
            log.info("@@\u6700\u540e\u7684productlist:" + productList2.size());
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u5206\u7c7b\u70b9\u51fb\u4e8b\u4ef6\u7ed3\u675f------------");
        }
        if (btn != null && btn.getKey() != null && btn.getKey().split("_").length > 1 && StringUtils.equals((CharSequence)PREFIXMALLB, (CharSequence)btn.getKey().split("_")[0])) {
            productList2 = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
            String mal = btn.getKey().split("_")[1];
            productList2 = this.goodsFilterByMal(productList2, mal);
            productList2 = this.goodsShoppriceFilterFromCache(productList2);
            productList2 = this.goodsQyspFilterFromCache(productList2);
            productList2 = this.goodsFilterByCategoryFromCache(productList2);
            productList2 = this.goodsSortByShopPriceFromCache(productList2);
            this.setFilterPanelSizeLabel(productList2.size());
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(CACHE_MAL))) {
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)FILTERMALALL, (String)"", (String)"");
            } else if (!StringUtils.equals((CharSequence)mal, (CharSequence)this.getPageCache().get(CACHE_MAL))) {
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)("mal_" + this.getPageCache().get(CACHE_MAL)), (String)"", (String)"");
            }
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)btn.getKey(), (String)"#FFFFFF", (String)"#FC8555");
            Map<String, String> filterMap = this.getFilterCache();
            this.refreshData(productList2);
            this.recache(filterMap);
            this.getPageCache().put(CACHE_MAL, mal);
        }
    }

    public void goodsSortBySales(List<GoodsInfo> productList, int orderby) {
        if (orderby == 0) {
            productList.sort(Comparator.comparing(GoodsInfo::getSales));
        } else {
            productList.sort(Comparator.comparing(GoodsInfo::getSales).reversed());
        }
    }

    private List<GoodsInfo> goodsFilterByMal(List<GoodsInfo> productList, String mal) {
        if (mal.equals(ALL)) {
            return productList;
        }
        return productList.stream().filter(a -> {
            String malName = "";
            String malVal = "";
            if (mal.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                malName = ProductSourceEnum.PRODUCTSOURCE_SELF.getName();
                malVal = ProductSourceEnum.PRODUCTSOURCE_SELF.getVal();
            }
            if (mal.equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                malName = ProductSourceEnum.PRODUCTSOURCE_JD.getName();
                malVal = ProductSourceEnum.PRODUCTSOURCE_JD.getVal();
            }
            return a.getProductSource().equals(malName) || a.getProductSource().equals(malVal);
        }).collect(Collectors.toList());
    }

    private List<GoodsInfo> goodsFilterByMalFromCache(List<GoodsInfo> productList) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_MAL))) {
            if (this.getPageCache().get(CACHE_MAL).equals(ALL)) {
                return productList;
            }
            return productList.stream().filter(a -> {
                String malName = "";
                String malVal = "";
                if (this.getPageCache().get(CACHE_MAL).equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                    malName = ProductSourceEnum.PRODUCTSOURCE_SELF.getName();
                    malVal = ProductSourceEnum.PRODUCTSOURCE_SELF.getVal();
                }
                if (this.getPageCache().get(CACHE_MAL).equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                    malName = ProductSourceEnum.PRODUCTSOURCE_JD.getName();
                    malVal = ProductSourceEnum.PRODUCTSOURCE_JD.getVal();
                }
                return a.getProductSource().equals(malName) || a.getProductSource().equals(malVal);
            }).collect(Collectors.toList());
        }
        return productList;
    }

    private List<GoodsInfo> goodsFilterByCategoryFromCache(List<GoodsInfo> productList) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_CATEGORY))) {
            return this.goodsFilterByCategory(productList, this.getPageCache().get(CACHE_CATEGORY));
        }
        return productList;
    }

    private List<GoodsInfo> goodsFilterByCategory(List<GoodsInfo> productList, String category) {
        if (StringUtils.equals((CharSequence)category, (CharSequence)"-1")) {
            return productList;
        }
        return productList.stream().filter(a -> StringUtils.equalsIgnoreCase((CharSequence)a.getCategoryNumber(), (CharSequence)category)).collect(Collectors.toList());
    }

    private List<GoodsInfo> goodsShoppriceFilter(List<GoodsInfo> productList, double startPrice, double endPrice) {
        List<GoodsInfo> goodsInfos = productList.stream().filter(a -> a.getShopPrice().compareTo(BigDecimal.valueOf(startPrice)) >= 0 && a.getShopPrice().compareTo(BigDecimal.valueOf(endPrice)) <= 0).collect(Collectors.toList());
        return goodsInfos;
    }

    public void goodsSort(List<GoodsInfo> productList, int orderby) {
        if (orderby == 0) {
            productList.sort(Comparator.comparing(GoodsInfo::getShopPrice));
        } else {
            productList.sort(Comparator.comparing(GoodsInfo::getShopPrice).reversed());
        }
    }

    private void refreshData(List<GoodsInfo> productList) {
        log.info("\u5206\u5f55\u52a0\u8f7d\u5f00\u59cb");
        this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
        this.showSearchList(productList);
        String productListStr = this.getPageCache().get(CACHE_PRODUCTLIST);
        this.getView().updateView(SEARCH_ENTRYENTITY);
        log.info("\u5206\u5f55\u52a0\u8f7d\u7ed3\u675f");
        this.getPageCache().put(CACHE_PRODUCTLIST, productListStr);
    }

    public List<GoodsInfo> goodsQyspFilter(List<GoodsInfo> productList, boolean isQysp) {
        ArrayList<GoodsInfo> goodsInfos = new ArrayList();
        if (isQysp) {
            goodsInfos = productList.stream().filter(a -> {
                if (a.getCentralpurtype() != null && StringUtils.isNotEmpty((CharSequence)a.getCentralpurtype())) {
                    return a.getCentralpurtype().equals("1");
                }
                return false;
            }).collect(Collectors.toList());
            return goodsInfos;
        }
        return productList;
    }

    private List<GoodsInfo> goodsShoppriceFilterFromCache(List<GoodsInfo> productList) {
        List<GoodsInfo> goodsInfos = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_STARTPRICE))) {
            double startPrice = Double.parseDouble(this.getPageCache().get(CACHE_STARTPRICE));
            double endPrice = Double.parseDouble(this.getPageCache().get(CACHE_ENDPRICE));
            goodsInfos = this.goodsShoppriceFilter(productList, startPrice, endPrice);
            this.getPageCache().put(CACHE_STARTPRICE, startPrice + "");
            this.getPageCache().put(CACHE_ENDPRICE, endPrice + "");
            return goodsInfos;
        }
        return productList;
    }

    private List<GoodsInfo> goodsQyspFilterFromCache(List<GoodsInfo> productList) {
        List<Object> goodsInfos = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_ISQYSP))) {
            goodsInfos = this.getPageCache().get(CACHE_ISQYSP).equals("1") ? this.goodsQyspFilter(productList, true) : this.goodsQyspFilter(productList, false);
            return goodsInfos;
        }
        return productList;
    }

    protected List<GoodsInfo> goodsSortByShopPriceFromCache(List<GoodsInfo> productList) {
        String changeText;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_PRICESORT)) && StringUtils.isNotEmpty((CharSequence)(changeText = this.getPageCache().get(CACHE_PRICESORT)))) {
            if (PRICEDOWN.equals(changeText)) {
                this.goodsSort(productList, 1);
            } else {
                this.goodsSort(productList, 0);
            }
        }
        return productList;
    }

    public void createNewData(BizDataEventArgs e) {
    }

    private void clikStyleChange(String key, boolean isClicking, String changeText) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        list.add(key);
        if (isClicking) {
            dataMap.put("fc", "#FFFFFF");
            dataMap.put("bc", "#FC8555");
        } else {
            dataMap.put("fc", "#FC8555");
            dataMap.put("bc", "");
        }
        if (changeText != null) {
            dataMap.put("text", (String)new LocaleString(changeText));
        }
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("currency", (Object)MalOrderUtil.getDefaultCurrency());
        }
        Label cartNo = (Label)this.getControl(CART_NO);
        int cartNumber = MalProductUtil.getCartNumber();
        this.getPageCache().put(CART_NO, String.valueOf(cartNumber));
        cartNo.setText(String.valueOf(cartNumber));
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        log.info("@@showParameterMap:" + showParameterMap);
        String searchContent = null;
        this.getModel().getEntryEntity(SEARCH_ENTRYENTITY);
        if (showParameterMap != null && showParameterMap.containsKey("searchText") && showParameterMap.containsKey(SEARCHFIELDS)) {
            searchContent = showParameterMap.get("searchText").toString();
            Search search = (Search)this.getView().getControl(SEARCHAP);
            JSONArray searchFields = new ArrayList();
            try {
                if (showParameterMap.get(SEARCHFIELDS) instanceof String) {
                    searchContent = URLDecoder.decode(searchContent, "UTF-8");
                    String searchFieldsStr = (String)showParameterMap.get(SEARCHFIELDS);
                    String decodeSearchFieldsStr = URLDecoder.decode(searchFieldsStr, "UTF-8");
                    searchFields = JSONArray.fromObject((Object)decodeSearchFieldsStr);
                } else {
                    searchFields = (List)showParameterMap.get(SEARCHFIELDS);
                }
                int size = 0;
                if ("1".equals(showParameterMap.get("isSearchByJDCatNum"))) {
                    searchFields.add("group.longnumber");
                    List goodsInfos = MalSearchUtils.searchFromJDByCategory((String)searchContent, (int)1, (int)200);
                    this.refreshData(goodsInfos);
                    size = goodsInfos.size();
                    this.getPageCache().put(CACHE_PRODUCTLIST, SerializationUtils.toJsonString((Object)goodsInfos));
                } else {
                    size = showParameterMap.get("source") != null ? this.refreshSearchData(searchContent, (List<String>)searchFields, (String)showParameterMap.get("source"), null, false, new QFilter[0]) : this.refreshSearchData(searchContent, (List<String>)searchFields);
                }
                this.setFilterPanelSizeLabel(size);
                String searchFieldstr = String.join((CharSequence)"_", (Iterable<? extends CharSequence>)searchFields);
                this.getPageCache().put(CACHE_SEARCHFIELDSTR, searchFieldstr);
                this.getPageCache().put(CACHE_SEARCHCONTENT, searchContent);
                Object searchShowName = showParameterMap.get("searchShowName");
                if (searchShowName != null) {
                    String decodeSearchShowName = URLDecoder.decode(searchShowName.toString(), "UTF-8");
                    search.setSearchKey(decodeSearchShowName);
                } else {
                    search.setSearchKey(searchContent);
                }
                this.initCategoryFilterPanel();
                this.initMalFilterPanel(MALFILTERPANELKEY, String.valueOf(showParameterMap.get("source")));
                this.getPageCache().put(CACHE_MAL, showParameterMap.get("source") == null ? ALL : String.valueOf(showParameterMap.get("source")));
            }
            catch (UnsupportedEncodingException e1) {
                log.info(ExceptionUtil.getStackTrace((Throwable)e1));
            }
        }
    }

    private void initMalFilterPanel(String key, String initSource) {
        Container flexpanelap = (Container)this.getView().getControl(key);
        if (flexpanelap == null) {
            return;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        LabelAp labelAp = new LabelAp();
        for (ProductSourceEnum source : ProductSourceEnum.values()) {
            if ("0".equals(source.getVal())) continue;
            labelAp.setClickable(true);
            labelAp.setKey("mal_" + source.getVal());
            labelAp.setId("mal_" + source.getVal());
            if (StringUtils.equalsIgnoreCase((CharSequence)source.getVal(), (CharSequence)initSource)) {
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)FILTERMALALL, (String)"", (String)"");
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)("mal_" + initSource), (String)"#FFFFFF", (String)"#FC8555");
            }
            labelAp.setName(new LocaleString(source.getName()));
            labelAp.setFontSize(12);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("20px");
            style.setMargin(margin);
            Padding padding = new Padding();
            padding.setBottom("3px");
            padding.setLeft("3px");
            padding.setRight("3px");
            padding.setTop("3px");
            style.setPadding(padding);
            labelAp.setStyle(style);
            list.add(labelAp.createControl());
        }
        flexpanelap.addControls(list);
    }

    private void initCategoryFilterPanel() {
        this.getPageCache().get(CACHE_PRODUCTLIST);
        List productList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
        this.createLabelAp(productList, CATEGORYFILTERCONTAINERKEY, false);
        this.getView().updateView(CATEGORYFILTERCONTAINERKEY);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().split("_").length > 1 && (StringUtils.equals((CharSequence)PREFIXCATEGORYLB, (CharSequence)e.getKey().split("_")[0]) || StringUtils.equals((CharSequence)PREFIXMALLB, (CharSequence)e.getKey().split("_")[0]))) {
            Label label = new Label();
            label.setKey(e.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    public int refreshSearchData(String searchContent, List<String> searchFields) {
        int size = 0;
        if (StringUtils.isNotEmpty((CharSequence)searchContent) && searchFields != null && searchFields.size() > 0) {
            List productList;
            this.getModel().beginInit();
            this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
            if (this.getView().getFormShowParameter().getCustomParam(SELECTBYSTRATEGY) != null) {
                switch (this.getView().getFormShowParameter().getCustomParam(SELECTBYSTRATEGY).toString()) {
                    case "new": {
                        SelectByNewStrategy selectByNewStrategy = new SelectByNewStrategy();
                        productList = selectByNewStrategy.loadGoods(-1, "");
                        break;
                    }
                    case "sales": {
                        SelectBySalesStrategy selectBySalesStrategy = new SelectBySalesStrategy();
                        productList = selectBySalesStrategy.loadGoods(-1, "");
                        break;
                    }
                    default: {
                        productList = MalSearchUtils.search((String)searchContent, searchFields);
                        break;
                    }
                }
            } else {
                productList = MalSearchUtils.search((String)searchContent, searchFields);
            }
            MainPageUtils.isPriceDown((List)productList);
            String productStr = SerializationUtils.toJsonString((Object)productList);
            this.getPageCache().put(CACHE_PRODUCTLIST, productStr);
            this.showSearchList(productList);
            Map<String, String> cacheMap = this.getFilterCache();
            size = productList.size();
            this.getModel().endInit();
            this.getView().updateView(SEARCH_ENTRYENTITY);
            this.getPageCache().put(CACHE_PRODUCTLIST, productStr);
            this.recache(cacheMap);
        }
        return size;
    }

    private int refreshSearchData(String searchContent, List<String> searchFields, String source, String orderBys, boolean isOnlyShowQysp, QFilter ... priceRangeFilter) {
        int size = 0;
        if (StringUtils.isNotEmpty((CharSequence)searchContent) && searchFields != null && searchFields.size() > 0) {
            this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
            List productList = new ArrayList();
            if (source.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                productList = MalSearchUtils.searchFromSelfByKey((String)searchContent, searchFields, (String)orderBys, (boolean)isOnlyShowQysp, (QFilter[])priceRangeFilter);
            } else if (source.equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                productList = MalSearchUtils.searchFromJDByKey((String)searchContent, searchFields);
            }
            this.showSearchList(productList);
            size = productList.size();
            MainPageUtils.isPriceDown(productList);
            this.getPageCache().put(CACHE_PRODUCTLIST, SerializationUtils.toJsonString(productList));
            this.getView().updateView();
            MainPageUtils.isPriceDown(productList);
            this.getPageCache().put(CACHE_PRODUCTLIST, SerializationUtils.toJsonString(productList));
        }
        return size;
    }

    private void showSearchList(List<GoodsInfo> productList) {
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        CardEntry cardEntry = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
        for (int i = 0; i < productList.size(); ++i) {
            vs.set(SEARCH_IMG, (Object)productList.get(i).getProductImgPath(), i);
            vs.set(SEARCH_PRICE, (Object)productList.get(i).getShopPrice(), i);
            vs.set(PRODUCT_SOURCE, (Object)productList.get(i).getProductSource(), i);
            vs.set(PRODUCT_SUPPLIER, (Object)productList.get(i).getSupplier(), i);
            vs.set(SEARCH_NAME, (Object)(productList.get(i).getProductName() + "\t" + productList.get(i).getProductModel()), i);
            vs.set(SEARCH_PK, (Object)productList.get(i).getProductId(), i);
            cardEntry.setChildVisible(false, i, new String[]{"pricedown"});
            cardEntry.setChildVisible(false, i, new String[]{"qysp"});
            if ("1".equals(productList.get(i).getCentralpurtype()) && this.getView().getControl("qysp") != null) {
                vs.set("qysp", (Object)ResManager.loadKDString((String)"\u7b7e\u7ea6\u5546\u54c1", (String)"MalSearchListPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                cardEntry.setChildVisible(true, i, new String[]{"qysp"});
            }
            if (!productList.get(i).isPriceDown()) continue;
            vs.set("pricedown", (Object)ResManager.loadKDString((String)"\u964d\u4ef7", (String)"MalSearchListPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
            cardEntry.setChildVisible(true, i, new String[]{"pricedown"});
        }
        model.batchCreateNewEntryRow(SEARCH_ENTRYENTITY, vs);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        entryGrid.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
        this.getModel().endInit();
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        CardEntry cardEntry = (CardEntry)arg0.getSource();
        FormDataModel model = (FormDataModel)cardEntry.getModel();
        String productId = (String)model.getValue(SEARCH_PK);
        String source = (String)model.getValue(PRODUCT_SOURCE);
        MainPageUtils.showDetailPage((IFormView)this.getView(), (String)productId, (String)source, (String)((String)model.getValue(SEARCH_NAME)), (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        if (StringUtils.equals((CharSequence)SEARCHAP, (CharSequence)search.getKey())) {
            List searchFields = arg0.getFieldNames();
            String searchText = arg0.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                int size = this.refreshSearchData(searchText, searchFields);
                this.setFilterPanelSizeLabel(size);
                if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_OLDCAT))) {
                    Container flexpanel = (Container)this.getView().getControl(CATEGORYFILTERCONTAINERKEY);
                    flexpanel.deleteControls(this.getPageCache().get(CACHE_OLDCAT).split("%"));
                    this.getPageCache().put(CACHE_OLDCAT, "");
                    this.getView().updateView(CATEGORYFILTERCONTAINERKEY);
                }
                this.getPageCache().put(CACHE_MAL, ALL);
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)FILTERMALALL, (String)"#FFFFFF", (String)"#FC8555");
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)("mal_" + ProductSourceEnum.PRODUCTSOURCE_SELF.getVal()), (String)"", (String)"");
                StyleUtil.setControlerColor((IFormView)this.getView(), (String)("mal_" + ProductSourceEnum.PRODUCTSOURCE_JD.getVal()), (String)"", (String)"");
                this.initCategoryFilterPanel();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "addattention": {
                break;
            }
            case "addcart": {
                this.addToCart();
                break;
            }
            case "entercart": {
                this.showCart();
                break;
            }
            case "enterorder": {
                this.showOrder();
                break;
            }
            case "add2oftenbuy": {
                int[] selectIndexs = this.getSelectIndex();
                String pk = (String)this.getModel().getValue(SEARCH_PK, selectIndexs[0]);
                String goodsource = (String)this.getModel().getValue(PRODUCT_SOURCE, selectIndexs[0]);
                if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(goodsource)) {
                    MalAdd2OftenbuyUtil.add2OftenbuyFromSelf(pk, this.getView());
                    break;
                }
                if (!EcPlatformEnum.ECPLATFORM_JD.getName().equals(goodsource) && !EcPlatformEnum.ECPLATFORM_SUNING.getName().equals(goodsource) && !EcPlatformEnum.ECPLATFORM_DL.getName().equals(goodsource)) break;
                HashMap<String, String> oftenbuyMap = new HashMap<String, String>(1);
                oftenbuyMap.put("often_goods", pk);
                GoodsInfo jdProdDetail = JdApiUtil.getJdProdDetail((String)pk, (boolean)false);
                oftenbuyMap.put("often_name", jdProdDetail.getProductName());
                oftenbuyMap.put("often_pic", jdProdDetail.getProductImgPath());
                MalAdd2OftenbuyUtil.add2OftenbuyFromJD(oftenbuyMap, this.getView());
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)MYORDER_FLEX, (CharSequence)source.getKey())) {
            this.showOrder();
        }
        if (StringUtils.equals((CharSequence)MYCART_FLEX, (CharSequence)source.getKey())) {
            this.showCart();
        }
    }

    private void showOrder() {
        MainPageUtils.jumpToOrder((IFormView)this.getView(), (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
    }

    private void showCart() {
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_shopcart", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, null), (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter())));
    }

    private void addToCart() {
        String source;
        int[] selectedIndexs = this.getSelectIndex();
        DynamicObject selectDObject = this.getSelectedDyObject(selectedIndexs);
        String pk = String.valueOf(selectDObject.getString(SEARCH_PK));
        boolean isAddSuccess = MalAddToCartHelper.addCart((String)pk, (String)(source = String.valueOf(selectDObject.getString(PRODUCT_SOURCE))));
        if (isAddSuccess) {
            this.updateCartNo();
            String msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalSearchListPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
        } else {
            String msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25\uff0c\u5546\u54c1\u5df2\u4e0b\u67b6\u3002", (String)"MalSearchListPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
        }
    }

    protected void updateCartNo() {
        Label cartNo = (Label)this.getControl(CART_NO);
        int currNo = MalProductUtil.getCartNumber();
        cartNo.setText(String.valueOf(currNo));
    }

    protected int[] getSelectIndex() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        return grid.getEntryState().getSelectedRows();
    }

    protected DynamicObject getSelectedDyObject(int[] selectedIndexs) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        IDataModel gridModel = grid.getModel();
        String entryKey = grid.getKey();
        DynamicObject entryObject = gridModel.getEntryRowEntity(entryKey, selectedIndexs[0]);
        return entryObject;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (CBQYSP.equals(e.getProperty().getName())) {
            List<GoodsInfo> productList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PRODUCTLIST), GoodsInfo.class);
            productList = this.goodsFilterByMalFromCache(productList);
            productList = this.goodsFilterByCategoryFromCache(productList);
            productList = this.goodsShoppriceFilterFromCache(productList);
            productList = this.goodsSortByShopPriceFromCache(productList);
            ChangeData[] changeData = e.getChangeSet();
            productList = this.goodsQyspFilter(productList, (Boolean)changeData[0].getNewValue());
            this.setFilterPanelSizeLabel(productList.size());
            Map<String, String> filterMap = this.getFilterCache();
            this.refreshData(productList);
            this.recache(filterMap);
            String isQysp = "";
            isQysp = (Boolean)changeData[0].getNewValue() != false ? "1" : "0";
            this.getPageCache().put(CACHE_ISQYSP, isQysp);
        }
    }

    private Map<String, String> getFilterCache() {
        HashMap<String, String> map = new HashMap<String, String>();
        IPageCache cache = this.getPageCache();
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_ISQYSP))) {
            map.put(CACHE_ISQYSP, cache.get(CACHE_ISQYSP));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_STARTPRICE))) {
            map.put(CACHE_STARTPRICE, cache.get(CACHE_STARTPRICE));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_ENDPRICE))) {
            map.put(CACHE_ENDPRICE, cache.get(CACHE_ENDPRICE));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_PRODUCTLIST))) {
            map.put(CACHE_PRODUCTLIST, cache.get(CACHE_PRODUCTLIST));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_SEARCHCONTENT))) {
            map.put(CACHE_SEARCHCONTENT, cache.get(CACHE_SEARCHCONTENT));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_SEARCHFIELDSTR))) {
            map.put(CACHE_SEARCHFIELDSTR, cache.get(CACHE_SEARCHFIELDSTR));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_CATEGORY))) {
            map.put(CACHE_CATEGORY, cache.get(CACHE_CATEGORY));
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.get(CACHE_MAL))) {
            map.put(CACHE_MAL, cache.get(CACHE_MAL));
        }
        return map;
    }

    protected void recache(Map<String, String> filterMap) {
        for (Map.Entry<String, String> entry : filterMap.entrySet()) {
            this.getPageCache().put(entry.getKey(), entry.getValue());
        }
    }

    public void setFilterPanelSizeLabel(int size) {
        Label labelNum = (Label)this.getView().getControl(LABELNUM);
        if (labelNum != null) {
            labelNum.setText(size + "");
        }
    }

    public void createLabelAp(List<GoodsInfo> goodsInfos, String containerKey, boolean distinctByNumber) {
        log.info("@@goodsInfos\uff1a" + JSONArray.fromObject(goodsInfos));
        Container flexpanelap = (Container)this.getControl(containerKey);
        if (flexpanelap == null) {
            return;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        HashSet<String> distinctSet = new HashSet<String>();
        LabelAp labelAp = new LabelAp();
        Map cacheTempMap = this.getPageCache().getAll();
        for (GoodsInfo goodsInfo : goodsInfos) {
            String distinctStr = "";
            if (goodsInfo == null || "null".equals(goodsInfo.getCategoryName())) continue;
            if (distinctByNumber) {
                distinctSet.add(goodsInfo.getProductName());
                distinctStr = goodsInfo.getCategoryNumber();
            } else {
                distinctSet.add(goodsInfo.getCategoryNumber());
                distinctStr = goodsInfo.getCategoryName();
            }
            if (!distinctSet.add(distinctStr)) continue;
            labelAp.setClickable(true);
            labelAp.setKey("filterpanel_" + goodsInfo.getCategoryNumber().toLowerCase());
            labelAp.setId(goodsInfo.getCategoryNumber());
            labelAp.setName(new LocaleString(goodsInfo.getCategoryName()));
            labelAp.setFontSize(12);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("20px");
            style.setMargin(margin);
            Padding padding = new Padding();
            padding.setBottom("3px");
            padding.setLeft("3px");
            padding.setRight("3px");
            padding.setTop("3px");
            style.setPadding(padding);
            labelAp.setStyle(style);
            list.add(labelAp.createControl());
            String catCache = (String)cacheTempMap.get(CACHE_OLDCAT);
            if (StringUtils.isNotEmpty((CharSequence)catCache)) {
                String[] cats = catCache.split("%");
                boolean isCache = true;
                for (String cat : cats) {
                    String curCat = "filterpanel_" + goodsInfo.getCategoryNumber().toLowerCase();
                    if (!curCat.equals(cat)) continue;
                    isCache = false;
                }
                if (!isCache) continue;
                catCache = catCache + "%filterpanel_" + goodsInfo.getCategoryNumber().toLowerCase();
                cacheTempMap.put(CACHE_OLDCAT, catCache);
                continue;
            }
            cacheTempMap.put(CACHE_OLDCAT, "filterpanel_" + goodsInfo.getCategoryNumber().toLowerCase());
        }
        this.getPageCache().put(cacheTempMap);
        flexpanelap.addControls(list);
    }
}

