/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.IFormController;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.addcart.MalAddToCartHelper;
import kd.scm.mal.common.search.MalSearchModel;
import kd.scm.mal.common.util.MalNewSearchUtils;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalGoodsConverter;
import kd.scm.mal.domain.model.goods.MalGoodsSelectStrategyParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.model.recommend.SearchParam;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalGoodsSelectService;
import kd.scm.mal.domain.service.MalSearchService;
import kd.scm.mal.formplugin.MalPickGoodsPlugin;
import kd.scm.mal.formplugin.util.MalAddToOftenBuyUtil;
import kd.scm.mal.formplugin.util.MalProductDetailUtil;
import kd.scm.mal.formplugin.util.MalProductUtil;
import kd.scm.mal.formplugin.util.MalShopCartUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class MalSearchNewListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(MalSearchNewListPlugin.class);
    private static final String SEARCHFIELDS = "searchFields";
    private static final String SEARCH_ENTRYENTITY = "search_entryentity";
    private static final String SEARCH_IMG = "searchgoods_img";
    private static final String SEARCH_PRICE = "searchgoods_price";
    private static final String SEARCH_NAME = "searchgoods_name";
    private static final String PRODUCT_SOURCE = "productgoods_source";
    private static final String PRODUCT_SUPPLIER = "supplier";
    private static final String MAL_NEWPRODUCTDETAIL = "mal_newproductdetail";
    private static final String SEARCH_PK = "searchgoods_pk";
    private static final String SEARCH_SKU = "searchgoods_sku";
    private static final String CART_NO = "cartno";
    private static final String CACHE_CATEGORY_MORE = "CACHE_CATEGORY_MORE";
    private static final String CACHE_BRAND_MORE = "CACHE_BRAND_MORE";
    private static final String BUTTON_DEFAULT = "btncomplex";
    private static final String BUTTON_PRICE = "btnprice";
    private static final String BUTTON_SALES = "btnsales";
    private static final String BUTTON_PRICE_RANGE = "btnconfirm";
    private static final String CATEGORY_FILTER_CONTAINER = "categoryfiltercontainer";
    private static final String BRAND_FILTER_CONTAINER = "brandfiltercontainer";
    private static final String SOURCE_FILTER_CONTAINER = "sourcefiltercontainer";
    private static final String REFRESH_COMPARE = "refresh_compare";
    private static final String SOURCE_FILTER_PREFIX = "sourcefilter";
    private static final String CATEGORY_FILTER_PREFIX = "categoryfilter";
    private static final String BRAND_FILTER_PREFIX = "brandfilter";
    private static final String CATEGORY_FILTER_ALL = "categoryfilter_all";
    private static final String BRAND_FILTER_ALL = "brandfilter_all";
    private static final String SOURCE_FILTER_ALL = "sourcefilter_all";
    private static final String ALL = "all";
    private static final String SELECTBYSTRATEGY = "strategy";
    private static final String CHECKBOX_QYSP = "cbqysp";
    private static final String LABELNUM = "labelnum";
    private static final String CB_COMPARE = "cb_compare";
    private static final String COMPARE_NUM = "compare_num";
    private static final String COMPARE_CLEAR = "compare_clear";
    private static final String CARD_IMG_CONTENT = "card_img_content";
    private static final String COMPARE_ENTRYENTITY = "compare_entryentity";
    private static final String FOLD = "fold";
    private static final String UNFOLD = "unfold";
    private static final String ISFOLD = "isfold";
    private static final String DESC_SPRILT = "\uff1a";
    private static final String SPLIT = "_";
    private static final String SELECTED_SOURCE = "selected_source";
    private static final String SELECTED_CATEGORY = "selected_category";
    private static final String SELECTED_BRAND = "selected_brand";
    private static final String UPDATE_COMPARE_CHECKSTATUS = "update_compare_checkstatus";

    private MalSearchModel getSearchModel() {
        String searchModelStr = this.getPageCache().get(this.getView().getPageId());
        if (StringUtils.isNotEmpty((CharSequence)searchModelStr)) {
            return (MalSearchModel)JSON.parseObject((String)searchModelStr, MalSearchModel.class);
        }
        return new MalSearchModel();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        MalSearchModel malSearchModel = this.getSearchModel();
        List productList = malSearchModel.filterAndSortBySelected(malSearchModel.getProductList());
        CardEntry cardEntry = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
        int index = 0;
        for (int i = e.getStartIndex(); i < productList.size() && index < e.getRows().size(); ++index, ++i) {
            cardEntry.setChildVisible(false, index, new String[]{"pricedown"});
            cardEntry.setChildVisible(false, index, new String[]{"qysp"});
            if ("1".equals(((GoodsInfo)productList.get(i)).getCentralpurtype()) && this.getView().getControl("qysp") != null) {
                cardEntry.setChildVisible(true, index, new String[]{"qysp"});
            }
            if (!((GoodsInfo)productList.get(i)).isPriceDown()) continue;
            cardEntry.setChildVisible(true, index, new String[]{"pricedown"});
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        Label labelBrand;
        Label labelSourceAll;
        Label labelCategory;
        Button btnconfirm;
        Button btnsales;
        Button btnprice;
        Button btncomplex;
        Container brandContainer;
        CardEntry grid = (CardEntry)this.getView().getControl(SEARCH_ENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        grid.addDataBindListener((EntryGridBindDataListener)this);
        grid.addRowClickListener((RowClickEventListener)this);
        Container imgContainer = (Container)this.getControl(CARD_IMG_CONTENT);
        imgContainer.addClickListener((ClickListener)this);
        Container categoryContainer = (Container)this.getControl("categorymoreflex");
        if (Objects.nonNull(categoryContainer)) {
            categoryContainer.addClickListener((ClickListener)this);
        }
        if (Objects.nonNull(brandContainer = (Container)this.getControl("brandmoreflex"))) {
            brandContainer.addClickListener((ClickListener)this);
        }
        if ((btncomplex = (Button)this.getView().getControl(BUTTON_DEFAULT)) != null) {
            btncomplex.addClickListener((ClickListener)this);
        }
        if ((btnprice = (Button)this.getView().getControl(BUTTON_PRICE)) != null) {
            btnprice.addClickListener((ClickListener)this);
        }
        if ((btnsales = (Button)this.getView().getControl(BUTTON_SALES)) != null) {
            btnsales.addClickListener((ClickListener)this);
        }
        if ((btnconfirm = (Button)this.getView().getControl(BUTTON_PRICE_RANGE)) != null) {
            btnconfirm.addClickListener((ClickListener)this);
        }
        if ((labelCategory = (Label)this.getView().getControl(CATEGORY_FILTER_ALL)) != null) {
            labelCategory.addClickListener((ClickListener)this);
        }
        if ((labelSourceAll = (Label)this.getView().getControl(SOURCE_FILTER_ALL)) != null) {
            labelSourceAll.addClickListener((ClickListener)this);
        }
        if ((labelBrand = (Label)this.getView().getControl(BRAND_FILTER_ALL)) != null) {
            labelBrand.addClickListener((ClickListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl(COMPARE_ENTRYENTITY)) != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.updateCartNo();
    }

    public void click(EventObject evt) {
        Container container = null;
        Button btn = null;
        if (evt.getSource() instanceof Container) {
            container = (Container)evt.getSource();
        }
        if (evt.getSource() instanceof Button) {
            btn = (Button)evt.getSource();
        }
        MalSearchModel malSearchModel = this.getSearchModel();
        List productList = malSearchModel.getProductList();
        if (container != null && StringUtils.equals((CharSequence)CARD_IMG_CONTENT, (CharSequence)container.getKey())) {
            this.showProdDetail(container.getModel());
        }
        if (btn != null && StringUtils.equals((CharSequence)BUTTON_DEFAULT, (CharSequence)btn.getKey())) {
            this.setFilterPanelSizeLabel(productList.size());
            malSearchModel.changeSortText(MalSearchModel.DEFALUT);
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            this.clikStyleChange(BUTTON_PRICE, false, MalSearchModel.PRICE);
            this.clikStyleChange(BUTTON_DEFAULT, true, null);
            this.clikStyleChange(BUTTON_SALES, false, MalSearchModel.SALES);
        }
        if (btn != null && StringUtils.equals((CharSequence)BUTTON_PRICE, (CharSequence)btn.getKey())) {
            malSearchModel.changeSortText(malSearchModel.getPriceSortText());
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            this.clikStyleChange(BUTTON_PRICE, true, malSearchModel.getPriceSortText());
            this.clikStyleChange(BUTTON_DEFAULT, false, null);
            this.clikStyleChange(BUTTON_SALES, false, MalSearchModel.SALES);
        }
        if (btn != null && StringUtils.equals((CharSequence)BUTTON_SALES, (CharSequence)btn.getKey())) {
            malSearchModel.changeSortText(malSearchModel.getSalesSortText());
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.setFilterPanelSizeLabel(productList.size());
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            this.clikStyleChange(BUTTON_PRICE, false, MalSearchModel.PRICE);
            this.clikStyleChange(BUTTON_DEFAULT, false, null);
            this.clikStyleChange(BUTTON_SALES, true, malSearchModel.getSalesSortText());
        }
        if (btn != null && StringUtils.equals((CharSequence)BUTTON_PRICE_RANGE, (CharSequence)btn.getKey())) {
            malSearchModel.setStartPrice((BigDecimal)this.getModel().getValue("textfieldprice0"));
            malSearchModel.setEndPrice((BigDecimal)this.getModel().getValue("textfieldprice1"));
            productList = malSearchModel.filterAndSortBySelected(malSearchModel.getProductList());
            this.setFilterPanelSizeLabel(productList.size());
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
        }
        if (btn != null && btn.getKey() != null && btn.getKey().split(SPLIT).length > 1 && StringUtils.equals((CharSequence)CATEGORY_FILTER_PREFIX, (CharSequence)btn.getKey().split(SPLIT)[0])) {
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u5206\u7c7b\u70b9\u51fb\u4e8b\u4ef6\u5f00\u59cb------------");
            log.info("@@btn.getKey()\uff1a" + btn.getKey());
            String[] categorys = btn.getKey().split(SPLIT);
            String categoryStr = categorys.length > 2 ? categorys[1] + SPLIT + categorys[2] : categorys[1];
            String category = StringUtils.isEmpty((CharSequence)categoryStr) || categoryStr.equalsIgnoreCase(ALL) ? ALL : categoryStr;
            String lastCategory = malSearchModel.getSelectedCategory();
            malSearchModel.setSelectedCategory(category);
            malSearchModel.filterAndSortBySelected(productList);
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.setFilterPanelSizeLabel(productList.size());
            if (ALL.equals(lastCategory)) {
                this.setClickingStyle(CATEGORY_FILTER_ALL, false);
            } else if (!StringUtils.isEmpty((CharSequence)lastCategory) && !StringUtils.equals((CharSequence)categoryStr, (CharSequence)lastCategory)) {
                this.setClickingStyle("categoryfilter_" + lastCategory, false);
            }
            this.setClickingStyle(btn.getKey(), true);
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            log.info("@@\u6700\u540e\u7684productlist:" + productList.size());
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u5206\u7c7b\u70b9\u51fb\u4e8b\u4ef6\u7ed3\u675f------------");
        }
        if (btn != null && btn.getKey() != null && btn.getKey().split(SPLIT).length > 1 && StringUtils.equals((CharSequence)SOURCE_FILTER_PREFIX, (CharSequence)btn.getKey().split(SPLIT)[0])) {
            String source = btn.getKey().split(SPLIT)[1];
            String lastSource = malSearchModel.getSelectedSource();
            malSearchModel.setSelectedSource(source);
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.setFilterPanelSizeLabel(productList.size());
            if (StringUtils.isEmpty((CharSequence)lastSource) || lastSource.equalsIgnoreCase(ALL)) {
                this.setClickingStyle(SOURCE_FILTER_ALL, false);
            } else if (null == source || !StringUtils.isEmpty((CharSequence)lastSource) && !StringUtils.equals((CharSequence)source, (CharSequence)lastSource)) {
                this.setClickingStyle("sourcefilter_" + lastSource, false);
            }
            this.setClickingStyle(btn.getKey(), true);
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            this.clikStyleChange(BUTTON_PRICE, false, null);
            this.clikStyleChange(BUTTON_DEFAULT, true, null);
            this.clikStyleChange(BUTTON_SALES, false, null);
        }
        if (btn != null && btn.getKey() != null && btn.getKey().split(SPLIT).length > 1 && StringUtils.equals((CharSequence)BRAND_FILTER_PREFIX, (CharSequence)btn.getKey().split(SPLIT)[0])) {
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u54c1\u724c\u70b9\u51fb\u4e8b\u4ef6\u5f00\u59cb------------");
            log.info("@@btn.getKey()\uff1a" + btn.getKey());
            String[] brands = btn.getKey().split(SPLIT);
            String brandStr = brands.length > 2 ? brands[1] + SPLIT + brands[2] : brands[1];
            String brand = StringUtils.isEmpty((CharSequence)brandStr) || brandStr.equalsIgnoreCase(ALL) ? ALL : brandStr;
            String lastBrand = malSearchModel.getSelectedBrand();
            malSearchModel.setSelectedBrand(brand);
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.setFilterPanelSizeLabel(productList.size());
            if (StringUtils.isEmpty((CharSequence)lastBrand) || lastBrand.equalsIgnoreCase(ALL)) {
                this.setClickingStyle(BRAND_FILTER_ALL, false);
            } else if (!StringUtils.isEmpty((CharSequence)lastBrand) && !StringUtils.equals((CharSequence)brandStr, (CharSequence)lastBrand)) {
                this.setClickingStyle("brandfilter_" + lastBrand, false);
            }
            this.setClickingStyle(btn.getKey(), true);
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
            log.info("@@\u6700\u540e\u7684productlist:" + productList.size());
            log.info("@@\u8fc7\u6ee4\u9762\u677f\u54c1\u724c\u70b9\u51fb\u4e8b\u4ef6\u7ed3\u675f------------");
        }
    }

    private void showProdDetail(IDataModel model) {
        String productId = String.valueOf(model.getValue(SEARCH_PK));
        String sourceFrom = String.valueOf(model.getValue(PRODUCT_SOURCE));
        String origin = (String)this.getView().getFormShowParameter().getCustomParam("origin");
        CloseCallBack closeCallBack = null;
        ShowType showType = ShowType.NewWindow;
        String caption = String.valueOf(model.getValue(SEARCH_NAME));
        if ("mal_pickgoods".equals(this.getView().getEntityId())) {
            origin = this.getView().getEntityId();
            closeCallBack = new CloseCallBack((IFormPlugin)new MalPickGoodsPlugin(), "mal_pickgoods");
            showType = ShowType.Modal;
            caption = "";
        }
        this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)productId, (String)String.valueOf(model.getValue(SEARCH_SKU)), (String)sourceFrom, (String)caption, (String)origin, (ShowType)showType, null, (CloseCallBack)closeCallBack));
    }

    private void updateSearchModel(MalSearchModel malSearchModel) {
        this.getPageCache().put(this.getView().getPageId(), JSON.toJSONString((Object)malSearchModel));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (COMPARE_CLEAR.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateCompareCheckStatus();
        }
        if (FOLD.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getModel().setValue(ISFOLD, (Object)Boolean.TRUE);
            this.showSelectedFilter();
        }
        if (UNFOLD.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getModel().setValue(ISFOLD, (Object)Boolean.FALSE);
        }
        if (UPDATE_COMPARE_CHECKSTATUS.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateCompareCheckStatus();
        }
    }

    private void showSelectedFilter() {
        MalSearchModel searchModel = this.getSearchModel();
        String descSource = (String)searchModel.getSourceTagsMap().get("sourcefilter_" + searchModel.getSelectedSource());
        this.getModel().setValue(SELECTED_SOURCE, (Object)(MalSearchNewListPlugin.descSource() + DESC_SPRILT + (StringUtils.isEmpty((CharSequence)descSource) ? MalSearchNewListPlugin.descAll() : descSource)));
        String descCategory = (String)searchModel.getCategoryTagsMap().get("categoryfilter_" + searchModel.getSelectedCategory());
        this.getModel().setValue(SELECTED_CATEGORY, (Object)(MalSearchNewListPlugin.descCategory() + DESC_SPRILT + (StringUtils.isEmpty((CharSequence)descCategory) ? MalSearchNewListPlugin.descAll() : descCategory)));
        String descBrand = (String)searchModel.getBrandTagsMap().get("brandfilter_" + searchModel.getSelectedBrand());
        this.getModel().setValue(SELECTED_BRAND, (Object)(MalSearchNewListPlugin.descBrand() + DESC_SPRILT + (StringUtils.isEmpty((CharSequence)descBrand) ? MalSearchNewListPlugin.descAll() : descBrand)));
    }

    private static String descAll() {
        return ResManager.loadKDString((String)"\u4e0d\u9650", (String)"MalSearchNewListPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String descSource() {
        return ResManager.loadKDString((String)"\u5546\u54c1\u6765\u6e90", (String)"MalSearchNewListPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String descCategory() {
        return ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"MalSearchNewListPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private static String descBrand() {
        return ResManager.loadKDString((String)"\u54c1\u724c", (String)"MalSearchNewListPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
    }

    private void updateCompareCheckStatus() {
        IFormController srv = (IFormController)this.getView().getService(IFormController.class);
        srv.registerListener();
        List malCompareRecords = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords();
        int row = this.getModel().getEntryRowCount(SEARCH_ENTRYENTITY);
        this.getModel().beginInit();
        boolean change = false;
        for (int i = 0; i < row; ++i) {
            boolean isCheck = (Boolean)this.getModel().getValue(CB_COMPARE, i);
            if (!isCheck) continue;
            Long goodsId = Long.valueOf((String)this.getModel().getValue(SEARCH_PK, i));
            if (!malCompareRecords.stream().noneMatch(malCompareRecord -> goodsId.equals(malCompareRecord.getGoodsId()))) continue;
            this.getModel().setValue(CB_COMPARE, (Object)Boolean.FALSE, i);
            change = true;
        }
        this.getModel().endInit();
        if (change) {
            this.getView().updateView(SEARCH_ENTRYENTITY);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (Stream.of(CARD_IMG_CONTENT, SEARCH_PRICE, SEARCH_NAME, PRODUCT_SUPPLIER).anyMatch(key -> key.equals(arg0.getFieldName()))) {
            CardEntry cardEntry = (CardEntry)arg0.getSource();
            this.showProdDetail(cardEntry.getModel());
        }
    }

    private void refreshData(List<GoodsInfo> productList) {
        this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
        this.showSearchList(productList);
        this.getView().updateView();
    }

    private void clikStyleChange(String key, boolean isClicking, String changeText) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        list.add(key);
        if (isClicking) {
            dataMap.put("fc", "#FFFFFF");
            dataMap.put("bc", "themeColor");
        } else {
            dataMap.put("fc", "themeColor");
            dataMap.put("bc", "");
        }
        if (changeText != null) {
            dataMap.put("text", (String)new LocaleString(changeText));
        }
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        this.initMalSearchModel();
        MalSearchModel malSearchModel = this.getSearchModel();
        if (ShowType.NewWindow == this.getView().getFormShowParameter().getOpenStyle().getShowType() || ShowType.InContainer == this.getView().getFormShowParameter().getOpenStyle().getShowType()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u5546\u57ce\u641c\u7d22", (String)"MalSearchNewListPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0])});
        }
        this.getPageCache().put("refreshSearch", "0");
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("currency", (Object)MalOrderUtil.getDefaultCurrency());
        }
        Label cartNo = (Label)this.getControl(CART_NO);
        int cartNumber = MalProductUtil.getCartNumber();
        if (cartNo != null) {
            cartNo.setText(String.valueOf(cartNumber));
        }
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        log.info("@@showParameterMap:" + showParameterMap);
        String searchContent = null;
        this.getModel().getEntryEntity(SEARCH_ENTRYENTITY);
        if (showParameterMap != null && (showParameterMap.containsKey("searchText") && showParameterMap.containsKey(SEARCHFIELDS) || null != this.getView().getFormShowParameter().getCustomParam(SELECTBYSTRATEGY) || null != showParameterMap.get("searchParam"))) {
            if (null != showParameterMap.get("searchText")) {
                searchContent = showParameterMap.get("searchText").toString();
            }
            JSONArray searchFields = new ArrayList();
            try {
                if (null != showParameterMap.get("searchParam")) {
                    SearchParam searchParam = (SearchParam)SerializationUtils.fromJsonString((String)String.valueOf(showParameterMap.get("searchParam")), SearchParam.class);
                    this.queryRecommendData(searchParam);
                    return;
                }
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u4e2d", (String)"MalSearchNewListPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0])));
                if (null == showParameterMap.get("source") && StringUtils.isNotEmpty((CharSequence)searchContent)) {
                    if (showParameterMap.get(SEARCHFIELDS) instanceof String) {
                        searchContent = this.decode(searchContent, "UTF-8");
                        String searchFieldsStr = (String)showParameterMap.get(SEARCHFIELDS);
                        String decodeSearchFieldsStr = this.decode(searchFieldsStr, "UTF-8");
                        searchFields = JSONArray.fromObject((Object)decodeSearchFieldsStr);
                    } else if (null != showParameterMap.get(SEARCHFIELDS)) {
                        searchContent = this.decode(searchContent, "UTF-8");
                        searchFields = JSONArray.fromObject(showParameterMap.get(SEARCHFIELDS));
                    }
                } else {
                    searchContent = this.decode(searchContent, "UTF-8");
                }
                if (null != searchContent) {
                    searchContent = searchContent.trim();
                }
                malSearchModel.setSearchText(searchContent);
                malSearchModel.setSearchFields(searchFields);
                int size = 0;
                if (null != showParameterMap.get("source")) {
                    ArrayList<String> categoryLongNumnberList = new ArrayList<String>(10);
                    malSearchModel.setSearchType("3");
                    String longNumber = this.decode((String)showParameterMap.get(SEARCHFIELDS), "UTF-8");
                    String level = (String)showParameterMap.get("level");
                    if (StringUtils.isBlank((CharSequence)level)) {
                        level = "1";
                    }
                    if (!StringUtils.isNumeric((CharSequence)level)) {
                        this.setFilterPanelSizeLabel(0);
                        return;
                    }
                    if (Integer.parseInt(level) < 3) {
                        categoryLongNumnberList = MalProductDetailUtil.getLongNumber(showParameterMap.get("source").toString(), level, longNumber);
                    } else {
                        categoryLongNumnberList.add(longNumber);
                    }
                    this.updateSearchModel(malSearchModel);
                    size = this.refreshSearchData(searchContent, (List<String>)searchFields, showParameterMap.get("source"), categoryLongNumnberList);
                } else if (this.getView().getFormShowParameter().getCustomParam(SELECTBYSTRATEGY) != null) {
                    malSearchModel.setSearchType("2");
                    MalGoodsSelectService malGoodsSelectService = (MalGoodsSelectService)DomainServiceFactory.serviceOf(MalGoodsSelectService.class, (String)((String)this.getView().getFormShowParameter().getCustomParam(SELECTBYSTRATEGY)));
                    if (malGoodsSelectService != null) {
                        List productList = MalGoodsConverter.convert2GoodsInfoByGoodsIds((List)malGoodsSelectService.loadMalGoods(new MalGoodsSelectStrategyParam((String)this.getView().getFormShowParameter().getCustomParam("platform"), -1, "", Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("promotionId")), "pmm_promotion")));
                        this.updateSearchModel(malSearchModel);
                        size = this.refreshSearchData(productList);
                    }
                } else {
                    malSearchModel.setSearchType("1");
                    this.updateSearchModel(malSearchModel);
                    size = this.refreshSearchData(searchContent, (List<String>)searchFields, null, null);
                }
                this.setFilterPanelSizeLabel(size);
                this.initFilterPanel();
                this.setClickingStyle(SOURCE_FILTER_ALL, true);
                this.setClickingStyle(CATEGORY_FILTER_ALL, true);
                this.setClickingStyle(BRAND_FILTER_ALL, true);
            }
            catch (UnsupportedEncodingException e1) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e1));
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void initMalSearchModel() {
        MalSearchModel malSearchModel = new MalSearchModel();
        this.getPageCache().put(this.getView().getPageId(), JSON.toJSONString((Object)malSearchModel));
    }

    private String decode(String keyWords, String encode) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((CharSequence)keyWords)) {
            try {
                keyWords = URLDecoder.decode(keyWords, encode);
            }
            catch (IllegalArgumentException e) {
                log.warn("decode:" + keyWords + "\n" + e.getMessage(), (Throwable)e);
                keyWords = URLDecoder.decode(keyWords.replaceAll("%", "%25"), encode);
            }
        }
        return keyWords;
    }

    private void initFilterPanel() {
        try (TimeTracer t = new TimeTracer("initFilterPanel");){
            List productList = this.getSearchModel().getProductList();
            this.createSourceLabelAp(productList, SOURCE_FILTER_CONTAINER);
            this.getView().updateView(SOURCE_FILTER_CONTAINER);
            this.createCategoryLabelAp(productList, CATEGORY_FILTER_CONTAINER);
            this.getView().updateView(CATEGORY_FILTER_CONTAINER);
            this.createBrandLabelAp(productList, BRAND_FILTER_CONTAINER);
            this.getView().updateView(BRAND_FILTER_CONTAINER);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().split(SPLIT).length > 1 && (StringUtils.equals((CharSequence)CATEGORY_FILTER_PREFIX, (CharSequence)e.getKey().split(SPLIT)[0]) || StringUtils.equals((CharSequence)SOURCE_FILTER_PREFIX, (CharSequence)e.getKey().split(SPLIT)[0]) || StringUtils.equals((CharSequence)BRAND_FILTER_PREFIX, (CharSequence)e.getKey().split(SPLIT)[0]))) {
            Label label = new Label();
            label.setKey(e.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    private void queryRecommendData(SearchParam searchParam) {
        MalSearchService malSearchService = (MalSearchService)DomainServiceFactory.serviceOf(MalSearchService.class);
        List productList = malSearchService.searchGoods(searchParam);
        List filterProductList = productList.stream().filter(item -> !item.getProductId().equals(searchParam.getProductId())).collect(Collectors.toList());
        List res = MalNewSearchUtils.getSales(filterProductList);
        Comparator<GoodsInfo> bySales = Comparator.comparing(GoodsInfo::getSales).reversed();
        Comparator<GoodsInfo> byPrice = Comparator.comparing(GoodsInfo::getShopPrice);
        res.sort(bySales.thenComparing(byPrice));
        List<GoodsInfo> goodsInfoList = res.stream().limit(10L).collect(Collectors.toList());
        MalSearchModel malSearchModel = this.getSearchModel();
        malSearchModel.setProductList(goodsInfoList);
        this.updateSearchModel(malSearchModel);
        this.showSearchList(goodsInfoList);
    }

    private int refreshSearchData(String searchContent, List<String> searchFields, Object source, List<String> categoryLongNumnberList) {
        try (TimeTracer t = new TimeTracer("refreshSearchData1");){
            List productList;
            this.getModel().beginInit();
            try (TimeTracer t1 = new TimeTracer("refreshSearchData1-deleteEntryData");){
                this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
            }
            var10_8 = null;
            try (TimeTracer t2 = new TimeTracer("refreshSearchData1-search");){
                productList = MalNewSearchUtils.search((String)searchContent, searchFields, (Object)source, categoryLongNumnberList);
            }
            catch (Throwable throwable) {
                var10_8 = throwable;
                throw throwable;
            }
            MalSearchModel malSearchModel = this.getSearchModel();
            malSearchModel.setProductList(productList);
            this.updateSearchModel(malSearchModel);
            try (TimeTracer t4 = new TimeTracer("refreshSearchData1-showSearchList");){
                this.showSearchList(productList);
            }
            int size = productList.size();
            this.getModel().endInit();
            this.getView().updateView(SEARCH_ENTRYENTITY);
            int n = size;
            return n;
        }
    }

    private int refreshSearchData(List<GoodsInfo> productList) {
        try (TimeTracer t = new TimeTracer("refreshSearchData2");){
            this.getModel().beginInit();
            this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
            for (GoodsInfo goodsInfo : productList) {
                if (goodsInfo.getProductSource().equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SELF.getVal())) continue;
                goodsInfo.setCentralpurtype("1");
            }
            this.showSearchList(productList);
            int size = productList.size();
            this.getModel().endInit();
            this.getView().updateView(SEARCH_ENTRYENTITY);
            MalSearchModel malSearchModel = this.getSearchModel();
            malSearchModel.setProductList(productList);
            this.updateSearchModel(malSearchModel);
            int n = size;
            return n;
        }
    }

    private void showSearchList(List<GoodsInfo> productList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        CardEntry cardEntry = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
        List malCompareRecords = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords();
        for (int i = 0; i < productList.size(); ++i) {
            GoodsInfo goodsInfo = productList.get(i);
            vs.set(SEARCH_IMG, (Object)goodsInfo.getProductImgPath(), i);
            vs.set(SEARCH_PRICE, (Object)goodsInfo.getShopPrice(), i);
            vs.set(PRODUCT_SOURCE, (Object)goodsInfo.getProductSource(), i);
            vs.set(PRODUCT_SUPPLIER, (Object)goodsInfo.getSupplier(), i);
            vs.set(SEARCH_NAME, (Object)(goodsInfo.getProductName() + "\t" + goodsInfo.getProductModel()), i);
            vs.set(SEARCH_PK, (Object)goodsInfo.getProductId(), i);
            vs.set(SEARCH_SKU, (Object)goodsInfo.getProductNumber(), i);
            cardEntry.setChildVisible(false, i, new String[]{"pricedown"});
            cardEntry.setChildVisible(false, i, new String[]{"qysp"});
            if (this.getView().getControl("qysp") != null && ("1".equals(goodsInfo.getCentralpurtype()) || !goodsInfo.getProductSource().equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SELF.getVal()))) {
                vs.set("qysp", (Object)ResManager.loadKDString((String)"\u7b7e\u7ea6\u5546\u54c1", (String)"MalSearchNewListPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                cardEntry.setChildVisible(true, i, new String[]{"qysp"});
            }
            if (goodsInfo.isPriceDown()) {
                vs.set("pricedown", (Object)ResManager.loadKDString((String)"\u964d\u4ef7", (String)"MalSearchNewListPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                cardEntry.setChildVisible(true, i, new String[]{"pricedown"});
            }
            if (!malCompareRecords.stream().anyMatch(malCompareRecord -> StringUtils.equals((CharSequence)String.valueOf(malCompareRecord.getGoodsId()), (CharSequence)goodsInfo.getProductId()))) continue;
            vs.set(CB_COMPARE, (Object)Boolean.TRUE, i);
        }
        this.getModel().beginInit();
        model.batchCreateNewEntryRow(SEARCH_ENTRYENTITY, vs);
        this.getModel().endInit();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        entryGrid.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
    }

    private void updateCompareNum(int compareNum) {
        this.getModel().setValue(COMPARE_NUM, (Object)Math.max(compareNum, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customEvent(CustomEventArgs e) {
        String key;
        switch (key = e.getEventName()) {
            case "click": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u4e2d", (String)"MalSearchNewListPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0])));
                    this.resetSearch();
                    MalSearchModel malSearchModel = this.getSearchModel();
                    String eventArgs = e.getEventArgs();
                    JSONObject jo = JSONObject.fromObject((Object)eventArgs);
                    String select = jo.getString("select");
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(select);
                    String input = jo.getString("input");
                    input = URLDecoder.decode(input, "UTF-8");
                    input = input.trim();
                    malSearchModel.setSearchType("1");
                    malSearchModel.setSearchText(input);
                    malSearchModel.setSearchFields(list);
                    this.getModel().getDataEntity(true);
                    BigDecimal startPrice = (BigDecimal)this.getModel().getValue("textfieldprice0");
                    BigDecimal endPrice = (BigDecimal)this.getModel().getValue("textfieldprice1");
                    List result = BigDecimal.ZERO.compareTo(startPrice) != 0 || BigDecimal.ZERO.compareTo(endPrice) != 0 ? MalNewSearchUtils.searchMallGoods((String)input, list, (Float)Float.valueOf(startPrice.toPlainString()), (Float)Float.valueOf(endPrice.toPlainString()), null, null, (int)1, (int)1000) : MalNewSearchUtils.searchMallGoods((String)input, list, null, null, null, null, (int)1, (int)1000);
                    malSearchModel.setProductList(result);
                    this.showSearchList(malSearchModel.filterAndSortBySelected(result));
                    int size = result.size();
                    this.getModel().endInit();
                    this.getView().updateView(SEARCH_ENTRYENTITY);
                    this.setFilterPanelSizeLabel(size);
                    this.updateSearchModel(malSearchModel);
                    this.initFilterPanel();
                    break;
                }
                catch (Exception exception) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)exception));
                    break;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        }
    }

    protected void resetSearch() {
        Container flexpanel;
        MalSearchModel malSearchModel = this.getSearchModel();
        if (!malSearchModel.getCategoryTagsMap().isEmpty()) {
            flexpanel = (Container)this.getView().getControl(CATEGORY_FILTER_CONTAINER);
            flexpanel.deleteControls(malSearchModel.getCategoryTagsMap().keySet().toArray(new String[0]));
            malSearchModel.getCategoryTagsMap().clear();
            this.getView().updateView(CATEGORY_FILTER_CONTAINER);
        }
        if (!malSearchModel.getBrandTagsMap().isEmpty()) {
            flexpanel = (Container)this.getView().getControl(BRAND_FILTER_CONTAINER);
            flexpanel.deleteControls(malSearchModel.getBrandTagsMap().keySet().toArray(new String[0]));
            malSearchModel.getBrandTagsMap().clear();
            this.getView().updateView(BRAND_FILTER_CONTAINER);
        }
        if (!malSearchModel.getSourceTagsMap().isEmpty()) {
            flexpanel = (Container)this.getView().getControl(SOURCE_FILTER_CONTAINER);
            flexpanel.deleteControls(malSearchModel.getSourceTagsMap().keySet().toArray(new String[0]));
            malSearchModel.getSourceTagsMap().clear();
            this.getView().updateView(SOURCE_FILTER_CONTAINER);
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(SEARCH_ENTRYENTITY);
        this.getModel().endInit();
        this.setClickingStyle(CATEGORY_FILTER_ALL, true);
        this.setClickingStyle(SOURCE_FILTER_ALL, true);
        this.setClickingStyle(BRAND_FILTER_ALL, true);
        this.clikStyleChange(BUTTON_DEFAULT, true, null);
        this.clikStyleChange(BUTTON_PRICE, false, MalSearchModel.PRICE);
        this.clikStyleChange(BUTTON_SALES, false, MalSearchModel.SALES);
        this.updateSearchModel(new MalSearchModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        MalSearchModel malSearchModel = this.getSearchModel();
        switch (operateKey) {
            case "addattention": {
                break;
            }
            case "addcart": {
                this.checkStock();
                if (!MAL_NEWPRODUCTDETAIL.equals(this.getView().getFormShowParameter().getParentFormId())) break;
                this.getView().getParentView().invokeOperation("updateview");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "add2oftenbuy": {
                String msg;
                int[] selectIndexs = this.getSelectIndex();
                DynamicObject selectDObject = this.getSelectedDyObject(selectIndexs);
                String pk = (String)this.getModel().getValue(SEARCH_PK, selectIndexs[0]);
                String source = (String)this.getModel().getValue(PRODUCT_SOURCE, selectIndexs[0]);
                ArrayList<String> goodsIdList = new ArrayList<String>(1);
                goodsIdList.add(pk);
                boolean success = false;
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                    success = MalAddToOftenBuyUtil.add(goodsIdList);
                } else {
                    Map<String, BigDecimal> malPrice = MalShopCartUtil.getMalPrice(goodsIdList);
                    if (!malPrice.isEmpty()) {
                        success = MalAddToOftenBuyUtil.add(goodsIdList);
                    }
                }
                if (success) {
                    msg = ResManager.loadKDString((String)"\u52a0\u5165\u5e38\u4e70\u6210\u529f\u3002", (String)"MalSearchNewListPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
                    break;
                }
                msg = ResManager.loadKDString((String)"\u52a0\u5165\u5e38\u4e70\u5931\u8d25\u3002", (String)"MalSearchNewListPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
                break;
            }
            case "categorymore": {
                int lastCategoryMore = malSearchModel.getCategoryMore();
                List categoryMoreKeys = malSearchModel.getCategoryMoreKeys();
                if (lastCategoryMore == 0) {
                    this.getView().setVisible(Boolean.FALSE, categoryMoreKeys.toArray(new String[0]));
                    malSearchModel.setCategoryMore(1);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"categorycut"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"categorycuttap"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"categorymore"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"categorymoretap"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, categoryMoreKeys.toArray(new String[0]));
                malSearchModel.setCategoryMore(0);
                this.getView().setVisible(Boolean.TRUE, new String[]{"categorycut"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"categorycuttap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"categorymore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"categorymoretap"});
                break;
            }
            case "brandmore": {
                int lastBrandMore = malSearchModel.getBrandMore();
                List brandMoreKeys = malSearchModel.getBrandMoreKeys();
                if (lastBrandMore == 1) {
                    this.getView().setVisible(Boolean.FALSE, brandMoreKeys.toArray(new String[0]));
                    malSearchModel.setBrandMore(0);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"brandcut"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"brandcuttap"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"brandmore"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"brandmoretap"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, brandMoreKeys.toArray(new String[0]));
                malSearchModel.setBrandMore(1);
                this.getView().setVisible(Boolean.TRUE, new String[]{"brandcut"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"brandcuttap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"brandmore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"brandmoretap"});
                break;
            }
        }
        this.updateSearchModel(malSearchModel);
    }

    private void addToCart() {
        String msg;
        int[] selectedIndexs = this.getSelectIndex();
        DynamicObject selectDObject = this.getSelectedDyObject(selectedIndexs);
        long pk = Long.parseLong(selectDObject.getString(SEARCH_PK));
        String source = String.valueOf(selectDObject.getString(PRODUCT_SOURCE));
        boolean isAddSuccess = false;
        String errmsg = "";
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            ArrayList<Long> prodIds = new ArrayList<Long>(1);
            prodIds.add(pk);
            Map msgMap = kd.scm.mal.common.util.MalProductUtil.checkProdStatusAndOrg(prodIds, (String)"addcart", (Long)RequestContext.get().getOrgId());
            if (msgMap.size() > 0) {
                for (Map.Entry errMap : msgMap.entrySet()) {
                    errmsg = (String)errMap.getKey();
                }
                if (!errmsg.isEmpty()) {
                    isAddSuccess = false;
                }
            } else {
                isAddSuccess = MalAddToCartHelper.addCartNew((Long)pk, (String)source);
            }
        } else {
            Map<String, BigDecimal> malPrice = MalShopCartUtil.getMalPrice(Collections.singletonList(String.valueOf(pk)));
            if (!malPrice.isEmpty()) {
                isAddSuccess = MalAddToCartHelper.addCartNew((Long)pk, (String)source);
            }
        }
        if (isAddSuccess) {
            this.updateCartNo();
            msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalSearchNewListPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
        } else if (!errmsg.isEmpty()) {
            this.getView().showErrorNotification(errmsg);
        } else {
            msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25\u3002", (String)"MalSearchNewListPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(selectDObject.getString(SEARCH_NAME) + "\t" + msg);
        }
    }

    private void checkStock() {
        int[] selectedIndexs = this.getSelectIndex();
        DynamicObject selectDObject = this.getSelectedDyObject(selectedIndexs);
        long pk = Long.parseLong(selectDObject.getString(SEARCH_PK));
        MalGoods malGoods = MalGoods.of((Long)pk);
        String stockDesc = malGoods.getStockDesc();
        String soldOut = StockEnum.SOLDOUT.getName();
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && null != stockDesc && (stockDesc.equals(soldOut) || stockDesc.equals("0"))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("add_cart", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u8d2d\u7269\u8f66\u5417\uff1f", (String)"MalSearchNewListPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.addToCart();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)"add_cart", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.addToCart();
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (CHECKBOX_QYSP.equals(e.getProperty().getName())) {
            MalSearchModel malSearchModel = this.getSearchModel();
            List productList = malSearchModel.getProductList();
            ChangeData[] changeData = e.getChangeSet();
            malSearchModel.setQysp((Boolean)changeData[0].getNewValue());
            productList = malSearchModel.filterAndSortBySelected(productList);
            this.setFilterPanelSizeLabel(productList.size());
            this.updateSearchModel(malSearchModel);
            this.refreshData(productList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CB_COMPARE.equals(e.getProperty().getName())) {
            Long goodsId = Long.valueOf(String.valueOf(this.getModel().getValue(SEARCH_PK, e.getChangeSet()[0].getRowIndex())));
            IPageCache pageCache = this.getPageCache();
            String compareValue = pageCache.get(CB_COMPARE);
            if (((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                if (null == compareValue) {
                    Boolean isView;
                    ArrayList<Long> prodIds = new ArrayList<Long>(1);
                    prodIds.add(goodsId);
                    String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
                    long orgId = RequestContext.get().getOrgId();
                    if (purchaseOrg != null) {
                        orgId = Long.parseLong(purchaseOrg);
                    }
                    if ((isView = kd.scm.mal.common.util.MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"addcompare", (Long)orgId)).booleanValue()) {
                        this.getModel().beginInit();
                        this.getModel().setDataChanged(false);
                        this.getModel().setValue(CB_COMPARE, (Object)Boolean.FALSE, e.getChangeSet()[0].getRowIndex());
                        pageCache.put(CB_COMPARE, "0");
                        this.getModel().endInit();
                        this.getView().invokeOperation(REFRESH_COMPARE);
                        return;
                    }
                }
                if ("0".equals(pageCache.get(CB_COMPARE))) {
                    pageCache.remove(CB_COMPARE);
                    this.getModel().setValue(CB_COMPARE, (Object)Boolean.FALSE, e.getChangeSet()[0].getRowIndex());
                    return;
                }
                try {
                    this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addCompareRecord(goodsId, Long.valueOf(RequestContext.get().getCurrUserId()), 0));
                }
                catch (KDBizException exception) {
                    this.getModel().beginInit();
                    this.getModel().setValue(CB_COMPARE, (Object)Boolean.FALSE, e.getChangeSet()[0].getRowIndex());
                    this.getModel().endInit();
                    this.getView().showErrorNotification(exception.getMessage());
                    this.getView().invokeOperation(REFRESH_COMPARE);
                }
            } else {
                ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(Stream.of(goodsId).collect(Collectors.toSet()), Long.valueOf(RequestContext.get().getCurrUserId()));
                this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords().size());
            }
            if (MAL_NEWPRODUCTDETAIL.equals(this.getView().getFormShowParameter().getParentFormId())) {
                this.getView().getParentView().invokeOperation(REFRESH_COMPARE);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    private void createSourceLabelAp(List<GoodsInfo> goodsInfos, String sourceContainerKey) {
        Container sourceContainer = (Container)this.getControl(sourceContainerKey);
        if (sourceContainer == null) {
            return;
        }
        MalSearchModel malSearchModel = this.getSearchModel();
        ArrayList<Map> sourceLabelList = new ArrayList<Map>();
        HashSet<String> sourceSet = new HashSet<String>(2);
        LabelAp labelAp = new LabelAp();
        for (GoodsInfo goodsInfo : goodsInfos) {
            if (goodsInfo == null || StringUtils.isEmpty((CharSequence)goodsInfo.getProductSource()) || !sourceSet.add(goodsInfo.getProductSource())) continue;
            labelAp.setClickable(true);
            labelAp.setKey("sourcefilter_" + goodsInfo.getProductSource());
            labelAp.setId("sourcefilter_" + goodsInfo.getProductSource());
            labelAp.setName(new LocaleString(EcPlatformEnum.fromVal((String)goodsInfo.getProductSource()).getName()));
            labelAp.setFontSize(12);
            labelAp.setStyle(MalSearchNewListPlugin.getFilterStyle());
            labelAp.setRadius("2px");
            sourceLabelList.add(labelAp.createControl());
            malSearchModel.getSourceTagsMap().put("sourcefilter_" + goodsInfo.getProductSource(), labelAp.getName().toString());
        }
        this.updateSearchModel(malSearchModel);
        sourceContainer.addControls(sourceLabelList);
    }

    private static Style getFilterStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("24px");
        style.setMargin(margin);
        Padding padding = new Padding();
        padding.setBottom("3px");
        padding.setLeft("3px");
        padding.setRight("3px");
        padding.setTop("3px");
        style.setPadding(padding);
        return style;
    }

    private void createCategoryLabelAp(List<GoodsInfo> goodsInfos, String categoryContainerKey) {
        Container categoryContainer = (Container)this.getControl(categoryContainerKey);
        if (categoryContainer == null) {
            return;
        }
        MalSearchModel malSearchModel = this.getSearchModel();
        ArrayList<Map> categoryLabelList = new ArrayList<Map>();
        HashMap<String, HashSet<String>> categoryFilterMap = new HashMap<String, HashSet<String>>();
        LabelAp labelAp = new LabelAp();
        int categoryCount = 0;
        List categoryMoreKeys = malSearchModel.getCategoryMoreKeys();
        for (GoodsInfo goodsInfo : goodsInfos) {
            if (goodsInfo == null || StringUtils.isEmpty((CharSequence)goodsInfo.getCategoryName()) || StringUtils.isEmpty((CharSequence)goodsInfo.getCategoryNumber())) continue;
            HashSet<String> categorySet = (HashSet<String>)categoryFilterMap.get(goodsInfo.getProductSource());
            if (null == categorySet) {
                categorySet = new HashSet<String>();
                categoryFilterMap.put(goodsInfo.getProductSource(), categorySet);
            }
            if (!categorySet.add(goodsInfo.getCategoryId())) continue;
            ++categoryCount;
            labelAp.setClickable(true);
            labelAp.setKey("categoryfilter_" + goodsInfo.getProductSource() + SPLIT + goodsInfo.getCategoryId());
            labelAp.setId(goodsInfo.getProductSource() + SPLIT + goodsInfo.getCategoryId());
            labelAp.setName(new LocaleString(goodsInfo.getCategoryName()));
            labelAp.setFontSize(12);
            labelAp.setRadius("2px");
            labelAp.setStyle(MalSearchNewListPlugin.getFilterStyle());
            categoryLabelList.add(labelAp.createControl());
            if (categoryCount > 12) {
                this.getView().setVisible(Boolean.FALSE, new String[]{labelAp.getKey()});
                categoryMoreKeys.add(labelAp.getKey());
            }
            malSearchModel.getCategoryTagsMap().put("categoryfilter_" + goodsInfo.getProductSource() + SPLIT + goodsInfo.getCategoryId(), labelAp.getName().toString());
        }
        this.updateSearchModel(malSearchModel);
        if (CollectionUtils.isNotEmpty((Collection)categoryMoreKeys)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"categorymoreflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"categorymore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"categorymoretap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"categorycut"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"categorycuttap"});
        } else {
            this.getPageCache().put(CACHE_CATEGORY_MORE, "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"categorymoreflex"});
        }
        categoryContainer.addControls(categoryLabelList);
    }

    private void createBrandLabelAp(List<GoodsInfo> goodsInfos, String brandContainerKey) {
        Container brandContainer = (Container)this.getControl(brandContainerKey);
        if (brandContainer == null) {
            return;
        }
        MalSearchModel malSearchModel = this.getSearchModel();
        ArrayList<Map> brandLabelList = new ArrayList<Map>();
        HashMap<String, HashSet<String>> brandFilterMap = new HashMap<String, HashSet<String>>();
        LabelAp labelAp = new LabelAp();
        int brandCount = 0;
        List brandMoreKeys = malSearchModel.getBrandMoreKeys();
        for (GoodsInfo goodsInfo : goodsInfos) {
            if (goodsInfo == null || StringUtils.isEmpty((CharSequence)goodsInfo.getBrandName()) || StringUtils.isEmpty((CharSequence)goodsInfo.getBrandNumber())) continue;
            HashSet<String> brandSet = (HashSet<String>)brandFilterMap.get(goodsInfo.getProductSource());
            if (null == brandSet) {
                brandSet = new HashSet<String>();
                brandFilterMap.put(goodsInfo.getProductSource(), brandSet);
            }
            if (!brandSet.add(goodsInfo.getBrandId())) continue;
            ++brandCount;
            labelAp.setClickable(true);
            labelAp.setKey("brandfilter_" + goodsInfo.getProductSource() + SPLIT + goodsInfo.getBrandId());
            labelAp.setId(goodsInfo.getProductSource() + SPLIT + goodsInfo.getBrandId());
            labelAp.setName(new LocaleString(goodsInfo.getBrandName()));
            labelAp.setFontSize(12);
            labelAp.setRadius("2px");
            labelAp.setStyle(MalSearchNewListPlugin.getFilterStyle());
            brandLabelList.add(labelAp.createControl());
            if (brandCount > 8) {
                this.getView().setVisible(Boolean.FALSE, new String[]{labelAp.getKey()});
                brandMoreKeys.add(labelAp.getKey());
            }
            malSearchModel.getBrandTagsMap().put("brandfilter_" + goodsInfo.getProductSource() + SPLIT + goodsInfo.getBrandId(), labelAp.getName().toString());
        }
        this.updateSearchModel(malSearchModel);
        if (CollectionUtils.isNotEmpty((Collection)brandMoreKeys)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"brandmoreflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"brandmore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"brandmoretap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"brandcut"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"brandcuttap"});
        } else {
            this.getPageCache().put(CACHE_BRAND_MORE, "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"brandmoreflex"});
        }
        brandContainer.addControls(brandLabelList);
    }

    private void setClickingStyle(String key, boolean isClicking) {
        HashMap<String, Object> uiParam = new HashMap<String, Object>();
        String foreColor = "#666666";
        String borderColor = "#FFFFFF";
        if (isClicking) {
            foreColor = "themeColor";
            borderColor = "themeColor";
        }
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("b", "1px_solid_" + borderColor);
        b.put("l", "1px_solid_" + borderColor);
        b.put("r", "1px_solid_" + borderColor);
        b.put("t", "1px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>();
        style.put("b", b);
        uiParam.put("s", style);
        uiParam.put("fc", foreColor);
        this.getView().updateControlMetadata(key, uiParam);
    }

    protected void updateCartNo() {
        Label cartNo = (Label)this.getControl(CART_NO);
        if (Objects.nonNull(cartNo)) {
            int currNo = MalProductUtil.getCartNumber();
            cartNo.setText(String.valueOf(currNo));
        }
    }

    public void setFilterPanelSizeLabel(int size) {
        Label labelNum = (Label)this.getView().getControl(LABELNUM);
        if (labelNum != null) {
            labelNum.setText(size + "");
        }
    }

    protected int[] getSelectIndex() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        return grid.getEntryState().getSelectedRows();
    }

    protected DynamicObject getSelectedDyObject(int[] selectedIndexs) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(SEARCH_ENTRYENTITY);
        IDataModel gridModel = grid.getModel();
        String entryKey = grid.getKey();
        return gridModel.getEntryRowEntity(entryKey, selectedIndexs[0]);
    }

    public static class TimeTracer
    implements AutoCloseable {
        private String methodName;
        private long startTime;

        public TimeTracer(String methodName) {
            this.methodName = methodName;
            this.startTime = TimeServiceHelper.getTimeStamp();
        }

        @Override
        public void close() {
            log.info("@@@[" + this.methodName + "] cost:" + (TimeServiceHelper.getTimeStamp() - this.startTime) + "ms");
        }
    }
}

