/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.mal.domain.model.search.MalSearchParam;

public class MalSearchParamPagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_OPEN_SEARCH = "open_search";
    public static final String MAL_SEARCH_PARAM = "malSearchParam";

    public void afterCreateNewData(EventObject e) {
        Object malSearchParamObj = this.getView().getFormShowParameter().getCustomParam(MAL_SEARCH_PARAM);
        if (!ObjectUtils.isEmpty((Object)malSearchParamObj)) {
            MalSearchParam malSearchParam = (MalSearchParam)JSON.parseObject((String)malSearchParamObj.toString(), MalSearchParam.class);
            this.initBySearchParam(malSearchParam);
        }
    }

    private void initBySearchParam(MalSearchParam malSearchParam) {
        if (StringUtils.isNotBlank((CharSequence)malSearchParam.getSources()) && malSearchParam.getSources().split(",").length == 1) {
            this.getModel().setValue("platform", (Object)malSearchParam.getSources());
            String standardId = EcApiUtil.getStandard((String)malSearchParam.getSources());
            if (StringUtils.isNotBlank((CharSequence)standardId)) {
                Map categoryDynMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_goodsclass", (QFilter[])new QFilter[]{new QFilter("number", "in", Arrays.asList(malSearchParam.getCategoryNumber(), malSearchParam.getCategoryNumber1(), malSearchParam.getCategoryNumber2())).and("standard", "=", (Object)Long.valueOf(standardId))});
                HashMap<String, Long> categoryNumberToIdMap = new HashMap<String, Long>(16);
                for (DynamicObject categoryDyn : categoryDynMap.values()) {
                    categoryNumberToIdMap.put(categoryDyn.getString("number"), categoryDyn.getLong("id"));
                }
                if (!categoryNumberToIdMap.isEmpty()) {
                    this.getModel().setValue("category3", categoryNumberToIdMap.get(malSearchParam.getCategoryNumber()));
                    this.getModel().setValue("category2", categoryNumberToIdMap.get(malSearchParam.getCategoryNumber2()));
                    this.getModel().setValue("category1", categoryNumberToIdMap.get(malSearchParam.getCategoryNumber1()));
                }
            }
            if (StringUtils.isNotBlank((Object)malSearchParam.getBrandNumbers())) {
                Map brandDynMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_brand", (QFilter[])new QFilter[]{new QFilter("name", "in", (Object)malSearchParam.getBrandNumbers())});
                DynamicObjectCollection brandsMul = (DynamicObjectCollection)this.getModel().getValue("brands");
                if (!brandsMul.isEmpty()) {
                    for (DynamicObject brandDyn : brandDynMap.values()) {
                        DynamicObject brandDynMul = brandsMul.addNew();
                        brandDynMul.set("fbasedataid_id", brandDyn.getPkValue());
                        brandDynMul.set("fbasedataid", (Object)brandDyn);
                    }
                    this.getModel().setValue("brands", (Object)brandsMul);
                }
            }
            this.getModel().setValue("start_price", (Object)malSearchParam.getStartPrice());
            this.getModel().setValue("end_price", (Object)malSearchParam.getEndPrice());
            this.getModel().setValue("orderby", (Object)malSearchParam.getSort());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit category1 = (BasedataEdit)this.getControl("category1");
        category1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category2 = (BasedataEdit)this.getControl("category2");
        category2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category3 = (BasedataEdit)this.getControl("category3");
        category3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().startsWith("category")) {
            String platform = (String)this.getModel().getValue("platform");
            FormShowParameter formShowParameter = evt.getFormShowParameter();
            if (StringUtils.isNotBlank((CharSequence)platform)) {
                String standardId = EcApiUtil.getStandard((String)platform);
                evt.addCustomQFilter(new QFilter("standard", "=", (Object)Long.valueOf(standardId)));
                formShowParameter.setCustomParam("cmbstandardlst", (Object)standardId);
            }
        }
        if (evt.getProperty().getName().equals("category1")) {
            evt.addCustomQFilter(new QFilter("level", "=", (Object)1));
        }
        if (evt.getProperty().getName().equals("category2")) {
            evt.addCustomQFilter(new QFilter("level", "=", (Object)2));
            long category1Id = this.getModel().getDataEntity().getLong("category1.id");
            if (category1Id > 0L) {
                evt.addCustomQFilter(new QFilter("parent.id", "=", (Object)category1Id));
            }
        }
        if (evt.getProperty().getName().equals("category3")) {
            evt.addCustomQFilter(new QFilter("level", "=", (Object)3));
            long category2Id = this.getModel().getDataEntity().getLong("category2.id");
            if (category2Id > 0L) {
                evt.addCustomQFilter(new QFilter("parent.id", "=", (Object)category2Id));
            } else {
                long category1Id = this.getModel().getDataEntity().getLong("category1.id");
                if (category1Id > 0L) {
                    evt.addCustomQFilter(new QFilter("parent.parent.id", "=", (Object)category1Id));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject category3;
        this.getModel().beginInit();
        if ("category1".equals(e.getProperty().getName())) {
            this.getModel().setValue("category2", null);
            this.getModel().setValue("category3", null);
        }
        if ("category2".equals(e.getProperty().getName())) {
            DynamicObject category2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (category2 != null) {
                this.getModel().setValue("category1", category2.get("parent"));
            }
            this.getModel().setValue("category3", null);
        }
        if ("category3".equals(e.getProperty().getName()) && (category3 = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            DynamicObject category3Dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)category3.getPkValue(), (String)"mdr_goodsclass");
            this.getModel().setValue("category2", category3Dyn.get("parent"));
            this.getModel().setValue("category1", category3Dyn.get("parent.parent"));
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity;
        AbstractOperate op;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && OP_OPEN_SEARCH.equals((op = (AbstractOperate)source).getOperateKey()) && (dataEntity = this.getModel().getDataEntity()).getBigDecimal("end_price").compareTo(BigDecimal.ZERO) > 0 && dataEntity.getBigDecimal("start_price").compareTo(BigDecimal.ZERO) > 0 && dataEntity.getBigDecimal("end_price").compareTo(dataEntity.getBigDecimal("start_price")) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7\u9700\u8981\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u4ef7\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"MalSearchParamPagePlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (OP_OPEN_SEARCH.equals(afterDoOperationEventArgs.getOperateKey())) {
            MalSearchParam malSearchParam = this.prepareSearchParam();
            this.getView().returnDataToParent((Object)malSearchParam);
            this.getView().close();
        }
    }

    private MalSearchParam prepareSearchParam() {
        MalSearchParam res = new MalSearchParam();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        res.setSources(dataEntity.getString("platform"));
        res.setCategoryNumber(dataEntity.getString("category3.number"));
        res.setCategoryLevel(3);
        res.setCategoryNumber1(dataEntity.getString("category1.number"));
        res.setCategoryNumber2(dataEntity.getString("category2.number"));
        DynamicObjectCollection brandsMul = (DynamicObjectCollection)this.getModel().getValue("brands");
        ArrayList<String> brandNumbers = new ArrayList<String>(brandsMul.size());
        for (DynamicObject brandDynMul : brandsMul) {
            DynamicObject brandDyn = brandDynMul.getDynamicObject("fbasedataid");
            brandNumbers.add(brandDyn.getString("name"));
        }
        res.setBrandNumbers(brandNumbers);
        res.setStartPrice(dataEntity.getBigDecimal("start_price"));
        res.setEndPrice(dataEntity.getBigDecimal("end_price"));
        res.setSort(dataEntity.getString("orderby"));
        return res;
    }
}

