/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.formplugin.MalMakeOrderCorePlugin;
import kd.scm.mal.formplugin.util.MalMakeOrderHelper;
import kd.scm.mal.formplugin.util.MalProductUtil;

public class MalSelfMakeOrderPlugin
extends MalMakeOrderCorePlugin {
    private static Log log = LogFactory.getLog(MalSelfMakeOrderPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleFee(false);
    }

    @Override
    protected void handleQtyChanged(int rowIndex, BigDecimal newVal, BigDecimal price) {
        super.handleQtyChanged(rowIndex, newVal, price);
        this.handleFee(false);
    }

    protected void handleFee(boolean isForceCahce) {
        String addressId = (String)this.getModel().getValue("addressid");
        if (StringUtils.isNotBlank((CharSequence)addressId)) {
            MalFeeHandleHelper.calDynamicObjectFee((DynamicObject)this.getModel().getDataEntity(true), (String)addressId, (boolean)isForceCahce);
        }
        this.getView().updateView();
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        DynamicObjectCollection dyoCol = this.getModel().getEntryEntity("entryentity");
        List<String> prodList = MalProductUtil.getListByProperty(dyoCol, "goods");
        String prodIdStr = prodList.toString();
        this.getPageCache().put("prodId", prodIdStr.substring(1, prodIdStr.length() - 1));
        this.handleFee(false);
    }

    @Override
    protected void handleFeeByAddressChanged() {
        super.handleFeeByAddressChanged();
        this.handleFee(true);
    }

    @Override
    protected Map<String, Map<Long, Long>> getProdMatMappingMap(List<Long> prodIdList) {
        QFilter mappingfilters;
        DynamicObjectCollection catDyoCol;
        QFilter filters;
        DynamicObjectCollection goodsDyoCol;
        String selectedFields = "goods.id,material.id,category.id,purchasetype.id";
        HashMap<String, Map<Long, Long>> resultMap = new HashMap<String, Map<Long, Long>>(2);
        HashMap<Object, Long> prodMatIdMap = new HashMap<Object, Long>();
        HashMap<Long, Long> purTypeMatIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> catMatIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> prodCatIdMap = new HashMap<Long, Long>();
        ArrayList<Long> catIdList = new ArrayList<Long>();
        QFilter prodfilters = new QFilter("goods", "in", prodIdList);
        DynamicObjectCollection prodDyoCol = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectedFields, (QFilter[])new QFilter[]{prodfilters});
        if (null != prodDyoCol && prodDyoCol.size() > 0) {
            for (DynamicObject dyo : prodDyoCol) {
                Long goodsId = dyo.getLong("goods.id");
                Long purchaseTypeId = dyo.getLong("purchasetype.id");
                Long materialId = dyo.getLong("material.id");
                prodMatIdMap.put(goodsId, materialId);
                purTypeMatIdMap.put(purchaseTypeId, materialId);
            }
        }
        if (null != (goodsDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,category.id", (QFilter[])new QFilter[]{filters = new QFilter("id", "in", prodIdList)})) && goodsDyoCol.size() > 0) {
            for (DynamicObject goodsDyo : goodsDyoCol) {
                Long catId = goodsDyo.getLong("category.id");
                prodCatIdMap.put(goodsDyo.getLong("id"), catId);
                catIdList.add(catId);
            }
        }
        if (null != (catDyoCol = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectedFields, (QFilter[])new QFilter[]{mappingfilters = new QFilter("category", "in", catIdList)})) && catDyoCol.size() > 0) {
            for (DynamicObject dyo : catDyoCol) {
                Long categoryId = dyo.getLong("category.id");
                Long materialId = dyo.getLong("material.id");
                catMatIdMap.put(categoryId, materialId);
            }
        }
        resultMap.put("prodMat", prodMatIdMap);
        resultMap.put("prodCat", prodCatIdMap);
        resultMap.put("catMat", catMatIdMap);
        resultMap.put("prodPurType", purTypeMatIdMap);
        return resultMap;
    }

    @Deprecated
    private DynamicObject getDefaultOrgDynamicObject(Long orgId) {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        HashMap filterMap = new HashMap(3);
        HashMap<String, String> enterPriseIdMap = new HashMap<String, String>(1);
        HashMap<String, String> platformMap = new HashMap<String, String>(1);
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>(1);
        enterPriseIdMap.put("=", enterpriseId);
        filterMap.put("tenantid", enterPriseIdMap);
        platformMap.put("=", "1");
        filterMap.put("platform", platformMap);
        orgIdMap.put("=", orgId);
        filterMap.put("entryentity.companyorg", orgIdMap);
        String selectFields = "entryentity.purorg.id,entryentity.rcvorg.id";
        DynamicObject dynamicObject = ORMUtil.queryDynamicObjectByUnique((String)"pmm_ecadmit", (String)selectFields, filterMap);
        return dynamicObject;
    }

    @Override
    protected BigDecimal calTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObjectCollection dyoCol = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dyo : dyoCol) {
            totalAmount = totalAmount.add(CommonUtil.getBigDecimalPro((Object)dyo.get("goodamount")));
        }
        return totalAmount;
    }

    @Override
    public String checkNotNull() {
        super.checkNotNull();
        StringBuilder sb = new StringBuilder();
        if (null == this.getModel().getValue("delidate")) {
            sb.append(ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f,", (String)"MalSelfMakeOrderPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    @Override
    protected void showDetailPage(String productId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_productdetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject productDyn = BusinessDataServiceHelper.loadSingle((Object)productId, (String)"pbd_goods");
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("productDyn", SerializationUtils.toJsonString((Object)productDyn));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    @Override
    public void makeOrder() {
        Map supGoodsMap;
        IFormView view = this.getView();
        Map featureMap = FeatureCheckUtil.checkMalFeature();
        if (null != featureMap && null != featureMap.get("hasLicense") && null != featureMap.get("licenseMsg") && !((Boolean)featureMap.get("hasLicense")).booleanValue()) {
            view.showMessage(String.valueOf(featureMap.get("licenseMsg")));
            return;
        }
        List<String> prodIdList = Arrays.asList(this.getPageCache().get("prodId").split(","));
        List<String> prodNumberList = MalProductUtil.checkProdMalStates(prodIdList);
        if (null != prodNumberList && prodNumberList.size() > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalSelfMakeOrderPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalSelfMakeOrderPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(prodNumberList), MessageTypes.Default);
            return;
        }
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        String addressId = (String)this.getModel().getValue("addressid");
        ArrayList<String> goodsList = new ArrayList<String>(MalFeeHandleHelper.checkGoodsSellArea((String)addressId, (Map)(supGoodsMap = MalFeeHandleHelper.getSupGoodsGroupMap((DynamicObject)sourceDyo))));
        if (null != goodsList && goodsList.size() > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u90e8\u5206\u5546\u54c1\u5728\u5f53\u524d\u533a\u57df\u4e0d\u53ef\u552e\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalSelfMakeOrderPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalSelfMakeOrderPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(goodsList), MessageTypes.Default);
            return;
        }
        MalMakeOrderHelper makeOrderHelper = new MalMakeOrderHelper();
        Map<String, Object> resultMsg = makeOrderHelper.makeOrder(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal(), sourceDyo);
        boolean flag = (Boolean)resultMsg.get("isSucess");
        if (flag) {
            Long malOrderBillPk = (Long)resultMsg.get("billid");
            if (null != malOrderBillPk) {
                BillShowParameter billShowParameter;
                this.createAttachment(malOrderBillPk);
                boolean isCloseMakeOrder = true;
                if (MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()) == ShowType.NewWindow) {
                    billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.EDIT, (long)malOrderBillPk, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "afterSubmit"));
                    isCloseMakeOrder = false;
                } else {
                    billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()), (OperationStatus)OperationStatus.EDIT, (long)malOrderBillPk, null, null);
                }
                this.getView().showForm((FormShowParameter)billShowParameter);
                HashMap<String, Boolean> returnData = new HashMap<String, Boolean>();
                returnData.put("sucessMakeOrder", Boolean.TRUE);
                this.getView().returnDataToParent(returnData);
                if (isCloseMakeOrder) {
                    this.getView().close();
                }
            }
        } else if (resultMsg.get("errMsg") instanceof String && StringUtils.isNotBlank((Object)resultMsg.get("errMsg"))) {
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u5355\u5931\u8d25\u3002", (String)"MalSelfMakeOrderPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]), String.valueOf(resultMsg.get("errMsg")), MessageTypes.Default);
        }
    }

    private void showMessage(String msg, String detail, MessageTypes type, ConfirmCallBackListener callBack) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (callBack != null) {
            param.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            cache.put("ConfirmCallBackListener." + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        param.put("msg", msg);
        param.put("detail", detail);
        param.put("messageType", (String)(type == null ? MessageTypes.Default : Integer.valueOf(type.getValue())));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("showMessage", param);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_productdetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IDataModel entryOperate = this.getModel();
        int currentIndex = entryOperate.getEntryCurrentRowIndex("entryentity");
        String goodsId = entryOperate.getEntryRowEntity("entryentity", currentIndex).getString("goods");
        DynamicObject productDyn = BusinessDataServiceHelper.loadSingle((Object)goodsId, (String)"pbd_goods");
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("productDyn", SerializationUtils.toJsonString((Object)productDyn));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }
}

