/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.entity.JdStockInfo;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.SupplierChatEngineUtil;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.formplugin.util.MalAddToCartUtil;
import kd.scm.mal.formplugin.util.MalAddressUtil;
import kd.scm.mal.formplugin.util.MalJdProductUtil;
import kd.scm.mal.formplugin.util.MalProductUtil;
import kd.scm.mal.formplugin.util.MalSearchUtils;
import kd.scm.mal.formplugin.util.MalShopCartUtil;

public class MalShopCartPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
SearchEnterListener,
TreeNodeClickListener {
    private static Log log = LogFactory.getLog(MalShopCartPlugin.class);

    public void registerListener(EventObject e) {
        Container mycartflex;
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("cart_entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Container myOrderContainer = (Container)this.getControl("myorderflex");
        myOrderContainer.addClickListener((ClickListener)this);
        Container oftenbuyflex = (Container)this.getControl("oftenbuyflex");
        if (oftenbuyflex != null) {
            oftenbuyflex.addClickListener((ClickListener)this);
        }
        if ((mycartflex = (Container)this.getControl("mycartflex")) != null) {
            mycartflex.addClickListener((ClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MalShopCartUtil.initEntryRow(this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("currency", (Object)MalOrderUtil.getDefaultCurrency());
        }
        this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66 \u261c", (String)"MalShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("fromCart", "true");
        MalShopCartUtil.setDefualAcountValue(this.getView());
        this.allotInitDynamicData(ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        this.allotInitDynamicData(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        this.createPurSchemeLabels(MalShopCartUtil.getPurSchemes(), "purschemeflexap");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        MalShopCartUtil.updateQty(e, this.getModel(), e.getProperty().getName(), this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "refreshcart": {
                this.cancelClicking();
                this.refresh();
                break;
            }
            case "deletecurrow": {
                this.getPageCache().put("delete_key", "singledelete");
                MalShopCartUtil.deleteCurrentEntry(this.getView(), new ConfirmCallBackListener("key_deletecurr", (IFormPlugin)this));
                break;
            }
            case "deleteselectentry": {
                this.getPageCache().put("delete_key", "batchdelete");
                MalShopCartUtil.deleteSelectedEntry(this.getView(), new ConfirmCallBackListener("key_deleteselect", (IFormPlugin)this));
                break;
            }
            case "wechat": {
                this.weChat();
                break;
            }
            case "acount": {
                this.openMakeOrderPage();
                break;
            }
            case "enterorder": {
                MalShopCartUtil.openMalOrderPage(this.getView());
                break;
            }
            case "purscheme": {
                MalShopCartUtil.openPurScheme(this.getView(), new CloseCallBack((IFormPlugin)this, "mal_purscheme"));
                break;
            }
            case "save_purscheme": {
                this.savePurScheme();
                break;
            }
            case "showcart": {
                this.cancelClicking();
                this.getPageCache().put("cache_isscheme", "0");
                this.refresh();
                this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66 \u261c", (String)"MalShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("fromCart", "true");
                break;
            }
            case "oftenbuy": {
                this.cancelClicking();
                this.showOftenBuy();
                this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalShopCartPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70 \u261c", (String)"MalShopCartPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("fromCart", "false");
                break;
            }
            case "add2oftenbuy": {
                this.add2Oftenbuy();
                break;
            }
            case "delscheme": {
                this.delScheme();
                break;
            }
        }
    }

    protected void weChat() {
        IDataModel entryOperate = this.getModel();
        int currentIndex = entryOperate.getEntryCurrentRowIndex("cart_entryentity");
        DynamicObject supplier = (DynamicObject)entryOperate.getEntryRowEntity("cart_entryentity", currentIndex).get("cart_supplier");
        String source = entryOperate.getEntryRowEntity("cart_entryentity", currentIndex).getString("cart_goodsource");
        if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(source)) {
            Map resultMap = SupplierChatEngineUtil.createSupplierChat((DynamicObject)supplier);
            if ("true".equals(resultMap.get("succed"))) {
                YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
                yzj.setView(this.getView());
                HashMap mData = new HashMap();
                mData.put("openId", resultMap.get("data"));
                mData.put("userName", "");
                mData.put("chattype", "chat_pc");
                yzj.yzjInterface("createAndChat", mData);
            } else {
                this.getView().showMessage(resultMap.get("message").toString());
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5546\u57ce\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u5ba2\u670d\u6c9f\u901a\u3002", (String)"MalShopCartPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void delScheme() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("cache_isscheme")) && this.getPageCache().get("cache_isscheme").equals("1") && !StringUtils.equals((CharSequence)this.getPageCache().get("cache_schemeid"), (CharSequence)(MalShopCartUtil.getOftenBuy() == null ? "" : MalShopCartUtil.getOftenBuy().getString("id")))) {
            DeleteServiceHelper.delete((String)"mal_purscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(this.getPageCache().get("cache_schemeid")))});
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getPageCache().get("cache_schemeid")});
            this.getPageCache().put("cache_isscheme", "0");
            this.getPageCache().put("cache_schemeid", "");
            this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66 \u261c", (String)"MalShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.refresh();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"MalShopCartPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void add2Oftenbuy() {
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(this.getView().getControl("cart_entryentity"));
        if (selectedIndexs.length > 0) {
            DynamicObjectCollection selectedSaveDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, this.getView().getControl("cart_entryentity"));
            List<String> prodIdList = MalProductUtil.getListByProperty(selectedSaveDyObject, "cart_goods");
            List<String> prodNumberList = MalProductUtil.checkProdMalStates(prodIdList);
            if (prodNumberList.size() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalShopCartPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(prodNumberList), MessageTypes.Default);
                return;
            }
            this.saveGoods(selectedSaveDyObject.stream().filter(dyo -> StringUtils.equals((CharSequence)dyo.getString("cart_goodsource"), (CharSequence)ProductSourceEnum.PRODUCTSOURCE_JD.getVal())).collect(Collectors.toCollection(() -> new DynamicObjectCollection())));
            QFilter qFilter = new QFilter("number", "=", (Object)RequestContext.get().getUserId());
            DynamicObject oftenbuyDyn = BusinessDataServiceHelper.loadSingle((String)"mal_purscheme", (String)"id,goodsentry,goodsentry.goods,goodsentry.unit,goodsentry.qty", (QFilter[])new QFilter[]{qFilter});
            if (oftenbuyDyn == null) {
                log.info("\u6211\u7684\u5e38\u4e70\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u540e\u53f0\u81ea\u52a8\u521b\u5efa");
                oftenbuyDyn = ORMUtil.newDynamicObject((String)"mal_purscheme");
                String userId = RequestContext.get().getUserId();
                oftenbuyDyn.set("name", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                oftenbuyDyn.set("creator", (Object)userId);
                oftenbuyDyn.set("modifier", (Object)userId);
                oftenbuyDyn.set("number", (Object)userId);
                oftenbuyDyn.set("modifytime", (Object)new Date());
                oftenbuyDyn.set("createtime", (Object)new Date());
                oftenbuyDyn.set("status", (Object)"A");
                oftenbuyDyn.set("enable", (Object)"1");
            }
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)oftenbuyDyn.get("goodsentry");
            StringBuilder logString = new StringBuilder();
            for (DynamicObject dyo2 : selectedSaveDyObject) {
                DynamicObject entryDyo2;
                String goodsNumber = dyo2.getString("cart_number");
                String goodsource = dyo2.getString("cart_goodsource");
                Optional<DynamicObject> dynOpt = entryDyoCol.stream().filter(entryDyo -> StringUtils.equals((CharSequence)entryDyo.getString("goods.number"), (CharSequence)goodsNumber) && StringUtils.equals((CharSequence)entryDyo.getString("goods.source"), (CharSequence)goodsource)).findFirst();
                if (dynOpt.isPresent()) {
                    entryDyo2 = dynOpt.get();
                } else {
                    entryDyo2 = ORMUtil.newDynamicObject((DynamicObjectType)entryDyoCol.getDynamicObjectType());
                    entryDyoCol.add((Object)entryDyo2);
                }
                DynamicObject goodDyn = BusinessDataServiceHelper.loadSingle((String)"pbd_goods", (String)"id,number,name,unit,source", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)goodsNumber), new QFilter("source", "=", (Object)goodsource)});
                logString.append(ResManager.loadKDString((String)"\u52a0\u5165\u5e38\u4e70\u7684goodDyn", (String)"MalShopCartPlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0])).append(goodDyn.getString("id")).append("\n");
                entryDyo2.set("goods", goodDyn.getPkValue());
                entryDyo2.set("unit", (Object)dyo2.getString("cart_unit.id"));
                entryDyo2.set("qty", (Object)dyo2.getBigDecimal("cart_qty"));
            }
            log.info(logString.toString());
            oftenbuyDyn.set("goodsentry", (Object)entryDyoCol);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oftenbuyDyn});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6dfb\u52a0\u6211\u7684\u5e38\u4e70\u6210\u529f\u3002", (String)"MalShopCartPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalShopCartPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    private void showOftenBuy() {
        DynamicObject oftenbuyDyn = MalShopCartUtil.getOftenBuy();
        if (oftenbuyDyn == null) {
            this.getModel().deleteEntryData("cart_entryentity");
            this.getView().updateView();
            return;
        }
        this.showPurSchemeInCart(oftenbuyDyn.getString("id"));
    }

    private void showPurSchemeInCart(String purSchemeId) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(purSchemeId));
        String selectFields = "goodsentry.goods.id,goodsentry.goods.number,goodsentry.goods.thumbnail,goodsentry.goods.name,goodsentry.goods.description,goodsentry.goods.model,goodsentry.goods.remark,goodsentry.goods.source,goodsentry.goods.supplier.id,goodsentry.goods.unit.id,goodsentry.goods.taxrate,goodsentry.goods.price,goodsentry.goods.shopprice,goodsentry.qty";
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_purscheme", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"goodsentry.goods.supplier asc");
        this.getModel().deleteEntryData("cart_entryentity");
        this.showEntryListOfPurScheme(dyoCol);
        MalShopCartUtil.initEntryRow(this.getView());
        MalShopCartUtil.setDefualAcountValue(this.getView());
        this.getView().updateView();
        this.getPageCache().put("cache_isscheme", "1");
        this.getPageCache().put("cache_schemeid", purSchemeId);
    }

    private void createPurSchemeLabels(DynamicObjectCollection purSchemeDyns, String key) {
        Container purSchemeFlexAp = (Container)this.getView().getControl(key);
        if (purSchemeFlexAp == null) {
            return;
        }
        purSchemeFlexAp.deleteControls(new String[]{this.getPageCache().get("cache_schemeid")});
        ArrayList<Map> list = new ArrayList<Map>();
        Margin margin = new Margin();
        margin.setTop("10px");
        Style style = new Style();
        style.setMargin(margin);
        Padding padding = new Padding();
        style.setPadding(padding);
        Border border = new Border();
        String color = "#ffaa56";
        border.setBottom("1px_solid_" + color);
        border.setLeft("1px_solid_" + color);
        border.setRight("1px_solid_" + color);
        border.setTop("1px_solid_" + color);
        style.setBorder(border);
        LabelAp labelAp = new LabelAp();
        for (DynamicObject dyn : purSchemeDyns) {
            purSchemeFlexAp.deleteControls(new String[]{dyn.getString("id")});
            if (ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]).equals(dyn.getString("name"))) continue;
            labelAp.setId(dyn.getString("id"));
            labelAp.setClickable(true);
            labelAp.setName(new LocaleString(dyn.getString("name")));
            labelAp.setKey(dyn.getString("id"));
            labelAp.setFontSize(14);
            labelAp.setForeColor(color);
            labelAp.setWidth(new LocaleString("100px"));
            labelAp.setRadius("30px");
            labelAp.setStyle(style);
            labelAp.setTextAlign("center");
            list.add(labelAp.createControl());
        }
        purSchemeFlexAp.addControls(list);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.equals((CharSequence)"myorderflex", (CharSequence)source.getKey())) {
            MalShopCartUtil.openMalOrderPage(this.getView());
        }
        if (StringUtils.equals((CharSequence)"mycartflex", (CharSequence)source.getKey())) {
            this.getPageCache().put("cache_isscheme", "0");
            this.getPageCache().put("isscheme", null);
            this.refresh();
            this.cancelClicking();
            this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66 \u261c", (String)"MalShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            pageCache.put("fromCart", "true");
        }
        if (StringUtils.equals((CharSequence)"oftenbuyflex", (CharSequence)source.getKey())) {
            this.showOftenBuy();
            this.cancelClicking();
            this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70 \u261c", (String)"MalShopCartPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalShopCartPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            pageCache.put("cache_isscheme", "1");
            this.getPageCache().put("isscheme", null);
            pageCache.put("fromCart", "false");
        }
        for (DynamicObject dyn : MalShopCartUtil.getPurSchemes()) {
            if (StringUtils.equals((CharSequence)dyn.getString("id"), (CharSequence)source.getKey())) {
                this.showPurSchemeInCart(source.getKey());
                this.getPageCache().put("isscheme", "2");
                this.setIsClicking(source.getKey(), true, "#ffaa56", "#ffaa56", "");
                this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalShopCartPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("myoften", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalShopCartPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                pageCache.put("fromCart", "false");
                continue;
            }
            this.setIsClicking(dyn.getString("id"), false, "#ffaa56", "#ffaa56", "");
            this.setIsClicking("mycartflex", false, "#FC8555", "#FC8555", "");
            this.setIsClicking("oftenbuyflex", false, "#FC8555", "#FC8555", "");
        }
    }

    private void cancelClicking() {
        for (DynamicObject dyn : MalShopCartUtil.getPurSchemes()) {
            this.setIsClicking(dyn.getString("id"), false, "#ffaa56", "#ffaa56", "");
        }
    }

    private void setIsClicking(String key, boolean isClicking, String foreColor, String borderColor, String backColor) {
        HashMap<String, Object> uiParam = new HashMap<String, Object>();
        if (isClicking) {
            foreColor = "#ffffff";
            backColor = "#FC8555";
        }
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("b", "1px_solid_" + borderColor);
        b.put("l", "1px_solid_" + borderColor);
        b.put("r", "1px_solid_" + borderColor);
        b.put("t", "1px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>();
        style.put("b", b);
        uiParam.put("s", style);
        uiParam.put("bc", backColor);
        uiParam.put("fc", foreColor);
        this.getView().updateControlMetadata(key, uiParam);
    }

    protected void savePurScheme() {
        DynamicObjectCollection selectedSaveDyObject = MalShopCartUtil.saveScheme(this.getView());
        if (null != selectedSaveDyObject) {
            if (((DynamicObject)selectedSaveDyObject.get(0)).getString("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                MalShopCartUtil.openSavePurScheme(this.getView(), new CloseCallBack((IFormPlugin)this, "mal_savescheme"));
            }
            if (((DynamicObject)selectedSaveDyObject.get(0)).getString("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                this.saveGoods(selectedSaveDyObject);
                MalShopCartUtil.openSavePurScheme(this.getView(), new CloseCallBack((IFormPlugin)this, "mal_savescheme"));
            }
        } else {
            return;
        }
    }

    private void saveGoods(DynamicObjectCollection selectedSaveDyObject) {
        ArrayList<String> skusList = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>(skusList.size());
        HashMap<String, String> imgMap = new HashMap<String, String>(skusList.size());
        for (DynamicObject dyn : selectedSaveDyObject) {
            String sku = dyn.getString("cart_number");
            skusList.add(sku);
            GoodsInfo jdProdDetail = JdApiUtil.getJdProdDetail((String)sku, (boolean)false);
            nameMap.put(sku, jdProdDetail.getProductName());
            imgMap.put(sku, jdProdDetail.getProductImgPath());
        }
        MalJdProductUtil.saveJdGoods(skusList, nameMap, imgMap);
    }

    protected void saveGoods2PurScheme(Map<String, Object> info) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject schemeDyo = ORMUtil.newDynamicObject((String)"mal_purscheme");
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(this.getView().getControl("cart_entryentity"));
        if (null != info.get("name") && selectedIndexs.length > 0) {
            DynamicObjectCollection selectedSaveDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, this.getView().getControl("cart_entryentity"));
            schemeDyo.set("name", (Object)String.valueOf(info.get("name")));
            schemeDyo.set("creator", (Object)userId);
            schemeDyo.set("modifier", (Object)userId);
            schemeDyo.set("modifytime", (Object)new Date());
            schemeDyo.set("createtime", (Object)new Date());
            schemeDyo.set("status", (Object)"A");
            schemeDyo.set("enable", (Object)"1");
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)schemeDyo.get("goodsentry");
            for (DynamicObject dyo : selectedSaveDyObject) {
                DynamicObject entryDyo = ORMUtil.newDynamicObject((DynamicObjectType)entryDyoCol.getDynamicObjectType());
                Long goods = Long.valueOf(dyo.getString("cart_goods"));
                DynamicObject gooddyn = null;
                if (StringUtils.equals((CharSequence)dyo.getString("cart_goodsource"), (CharSequence)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                    gooddyn = BusinessDataServiceHelper.loadSingleFromCache((Object)goods, (String)"pbd_goods");
                } else if (StringUtils.equals((CharSequence)dyo.getString("cart_goodsource"), (CharSequence)ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                    gooddyn = BusinessDataServiceHelper.loadSingle((String)"pbd_goods", (String)"id,name,unit,source", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)String.valueOf(goods))});
                }
                if (gooddyn == null) continue;
                entryDyo.set("goods", (Object)gooddyn);
                entryDyo.set("unit", dyo.get("cart_unit"));
                entryDyo.set("qty", (Object)CommonUtil.getBigDecimalPro((Object)dyo.get("cart_qty")));
                entryDyoCol.add((Object)entryDyo);
            }
            schemeDyo.set("goodsentry", (Object)entryDyoCol);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDyo});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u91c7\u8d2d\u65b9\u6848\u6210\u529f\u3002", (String)"MalShopCartPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u91c7\u8d2d\u65b9\u6848\u5931\u8d25\u3002", (String)"MalShopCartPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        Label label = new Label();
        label.addClickListener((ClickListener)this);
        MalShopCartUtil.saveSchemeId(e, this.getView(), label);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        MalShopCartUtil.showScheme(closedCallBackEvent, this.getView());
        if (StringUtils.isNotBlank((CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent.getActionId().equals("mal_savescheme") && null != closedCallBackEvent.getReturnData()) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            this.saveGoods2PurScheme(returnData);
            this.createPurSchemeLabels(MalShopCartUtil.getPurSchemes(), "purschemeflexap");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MalShopCartUtil.confirmScheme(messageBoxClosedEvent, this.getView(), new CloseCallBack((IFormPlugin)this, "mal_purscheme"));
        if (StringUtils.equals((CharSequence)"key_deletecurr", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IDataModel entryOperate = this.getModel();
            int currentIndex = entryOperate.getEntryCurrentRowIndex("cart_entryentity");
            DynamicObject dyo = entryOperate.getEntryRowEntity("cart_entryentity", currentIndex);
            this.getPageCache().put("currentPk", dyo.getString("cart_pk"));
            if (StringUtils.equals((CharSequence)this.getPageCache().get("cache_isscheme"), (CharSequence)"1")) {
                this.getPageCache().put("cache_goodid", dyo.getString("cart_pk"));
            } else {
                this.getPageCache().put("cache_goodid", dyo.getString("cart_goods"));
            }
            this.getModel().deleteEntryRows("cart_entryentity", new int[]{currentIndex});
        }
    }

    protected void refresh() {
        this.getModel().deleteEntryData("cart_entryentity");
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("cache_isscheme")) && StringUtils.equals((CharSequence)this.getPageCache().get("cache_isscheme"), (CharSequence)"1")) {
            this.showPurSchemeInCart(this.getPageCache().get("cache_schemeid"));
            this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66", (String)"MalShopCartPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            this.setIsClicking(this.getPageCache().get("cache_schemeid"), true, "#ffaa56", "#ffaa56", "");
        } else {
            DynamicObject[] jdNewDynamicObjects = this.getNewDynamicObjectCol(ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
            DynamicObject[] selfNewDynamicObjects = this.getNewDynamicObjectCol(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
            if (null != jdNewDynamicObjects) {
                this.showEntryList(ProductSourceEnum.PRODUCTSOURCE_JD.getVal(), jdNewDynamicObjects);
            }
            if (null != selfNewDynamicObjects) {
                this.showEntryList(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal(), selfNewDynamicObjects);
            }
            this.getModel().setValue("mycart", (Object)ResManager.loadKDString((String)"\u8d2d\u7269\u8f66 \u261c", (String)"MalShopCartPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        MalShopCartUtil.setDefualAcountValue(this.getView());
        this.getView().updateView();
    }

    private DynamicObject[] getNewDynamicObjectCol(String goodSource) {
        DynamicObject[] dynamicObjects = null;
        String entityKey = "mal_shopcartbill";
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String diffFields = MalShopCartUtil.getDiffFieldsBySource(goodSource);
        String selectFields = "id,goodsimg," + diffFields + ",goodsname,goodsdesc,stockqty,taxprice,qty,unit,taxamount,goodsource,billdate,supplier.id,supplier.number supplier";
        HashMap queryFilterMap = new HashMap(2);
        HashMap<String, Long> person = new HashMap<String, Long>(1);
        HashMap<String, String> sourceMap = new HashMap<String, String>(1);
        person.put("=", userId);
        sourceMap.put("=", goodSource);
        queryFilterMap.put("person", person);
        queryFilterMap.put("goodsource", sourceMap);
        dynamicObjects = ORMUtil.load((String)entityKey, (String)selectFields, queryFilterMap, (String)"supplier asc");
        return dynamicObjects;
    }

    protected void allotInitDynamicData(String goodSource) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String entityKey = "mal_shopcartbill";
        String diffFields = MalShopCartUtil.getDiffFieldsBySource(goodSource);
        String selectFields = "id,goodsimg," + diffFields + ",goodsname,goodsdesc,stockqty,taxprice,qty,unit.id,taxamount,goodsource,supplier.id,supplier.number supplier";
        HashMap queryFilterMap = new HashMap(2);
        HashMap<String, Long> person = new HashMap<String, Long>(1);
        HashMap<String, String> source = new HashMap<String, String>(1);
        person.put("=", userId);
        source.put("=", goodSource);
        queryFilterMap.put("person", person);
        queryFilterMap.put("goodsource", source);
        DynamicObject[] dynamicObjects = ORMUtil.load((String)entityKey, (String)selectFields, queryFilterMap, (String)"supplier asc");
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            this.updatePriceAndStock(dynamicObjects, goodSource);
            this.showEntryList(goodSource, dynamicObjects);
        }
    }

    protected void updatePriceAndStock(DynamicObject[] dynamicObjects, String goodSource) {
        String diffFields = MalShopCartUtil.getDiffFieldsBySource(goodSource);
        List<String> skuNumList = MalShopCartUtil.getSkus(dynamicObjects, diffFields);
        if (goodSource.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
            List<String> goodsIdList = MalShopCartUtil.getSkus(dynamicObjects, "goods.id");
            Map<String, BigDecimal> prodPrice = MalShopCartUtil.getMalProdPrice(skuNumList);
            Map<String, BigDecimal> prodStockQty = MalProductUtil.getAvailableqty(goodsIdList);
            for (DynamicObject dyo : dynamicObjects) {
                BigDecimal goodsProdStockQty;
                String skuId = dyo.getString(diffFields);
                String goodsId = dyo.getString("goods.id");
                BigDecimal qty = dyo.getBigDecimal("qty");
                BigDecimal skuProdPrice = prodPrice.get(skuId);
                if (skuProdPrice != null) {
                    dyo.set("taxPrice", (Object)skuProdPrice);
                    dyo.set("taxamount", (Object)qty.multiply(skuProdPrice));
                }
                if ((goodsProdStockQty = prodStockQty.get(goodsId)) != null) {
                    dyo.set("stockqty", (Object)String.valueOf(goodsProdStockQty));
                    continue;
                }
                dyo.set("stockqty", (Object)String.valueOf(BigDecimal.ZERO));
            }
        } else if (goodSource.equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
            Map priceMap = new HashMap();
            Map stockMap = new HashMap();
            try {
                Map<String, String> defualtAddress = MalJdProductUtil.getDefualtReciept();
                String area = "19_1607_3155";
                priceMap = JdApiUtil.batchGetJdPriceMap(skuNumList);
                if (!defualtAddress.isEmpty()) {
                    area = defualtAddress.get("receiptjdadress");
                }
                stockMap = JdApiUtil.batchGetJdStock(skuNumList, (String)area);
            }
            catch (KDBizException e) {
                log.error("@@@kd.scm.mal.formplugin.MalShopCartPlugin.updatePriceAndStock,\u66f4\u65b0\u4ef7\u683c\u6216\u5e93\u5b58\u5f02\u5e38" + e.getMessage());
            }
            for (DynamicObject dyo : dynamicObjects) {
                String skuId = dyo.getString(diffFields);
                BigDecimal qty = dyo.getBigDecimal("qty");
                PriceInfo skuPrice = (PriceInfo)priceMap.get(skuId);
                if (skuPrice != null) {
                    BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)skuPrice.getShowprice());
                    dyo.set("taxPrice", (Object)taxPrice);
                    dyo.set("taxamount", (Object)qty.multiply(taxPrice));
                } else {
                    dyo.set("taxPrice", (Object)BigDecimal.ZERO);
                    dyo.set("taxamount", (Object)BigDecimal.ZERO);
                }
                JdStockInfo jdStockInfo = (JdStockInfo)stockMap.get(skuId);
                if (jdStockInfo != null) {
                    dyo.set("goodsdesc", (Object)jdStockInfo.getDesc());
                    continue;
                }
                dyo.set("goodsdesc", (Object)StockEnum.SOLDOUT.getName());
            }
        }
        SaveServiceHelper.save((IDataEntityType)dynamicObjects[0].getDataEntityType(), (Object[])dynamicObjects);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        IPageCache cache = this.getPageCache();
        String schemeId = cache.get("cache_schemeid");
        Boolean realDeleteSchemeData = Boolean.FALSE;
        if (StringUtils.equals((CharSequence)cache.get("delete_key"), (CharSequence)"singledelete")) {
            if (StringUtils.isNotEmpty((CharSequence)cache.get("cache_isscheme")) && StringUtils.equals((CharSequence)"1", (CharSequence)cache.get("cache_isscheme"))) {
                String[] goodId = cache.get("cache_goodid").split(",");
                realDeleteSchemeData = MalShopCartUtil.realDeleteSchemeData(this.getView(), schemeId, goodId);
            } else {
                MalShopCartUtil.realDeleteData(cache.get("currentPk").split(","));
            }
        } else if (StringUtils.equals((CharSequence)cache.get("delete_key"), (CharSequence)"batchdelete")) {
            if (StringUtils.isNotEmpty((CharSequence)cache.get("cache_isscheme")) && StringUtils.equals((CharSequence)"1", (CharSequence)cache.get("cache_isscheme"))) {
                String[] goodsId = cache.get("cache_goodsid").split(",");
                realDeleteSchemeData = MalShopCartUtil.realDeleteSchemeData(this.getView(), schemeId, goodsId);
            } else {
                MalShopCartUtil.realDeleteData(cache.get("slectPks").split(","));
            }
        }
        MalShopCartUtil.updateAcountValue(this.getView(), MalShopCartUtil.getSelectIndex(this.getView().getControl("cart_entryentity")));
        if (realDeleteSchemeData.booleanValue() && StringUtils.equals((CharSequence)"2", (CharSequence)cache.get("isscheme"))) {
            this.delScheme();
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("cart_entryentity");
            entryGrid.selectRows(new int[0], 0);
        }
    }

    protected void showEntryList(String goodSource, DynamicObject[] dynamicObjects) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String diffFields = MalShopCartUtil.getDiffFieldsBySource(goodSource);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dyo = dynamicObjects[i];
            if (dyo == null) {
                return;
            }
            vs.set("cart_pk", dyo.get("id"), i);
            if (goodSource.equalsIgnoreCase(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                vs.set("cart_goods", dyo.get("goods.id"), i);
                vs.set("cart_number", dyo.get(diffFields), i);
                vs.set("cart_stock_qty", (Object)this.getSelfStockDesc(CommonUtil.getBigDecimalPro((Object)dyo.get("stockqty"))), i);
                vs.set("cart_desc", dyo.get("goodsdesc"), i);
            } else if (goodSource.equalsIgnoreCase(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                vs.set("cart_goods", (Object)dyo.getString(diffFields), i);
                vs.set("cart_number", (Object)dyo.getString(diffFields), i);
                vs.set("cart_stock_qty", dyo.get("goodsdesc"), i);
            }
            vs.set("cart_pic", dyo.get("goodsimg"), i);
            vs.set("cart_name", dyo.get("goodsname"), i);
            vs.set("cart_price", dyo.get("taxprice"), i);
            vs.set("cart_qty", dyo.get("qty"), i);
            vs.set("cart_unit", dyo.get("unit.id"), i);
            vs.set("cart_amount", dyo.get("taxamount"), i);
            vs.set("cart_goodsource", dyo.get("goodsource"), i);
            vs.set("cart_supplier", dyo.get("supplier.id"), i);
        }
        model.batchCreateNewEntryRow("cart_entryentity", vs);
    }

    private String getSelfStockDesc(BigDecimal stockqty) {
        String stock = stockqty.stripTrailingZeros().toPlainString();
        if (BigDecimal.ZERO.compareTo(stockqty) >= 0) {
            stock = "0";
        }
        return stock;
    }

    private void showEntryListOfPurScheme(DynamicObjectCollection dynamicObjects) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        ArrayList<String> skus = new ArrayList<String>();
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            if (!StringUtils.equals((CharSequence)((DynamicObject)dynamicObjects.get(i)).getString("goodsentry.goods.source"), (CharSequence)ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) continue;
            skus.add(((DynamicObject)dynamicObjects.get(i)).getString("goodsentry.goods.number"));
        }
        Map priceInfoMap = JdApiUtil.batchGetJdPriceMap(skus);
        String defaultJdAdrNum = "19_1607_3155_0";
        if (MalAddressUtil.getDefaultAddress() != null) {
            defaultJdAdrNum = MalAddressUtil.getDefaultAddress().getString("jdaddressnum");
        }
        Map stockInfoMap = JdApiUtil.batchGetJdStock(skus, (String)defaultJdAdrNum);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dyo;
            if (dynamicObjects.get(i) == null || (dyo = (DynamicObject)dynamicObjects.get(i)) == null) continue;
            BigDecimal amount = BigDecimal.ZERO;
            vs.set("cart_pk", dyo.get("goodsentry.goods.id"), i);
            String source = dyo.getString("goodsentry.goods.source");
            if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equalsIgnoreCase(source)) {
                vs.set("cart_stock_qty", (Object)this.getSelfStockDesc(MalAddToCartUtil.getAvailableqty(dyo.getString("goodsentry.goods.id"))), i);
                vs.set("cart_desc", dyo.get("goodsentry.goods.description"), i);
                vs.set("cart_goods", (Object)dyo.getString("goodsentry.goods.id"), i);
                vs.set("cart_price", (Object)dyo.getBigDecimal("goodsentry.goods.shopprice"), i);
                amount = dyo.getBigDecimal("goodsentry.qty").multiply(dyo.getBigDecimal("goodsentry.goods.shopprice"));
            } else if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equalsIgnoreCase(source)) {
                PriceInfo priceInfo = (PriceInfo)priceInfoMap.get(dyo.getString("goodsentry.goods.number"));
                JdStockInfo jdStockInfo = (JdStockInfo)stockInfoMap.get(dyo.getString("goodsentry.goods.number"));
                if (jdStockInfo != null) {
                    vs.set("cart_stock_qty", (Object)jdStockInfo.getDesc(), i);
                } else {
                    vs.set("cart_stock_qty", (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalShopCartPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]), i);
                }
                if (priceInfo != null) {
                    vs.set("cart_price", (Object)priceInfo.getShowprice(), i);
                    amount = dyo.getBigDecimal("goodsentry.qty").multiply(priceInfo.getShowprice());
                } else {
                    vs.set("cart_price", (Object)0, i);
                }
                vs.set("cart_goods", (Object)dyo.getString("goodsentry.goods.number"), i);
            }
            vs.set("cart_number", (Object)dyo.getString("goodsentry.goods.number"), i);
            vs.set("cart_pic", dyo.get("goodsentry.goods.thumbnail"), i);
            vs.set("cart_name", dyo.get("goodsentry.goods.name"), i);
            vs.set("cart_qty", (Object)dyo.getBigDecimal("goodsentry.qty"), i);
            vs.set("cart_unit", dyo.get("goodsentry.goods.unit.id"), i);
            vs.set("cart_amount", (Object)amount, i);
            vs.set("cart_goodsource", dyo.get("goodsentry.goods.source"), i);
            vs.set("cart_supplier", dyo.get("goodsentry.goods.supplier.id"), i);
        }
        model.batchCreateNewEntryRow("cart_entryentity", vs);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        String entryKey = grid.getKey();
        if ("cart_entryentity".equals(entryKey)) {
            int[] selectedIndexs = MalShopCartUtil.getSelectIndex(this.getView().getControl("cart_entryentity"));
            MalShopCartUtil.updateAcountValue(this.getView(), selectedIndexs);
        }
    }

    protected void openMakeOrderPage() {
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(this.getView().getControl("cart_entryentity"));
        if (selectedIndexs.length > 0) {
            DynamicObjectCollection selectedRowsDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, this.getView().getControl("cart_entryentity"));
            if (MalShopCartUtil.isSameSource(selectedRowsDyObject)) {
                List<String> prodIdList = MalShopCartUtil.getSkuMapBySource(selectedRowsDyObject).get("prodIdList");
                List<String> skuList = MalShopCartUtil.getSkuMapBySource(selectedRowsDyObject).get("skuList");
                if (!MalShopCartUtil.isSelfGoods(prodIdList, this.getView())) {
                    return;
                }
                if (skuList.size() > 0) {
                    List<String> offList = MalJdProductUtil.checkJdSkuStates(skuList);
                    if (offList.size() > 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalShopCartPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(offList), MessageTypes.Default);
                        return;
                    }
                    List<String> malList = MalShopCartUtil.isMalGoods(selectedRowsDyObject);
                    if (malList.size() > 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u7f3a\u8d27\u6216\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalShopCartPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + MalProductUtil.formatProdNumber(malList), MessageTypes.Default);
                        return;
                    }
                }
                HashMap<String, Object> customFilter = new HashMap<String, Object>();
                customFilter.put("slectProd", MalShopCartUtil.dyoColToMap(selectedRowsDyObject));
                customFilter.put("param_amount", this.getPageCache().get("cart_select_amount"));
                ShowType showType = MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter());
                customFilter.put("opentype", showType);
                customFilter.put("fromCart", this.getPageCache().get("fromCart"));
                CloseCallBack callBack = new CloseCallBack();
                callBack.setClassName(((Object)((Object)this)).getClass().getName());
                callBack.setActionId("mal_makeorder");
                if (((DynamicObject)selectedRowsDyObject.get(0)).getString("cart_goodsource").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_makeorder", customFilter, (CloseCallBack)callBack, (ShowType)showType));
                } else {
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_jdmakeorder", customFilter, (CloseCallBack)callBack, (ShowType)showType));
                }
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6765\u6e90\u81ea\u5efa\u5546\u57ce\u548c\u4eac\u4e1c\u5546\u57ce\u7684\u5546\u54c1\u9700\u5206\u522b\u7ed3\u7b97\u3002", (String)"MalShopCartPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalShopCartPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        MalShopCartUtil.saveAllChangedQty(this.getView());
        IDataModel entryOperate = this.getModel();
        int currentIndex = entryOperate.getEntryCurrentRowIndex("cart_entryentity");
        DynamicObject row = entryOperate.getEntryRowEntity("cart_entryentity", currentIndex);
        String goodsId = row.getString("cart_goods");
        String source = row.getString("cart_goodsource");
        String caption = row.getString("cart_name");
        if (ProductSourceEnum.PRODUCTSOURCE_JD.equals((Object)source) && (null == row.getString("cart_price") || null == row.getString("cart_stock_qty") || row.getString("cart_stock_qty").isEmpty())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4ef7\u683c\u6216\u8005\u5e93\u5b58\u5f02\u5e38,\u65e0\u6cd5\u67e5\u770b\u8be6\u60c5\u3002", (String)"MalShopCartPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        MainPageUtils.showDetailPage((IFormView)this.getView(), (String)goodsId, (String)source, (String)caption, (ShowType)MainPageUtils.getShowType((IPageCache)this.getPageCache()));
    }

    public void search(SearchEnterEvent arg0) {
        MalShopCartUtil.saveAllChangedQty(this.getView());
        MalSearchUtils.toSearch("searchap", arg0, this, MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
    }
}

