/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MalTabPlugin
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillFilterGridFields();
    }

    public void fillFilterGridFields() {
        MainEntityType mainType = this.getSrcMainType();
        if (mainType != null) {
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            option.setCompatibleProductMode(true);
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)mainType, (FilterFieldBuildOption)option);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.setEntityNumber(mainType.getName());
            filterGrid.setFilterColumns(cols);
        }
    }

    private MainEntityType getSrcMainType() {
        Object group = this.getModel().getValue("group");
        String srcEntityNumber = "";
        if (null != group) {
            DynamicObject gruoupDyn = (DynamicObject)group;
            QFilter qFilter = new QFilter("id", "=", (Object)gruoupDyn.getLong("id"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_menu", (String)"entity.number", (QFilter[])qFilter.toArray());
            srcEntityNumber = dynamicObject.getString("entity.number");
        }
        return EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate oprate = (FormOperate)evt.getSource();
        String operationKey = oprate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operationKey)) {
            FilterCondition filterCondition = this.getFilter();
            this.saveFilterToText(filterCondition);
        }
        super.beforeDoOperation(evt);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String saveFilterToText(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("filter_tag", (Object)filter);
        return filter;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillFilterGridFields();
    }

    public void afterBindData(EventObject e) {
        DynamicObject gruoupDyn;
        QFilter qFilter;
        DynamicObject dynamicObject;
        String type;
        Object filterObj = this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
        super.afterBindData(e);
        Object group = this.getModel().getValue("group");
        if (null != group && !"BillFormModel".equals(type = (dynamicObject = QueryServiceHelper.queryOne((String)"mal_menu", (String)"entity.modeltype", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(gruoupDyn = (DynamicObject)group).getLong("id"))).toArray())).getString("entity.modeltype")) && !"BaseFormModel".equals(type)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }
}

