/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;

public class MalComparePriceDetaiEditPluigin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if ("cart_number".equals(arg0.getFieldName()) || "cart_name".equals(arg0.getFieldName())) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", currentIndex);
            String source = row.getString("cart_goodsource");
            String goodsId = row.getString("cart_goods");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)goodsId, (String)source, (String)row.getString("cart_name"), (ShowType)ShowType.NewWindow);
            } else {
                MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)row.getString("cart_number"), (String)source, (String)row.getString("cart_name"), (ShowType)ShowType.NewWindow);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        this.showEntryList();
        this.setTitle();
    }

    private void setTitle() {
        FormShowParameter fs = this.getView().getFormShowParameter();
        Map customParams = fs.getCustomParams();
        Object titlevisible = customParams.get("titlevisible");
        List comparePrices = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("comparePrices")), ComparePriceInfo.class);
        if ("1".equals(titlevisible)) {
            this.createTitle(true, true, comparePrices);
        } else {
            this.createTitle(false, true, comparePrices);
        }
    }

    private void createTitle(boolean isVisableTitle, boolean isVisableDetail, List<ComparePriceInfo> comparePrices) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1024);
        Container purSchemeFlexAp = (Container)this.getView().getControl("titleflexpanelap");
        String detailName = "";
        if (comparePrices == null) {
            return;
        }
        if (comparePrices.size() > 0) {
            ComparePriceInfo info = comparePrices.get(0);
            String dateFormat = DateUtil.date2str((Date)info.getCompareDate(), (String)"yyyy/MM/dd HH:mm:ss");
            detailName = ResManager.loadKDString((String)"\u6bd4\u4ef7\u4eba\uff1a{0}  \u6bd4\u4ef7\u65f6\u95f4\uff1a{1}", (String)"MalComparePriceDetaiEditPluigin_0", (String)"scm-mal-formplugin", (Object[])new Object[]{info.getComparePersonName(), dateFormat});
        }
        if (isVisableTitle && isVisableDetail) {
            this.createLabelAp(list, ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u6bd4\u4ef7\u8be6\u60c5", (String)"MalComparePriceDetaiEditPluigin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), 14, "titlelabelap");
            this.createLabelAp(list, detailName, 14, "detaillabelap");
        }
        if (!isVisableTitle && isVisableDetail) {
            this.createLabelAp(list, detailName, 16, "detaillabelap");
        }
        purSchemeFlexAp.addControls(list);
    }

    private void createLabelAp(List<Map<String, Object>> list, String name, int fonesize, String key) {
        LabelAp labelAp = new LabelAp();
        labelAp.setParentId("titleflexpanelap");
        labelAp.setId(key);
        labelAp.setName(new LocaleString(name));
        labelAp.setKey(key);
        labelAp.setFontSize(fonesize);
        labelAp.setForeColor("#333333");
        labelAp.setLineHeight("30px");
        Margin labelMargin = new Margin();
        labelMargin.setLeft("6px");
        Style labelStyle = new Style();
        labelStyle.setMargin(labelMargin);
        labelAp.setStyle(labelStyle);
        labelAp.setTextAlign("center");
        list.add(labelAp.createControl());
    }

    private void showEntryList() {
        DynamicObject row;
        int i;
        FormShowParameter fs = this.getView().getFormShowParameter();
        Map customParams = fs.getCustomParams();
        List comparePrices = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("comparePrices")), ComparePriceInfo.class);
        if (comparePrices == null) {
            return;
        }
        Long goodsId = Long.parseLong(String.valueOf(customParams.get("goodsId")));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        for (int i2 = 0; i2 < comparePrices.size(); ++i2) {
            ComparePriceInfo info = (ComparePriceInfo)comparePrices.get(i2);
            if (!info.getGoodsId().equals(goodsId)) continue;
            this.setEntryVal(vs, info, 0, defaultCurrency);
            break;
        }
        int index = 1;
        for (int i3 = 0; i3 < comparePrices.size(); ++i3) {
            ComparePriceInfo info = (ComparePriceInfo)comparePrices.get(i3);
            if (info.getGoodsId().equals(goodsId)) continue;
            this.setEntryVal(vs, info, index, defaultCurrency);
            ++index;
        }
        this.getModel().beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().beginInit();
        this.getView().updateView("entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        BigDecimal min = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        for (i = 0; i < entryCol.size(); ++i) {
            row = (DynamicObject)entryCol.get(i);
            BigDecimal price = row.getBigDecimal("cart_price");
            if (price.compareTo(min) <= 0 || min.compareTo(BigDecimal.ZERO) == 0) {
                min = price;
            }
            if (price.compareTo(max) < 0) continue;
            max = price;
        }
        for (i = 0; i < entryCol.size(); ++i) {
            row = (DynamicObject)entryCol.get(i);
            long cart_goods = row.getLong("cart_goods");
            if (!goodsId.equals(cart_goods)) {
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"cart_goods_select"});
            }
            cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"cart_remark_mh", "cart_remark_ml"});
            if (min.compareTo(max) == 0) continue;
            BigDecimal price = row.getBigDecimal("cart_price");
            if (price.compareTo(min) == 0) {
                cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"cart_remark_mh"});
                cardEntry.setChildVisible(true, row.getInt("seq") - 1, new String[]{"cart_remark_ml"});
                continue;
            }
            if (price.compareTo(max) != 0) continue;
            cardEntry.setChildVisible(false, row.getInt("seq") - 1, new String[]{"cart_remark_ml"});
            cardEntry.setChildVisible(true, row.getInt("seq") - 1, new String[]{"cart_remark_mh"});
        }
    }

    private void setEntryVal(TableValueSetter vs, ComparePriceInfo info, int i, String defaultCurrency) {
        vs.set("cart_index", (Object)(i + 1), i);
        vs.set("cart_supplier", (Object)info.getSupplierId(), i);
        vs.set("cart_price", (Object)info.getPrice(), i);
        vs.set("cart_desc", (Object)info.getGoodsDesc(), i);
        vs.set("cart_name", (Object)info.getGoodsName(), i);
        vs.set("cart_number", (Object)info.getGoodsNumber(), i);
        vs.set("cart_pic", (Object)info.getGoodsPic(), i);
        vs.set("cart_unit", (Object)info.getGoodsUnit(), i);
        vs.set("cart_goods", (Object)info.getGoodsId(), i);
        vs.set("cart_goodsource", (Object)info.getGoodsSource(), i);
        vs.set("cart_currency", (Object)defaultCurrency, i);
    }
}

