/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public class MalGoodsCommentEdit
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(MalGoodsCommentEdit.class);

    public void afterCreateNewData(EventObject e) {
        this.showGoodsInfo();
        this.showCommentInfo();
    }

    private void showGoodsInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object billno = customParams.get("billno");
        Object billdate = customParams.get("billdate");
        Object thumbnail = customParams.get("thumbnail");
        Object goodsname = customParams.get("goodsname");
        Object taxprice = customParams.get("taxprice");
        this.getModel().setValue("billno", billno);
        this.getModel().setValue("billdate", billdate);
        this.getModel().setValue("thumbnail", thumbnail);
        this.getModel().setValue("goodsname", goodsname);
        this.getModel().setValue("taxprice", taxprice);
        this.showSaleAttr(goodsId);
    }

    private void showSaleAttr(Object goodsId) {
        MalGoods malGoods = MalGoods.of((Long)((Long)goodsId));
        StringBuilder attrNames = new StringBuilder();
        if (malGoods != null) {
            List malSimilarGoods = malGoods.getMalSimilarGoodsList();
            for (MalSimilarGoods malSimilarGood : malSimilarGoods) {
                List malSaleAttrs = malSimilarGood.getMalSaleAttrs();
                for (MalSaleAttr malSaleAttr : malSaleAttrs) {
                    attrNames.append(malSaleAttr.getSaleValue()).append("\uff1b");
                }
            }
        }
        if (attrNames.length() > 0) {
            this.getModel().setValue("saleattr", (Object)attrNames.delete(attrNames.length() - 1, attrNames.length()).toString());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saleattr"});
        }
    }

    private void showCommentInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pbd_prodcomment");
        fsp.setAppId("pbd");
        fsp.setCustomParam("openStyle", (Object)"new");
        fsp.setCustomParam("commentDetails", customParams.get("commentDetails"));
        fsp.setCustomParam("prodCommentLabels", customParams.get("prodCommentLabels"));
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("commentinfocontainer");
        this.getView().showForm(fsp);
        this.getPageCache().put("childPageId", fsp.getPageId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("submit".equals(operateKey)) {
            this.submitOp();
        }
    }

    private void submitOp() {
        StringBuilder msg = new StringBuilder();
        boolean hasNull = false;
        String childPageId = this.getPageCache().get("childPageId");
        DynamicObject dynamicObject = this.getView().getViewNoPlugin(childPageId).getModel().getDataEntity();
        Map<String, Integer> typeNum = this.initCommentTypeNum();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List commentDetails = SerializationUtils.fromJsonStringToList((String)((String)customParams.get("commentDetails")), ProdCommentContentDetail.class);
        for (ProdCommentContentDetail commentDetail : commentDetails) {
            if (commentDetail.getMustInput().booleanValue() && !this.checkFieldHasValue(dynamicObject, commentDetail, typeNum)) {
                hasNull = true;
                msg.append("\"").append(commentDetail.getCommentTitle()).append("\"").append(",");
            }
            String type = commentDetail.getModuleType();
            if (!ProdCommentTypeEnum.STARS.getVal().equals(type) && !ProdCommentTypeEnum.TEXT.getVal().equals(type) && !ProdCommentTypeEnum.SCORE.getVal().equals(type)) continue;
            typeNum.put(type, typeNum.get(type) + 1);
        }
        if (hasNull) {
            msg.deleteCharAt(msg.length() - 1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4{0}\u3002", (String)"MalGoodsCommentEdit_0", (String)"scm-mal-formplugin", (Object[])new Object[]{msg.toString()}));
            return;
        }
        if (this.checkHasCommented()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u8ba2\u5355\u5df2\u8fdb\u884c\u8fc7\u8bc4\u4ef7\uff0c\u8bf7\u8fd4\u56de\u5217\u8868\u67e5\u770b\u3002", (String)"MalGoodsCommentEdit_1", (String)"scm-mal-formplugin", (Object[])new Object[]{msg.toString()}));
            return;
        }
        this.createComment(dynamicObject, commentDetails);
    }

    private boolean checkFieldHasValue(DynamicObject dynamicObject, ProdCommentContentDetail commentDetail, Map<String, Integer> typeNum) {
        String type = commentDetail.getModuleType();
        switch (ProdCommentTypeEnum.fromVal((String)type)) {
            case STARS: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.STARS.getVal());
                BigDecimal bigDecimal = dynamicObject.getBigDecimal("stars" + integer + "value");
                if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) break;
                return false;
            }
            case TEXT: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.TEXT.getVal());
                String text = dynamicObject.getString("textinput" + integer);
                if (!StringUtils.isBlank((CharSequence)text)) break;
                return false;
            }
            case LEVEL: {
                String level = dynamicObject.getString("level");
                if (!StringUtils.isBlank((CharSequence)level)) break;
                return false;
            }
            case PICTURE: {
                String pictureUrl = dynamicObject.getString("pictureurl");
                if (!StringUtils.isBlank((CharSequence)pictureUrl)) break;
                return false;
            }
            case LABEL: {
                String labelId = dynamicObject.getString("labelid");
                if (!StringUtils.isBlank((CharSequence)labelId)) break;
                return false;
            }
            case SCORE: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.SCORE.getVal());
                BigDecimal bigDecimal = dynamicObject.getBigDecimal("scoreadd" + integer);
                if (bigDecimal != null) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkHasCommented() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object order = customParams.get("orderId");
        Object commenttype = customParams.get("commenttype");
        QFilter qFilter = new QFilter("order", "=", order);
        qFilter.and("goods", "=", goodsId);
        qFilter.and("commenttype", "=", commenttype);
        return QueryServiceHelper.exists((String)"pmm_commentmanage", (QFilter[])qFilter.toArray());
    }

    private Map<String, Integer> initCommentTypeNum() {
        HashMap<String, Integer> typeAndNumMap = new HashMap<String, Integer>(8);
        typeAndNumMap.put(ProdCommentTypeEnum.STARS.getVal(), 1);
        typeAndNumMap.put(ProdCommentTypeEnum.SCORE.getVal(), 1);
        typeAndNumMap.put(ProdCommentTypeEnum.TEXT.getVal(), 1);
        return typeAndNumMap;
    }

    private void createComment(DynamicObject dynamicObject, List<ProdCommentContentDetail> commentDetails) {
        DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_commentmanage");
        this.setHeadValue(newDyn);
        this.setCommentContent(dynamicObject, commentDetails, newDyn);
        this.saveDyn(newDyn);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap paramMap = new HashMap(8);
        paramMap.put("goodsId", customParams.get("goodsId"));
        paramMap.put("billno", customParams.get("billno"));
        paramMap.put("orderId", customParams.get("orderId"));
        paramMap.put("billdate", customParams.get("billdate"));
        paramMap.put("thumbnail", customParams.get("thumbnail"));
        paramMap.put("goodsname", customParams.get("goodsname"));
        paramMap.put("spunumber", customParams.get("spunumber"));
        paramMap.put("taxprice", customParams.get("taxprice"));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_viewcomment");
        fsp.setCustomParams(paramMap);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().getParentView().showForm(fsp);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u6210\u529f\u3002", (String)"MalGoodsCommentEdit_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void setHeadValue(DynamicObject newDyn) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object supplier = customParams.get("supplier");
        Object commenttype = customParams.get("commenttype");
        Object order = customParams.get("orderId");
        if (((Boolean)this.getModel().getValue("anonymouscomment")).booleanValue()) {
            newDyn.set("privacyprotectway", (Object)"C");
        } else if ("true".equals(customParams.get("privacyprotect"))) {
            newDyn.set("privacyprotectway", (Object)"B");
        } else {
            newDyn.set("privacyprotectway", (Object)"A");
        }
        if (((Boolean)customParams.get("allowabandon")).booleanValue()) {
            newDyn.set("allowabandon", (Object)Boolean.TRUE);
        } else {
            newDyn.set("allowabandon", (Object)Boolean.FALSE);
        }
        newDyn.set("order_id", order);
        newDyn.set("goods_id", goodsId);
        newDyn.set("supplier_id", supplier);
        newDyn.set("billstatus", (Object)"A");
        newDyn.set("commenttype", commenttype);
        newDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        newDyn.set("createtime", (Object)TimeServiceHelper.now());
    }

    private void setCommentContent(DynamicObject dynamicObject, List<ProdCommentContentDetail> commentDetails, DynamicObject newDyn) {
        Map<String, Integer> typeNum = this.initCommentTypeNum();
        DynamicObjectCollection entryEntity = newDyn.getDynamicObjectCollection("entryentity");
        String labelCommentTitle = "";
        for (ProdCommentContentDetail commentDetail : commentDetails) {
            String type = commentDetail.getModuleType();
            if (this.checkFieldHasValue(dynamicObject, commentDetail, typeNum)) {
                if (ProdCommentTypeEnum.PICTURE.getVal().equals(type)) {
                    newDyn.set("pictureurl_tag", (Object)dynamicObject.getString("pictureurl"));
                } else if (ProdCommentTypeEnum.LABEL.getVal().equals(type)) {
                    labelCommentTitle = commentDetail.getCommentTitle();
                } else {
                    this.setCommentContentToEntry(commentDetail, entryEntity, dynamicObject, typeNum);
                }
            }
            if (!ProdCommentTypeEnum.STARS.getVal().equals(type) && !ProdCommentTypeEnum.TEXT.getVal().equals(type) && !ProdCommentTypeEnum.SCORE.getVal().equals(type)) continue;
            typeNum.put(type, typeNum.get(type) + 1);
        }
        DynamicObjectCollection labels = dynamicObject.getDynamicObjectCollection("labelbasedata");
        for (DynamicObject label : labels) {
            DynamicObject newEntry = entryEntity.addNew();
            newEntry.set("commenttitle", (Object)labelCommentTitle);
            newEntry.set("moduletype_id", (Object)4L);
            newEntry.set("content", (Object)label.getString("fbasedataid_id"));
        }
    }

    private void saveDyn(DynamicObject dynamicObject) {
        OperationResult auditOpRes;
        DynamicObject[] dyns = new DynamicObject[]{dynamicObject};
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult saveOpRes = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_commentmanage", (DynamicObject[])dyns, (OperateOption)option);
        if (!saveOpRes.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\u4fe1\u606f\u7ba1\u7406\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"MalGoodsCommentEdit_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)saveOpRes.getAllErrorOrValidateInfo()));
        }
        OperationResult submitOpRes = OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_commentmanage", (Object[])saveOpRes.getSuccessPkIds().toArray(), (OperateOption)option);
        if (!submitOpRes.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\u4fe1\u606f\u7ba1\u7406\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"MalGoodsCommentEdit_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)submitOpRes.getAllErrorOrValidateInfo()));
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!((Boolean)customParams.get("needaudit")).booleanValue() && !(auditOpRes = OperationServiceHelper.executeOperate((String)"audit", (String)"pmm_commentmanage", (Object[])submitOpRes.getSuccessPkIds().toArray(), (OperateOption)option)).isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\u4fe1\u606f\u7ba1\u7406\u5ba1\u6838\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"MalGoodsCommentEdit_5", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)auditOpRes.getAllErrorOrValidateInfo()));
        }
    }

    private void setCommentContentToEntry(ProdCommentContentDetail commentDetail, DynamicObjectCollection entryEntity, DynamicObject dynamicObject, Map<String, Integer> typeNum) {
        String type = commentDetail.getModuleType();
        DynamicObject newEntry = entryEntity.addNew();
        newEntry.set("commenttitle", (Object)commentDetail.getCommentTitle());
        switch (ProdCommentTypeEnum.fromVal((String)type)) {
            case STARS: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.STARS.getVal());
                BigDecimal bigDecimal = dynamicObject.getBigDecimal("stars" + integer + "value");
                newEntry.set("moduletype_id", (Object)1L);
                newEntry.set("content", (Object)bigDecimal.toString());
                break;
            }
            case TEXT: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.TEXT.getVal());
                String text = dynamicObject.getString("textinput" + integer);
                newEntry.set("moduletype_id", (Object)3L);
                newEntry.set("content", (Object)text);
                break;
            }
            case LEVEL: {
                String level = dynamicObject.getString("level");
                newEntry.set("moduletype_id", (Object)6L);
                newEntry.set("content", (Object)level);
                break;
            }
            case SCORE: {
                Integer integer = typeNum.get(ProdCommentTypeEnum.SCORE.getVal());
                BigDecimal bigDecimal = dynamicObject.getBigDecimal("scoreadd" + integer);
                newEntry.set("moduletype_id", (Object)2L);
                newEntry.set("content", (Object)bigDecimal.toString());
                break;
            }
        }
    }
}

