/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.domain.ProdCommentLabel;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public class MalGoodsViewCommentEdit
extends AbstractBillPlugIn {
    private static String First_Comment = "0";
    private static String Follow_Comment = "1";

    public void afterCreateNewData(EventObject e) {
        this.showGoodsInfo();
        this.showCommentInfo();
    }

    private void showGoodsInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object billno = customParams.get("billno");
        Object billdate = customParams.get("billdate");
        Object thumbnail = customParams.get("thumbnail");
        Object goodsname = customParams.get("goodsname");
        Object taxprice = customParams.get("taxprice");
        this.getModel().setValue("billno", billno);
        this.getModel().setValue("billdate", billdate);
        this.getModel().setValue("thumbnail", thumbnail);
        this.getModel().setValue("goodsname", goodsname);
        this.getModel().setValue("taxprice", taxprice);
        this.showSaleAttr(goodsId);
    }

    private void showSaleAttr(Object goodsId) {
        MalGoods malGoods = MalGoods.of((Long)((Long)goodsId));
        StringBuilder attrNames = new StringBuilder();
        if (malGoods != null) {
            List malSimilarGoods = malGoods.getMalSimilarGoodsList();
            for (MalSimilarGoods malSimilarGood : malSimilarGoods) {
                List malSaleAttrs = malSimilarGood.getMalSaleAttrs();
                for (MalSaleAttr malSaleAttr : malSaleAttrs) {
                    attrNames.append(malSaleAttr.getSaleValue()).append("\uff1b");
                }
            }
        }
        if (attrNames.length() > 0) {
            this.getModel().setValue("saleattr", (Object)attrNames.delete(attrNames.length() - 1, attrNames.length()).toString());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saleattr"});
        }
    }

    private void showCommentInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goodsId");
        Object orderId = customParams.get("orderId");
        QFilter qFilter = new QFilter("order", "=", orderId);
        qFilter.and("goods", "=", goodsId);
        DynamicObjectCollection comments = QueryServiceHelper.query((String)"pmm_commentmanage", (String)"id,billstatus,commenttype,abandonreason,pictureurl,pictureurl_tag,allowabandon,privacyprotectway,creator,createtime,abandonuser,abandondate,entryentity.moduletype.number moduletype,entryentity.commenttitle commenttitle,entryentity.content content", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> firstComments = new ArrayList<DynamicObject>(comments.size());
        ArrayList<DynamicObject> followComments = new ArrayList<DynamicObject>(comments.size());
        for (DynamicObject comment : comments) {
            if (First_Comment.equals(comment.getString("commenttype"))) {
                firstComments.add(comment);
                continue;
            }
            if (!Follow_Comment.equals(comment.getString("commenttype"))) continue;
            followComments.add(comment);
        }
        this.firstCommentView(firstComments);
        this.followCommentView(followComments);
    }

    private void firstCommentView(List<DynamicObject> firstComments) {
        if (firstComments.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commentinfocontainer"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u6682\u65e0\u8bc4\u4ef7\u3002", (String)"MalGoodsViewCommentEdit_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.commentView(firstComments, "first");
    }

    private void followCommentView(List<DynamicObject> followComments) {
        if (followComments.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"followcontainer"});
            return;
        }
        this.commentView(followComments, "follow");
    }

    private void commentView(List<DynamicObject> comments, String commentType) {
        List<ProdCommentContentDetail> commentDetails = this.getCommentDetail(comments);
        List<ProdCommentLabel> prodCommentLabels = this.getProdCommentLabels(comments);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pbd_prodcomment");
        fsp.setCustomParam("openStyle", (Object)"view");
        fsp.setCustomParam("commentDetails", (Object)SerializationUtils.toJsonString(commentDetails));
        fsp.setCustomParam("prodCommentLabels", (Object)SerializationUtils.toJsonString(prodCommentLabels));
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey(commentType + "commentcontainer");
        this.getView().showForm(fsp);
        DynamicObject dynamicObject = comments.get(0);
        this.getModel().setValue(commentType + "commentdate", (Object)dynamicObject.getDate("createtime"));
        this.getView().updateView(commentType + "commentdate");
        String billstatus = dynamicObject.getString("billstatus");
        if ("D".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{commentType + "abandoncontainer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{commentType + "abandon"});
            this.getModel().setValue(commentType + "abandonuser", (Object)dynamicObject.getLong("abandonuser"));
            this.getModel().setValue(commentType + "abandondate", (Object)dynamicObject.getDate("abandondate"));
            this.getModel().setValue(commentType + "abandonreason", (Object)dynamicObject.getString("abandonreason"));
            this.getView().setVisible(Boolean.FALSE, new String[]{commentType + "abandonbutton"});
            this.getView().updateView(commentType + "abandonuser");
            this.getView().updateView(commentType + "abandondate");
            this.getView().updateView(commentType + "abandonreason");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{commentType + "abandoncontainer"});
            if (UserServiceHelper.getCurrentUserId() != dynamicObject.getLong("creator") || !dynamicObject.getBoolean("allowabandon")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{commentType + "abandonbutton"});
            }
        }
        this.getPageCache().put(commentType + "BillIds", dynamicObject.getString("id"));
    }

    private List<ProdCommentContentDetail> getCommentDetail(List<DynamicObject> comments) {
        ArrayList<ProdCommentContentDetail> prodCommentContentDetails = new ArrayList<ProdCommentContentDetail>(comments.size());
        for (DynamicObject comment : comments) {
            ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
            prodCommentContentDetail.setId(Long.valueOf(comment.getLong("id")));
            prodCommentContentDetail.setCommentTitle(comment.getString("commenttitle"));
            prodCommentContentDetail.setModuleType(comment.getString("moduletype"));
            prodCommentContentDetail.setValue(comment.getString("content"));
            prodCommentContentDetails.add(prodCommentContentDetail);
        }
        ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
        String pictureUrl = comments.get(0).getString("pictureurl_tag");
        prodCommentContentDetail.setId(Long.valueOf(comments.get(0).getLong("id")));
        prodCommentContentDetail.setModuleType(ProdCommentTypeEnum.PICTURE.getVal());
        prodCommentContentDetail.setValue(pictureUrl);
        prodCommentContentDetails.add(prodCommentContentDetail);
        return prodCommentContentDetails;
    }

    private List<ProdCommentLabel> getProdCommentLabels(List<DynamicObject> comments) {
        List labelIds = comments.stream().filter(k -> ProdCommentTypeEnum.LABEL.getVal().equals(k.getString("moduletype"))).map(k -> Long.valueOf(k.getString("content"))).collect(Collectors.toList());
        ArrayList<ProdCommentLabel> prodCommentLabels = new ArrayList<ProdCommentLabel>(labelIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pmm_commentlabel", (String)"id,name,labeltype", (QFilter[])new QFilter[]{new QFilter("id", "in", labelIds)}, (String)"id");){
            dataSet.forEach(row -> {
                ProdCommentLabel prodCommentLabel = new ProdCommentLabel();
                prodCommentLabel.setId(row.getLong("id"));
                prodCommentLabel.setName(row.getString("name"));
                prodCommentLabel.setLabelType(row.getString("labeltype"));
                prodCommentLabels.add(prodCommentLabel);
            });
        }
        return prodCommentLabels;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("firstabandon".equals(operateKey)) {
            this.openAbandonPage("first");
        }
        if ("followabandon".equals(operateKey)) {
            this.openAbandonPage("follow");
        }
    }

    private void openAbandonPage(String commentType) {
        String billId = this.getPageCache().get(commentType + "BillIds");
        QFilter qFilter = new QFilter("id", "in", (Object)Long.valueOf(billId));
        qFilter.and("billstatus", "=", (Object)"D");
        boolean exists = QueryServiceHelper.exists((String)"pmm_commentmanage", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u4f5c\u5e9f\u7684\u8bc4\u4ef7\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f5c\u5e9f\u3002", (String)"MalGoodsViewCommentEdit_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap paramMap = new HashMap(8);
        ArrayList<Long> billIds = new ArrayList<Long>(8);
        billIds.add(Long.valueOf(billId));
        paramMap.put("billIds", billIds);
        OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pbd_commentabandon", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().updateView();
        }
    }
}

