/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class MalMenuEditPlugin
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillFilterGridFields();
    }

    public void fillFilterGridFields() {
        MainEntityType mainType = this.getSrcMainType();
        if (mainType != null) {
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            option.setCompatibleProductMode(true);
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)mainType, (FilterFieldBuildOption)option);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.setEntityNumber(mainType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView("filtergrid");
        }
    }

    private MainEntityType getSrcMainType() {
        Object entity = this.getModel().getValue("entity");
        String srcEntityNumber = "";
        if (null != entity) {
            DynamicObject entityDyn = (DynamicObject)entity;
            srcEntityNumber = entityDyn.getString("number");
            return EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate oprate = (FormOperate)evt.getSource();
        String operationKey = oprate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operationKey)) {
            FilterCondition filterCondition = this.getFilter();
            this.saveFilterToText(filterCondition);
        }
        super.beforeDoOperation(evt);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String saveFilterToText(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("filter_tag", (Object)filter);
        return filter;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillFilterGridFields();
    }

    public void afterBindData(EventObject e) {
        Object entity;
        super.afterBindData(e);
        Object filterObj = this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
        if (null != (entity = this.getModel().getValue("entity"))) {
            DynamicObject entityDyn = (DynamicObject)entity;
            String type = entityDyn.getString("modeltype");
            if (!"BillFormModel".equals(type) && !"BaseFormModel".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("entity".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (null != newValue) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                this.fillFilterGridFields();
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            }
        }
    }
}

