/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SupplierChatEngineUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.business.service.MalGoodsMonitorLogService;
import kd.scm.mal.common.aftersale.bean.AfterSaleValidateInfo;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import kd.scm.mal.formplugin.util.MalOrderEntityUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MalOrderEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String AFTERSALE = "aftersale";
    public static final String BILLID = "billid";
    private static final String PM_PURAPPLYBILL = "pm_purapplybill";

    public void initialize() {
        super.initialize();
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit purType = (BasedataEdit)this.getView().getControl("purtype");
        purType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("cancelorder".equals(operateKey)) {
            this.cancelOrder(args);
        }
        if ("submit".equals(operateKey)) {
            this.checkSubmit(args);
        }
    }

    private void checkSubmit(BeforeDoOperationEventArgs args) {
        MalGoodsMonitorLogService malGoodsMonitorLogService;
        Collection goodsMonitorLogs;
        if (null != this.getPageCache().get("continue")) {
            this.getPageCache().remove("continue");
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
        long orgId = RequestContext.get().getOrgId();
        Object deporg = this.getModel().getValue("deporg");
        if (null != deporg) {
            orgId = ((DynamicObject)deporg).getLong("id");
        }
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(16);
        for (DynamicObject row : entryCols) {
            if (null == row.get("goods")) continue;
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)row.getLong("goods.id"), (String)dataEntity.getString("platform"), (BigDecimal)BigDecimal.ONE, null, (Long)orgId);
            malMatGoodsInitParams.add(param);
        }
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
        ArrayList<String> goodIds = new ArrayList<String>(16);
        ArrayList<Long> goodsPoolIds = new ArrayList<Long>(16);
        for (Map.Entry map : malGoodsMap.entrySet()) {
            MalGoods malGoods = (MalGoods)map.getValue();
            if (null == malGoods) continue;
            goodIds.add(malGoods.getProductId());
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getProductSource())) continue;
            goodsPoolIds.add(malGoods.getGoodsInfo().getProdPoolId());
        }
        if (goodIds.size() > 0 && (goodsMonitorLogs = (malGoodsMonitorLogService = new MalGoodsMonitorLogService()).getGoodsMonitorLogs(goodIds, goodsPoolIds)) != null && goodsMonitorLogs.size() > 0) {
            String disableDeatialMsg = malGoodsMonitorLogService.getDisableDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)disableDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u7981\u6b62\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 \u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalOrderEditPlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, disableDeatialMsg, MessageTypes.Default);
                args.setCancel(true);
                return;
            }
            String notifyDeatialMsg = malGoodsMonitorLogService.getNotifyDetailMsg(goodsMonitorLogs);
            if (!StringUtils.isEmpty((CharSequence)notifyDeatialMsg)) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalOrderEditPlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u4e0b\u5355", (String)"MalOrderEditPlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, notifyDeatialMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("notifymsg", (IFormPlugin)this), btnNameMaps);
                args.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"cancel", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("cancel", "true");
            this.getView().invokeOperation("cancelorder");
        }
        if (StringUtils.equals((CharSequence)"notifymsg", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("continue", "true");
            this.getView().invokeOperation("submit");
        }
    }

    private void cancelOrder(BeforeDoOperationEventArgs args) {
        boolean isallcancelFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"ispartcancel").and(new QFilter("paramvalue", "=", (Object)"N"))});
        DynamicObject order = this.getModel().getDataEntity(true);
        String platform = order.getString("platform");
        String msg = ResManager.loadKDString((String)"\u8ba2\u5355\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d6\u6d88\uff1f", (String)"MalOrderEditPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        if (!(ApiConfigUtil.hasCQScmConfig() || !isallcancelFlag && (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)))) {
            msg = ResManager.loadKDString((String)"\u8ba2\u5355\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d6\u6d88\uff1f", (String)"MalOrderEditPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        } else {
            String erpbillstatus;
            String erplogstatus;
            msg = ResManager.loadKDString((String)"\u4ec5\u81ea\u5efa\u3001\u4eac\u4e1c\u3001\u4eac\u4e1c\u5de5\u4e1a\u54c1\u652f\u6301\u6309\u5206\u5f55\u53d6\u6d88\u8ba2\u5355\uff0c\u5176\u4ed6\u7535\u5546\u5c06\u53d6\u6d88\u6574\u4e2a\u8ba2\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderEditPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            FormOperate source = (FormOperate)args.getSource();
            OperateOption option = source.getOption();
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectrows = grid.getEntryState().getSelectedRows();
            ArrayList<String> entryIdList = new ArrayList<String>(16);
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("entryentity");
            for (int index : selectrows) {
                DynamicObject row = (DynamicObject)entryCol.get(index);
                String entryId = row.getString("id");
                String entrystatus = row.getString("entrystatus");
                if (StringUtils.isEmpty((CharSequence)entryId) || "F".equals(entrystatus)) continue;
                entryIdList.add(entryId);
            }
            if (selectrows.length > 0 && entryIdList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f\u72b6\u6001\u7684\u8ba2\u5355\u5206\u5f55\u4e0d\u5141\u8bb8\u53d6\u6d88\u3002", (String)"MalOrderEditPlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billsatus = order.getString("billstatus");
            if ("A".equals(billsatus)) {
                msg = ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u7684\u8ba2\u5355\u53ea\u80fd\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderEditPlugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            }
            if ("B".equals(billsatus)) {
                msg = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7684\u8ba2\u5355\u53ea\u80fd\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderEditPlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            }
            HashSet<String> submitOrderNos = new HashSet<String>(16);
            HashSet<String> confirmOrderNos = new HashSet<String>(16);
            for (DynamicObject row : entryCol) {
                if (!entryIdList.contains(row.getString("id")) || StringUtils.isEmpty((CharSequence)row.getString("erpbillnumber"))) continue;
                erplogstatus = row.getString("erplogstatus");
                erpbillstatus = row.getString("erpbillstatus");
                if ("A".equals(erpbillstatus) || "B".equals(erpbillstatus)) {
                    submitOrderNos.add(row.getString("erpbillnumber"));
                    continue;
                }
                if (!"H".equals(erplogstatus)) continue;
                confirmOrderNos.add(row.getString("erpbillnumber"));
            }
            if (confirmOrderNos.size() > 0 && submitOrderNos.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u5f20\u4e0d\u540c\u72b6\u6001\u7684\u91c7\u8d2d\u8ba2\u5355\u540c\u65f6\u53d6\u6d88\u3002", (String)"MalOrderEditPlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (DynamicObject row : entryCol) {
                if (!entryIdList.contains(row.getString("id"))) continue;
                erplogstatus = row.getString("erplogstatus");
                erpbillstatus = row.getString("erpbillstatus");
                if ("A".equals(erpbillstatus) || "B".equals(erpbillstatus)) {
                    msg = ResManager.loadKDString((String)"\u5b58\u5728\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u662f\u5df2\u63d0\u4ea4\u7684\u5206\u5f55\uff0c\u8be5\u5206\u5f55\u7684\u8ba2\u5355\u5c06\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderEditPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (!"H".equals(erplogstatus)) continue;
                msg = ResManager.loadKDString((String)"\u4ec5\u81ea\u5efa\u3001\u4eac\u4e1c\u3001\u4eac\u4e1c\u5de5\u4e1a\u54c1\u652f\u6301\u6309\u5206\u5f55\u53d6\u6d88\u8ba2\u5355\uff0c\u5176\u4ed6\u7535\u5546\u5c06\u53d6\u6d88\u6574\u4e2a\u8ba2\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderEditPlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                break;
            }
            option.setVariableValue("entryIds", SerializationUtils.toJsonString(entryIdList));
            source.setOption(option);
        }
        if (null == this.getPageCache().get("cancel")) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("cancel", (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
            args.setCancel(true);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String billNo;
        IDataModel entryOperate = this.getModel();
        int selectRowIndex = args.getRowIndex();
        if (StringUtils.equals((CharSequence)"erpbillnumber", (CharSequence)args.getFieldName())) {
            String billNo2 = entryOperate.getEntryRowEntity("entryentity", selectRowIndex).getString("erpbillnumber");
            if (ApiConfigUtil.hasCQScmConfig() && StringUtils.isNotBlank((CharSequence)billNo2) && !MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)this.getModel().getDataEntity().getDynamicObject("businesstype"))) {
                this.showOrder(billNo2, "pm_purorderbill");
            } else {
                this.showOrder(billNo2, "pur_order");
            }
        }
        DynamicObject row = entryOperate.getEntryRowEntity("entryentity", selectRowIndex);
        DynamicObject goods = (DynamicObject)row.get("goods");
        String source = goods.getString("source");
        if (StringUtils.equals((CharSequence)"goods", (CharSequence)args.getFieldName())) {
            String goodsId = null;
            goodsId = EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) ? goods.getString("id") : goods.getString("number");
            String caption = goods.getString("name");
            boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
            if (defaultMalVersion) {
                MainPageUtils.showNewDetailPage((IFormView)this.getView(), (String)goodsId, (String)source, (String)caption, (ShowType)ShowType.NewWindow);
            } else {
                MainPageUtils.showDetailPage((IFormView)this.getView(), (String)goodsId, (String)source, (String)caption, (ShowType)MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter()));
            }
        }
        if (StringUtils.equals((CharSequence)"protocolno", (CharSequence)args.getFieldName()) && StringUtils.isNotBlank((CharSequence)(billNo = entryOperate.getEntryRowEntity("entryentity", selectRowIndex).getString("protocolno")))) {
            this.showPortocol(billNo, "pmm_protocol");
        }
        if (StringUtils.equals((CharSequence)"compareresult", (CharSequence)args.getFieldName())) {
            Long orgId = RequestContext.get().getOrgId();
            if (null != this.getModel().getValue("deporg")) {
                orgId = ((DynamicObject)this.getModel().getValue("deporg")).getLong("id");
            }
            Long goodsId = goods.getLong("id");
            Object pricemonitortab = this.getModel().getValue("pricemonitortab");
            ArrayList<String> invisibletabs = new ArrayList<String>(16);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"mal_order", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List entitys = entityMetadata.getEntitys();
            for (String[] entity : entitys) {
                if (!"mal_order".equals(entity.getKey())) continue;
                List items = entity.getItems();
                for (EntityItem item : items) {
                    if (!(item instanceof MulComboField) || !"pricemonitortab".equals(item.getKey())) continue;
                    pricemonitortab = ((MulComboField)item).getDefValue();
                }
            }
            if (null != pricemonitortab && !StringUtils.isEmpty((CharSequence)String.valueOf(pricemonitortab))) {
                String[] tabs;
                for (String tab : tabs = String.valueOf(pricemonitortab).split(",")) {
                    if (StringUtils.isEmpty((CharSequence)tab)) continue;
                    invisibletabs.add(tab);
                }
            }
            MalPriceMonitorService service = new MalPriceMonitorService();
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam((Long)goodsId, (String)source, (BigDecimal)BigDecimal.ONE, null, (Long)orgId);
            param.setCompareId(Long.valueOf(row.getLong("compareid")));
            malMatGoodsInitParams.add(param);
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            if (!service.checkIsShowPriceMonitorForm((MalGoods)malGoodsMap.get(goodsId), invisibletabs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6bd4\u4ef7\u8bb0\u5f55\u3001\u540c\u6b3e\u5546\u54c1\u3001\u534a\u5e74\u5185\u7684\u5386\u53f2\u4ef7\u683c\u548c\u672c\u7ec4\u7ec7\u4ea4\u6613\u4ef7\u6570\u636e\u3002", (String)"MalOrderEditPlugin_22", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mal_pricemonitordetail");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
            detailParamMap.put("goodsId", goodsId);
            detailParamMap.put("source", source);
            detailParamMap.put("org", orgId);
            detailParamMap.put("compareid", row.getLong("compareid"));
            detailParamMap.put("sourceForm", this.getModel().getDataEntity().getDataEntityType().getName());
            detailParamMap.put("invisibletabs", SerializationUtils.toJsonString(invisibletabs));
            detailParamMap.put("purchase_org", this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
            showParameter.setCustomParams(detailParamMap);
            this.getView().showForm(showParameter);
            return;
        }
    }

    private void packageData(PackageDataEvent event) {
        String compareresult = event.getRowData().getString("compareresult");
        if ("A".equals(compareresult)) {
            event.getNoLinkKey().add("compareresult");
        }
    }

    private void showPortocol(String billNo, String entityKey) {
        DynamicObject purtocolId = QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (purtocolId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u534f\u8bae\u7b7e\u8ba2\u3002", (String)"MalOrderEditPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityKey);
        showParameter.setPkId((Object)purtocolId.getLong("id"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showOrder(String billNo, String entityKey) {
        DynamicObject purOrderId = QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (purOrderId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"MalOrderEditPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityKey);
        showParameter.setPkId((Object)purOrderId.getLong("id"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        int rowIndex = changedData[0].getRowIndex();
        if (StringUtils.equals((CharSequence)"qty", (CharSequence)fieldKey)) {
            BigDecimal newVal;
            DynamicObject rowEntity = model.getEntryRowEntity("entryentity", rowIndex);
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            if (oldVal.compareTo(newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue())) == 0) {
                return;
            }
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                rowEntity.set("qty", (Object)oldVal);
            } else {
                BigDecimal cacheQty;
                String qtyStr = this.getPageCache().get("qty");
                if (null != qtyStr && newVal.compareTo(cacheQty = CommonUtil.getBigDecimalPro((Object)qtyStr)) == 0) {
                    return;
                }
                boolean isExistFee = this.getIsExistFee(rowEntity);
                if (isExistFee) {
                    this.getPageCache().put("qty", String.valueOf(changedData[0].getOldValue()));
                    rowEntity.set("qty", (Object)oldVal);
                    String msg = ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u9644\u52a0\u8d39\u8fd0\u8d39\u5df2\u5206\u644a\uff0c\u4f60\u4e0d\u652f\u6301\u91cd\u65b0\u4fee\u6539\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u3002", (String)"MalOrderEditPlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                this.getPageCache().remove("qty");
                this.setLadPrice(rowEntity, rowIndex);
                this.CalBill();
            }
        }
        if (StringUtils.equals((CharSequence)"goods", (CharSequence)fieldKey)) {
            DynamicObject oldValue = (DynamicObject)changedData[0].getOldValue();
            DynamicObject newValue = (DynamicObject)changedData[0].getNewValue();
            DynamicObject rowEntity = model.getEntryRowEntity("entryentity", rowIndex);
            if (null == newValue || oldValue != null && StringUtils.equals((CharSequence)oldValue.getString("id"), (CharSequence)newValue.getString("id"))) {
                return;
            }
            rowEntity.set("goodsdesc", newValue.get("description"));
            rowEntity.set("goodsimg", newValue.get("thumbnail"));
            rowEntity.set("supplier", newValue.get("supplier"));
            rowEntity.set("unit", newValue.get("unit"));
            rowEntity.set("taxprice", newValue.get("shopprice"));
            rowEntity.set("price", newValue.get("price"));
            rowEntity.set("taxrate", newValue.get("taxrate"));
            this.CalBill();
        }
    }

    private void setLadPrice(DynamicObject rowEntity, int rowIndex) {
        DynamicObject goods = rowEntity.getDynamicObject("goods");
        DynamicObject deporg = (DynamicObject)this.getModel().getValue("deporg");
        Object platform = this.getModel().getValue("platform");
        if (null != goods && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
            BigDecimal taxprice = rowEntity.getBigDecimal("taxprice");
            MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)goods.getLong("id"), (String)EcPlatformEnum.ECPLATFORM_SELF.getVal(), (BigDecimal)rowEntity.getBigDecimal("qty"), null, (Long)deporg.getLong("id")), (boolean)false, (boolean)false);
            if (null != malGoods) {
                if (taxprice.compareTo(malGoods.getTaxPrice()) == 0) {
                    return;
                }
                this.getModel().setValue("taxprice", (Object)malGoods.getTaxPrice(), rowIndex);
            }
        }
    }

    private boolean getIsExistFee(DynamicObject rowEntity) {
        DynamicObject goods = rowEntity.getDynamicObject("goods");
        BigDecimal freight = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("freight"));
        Object platform = this.getModel().getValue("platform");
        if (null != goods && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
            DynamicObject prod;
            long goodsId = goods.getLong("id");
            QFilter qFilter = new QFilter("id", "=", (Object)goodsId);
            DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"surchargeid", (QFilter[])qFilter.toArray());
            boolean issuccess = false;
            if (prods.size() > 0 && !(prod = (DynamicObject)prods.get(0)).getString("surchargeid").isEmpty()) {
                issuccess = true;
            }
            if (freight.compareTo(BigDecimal.ZERO) != 0) {
                issuccess = true;
            }
            return issuccess;
        }
        return false;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String status = (String)this.getModel().getValue("billstatus");
        String platform = (String)this.getModel().getValue("platform");
        String jdOrderId = (String)this.getModel().getValue("jdorderid");
        if (StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.CANCELED.getVal()) || StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getVal()) && StringUtils.equals((CharSequence)platform, (CharSequence)ProductSourceEnum.PRODUCTSOURCE_JD.getVal()) && StringUtils.isNotBlank((CharSequence)jdOrderId)) {
            FormShowParameter param = ((BillView)e.getSource()).getFormShowParameter();
            param.setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblcancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_print"});
        }
    }

    public void CalBill() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        Cal4DynamicObj.calByQty((DynamicObject)bill, (String)"entryentity");
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        BillModel model = (BillModel)this.getModel();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null == operationResult || !operationResult.isSuccess()) {
            if (operateKey.equals("cancelorder")) {
                this.getPageCache().remove("cancel");
            }
            return;
        }
        if ("audit".equals(operateKey)) {
            model.load(model.getPKValue());
            this.getView().updateView("entryentity");
        }
        switch (operateKey) {
            case "aftersale": {
                HashMap paramMap = new HashMap();
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectrows = grid.getEntryState().getSelectedRows();
                if (null == selectrows || selectrows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5206\u5f55\u7533\u8bf7\u552e\u540e\u3002", (String)"MalOrderEditPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<String> entryIDs = new ArrayList<String>(selectrows.length);
                for (int index : selectrows) {
                    DynamicObject entryprod = model.getEntryRowEntity("entryentity", index);
                    entryIDs.add(entryprod.getPkValue().toString());
                }
                AfterSaleValidateInfo afterSaleValidateInfo = MalOrderEntityUtil.afterSaleCheck(entryIDs);
                Map afterSaleCheckMap = afterSaleValidateInfo.getMalOrderIdEntryIdsMap();
                if (!afterSaleValidateInfo.getErrorInfos().isEmpty()) {
                    this.getView().showTipNotification((String)afterSaleValidateInfo.getErrorInfos().get(0));
                    return;
                }
                MutexHelper.require((String)"mal_order", (Object)this.getModel().getDataEntity().getPkValue(), (String)AFTERSALE, (StringBuilder)new StringBuilder("lock"));
                this.getPageCache().put("lockId", this.getModel().getDataEntity().getPkValue().toString());
                Map.Entry afterSaleCheckEntry = afterSaleCheckMap.entrySet().iterator().next();
                String malOrderEntryIds = String.join((CharSequence)",", (Iterable)afterSaleCheckEntry.getValue());
                paramMap.put("malOrderId", afterSaleCheckEntry.getKey());
                paramMap.put("malOrderEntry", malOrderEntryIds);
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_aftersale", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, AFTERSALE), (ShowType)ShowType.Modal));
                break;
            }
            case "audit": {
                if (ShowType.Modal != this.getView().getFormShowParameter().getOpenStyle().getShowType()) break;
                MainPageUtils.jumpToOrder((IFormView)this.getView(), (ShowType)ShowType.NewWindow);
                break;
            }
            case "wechat": {
                EntryGrid grids = (EntryGrid)this.getView().getControl("entryentity");
                int[] rowCollection = grids.getSelectRows();
                if (rowCollection.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalOrderEditPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = new DynamicObject();
                Long id = 0L;
                int index = 0;
                for (int row : rowCollection) {
                    dynamicObject = this.getView().getModel().getEntryRowEntity("entryentity", row);
                    if (index == 0) {
                        id = dynamicObject.getLong("supplier.id");
                    }
                    if (!id.equals(dynamicObject.getLong("supplier.id"))) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8ba2\u5355\u6240\u5c5e\u5546\u5bb6\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MalOrderEditPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ++index;
                }
                DynamicObject supplier = (DynamicObject)dynamicObject.get("supplier");
                Map resultMap = SupplierChatEngineUtil.createSupplierChat((DynamicObject)supplier);
                if ("false".equals(resultMap.get("succed"))) {
                    this.getView().showMessage(resultMap.get("message").toString());
                }
                if (!"true".equals(resultMap.get("succed"))) break;
                YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
                yzj.setView(this.getView());
                HashMap mData = new HashMap();
                mData.put("openId", resultMap.get("data"));
                mData.put("userName", "");
                mData.put("chattype", "chat_pc");
                yzj.yzjInterface("createAndChat", mData);
                break;
            }
            case "cancelorder": {
                if (null == this.getPageCache().get("cancel")) break;
                this.getPageCache().remove("cancel");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!StringUtils.isNotBlank((CharSequence)closedCallBackEvent.getActionId())) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "aftersale": {
                MutexHelper.release((String)"mal_order", (String)AFTERSALE, (String)this.getPageCache().get("lockId"));
                Object condition = closedCallBackEvent.getReturnData();
                if (condition == null) {
                    return;
                }
                Map map = condition instanceof Map ? (Map)condition : new HashMap();
                Long billId = (Long)map.get(BILLID);
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"mal_returnreq", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)billId, null, null));
            }
        }
    }

    public void afterBindData(EventObject e) {
        boolean defaultMalVersion;
        super.afterBindData(e);
        this.getView().setVisible(MalOrderUtil.getDefaultMalVersion() ? Boolean.FALSE : Boolean.TRUE, new String[]{"jdorderid", "jdorderstatus", "paytype", "jdorder", "jdchildorderid", "jdchildorderstatus", "jdstate", "jdinvoicestate", "jdinvoiceresult", "paycodeid"});
        this.getView().setVisible(MalOrderUtil.getDefaultMalVersion() ? Boolean.TRUE : Boolean.FALSE, new String[]{"ecorderid", "orderstatus", "malpaytype", "order", "childorderid", "childorderstatus", "state", "invoicestate", "invoiceresult", "paycode", "note"});
        if (MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"malinvtype"});
            Object platform = this.getModel().getValue("platform");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"malinvtype"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"malinvtype"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"malinvtype"});
        }
        if (MalOrderUtil.getDefaultMalVersion()) {
            DynamicObject malOrder = this.getModel().getDataEntity();
            if (!MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)malOrder.getDynamicObject("businesstype"))) {
                BasedataEdit matEdit = (BasedataEdit)this.getControl("material");
                matEdit.setMustInput(true);
            }
            DynamicObjectCollection entity = (DynamicObjectCollection)malOrder.get("entryentity");
            String source = malOrder.getString("platform");
            if (!StringUtils.isEmpty((CharSequence)source) && !source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                if (!(source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()) || EcPlatformEnum.ECPLATFORM_XY.getVal().equalsIgnoreCase(source))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"state"});
                }
                ArrayList<Long> pkIds = new ArrayList<Long>(entity.size());
                for (DynamicObject dynamicObject : entity) {
                    pkIds.add(dynamicObject.getLong("order_id"));
                }
                String selectFields = "entryentity.goods.number sku,suborderstate status,invoicestate,invoiceresult";
                if (EcPlatformEnum.ECPLATFORM_JD.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,jdchildorderstatus status,invoicestate,jdstate state,invoiceresult";
                }
                if (EcPlatformEnum.ECPLATFORM_XY.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,orderstate status,invoicestate,state,invoiceresult";
                }
                if (EcPlatformEnum.ECPLATFORM_CG.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,state status,invoicestate,invoiceresult";
                }
                if (EcPlatformEnum.ECPLATFORM_DL.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,state status,invoicestate,invoiceresult";
                }
                if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,state status,invoicestate,invoiceresult";
                }
                if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equalsIgnoreCase(source)) {
                    selectFields = "entryentity.goods.number sku,state status,invoicestate,invoiceresult";
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkIds)};
                DynamicObjectCollection orderCol = QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)selectFields, (QFilter[])qFilters);
                HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>(entity.size());
                for (DynamicObject order : orderCol) {
                    HashMap<String, String> detail = (HashMap<String, String>)map.get(order.getString("sku"));
                    if (MapUtils.isEmpty((Map)detail)) {
                        detail = new HashMap<String, String>(2);
                    }
                    detail.put("status", order.getString("status"));
                    detail.put("invoicestate", order.getString("invoicestate"));
                    detail.put("invoiceresult", order.getString("invoiceresult"));
                    if (EcPlatformEnum.ECPLATFORM_JD.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_XY.getVal().equalsIgnoreCase(source)) {
                        detail.put("state", order.getString("state"));
                    }
                    map.put(order.getString("sku"), detail);
                }
                for (DynamicObject dynamicObject : entity) {
                    String sku = dynamicObject.getString("goods.number");
                    if (null != map.get(sku) && !StringUtils.isEmpty((CharSequence)((CharSequence)((Map)map.get(sku)).get("status")))) {
                        dynamicObject.set("childorderstatus", (Object)EmalStatusUtil.getEmalStatusName((String)((String)((Map)map.get(sku)).get("status")), (String)"1", (String)source));
                    }
                    if (null != map.get(sku) && !StringUtils.isEmpty((CharSequence)((CharSequence)((Map)map.get(sku)).get("invoicestate")))) {
                        String invoiceStateName = EmalStatusUtil.getCqNameByCqNumber((String)((String)((Map)map.get(sku)).get("invoicestate")), (String)"3", (String)source);
                        dynamicObject.set("invoicestate", (Object)invoiceStateName);
                        dynamicObject.set("invoiceresult", ((Map)map.get(sku)).get("invoiceresult"));
                    }
                    if (null == map.get(sku) || StringUtils.isEmpty((CharSequence)((CharSequence)((Map)map.get(sku)).get("state")))) continue;
                    switch ((String)((Map)map.get(sku)).get("state")) {
                        case "0": {
                            dynamicObject.set("state", (Object)ResManager.loadKDString((String)"\u65b0\u5efa", (String)"MalOrderEditPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        case "1": {
                            dynamicObject.set("state", (Object)ResManager.loadKDString((String)"\u59a5\u6295", (String)"MalOrderEditPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        case "2": {
                            dynamicObject.set("state", (Object)ResManager.loadKDString((String)"\u62d2\u6536", (String)"MalOrderEditPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            break;
                        }
                    }
                }
            }
            this.getModel().setDataChanged(false);
            this.getView().updateView("entryentity");
        }
        if (defaultMalVersion = MalOrderParamUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"compareresult", "compareremark"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"compareresult", "compareremark"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Long[] idList;
        DynamicObject dataEntity;
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"tbllogistics")) {
            this.showLogistics((String)this.getModel().getValue("billno"), (String)this.getModel().getValue("platform"));
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_trackup")) {
            dataEntity = this.getModel().getDataEntity();
            idList = new Long[]{dataEntity.getLong("id")};
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("botp_track_only_dirt_link", "true");
            List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)"mal_order", (String)"mal_order", (Long[])idList, (Long[])idList, (OperateOption)operateOption);
            if (bfRowList.isEmpty()) {
                ArrayList<Long> erpSourceIdList = new ArrayList<Long>();
                QFilter idFilter = new QFilter("id", "in", (Object)idList);
                DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)"mal_order", (String)"id,entryentity.erpsourceid erpsourceid,entryentity.erpsourcebilltype erpsourcebilltype,deporg", (QFilter[])new QFilter[]{idFilter});
                if (null != dyoCollection && !dyoCollection.isEmpty()) {
                    for (DynamicObject dyo : dyoCollection) {
                        if (!PM_PURAPPLYBILL.equals(dyo.getString("erpsourcebilltype")) || 0L == dyo.getLong("erpsourceid")) continue;
                        erpSourceIdList.add(dyo.getLong("erpsourceid"));
                    }
                }
                if (!erpSourceIdList.isEmpty()) {
                    ArrayList noPermissionList = new ArrayList();
                    ArrayList<Long> purApplyBillIdSet = new ArrayList<Long>(erpSourceIdList.size());
                    DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)PM_PURAPPLYBILL, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", erpSourceIdList)});
                    if (dyoCol != null && !dyoCol.isEmpty()) {
                        for (DynamicObject dyo : dyoCol) {
                            String appId = MalBizFowUtil.getPcAppId((String)PM_PURAPPLYBILL);
                            long deporg = dyo.getLong("org");
                            int hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)deporg, (String)"15", (String)appId, (String)PM_PURAPPLYBILL, (String)"47150e89000000ac");
                            if (hasPermResult != 1) {
                                noPermissionList.add(dyo.getLong("id"));
                                continue;
                            }
                            purApplyBillIdSet.add(dyo.getLong("id"));
                        }
                    }
                    if (purApplyBillIdSet.isEmpty()) {
                        if (!noPermissionList.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u7533\u8bf7\u5355\u201d\u7533\u8bf7\u7ec4\u7ec7\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderEditPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderEditPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                        }
                        evt.setCancel(true);
                        return;
                    }
                    if (purApplyBillIdSet.size() == 1) {
                        OpenFormUtil.openBillPage((IFormView)this.getView(), (String)PM_PURAPPLYBILL, purApplyBillIdSet.get(0), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                    } else {
                        OpenFormUtil.openListPage((IFormView)this.getView(), (String)PM_PURAPPLYBILL, (ShowType)ShowType.MainNewTabPage, null, (QFilter)new QFilter("id", "in", purApplyBillIdSet), (CloseCallBack)new CloseCallBack());
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderEditPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
                evt.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_trackdown")) {
            BFRowLinkDownNode bfRowLinkDownNode;
            dataEntity = this.getModel().getDataEntity();
            idList = new Long[]{dataEntity.getLong("id")};
            Map map = BFTrackerServiceHelper.loadBillLinkDownNodes((String)"mal_order", (Long[])idList, (boolean)false);
            DynamicObjectCollection order = QueryServiceHelper.query((String)"mal_order", (String)"id,billno,entryentity.erpbillnumber,entryentity.erpsourcebilltype erpsourcebilltype,entryentity.erpbillnumber erpbillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
            ArrayList<String> list = new ArrayList<String>(order.size());
            HashMap<String, Long> purOrderNumAndMalIdMap = new HashMap<String, Long>();
            ArrayList<Long> malBillIdList = new ArrayList<Long>();
            for (DynamicObject dyn : order) {
                String erpbillnumber = dyn.getString("entryentity.erpbillnumber");
                if (!StringUtils.isBlank((CharSequence)erpbillnumber)) {
                    list.add(erpbillnumber);
                    purOrderNumAndMalIdMap.put(erpbillnumber, dyn.getLong("id"));
                }
                if (!PM_PURAPPLYBILL.equals(dyn.getString("erpsourcebilltype")) || "".equals(dyn.getString("erpbillnumber"))) continue;
                malBillIdList.add(dyn.getLong("id"));
            }
            boolean open = false;
            ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>();
            Long malOrderMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order");
            if (!list.isEmpty()) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"pur_order", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", list)});
                HashMap<Long, ArrayList<Long>> malIdAndPurOrderIdMap = new HashMap<Long, ArrayList<Long>>();
                for (DynamicObject dyn : query) {
                    Long malOrderId = (Long)purOrderNumAndMalIdMap.get(dyn.getString("billno"));
                    ArrayList<Long> purOrderList = (ArrayList<Long>)malIdAndPurOrderIdMap.get(malOrderId);
                    if (purOrderList == null) {
                        purOrderList = new ArrayList<Long>();
                        malIdAndPurOrderIdMap.put(malOrderId, purOrderList);
                    }
                    purOrderList.add(dyn.getLong("id"));
                }
                open = true;
                Long purOrderMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order");
                for (Map.Entry malIdAndPurOrderId : malIdAndPurOrderIdMap.entrySet()) {
                    Long malId = (Long)malIdAndPurOrderId.getKey();
                    List purOrderList = (List)malIdAndPurOrderId.getValue();
                    bfRowLinkDownNode = MalBizFowUtil.getBFRowLinkDownNode((Long)malOrderMainTableId, (Long)malId, (Long)purOrderMainTableId, (List)purOrderList);
                    nodes.add(bfRowLinkDownNode);
                }
            }
            if (!malBillIdList.isEmpty()) {
                List<Long> pmOrderList;
                DynamicObjectCollection pmOrder = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.soubillid soubillid", (QFilter[])new QFilter[]{new QFilter("billentry.soubillid", "in", malBillIdList)});
                HashMap<Long, ArrayList<Long>> malIdAndPmOrderMap = new HashMap<Long, ArrayList<Long>>();
                for (DynamicObject dyn : pmOrder) {
                    long malId = dyn.getLong("soubillid");
                    pmOrderList = (ArrayList<Long>)malIdAndPmOrderMap.get(malId);
                    if (pmOrderList == null) {
                        pmOrderList = new ArrayList<Long>();
                        malIdAndPmOrderMap.put(malId, (ArrayList<Long>)pmOrderList);
                    }
                    pmOrderList.add(dyn.getLong("id"));
                }
                open = true;
                Long pmPurOrderBillMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill");
                for (Map.Entry malIdAndPmOrder : malIdAndPmOrderMap.entrySet()) {
                    Long malId = (Long)malIdAndPmOrder.getKey();
                    pmOrderList = (List)malIdAndPmOrder.getValue();
                    bfRowLinkDownNode = MalBizFowUtil.getBFRowLinkDownNode((Long)malOrderMainTableId, (Long)malId, (Long)pmPurOrderBillMainTableId, pmOrderList);
                    nodes.add(bfRowLinkDownNode);
                }
            }
            if (map != null && map.size() > 0) {
                ArrayList<Long> mainIdList = new ArrayList<Long>();
                mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order"));
                mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill"));
                mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_returnreq"));
                mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill"));
                mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order"));
                open = true;
                for (BFRowLinkDownNode bfRowLinkDownNode2 : map.values()) {
                    this.deleteUnRelativeEntity(bfRowLinkDownNode2, mainIdList);
                }
                nodes.addAll(map.values());
            }
            if (!open) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderEditPlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("botp_lookuptracker");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setPageId(this.setPageId(nodes));
                showParameter.setCaption(this.setCaption(order));
                showParameter.getCustomParams().put("linknodes", SerializationUtils.serializeToBase64(nodes));
                showParameter.getCustomParams().put("lookuptype", "lookdown");
                showParameter.getCustomParams().put("track_checkrightappids", "");
                this.getView().showForm(showParameter);
            }
            evt.setCancel(true);
        }
    }

    private String setPageId(List<BFRowLinkDownNode> nodes) {
        String pageId = this.getView().getPageId();
        String operation = "lookDown";
        String hasCode = String.valueOf(31 * nodes.hashCode());
        return String.format("%s_%s_%s", pageId, operation, hasCode);
    }

    private String setCaption(DynamicObjectCollection order) {
        return String.format(ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355(%1$s)-\u4e0b\u67e5", (String)"MalOrderEditPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]), ((DynamicObject)order.get(0)).getString("billno"));
    }

    private void deleteUnRelativeEntity(BFRowLinkDownNode bfRowLinkDownNode, List<Long> mainIdList) {
        Map tNodes = bfRowLinkDownNode.getTNodes();
        Iterator iterator = tNodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry bfRowIdBFRowLinkDownNodeEntry = iterator.next();
            BFRowId bfRowId = (BFRowId)bfRowIdBFRowLinkDownNodeEntry.getKey();
            Long mainTableId = bfRowId.getMainTableId();
            if (!mainIdList.contains(mainTableId)) {
                iterator.remove();
                continue;
            }
            this.deleteUnRelativeEntity((BFRowLinkDownNode)bfRowIdBFRowLinkDownNodeEntry.getValue(), mainIdList);
        }
    }

    public void showLogistics(String billno, String platform) {
        FormShowParameter showParameter = new FormShowParameter();
        if (MalOrderUtil.getDefaultMalVersion() && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equalsIgnoreCase(platform)) {
            showParameter.setFormId("pbd_mal_orderlogistics");
        } else {
            showParameter.setFormId("pbd_logistics");
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billno", billno);
        paramMap.put("platform", platform);
        showParameter.setCustomParams(paramMap);
        this.getView().showForm(showParameter);
    }

    public void pageRelease(EventObject e) {
        MutexHelper.release((String)"mal_order", (String)AFTERSALE, (String)this.getPageCache().get("lockId"));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject bizType;
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        int rowIndex = arg0.getRow();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"purtype") && (bizType = (DynamicObject)this.getModel().getValue("businesstype")) != null) {
            Set lineTypeIds;
            List filters = showParameter.getListFilterParameter().getQFilters();
            if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)bizType)) {
                filters.add(new QFilter("linetype.number", "like", (Object)"060%"));
            }
            if (!CollectionUtils.isEmpty((Collection)(lineTypeIds = BizTypeHelper.getAllLineTypeIds((Long)bizType.getLong("id"))))) {
                filters.add(new QFilter("linetype", "in", (Object)lineTypeIds));
            }
            if (this.isFromScmcReq()) {
                DynamicObject materialDyn = (DynamicObject)this.getModel().getValue("material", rowIndex);
                Set serviceAttrIdSet = MalPlaceOrderUtils.getServiceAttrIdSetByMaterial((DynamicObject)materialDyn);
                if (!serviceAttrIdSet.isEmpty()) {
                    filters.add(new QFilter("linetype.serviceattribute.id", "in", (Object)serviceAttrIdSet));
                } else {
                    filters.add(new QFilter("linetype", "is null", null));
                }
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            Object purTypeDyn;
            DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
            Long purOrgId = purOrg != null ? purOrg.getLong("id") : 0L;
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)purOrgId).and(new QFilter("enablepur", "=", (Object)"1"));
            DynamicObject bizType2 = (DynamicObject)this.getModel().getValue("businesstype");
            if (bizType2 != null && (purTypeDyn = this.getModel().getValue("purtype", rowIndex)) != null && !MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)bizType2)) {
                QFilter serAttrfilter = MalPlaceOrderUtils.getMaterialFiltersByPurtype((DynamicObject)((DynamicObject)purTypeDyn));
                if (serAttrfilter != null) {
                    filter.and(serAttrfilter);
                } else {
                    filter.and("serviceattribute.fbasedataid_id", "is null", null);
                }
            }
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private boolean isFromScmcReq() {
        return PM_PURAPPLYBILL.equals(this.getModel().getEntryRowEntity("entryentity", 0).getString("erpsourcebilltype"));
    }
}

