/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.mal.common.aftersale.AfterSaleFactory;
import kd.scm.mal.common.aftersale.IAfterSaleService;

public class MalReturnReqEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private final Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final String OP_CANCEL = "cancel";
    private static final String OP_RETURN = "return";
    private static final String OP_REFRESH = "refresh";
    private static final String UPDATESRVSCHEDULE = "updatesrvschedule";
    private static final String RECEIVE_RETURN_TYPE = "2";
    private static final String INSTOCK_RETURN_TYPE = "1";
    private static final String RECEIVE_RETURN = "receivereturn";
    private static final String INSTOCK_RETURN = "instockreturn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid trackentryentity = (EntryGrid)this.getControl("aftersaleentry");
        trackentryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String source = String.valueOf(this.getModel().getValue("platform"));
        if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(source)) {
            try {
                String ecOrderId;
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
                DynamicObjectCollection asEntryCol = this.getModel().getEntryEntity("aftersaleentry");
                if (asEntryCol.isEmpty()) {
                    return;
                }
                String ecPorderPk = ((DynamicObject)entryCol.get(0)).getString("ecorder.id");
                DynamicObject ecOrderDyn = null;
                String ecsource = (String)this.getModel().getValue("ecsource");
                if (StringUtils.isNotEmpty((CharSequence)ecPorderPk) && StringUtils.isNotEmpty((CharSequence)ecsource)) {
                    ecOrderDyn = "pbd_jdorder".equals(ecsource) ? QueryServiceHelper.queryOne((String)ecsource, (String)"number orderid,jdorderid porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(ecPorderPk))}) : QueryServiceHelper.queryOne((String)ecsource, (String)"orderid,porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(ecPorderPk))});
                }
                String string = ecOrderId = ecOrderDyn == null ? "" : ecOrderDyn.getString("orderid");
                if (StringUtils.isEmpty((CharSequence)ecOrderId)) {
                    ecOrderId = String.valueOf(this.getModel().getValue("jdchildorderid", 0));
                }
                if (StringUtils.isEmpty((CharSequence)ecOrderId)) {
                    return;
                }
                IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
                Map cancelResult = afterSaleService.canCancelAfterSale(ecOrderId);
                Iterator iterator = cancelResult.values().iterator();
                while (iterator.hasNext()) {
                    boolean canCancel = (Boolean)iterator.next();
                    if (!canCancel) continue;
                    this.getView().setVisible(Boolean.TRUE, new String[]{"tblcancel"});
                    return;
                }
                if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(source)) {
                    String afservicebillid = ((DynamicObject)asEntryCol.get(0)).getString("afservicebill.number");
                    afterSaleService.updateAfterSaleTrack((AbstractFormDataModel)this.getModel(), afservicebillid);
                }
            }
            catch (KDBizException kde) {
                this.log.error(ExceptionUtil.getStackTrace((Throwable)kde));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_trackup".equals(itemKey)) {
            this.trackUp();
        }
    }

    private void trackUp() {
        Object number = this.getModel().getValue("malorderno");
        if (null != number) {
            Map<String, HashSet<Long>> result = this.getTrackUpBill(String.valueOf(number));
            if (result.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalReturnReqEditPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Map<String, HashSet<Long>>> customParams = new HashMap<String, Map<String, HashSet<Long>>>();
            customParams.put("param", result);
            FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
            this.getView().showForm(formParam);
        }
    }

    private Map<String, HashSet<Long>> getTrackUpBill(String billNo) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> set = new HashSet<Long>(1);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"mal_order", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNo)});
        if (dyo != null) {
            set.add(dyo.getLong("id"));
            resultMap.put("mal_order", set);
        }
        return resultMap;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (opKey = args.getOperateKey()) {
            case "return": {
                if (ApiConfigUtil.hasEASConfig()) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("billid", this.getModel().getDataEntity().getPkValue().toString());
                    param.put("source", "mall");
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_batreturn", param, null, (ShowType)ShowType.MainNewTabPage));
                    break;
                }
                if (ApiConfigUtil.hasCQScmConfig()) {
                    this.getView().invokeOperation("push");
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_return"});
                break;
            }
            case "receivereturn": {
                this.toReturn(this.getModel().getDataEntity(), RECEIVE_RETURN_TYPE);
                break;
            }
            case "instockreturn": {
                this.toReturn(this.getModel().getDataEntity(), INSTOCK_RETURN_TYPE);
                break;
            }
            default: {
                this.getView().invokeOperation(OP_REFRESH);
            }
        }
    }

    protected void toReturn(DynamicObject returnReqDyn, String returnType) {
        String billId = returnReqDyn.getString("id");
        Map lockInfo = MutexUtil.getLockInfo((String)billId, (String)"pur_return_match", (String)"baritemap1");
        if (lockInfo != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5728\u5feb\u901f\u9000\u8d27\u4e2d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"MalReturnReqEditPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> pkIds = new ArrayList<String>();
        pkIds.add(returnReqDyn.getString("id"));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("billid", pkIds);
        fsp.setCustomParam("returnType", (Object)returnType);
        fsp.setCustomParam("businesstype", (Object)returnReqDyn.getString("businesstype.id"));
        fsp.setFormId("pur_return_match");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "toReturn"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("toReturn")) {
            this.getView().invokeOperation(OP_REFRESH);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        String source = String.valueOf(this.getModel().getValue("platform"));
        IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
        if (afterSaleService != null && (OP_CANCEL.equals(operateKey) || OP_REFRESH.equals(operateKey)) && !ReturnStatusEnum.FINISH.getVal().equals(this.getModel().getDataEntity().getString("cfmstatus"))) {
            afterSaleService.updateAfterServiceSchedule(this.getModel().getDataEntity(true));
        }
        if ((RECEIVE_RETURN.equals(operateKey) || INSTOCK_RETURN.equals(operateKey)) && !"3".equals(this.getModel().getValue("replenishtype")) && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getModel().getValue("platform"))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u552e\u540e\u7533\u8bf7\u5355\u4e0d\u652f\u6301\u53d1\u8d77\u9000\u8865\u5904\u7406\u3002", (String)"MalReturnReqEditPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if (UPDATESRVSCHEDULE.equals(operateKey)) {
            if (this.getModel().getValue("platform").equals(EcPlatformEnum.ECPLATFORM_XFS.getVal())) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u946b\u65b9\u76db\u4e0d\u652f\u6301\u8fdb\u5ea6\u66f4\u65b0\u3002", (String)"MalReturnReqEditPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (this.getModel().getValue("platform").equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5bf9\u7535\u5546\u652f\u6301\u8fdb\u5ea6\u66f4\u65b0\u3002", (String)"MalReturnReqEditPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject aftersaleentryDyn;
        String afservicebillid;
        int rowIdx = evt.getRow();
        if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(this.getModel().getValue("platform")) && StringUtils.isNotEmpty((CharSequence)(afservicebillid = (aftersaleentryDyn = this.getModel().getEntryRowEntity("aftersaleentry", rowIdx)).getString("afservicebill.number")))) {
            IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
            afterSaleService.updateAfterSaleTrack((AbstractFormDataModel)this.getModel(), afservicebillid);
        }
    }
}

