/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.domain.ProdCommentLabel;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public final class MalOrderCommentListPlugin
extends AbstractListPlugin {
    private static String First_Comment = "0";
    private static String Follow_Comment = "1";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        HashSet<String> fixedColumns = new HashSet<String>(16);
        fixedColumns.add("commentfirststatus");
        fixedColumns.add("commentfollowstatus");
        fixedColumns.add("goods.name");
        for (IListColumn listColumn : listColumns) {
            String listFieldKey;
            if (!(listColumn instanceof ListColumn) || !fixedColumns.contains(listFieldKey = listColumn.getListFieldKey())) continue;
            ListColumn listOperationColumn = (ListColumn)listColumn;
            listOperationColumn.setFixed(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dynamicObjects = super.getData(arg0, arg1);
                ArrayList pkIds = new ArrayList(dynamicObjects.size());
                dynamicObjects.forEach(v -> pkIds.add(v.getLong("id")));
                boolean containCommentFirstStatus = dynamicObjects.getDynamicObjectType().getProperties().containsKey((Object)"entryentity.commentfirststatus");
                boolean containCommentFollowStatus = dynamicObjects.getDynamicObjectType().getProperties().containsKey((Object)"entryentity.commentfollowstatus");
                if (!containCommentFirstStatus || !containCommentFollowStatus) {
                    HashMap firstStatusMap = new HashMap(pkIds.size());
                    HashMap followStatusMap = new HashMap(pkIds.size());
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order_comment", (String)"id,entryentity.commentfirststatus commentfirststatus,entryentity.commentfollowstatus commentfollowstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)}, null);){
                        dataSet.forEach(row -> {
                            firstStatusMap.put(row.getLong("id"), row.getString("commentfirststatus"));
                            followStatusMap.put(row.getLong("id"), row.getString("commentfollowstatus"));
                        });
                    }
                    if (!containCommentFirstStatus) {
                        dynamicObjects.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.commentfirststatus", String.class, (Object)""));
                    }
                    if (!containCommentFollowStatus) {
                        dynamicObjects.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.commentfollowstatus", String.class, (Object)""));
                    }
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        if (!containCommentFirstStatus) {
                            dynamicObject.set("entryentity.commentfirststatus", firstStatusMap.get(dynamicObject.getLong("id")));
                        }
                        if (containCommentFollowStatus) continue;
                        dynamicObject.set("entryentity.commentfollowstatus", followStatusMap.get(dynamicObject.getLong("id")));
                    }
                }
                return dynamicObjects;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List<String> billStatusList = Arrays.asList("C", "D", "Z");
        QFilter qFilter = new QFilter("billstatus", "in", billStatusList);
        QFilter logStatusQFilter = new QFilter("entryentity.erplogstatus", "in", Arrays.asList("E", "G"));
        logStatusQFilter.or(new QFilter("entryentity.erplogstatus", "=", (Object)"F").and(new QFilter("entryentity.sumreceiptqty", "=", (Object)"entryentity.qty", true)));
        qFilters.add(logStatusQFilter);
        qFilters.add(qFilter);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status");
        if (StringUtils.isNotBlank(status)) {
            if ("docomment".equals(status)) {
                qFilters.add(new QFilter("entryentity.commentfirststatus", "=", (Object)"A"));
            } else if ("hascommented".equals(status)) {
                qFilters.add(new QFilter("entryentity.commentfirststatus", "!=", (Object)"A"));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u6211\u7684\u8bc4\u4ef7", (String)"MalOrderCommentListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])});
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        DynamicObject rowData = packageDataEvent.getRowData();
        if (packageDataEvent.getSource() instanceof ListOperationColumnDesc && "listoperationcolumnap".equals(((ListOperationColumnDesc)packageDataEvent.getSource()).getKey())) {
            List operationColItemList = (List)packageDataEvent.getFormatValue();
            for (OperationColItem operationColItem : operationColItemList) {
                String operationKey = operationColItem.getOperationKey();
                String firstStatus = rowData.getString("entryentity.commentfirststatus");
                String followStatus = rowData.getString("entryentity.commentfollowstatus");
                if ("A".equals(firstStatus) && ("viewcomment".equals(operationKey) || "followcomment".equals(operationKey))) {
                    operationColItem.setVisible(false);
                }
                if (!"A".equals(firstStatus) && "A".equals(followStatus) && "docomment".equals(operationKey)) {
                    operationColItem.setVisible(false);
                }
                if ("A".equals(firstStatus) || "A".equals(followStatus) || !"docomment".equals(operationKey) && !"followcomment".equals(operationKey)) continue;
                operationColItem.setVisible(false);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object id = list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("mal_order");
            showParameter.setPkId(id);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "docomment": {
                this.doComment(First_Comment, args);
                break;
            }
            case "followcomment": {
                this.doComment(Follow_Comment, args);
                break;
            }
            case "viewcomment": {
                this.viewComment();
                break;
            }
        }
    }

    private void doComment(String commentType, BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object entryId = list.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
        DynamicObject malOrder = QueryServiceHelper.queryOne((String)"mal_order_comment", (String)"id,billdate,billno,entryentity.qty qty,entryentity.sumreceiptqty sumreceiptqty,entryentity.erplogstatus erplogstatus,entryentity.taxprice taxprice,entryentity.goods.id goods,entryentity.goods.supplier supplier,entryentity.goods.category category,entryentity.goods.name goodsname,entryentity.goods.thumbnail thumbnail,entryentity.goods.spunumber spunumber", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", entryId)});
        Long categoryId = malOrder.getLong("category");
        String properties = "strategy.privacyprotect privacyprotect,strategy.needaudit needaudit,strategy.commentstep commentstep,strategy.allowabandon allowabandon,commtplinfoentry.ismustimput ismustimput,commtplinfoentry.module.name modulename,commtplinfoentry.module.num num,commtplinfoentry.module.placeholder placeholder,commtplinfoentry.module.level level,commtplinfoentry.module.score score,commtplinfoentry.module.picturenum picturenum,commtplinfoentry.module.group.number group,commtplinfoentry.module.group.id groupId,commtplinfoentry.module.label.id labelgroup,commtplinfoentry.module.label.fbasedataid label";
        QFilter tempQFilter = new QFilter("commtplclassentry.class.id", "=", (Object)categoryId);
        tempQFilter.and("enable", "=", (Object)"1");
        tempQFilter.and("alluse", "=", (Object)"0");
        DynamicObjectCollection commentTemplate = QueryServiceHelper.query((String)"pmm_commenttemplate", (String)properties, (QFilter[])tempQFilter.toArray());
        if (commentTemplate == null || commentTemplate.isEmpty()) {
            QFilter allUseQFilter = new QFilter("alluse", "=", (Object)"1");
            allUseQFilter.and("enable", "=", (Object)"1");
            commentTemplate = QueryServiceHelper.query((String)"pmm_commenttemplate", (String)properties, (QFilter[])allUseQFilter.toArray());
        }
        if (!this.checkIsAllowComment(commentTemplate, malOrder, commentType)) {
            args.setCancel(true);
            return;
        }
        ArrayList<ProdCommentLabel> prodCommentLabels = new ArrayList<ProdCommentLabel>(commentTemplate.size());
        List<ProdCommentContentDetail> prodCommentContentDetails = this.getProdCommentContentDetails(commentTemplate, prodCommentLabels);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("commentDetails", SerializationUtils.toJsonString(prodCommentContentDetails));
        paramMap.put("prodCommentLabels", SerializationUtils.toJsonString(prodCommentLabels));
        paramMap.put("goodsId", malOrder.getLong("goods"));
        paramMap.put("billno", malOrder.getString("billno"));
        paramMap.put("orderId", malOrder.getLong("id"));
        paramMap.put("billdate", malOrder.getDate("billdate"));
        paramMap.put("thumbnail", malOrder.getString("thumbnail"));
        paramMap.put("goodsname", malOrder.getString("goodsname"));
        paramMap.put("spunumber", malOrder.getString("spunumber"));
        paramMap.put("taxprice", malOrder.getString("taxprice"));
        paramMap.put("supplier", malOrder.getString("supplier"));
        paramMap.put("privacyprotect", ((DynamicObject)commentTemplate.get(0)).getBoolean("privacyprotect"));
        paramMap.put("allowabandon", ((DynamicObject)commentTemplate.get(0)).getBoolean("allowabandon"));
        paramMap.put("needaudit", ((DynamicObject)commentTemplate.get(0)).getBoolean("needaudit"));
        paramMap.put("commenttype", commentType);
        FormShowParameter fsp = new FormShowParameter();
        StyleCss styleCss = new StyleCss();
        int height = 64;
        int size = prodCommentContentDetails.size();
        if (!prodCommentLabels.isEmpty()) {
            size = prodCommentContentDetails.size() - prodCommentLabels.size() + 1;
        }
        if (size > 5) {
            height += (size - 5) * 6;
        }
        styleCss.setHeight(height + "%");
        fsp.setFormId("mal_goodscomment");
        fsp.setCustomParams(paramMap);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "doCommentClose"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(fsp);
    }

    private boolean checkIsAllowComment(DynamicObjectCollection commentTemplate, DynamicObject malOrder, String commentType) {
        String commentStep = ((DynamicObject)commentTemplate.get(0)).getString("commentstep");
        QFilter commonManageQFilter = new QFilter("order", "=", (Object)malOrder.getLong("id"));
        commonManageQFilter.and("goods", "=", (Object)malOrder.getLong("goods"));
        commonManageQFilter.and("commenttype", "=", (Object)commentType);
        boolean exists = QueryServiceHelper.exists((String)"pmm_commentmanage", (QFilter[])commonManageQFilter.toArray());
        if (exists) {
            if (First_Comment.equals(commentType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u8ba2\u5355\u5df2\u7ecf\u8fdb\u884c\u8fc7\u8bc4\u4ef7\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"MalOrderCommentListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            } else if (Follow_Comment.equals(commentType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u8ba2\u5355\u5df2\u7ecf\u8fdb\u884c\u8fc7\u8ffd\u8bc4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"MalOrderCommentListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if ("B".equals(commentStep)) {
            return true;
        }
        String logStatus = malOrder.getString("erplogstatus");
        BigDecimal qty = malOrder.getBigDecimal("qty");
        BigDecimal sumreceiptqty = malOrder.getBigDecimal("sumreceiptqty");
        if (!("E".equals(logStatus) || "G".equals(logStatus) || "F".equals(logStatus) && qty.compareTo(sumreceiptqty) == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6536\u8d27\u540e\u518d\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"MalOrderCommentListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<ProdCommentContentDetail> getProdCommentContentDetails(DynamicObjectCollection commentTemplate, List<ProdCommentLabel> prodCommentLabels) {
        ArrayList<ProdCommentContentDetail> prodCommentContentDetails = new ArrayList<ProdCommentContentDetail>(commentTemplate.size());
        for (DynamicObject dynamicObject : commentTemplate) {
            ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
            String group = dynamicObject.getString("group");
            if (ProdCommentTypeEnum.LABEL.getVal().equals(group)) {
                ProdCommentLabel prodCommentLabel = new ProdCommentLabel();
                prodCommentLabel.setId(Long.valueOf(dynamicObject.getLong("label")));
                prodCommentLabels.add(prodCommentLabel);
            }
            prodCommentContentDetail.setId(Long.valueOf(dynamicObject.getLong("groupId")));
            prodCommentContentDetail.setCommentTitle(dynamicObject.getString("modulename"));
            prodCommentContentDetail.setMustInput(Boolean.valueOf(dynamicObject.getBoolean("ismustimput")));
            prodCommentContentDetail.setValue(this.getModuleValue(dynamicObject));
            prodCommentContentDetail.setModuleType(group);
            prodCommentContentDetails.add(prodCommentContentDetail);
        }
        return prodCommentContentDetails;
    }

    private String getModuleValue(DynamicObject dynamicObject) {
        String value = "";
        String group = dynamicObject.getString("group");
        switch (ProdCommentTypeEnum.fromVal((String)group)) {
            case STARS: {
                value = dynamicObject.getString("num");
                break;
            }
            case SCORE: {
                value = dynamicObject.getString("score");
                break;
            }
            case TEXT: {
                value = dynamicObject.getString("placeholder");
                break;
            }
            case LABEL: {
                value = dynamicObject.getString("label");
                break;
            }
            case PICTURE: {
                value = dynamicObject.getString("picturenum");
                break;
            }
            case LEVEL: {
                value = dynamicObject.getString("level");
            }
        }
        return value;
    }

    private void viewComment() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object entryId = list.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
        DynamicObject malOrder = QueryServiceHelper.queryOne((String)"mal_order_comment", (String)"id,billdate,billno,entryentity.taxprice taxprice,entryentity.goods.id goods,entryentity.goods.supplier supplier,entryentity.goods.category category,entryentity.goods.name goodsname,entryentity.goods.thumbnail thumbnail,entryentity.goods.spunumber spunumber", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", entryId)});
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("goodsId", malOrder.getLong("goods"));
        paramMap.put("billno", malOrder.getString("billno"));
        paramMap.put("orderId", malOrder.getLong("id"));
        paramMap.put("billdate", malOrder.getDate("billdate"));
        paramMap.put("thumbnail", malOrder.getString("thumbnail"));
        paramMap.put("goodsname", malOrder.getString("goodsname"));
        paramMap.put("spunumber", malOrder.getString("spunumber"));
        paramMap.put("taxprice", malOrder.getString("taxprice"));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_viewcomment");
        fsp.setCustomParams(paramMap);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "doCommentClose": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                list.refresh();
            }
        }
    }
}

