/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SupplierChatEngineUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.service.MalGoodsMonitorLogService;
import kd.scm.mal.business.service.MalNewShopCenterService;
import kd.scm.mal.common.aftersale.bean.AfterSaleValidateInfo;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.EcOrderAutoReceiveFactory;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalAuthorityUtils;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.formplugin.util.MalOrderEntityUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import net.sf.json.JSONArray;

public class MalOrderListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(MalOrderListPlugin.class);
    private static final String KEY_RECEIVE = "receive";
    private static final String KEY_AFTERSALE = "aftersale";
    private static final String AFTERSALE = "aftersale";
    public static final String BILLID = "billid";
    private static final String AUTO_RECEIVE = "autoreceive";
    private static final String ASYNCSTATUS = "asyncstatus";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String aftersaleReq = (String)fsp.getCustomParam("aftersaleReq");
        if ("1".equals(aftersaleReq)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "tblorder", "baritemap1", "tblcancel", "tblatuoreceive"});
            if ((ShowType.NewWindow == this.getView().getFormShowParameter().getOpenStyle().getShowType() || ShowType.InContainer == this.getView().getFormShowParameter().getOpenStyle().getShowType()) && MalOrderUtil.getDefaultMalVersion()) {
                this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u7533\u8bf7\u552e\u540e", (String)"MalOrderListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])});
            }
        } else if ((ShowType.NewWindow == this.getView().getFormShowParameter().getOpenStyle().getShowType() || ShowType.InContainer == this.getView().getFormShowParameter().getOpenStyle().getShowType()) && MalOrderUtil.getDefaultMalVersion()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u6211\u7684\u8ba2\u5355", (String)"MalOrderListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0])});
        }
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter fsp;
        String aftersaleReq;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter userQFilter = MalAuthorityUtils.getMalOrderViewAuthorityFilter((String)RequestContext.get().getUserId(), (String)"deporg.id", (String)"mal_order");
        if (null != userQFilter) {
            qFilters.add(userQFilter);
        }
        if ("1".equals(aftersaleReq = (String)(fsp = this.getView().getFormShowParameter()).getCustomParam("aftersaleReq"))) {
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        }
        if (null == fsp.getCustomParam("status")) {
            Object logStatus = fsp.getCustomParam("logStatus");
            if (logStatus != null) {
                try {
                    qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
                    qFilters.add(new QFilter("entryentity.erplogstatus", "in", (Object)JSONArray.fromObject((Object)URLDecoder.decode(logStatus.toString(), "UTF-8"))));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.error("@@open fail:" + logStatus + "\n" + unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
                }
            }
        } else {
            String malkey = (String)fsp.getCustomParam("status");
            MalNewShopCenterService service = new MalNewShopCenterService();
            String formId = "mal_order";
            if (fsp.getCustomParam("formId") != null) {
                formId = (String)fsp.getCustomParam("formId");
            }
            Set ids = service.queryTarEntityID(qFilters.toArray(new QFilter[0]), malkey, formId);
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
        String ids = (String)fsp.getCustomParam("ids");
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            log.info("setFilter.ids:" + ids);
            try {
                ids = URLDecoder.decode(ids, "UTF-8");
                if (ids.startsWith("[") && ids.endsWith("]")) {
                    JSONArray idsJa = JSONArray.fromObject((Object)URLDecoder.decode(ids, "UTF-8"));
                    qFilters.add(new QFilter("id", "in", (Object)idsJa));
                }
            }
            catch (UnsupportedEncodingException exception) {
                log.error(ExceptionUtil.getStackTrace((Throwable)exception));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object pk;
        DynamicObject data;
        DynamicObjectCollection logDyCol;
        if (StringUtils.equals((CharSequence)"erpbillnumber", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            int selectRowIndex = args.getRowIndex();
            Object pk2 = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject data2 = QueryServiceHelper.queryOne((String)"mal_order", (String)"businesstype", (QFilter[])new QFilter[]{new QFilter("id", "=", pk2)});
            if (ApiConfigUtil.hasCQScmConfig() && !MalNewOrderUtils.checkIsGoodsBizTypeId((Long)data2.getLong("businesstype"))) {
                HyperLinkClickUtil.MallPurOrderView((IFormView)this.getView(), (String)"mal_order", (String)"entryentity.erpbillnumber", (String)"entryentity.id", (String)"pm_purorderbill", (int)selectRowIndex);
            } else {
                HyperLinkClickUtil.MallPurOrderView((IFormView)this.getView(), (String)"mal_order", (String)"entryentity.erpbillnumber", (String)"entryentity.id", (String)"pur_order", (int)selectRowIndex);
            }
        }
        if (StringUtils.equals((CharSequence)ASYNCSTATUS, (CharSequence)args.getHyperLinkClickEvent().getFieldName()) && !CollectionUtils.isEmpty((Collection)(logDyCol = QueryServiceHelper.query((String)"bos_log_asyncop", (String)"id,exetime,org,user,entity,billno,operatorname,oprulename,consume,log_tag,success", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(data = QueryServiceHelper.queryOne((String)"mal_order", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", pk = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue())})).getString("billno"))}, (String)"exetime desc")))) {
            DynamicObject logDy = (DynamicObject)logDyCol.get(0);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", logDy.getLong("id"));
            paramMap.put("exetime", logDy.getString("exetime"));
            paramMap.put("org", logDy.getString("org"));
            paramMap.put("user", logDy.getString("user"));
            paramMap.put("entity", logDy.getString("entity"));
            paramMap.put("operatorname", logDy.getString("operatorname"));
            paramMap.put("oprulename", logDy.getString("oprulename"));
            paramMap.put("consume", logDy.getString("consume"));
            paramMap.put("success", logDy.getString("success"));
            paramMap.put("billno", logDy.getString("billno"));
            paramMap.put("log", logDy.getString("log_tag"));
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_log_asyncop", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "malLogAsyncop"), (ShowType)ShowType.MainNewTabPage));
            args.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject data;
        BillList list;
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"tblorder")) {
            list = (BillList)this.getView().getControl("billlistap");
            if (list.getSelectedRows().size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalOrderListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            data = this.getSelectData();
            if (null != data) {
                if (MalOrderUtil.getDefaultMalVersion()) {
                    DynamicObjectCollection entryCol = data.getDynamicObjectCollection("entryentity");
                    ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(entryCol.size());
                    HashMap<Long, BigDecimal> goodsIdToQtyMap = new HashMap<Long, BigDecimal>();
                    for (DynamicObject entry : entryCol) {
                        MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.buildGeneralParam((Long)entry.getLong("goods.id"), (String)data.getString("platform"), (BigDecimal)entry.getBigDecimal("qty"), (String)data.getString("receipt.address"), (Long)RequestContext.get().getOrgId());
                        malMatGoodsInitParams.add(malMatGoodsInitParam);
                        goodsIdToQtyMap.put(entry.getLong("goods.id"), BigDecimal.ONE);
                    }
                    Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
                    MalPlaceOrderValidateResult malPlaceOrderValidateResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).validateGoodsForPlaceOrder(goodsIdToQtyMap, malGoodsMap, false, RequestContext.get().getOrgId());
                    if (malPlaceOrderValidateResult.getInvalidProdNumberList().size() == malGoodsMap.size()) {
                        this.getView().showMessage(String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()));
                        return;
                    }
                    if (malPlaceOrderValidateResult.getInvalidProdNumberList().size() > 0) {
                        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("quickmake", (IFormPlugin)this);
                        this.getView().showConfirm(String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
                        return;
                    }
                }
                this.doQuickMakeOrder();
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"tbllogistics")) {
            ArrayList<String> entryKey = new ArrayList<String>(1);
            entryKey.add("entryentity");
            data = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"mal_order", entryKey);
            if (data != null) {
                this.showLogistics(data.getString("billno"), data.getString("platform"));
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"tblcancel")) {
            list = (BillList)this.getView().getControl("billlistap");
            if (list.getSelectedRows().size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalOrderListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (list.getSelectedRows().getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u8ba2\u5355\u8fdb\u884c\u53d6\u6d88\u3002", (String)"MalOrderListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"wechat")) {
            list = (BillList)this.getView().getControl("billlistap");
            if (list.getSelectedRows().size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalOrderListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (list.getSelectedRows().getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9\u4e00\u6761\u5355\u636e\u8054\u7cfb\u5ba2\u670d\u3002", (String)"MalOrderListPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void doQuickMakeOrder() {
        if (MalOrderUtil.getDefaultMalVersion()) {
            this.openMalPlaceOrder();
        } else {
            this.toMakeOrder();
        }
    }

    private void toMakeOrder() {
        DynamicObject data = this.getSelectData();
        List<Map<String, Object>> cusMapList = this.createRemakeOrderData(data);
        String source = data.getString("platform");
        HashMap<String, Object> customFilter = new HashMap<String, Object>();
        customFilter.put("slectProd", cusMapList);
        customFilter.put("param_amount", this.getPageCache().get("totalAmount"));
        customFilter.put("person", data.get("person.id"));
        customFilter.put("receipt", data.get("receipt.id"));
        customFilter.put("fromCart", "false");
        this.preHandleHeadData(customFilter);
        CloseCallBack callBack = new CloseCallBack();
        callBack.setClassName(((Object)((Object)this)).getClass().getName());
        if (source.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
            callBack.setActionId("mal_makeorder");
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_makeorder", customFilter, (CloseCallBack)callBack, (ShowType)ShowType.MainNewTabPage));
        } else {
            callBack.setActionId("mal_jdmakeorder");
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_jdmakeorder", customFilter, (CloseCallBack)callBack, (ShowType)ShowType.MainNewTabPage));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"quickmake", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doQuickMakeOrder();
        }
        if (StringUtils.equals((CharSequence)"cancel", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("cancel", "true");
            this.getView().invokeOperation("cancelorder");
        }
        if (StringUtils.equals((CharSequence)"notifymsg", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("continue", "true");
            this.getView().invokeOperation("submit");
        }
    }

    private String setPageId(List<BFRowLinkDownNode> nodes) {
        String pageId = this.getView().getPageId();
        String operation = "lookDown";
        String hasCode = String.valueOf(31 * nodes.hashCode());
        return String.format("%s_%s_%s", pageId, operation, hasCode);
    }

    private String setCaption(List<String> malNumberList) {
        if (malNumberList.size() == 1) {
            return String.format(ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355(%1$s)-\u4e0b\u67e5", (String)"MalOrderListPlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]), malNumberList.get(0));
        }
        return String.format(ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355(%1$s\u7b49%2$s\u5355)-\u4e0b\u67e5", (String)"MalOrderListPlugin_22", (String)"scm-mal-formplugin", (Object[])new Object[0]), malNumberList.get(0), malNumberList.size());
    }

    private void deleteUnRelativeEntity(BFRowLinkDownNode bfRowLinkDownNode, List<Long> mainIdList) {
        Map tNodes = bfRowLinkDownNode.getTNodes();
        Iterator iterator = tNodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry bfRowIdBFRowLinkDownNodeEntry = iterator.next();
            BFRowId bfRowId = (BFRowId)bfRowIdBFRowLinkDownNodeEntry.getKey();
            Long mainTableId = bfRowId.getMainTableId();
            if (!mainIdList.contains(mainTableId)) {
                iterator.remove();
                continue;
            }
            this.deleteUnRelativeEntity((BFRowLinkDownNode)bfRowIdBFRowLinkDownNodeEntry.getValue(), mainIdList);
        }
    }

    protected DynamicObject getSelectData() {
        ArrayList<String> entryKeyList = new ArrayList<String>(1);
        entryKeyList.add("entryentity");
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5546\u57ce\u8ba2\u5355\u518d\u6765\u4e00\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MalOrderListPlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        for (String entryKey : entryKeyList) {
            selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"mal_order", (String)entryKey, (boolean)false);
        }
        return BusinessDataServiceHelper.loadSingle((Object)objects[0], (String)"mal_order");
    }

    private void openMalPlaceOrder() {
        DynamicObject data = this.getSelectData();
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
        ArrayList<Long> prodIds = new ArrayList<Long>(1024);
        for (DynamicObject row : entrys) {
            DynamicObject goods = row.getDynamicObject("goods");
            if (null == goods) continue;
            prodIds.add(goods.getLong("id"));
        }
        long orgId = RequestContext.get().getOrgId();
        QFilter qFilter = new QFilter("goods.id", "in", prodIds);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        List infos = MalProductUtil.getProdPools((QFilter[])qFilter.toArray(), (String)"goods.id", (boolean)false);
        HashSet<Long> idSet = new HashSet<Long>(1024);
        for (DynamicObject info : infos) {
            long org = info.getLong("entryentity.orgname");
            boolean isgoodvisible = info.getBoolean("isgoodvisible");
            if (!isgoodvisible && org != orgId) continue;
            idSet.add(info.getLong("goods.id"));
        }
        HashMap<String, Object> customFilter = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String source = data.getString("platform");
        DynamicObjectCollection dyoCol = data.getDynamicObjectCollection("entryentity");
        BigDecimal totalAmount = BigDecimal.ZERO;
        int count = 1;
        for (DynamicObject dyo : dyoCol) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(dyoCol.size());
            String goodsId = dyo.getString("goods.id");
            String goods = dyo.getString("goods.number");
            Long supplierId = dyo.getLong("supplier.id");
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)dyo.get("qty"));
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal amount = qty.multiply(price);
            if (!idSet.contains(Long.parseLong(goodsId)) && source.equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) continue;
            dataMap.put("cart_pricedesc", null);
            if (source.equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                dataMap.put("cart_supplier_id", supplierId);
            } else {
                dataMap.put("cart_supplier_id", MalOrderUtil.getEcSupplierId((String)source));
            }
            dataMap.put("cart_goodsource", source);
            dataMap.put("cart_pic", ((DynamicObject)dyo.get("goods")).getString("thumbnail"));
            dataMap.put("cart_price", BigDecimal.ZERO);
            dataMap.put("cart_name", dyo.get("goods.name.zh_CN"));
            dataMap.put("cart_amount", amount);
            dataMap.put("cart_number", goods);
            dataMap.put("cart_stock_qty", BigDecimal.ZERO);
            dataMap.put("cart_unit", dyo.get("unit.id"));
            dataMap.put("cart_supplier", supplierId);
            dataMap.put("cart_pk", goodsId);
            dataMap.put("id", 0);
            dataMap.put("cart_desc", dyo.get("goods.model.zh_CN"));
            dataMap.put("seq", count);
            dataMap.put("cart_goods", goodsId);
            dataMap.put("cart_qty", qty);
            dataMap.put("cart_purtype", dyo.get("purtype.id"));
            dataMap.put("cart_linetype", dyo.get("linetype.id"));
            dataMap.put("cart_goodsuse", dyo.get("goodsuse.id"));
            dataMap.put("cart_entrycostproject", dyo.get("entrycostproject.id"));
            ++count;
            totalAmount = totalAmount.add(amount);
            resultList.add(dataMap);
        }
        this.preHandleEntryData(resultList);
        customFilter.put("slectProd", resultList);
        customFilter.put("param_amount", totalAmount);
        customFilter.put("businesstype", data.get("businesstype.id"));
        ShowType showType = MainPageUtils.getShowType((FormShowParameter)this.getView().getFormShowParameter());
        customFilter.put("opentype", showType);
        customFilter.put("fromCart", this.getPageCache().get("fromCart"));
        this.preHandleHeadData(customFilter);
        CloseCallBack callBack = new CloseCallBack();
        callBack.setClassName(((Object)((Object)this)).getClass().getName());
        callBack.setActionId("mal_placeorder");
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_placeorder", customFilter, (CloseCallBack)callBack, (ShowType)ShowType.MainNewTabPage));
    }

    public void showLogistics(String billno, String platform) {
        FormShowParameter showParameter = new FormShowParameter();
        if (MalOrderUtil.getDefaultMalVersion() && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equalsIgnoreCase(platform)) {
            showParameter.setFormId("pbd_mal_orderlogistics");
        } else {
            showParameter.setFormId("pbd_logistics");
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billno", billno);
        paramMap.put("platform", platform);
        showParameter.setCustomParams(paramMap);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        super.closedCallBack(closedCallBackEvent);
        if (!StringUtils.isNotBlank((CharSequence)closedCallBackEvent.getActionId())) {
            return;
        }
        if ((closedCallBackEvent.getActionId().equals("mal_makeorder") || closedCallBackEvent.getActionId().equals("mal_jdmakeorder")) && null != closedCallBackEvent.getReturnData() && ((Boolean)(returnData = (HashMap)closedCallBackEvent.getReturnData()).get("sucessMakeOrder")).booleanValue()) {
            this.getView().invokeOperation("refresh");
        }
        switch (closedCallBackEvent.getActionId()) {
            case "aftersale": {
                Object condition = closedCallBackEvent.getReturnData();
                MutexHelper.release((String)"mal_order", (String)"aftersale", (String)this.getPageCache().get("lockId"));
                if (condition == null) {
                    return;
                }
                Map map = condition instanceof Map ? (Map)condition : new HashMap();
                Long billId = (Long)map.get(BILLID);
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"mal_returnreq", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)billId, null, null));
                break;
            }
            case "jumpToBarReceive": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private List<Map<String, Object>> createRemakeOrderData(DynamicObject data) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal freight = data.getBigDecimal("freight");
        DynamicObjectCollection dyoCol = data.getDynamicObjectCollection("entryentity");
        String source = data.getString("platform");
        List goodsList = MalProductUtil.getListByProperty((DynamicObjectCollection)dyoCol, (String)"goods.number");
        List goodsIdList = MalProductUtil.getListByProperty((DynamicObjectCollection)dyoCol, (String)"goods.id");
        Map priceMap = new HashMap();
        Map stockQtyMap = new HashMap();
        Map jdPriceMap = new HashMap();
        if (source.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
            priceMap = MalProductUtil.getMalProdPrice((List)goodsList);
            stockQtyMap = MalProductUtil.getAvailableqty((List)goodsIdList);
        } else {
            try {
                jdPriceMap = JdApiUtil.batchGetJdPriceMap((List)goodsList);
            }
            catch (KDBizException e) {
                log.error("@@@kd.scm.mal.formplugin.list.MalOrderListPlugin.createRemakeOrderData,\u66f4\u65b0\u4ef7\u683c\u5f02\u5e38" + e.getMessage());
            }
        }
        for (DynamicObject dyo : dyoCol) {
            BigDecimal price;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            String goodsId = dyo.getString("goods.id");
            String goods = dyo.getString("goods.number");
            Long supplierId = dyo.getLong("supplier.id");
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)dyo.get("qty"));
            if (source.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                price = (BigDecimal)priceMap.get(goods);
                dataMap.put("cart_goods", goodsId);
                dataMap.put("cart_stock_qty", stockQtyMap.getOrDefault(goodsId, BigDecimal.ZERO));
            } else {
                dataMap.put("cart_goods", goods);
                price = jdPriceMap.get(goods) != null ? CommonUtil.getBigDecimalPro((Object)((PriceInfo)jdPriceMap.get(goods)).getShowprice()) : BigDecimal.ZERO;
            }
            BigDecimal amount = qty.multiply(price);
            dataMap.put("cart_goodsource", source);
            dataMap.put("cart_pic", ((DynamicObject)dyo.get("goods")).getString("thumbnail"));
            dataMap.put("cart_number", goods);
            dataMap.put("cart_name", dyo.get("goods.name.zh_CN"));
            dataMap.put("cart_desc", dyo.get("goods.model.zh_CN"));
            dataMap.put("cart_supplier", supplierId);
            dataMap.put("cart_price", price);
            dataMap.put("cart_qty", qty);
            dataMap.put("cart_unit", dyo.get("unit.id"));
            dataMap.put("cart_amount", amount);
            dataMap.put("cart_purtype", dyo.get("purtype.id"));
            totalAmount = totalAmount.add(amount);
            resultList.add(dataMap);
        }
        this.preHandleEntryData(resultList);
        this.getPageCache().put("totalAmount", String.valueOf(totalAmount));
        this.getPageCache().put("freight", String.valueOf(freight));
        return resultList;
    }

    public void preHandleEntryData(List<Map<String, Object>> resultList) {
    }

    public void preHandleHeadData(Map<String, Object> dataMap) {
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "wechat": {
                IListView listView = (IListView)this.getView();
                ListSelectedRowCollection rowCollection = listView.getSelectedRows();
                DynamicObject dynamicObject = null;
                Long id = 0L;
                int index = 0;
                for (ListSelectedRow listSelectedRow : rowCollection) {
                    QFilter q1 = new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue());
                    QFilter q2 = new QFilter("entryentity.id", "=", listSelectedRow.getEntryPrimaryKeyValue());
                    dynamicObject = QueryServiceHelper.queryOne((String)"mal_order", (String)"entryentity.supplier as id,entryentity.supplier.bizpartner", (QFilter[])new QFilter[]{q1, q2});
                    if (index == 0) {
                        id = dynamicObject.getLong("id");
                    }
                    if (!id.equals(dynamicObject.getLong("id"))) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8ba2\u5355\u6240\u5c5e\u5546\u5bb6\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MalOrderListPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ++index;
                }
                Map resultMap = SupplierChatEngineUtil.createSupplierChat(dynamicObject);
                if ("false".equals(resultMap.get("succed"))) {
                    this.getView().showMessage(resultMap.get("message").toString());
                }
                if (!"true".equals(resultMap.get("succed"))) break;
                YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
                yzj.setView(this.getView());
                HashMap mData = new HashMap();
                mData.put("openId", resultMap.get("data"));
                mData.put("userName", "");
                mData.put("chattype", "chat_pc");
                yzj.yzjInterface("createAndChat", mData);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "aftersale": {
                ListSelectedRowCollection str = args.getListSelectedData();
                ArrayList<String> orderNoList = new ArrayList<String>();
                BillList billList = (BillList)this.getControl("billlistap");
                QueryResult queryResult = billList.queryDataBySelectedRows(str);
                DynamicObjectCollection queryResultCollection = queryResult.getCollection();
                for (DynamicObject selectRow : queryResultCollection) {
                    if (BillStatusEnum.AUDIT.getVal().equals(selectRow.getString("billstatus")) || orderNoList.contains(selectRow.getString("billno"))) continue;
                    orderNoList.add(selectRow.getString("billno"));
                    args.setCancel(true);
                }
                if (orderNoList.size() <= 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e2d\u5305\u542b\u672a\u5ba1\u6838\u7684\u5355\u636e\uff0c\u7533\u8bf7\u552e\u540e\u5931\u8d25\u3002", (String)"MalOrderListPlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\uff1a", (String)"MalOrderListPlugin_37", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + String.join((CharSequence)",", orderNoList), MessageTypes.Default);
                break;
            }
            case "trackup": {
                this.trackUp(args);
                break;
            }
            case "trackdown": {
                this.trackDownOp(args);
                break;
            }
            case "cancelorder": {
                this.checkCancelMsg(args);
                break;
            }
            case "submit": {
                this.checkSubmit(args);
                break;
            }
        }
    }

    private void checkSubmit(BeforeDoOperationEventArgs args) {
        if (null != this.getPageCache().get("continue")) {
            this.getPageCache().remove("continue");
            return;
        }
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        if (selCollection.size() > 0) {
            MalGoodsMonitorLogService malGoodsMonitorLogService;
            Collection collection;
            ArrayList<Long> orderIds = new ArrayList<Long>(16);
            for (ListSelectedRow listSelectedRow : selCollection) {
                orderIds.add(Long.parseLong(String.valueOf(listSelectedRow.getPrimaryKeyValue())));
            }
            QFilter qFilter = new QFilter("id", "in", orderIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)"A"));
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"mal_order", (String)"billno,platform,deporg,entryentity.goods goods", (QFilter[])qFilter.toArray());
            ArrayList<String> goodsIds = new ArrayList<String>(16);
            HashMap goodsIds_OrgIdsMap = new HashMap(16);
            HashMap<String, String> billno_goodsOrgMap = new HashMap<String, String>(16);
            for (DynamicObject row : orders) {
                if (null == row.get("goods")) continue;
                Long orgId = row.getLong("deporg");
                goodsIds.add(row.getString("goods"));
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString("platform"))) {
                    List<Long> orgIds = new ArrayList<Long>(16);
                    if (null != goodsIds_OrgIdsMap.get(row.getLong("goods"))) {
                        orgIds = (List)goodsIds_OrgIdsMap.get(row.getLong("goods"));
                    }
                    orgIds.add(orgId);
                    goodsIds_OrgIdsMap.put(row.getLong("goods"), orgIds);
                    billno_goodsOrgMap.put(row.getString("billno"), row.getString("goods") + orgId);
                    continue;
                }
                billno_goodsOrgMap.put(row.getString("billno"), row.getString("goods"));
            }
            HashMap<String, String> goodsOrg_PoolIdMap = new HashMap<String, String>(16);
            HashMap<String, String> goodsId_PoolIdMap = new HashMap<String, String>(16);
            QFilter goodsQf = new QFilter("goods.id", "in", goodsIds_OrgIdsMap.keySet());
            DynamicObjectCollection pmmProdPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.id,id,entryentity.orgname,isgoodvisible", (QFilter[])goodsQf.toArray());
            HashSet<Long> prodPoolIds = new HashSet<Long>(16);
            for (Object row : pmmProdPools) {
                String string = row.getString("entryentity.orgname");
                long goodsId = row.getLong("goods.id");
                List orgIds = (List)goodsIds_OrgIdsMap.get(goodsId);
                if (row.getBoolean("isgoodvisible")) {
                    prodPoolIds.add(row.getLong("id"));
                    goodsId_PoolIdMap.put(String.valueOf(goodsId), row.getString("id"));
                    continue;
                }
                if (!orgIds.contains(row.getLong("entryentity.orgname"))) continue;
                prodPoolIds.add(row.getLong("id"));
                goodsOrg_PoolIdMap.put(goodsId + string, row.getString("id"));
            }
            HashMap billno_GoodsIdMap = new HashMap(16);
            for (Map.Entry entry : billno_goodsOrgMap.entrySet()) {
                String billno = (String)entry.getKey();
                if (null != goodsOrg_PoolIdMap.get(entry.getValue())) {
                    billno_GoodsIdMap.put(billno, goodsOrg_PoolIdMap.get(entry.getValue()));
                    continue;
                }
                boolean isExistAllOrg = false;
                for (Map.Entry entry2 : goodsId_PoolIdMap.entrySet()) {
                    String goodIds = (String)entry2.getKey();
                    if (!((String)entry.getValue()).contains(goodIds)) continue;
                    billno_GoodsIdMap.put(billno, entry2.getValue());
                    isExistAllOrg = true;
                    break;
                }
                if (isExistAllOrg) continue;
                billno_GoodsIdMap.put(billno, entry.getValue());
            }
            if (goodsIds.size() > 0 && (collection = (malGoodsMonitorLogService = new MalGoodsMonitorLogService()).getGoodsMonitorLogs(goodsIds, new ArrayList(prodPoolIds))) != null && collection.size() > 0) {
                String disableDeatialMsg = malGoodsMonitorLogService.getDisableDetailOrderMsg(collection, billno_GoodsIdMap);
                if (!StringUtils.isEmpty((CharSequence)disableDeatialMsg)) {
                    String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u7981\u6b62\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 \u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalOrderListPlugin_47", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(msg, disableDeatialMsg, MessageTypes.Default);
                    args.setCancel(true);
                    return;
                }
                String notifyDeatialMsg = malGoodsMonitorLogService.getNotifyDetailOrderMsg(collection, billno_GoodsIdMap);
                if (!StringUtils.isEmpty((CharSequence)notifyDeatialMsg)) {
                    String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u4f01\u4e1a\u89c4\u5b9a\u7684\u76d1\u63a7\u9608\u503c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u8be6\u60c5\u53ef\u8054\u7cfb\u4f01\u4e1a\u5546\u57ce\u8fd0\u8425\u4eba\u5458\u6216\u67e5\u8be2\u5546\u54c1\u76d1\u63a7\u65e5\u5fd7", (String)"MalOrderListPlugin_48", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    HashMap<Integer, String> hashMap = new HashMap<Integer, String>(16);
                    hashMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u4e0b\u5355", (String)"MalOrderListPlugin_49", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(msg, notifyDeatialMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("notifymsg", (IFormPlugin)this), hashMap);
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private void checkCancelMsg(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selCollection = ((IListView)this.getView()).getSelectedRows();
        if (selCollection.size() > 0) {
            Object primaryKeyValue = selCollection.get(0).getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(primaryKeyValue)));
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"mal_order", (String)"billstatus,platform,entryentity.erpbillnumber,entryentity.entrystatus,entryentity.id,entryentity.erpbillstatus,entryentity.erplogstatus", (QFilter[])qFilter.toArray());
            boolean isallcancelFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"ispartcancel").and(new QFilter("paramvalue", "=", (Object)"N"))});
            String msg = ResManager.loadKDString((String)"\u8ba2\u5355\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d6\u6d88\uff1f", (String)"MalOrderListPlugin_41", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            DynamicObject order = (DynamicObject)orders.get(0);
            String platform = order.getString("platform");
            if (!(ApiConfigUtil.hasCQScmConfig() || !isallcancelFlag && (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)))) {
                msg = ResManager.loadKDString((String)"\u8ba2\u5355\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d6\u6d88\uff1f", (String)"MalOrderListPlugin_41", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            } else {
                msg = ResManager.loadKDString((String)"\u4ec5\u81ea\u5efa\u3001\u4eac\u4e1c\u3001\u4eac\u4e1c\u5de5\u4e1a\u54c1\u652f\u6301\u6309\u5206\u5f55\u53d6\u6d88\u8ba2\u5355\uff0c\u5176\u4ed6\u7535\u5546\u5c06\u53d6\u6d88\u6574\u4e2a\u8ba2\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderListPlugin_42", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                Map listUserOptions = ((ListShowParameter)this.getView().getFormShowParameter()).getListUserOption().getListUserOptions();
                Object ismergerows = listUserOptions.get("ismergerows");
                if (!Boolean.parseBoolean(String.valueOf(ismergerows))) {
                    msg = ResManager.loadKDString((String)"\u8ba2\u5355\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d6\u6d88\uff1f", (String)"MalOrderListPlugin_41", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                } else {
                    FormOperate source = (FormOperate)args.getSource();
                    OperateOption option = source.getOption();
                    ListSelectedRowCollection slCollection = ((IListView)this.getView()).getSelectedRows();
                    ArrayList<String> entryIdList = new ArrayList<String>(16);
                    for (int i = 0; i < slCollection.size(); ++i) {
                        Iterator entryId = slCollection.get(i).getEntryPrimaryKeyValue();
                        if (null == entryId) continue;
                        entryIdList.add(String.valueOf(entryId));
                    }
                    ArrayList<Long> entryIds = new ArrayList<Long>(16);
                    for (String entryId : entryIdList) {
                        entryIds.add(Long.parseLong(entryId));
                    }
                    entryIdList.clear();
                    if (orders.size() > 0) {
                        String erpbillstatus;
                        String erplogstatus;
                        for (DynamicObject row : orders) {
                            String entrystatus = row.getString("entryentity.entrystatus");
                            long entryId = row.getLong("entryentity.id");
                            if (!entryIds.contains(entryId) || "F".equals(entrystatus)) continue;
                            entryIdList.add(row.getString("entryentity.id"));
                        }
                        if (entryIdList.size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f\u72b6\u6001\u7684\u8ba2\u5355\u5206\u5f55\u4e0d\u5141\u8bb8\u53d6\u6d88\u3002", (String)"MalOrderListPlugin_40", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        String billsatus = ((DynamicObject)orders.get(0)).getString("billstatus");
                        if ("A".equals(billsatus)) {
                            msg = ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u7684\u8ba2\u5355\u53ea\u80fd\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderListPlugin_50", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                        }
                        if ("B".equals(billsatus)) {
                            msg = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7684\u8ba2\u5355\u53ea\u80fd\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderListPlugin_45", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                        }
                        HashSet<String> submitOrderNos = new HashSet<String>(16);
                        HashSet<String> confirmOrderNos = new HashSet<String>(16);
                        for (DynamicObject row : orders) {
                            if (!entryIdList.contains(row.getString("entryentity.id")) || StringUtils.isEmpty((CharSequence)row.getString("entryentity.erpbillnumber"))) continue;
                            erplogstatus = row.getString("entryentity.erplogstatus");
                            erpbillstatus = row.getString("entryentity.erpbillstatus");
                            if ("A".equals(erpbillstatus) || "B".equals(erpbillstatus)) {
                                submitOrderNos.add(row.getString("entryentity.erpbillnumber"));
                                continue;
                            }
                            if (!"H".equals(erplogstatus)) continue;
                            confirmOrderNos.add(row.getString("entryentity.erpbillnumber"));
                        }
                        if (confirmOrderNos.size() > 0 && submitOrderNos.size() > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u5f20\u4e0d\u540c\u72b6\u6001\u7684\u91c7\u8d2d\u8ba2\u5355\u540c\u65f6\u53d6\u6d88\u3002", (String)"MalOrderListPlugin_46", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        for (DynamicObject row : orders) {
                            if (!entryIdList.contains(row.getString("entryentity.id"))) continue;
                            erplogstatus = row.getString("entryentity.erplogstatus");
                            erpbillstatus = row.getString("entryentity.erpbillstatus");
                            if ("A".equals(erpbillstatus) || "B".equals(erpbillstatus)) {
                                msg = ResManager.loadKDString((String)"\u5b58\u5728\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u662f\u5df2\u63d0\u4ea4\u7684\u5206\u5f55\uff0c\u8be5\u5206\u5f55\u7684\u8ba2\u5355\u5c06\u6574\u5355\u53d6\u6d88\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderListPlugin_44", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                                break;
                            }
                            if (!"H".equals(erplogstatus)) continue;
                            msg = ResManager.loadKDString((String)"\u4ec5\u81ea\u5efa\u3001\u4eac\u4e1c\u3001\u4eac\u4e1c\u5de5\u4e1a\u54c1\u652f\u6301\u6309\u5206\u5f55\u53d6\u6d88\u8ba2\u5355\uff0c\u5176\u4ed6\u7535\u5546\u5c06\u53d6\u6d88\u6574\u4e2a\u8ba2\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MalOrderListPlugin_42", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                            break;
                        }
                        option.setVariableValue("entryIds", SerializationUtils.toJsonString(entryIdList));
                        source.setOption(option);
                    }
                }
            }
            if (null == this.getPageCache().get("cancel")) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("cancel", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack);
                args.setCancel(true);
            }
        }
    }

    private void trackUp(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection slCollection = ((IListView)this.getView()).getSelectedRows();
        if (slCollection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalOrderListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long[] idList = new Long[slCollection.size()];
        for (int i = 0; i < slCollection.size(); ++i) {
            idList[i] = (Long)slCollection.get(i).getPrimaryKeyValue();
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("botp_track_only_dirt_link", "true");
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)"mal_order", (String)"mal_order", (Long[])idList, (Long[])idList, (OperateOption)operateOption);
        if (bfRowList.isEmpty()) {
            ArrayList<Long> erpSourceIdList = new ArrayList<Long>();
            QFilter idFilter = new QFilter("id", "in", (Object)idList);
            DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)"mal_order", (String)"id,entryentity.erpsourceid erpsourceid,entryentity.erpsourcebilltype erpsourcebilltype,deporg", (QFilter[])new QFilter[]{idFilter});
            if (null != dyoCollection && !dyoCollection.isEmpty()) {
                for (DynamicObject dyo : dyoCollection) {
                    if (!"pm_purapplybill".equals(dyo.getString("erpsourcebilltype")) || 0L == dyo.getLong("erpsourceid")) continue;
                    erpSourceIdList.add(dyo.getLong("erpsourceid"));
                }
            }
            if (!erpSourceIdList.isEmpty()) {
                ArrayList<Long> purApplyBillIdSet = new ArrayList<Long>(erpSourceIdList.size());
                DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pm_purapplybill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", erpSourceIdList)});
                ArrayList<Long> noPermissionList = new ArrayList<Long>();
                if (dyoCol != null && !dyoCol.isEmpty()) {
                    for (DynamicObject dyo : dyoCol) {
                        String appId = MalBizFowUtil.getPcAppId((String)"pm_purapplybill");
                        long deporg = dyo.getLong("org");
                        int hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)deporg, (String)"15", (String)appId, (String)"pm_purapplybill", (String)"47150e89000000ac");
                        if (hasPermResult != 1) {
                            noPermissionList.add(dyo.getLong("id"));
                            continue;
                        }
                        purApplyBillIdSet.add(dyo.getLong("id"));
                    }
                }
                if (purApplyBillIdSet.isEmpty()) {
                    if (!noPermissionList.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u7533\u8bf7\u5355\u201d\u7533\u8bf7\u7ec4\u7ec7\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderListPlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderListPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    }
                    evt.setCancel(true);
                    return;
                }
                if (purApplyBillIdSet.size() == 1) {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"pm_purapplybill", purApplyBillIdSet.get(0), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                } else {
                    OpenFormUtil.openListPage((IFormView)this.getView(), (String)"pm_purapplybill", (ShowType)ShowType.MainNewTabPage, null, (QFilter)new QFilter("id", "in", purApplyBillIdSet), (CloseCallBack)new CloseCallBack());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderListPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            evt.setCancel(true);
        }
    }

    private void trackDownOp(BeforeDoOperationEventArgs evt) {
        BFRowLinkDownNode bfRowLinkDownNode;
        Long malId;
        ListSelectedRowCollection slCollection = ((IListView)this.getView()).getSelectedRows();
        if (slCollection.isEmpty()) {
            return;
        }
        Long[] idList = new Long[slCollection.size()];
        for (int i = 0; i < slCollection.size(); ++i) {
            idList[i] = (Long)slCollection.get(i).getPrimaryKeyValue();
        }
        Map map = BFTrackerServiceHelper.loadBillLinkDownNodes((String)"mal_order", (Long[])idList, (boolean)false);
        DynamicObjectCollection order = QueryServiceHelper.query((String)"mal_order", (String)"id,billno,entryentity.erpbillnumber,entryentity.erpsourcebilltype erpsourcebilltype,entryentity.erpbillnumber erpbillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
        ArrayList<String> list = new ArrayList<String>(order.size());
        ArrayList<String> malNumberList = new ArrayList<String>();
        HashMap<String, Long> purOrderNumAndMalIdMap = new HashMap<String, Long>();
        ArrayList<Long> malBillIdList = new ArrayList<Long>();
        for (DynamicObject dyn : order) {
            String erpbillnumber = dyn.getString("entryentity.erpbillnumber");
            if (!StringUtils.isBlank((CharSequence)erpbillnumber)) {
                list.add(erpbillnumber);
                purOrderNumAndMalIdMap.put(erpbillnumber, dyn.getLong("id"));
            }
            if ("pm_purapplybill".equals(dyn.getString("erpsourcebilltype")) && !"".equals(dyn.getString("erpbillnumber"))) {
                malBillIdList.add(dyn.getLong("id"));
            }
            if (malNumberList.contains(dyn.getString("billno"))) continue;
            malNumberList.add(dyn.getString("billno"));
        }
        boolean open = false;
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>();
        Long malOrderMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order");
        if (!list.isEmpty()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pur_order", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", list)});
            HashMap<Long, ArrayList<Long>> malIdAndPurOrderIdMap = new HashMap<Long, ArrayList<Long>>();
            for (Object dyn : query) {
                Long l = (Long)purOrderNumAndMalIdMap.get(dyn.getString("billno"));
                ArrayList<Long> purOrderList = (ArrayList<Long>)malIdAndPurOrderIdMap.get(l);
                if (purOrderList == null) {
                    purOrderList = new ArrayList<Long>();
                    malIdAndPurOrderIdMap.put(l, purOrderList);
                }
                purOrderList.add(dyn.getLong("id"));
            }
            open = true;
            Long purOrderMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order");
            for (Map.Entry entry : malIdAndPurOrderIdMap.entrySet()) {
                malId = (Long)entry.getKey();
                List purOrderList = (List)entry.getValue();
                bfRowLinkDownNode = MalBizFowUtil.getBFRowLinkDownNode((Long)malOrderMainTableId, (Long)malId, (Long)purOrderMainTableId, (List)purOrderList);
                nodes.add(bfRowLinkDownNode);
            }
        }
        if (!malBillIdList.isEmpty()) {
            List<Long> pmOrderList;
            DynamicObjectCollection pmOrder = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.soubillid soubillid", (QFilter[])new QFilter[]{new QFilter("billentry.soubillid", "in", malBillIdList)});
            HashMap<Long, ArrayList<Long>> malIdAndPmOrderMap = new HashMap<Long, ArrayList<Long>>();
            for (Object dyn : pmOrder) {
                long l = dyn.getLong("soubillid");
                pmOrderList = (ArrayList<Long>)malIdAndPmOrderMap.get(l);
                if (pmOrderList == null) {
                    pmOrderList = new ArrayList<Long>();
                    malIdAndPmOrderMap.put(l, (ArrayList<Long>)pmOrderList);
                }
                pmOrderList.add(dyn.getLong("id"));
            }
            open = true;
            Long pmPurOrderBillMainTableId = MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill");
            for (Map.Entry entry : malIdAndPmOrderMap.entrySet()) {
                malId = (Long)entry.getKey();
                pmOrderList = (List)entry.getValue();
                bfRowLinkDownNode = MalBizFowUtil.getBFRowLinkDownNode((Long)malOrderMainTableId, (Long)malId, (Long)pmPurOrderBillMainTableId, pmOrderList);
                nodes.add(bfRowLinkDownNode);
            }
        }
        if (map != null && map.size() > 0) {
            ArrayList<Long> mainIdList = new ArrayList<Long>();
            mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order"));
            mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill"));
            mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_returnreq"));
            mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill"));
            mainIdList.add(MalBizFowUtil.getMainTableId((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order"));
            open = true;
            for (BFRowLinkDownNode bfRowLinkDownNode2 : map.values()) {
                this.deleteUnRelativeEntity(bfRowLinkDownNode2, mainIdList);
            }
            nodes.addAll(map.values());
        }
        if (!open) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalOrderListPlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_lookuptracker");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPageId(this.setPageId(nodes));
            showParameter.setCaption(this.setCaption(malNumberList));
            showParameter.getCustomParams().put("linknodes", SerializationUtils.serializeToBase64(nodes));
            showParameter.getCustomParams().put("lookuptype", "lookdown");
            showParameter.getCustomParams().put("track_checkrightappids", "");
            this.getView().showForm(showParameter);
        }
        evt.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        String itemKey = args.getOperateKey();
        if (null == result || !result.isSuccess()) {
            if (itemKey.equals("cancelorder")) {
                this.getPageCache().remove("cancel");
            }
            return;
        }
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection listcol = billlist.getSelectedRows();
        Object[] pks = listcol.getPrimaryKeyValues();
        switch (itemKey) {
            case "autoreceive": {
                log.info("\u65b0\u7248\u7535\u5546\u751f\u6210\u6536\u8d27\t");
                Map<String, Set<String>> sourceReceiveEcPOrderIdSetMap = this.autoReceive(listcol.getEntryPrimaryKeyValues());
                if (sourceReceiveEcPOrderIdSetMap.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8ba2\u5355\u4e0d\u6ee1\u8db3\u7535\u5546\u9a8c\u6536\u6761\u4ef6\uff0c\u8bf7\u901a\u8fc7\u7535\u5546\u72b6\u6001\u66f4\u65b0\u529f\u80fd\u66f4\u65b0\u7535\u5546\u8ba2\u5355\u72b6\u6001\uff0c\u518d\u8fdb\u884c\u786e\u8ba4\u6536\u8d27\u3002\u82e5\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4ecd\u4e0d\u6ee1\u8db3\u6536\u8d27\u6761\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u7535\u5546\u5ba2\u670d\u4eba\u5458\u534f\u52a9\u5904\u7406\u3002", (String)"MalOrderListPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    break;
                }
                int count = 0;
                for (Set<String> ecOrderIdSet : sourceReceiveEcPOrderIdSetMap.values()) {
                    count += ecOrderIdSet.size();
                }
                if (count != pks.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5546\u90e8\u5206\u786e\u8ba4\u6536\u8d27\u6210\u529f\u3002", (String)"MalOrderListPlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7535\u5546\u786e\u8ba4\u6536\u8d27\u6210\u529f\u3002", (String)"MalOrderListPlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "receive": {
                log.info("$$$$$\u8ba2\u5355\u6536\u8d27\u5f00\u59cb");
                MalOrderUtil.autoRrecive();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u81ea\u52a8\u6536\u8d27\uff0c\u8bf7\u68c0\u67e5\u6536\u8d27\u5355\u636e\u662f\u5426\u751f\u6210\u6210\u529f\u3002", (String)"MalOrderListPlugin_38", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "aftersale": {
                IListView view = (IListView)this.getView();
                ListSelectedRowCollection listSelectedRows = view.getSelectedRows();
                Object[] entryIDsArr = listSelectedRows.getEntryPrimaryKeyValues();
                ArrayList<String> entryIDs = new ArrayList<String>(entryIDsArr.length);
                for (Object entryID : entryIDsArr) {
                    entryIDs.add(entryID.toString());
                }
                AfterSaleValidateInfo afterSaleValidateInfo = MalOrderEntityUtil.afterSaleCheck(entryIDs);
                Map afterSaleCheckMap = afterSaleValidateInfo.getMalOrderIdEntryIdsMap();
                if (!afterSaleValidateInfo.getErrorInfos().isEmpty()) {
                    this.getView().showTipNotification((String)afterSaleValidateInfo.getErrorInfos().get(0));
                    return;
                }
                if (afterSaleValidateInfo.getMalOrderIdEntryIdsMap().isEmpty()) {
                    return;
                }
                MutexHelper.require((String)"mal_order", (Object)pks[0], (String)"aftersale", (StringBuilder)new StringBuilder("lock"));
                this.getPageCache().put("lockId", pks[0].toString());
                Map.Entry afterSaleCheckEntry = afterSaleCheckMap.entrySet().iterator().next();
                String malOrderEntryIds = String.join((CharSequence)",", (Iterable)afterSaleCheckEntry.getValue());
                HashMap paramMap = new HashMap();
                paramMap.put("malOrderId", afterSaleCheckEntry.getKey());
                paramMap.put("malOrderEntry", malOrderEntryIds);
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_aftersale", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "aftersale"), (ShowType)ShowType.Modal));
                break;
            }
            case "jdconfirmrecevie": {
                String resultstr = this.jdconfirmrecevie();
                if (resultstr != null && resultstr.length() > 2) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u4eac\u4e1c\u6536\u8d27\u72b6\u6001\u6210\u529f\u3002", (String)"MalOrderListPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]), resultstr, MessageTypes.Default);
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u4eac\u4e1c\u6536\u8d27\u72b6\u6001\u5b8c\u6210\u3002", (String)"MalOrderListPlugin_31", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "confirmandreceive": {
                log.info("$$$$$\u66f4\u65b0\u4eac\u4e1c\u786e\u8ba4\u6536\u8d27\u72b6\u6001\u5f00\u59cb");
                String resultstr = this.jdconfirmrecevie();
                log.info("$$$$$\u8ba2\u5355\u6536\u8d27\u5f00\u59cb");
                MalOrderUtil.autoRrecive();
                if (resultstr != null && resultstr.length() > 2) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u72b6\u6001&\u6536\u8d27\u5b8c\u6210\u3002", (String)"MalOrderListPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]), resultstr, MessageTypes.Default);
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u72b6\u6001&\u6536\u8d27\u6210\u529f\u3002", (String)"MalOrderListPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "pushreceipt": {
                log.info("$$$$\u5b9e\u6536\u5904\u7406\u8df3\u8f6c");
                this.jumpToBatReceive();
                break;
            }
            case "cancelorder": {
                if (null == this.getPageCache().get("cancel")) break;
                this.getPageCache().remove("cancel");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private Map<String, Set<String>> autoReceive(Object[] entryIds) {
        Map<String, DynamicObjectCollection> sourceMalOrderCol = this.querySelectedMalOrderByEntryPks(entryIds);
        HashMap<String, Set<String>> sourceReceiveEcPOrderIdSetMap = new HashMap<String, Set<String>>();
        sourceMalOrderCol.forEach((source, malOrderCol) -> {
            DynamicObjectCollection ecOrderCol;
            String ecOrderEntity = MalNewOrderUtils.getPlatformId((String)source);
            HashSet<String> ecOrderSet = new HashSet<String>(malOrderCol.size() * 2);
            HashSet<String> ecPOrderIdSet = new HashSet<String>(malOrderCol.size() * 2);
            HashSet<Long> ecOrderPkSet = new HashSet<Long>();
            for (DynamicObject malOrder : malOrderCol) {
                ecOrderPkSet.add(malOrder.getLong("order"));
            }
            if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
                ecOrderCol = QueryServiceHelper.query((String)ecOrderEntity, (String)"id,number,jdorderid", (QFilter[])new QFilter[]{new QFilter("id", "in", ecOrderPkSet).and(this.getStateFilter((String)source))});
                for (DynamicObject ecOrder : ecOrderCol) {
                    ecOrderSet.add(ecOrder.getString("number"));
                    ecPOrderIdSet.add(ecOrder.getString("jdorderid"));
                }
                if (!ecPOrderIdSet.isEmpty()) {
                    this.pushRecieve((Set<String>)ecOrderSet, (String)source, (Set<String>)ecPOrderIdSet, MalNewOrderUtils.getPlatformId((String)source), "id,number", "number");
                }
            } else {
                ecOrderCol = QueryServiceHelper.query((String)ecOrderEntity, (String)"id,orderid,porderid", (QFilter[])new QFilter[]{new QFilter("id", "in", ecOrderPkSet).and(this.getStateFilter((String)source))});
                for (DynamicObject ecOrder : ecOrderCol) {
                    ecOrderSet.add(ecOrder.getString("orderid"));
                    ecPOrderIdSet.add(ecOrder.getString("porderid"));
                }
                if (!ecPOrderIdSet.isEmpty()) {
                    this.pushRecieve((Set<String>)ecOrderSet, (String)source, (Set<String>)ecPOrderIdSet, MalNewOrderUtils.getPlatformId((String)source), "id,orderid", "orderid");
                }
            }
            if (!ecOrderSet.isEmpty()) {
                sourceReceiveEcPOrderIdSetMap.put((String)source, (Set<String>)ecPOrderIdSet);
            }
        });
        return sourceReceiveEcPOrderIdSetMap;
    }

    private QFilter getStateFilter(String source) {
        QFilter ecStateFilter = null;
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            ecStateFilter = new QFilter("orderstate", "=", (Object)"4");
        }
        if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_CG.getVal().equals(source)) {
            ecStateFilter = new QFilter("state", "=", (Object)"1");
        }
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            ecStateFilter = new QFilter("jdstate", "in", (Object)Stream.of("1", "3").toArray());
        }
        if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(source)) {
            ecStateFilter = new QFilter("state", "=", (Object)"4");
        }
        if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) {
            ecStateFilter = new QFilter("state", "in", (Object)Stream.of("60", "70", "80").toArray());
        }
        if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(source)) {
            ecStateFilter = new QFilter("state", "in", (Object)"1");
        }
        return ecStateFilter;
    }

    private Map<String, DynamicObjectCollection> querySelectMalOrderByFilter(QFilter filter) {
        HashMap<String, DynamicObjectCollection> res = new HashMap<String, DynamicObjectCollection>(16);
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "id,billno,platform,ecorderid pOrder,entryentity.order order";
        DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)selectProperties, (QFilter[])filters);
        for (DynamicObject malOrder : malOrders) {
            String platform = malOrder.getString("platform");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrder.getString("platform"))) continue;
            DynamicObjectCollection col = (DynamicObjectCollection)res.get(platform);
            if (col == null) {
                col = new DynamicObjectCollection();
            }
            col.add((Object)malOrder);
            res.put(platform, col);
        }
        return res;
    }

    private Map<String, DynamicObjectCollection> querySelectedMalOrderByEntryPks(Object[] entryIds) {
        QFilter filter = new QFilter("entryentity.id", "in", (Object)entryIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("platform", "!=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        return this.querySelectMalOrderByFilter(filter);
    }

    public void pushRecieve(Set<String> orderSet, String source, Set<String> pOrderIdSet, String entity, String selectors, String filterKey) {
        Set completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(orderSet, (String)entity, (String)selectors, (String)filterKey);
        DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder((String)source, pOrderIdSet);
        if (null == purOrders || purOrders.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u57ce\u8ba2\u5355\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"MalOrderListPlugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        new EcOrderAutoReceiceProxy(EcOrderAutoReceiveFactory.getEcOrderAutoReceiveServiceByConnectErp()).autoReceive(purOrders, completeIds);
    }

    private String jdconfirmrecevie() {
        log.info("$$$$$\u5355\u72ec\u66f4\u65b0\u4eac\u4e1c\u786e\u8ba4\u6536\u8d27\u72b6\u6001\u5f00\u59cb");
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection listcol = billlist.getSelectedRows();
        return MalOrderUtil.jdconfirmrecevie((Object[])listcol.getPrimaryKeyValues());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean defaultMalVersion = MalOrderParamUtil.getDefaultMalVersion();
        this.getView().setVisible(defaultMalVersion ? Boolean.FALSE : Boolean.TRUE, new String[]{"jdconfirm"});
        this.getView().setVisible(defaultMalVersion ? Boolean.TRUE : Boolean.FALSE, new String[]{"confirmreceived"});
        if (defaultMalVersion) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"compareresult", "compareid", "compareremark"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"compareresult", "compareid", "compareremark"});
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (null != fsp.getCustomParam("status")) {
            String malkey = (String)fsp.getCustomParam("status");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblclose", "pushreceipt"});
            switch (malkey) {
                case "savesubmit": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbllogistics", "confirmreceived", "jdconfirm", "tblaftersale", "tblclose", "bar_trackdown"});
                    break;
                }
                case "saloutcount": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "tbllogistics", "tblclose", "baritemap1", "confirmreceived", "jdconfirm", "tblaftersale", "malconfirm"});
                    break;
                }
                case "receivecount": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "baritemap1", "tblclose", "jdconfirm", "tblcancel", "malconfirm"});
                    break;
                }
                case "finishcount": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "tblcancel", "baritemap1", "tbllogistics", "tblclose", "confirmreceived", "jdconfirm", "malconfirm"});
                    break;
                }
                case "cancelcount": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "baritemap1", "tblclose", "tblcancel", "tbllogistics", "confirmreceived", "jdconfirm", "tblaftersale", "bar_track", "wechat"});
                }
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        boolean newVersion = MalOrderUtil.getDefaultMalVersion();
        for (IListColumn item : columnList) {
            String fieldName = item.getListFieldKey();
            if ("jdorder.invoicestate".equals(fieldName) || "jdorder.invoiceresult".equals(fieldName)) {
                item.setVisible(newVersion ? 0 : 63);
            }
            if (!"invoicestate".equals(fieldName) && !"invoiceresult".equals(fieldName)) continue;
            item.setVisible(0);
        }
    }

    public void pageRelease(EventObject e) {
        MutexHelper.release((String)"mal_order", (String)"aftersale", (String)this.getPageCache().get("lockId"));
    }

    private void jumpToBatReceive() {
        Boolean isAutoReceive = ParamUtil.getBooleanParam((String)"isautoreceive");
        if (isAutoReceive.booleanValue()) {
            this.showErrorTip();
            return;
        }
        ArrayList<Long> entryIds = new ArrayList<Long>();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rowCollection = listView.getSelectedRows();
        for (ListSelectedRow listSelectedRow : rowCollection) {
            entryIds.add((Long)listSelectedRow.getEntryPrimaryKeyValue());
        }
        DynamicObjectCollection malOrderDynColl = QueryServiceHelper.query((String)"mal_order", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryIds)});
        ArrayList<String> enableEntryIds = new ArrayList<String>();
        for (DynamicObject malOrder : malOrderDynColl) {
            String erplogstatus = malOrder.getString("erplogstatus");
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrder.getString("platform")) || !LogisticsStatusEnum.ALLOUTSTOCK.getVal().equals(erplogstatus) && !LogisticsStatusEnum.PARTRECIPT.getVal().equals(erplogstatus) && !LogisticsStatusEnum.PARTINSTOCK.getVal().equals(erplogstatus) && !LogisticsStatusEnum.PARTOUTSTOCK.getVal().equals(erplogstatus)) continue;
            enableEntryIds.add(malOrder.getString("entryid"));
        }
        if (enableEntryIds.isEmpty()) {
            this.showErrorTip();
            return;
        }
        DynamicObjectCollection purOrderDynColl = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.id entryid,materialentry.srcentryid srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", enableEntryIds)});
        ArrayList<String> purOrderEntryIds = new ArrayList<String>();
        for (DynamicObject purOrder : purOrderDynColl) {
            purOrderEntryIds.add(purOrder.getString("entryid"));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pur_batreceive");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("sourceBill", (Object)"mal_order");
        formShowParameter.setCustomParam("purOrderEntryIds", purOrderEntryIds);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "jumpToBarReceive"));
        this.getView().showForm(formShowParameter);
    }

    private String getSelectProperties() {
        return "id,platform,entryentity.id entryid,entryentity.erplogstatus erplogstatus,entryentity.erpbillnumber erpbillnumber";
    }

    private void showErrorTip() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u884c\u4e0d\u6ee1\u8db3\u5b9e\u6536\u5904\u7406\u6761\u4ef6\uff0c\u8bf7\u6309\u4ee5\u4e0b\u6761\u4ef6\u68c0\u67e5\uff1a", (String)"MalOrderListPlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1\u3001\u53c2\u6570\u81ea\u52a8\u751f\u6210\u6536\u8d27 \u8bbe\u7f6e\u4e3a\u5426\u3002", (String)"MalOrderListPlugin_39", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2\u3001\u5546\u57ce\u8ba2\u5355\u7c7b\u578b\u4e3a\u81ea\u5efa\u5546\u57ce\u3002", (String)"MalOrderListPlugin_28", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3\u3001\u9009\u4e2d\u7684\u884c\u7269\u6d41\u72b6\u6001\u4e3a\u5df2\u53d1\u8d27\u6216\u4e3a\u90e8\u5206\u6536\u8d27\u6216\u4e3a\u90e8\u5206\u5165\u5e93\u3002", (String)"MalOrderListPlugin_29", (String)"scm-mal-formplugin", (Object[])new Object[0]));
    }
}

