/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.mvc.list.ListDataProvider;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;

class MalProdBrowsingHistoryListDataProvider
extends ListDataProvider {
    MalProdBrowsingHistoryListDataProvider() {
    }

    public DynamicObjectCollection getData(int arg0, int arg1) {
        long goodsId;
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty()) {
            return rows;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"goodsstatus")) {
            return rows;
        }
        long orgId = RequestContext.get().getOrgId();
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(16);
        for (DynamicObject row : rows) {
            DynamicObject goods = row.getDynamicObject("goods");
            if (null == goods) continue;
            String sku = goods.getString("number");
            String source = goods.getString("source");
            goodsId = goods.getLong("id");
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)sku, (String)source, (BigDecimal)BigDecimal.ONE, null, (Long)orgId));
        }
        if (malMatGoodsInitParams.size() > 0) {
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
            for (DynamicObject row : rows) {
                DynamicObject goods = row.getDynamicObject("goods");
                if (null == goods || null == malGoodsMap.get(goodsId = goods.getLong("id"))) continue;
                MalGoods malGoods = (MalGoods)malGoodsMap.get(goodsId);
                if (!malGoods.validateOrgSaleable(Long.valueOf(RequestContext.get().getOrgId()))) {
                    row.set("goodsstatus", (Object)"2");
                    continue;
                }
                if (!malGoods.validateMallStatus()) {
                    row.set("goodsstatus", (Object)"3");
                    continue;
                }
                if (((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, BigDecimal.ONE) || (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) || selfInventoryUnlimited) && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) continue;
                row.set("goodsstatus", (Object)"1");
            }
        }
        return rows;
    }
}

