/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.PurBizPersonUtil;

public class MalPurOrderListPlugin
extends AbstractListPlugin {
    private static final String CREATOR = "creator";
    private static final String AFTERSALE = "aftersale";
    public static final String BILLID = "billid";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status");
        IFormView view = this.getView();
        if (null != status) {
            switch (String.valueOf(status)) {
                case "savesubmit": {
                    view.setVisible(Boolean.FALSE, new String[]{"tbllogistics", "trackdown", "tblaftersale", "pushreceipt"});
                    break;
                }
                case "saloutcount": {
                    view.setVisible(Boolean.FALSE, new String[]{"tbldel", "tblcheck", "tblsubmit", "tblsubmit", "baritemap1", "tbllogistics", "confirmreceived", "jdconfirm", "tblaftersale"});
                    break;
                }
                case "receivecount": {
                    view.setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "baritemap1", "tblcancel", "confirmreceived", "jdconfirm"});
                    break;
                }
                case "finishcount": {
                    view.setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "baritemap1", "tblcancel", "tbllogistics", "confirmreceived", "jdconfirm", "tblatuoreceive"});
                    break;
                }
                case "cancelcount": {
                    view.setVisible(Boolean.FALSE, new String[]{"tbldel", "tblsubmit", "tblcheck", "baritemap1", "tblcancel", "tbllogistics", "confirmreceived", "jdconfirm", "tblatuoreceive", "tblaftersale", "bar_track"});
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        DynamicObjectCollection bizpersons = PurBizPersonUtil.getBizPartners((String[])new String[]{"billcreator"});
        HashSet<Long> billcreatores = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)bizpersons)) {
            for (DynamicObject bizperson : bizpersons) {
                Long id = bizperson.getLong("billcreator");
                if (null == id || id == 0L) continue;
                billcreatores.add(id);
            }
        }
        QFilter userQFilter = new QFilter(CREATOR, "=", (Object)RequestContext.get().getCurrUserId());
        if (billcreatores.size() > 0) {
            userQFilter.or(new QFilter(CREATOR, "in", billcreatores));
        }
        qFilters.add(userQFilter);
        Map filterMap = BillFormUtil.getCustomParamsForList((Map)this.getView().getFormShowParameter().getCustomParams());
        if (filterMap.size() > 0) {
            qFilters.addAll(CommonUtil.getQueryListFilter((Map)filterMap));
        }
        QFilter srcTypeFilter = new QFilter("srctype", "=", (Object)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal());
        srcTypeFilter.or(new QFilter("srctype", "=", (Object)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal()));
        qFilters.add(srcTypeFilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickUtil.MallGoodsView((IFormView)this.getView(), (String)"mal_purorder", (String)"materialentry.goods", (String)"materialentry.id", (String)"pmm_prodmanage");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemKey = args.getOperateKey()) {
            case "aftersale": {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                String billid = this.afterSalesCheck();
                if (null == billid) {
                    return;
                }
                paramMap.put("orderEntryToAfterSale", billid);
                BillList list = (BillList)this.getView().getControl("billlistap");
                if (null == list.getCurrentSelectedRowInfo() || null == list.getCurrentSelectedRowInfo().getPrimaryKeyValue()) {
                    return;
                }
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"mal_aftersale", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, AFTERSALE), (ShowType)ShowType.Modal));
                break;
            }
        }
    }

    private String afterSalesCheck() {
        String entryid = null;
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listview.getSelectedRows();
        ArrayList<String> entryIDs = new ArrayList<String>();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> jdIdSet = new HashSet<String>();
        for (ListSelectedRow row : selectRows) {
            idSet.add(row.getPrimaryKeyValue().toString());
            entryIDs.add(row.getEntryPrimaryKeyValue().toString());
        }
        QFilter poIdfilter = new QFilter("materialentry.id", "in", entryIDs);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,cfmstatus,logstatus,materialentry.id,materialentry.goods,materialentry.jdorder", (QFilter[])new QFilter[]{poIdfilter});
        if (null != objs && objs.length == 1) {
            for (DynamicObject obj : objs) {
                DynamicObjectCollection entries = obj.getDynamicObjectCollection("materialentry");
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    if (!entryIDs.contains(entry.getPkValue().toString())) continue;
                    jdIdSet.add(entry.getString("jdorder.number"));
                }
            }
        }
        if (idSet.size() > 1 || objs.length != 1 || jdIdSet.size() != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u8ba2\u5355\u53f7\u7684\u5206\u5f55\u53d1\u8d77\u552e\u540e\u7533\u8bf7\uff0c\u7535\u5546\u8ba2\u5355\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u5b50\u8ba2\u5355\u7684\u5206\u5f55\u53d1\u8d77\u552e\u540e\u3002", (String)"MalPurOrderListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject bill = objs[0];
        if (null == bill) {
            return null;
        }
        if (!"B".equalsIgnoreCase(bill.getString("cfmstatus"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u672a\u786e\u8ba4\u4e0d\u80fd\u7533\u8bf7\u552e\u540e\u3002", (String)"MalPurOrderListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (!("D".equalsIgnoreCase(bill.getString("logstatus")) || "E".equalsIgnoreCase(bill.getString("logstatus")) || "F".equalsIgnoreCase(bill.getString("logstatus")) || "G".equalsIgnoreCase(bill.getString("logstatus")))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u672a\u6536\u8d27\u4e0d\u80fd\u7533\u8bf7\u552e\u540e\u3002", (String)"MalPurOrderListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("materialentry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            if (!entryIDs.contains(entry.getPkValue().toString()) || null != entry.getString("goods")) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalPurOrderListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        entryid = String.join((CharSequence)",", entryIDs);
        return entryid;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "aftersale": {
                Object condition = closedCallBackEvent.getReturnData();
                if (condition == null) {
                    return;
                }
                Map map = condition instanceof Map ? (Map)condition : new HashMap();
                Long billId = (Long)map.get(BILLID);
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"mal_returnreq", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)billId, null, null));
            }
        }
    }
}

