/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;

public class MalPurSchemeListPlugin
extends AbstractListPlugin {
    private static final String OP_TO_ORDER = "toorder";
    private static final String OP_ADDCART = "addcart";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.getListUserOption().setMergeRow(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qfilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).and("number", "!=", (Object)RequestContext.get().getUserId());
        List filters = e.getQFilters();
        filters.add(qfilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_number", (CharSequence)args.getFieldName())) {
            DynamicObject goods;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ListSelectedRowCollection focusRows = new ListSelectedRowCollection();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                if (listSelectedRow.getRowKey() != args.getRowIndex()) continue;
                focusRows.add((Object)listSelectedRow);
            }
            if (focusRows.isEmpty()) {
                return;
            }
            QueryResult queryResult = billList.queryDataBySelectedRows(focusRows);
            DynamicObjectCollection col = queryResult.getCollection();
            if (!col.isEmpty() && (goods = ((DynamicObject)col.get(0)).getDynamicObject("goodsentry.goods")) != null) {
                String source = goods.getString("source");
                String goodsId = goods.getString("id");
                String goodsNumber = goods.getString("number");
                String caption = goods.getString("name");
                FormShowParameter detailPageFormShowParam = MalProductDetail.getDetailPageFormShowParam((String)goodsId, (String)goodsNumber, (String)source, (String)caption, (String)"", (ShowType)ShowType.Modal, null, null);
                this.getView().showForm(detailPageFormShowParam);
                args.setCancel(true);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ListDataProvider listDataProvider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynamicObjects = super.getData(start, limit);
                DataEntityPropertyCollection properties = dynamicObjects.getDynamicObjectType().getProperties();
                if (!properties.containsKey((Object)"goodsentry.taxprice")) {
                    dynamicObjects.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("goodsentry.taxprice", BigDecimal.class, (Object)BigDecimal.ZERO));
                }
                if (!properties.containsKey((Object)"goodsentry.taxamount")) {
                    dynamicObjects.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("goodsentry.taxamount", BigDecimal.class, (Object)BigDecimal.ZERO));
                }
                if (!properties.containsKey((Object)"sumtaxamount")) {
                    dynamicObjects.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("sumtaxamount", BigDecimal.class, (Object)BigDecimal.ZERO));
                }
                ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject goods = dynamicObject.getDynamicObject("goodsentry.goods");
                    String source = goods.getString("source");
                    Long goodsId = goods.getLong("id");
                    String goodsNumber = goods.getString("number");
                    malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)goodsNumber, (String)source, (BigDecimal)dynamicObject.getBigDecimal("goodsentry.qty"), (String)"", (Long)RequestContext.get().getOrgId()));
                }
                Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
                HashMap<Long, BigDecimal> id2SumTaxAmount = new HashMap<Long, BigDecimal>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject goods = dynamicObject.getDynamicObject("goodsentry.goods");
                    MalGoods malGoods = (MalGoods)malGoodsMap.get(goods.getLong("id"));
                    if (malGoods == null) continue;
                    dynamicObject.set("goodsentry.taxprice", (Object)malGoods.getTaxPrice());
                    BigDecimal taxAmount = malGoods.getTaxPrice().multiply(dynamicObject.getBigDecimal("goodsentry.qty"));
                    dynamicObject.set("goodsentry.taxamount", (Object)taxAmount);
                    BigDecimal sumTaxAmount = id2SumTaxAmount.getOrDefault(dynamicObject.getLong("id"), BigDecimal.ZERO);
                    id2SumTaxAmount.put(dynamicObject.getLong("id"), sumTaxAmount.add(taxAmount));
                }
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("sumtaxamount", id2SumTaxAmount.get(dynamicObject.getLong("id")));
                }
                return dynamicObjects;
            }
        };
        listDataProvider.getListFields();
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_ADDCART.equals(operateKey) || OP_TO_ORDER.equals(operateKey)) {
            OperateOption option = operate.getOption();
            BillList billList = (BillList)this.getControl("billlistap");
            QueryResult queryResult = billList.queryDataBySelectedRows(billList.getSelectedRows());
            DynamicObjectCollection col = queryResult.getCollection();
            ArrayList<String> selectedGoodsIds = new ArrayList<String>(col.size());
            for (DynamicObject selectedRowDyn : col) {
                selectedGoodsIds.add(selectedRowDyn.getString("goods_id"));
            }
            option.setVariableValue("selectedGoodsIds", StringUtils.join((Object[])selectedGoodsIds.toArray(), (String)","));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_TO_ORDER.equals(afterDoOperationEventArgs.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            QueryResult queryResult = billList.queryDataBySelectedRows(billList.getSelectedRows());
            DynamicObjectCollection col = queryResult.getCollection();
            MalToPlaceOrderParam malToPlaceOrderParam = new MalToPlaceOrderParam();
            ArrayList<MalToPlaceOrderItem> malToPlaceOrderItems = new ArrayList<MalToPlaceOrderItem>();
            for (DynamicObject selectedRowDyn : col) {
                DynamicObject goods = selectedRowDyn.getDynamicObject("goodsentry.goods");
                malToPlaceOrderParam.setDptOrgId(Long.valueOf(RequestContext.get().getOrgId()));
                String goodsId = goods.getString("id");
                String goodsNumber = goods.getString("number");
                String source = goods.getString("source");
                BigDecimal qty = selectedRowDyn.getBigDecimal("goodsentry.qty");
                MalToPlaceOrderItem malToPlaceOrderItem = new MalToPlaceOrderItem();
                malToPlaceOrderItem.setGoodsId(Long.valueOf(goodsId));
                malToPlaceOrderItem.setGoodsNumber(goodsNumber);
                malToPlaceOrderItem.setPlatform(source);
                malToPlaceOrderItem.setQty(qty);
                malToPlaceOrderItems.add(malToPlaceOrderItem);
            }
            malToPlaceOrderParam.setMalToPlaceOrderItemList(malToPlaceOrderItems);
            malToPlaceOrderParam.setValidateGoodsForPlaceOrder(false);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("mal_placeorder");
            parameter.setCustomParam("MAL_TO_PLACEORDER_PARAM", (Object)JSON.toJSONString((Object)malToPlaceOrderParam));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_ADDCART.equals(afterDoOperationEventArgs.getOperateKey()) && (parentView = this.getView().getParentView()) != null && "mal_newshopcenter".equals(parentView.getEntityId())) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }
}

