/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.list;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.mal.common.aftersale.impl.MalAutoReturnService;
import kd.scm.mal.common.util.MalAuthorityUtils;
import net.sf.json.JSONArray;

public class MalReturnReqListPlugin
extends AbstractListPlugin {
    private static final char FROM_PUR = '0';
    private static final String UPDATE_SRVSCHEDULE = "updatesrvschedule";
    private static final String RECEIVE_RETURN_TYPE = "2";
    private static final String INSTOCK_RETURN_TYPE = "1";
    private static final String RECEIVE_RETURN = "receivereturn";
    private static final String INSTOCK_RETURN = "instockreturn";
    private static final Log log = LogFactory.getLog(MalReturnReqListPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (MalOrderUtil.getDefaultMalVersion()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u552e\u540e\u67e5\u8be2", (String)"MalReturnReqListPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (ApiConfigUtil.hasCQScmConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tbltrack"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbltrack"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status");
        IFormView view = this.getView();
        if (null != status) {
            view.setVisible(Boolean.FALSE, new String[]{"tblclose", "tbltrack"});
            switch (String.valueOf(status)) {
                case "allsubmit": {
                    view.setVisible(Boolean.FALSE, new String[]{"tblreturn", "baritemap1", "bar_autoreturn", "wechat", "tbltrack", "tblclose"});
                    break;
                }
                case "allaudit": {
                    view.setVisible(Boolean.FALSE, new String[]{"wechat", "bar_updatesrvschedule", "tblclose", "tbltrack"});
                    break;
                }
                case "allfinish": {
                    view.setVisible(Boolean.FALSE, new String[]{"tblreturn", "baritemap1", "tblcancel", "tblcancel", "wechat", "bar_updatesrvschedule", "tblclose", "tbltrack"});
                    break;
                }
                case "allcancel": {
                    view.setVisible(Boolean.FALSE, new String[]{"tblreturn", "baritemap1", "tblcancel", "bar_updatesrvschedule", "wechat", "tbltrack", "tblclose", "tbltrack"});
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String property = args.getHyperLinkClickEvent().getFieldName();
        if ("malorderno".equals(property)) {
            Long reqId = (Long)((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_returnreq", (String)"malorderno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reqId)});
            if (null == dynamicObject) {
                return;
            }
            String malorderno = dynamicObject.getString("malorderno");
            QFilter qFilter = new QFilter("billno", "=", (Object)malorderno);
            DynamicObject malOrder = QueryServiceHelper.queryOne((String)"mal_order", (String)"id", (QFilter[])qFilter.toArray());
            if (null != malOrder) {
                Long id = malOrder.getLong("id");
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)id, new HashMap(), null));
            }
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String ids;
        FormShowParameter fsp;
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        QFilter platformFilter = new QFilter("platform", "!=", (Object)Character.valueOf('0'));
        qFilterList.add(platformFilter);
        QFilter malBizPersonFilter = MalAuthorityUtils.getMalOrderViewAuthorityFilter((String)RequestContext.get().getUserId(), (String)"purorg.id", (String)"mal_returnreq");
        if (malBizPersonFilter != null) {
            qFilterList.add(malBizPersonFilter);
        }
        if (null != (fsp = this.getView().getFormShowParameter()).getCustomParam("status")) {
            String malkey = (String)fsp.getCustomParam("status");
            Set ids2 = (Set)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"IMalNewShopCenterService", (String)"queryTarEntityID", (Object[])new Object[]{qFilterList.toArray(new QFilter[0]), malkey, "mal_returnreq"});
            qFilterList.add(new QFilter("id", "in", (Object)ids2));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ids = (String)fsp.getCustomParam("ids")))) {
            log.info("setFilter.ids:" + ids);
            try {
                ids = URLDecoder.decode(ids, "UTF-8");
                if (ids.startsWith("[") && ids.endsWith("]")) {
                    JSONArray idsJa = JSONArray.fromObject((Object)URLDecoder.decode(ids, "UTF-8"));
                    qFilterList.add(new QFilter("id", "in", (Object)idsJa));
                }
            }
            catch (UnsupportedEncodingException exception) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)exception));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (UPDATE_SRVSCHEDULE.equals(evt.getOperationKey())) {
            if (((ListView)this.getView()).getSelectedRows().getPrimaryKeyValues().length == 0) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MalReturnReqListPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_returnreq", (String)"platform", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (dynamicObject.get("platform").equals(EcPlatformEnum.ECPLATFORM_XFS.getVal())) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u946b\u65b9\u76db\u4e0d\u652f\u6301\u8fdb\u5ea6\u66f4\u65b0\u3002", (String)"MalReturnReqListPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            if (dynamicObject.get("platform").equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u7535\u5546\u8fdb\u5ea6\u66f4\u65b0\u3002", (String)"MalReturnReqListPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "tbltrackup": {
                this.trackUp();
                break;
            }
        }
    }

    private void trackUp() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MalReturnReqListPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> billNoList = new ArrayList<String>();
        QFilter idFilter = new QFilter("id", "in", (Object)objects);
        DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)"mal_returnreq", (String)"id,malorderno", (QFilter[])new QFilter[]{idFilter});
        if (null != dyoCollection && !dyoCollection.isEmpty()) {
            for (DynamicObject dyo : dyoCollection) {
                if (!StringUtils.isNotBlank((CharSequence)dyo.getString("malorderno"))) continue;
                billNoList.add(dyo.getString("malorderno"));
            }
        }
        if (!billNoList.isEmpty()) {
            HashMap resultMap = new HashMap();
            HashSet<Long> set = new HashSet<Long>(billNoList.size());
            DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
            if (dyoCol != null && !dyoCol.isEmpty()) {
                for (DynamicObject dyo : dyoCol) {
                    set.add(dyo.getLong("id"));
                }
                resultMap.put("mal_order", set);
            }
            if (resultMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalReturnReqListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap customParams = new HashMap();
            customParams.put("param", resultMap);
            FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
            this.getView().showForm(formParam);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"MalReturnReqListPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IListView listview = (IListView)this.getView();
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        String itemKey = args.getOperateKey();
        String validRequestReqIdListJson = this.getPageCache().get("validRequestReqIdList");
        ArrayList<Long> validRequestReqIdList = new ArrayList();
        if (validRequestReqIdListJson != null) {
            validRequestReqIdList = (List)SerializationUtils.fromJsonString((String)validRequestReqIdListJson, List.class);
        }
        ListSelectedRowCollection selectCols = listview.getSelectedRows();
        switch (itemKey) {
            case "return": {
                if (selectCols.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u9000\u8d27\u3002", (String)"MalReturnReqListPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ApiConfigUtil.hasEASConfig()) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("billid", selectCols.get(0).getPrimaryKeyValue().toString());
                    param.put("source", "mall");
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_batreturn", param, null, (ShowType)ShowType.MainNewTabPage));
                    break;
                }
                if (ApiConfigUtil.hasCQScmConfig()) {
                    this.getView().invokeOperation("push");
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"tblreturn"});
                break;
            }
            case "autoreturn": {
                MalAutoReturnService malAutoReturnService = new MalAutoReturnService();
                malAutoReturnService.autoPushReturn();
                malAutoReturnService.updateShcdule();
                break;
            }
            case "receivereturn": {
                this.toReturn(this.queryReturnReq(validRequestReqIdList), RECEIVE_RETURN_TYPE);
                break;
            }
            case "instockreturn": {
                this.toReturn(this.queryReturnReq(validRequestReqIdList), INSTOCK_RETURN_TYPE);
                break;
            }
            case "updatesrvschedule": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
        }
    }

    private DynamicObjectCollection queryReturnReq(List<Long> pkIds) {
        return QueryServiceHelper.query((String)"mal_returnreq", (String)"id,businesstype.id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
    }

    protected void toReturn(DynamicObjectCollection returnReqDyn, String returnType) {
        ArrayList<String> pkIds = new ArrayList<String>();
        for (DynamicObject dynamicObject : returnReqDyn) {
            String billId = dynamicObject.getString("id");
            pkIds.add(billId);
            Map lockInfo = MutexUtil.getLockInfo((String)billId, (String)"pur_return_match", (String)"baritemap1");
            if (lockInfo == null) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7684\u552e\u540e\u7533\u8bf7\u5355\u5df2\u7ecf\u5728\u5feb\u901f\u9000\u8d27\u4e2d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"MalReturnReqListPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("billid", pkIds);
        fsp.setCustomParam("returnType", (Object)returnType);
        fsp.setCustomParam("businesstype", (Object)((DynamicObject)returnReqDyn.get(0)).getString("businesstype.id"));
        fsp.setFormId("pur_return_match");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "toReturn"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("toReturn")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "cancel": {
                AfterSaleUtil.updateJdAfterSaleStateInPurOder();
                break;
            }
            case "refresh": {
                AfterSaleUtil.updateJdAfterSaleStateInPurOder();
                break;
            }
            case "push": 
            case "receivereturn": 
            case "instockreturn": {
                IListView listview = (IListView)this.getView();
                ListSelectedRowCollection selectCols = listview.getSelectedRows();
                if (selectCols.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u5355\u636e\u8fdb\u884c\u9000\u8d27\u64cd\u4f5c\u3002", (String)"MalReturnReqListPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<Long> pkIds = new ArrayList<Long>();
                for (ListSelectedRow selectCol : selectCols) {
                    pkIds.add((Long)selectCol.getPrimaryKeyValue());
                }
                DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_returnreq", (String)"id,billno,cfmstatus,platform,replenishtype,malorderno", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                if (null == dyoCol || dyoCol.isEmpty()) break;
                HashSet<String> malOrderNumberSet = new HashSet<String>();
                ArrayList<Long> validRequestReqIdList = new ArrayList<Long>();
                StringBuilder sb = new StringBuilder();
                HashMap<String, String> pageCacheTmpMap = new HashMap<String, String>(dyoCol.size() << 2);
                for (DynamicObject requestReqDyn : dyoCol) {
                    String msg;
                    if (!malOrderNumberSet.isEmpty() && !malOrderNumberSet.contains(requestReqDyn.getString("malorderno"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u5546\u57ce\u8ba2\u5355\u8fdb\u884c\u6279\u91cf\u9000\u8d27\u3002", (String)"MalReturnReqListPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    malOrderNumberSet.add(requestReqDyn.getString("malorderno"));
                    if (StringUtils.isNotBlank((CharSequence)requestReqDyn.getString("cfmstatus")) && !"B".equals(requestReqDyn.getString("cfmstatus"))) {
                        msg = ResManager.loadKDString((String)"\u4ec5\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u7684\u624d\u53ef\u9000\u8d27\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MalReturnReqListPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                        sb.append(msg).append("\t\n");
                    } else if (!"3".equals(requestReqDyn.getString("replenishtype")) && !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(requestReqDyn.getString("platform"))) {
                        msg = ResManager.loadKDString((String)"\u5f53\u524d\u552e\u540e\u7533\u8bf7\u5355\u4e0d\u652f\u6301\u53d1\u8d77\u9000\u8865\u5904\u7406\u3002", (String)"MalReturnReqListPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                        sb.append(requestReqDyn.getString("billno")).append(msg).append("\t\n");
                    } else {
                        validRequestReqIdList.add(requestReqDyn.getLong("id"));
                    }
                    if (validRequestReqIdList.isEmpty()) {
                        this.getView().showTipNotification(sb.toString());
                        args.setCancel(true);
                        return;
                    }
                    pageCacheTmpMap.put("validRequestReqIdList", SerializationUtils.toJsonString(validRequestReqIdList));
                }
                this.getPageCache().put(pageCacheTmpMap);
            }
        }
    }
}

