/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.sqlscipt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.TransInner;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlUpdateItem;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.visitor.ASTVisitor;
import kd.bos.ksql.visitor.ASTVisitorBase;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.mal.formplugin.sqlscipt.MalPreInsDataScriptBuilder;

public final class MalTransInner
extends TransInner {
    public static String checkKsql(String dbRouteKey, String sql) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            try {
                List sqlStmts = MalTransInner.parseStatement((String)sql);
                HashMap<String, ArrayList<SqlObjectInfo>> sqlObjectMap = new HashMap<String, ArrayList<SqlObjectInfo>>();
                for (int i = 0; i < sqlStmts.size(); ++i) {
                    SqlStmt sqlStmt = (SqlStmt)sqlStmts.get(i);
                    SqlObjectInfo info = (SqlObjectInfo)sqlStmt.accept((ASTVisitor)new ASTVisitorBase<SqlObjectInfo>(){
                        SqlObjectInfo info = new SqlObjectInfo();

                        public SqlObjectInfo visitSqlExecStmt(SqlExecStmt stmt) {
                            String text;
                            Object o;
                            List paramList;
                            String processName = stmt.processName;
                            if ("P_ALTERPK".equals(processName) && (paramList = stmt.paramList) != null && paramList.size() == 4 && (o = paramList.get(0)) instanceof SqlCharExpr && (!(text = ((SqlCharExpr)o).text).startsWith("PK_") || text.length() > 27)) {
                                this.info.tableName = paramList.get(1).toString();
                                this.info.errors.append("table:").append(paramList.get(1)).append("PK name ").append(text).append("invalid!!!");
                            }
                            return this.info;
                        }

                        public SqlObjectInfo visitSqlCreateIndexStmt(SqlCreateIndexStmt stmt) {
                            String indexName = stmt.indexName;
                            this.info.type = stmt.type;
                            if (!indexName.startsWith("IDX_") || indexName.length() > 30) {
                                this.info.errors.append("table:").append(stmt.tableName).append("index ").append(indexName).append(" invalid!!!").append(System.lineSeparator());
                            }
                            if (!this.info.conditionIndexNames.contains(indexName)) {
                                this.info.errors.append("table:").append(stmt.tableName).append("index ").append(indexName).append(" un match condition name!!!").append(System.lineSeparator());
                            }
                            return this.info;
                        }

                        public SqlObjectInfo visitSqlCreateTableStmt(SqlCreateTableStmt stmt) {
                            this.info.type = stmt.type;
                            this.info.tableName = stmt.name;
                            Collection columnList = stmt.columnList;
                            if (columnList != null) {
                                for (Object o : columnList) {
                                    String dataType;
                                    SqlColumnDef columnDef = (SqlColumnDef)o;
                                    switch (dataType = columnDef.dataType) {
                                        case "BIGINT": {
                                            if (!columnDef.allowNull.booleanValue()) break;
                                            this.info.errors.append("table:").append(stmt.name).append(" column:").append(columnDef.name).append(" can not be null");
                                            break;
                                        }
                                        case "NVARCHAR": 
                                        case "VARCHAR": 
                                        case "CHAR": {
                                            String text = null;
                                            if (columnDef.defaultValueExpr instanceof SqlCharExpr) {
                                                text = ((SqlCharExpr)columnDef.defaultValueExpr).text;
                                            } else if (columnDef.defaultValueExpr instanceof SqlNCharExpr) {
                                                text = ((SqlCharExpr)columnDef.defaultValueExpr).text;
                                            }
                                            if (columnDef.allowNull.booleanValue() || text == null || text.length() != 1) {
                                                this.info.errors.append("table:").append(stmt.name).append(" column:").append(columnDef.name).append(" can not be null").append(System.lineSeparator());
                                                break;
                                            }
                                            if (text.length() <= columnDef.length) break;
                                            this.info.errors.append("table:").append(stmt.name).append(" column:").append(columnDef.name).append(" default value large than preidicate").append(System.lineSeparator());
                                            break;
                                        }
                                        case "DATETIME": {
                                            if (columnDef.allowNull == null || !columnDef.allowNull.booleanValue()) break;
                                            this.info.errors.append("table:").append(stmt.name).append(" column:").append(columnDef.name).append(" must be null").append(System.lineSeparator());
                                        }
                                    }
                                }
                            }
                            return this.info;
                        }

                        public SqlObjectInfo visitSqlDeleteStmt(SqlDeleteStmt stmt) {
                            this.info.tableName = stmt.delete.tableName;
                            this.info.type = stmt.type;
                            return this.info;
                        }

                        public SqlObjectInfo visitSqlIfStmt(SqlIfStmt stmt) {
                            SqlSelectBase subQuery;
                            SqlExpr condition = stmt.condition;
                            if (condition instanceof SqlExistsExpr && (subQuery = ((SqlExistsExpr)condition).subQuery) instanceof SqlSelect) {
                                SqlBinaryOpExpr condition1 = (SqlBinaryOpExpr)((SqlSelect)subQuery).condition;
                                String text = ((SqlCharExpr)condition1.right).text;
                                this.info.conditionIndexNames.add(text);
                            }
                            return (SqlObjectInfo)super.visitSqlIfStmt(stmt);
                        }

                        public SqlObjectInfo visitSqlInsertStmt(SqlInsertStmt stmt) {
                            this.info.type = stmt.type;
                            this.info.fields = stmt.insert.columnList;
                            this.info.values = stmt.insert.valueList;
                            this.info.tableName = stmt.insert.tableName;
                            return this.info;
                        }

                        public SqlObjectInfo visitSqlUpdateStmt(SqlUpdateStmt stmt) {
                            this.info.tableName = stmt.update.updateTable.name;
                            this.info.type = stmt.type;
                            if (stmt.update.updateList != null) {
                                for (Object o : stmt.update.updateList) {
                                    this.info.fields.add(((SqlUpdateItem)o).name);
                                    this.info.values.add(((SqlUpdateItem)o).expr);
                                }
                            }
                            return this.info;
                        }
                    });
                    ArrayList<SqlObjectInfo> sqlObjectInfos = (ArrayList<SqlObjectInfo>)sqlObjectMap.get(info.tableName);
                    if (sqlObjectInfos == null) {
                        sqlObjectInfos = new ArrayList<SqlObjectInfo>();
                        sqlObjectMap.put(info.tableName, sqlObjectInfos);
                    }
                    sqlObjectInfos.add(info);
                }
                for (Map.Entry next : sqlObjectMap.entrySet()) {
                    List values = (List)next.getValue();
                    sb.append(MalTransInner.checkInsertSql(dbRouteKey, values));
                }
            }
            catch (Exception e) {
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }

    private static String checkInsertSql(String dbRouteKey, List<SqlObjectInfo> sqlObjectInfos) {
        StringBuilder sb = new StringBuilder();
        if (sqlObjectInfos != null && sqlObjectInfos.size() > 0) {
            HashMap<String, FieldInfo> tableFieldInfo = new HashMap<String, FieldInfo>(sqlObjectInfos.size());
            SqlObjectInfo sqlStmt = sqlObjectInfos.get(0);
            String tableName = sqlStmt.tableName;
            List fieldInfo = DB.getFieldInfo((DBRoute)new DBRoute(dbRouteKey), (String)tableName);
            for (FieldInfo info : fieldInfo) {
                tableFieldInfo.put(info.getFieldName(), info);
            }
            for (SqlObjectInfo stmt : sqlObjectInfos) {
                if (stmt.type == 1 || stmt.type == 2 || stmt.type == 3) {
                    List columnList = stmt.fields;
                    List valueList = stmt.values;
                    for (int i = 0; i < columnList.size(); ++i) {
                        Object name = columnList.get(i);
                        FieldInfo fieldInfo1 = (FieldInfo)tableFieldInfo.get(String.valueOf(name).toLowerCase());
                        Object value = valueList.get(i);
                        sb.append(MalTransInner.validateValue(fieldInfo1, value, name, stmt));
                    }
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)stmt.errors.toString())) continue;
                sb.append(stmt.errors.toString());
            }
        }
        return sb.toString();
    }

    private static String validateValue(FieldInfo fieldInfo1, Object value, Object name, SqlObjectInfo stmt) {
        StringBuilder sb = new StringBuilder();
        if (fieldInfo1 != null && stmt != null) {
            int jdbcDataType = fieldInfo1.getJDBCDataType();
            switch (jdbcDataType) {
                case -5: {
                    if (value instanceof SqlIntExpr || value instanceof SqlLongExpr) break;
                    sb.append(String.format("please check \u2018%1$s\u2019 dataType", name)).append(System.lineSeparator());
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof SqlDateTimeExpr || value instanceof SqlNullExpr) break;
                    sb.append(String.format("please check \u2018%1$s\u2019 time value", name)).append(System.lineSeparator());
                    break;
                }
                case 2004: {
                    break;
                }
                case 16: {
                    break;
                }
                case -16: 
                case -15: 
                case -1: 
                case 1: 
                case 12: {
                    String text = null;
                    if (value instanceof SqlCharExpr) {
                        text = ((SqlCharExpr)value).text;
                    } else if (value instanceof SqlNCharExpr) {
                        text = ((SqlNCharExpr)value).text;
                    } else {
                        sb.append(String.format("please check \u2018%1$s\u2019 char value", name)).append(System.lineSeparator());
                    }
                    if (text != null && (!StringUtils.isBlank((CharSequence)text) || text.length() != 0)) break;
                    sb.append(String.format(" please check \u2018%1$s\u2019 char value is null or ''", name)).append(System.lineSeparator());
                    break;
                }
            }
        }
        return sb.toString();
    }

    public static String generateSQL(String entityKey, String[] ids) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        InsertTableInfo insertTableInfo = new InsertTableInfo(ids, (DynamicObjectType)mainEntityType);
        List<InsertTableInfo> allInsertTableInfos = insertTableInfo.getAllInseartTableInfos();
        StringBuilder result = new StringBuilder();
        allInsertTableInfos.forEach(insertTable -> {
            if (StringUtils.isNotEmpty((CharSequence)insertTable.getTableName())) {
                MalPreInsDataScriptBuilder builder = new MalPreInsDataScriptBuilder();
                try {
                    Map<String, Object> map = builder.genInsertSQLScript(DBRoute.of((String)insertTable.getRoute()), insertTable.getTableName(), insertTable.getSelectField(), insertTable.getWhere(), null, null);
                    result.append(map.get("sql"));
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        });
        return result.toString();
    }

    private static class InsertTableInfo {
        String[] pks;
        String tableName;
        String route;
        String selectField;
        String where;
        DynamicObjectType mt;
        List<InsertTableInfo> allInseartTableInfos;
        Map<String, InsertTableInfo> groupTableMap = new HashMap<String, InsertTableInfo>();

        public String getRoute() {
            return this.route;
        }

        public String getSelectField() {
            return this.selectField;
        }

        public String getWhere() {
            return this.where;
        }

        public List<InsertTableInfo> getAllInseartTableInfos() {
            return this.allInseartTableInfos;
        }

        public Map<String, InsertTableInfo> getGroupTableMap() {
            return this.groupTableMap;
        }

        public String getTableName() {
            return this.tableName;
        }

        public InsertTableInfo(String[] pks, DynamicObjectType mt) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.mt = mt;
            this.tableName = mt.getAlias();
            this.route = mt.getDBRouteKey();
            this.where = this.generateWhere();
            this.selectField = this.generateSelectField();
            this.generateEntryInsertTableInfo();
            this.generateGroupInsertTableInfo();
            if (StringUtils.isNotEmpty((CharSequence)this.tableName)) {
                this.allInseartTableInfos.add(this);
            }
            this.groupTableMap.forEach((groupTableKey, insertTableInfo) -> {
                if (StringUtils.isNotEmpty((CharSequence)insertTableInfo.getTableName())) {
                    this.allInseartTableInfos.add((InsertTableInfo)insertTableInfo);
                }
            });
            this.allInseartTableInfos.removeIf(t -> t.getTableName().endsWith("_lk"));
            HashSet dupSet = new HashSet(this.allInseartTableInfos.size());
            this.allInseartTableInfos.removeIf(insertTableInfo -> !dupSet.add(insertTableInfo.getTableName()));
        }

        public InsertTableInfo(String[] pks, DynamicObjectType mt, String groupTable, String selectField) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.tableName = mt.getAlias() + '_' + groupTable;
            this.route = mt.getDBRouteKey();
            this.where = this.generateWhere();
            this.selectField = selectField;
        }

        public InsertTableInfo(String[] pks, String route, String tableName, String selectField) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.tableName = tableName;
            this.route = route;
            this.where = this.generateWhere();
            this.selectField = selectField;
        }

        public void appendSelectField(String field) {
            this.selectField = this.selectField + "," + field;
        }

        private void generateGroupInsertTableInfo() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            properties.forEach(iDataEntityProperty -> {
                String field = iDataEntityProperty.getAlias();
                String tableGroupKey = iDataEntityProperty.getTableGroup();
                if (StringUtils.isNotEmpty((CharSequence)field) && (StringUtils.isNotEmpty((CharSequence)tableGroupKey) || iDataEntityProperty instanceof MuliLangTextProp)) {
                    InsertTableInfo groupInsertTableInfo;
                    if (iDataEntityProperty instanceof MuliLangTextProp) {
                        tableGroupKey = "l";
                    }
                    if ((groupInsertTableInfo = this.groupTableMap.get(this.tableName + '_' + tableGroupKey)) == null) {
                        field = "l".equals(tableGroupKey) ? "fpkid,fid,flocaleid," + field : "fid," + field;
                        if (!(this.mt instanceof EntryType && "l".equals(tableGroupKey) || !StringUtils.isNotEmpty((CharSequence)(groupInsertTableInfo = new InsertTableInfo(this.pks, this.mt, tableGroupKey, field)).getTableName()))) {
                            this.groupTableMap.put(groupInsertTableInfo.getTableName(), groupInsertTableInfo);
                        }
                    } else {
                        groupInsertTableInfo.appendSelectField(field);
                    }
                }
                if (iDataEntityProperty instanceof MulBasedataProp && !(this.mt instanceof EntryType)) {
                    this.allInseartTableInfos.add(new InsertTableInfo(this.pks, this.route, iDataEntityProperty.getAlias(), "fpkid,fid,fbasedataid"));
                }
            });
        }

        private void generateEntryInsertTableInfo() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            properties.forEach(iDataEntityProperty -> {
                if (iDataEntityProperty instanceof EntryProp) {
                    InsertTableInfo entryInsertTableInfo = new InsertTableInfo(this.pks, ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType());
                    if (entryInsertTableInfo.mt instanceof SubEntryType) {
                        entryInsertTableInfo.appendSelectField("fentryid");
                    } else if (!(entryInsertTableInfo.mt instanceof LinkEntryType)) {
                        entryInsertTableInfo.appendSelectField("fid");
                    }
                    this.allInseartTableInfos.addAll(entryInsertTableInfo.getAllInseartTableInfos());
                    this.groupTableMap.putAll(entryInsertTableInfo.getGroupTableMap());
                }
            });
        }

        private String generateSelectField() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            StringBuilder selectFieldSb = new StringBuilder();
            properties.forEach(iDataEntityProperty -> {
                String field = iDataEntityProperty.getAlias();
                if (StringUtils.isNotEmpty((CharSequence)field) && StringUtils.isEmpty((CharSequence)iDataEntityProperty.getTableGroup()) && !(iDataEntityProperty instanceof MulBasedataProp)) {
                    selectFieldSb.append(field).append(',');
                }
            });
            selectFieldSb.delete(selectFieldSb.toString().length() - 1, selectFieldSb.toString().length());
            return selectFieldSb.toString();
        }

        private String generateWhere() {
            if (this.mt instanceof LinkEntryType) {
                return "";
            }
            if (this.mt instanceof SubEntryType) {
                IDataEntityType parentDataEntityType = this.mt.getParent();
                ArrayList<Object> pkList = new ArrayList<Object>(this.pks.length);
                if (parentDataEntityType.getParent().getPrimaryKey() instanceof LongProp) {
                    for (String pk : this.pks) {
                        pkList.add(Long.valueOf(pk));
                    }
                } else {
                    pkList.addAll(Arrays.asList(this.pks));
                }
                QFilter qFilter = new QFilter("id", "in", pkList);
                ArrayList<String> entryIds = new ArrayList<String>(1024);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"subentryquery", (String)parentDataEntityType.getParent().getName(), (String)(parentDataEntityType.getName() + ".id"), (QFilter[])new QFilter[]{qFilter}, null);){
                    Object object;
                    for (Row row : dataSet) {
                        entryIds.add(row.getString(parentDataEntityType.getName() + ".id"));
                    }
                    if (entryIds.isEmpty()) {
                        object = "";
                        return object;
                    }
                    if (entryIds.size() == 1) {
                        object = "fentryid=" + (String)entryIds.get(0);
                        return object;
                    }
                    object = "fentryid in (" + StringUtils.join((Object[])entryIds.toArray(), (String)",") + ")";
                    return object;
                }
            }
            if (this.pks == null || this.pks.length == 0) {
                return "";
            }
            if (this.pks.length == 1) {
                return "fid = '" + this.pks[0] + '\'';
            }
            StringBuilder sb = new StringBuilder();
            sb.append("fid in (");
            for (String pk : this.pks) {
                sb.append('\'');
                sb.append(pk).append("',");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(')');
            return sb.toString();
        }

        public String toString() {
            return "InsertTableInfo{tableName='" + this.tableName + '\'' + ", route='" + this.route + '\'' + ", selectField='" + this.selectField + '\'' + ", where='" + this.where + '\'' + '}';
        }
    }

    private static class SqlObjectInfo {
        private int type;
        private String tableName;
        private List<String> conditionIndexNames = new ArrayList<String>();
        private List<Object> fields = new ArrayList<Object>();
        private List<Object> values = new ArrayList<Object>();
        private StringBuilder errors = new StringBuilder();

        private SqlObjectInfo() {
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            return super.toString();
        }
    }
}

