/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.mal.domain.model.goods.MalGoods;

public class MalAddToOftenBuyUtil {
    private static final Log log = LogFactory.getLog(MalAddToOftenBuyUtil.class);

    public static synchronized boolean add(List<String> goodsIdList) {
        HashMap<Long, BigDecimal> goodsId2QtyMap = new HashMap<Long, BigDecimal>(goodsIdList.size() << 2);
        for (String goodsId : goodsIdList) {
            goodsId2QtyMap.put(Long.valueOf(goodsId), BigDecimal.ONE);
        }
        return MalAddToOftenBuyUtil.add(goodsId2QtyMap);
    }

    public static boolean add(Map<Long, BigDecimal> goodsId2QtyMap) {
        QFilter numberQFiter;
        DynamicObject oftenbuyDyn;
        ArrayList<Long> idList = new ArrayList<Long>(goodsId2QtyMap.keySet());
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] goodsList = BusinessDataServiceHelper.load((String)"pbd_goods", (String)"id,name,unit.id,source", (QFilter[])new QFilter[]{idFilter});
        if (goodsList == null || goodsList.length == 0) {
            MalGoods.syncEcGoodsToGoodsManage(new HashSet<Long>(idList));
            goodsList = BusinessDataServiceHelper.load((String)"pbd_goods", (String)"id,name,unit.id,source", (QFilter[])new QFilter[]{idFilter});
        }
        if ((oftenbuyDyn = BusinessDataServiceHelper.loadSingle((String)"mal_purscheme", (String)"id,goodsentry,goodsentry.goods,goodsentry.unit,goodsentry.qty", (QFilter[])new QFilter[]{numberQFiter = new QFilter("number", "=", (Object)RequestContext.get().getUserId())})) == null) {
            log.info("\u6211\u7684\u5e38\u4e70\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u540e\u53f0\u81ea\u52a8\u521b\u5efa");
            oftenbuyDyn = BusinessDataServiceHelper.newDynamicObject((String)"mal_purscheme");
            String userId = RequestContext.get().getUserId();
            oftenbuyDyn.set("name", (Object)ResManager.loadKDString((String)"\u6211\u7684\u5e38\u4e70", (String)"MalAddToOftenBuyUtil_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            oftenbuyDyn.set("creator", (Object)userId);
            oftenbuyDyn.set("modifier", (Object)userId);
            oftenbuyDyn.set("number", (Object)userId);
            oftenbuyDyn.set("modifytime", (Object)new Date());
            oftenbuyDyn.set("createtime", (Object)new Date());
            oftenbuyDyn.set("status", (Object)"A");
            oftenbuyDyn.set("enable", (Object)"1");
        }
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)oftenbuyDyn.get("goodsentry");
        for (DynamicObject goods : goodsList) {
            DynamicObject entryDyo;
            String goodsId = goods.getString("id");
            Optional<DynamicObject> dynOptional = entryDyoCol.stream().filter(dyn -> StringUtils.equals((CharSequence)dyn.getString("goods.id"), (CharSequence)goodsId)).findFirst();
            if (dynOptional.isPresent()) {
                entryDyo = dynOptional.get();
            } else {
                entryDyo = ORMUtil.newDynamicObject((DynamicObjectType)entryDyoCol.getDynamicObjectType());
                entryDyoCol.add((Object)entryDyo);
            }
            entryDyo.set("goods", goods.getPkValue());
            entryDyo.set("unit", goods.get("unit.id"));
            entryDyo.set("qty", (Object)goodsId2QtyMap.getOrDefault(Long.valueOf(goodsId), BigDecimal.ONE));
        }
        oftenbuyDyn.set("goodsentry", (Object)entryDyoCol);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oftenbuyDyn});
        log.info("\u52a0\u5165\u5e38\u4e70\u52a8\u6001\u5bf9\u8c61oftenbuyDyn\uff1a" + oftenbuyDyn);
        return true;
    }
}

