/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalProductUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MalMakeOrderHelper {
    private static Log log = LogFactory.getLog(MalMakeOrderHelper.class);

    public Map<String, Object> makeOrder(String source, DynamicObject sourceDyo) {
        HashMap<String, Object> resultMsg = new HashMap<String, Object>();
        if (null != sourceDyo) {
            if (source.equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                return this.makeOrder4Self(sourceDyo);
            }
            if (source.equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                return this.makeOrder4Jd(sourceDyo);
            }
        }
        return resultMsg;
    }

    public Map<String, Object> makeOrder4Jd(DynamicObject sourceDyo) {
        boolean flag = true;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>();
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<String> skusList = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> imgMap = new HashMap<String, String>();
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>();
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity");
        for (DynamicObject dyo : entryDyoCol) {
            String sku = dyo.getString("goods");
            Object materialId = dyo.get("material");
            skusList.add(sku);
            nameMap.put(sku, dyo.getString("goodsname"));
            imgMap.put(sku, dyo.getString("goodsimg"));
            qtyMap.put(sku, dyo.getInt("qty"));
            materialMappingMap.put(sku, materialId);
        }
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u4eac\u4e1c\u5546\u54c1@@@@@@@@");
            Map skuIdMap = MalProductUtil.saveJdGoods(skusList, nameMap, imgMap);
            log.info("@@@@@@@@\u4fdd\u5b58\u4eac\u4e1c\u5546\u54c1\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u53d6\u4eac\u4e1c\u4ef7\u683c@@@@@@@@");
            Map priceMap = JdApiUtil.batchGetJdPriceMap(skusList);
            log.info("@@@@@@@@\u53d6\u4eac\u4e1c\u4ef7\u683c\u6210\u529f@@@@@@@@");
            this.preHandleDynamicObj4Jd(sourceDyo, skusList);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo4Jd(sourceDyo, orderDyo, priceMap, skuIdMap);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97@@@@@@@@");
            Cal4DynamicObj.calByTaxAmount((DynamicObject)orderDyo, (String)"entryentity");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u6839\u636e\u5546\u57ce\u8ba2\u5355\u7f16\u7801\u89c4\u5219\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801@@@@@@@@");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation4Jd(materialMappingMap, skuIdMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355@@@@@@@@");
            Map<String, String> jdResultMap = this.createJDOrder(sourceDyo, orderDyo.getString("billno"), qtyMap);
            String jdOrderId = jdResultMap.get("jdOrderID");
            log.info("@@@@@@@@\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u5b8c\u6210@@@@@@@@");
            log.info("\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355ID:" + jdOrderId);
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u4eac\u4e1c\u5355\u76f8\u5173\u4fe1\u606f@@@@@@@@");
            JDOrderUtil.saveJdParentOrder((Map)skuIdMap, (Map)priceMap, qtyMap, (String)jdResultMap.get("resultJson"));
            log.info("@@@@@@@@\u4fdd\u5b58\u4eac\u4e1c\u5355\u76f8\u5173\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f@@@@@@@@");
            this.writeBack2OrderInfo(sourceDyo, jdOrderId, orderDyo.getString("billno"), jdResultMap.get("resultJson"), skuIdMap);
            log.info("@@@@@@@@\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@\u4eac\u4e1c\u4e0b\u5355\u52a8\u6001\u5bf9\u8c61" + orderDyo);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Jd,\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25,\u539f\u56e0\uff1a", (String)"MalMakeOrderHelper_0", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + (StringUtils.isEmpty((CharSequence)submitResult.getMessage()) ? "" : submitResult.getMessage() + "\uff0c") + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            resultMap.put("isSucess", flag);
            resultMap.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMap.put("billno", orderDyo.getString("billno"));
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838@@@@@@@@");
            String bizflow = MalOrderUtil.getBizFlowParam();
            if ((StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) || StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Jd,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,-->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u5931\u8d25,\u539f\u56e0\uff1a", (String)"MalMakeOrderHelper_2", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + (StringUtils.isEmpty((CharSequence)auditResult.getMessage()) ? "" : auditResult.getMessage() + "\uff0c") + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u6210\u529f@@@@@@@@");
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds4Jd(skusList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
        }
        catch (Exception e) {
            flag = false;
            if (!(e instanceof KDBizException)) {
                this.rollBackMalOrder(saveResult);
                log.error("@@@MalMakeOrderHelper.makeOrder4Jd\u5546\u57ce\u8ba2\u5355\u751f\u6210\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalMakeOrderHelper_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("sys error", msg), new Object[0]);
            }
            KDBizException kdBizException = (KDBizException)((Object)e);
            this.rollBackMalOrder(saveResult, kdBizException);
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("isSucess", flag);
        }
        return resultMap;
    }

    public void preHandleDynamicObj(DynamicObject sourceDyo, List<Long> goodsList) {
    }

    public void preHandleDynamicObj4Jd(DynamicObject sourceDyo, List<String> skusList) {
    }

    private void writeBack2OrderInfo(DynamicObject sourceDyo, String jdOrderId, String billNo, String json, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        Map<String, PriceInfo> resultMap = this.getResultPriceInfo(json);
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)jdOrderId);
        dyo[0].set("jdorderstatus", (Object)JDOrderStatusEnum.CREATE.getName());
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            PriceInfo price = resultMap.get(goodsIdSku);
            temp.set("price", (Object)price.getPrice());
            temp.set("taxprice", (Object)price.getTaxPrice());
            temp.set("taxrate", (Object)price.getTaxRate());
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    private Map<String, PriceInfo> getResultPriceInfo(String str) {
        JSONObject node = JSONObject.fromObject((Object)str).getJSONObject("result");
        JSONArray skus = node.getJSONArray("sku");
        HashMap<String, PriceInfo> map = new HashMap<String, PriceInfo>((int)((double)skus.size() / 0.75));
        int size = skus.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = skus.getJSONObject(i);
            PriceInfo price = new PriceInfo();
            price.setTaxPrice(BigDecimal.valueOf(jsonObject.getDouble("price")));
            price.setTaxRate(BigDecimal.valueOf(jsonObject.getDouble("tax")));
            price.setTax(BigDecimal.valueOf(jsonObject.getDouble("taxPrice")));
            price.setPrice(BigDecimal.valueOf(jsonObject.getDouble("nakedPrice")));
            map.put(jsonObject.getString("skuId"), price);
        }
        return map;
    }

    private Map<String, String> createJDOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        String jdOrderID = null;
        Map recieptMap = MalProductUtil.getRecieptInfo((String)sourceDyo.getString("receipt"));
        String name = ((String)recieptMap.get("receiptname")).trim();
        String[] jdAdress = ((String)recieptMap.get("receiptjdadress")).split("_");
        if (null == jdAdress || jdAdress.length < 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4eac\u4e1c\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u3002", (String)"MalMakeOrderHelper_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        String province = jdAdress[0].trim();
        String city = jdAdress[1].trim();
        String county = jdAdress[2].trim();
        String town = jdAdress[3].trim();
        String address = ((String)recieptMap.get("receiptAddr")).trim();
        MalAddressUtil.validateJdOrderAddress((String)((String)recieptMap.get("admindivisionId")), (String)(province + "_" + city + "_" + county));
        String zip = ((String)recieptMap.get("receiptzip")).trim();
        String phone = "";
        String mobile = ((String)recieptMap.get("receiptphone")).trim();
        String email = ((String)recieptMap.get("receiptemail")).trim();
        String remark = sourceDyo.getString("remark");
        String companyName = sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim();
        String invoiceContent = sourceDyo.getString("invoicecontent").trim();
        String paymentType = sourceDyo.getString("paytype").trim();
        String submitState = "0";
        String invoiceType = sourceDyo.getString("invoicetype").trim();
        String selectedInvoiceTitle = "5";
        String invoiceState = "2";
        String isUseBalance = "0";
        if (paymentType.equals("4")) {
            isUseBalance = "1";
        }
        String regCode = sourceDyo.getString("invoiceorg.ftaxregnum");
        StringBuilder skuStr = new StringBuilder();
        skuStr.append('[');
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            skuStr.append('{');
            skuStr.append("\"skuId\":").append(skuEntry.getKey()).append(",\"num\":").append(skuEntry.getValue());
            skuStr.append(",\"bNeedGift\":").append(this.needGifts());
            skuStr.append(",\"yanbao\":").append("[]");
            skuStr.append("},");
        }
        String tempSku = skuStr.substring(0, skuStr.lastIndexOf(","));
        tempSku = tempSku + "]";
        StringBuilder logString = new StringBuilder();
        logString.append(ResManager.loadKDString((String)"\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570:", (String)"MalMakeOrderHelper_12", (String)"scm-mal-formplugin", (Object[])new Object[0])).append("\n");
        HashMap<String, String> params = new HashMap<String, String>(1024);
        params.put("thirdOrder", orderBillNo);
        logString.append("thirdOrder").append(":").append(orderBillNo).append("\n");
        params.put("sku", tempSku);
        logString.append("sku").append(":").append(tempSku).append("\n");
        params.put("name", name);
        params.put("province", province);
        params.put("city", city);
        params.put("county", county);
        params.put("town", town);
        params.put("address", address);
        params.put("zip", zip);
        params.put("phone", phone);
        params.put("mobile", mobile);
        params.put("email", email);
        params.put("remark", remark);
        params.put("invoiceState", invoiceState);
        logString.append("invoiceState").append(":").append(invoiceState).append("\n");
        params.put("invoiceType", invoiceType);
        logString.append("invoiceType").append(":").append(invoiceType).append("\n");
        params.put("invoiceName", name);
        params.put("invoicePhone", mobile);
        params.put("invoiceCity", province);
        params.put("invoiceProvice", city);
        params.put("invoiceCounty", county);
        params.put("invoiceAddress", address);
        params.put("selectedInvoiceTitle", selectedInvoiceTitle);
        params.put("companyName", companyName);
        params.put("invoiceContent", invoiceContent);
        params.put("paymentType", paymentType);
        params.put("submitState", submitState);
        logString.append("submitState").append(":").append(submitState).append("\n");
        params.put("isUseBalance", isUseBalance);
        logString.append("isUseBalance").append(":").append(isUseBalance).append("\n");
        params.put("regCode", regCode);
        params.put("regCompanyName", companyName);
        log.info(logString.toString());
        String json = JdApiUtil.submitJdOrder(params, null);
        log.info("\u8c03\u7528\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + json);
        JSONObject node = JSONObject.fromObject((Object)json);
        if (!node.getBoolean("success")) {
            throw new KDBizException(new ErrorCode("makeJdOrder fail", node.getString("resultMessage")), new Object[0]);
        }
        jdOrderID = node.getJSONObject("result").get("jdOrderId").toString();
        result.put("jdOrderID", jdOrderID);
        result.put("resultJson", json);
        return result;
    }

    public String needGifts() {
        return "false";
    }

    public void preHandleDynamicObj4Jd(DynamicObject sourceDyo, Map<String, PriceInfo> priceMap) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity");
        String goodsId = "";
        for (DynamicObject entryDyo : entryDyoCol) {
            goodsId = entryDyo.getString("goods");
            entryDyo.set("goodprice", (Object)priceMap.get(goodsId).getShowprice());
            entryDyo.set("taxrate", (Object)priceMap.get(goodsId).getTaxRate());
        }
    }

    public Map<String, Object> makeOrder4Self(DynamicObject sourceDyo) {
        QFilter filter;
        boolean flag = true;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>();
        HashMap<Long, BigDecimal> taxRateMap = new HashMap<Long, BigDecimal>();
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<Long> goodsList = new ArrayList<Long>();
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity");
        for (DynamicObject dyo : entryDyoCol) {
            Long goodsId = dyo.getLong("goods");
            Object materialId = dyo.get("material");
            goodsList.add(goodsId);
            materialMappingMap.put(String.valueOf(goodsId), materialId);
        }
        String selectFields = this.getSelectedFields();
        DynamicObjectCollection dynamicObjectCol = QueryServiceHelper.query((String)"pbd_goods", (String)selectFields, (QFilter[])new QFilter[]{filter = new QFilter("id", "in", goodsList)});
        if (null != dynamicObjectCol && dynamicObjectCol.size() > 0) {
            for (int i = 0; i < dynamicObjectCol.size(); ++i) {
                Long pkId = ((DynamicObject)dynamicObjectCol.get(i)).getLong("id");
                BigDecimal taxRate = ((DynamicObject)dynamicObjectCol.get(i)).getBigDecimal("taxrate");
                taxRateMap.put(pkId, taxRate);
            }
        }
        StringBuilder logStr = new StringBuilder();
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            this.preHandleDynamicObj(sourceDyo, goodsList);
            log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo(sourceDyo, orderDyo, taxRateMap);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            Cal4DynamicObj.calByTaxAmount((DynamicObject)orderDyo, (String)"entryentity");
            logStr.append("The calculation of the Process Marketplace Related Price Amount field is complete---->");
            logStr.append("According to the mall order coding rules, the document code is automatically generated, and the execution is completed---->");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Self,\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + logStr);
                String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5931\u8d25,\u539f\u56e0\uff1a", (String)"MalMakeOrderHelper_7", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + (StringUtils.isEmpty((CharSequence)submitResult.getMessage()) ? "" : submitResult.getMessage() + "\uff0c") + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            String bizflow = MalOrderUtil.getBizFlowParam();
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Self,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + logStr);
                String msg = ResManager.loadKDString((String)"\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,\u539f\u56e0\uff1a", (String)"MalMakeOrderHelper_8", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + (StringUtils.isEmpty((CharSequence)auditResult.getMessage()) ? "" : auditResult.getMessage() + "\uff0c") + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation(materialMappingMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            logStr.append(ResManager.loadKDString((String)"\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u6267\u884c\u5b8c\u6210\u3002", (String)"MalMakeOrderHelper_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds(goodsList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
            logStr.append(ResManager.loadKDString((String)"\u5220\u9664\u8d2d\u7269\u8f66\u8bb0\u5f55\u6210\u529f\u3002", (String)"MalMakeOrderHelper_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            resultMap.put("isSucess", flag);
            resultMap.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMap.put("billno", orderDyo.getString("billno"));
        }
        catch (Exception e) {
            flag = false;
            if (!(e instanceof KDBizException)) {
                this.rollBackMalOrder(saveResult);
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalMakeOrderHelper_3", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("sys error", msg + logStr + "\n" + ExceptionUtil.getStackTrace((Throwable)e)), new Object[0]);
            }
            KDBizException kdBizException = (KDBizException)((Object)e);
            this.rollBackMalOrder(saveResult, kdBizException);
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("isSucess", flag);
        }
        return resultMap;
    }

    private void rollBackMalOrder(OperationResult operationResult) {
        if (operationResult != null && operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
            Long pk = operationResult.getSuccessPkIds().toArray(new Long[0])[0];
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5355\u636eID-->" + pk);
            QFilter pkFilter = new QFilter("id", "=", (Object)pk);
            this.deleteMalOrder(pk, pkFilter);
        }
    }

    private void rollBackMalOrder(OperationResult operationResult, KDBizException e) {
        if (operationResult != null && operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
            Long pk = operationResult.getSuccessPkIds().toArray(new Long[0])[0];
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5355\u636eID-->" + pk);
            QFilter pkFilter = new QFilter("id", "=", (Object)pk);
            if (StringUtils.equals((CharSequence)"Audit Bill fail", (CharSequence)e.getErrorCode().getCode())) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"mal_order", (Object[])new Object[]{pk}, null);
                if (null != opResult && opResult.isSuccess()) {
                    this.deleteMalOrder(pk, pkFilter);
                } else if (null != opResult) {
                    log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u64a4\u9500\u5931\u8d25\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + pk + "\n" + ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo()));
                } else {
                    log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u64a4\u9500\u5931\u8d25\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + pk + "\n");
                }
            } else {
                this.deleteMalOrder(pk, pkFilter);
            }
        }
    }

    private void deleteMalOrder(Long pk, QFilter pkFilter) {
        try (TXHandle h = TX.requiresNew();){
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5f00\u59cb\u6267\u884c\u5220\u9664");
            DeleteServiceHelper.delete((String)"mal_order", (QFilter[])new QFilter[]{pkFilter});
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u6267\u884c\u5220\u9664\u6210\u529f");
        }
        catch (Exception rollback) {
            log.error("@@@MalMakeOrderHelper.rollBackMalOrder:\u56de\u6eda\u5f02\u5e38\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + pk + "\n" + ExceptionUtil.getStackTrace((Throwable)rollback));
        }
    }

    public void updateMappingRelation(Map<String, Object> materialMappingMap) {
        Set<String> prodIdSet = materialMappingMap.keySet();
        this.handleMappingRelation(materialMappingMap, null, prodIdSet);
    }

    public void updateMappingRelation4Jd(Map<String, Object> materialMappingMap, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        Set<String> prodIdSet = idSkuMap.keySet();
        this.handleMappingRelation(materialMappingMap, idSkuMap, prodIdSet);
    }

    public void handleMappingRelation(Map<String, Object> materialMappingMap, Map<String, String> idSkuMap, Set<String> prodIdSet) {
        DynamicObject[] dyobjects;
        Date currDate = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        HashSet<Long> prodSet = new HashSet<Long>(prodIdSet.size());
        for (String prodId : prodIdSet) {
            prodSet.add(Long.valueOf(prodId));
        }
        QFilter filter = new QFilter("goods", "in", prodSet);
        for (DynamicObject dyo : dyobjects = BusinessDataServiceHelper.load((String)"pmm_prodmatmapping", (String)"id,goods.id,material,billdate,modifytime,modifier", (QFilter[])new QFilter[]{filter})) {
            String key = dyo.getString("goods.id");
            if (!prodIdSet.contains(key)) continue;
            if (null != idSkuMap) {
                dyo.set("material", materialMappingMap.get(idSkuMap.get(key)));
            } else {
                dyo.set("material", materialMappingMap.get(key));
            }
            dyo.set("billdate", (Object)currDate);
            dyo.set("modifytime", (Object)currDate);
            dyo.set("modifier", (Object)userId);
            prodIdSet.remove(key);
        }
        SaveServiceHelper.save((DynamicObject[])dyobjects);
        if (null != prodIdSet && prodIdSet.size() > 0) {
            DynamicObject[] newDyobjects = new DynamicObject[prodIdSet.size()];
            int count = 0;
            for (String prodId : prodIdSet) {
                DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmatmapping");
                newDyo.set("goods", (Object)prodId);
                if (null != idSkuMap) {
                    newDyo.set("material", materialMappingMap.get(idSkuMap.get(prodId)));
                } else {
                    newDyo.set("material", materialMappingMap.get(prodId));
                }
                newDyo.set("creator", (Object)userId);
                newDyo.set("modifier", (Object)userId);
                newDyo.set("billdate", (Object)currDate);
                newDyo.set("createtime", (Object)currDate);
                newDyo.set("modifytime", (Object)currDate);
                newDyobjects[count] = newDyo;
                ++count;
            }
            SaveServiceHelper.save((DynamicObject[])newDyobjects);
        }
    }

    public void handleOrderHeadInfo(DynamicObject sourceDyo, DynamicObject orderDyo) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5355\u5934\u4fe1\u606f@@@@@@@@");
        ArrayList<String> sourcePropertyList = new ArrayList<String>();
        DataEntityPropertyCollection sourcePropertyCol = sourceDyo.getDataEntityType().getProperties();
        for (IDataEntityProperty sourceProperty : sourcePropertyCol) {
            sourcePropertyList.add(sourceProperty.getName());
        }
        ArrayList<String> orderPropertyList = new ArrayList<String>();
        DataEntityPropertyCollection orderPropertyCol = orderDyo.getDataEntityType().getProperties();
        for (IDataEntityProperty orderProperty : orderPropertyCol) {
            orderPropertyList.add(orderProperty.getName());
        }
        for (String proKey : sourcePropertyList) {
            if (!orderPropertyList.contains(proKey) || StringUtils.equals((CharSequence)proKey, (CharSequence)"entryentity")) continue;
            orderDyo.set(proKey, sourceDyo.get(proKey));
        }
        orderDyo.set("loccurr", sourceDyo.get("curr"));
        orderDyo.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        if (sourceDyo.getDataEntityType().toString().toLowerCase().equals("mal_makeorder")) {
            orderDyo.set("platform", (Object)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
            orderDyo.set("invtype", (Object)"2");
            orderDyo.set("invdetail", (Object)"1");
        } else if (sourceDyo.getDataEntityType().toString().toLowerCase().equals("mal_jdmakeorder")) {
            orderDyo.set("platform", (Object)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
            orderDyo.set("invtype", sourceDyo.get("invoicetype"));
            orderDyo.set("malinvtype_id", sourceDyo.get("invoiceid_id"));
            orderDyo.set("invdetail", sourceDyo.get("invoicecontent"));
            orderDyo.set("paytype", sourceDyo.get("paytype"));
        }
        orderDyo.set("invway", (Object)"2");
        orderDyo.set("taxtype", (Object)"1");
        orderDyo.set("exchrate", (Object)BigDecimal.ONE.setScale(2));
        Date currentDate = new Date();
        Long personId = RequestContext.get().getCurrUserId();
        orderDyo.set("billdate", (Object)currentDate);
        orderDyo.set("creator", (Object)personId);
        orderDyo.set("createtime", (Object)currentDate);
        orderDyo.set("modifier", (Object)personId);
        orderDyo.set("modifytime", (Object)currentDate);
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5355\u5934\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    public void handleOrderEntryInfo4Jd(DynamicObject sourceDyo, DynamicObject orderDyo, Map<String, PriceInfo> priceMap, Map<String, String> skuIdMap) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f@@@@@@@@");
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)orderDyo.get("entryentity");
        EntryProp sourceEntryProp = (EntryProp)sourceDyo.getDataEntityType().getProperties().get((Object)"entryentity");
        List sourceEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)sourceEntryProp.getItemType());
        sourceEntryProList.remove("id");
        EntryProp orderEntryProp = (EntryProp)orderDyo.getDataEntityType().getProperties().get((Object)"entryentity");
        List orderEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)orderEntryProp.getItemType());
        DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyo : dyoCol) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            for (String proKey : sourceEntryProList) {
                if (!orderEntryProList.contains(proKey)) continue;
                String goodsId = dyo.getString("goods");
                if (proKey.equals("goods")) {
                    entryDyo.set("goods", (Object)skuIdMap.get(goodsId));
                } else if (proKey.equals("taxrate")) {
                    entryDyo.set("taxrate", (Object)priceMap.get(goodsId).getTaxRate());
                } else {
                    entryDyo.set(proKey, dyo.get(proKey));
                }
                entryDyo.set("dctrate", (Object)BigDecimal.ZERO.setScale(2));
                entryDyo.set("dctamount", (Object)BigDecimal.ZERO);
                entryDyo.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                entryDyo.set("addvalue", (Object)"2");
            }
        }
        orderDyo.set("entryentity", (Object)entryDyoCol);
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    public void handleOrderEntryInfo(DynamicObject sourceDyo, DynamicObject orderDyo, Map<Long, BigDecimal> taxRateMap) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f@@@@@@@@");
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)orderDyo.get("entryentity");
        EntryProp sourceEntryProp = (EntryProp)sourceDyo.getDataEntityType().getProperties().get((Object)"entryentity");
        List sourceEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)sourceEntryProp.getItemType());
        sourceEntryProList.remove("id");
        EntryProp orderEntryProp = (EntryProp)orderDyo.getDataEntityType().getProperties().get((Object)"entryentity");
        List orderEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)orderEntryProp.getItemType());
        DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyo : dyoCol) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            for (String proKey : sourceEntryProList) {
                if (!orderEntryProList.contains(proKey)) continue;
                Long goodsId = dyo.getLong("goods");
                if (proKey.equals("taxrate")) {
                    entryDyo.set("taxrate", (Object)taxRateMap.get(goodsId));
                } else {
                    entryDyo.set(proKey, dyo.get(proKey));
                }
                entryDyo.set("dctrate", (Object)BigDecimal.ZERO.setScale(2));
                entryDyo.set("dctamount", (Object)BigDecimal.ZERO);
                entryDyo.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                entryDyo.set("addvalue", (Object)"2");
            }
        }
        orderDyo.set("entryentity", (Object)entryDyoCol);
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    private String getSelectedFields() {
        return "id,taxrate,price,taxprice,shopprice";
    }
}

