/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.common.addcart.MalAddToCartHelper;
import kd.scm.mal.common.addcart.impl.MalSelfAddToCart;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.malcore.enums.MallStatusEnum;

public class MalShopCartUtil {
    public static final String CART_ENTRYENTITY = "cart_entryentity";
    public static final String CART_SELECT_QTY = "cart_select_qty";
    public static final String CART_SELECT_AMOUNT = "cart_select_amount";
    public static final String CART_QTY = "cart_qty";
    public static final String CART_AMOUNT = "cart_amount";
    public static final String SELECTPKS = "slectPks";
    public static final String defualQtyValue = "0";
    public static final String defualAmtValue = "0.00";
    public static final String CACHE_GOODSID = "cache_goodsid";
    public static final String FOCUS_NODE_ID = "FOCUS_NODE_ID";
    public static final String SEARCHAP = "searchap";
    public static final String CART_PRICE = "cart_price";
    public static final String CART_OPERATION = "cart_operation";
    public static final String DELETEKEY = "delete_key";
    public static final String CURRENTPK = "currentPk";
    public static final String SCHEMENUMBER = "number";
    public static final String SCHEMENAME = "name";
    public static final String KEY_PURSCHEME = "key_purscheme";
    public static final String KEY_DELETESELECT = "key_deleteselect";
    public static final String KEY_DELETECURR = "key_deletecurr";
    public static final String MYORDER_FLEX = "myorderflex";
    public static final String CACHE_ISSCHEME = "cache_isscheme";
    public static final String CACHE_SCHEMEID = "cache_schemeid";
    public static final String CACHE_GOODID = "cache_goodid";
    public static final String FROM_CART = "fromCart";
    public static final String KEY_TREEVIEW = "treeviewap";
    public static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";

    public static boolean isSameSource(DynamicObjectCollection selectedRowsDyObject) {
        boolean flag = true;
        if (selectedRowsDyObject.size() > 1) {
            String firstSource = ((DynamicObject)selectedRowsDyObject.get(0)).getString("cart_goodsource");
            for (int i = 1; i < selectedRowsDyObject.size(); ++i) {
                if (StringUtils.equalsIgnoreCase((CharSequence)firstSource, (CharSequence)((DynamicObject)selectedRowsDyObject.get(i)).getString("cart_goodsource"))) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public static List<Map<String, Object>> dyoColToMap(DynamicObjectCollection selectedRowsDyObject) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (DynamicObject dyo : selectedRowsDyObject) {
            resultList.add(DynamicObjectUtil.object2MapByQuery((DynamicObject)dyo));
        }
        return resultList;
    }

    public static void saveChangedQty(List<String> pagePksList, Map<String, BigDecimal> qtyMap, Map<String, BigDecimal> taxAmountMap) {
        ArrayList pageIdsList = new ArrayList();
        pagePksList.forEach(id -> pageIdsList.add(Long.valueOf(id)));
        QFilter filter = new QFilter("id", "in", pageIdsList);
        String selectors = DynamicObjectUtil.getSelectfields((String)"mal_shopcartbill", (boolean)false);
        DynamicObject[] realExDynamicObjects = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)selectors, (QFilter[])new QFilter[]{filter});
        MalSelfAddToCart selfService = new MalSelfAddToCart();
        ArrayList<DynamicObject> malDyns = new ArrayList<DynamicObject>(1024);
        for (DynamicObject info : realExDynamicObjects) {
            DynamicObject goods = info.getDynamicObject("goods");
            String goodsource = info.getString("goodsource");
            String pkValue = info.getString("id");
            BigDecimal newQty = qtyMap.get(pkValue);
            BigDecimal oldqty = info.getBigDecimal("qty");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsource)) {
                selfService.addCart(Long.valueOf(goods.getLong("id")), newQty.subtract(oldqty));
                continue;
            }
            info.set("qty", (Object)qtyMap.get(pkValue));
            info.set("taxamount", (Object)taxAmountMap.get(pkValue));
            malDyns.add(info);
        }
        if (malDyns.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])malDyns.toArray(new DynamicObject[0]));
        }
    }

    public static String getDiffFieldsBySource(String goodSource) {
        switch (goodSource) {
            case "1": {
                return "goods.number";
            }
            case "2": {
                return "remark";
            }
        }
        return "remark";
    }

    public static int[] getSelectIndex(Control control) {
        EntryGrid grid = (EntryGrid)control;
        return grid.getEntryState().getSelectedRows();
    }

    public static DynamicObjectCollection getSelectedDyObject(int[] selectedIndexs, Control control) {
        EntryGrid grid = (EntryGrid)control;
        IDataModel gridModel = grid.getModel();
        String entryKey = grid.getKey();
        DynamicObjectCollection selectedRowsDyObject = new DynamicObjectCollection();
        DynamicObjectCollection col = gridModel.getEntryEntity(entryKey);
        for (int i = 0; i < selectedIndexs.length; ++i) {
            DynamicObject entryObject = (DynamicObject)col.get(selectedIndexs[i]);
            if (null == entryObject) continue;
            selectedRowsDyObject.add((Object)entryObject);
        }
        return selectedRowsDyObject;
    }

    public static void updateAcountValue(IFormView view, int[] selectedIndexs) {
        Label selectQty = (Label)view.getControl(CART_SELECT_QTY);
        if (selectedIndexs.length > 0 && selectedIndexs[0] != -1) {
            DynamicObjectCollection selectedRowsDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, view.getControl(CART_ENTRYENTITY));
            List pks = MalProductUtil.getListByProperty((DynamicObjectCollection)selectedRowsDyObject, (String)"cart_pk");
            List goodsid = MalProductUtil.getListByProperty((DynamicObjectCollection)selectedRowsDyObject, (String)"cart_goods");
            String qty = MalShopCartUtil.calTotalQty(selectedRowsDyObject);
            selectQty.setText(qty);
            BigDecimal amount = MalShopCartUtil.calTotalAmount(selectedRowsDyObject);
            view.getModel().setValue(CART_SELECT_AMOUNT, (Object)amount);
            view.getPageCache().put(SELECTPKS, String.join((CharSequence)",", pks));
            view.getPageCache().put(CACHE_GOODSID, String.join((CharSequence)",", goodsid));
            view.getPageCache().put(CART_SELECT_AMOUNT, String.valueOf(amount));
        } else {
            selectQty.setText(defualQtyValue);
            view.getModel().setValue(CART_SELECT_AMOUNT, (Object)BigDecimal.ZERO);
            view.getPageCache().put(SELECTPKS, "");
            view.getPageCache().put(CACHE_GOODSID, "");
            view.getPageCache().put(CART_SELECT_AMOUNT, defualAmtValue);
        }
        view.updateView(CART_SELECT_AMOUNT);
    }

    public static String calTotalQty(DynamicObjectCollection selectedRows) {
        BigDecimal totalQty = BigDecimal.ZERO;
        for (DynamicObject entry : selectedRows) {
            String qty = entry.getString(CART_QTY);
            totalQty = totalQty.add(CommonUtil.getBigDecimalPro((Object)qty));
        }
        return totalQty.stripTrailingZeros().toPlainString();
    }

    public static BigDecimal calTotalAmount(DynamicObjectCollection selectedRows) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject entry : selectedRows) {
            String amount = entry.getString(CART_AMOUNT);
            totalAmount = totalAmount.add(CommonUtil.getBigDecimalPro((Object)amount));
        }
        return totalAmount;
    }

    public static void setDefualAcountValue(IFormView view) {
        Label totalQty = (Label)view.getControl(CART_SELECT_QTY);
        totalQty.setText(defualQtyValue);
        view.getModel().setValue(CART_SELECT_AMOUNT, (Object)BigDecimal.ZERO);
    }

    public static List<String> getSkus(DynamicObject[] loadProd, String property) {
        ArrayList<String> pks = new ArrayList<String>(loadProd.length);
        for (DynamicObject dyObj : loadProd) {
            pks.add(dyObj.getString(property));
        }
        return pks;
    }

    public static void saveAllChangedQty(IFormView view) {
        DynamicObjectCollection existDynamicObjects = view.getModel().getEntryEntity(CART_ENTRYENTITY);
        List pagePksList = MalProductUtil.getListByProperty((DynamicObjectCollection)existDynamicObjects, (String)"cart_pk");
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> taxAmountMap = new HashMap<String, BigDecimal>();
        for (DynamicObject dyo : existDynamicObjects) {
            String pk = dyo.getString("cart_pk");
            BigDecimal qty = dyo.getBigDecimal(CART_QTY);
            BigDecimal taxAmount = dyo.getBigDecimal(CART_AMOUNT);
            qtyMap.put(pk, qty);
            taxAmountMap.put(pk, taxAmount);
        }
        MalShopCartUtil.saveChangedQty(pagePksList, qtyMap, taxAmountMap);
    }

    public static Map<String, List<String>> getSkuMapBySource(DynamicObjectCollection selectedRowsDyObject) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> prodIdList = new ArrayList<String>();
        ArrayList<String> skuList = new ArrayList<String>();
        for (DynamicObject dyo : selectedRowsDyObject) {
            if (dyo == null) continue;
            if (dyo.getString("cart_goodsource").equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                String goods = dyo.getString("cart_goods");
                if (goods.isEmpty()) continue;
                prodIdList.add(goods);
                continue;
            }
            skuList.add(dyo.getString("cart_number"));
        }
        result.put("prodIdList", prodIdList);
        result.put("skuList", skuList);
        return result;
    }

    public static DynamicObject getOftenBuy() {
        QFilter numberQFiter = new QFilter(SCHEMENUMBER, "=", (Object)RequestContext.get().getUserId());
        DynamicObject oftenbuyDyn = QueryServiceHelper.queryOne((String)"mal_purscheme", (String)"id,number", (QFilter[])new QFilter[]{numberQFiter});
        return oftenbuyDyn;
    }

    public static DynamicObjectCollection getPurSchemes() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter qfilter = new QFilter("creator", "=", (Object)userId);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_purscheme", (String)"id,number,name", (QFilter[])new QFilter[]{qfilter}, (String)"createtime asc");
        return dyoCol;
    }

    @Deprecated
    public static void updateControlMetadata(IFormView view, String key) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(key);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    public static void initEntryRow(IFormView view) {
        DynamicObjectCollection dyoCol = view.getModel().getEntryEntity(CART_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)view.getControl(CART_ENTRYENTITY);
        if (dyoCol.size() > 0) {
            DynamicObject[] dyos;
            int[] allRowIndexs = new int[dyoCol.size()];
            for (int i = 0; i < dyoCol.size(); ++i) {
                allRowIndexs[i] = i;
            }
            grid.setRowBackcolor("", allRowIndexs);
            for (int i : allRowIndexs) {
                view.setEnable(Boolean.TRUE, i, new String[]{CART_QTY});
            }
            List<String> prodIdList = MalShopCartUtil.getSkuMapBySource(dyoCol).get("prodIdList");
            List prodNumberList = MalProductUtil.checkProdMalStatesWithSource(prodIdList);
            if (prodNumberList.size() > 0) {
                int[] rowIndexs = new int[prodNumberList.size()];
                int count = 0;
                for (DynamicObject dyo : dyoCol) {
                    if (!prodNumberList.contains(dyo.getString("cart_number") + "+" + dyo.getString("cart_goodsource"))) continue;
                    rowIndexs[count++] = dyo.getInt("seq") - 1;
                }
                grid.setRowBackcolor("#D7D7D7", rowIndexs);
                for (int i : rowIndexs) {
                    view.setEnable(Boolean.FALSE, i, new String[]{CART_QTY});
                }
            }
            ArrayList<String> selectNums = new ArrayList<String>();
            for (DynamicObject dyo : dyos = MalShopCartUtil.getNewDynamicObjectCol()) {
                Date billDate = dyo.getDate("billdate");
                String number = dyo.getString("goods.number");
                if (TimeServiceHelper.getTimeStamp() - billDate.getTime() >= 600000L || prodNumberList.contains(number)) continue;
                selectNums.add(number);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (selectNums.size() > 0) {
                for (DynamicObject dyo : dyoCol) {
                    if (!selectNums.contains(dyo.getString("cart_number"))) continue;
                    arrayList.add(dyo.getInt("seq") - 1);
                }
                int[] selectIndex = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    selectIndex[i] = (Integer)arrayList.get(i);
                }
                if (selectIndex.length > 0) {
                    grid.selectRows(selectIndex, selectIndex[0]);
                    MalShopCartUtil.updateAcountValue(view, selectIndex);
                } else {
                    MalShopCartUtil.updateAcountValue(view, new int[0]);
                }
            }
        }
    }

    public static DynamicObject[] getNewDynamicObjectCol() {
        String selectFields = "id,goodsimg,goods.number,remark,goodsname,goodsdesc,stockqty,taxprice,qty,unit,taxamount,goodsource,billdate,supplier.id,supplier.number supplier";
        QFilter qFilter = new QFilter("person", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"supplier asc");
        return load;
    }

    public static List<String> getMalStatus(List<String> skuList) {
        DynamicObjectCollection goodsMal = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(SCHEMENUMBER, "in", skuList)});
        HashMap<String, String> map = new HashMap<String, String>(goodsMal.size());
        ArrayList<Long> idList = new ArrayList<Long>(goodsMal.size());
        for (DynamicObject dyn : goodsMal) {
            map.put(dyn.getString("id"), dyn.getString(SCHEMENUMBER));
            idList.add(dyn.getLong("id"));
        }
        DynamicObjectCollection statusMal = QueryServiceHelper.query((String)"pbd_mallgoods_status", (String)"mallgoods,mallstatus", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", idList)});
        ArrayList<String> statusList = new ArrayList<String>(statusMal.size());
        for (DynamicObject dyn : statusMal) {
            if (!defualQtyValue.equals(dyn.getString("mallstatus"))) continue;
            statusList.add(dyn.getString("mallgoods"));
        }
        ArrayList<String> list = new ArrayList<String>(statusList.size());
        if (statusList.size() > 0) {
            for (String sku : statusList) {
                Object conSku = map.get(sku);
                if (null == conSku) continue;
                list.add(String.valueOf(conSku));
            }
        }
        return list;
    }

    public static void realDeleteData(Object[] pks) {
        DynamicObject newDynamicObject = ORM.create().newDynamicObject("mal_shopcartbill");
        ArrayList<Long> shopcartIds = new ArrayList<Long>(1024);
        for (Object pk : pks) {
            shopcartIds.add(Long.parseLong(String.valueOf(pk)));
        }
        QFilter qFilter = new QFilter("id", "in", shopcartIds);
        DynamicObjectCollection shopcartCol = QueryServiceHelper.query((String)"mal_shopcartbill", (String)"id,goods.id", (QFilter[])qFilter.toArray());
        ArrayList<Long> prodIds = new ArrayList<Long>(1024);
        for (DynamicObject shopcart : shopcartCol) {
            prodIds.add(shopcart.getLong("goods.id"));
        }
        qFilter = new QFilter("goods.id", "in", prodIds);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        List prodPools = MalProductUtil.getProdPools((QFilter[])qFilter.toArray(), (String)"goods.id", (boolean)false);
        ArrayList<Long> poolProdIds = new ArrayList<Long>(1024);
        for (DynamicObject pool : prodPools) {
            if (!pool.getBoolean("isgoodvisible")) continue;
            poolProdIds.add(pool.getLong("goods.id"));
        }
        ArrayList<Object> deleteIds = new ArrayList<Object>(1024);
        qFilter = new QFilter("goods.id", "in", prodIds);
        qFilter.and(new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId()));
        shopcartCol = QueryServiceHelper.query((String)"mal_shopcartbill", (String)"id,goods.id", (QFilter[])qFilter.toArray());
        for (DynamicObject shopcart : shopcartCol) {
            long goodId = shopcart.getLong("goods.id");
            if (!poolProdIds.contains(goodId)) continue;
            deleteIds.add(shopcart.get("id"));
        }
        for (Object obj : pks) {
            if (deleteIds.contains(obj)) continue;
            deleteIds.add(obj);
        }
        DeleteServiceHelper.delete((IDataEntityType)newDynamicObject.getDataEntityType(), (Object[])deleteIds.toArray());
    }

    public static Boolean realDeleteSchemeData(IFormView view, String schemeId, String[] goodsId) {
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"mal_purscheme");
        DynamicObjectCollection schemeEntryDynCol = schemeDyn.getDynamicObjectCollection("goodsentry");
        DynamicObjectCollection newSchemeEntryDynCol = new DynamicObjectCollection();
        HashSet<String> goodsIdSet = new HashSet<String>(Arrays.asList(goodsId));
        int index = 0;
        for (Object entryDyn : schemeEntryDynCol) {
            if (goodsIdSet.contains(entryDyn.getString("goods.id"))) continue;
            newSchemeEntryDynCol.add(index++, (DynamicObject)entryDyn);
        }
        if (newSchemeEntryDynCol.size() > 0) {
            DynamicObjectCollection newSchemeEntry = newSchemeEntryDynCol;
            newSchemeEntryDynCol = new DynamicObjectCollection();
            index = 0;
            for (DynamicObject entryDyn : newSchemeEntry) {
                if (goodsIdSet.contains(entryDyn.getString("goods.number"))) continue;
                newSchemeEntryDynCol.add(index++, entryDyn);
            }
        }
        if (newSchemeEntryDynCol.size() == 0) {
            DynamicObject newDynamicObject = ORM.create().newDynamicObject("mal_purscheme");
            DeleteServiceHelper.delete((IDataEntityType)newDynamicObject.getDataEntityType(), (Object[])new Object[]{Long.valueOf(schemeId)});
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4ece\u5217\u8868\u79fb\u9664\u3002", (String)"MalShopCartUtil_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        schemeDyn.set("goodsentry", (Object)newSchemeEntryDynCol);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_purscheme", (DynamicObject[])new DynamicObject[]{schemeDyn}, (OperateOption)option);
        if (saveResult.isSuccess()) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4ece\u5217\u8868\u79fb\u9664\u3002", (String)"MalShopCartUtil_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4ece\u5217\u8868\u79fb\u9664\u5931\u8d25\u3002", (String)"MalShopCartUtil_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        return Boolean.FALSE;
    }

    public static Map<String, BigDecimal> getMalProdPrice(List<String> skuList) {
        HashMap<String, BigDecimal> price = new HashMap<String, BigDecimal>(1024);
        ArrayList<String> soldProdNumbers = new ArrayList<String>(1024);
        QFilter qFilter = new QFilter("goods.number", "in", skuList);
        String selector = "goods.id id,goods.number number,taxprice,goods.taxprice shopprice,mallstatus";
        List prodPools = MalProductUtil.getProdPools((QFilter[])qFilter.toArray(), (String)selector);
        for (DynamicObject dyo : prodPools) {
            if (dyo.getString("mallstatus").equals(MallStatusEnum.SOLD.getVal())) {
                price.put(dyo.getString(SCHEMENUMBER), dyo.getBigDecimal("taxprice"));
                soldProdNumbers.add(dyo.getString(SCHEMENUMBER));
                continue;
            }
            if (soldProdNumbers.contains(dyo.getString(SCHEMENUMBER))) continue;
            price.put(dyo.getString(SCHEMENUMBER), dyo.getBigDecimal("shopprice"));
        }
        return price;
    }

    public static void openPurScheme(IFormView view, CloseCallBack closeCallBack) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("mal_purscheme");
        param.setFormId("mal_listf7");
        param.setLookUp(true);
        param.setShowTitle(false);
        param.setMultiSelect(false);
        StyleCss css = new StyleCss();
        css.setWidth("900px");
        css.setHeight("600px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)param);
    }

    public static void deleteSelectedEntry(IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        int[] selectIndex = MalShopCartUtil.getSelectIndex(view.getControl(CART_ENTRYENTITY));
        if (selectIndex.length > 0) {
            String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u9009\u62e9\u5546\u54c1\uff1f", (String)"MalShopCartUtil_2", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalShopCartUtil_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public static void deleteCurrentEntry(IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u5546\u54c1\uff1f", (String)"MalShopCartUtil_4", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
    }

    public static Map<String, BigDecimal> getMalPrice(List<String> goodsIdList) {
        ArrayList mallGoodsIdList = new ArrayList();
        goodsIdList.forEach(id -> {
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                mallGoodsIdList.add(Long.parseLong(id));
            }
        });
        DynamicObjectCollection priceQuery = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods,price", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", mallGoodsIdList)});
        HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>(priceQuery.size());
        for (DynamicObject dyn : priceQuery) {
            priceMap.put(dyn.getString("mallgoods"), dyn.getBigDecimal("price"));
        }
        return priceMap;
    }

    public static void openMalOrderPage(IFormView view) {
        MainPageUtils.jumpToOrder((IFormView)view, (ShowType)MainPageUtils.getShowType((FormShowParameter)view.getFormShowParameter()));
    }

    public static void updateQty(PropertyChangedArgs e, IDataModel model, String fieldKey, IFormView view) {
        if (StringUtils.equals((CharSequence)CART_QTY, (CharSequence)fieldKey)) {
            BigDecimal newVal;
            ChangeData[] changedData = e.getChangeSet();
            int rowIndex = changedData[0].getRowIndex();
            DynamicObject rowEntity = model.getEntryRowEntity(CART_ENTRYENTITY, rowIndex);
            BigDecimal price = rowEntity.getBigDecimal(CART_PRICE);
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            if (oldVal.compareTo(newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue())) == 0) {
                return;
            }
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                rowEntity.set(CART_QTY, (Object)oldVal);
            } else {
                try {
                    String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
                    if (Boolean.parseBoolean(param)) {
                        String source = rowEntity.getString("cart_goodsource");
                        long goodsId = model.getValue("cart_goods", rowIndex) instanceof DynamicObject ? ((DynamicObject)model.getValue("cart_goods", rowIndex)).getLong("id") : Long.parseLong(String.valueOf(model.getValue("cart_goods", rowIndex)));
                        long orgId = ((DynamicObject)model.getValue("header_org")).getLong("id");
                        MalGoods mal = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)goodsId, (String)source, (BigDecimal)newVal, null, (Long)orgId), (boolean)false, (boolean)false);
                        price = mal.getTaxPrice();
                        model.setValue(CART_PRICE, (Object)mal.getTaxPrice(), rowIndex);
                    }
                    BigDecimal amount = newVal.multiply(price);
                    model.setValue(CART_AMOUNT, (Object)amount, rowIndex);
                    model.setValue(CART_SELECT_AMOUNT, (Object)amount);
                    Label totalQty = (Label)view.getControl(CART_SELECT_QTY);
                    totalQty.setText(String.valueOf(newVal));
                    MalShopCartUtil.updateAcountValue(view, MalShopCartUtil.getSelectIndex(view.getControl(CART_ENTRYENTITY)));
                    String pk = rowEntity.getString("cart_pk");
                    ArrayList<String> pagePksList = new ArrayList<String>(1);
                    pagePksList.add(pk);
                    HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(1);
                    qtyMap.put(pk, newVal);
                    HashMap<String, BigDecimal> taxAmountMap = new HashMap<String, BigDecimal>(1);
                    taxAmountMap.put(pk, amount);
                    MalShopCartUtil.saveChangedQty(pagePksList, qtyMap, taxAmountMap);
                }
                catch (KDException e1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u586b\u5199\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"MalShopCartUtil_5", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    model.setValue(CART_QTY, (Object)oldVal, rowIndex);
                }
            }
        }
    }

    public static DynamicObjectCollection saveScheme(IFormView view) {
        int[] selectedIndexs = MalShopCartUtil.getSelectIndex(view.getControl(CART_ENTRYENTITY));
        DynamicObjectCollection selectedSaveDyObject = null;
        if (selectedIndexs.length > 0) {
            selectedSaveDyObject = MalShopCartUtil.getSelectedDyObject(selectedIndexs, view.getControl(CART_ENTRYENTITY));
            List prodIdList = MalProductUtil.getListByProperty((DynamicObjectCollection)selectedSaveDyObject, (String)"cart_goods");
            ArrayList<Long> prodLongIDs = new ArrayList<Long>(1024);
            for (String id : prodIdList) {
                prodLongIDs.add(Long.parseLong(id));
            }
            Boolean isView = MalProductUtil.setMsgView((IFormView)view, prodLongIDs, (String)"addpurscheme");
            if (isView.booleanValue()) {
                return null;
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5546\u54c1\u8bb0\u5f55\u3002", (String)"MalShopCartUtil_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (!MalShopCartUtil.isSameSource(selectedSaveDyObject)) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u5546\u54c1\u6765\u6e90\u7684\u5546\u54c1\u4f5c\u4e3a\u91c7\u8d2d\u5957\u9910\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"MalShopCartUtil_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return null;
        }
        return selectedSaveDyObject;
    }

    public static void openSavePurScheme(IFormView view, CloseCallBack closeCallBack) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("mal_savescheme");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }

    public static void saveSchemeId(OnGetControlArgs e, IFormView view, Label label) {
        DynamicObjectCollection purSchemeDynCol = MalShopCartUtil.getPurSchemes();
        for (DynamicObject dyn : purSchemeDynCol) {
            if (!StringUtils.equals((CharSequence)dyn.getString("id"), (CharSequence)e.getKey())) continue;
            label.setKey(dyn.getString("id"));
            label.setView(view);
            e.setControl((Control)label);
        }
    }

    public static void showScheme(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        if (StringUtils.isNotBlank((CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent.getActionId().equals("mal_purscheme")) {
            HashMap returnData;
            if (null != closedCallBackEvent.getReturnData() && ((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).size() > 0) {
                HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>();
                Long purSchemeId = (Long)((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0).getPrimaryKeyValue();
                QFilter filter = new QFilter("id", "=", (Object)purSchemeId);
                DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_purscheme", (String)"goodsentry.goods.id,goodsentry.qty", (QFilter[])new QFilter[]{filter});
                ArrayList<Long> pksList = new ArrayList<Long>();
                for (DynamicObject dyo : dyoCol) {
                    Long goodsId = dyo.getLong("goodsentry.goods.id");
                    pksList.add(goodsId);
                    qtyMap.put(goodsId, dyo.getBigDecimal("goodsentry.qty"));
                }
                MalProductUtil.deleteCartProds(null);
                MalAddToCartHelper.batchAddMalProdToCart(pksList, qtyMap);
                view.invokeOperation("refreshcart");
                MalShopCartUtil.initEntryRow(view);
            }
            if (StringUtils.isNotBlank((CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent.getActionId().equals("mal_makeorder") && null != closedCallBackEvent.getReturnData() && ((Boolean)(returnData = (HashMap)closedCallBackEvent.getReturnData()).get("sucessMakeOrder")).booleanValue()) {
                view.invokeOperation("refreshcart");
            }
        }
    }

    public static void confirmScheme(MessageBoxClosedEvent messageBoxClosedEvent, IFormView view, CloseCallBack closeCallBack) {
        if (StringUtils.equals((CharSequence)KEY_PURSCHEME, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            MalShopCartUtil.openPurScheme(view, closeCallBack);
        }
        if (StringUtils.equals((CharSequence)KEY_DELETESELECT, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            int[] selectIndex = MalShopCartUtil.getSelectIndex(view.getControl(CART_ENTRYENTITY));
            HashSet<Integer> set = new HashSet<Integer>(selectIndex.length);
            for (int i : selectIndex) {
                set.add(i);
            }
            Integer[] temp = set.toArray(new Integer[0]);
            int[] intArray = new int[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                intArray[i] = temp[i];
            }
            view.getModel().deleteEntryRows(CART_ENTRYENTITY, intArray);
        }
    }

    public static boolean isSelfGoods(List<String> prodIdList, IFormView view) {
        if (prodIdList.size() > 0) {
            ArrayList<Long> prodLongIDs = new ArrayList<Long>(1024);
            for (String id : prodIdList) {
                prodLongIDs.add(Long.parseLong(id));
            }
            Boolean isView = MalProductUtil.setMsgView((IFormView)view, prodLongIDs, (String)"settle");
            if (isView.booleanValue()) {
                return false;
            }
            List prodNumberList = MalProductUtil.checkProdMalStates(prodIdList);
            if (null != prodNumberList && prodNumberList.size() > 0) {
                view.showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartUtil_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a", (String)"MalShopCartUtil_7", (String)"scm-mal-formplugin", (Object[])new Object[0]) + "\n" + String.join((CharSequence)",", prodNumberList), MessageTypes.Default);
                return false;
            }
        }
        return true;
    }

    public static List<String> isMalGoods(DynamicObjectCollection rowsDyObject) {
        ArrayList<String> list = new ArrayList<String>(rowsDyObject.size());
        for (DynamicObject dyo : rowsDyObject) {
            String source = dyo.getString("cart_goodsource");
            String stock = dyo.getString("cart_stock_qty");
            String number = dyo.getString("cart_number");
            if (dyo.getBigDecimal(CART_PRICE).compareTo(BigDecimal.ZERO) <= 0) {
                list.add(number);
                continue;
            }
            if (stock.equals(StockEnum.SOLDOUT.getName())) {
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_XY.getVal().equals(source)) continue;
                list.add(number);
                continue;
            }
            if (stock.equals(StockEnum.SALE.getName()) || stock.equals(StockEnum.SOLDOUT.getName())) continue;
            BigDecimal cart_stock_qty = BigDecimal.ZERO;
            if (null != dyo.get("cart_stock_qty")) {
                cart_stock_qty = dyo.getBigDecimal("cart_stock_qty");
            }
            BigDecimal cart_qty = BigDecimal.ZERO;
            if (null != dyo.get(CART_QTY)) {
                cart_qty = dyo.getBigDecimal(CART_QTY);
            }
            if (cart_stock_qty.compareTo(cart_qty) >= 0 || EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_XY.getVal().equals(source)) continue;
            list.add(number);
        }
        return list;
    }
}

