/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.util.MalAddressUtil;

public class MalAddressSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)MalAddressSaveOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("address");
        e.getFieldKeys().add("mapaddress");
        e.getFieldKeys().add("jdaddressnum");
        e.getFieldKeys().add("wholeaddress");
        e.getFieldKeys().add("default");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        HashSet<Long> admindivisionIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            admindivisionIdSet.add(dynamicObject.getLong("address"));
        }
        boolean hasJdToken = this.isHasJdToken();
        Map admindivisionDynMap = BusinessDataServiceHelper.loadFromCache((Object[])admindivisionIdSet.toArray(new Object[0]), (String)"bd_admindivision");
        StringBuilder logStr = new StringBuilder();
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            DynamicObject admindivisionDyn;
            this.handleWholeAddress(admindivisionDynMap, dynamicObject);
            if (!hasJdToken || (admindivisionDyn = MalAddressUtil.getAdmindivisionById((String)dynamicObject.getString("address"))) == null || admindivisionDyn.getInt("level") < 2) continue;
            String adminFullName = admindivisionDyn.getString("fullname");
            String address = adminFullName + "_" + dynamicObject.getString("mapaddress");
            String jdAdrNum = "";
            try {
                jdAdrNum = MalAddressUtil.getJdAdrNumFromApi((String)address, (boolean)false);
            }
            catch (Exception exception) {
                logStr.append(ExceptionUtil.getStackTrace((Throwable)exception));
            }
            if (!MalOrderUtil.getDefaultMalVersion() && !MalAddressUtil.validateJdAddress((String)adminFullName, (String)jdAdrNum)) {
                String jdAdminAdr = JdApiUtil.getAddressJonString((String)address);
                throw new KDBizException(ResManager.loadKDString((String)MessageFormat.format("\u6821\u9a8c\u4eac\u4e1c\u5730\u5740\u6709\u8bef\uff1a\u7701\u5e02\u533a\u201c{0}\u201d\u4e0e\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u201c{1}\u201d\u4e0d\u5339\u914d,\u8bf7\u4fdd\u8bc1\u7701\u5e02\u533a\u7684\u533a\u4e0e\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u4e2d\u7684\u533a\uff08county\uff09\u4e00\u81f4\u3002", adminFullName, jdAdminAdr), (String)"MalAddressSaveOp_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            dynamicObject.set("jdaddressnum", (Object)jdAdrNum);
        }
        if (logStr.length() > 0) {
            log.error(logStr.toString());
        }
    }

    private boolean isHasJdToken() {
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            return false;
        }
        return openedMalNos.contains(EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    private void handleWholeAddress(Map<Object, DynamicObject> admindivisionDynMap, DynamicObject dynamicObject) {
        String mapaddress = dynamicObject.getString("mapaddress");
        DynamicObject admindivisionDyn = admindivisionDynMap.get(dynamicObject.getLong("address"));
        String fullName = admindivisionDyn.getString("fullname");
        dynamicObject.set("wholeaddress", (Object)(fullName + "_" + mapaddress));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        QFilter filter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()).and("default", "=", (Object)true);
        Map defaultAddressDynMap = BusinessDataServiceHelper.loadFromCache((String)"mal_address", (String)"default,number", (QFilter[])new QFilter[]{filter});
        if (defaultAddressDynMap.size() > 1) {
            for (ExtendedDataEntity extendedDataEntity : e.getSelectedRows()) {
                boolean defulat = extendedDataEntity.getDataEntity().getBoolean("default");
                if (defulat) {
                    for (DynamicObject addressDyn : defaultAddressDynMap.values()) {
                        if (addressDyn.getPkValue().equals(extendedDataEntity.getBillPkId())) continue;
                        addressDyn.set("default", (Object)Boolean.FALSE);
                    }
                    continue;
                }
                ArrayList tempList = new ArrayList(defaultAddressDynMap.values());
                for (int i = 1; i < defaultAddressDynMap.size(); ++i) {
                    ((DynamicObject)tempList.get(i)).set("default", (Object)Boolean.FALSE);
                }
            }
            SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])defaultAddressDynMap.values().toArray(new DynamicObject[0]));
        }
    }
}

