/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizTypeEnum;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.SynOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.opplugin.botp.MalOrderToPmOrderUtil;
import kd.scm.malcore.domain.GoodsInventoryHandleOrder;
import kd.scm.malcore.domain.GoodsInventoryHandleParam;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;

public class MalOrderAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(MalOrderAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.goods");
        e.getFieldKeys().add("platform");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("order");
        e.getFieldKeys().add("entryentity.erpsourceentryid");
        e.getFieldKeys().add("entryentity.qty");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        log.info("@@@\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\uff0c\u4e1a\u52a1\u6d41\u7a0b\u53c2\u6570\uff1a" + MalOrderUtil.getBizFlowParam());
        if ("audit".equals(operationKey) && StringUtils.equalsIgnoreCase((CharSequence)MalOrderUtil.getBizFlowParam(), (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) {
            log.info("@@@\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\uff0c\u751f\u6210EAS\u7533\u8bf7\u5355\uff0c\u5546\u57ce\u662f\u5426\u65b0\u7248\u672c\uff1a" + MalOrderUtil.getDefaultMalVersion());
            return;
        }
        if ("audit".equals(operationKey) && !MalOrderUtil.getDefaultMalVersion()) {
            String bizflow = MalOrderUtil.getBizFlowParam();
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal()) && ApiConfigUtil.hasEASConfig()) {
                DynamicObject[] objs = e.getDataEntities();
                ArrayList<Object> pks = new ArrayList<Object>(objs.length);
                for (DynamicObject obj : objs) {
                    pks.add(obj.get("id"));
                }
                SynOrderUtil.synCreateEasPurRequest(pks, (String)"mal_order");
            } else if (ApiConfigUtil.hasCQScmConfig()) {
                MalOrderToPmOrderUtil.pushPurBill(e.getValidExtDataEntities());
            } else {
                List Objs = e.getValidExtDataEntities();
                for (ExtendedDataEntity obj : Objs) {
                    DynamicObject bill = obj.getDataEntity();
                    String billNo = bill.getString("billno");
                    this.pushBill(billNo, "mal_order", "pur_order");
                }
            }
        }
    }

    private void pushBill(String billNo, String srcEntityKey, String targetEntityKey) {
        DynamicObjectCollection billColl = this.assemblePushBillData(billNo, srcEntityKey);
        if (null != billColl) {
            Long malOrderCreatorId = ((DynamicObject)billColl.get(0)).getLong("creator.id");
            List targetData = MalBizFowUtil.getPushTargetDataList((DynamicObjectCollection)billColl, (String)srcEntityKey, (String)targetEntityKey);
            this.handleAfterPushBill(targetData);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ignoreValidation", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            OperationResult saveResult = null;
            String bizflow = MalOrderUtil.getBizFlowParam();
            saveResult = this.doSaveOperation(targetEntityKey, targetData, option, malOrderCreatorId);
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                OperationResult submitResult = this.doSubmitOperation(targetEntityKey, saveResult, option, billNo);
                this.doAuditOperation(targetEntityKey, saveResult, submitResult, option, billNo);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
                this.doSubmitOperation(targetEntityKey, saveResult, option, billNo);
            }
        }
    }

    protected OperationResult doSaveOperation(String targetEntityKey, List<DynamicObject> targetData, OperateOption option, Long malOrderCreatorId) {
        log.info("@@@kd.scm.mal.opplugin.MalOrderAuditOp.doSaveOperation-->\u5f00\u59cb\u6267\u884c\u534f\u540c\u8ba2\u5355\u4fdd\u5b58\u64cd\u4f5c");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetEntityKey, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
        CommonUtil.check((OperationResult)saveResult);
        try (TXHandle h = TX.requiresNew();){
            this.handleTargetBill(saveResult, targetData, targetEntityKey, malOrderCreatorId);
        }
        catch (Exception e) {
            log.error("@@@kd.scm.mal.opplugin.MalOrderAuditOp.doSaveOperation\u5904\u7406\u5355\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return saveResult;
    }

    protected OperationResult doSubmitOperation(String targetEntityKey, OperationResult saveResult, OperateOption option, String billNo) {
        log.info("@@@kd.scm.mal.opplugin.MalOrderAuditOp.doSubmitOperation-->\u5f00\u59cb\u6267\u884c\u534f\u540c\u8ba2\u5355\u63d0\u4ea4\u64cd\u4f5c");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityKey, (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
        if (!submitResult.isSuccess()) {
            this.rollBackPurOrder(saveResult, billNo);
            log.error("@@@MalOrderAuditOp.pushBill:\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
            throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u63d0\u4ea4\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderAuditOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0])), new Object[]{ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())});
        }
        try (TXHandle h = TX.requiresNew();){
            this.handleErpBillStatus(billNo);
        }
        catch (Exception e) {
            log.error("@@@kd.scm.mal.opplugin.MalOrderAuditOp.doSubmitOperation\u5904\u7406\u63d0\u4ea4\u53cd\u5199\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return submitResult;
    }

    protected void doAuditOperation(String targetEntityKey, OperationResult saveResult, OperationResult submitResult, OperateOption option, String billNo) {
        log.info("@@@kd.scm.mal.opplugin.MalOrderAuditOp.doAuditOperation-->\u5f00\u59cb\u6267\u884c\u534f\u540c\u8ba2\u5355\u5ba1\u6838\u64cd\u4f5c");
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityKey, (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
        if (!auditResult.isSuccess()) {
            this.rollBackPurOrder(saveResult, billNo);
            log.error("@@@MalOrderAuditOp.pushBill:\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
            throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u5ba1\u6838\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderAuditOp_2", (String)"scm-mal-opplugin", (Object[])new Object[0])), new Object[]{ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())});
        }
    }

    private void rollBackPurOrder(OperationResult saveOpResult, String billNo) {
        if (saveOpResult != null && saveOpResult.getSuccessPkIds() != null && saveOpResult.getSuccessPkIds().size() > 0) {
            Object[] pks = saveOpResult.getSuccessPkIds().toArray(new Long[0]);
            QFilter pkFilter = new QFilter("id", "in", (Object)pks);
            try (TXHandle h = TX.requiresNew();){
                DeleteServiceHelper.delete((String)"pur_order", (QFilter[])new QFilter[]{pkFilter});
                this.rollBackMalOrder(billNo);
            }
            catch (Exception e) {
                log.error("@@@MalOrderAuditOp.rollBackPurOrder:\u56de\u6eda\u5f02\u5e38\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + Arrays.toString(pks) + "\n" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private void rollBackMalOrder(String billNo) {
        QFilter noFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)"jdorderstatus,entryentity.erpbillnumber,entryentity.erpbillstatus,entryentity.entrystatus,entryentity.sumorderqty", (QFilter[])new QFilter[]{noFilter});
        if (null != dyos && dyos.length > 0) {
            for (DynamicObject dyo : dyos) {
                if (StringUtils.isNotBlank((CharSequence)dyo.getString("jdorderstatus"))) {
                    dyo.set("jdorderstatus", (Object)JDOrderStatusEnum.CREATE.getName());
                }
                DynamicObjectCollection entryDyoCol = dyo.getDynamicObjectCollection("entryentity");
                entryDyoCol.forEach(entryDyo -> {
                    entryDyo.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                    entryDyo.set("erpbillnumber", null);
                    entryDyo.set("erpbillstatus", null);
                    entryDyo.set("sumorderqty", (Object)BigDecimal.ZERO);
                });
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    private void handleErpBillStatus(String billNo) {
        QFilter noFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)"entryentity.erpbillstatus", (QFilter[])new QFilter[]{noFilter});
        if (null != dyos && dyos.length > 0) {
            for (DynamicObject dyo : dyos) {
                DynamicObjectCollection entryDyoCol = dyo.getDynamicObjectCollection("entryentity");
                entryDyoCol.forEach(entryDyo -> entryDyo.set("erpbillstatus", (Object)BillStatusEnum.SUBMIT.getVal()));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    public void handleTargetBill(OperationResult opResult, List<DynamicObject> targetData, String targetEntityKey, Long malOrderCreatorId) {
        QFilter filter = new QFilter("id", "in", (Object)opResult.getSuccessPkIds().toArray(new Object[0]));
        String selectFileds = "id,billno,billstatus,cfmstatus,creator,auditor,auditdate,materialentry.entryrcvorg,materialentry.entrysettleorg,materialentry.pobillno,materialentry.pobillid,materialentry.poentryid";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)targetEntityKey, (String)selectFileds, (QFilter[])new QFilter[]{filter});
        if (null != targetData) {
            String bizflow = MalOrderUtil.getBizFlowParam();
            StringBuilder logString = new StringBuilder();
            for (DynamicObject dyo : dynamicObjects) {
                if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                    dyo.set("cfmstatus", (Object)"A");
                }
                dyo.set("creator", (Object)malOrderCreatorId);
                logString.append(ResManager.loadKDString((String)"Line-->337\u8ba2\u5355\u6267\u884c\u8ddf\u8e2a\u521b\u5efa\u4eba\uff1a", (String)"MalOrderAuditOp_4", (String)"scm-mal-opplugin", (Object[])new Object[0])).append(dyo.getLong("creator.id")).append("\n");
                DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("materialentry");
                if (null == entryCol || entryCol.size() <= 0) continue;
                Long orgId = ((DynamicObject)((DynamicObject)entryCol.get(0)).get("entryrcvorg")).getLong("id");
                Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (result.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\uff0c\u7ec4\u7ec7\u7684\u6b63\u786e\u6027\u3002", (String)"MalOrderAuditOp_3", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                }
                long settleOrgId = Long.parseLong(result.get("id").toString());
                for (DynamicObject entrydyo : entryCol) {
                    if (settleOrgId != 0L && null == entrydyo.get("entrysettleorg")) {
                        entrydyo.set("entrysettleorg", (Object)settleOrgId);
                    }
                    entrydyo.set("pobillno", dyo.get("billno"));
                    entrydyo.set("pobillid", dyo.get("id"));
                    entrydyo.set("poentryid", entrydyo.get("id"));
                }
            }
            log.info(logString.toString());
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void handleAfterPushBill(List<DynamicObject> targetData) {
        Set supplierIdSet = MalBizFowUtil.getSupplierIdSet(targetData);
        Map bizPartnerMap = MalBizFowUtil.getBizPartner((Set)supplierIdSet);
        StringBuilder logStr = new StringBuilder();
        for (DynamicObject data : targetData) {
            data.set("biztype", (Object)BizTypeEnum.PUR_STANDARD.getVal());
            Long supplierId = data.getLong("supplier.id");
            Object bizPartner = bizPartnerMap.get(supplierId);
            if (bizPartner != null) {
                data.set("bizpartner_id", bizPartner);
            }
            Cal4DynamicObj.calSum((DynamicObject)data, (String)"materialentry");
            this.setCenterBalance(data);
            logStr.append("@@@jdorderid\uff1a").append(data.getString("jdorderid"));
        }
        log.info(logStr.toString());
    }

    protected void setCenterBalance(DynamicObject data) {
        MalBizFowUtil.setCenterBalance((DynamicObject)data);
    }

    public DynamicObjectCollection assemblePushBillData(String billNo, String srcEntityKey) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        return QueryServiceHelper.query((String)srcEntityKey, (String)"id,entryentity.id entryentity,creator.id,jdorderid", (QFilter[])new QFilter[]{filter});
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (MalOrderParamUtil.getDefaultMalVersion()) {
            DynamicObject[] dynamicObjects = e.getDataEntities();
            GoodsInventoryHandleParam goodsInventoryHandleParam = new GoodsInventoryHandleParam();
            ArrayList<GoodsInventoryHandleOrder> orderList = new ArrayList<GoodsInventoryHandleOrder>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(dynamicObject.getString("platform"))) continue;
                GoodsInventoryHandleOrder goodsInventoryHandleOrder = new GoodsInventoryHandleOrder();
                goodsInventoryHandleOrder.setOperationName("audit");
                goodsInventoryHandleOrder.setEntityName("mal_order");
                goodsInventoryHandleOrder.setBillNo(dynamicObject.getString("billno"));
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dynamicObjectCollection.size());
                for (DynamicObject entry : dynamicObjectCollection) {
                    long goodsId = entry.getLong("goods_id");
                    GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
                    sku.setGoodsId(Long.valueOf(goodsId));
                    sku.setGoodsNumber(entry.getDynamicObject("goods").getString("number"));
                    sku.setQty(entry.getBigDecimal("qty"));
                    skuList.add(sku);
                }
                goodsInventoryHandleOrder.setSkuList(skuList);
                orderList.add(goodsInventoryHandleOrder);
            }
            goodsInventoryHandleParam.setGoodsInventoryHandleOrderList(orderList);
            if (!orderList.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"confirmGoodsLockInventoryQty", (Object[])new Object[]{goodsInventoryHandleParam});
            }
        }
    }
}

