/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.opplugin.validator.MalOrderValidator;
import kd.scm.malcore.domain.GoodsInventoryHandleOrder;
import kd.scm.malcore.domain.GoodsInventoryHandleParam;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;
import net.sf.json.JSONObject;

public class MalOrderCancelOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(MalOrderCancelOp.class);
    private Map<Long, Set<Long>> cancelEntryIdMap = new HashMap<Long, Set<Long>>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("cfmstatus");
        filds.add("jdorderstatus");
        filds.add("jdorderid");
        filds.add("platform");
        filds.add("billno");
        filds.add("billstatus");
        filds.add("auditdate");
        filds.add("entryentity.erpbillnumber");
        filds.add("entryentity.erpbillstatus");
        filds.add("entryentity.erplogstatus");
        filds.add("entryentity.goods");
        filds.add("entryentity.order");
        filds.add("asyncstatus");
        filds.add("entryentity.erpsourceentryid");
        filds.add("entryentity.qty");
        filds.add("entryentity.entrystatus");
        if (MalOrderUtil.getDefaultMalVersion()) {
            filds.add("ecorderid");
            filds.add("orderstatus");
        }
    }

    protected void setEcOrderStatus(String source, String ecOrderId) {
        DynamicObject[] dyos = null;
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source)) {
            QFilter filter = MalOrderUtil.getDefaultMalVersion() ? new QFilter("id", "=", (Object)Long.parseLong(ecOrderId)) : new QFilter("number", "=", (Object)ecOrderId);
            dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdorderstate", (QFilter[])new QFilter[]{filter});
            if (null != dyos) {
                for (DynamicObject bill : dyos) {
                    bill.set("jdorderstate", (Object)"0");
                }
            }
        } else {
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(ecOrderId));
            String orderMark = MalNewOrderUtils.getPlatformId((String)source);
            for (DynamicObject bill : dyos = BusinessDataServiceHelper.load((String)orderMark, (String)"orderid,orderstate,state", (QFilter[])new QFilter[]{filter})) {
                if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
                    bill.set("orderstate", (Object)"5");
                }
                if (EcPlatformEnum.ECPLATFORM_XY.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_CG.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_DL.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(source)) {
                    bill.set("orderstate", (Object)"0");
                }
                if (!EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) continue;
                bill.set("state", (Object)"90");
            }
        }
        if (null != dyos) {
            SaveServiceHelper.save((DynamicObject[])dyos);
        }
        log.info("@@@MalOrderCancelOp.setEcOrderStatus\u8bbe\u7f6e\u7535\u5546\u72b6\u6001\u6210\u529f");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjs;
        super.beginOperationTransaction(e);
        for (DynamicObject info : dynamicObjs = e.getDataEntities()) {
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
            HashSet<Long> entryIds = new HashSet<Long>(16);
            for (DynamicObject row : entryCol) {
                if (!"F".equals(row.getString("entrystatus"))) continue;
                entryIds.add(row.getLong("id"));
            }
            this.cancelEntryIdMap.put(info.getLong("id"), entryIds);
        }
        DynamicObject malOrder = dynamicObjs[0];
        String platform = malOrder.getString("platform");
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        try {
            if (StringUtils.equals((CharSequence)platform, (CharSequence)EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                this.cancelMalOrder4Self(malOrder);
            } else {
                this.cancelMalOrder4Ec(platform, defaultMalVersion, malOrder);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjs);
        }
        catch (Exception exception) {
            log.error("@@beginOperationTransaction\u53d6\u6d88\u8ba2\u5355\u5931\u8d25--->" + ExceptionUtil.getStackTrace((Throwable)exception));
            e.setCancelOperation(true);
            if (exception instanceof KDException) {
                if (((KDException)exception).getErrorCode().getCode().equalsIgnoreCase("bos.wf.withdrawError")) {
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u5df2\u88ab\u5904\u7406\uff0c\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{0}\u8bf7\u8054\u7cfb\u5bf9\u5e94\u5355\u636e\u8282\u70b9\u5904\u7406\u4eba\u3002", (String)"MalOrderCancelOp_2", (String)"scm-mal-opplugin", (Object[])new Object[0]), ((KDException)exception).getErrorCode().getMessage()));
                }
                throw new KDBizException(ResManager.loadKDString((String)exception.getMessage(), (String)"MalOrderCancelOp_2", (String)"MalOrderCancelOp_5", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderCancelOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getPartEntryIds(DynamicObject malOrder) {
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String entrIdListStr = (String)paramMap.get("entryIds");
        ArrayList<String> entrIdList = new ArrayList(16);
        if (!StringUtils.isEmpty((CharSequence)entrIdListStr)) {
            entrIdList = (List)SerializationUtils.fromJsonString((String)entrIdListStr, List.class);
        }
        DynamicObjectCollection entryCol = malOrder.getDynamicObjectCollection("entryentity");
        HashSet<String> cancelBillnos = new HashSet<String>(16);
        for (DynamicObject row : entryCol) {
            String erpbillstatus;
            if (!entrIdList.contains(row.getString("id")) || !"A".equals(erpbillstatus = row.getString("erpbillstatus")) && !"B".equals(erpbillstatus)) continue;
            cancelBillnos.add(row.getString("erpbillnumber"));
        }
        for (DynamicObject row : entryCol) {
            String entryId = row.getString("id");
            String erpbillnumber = row.getString("erpbillnumber");
            if (!cancelBillnos.contains(erpbillnumber)) continue;
            entrIdList.add(entryId);
        }
        return entrIdList;
    }

    private void handleEcOrder(String platform, boolean defaultMalVersion, DynamicObject dataEntity) {
        if (defaultMalVersion) {
            this.cancelMalOrder(dataEntity);
            if (this.isPartCancelOrder(platform, dataEntity)) {
                this.setEcOrderStatusByPartCancel(dataEntity);
            } else {
                this.setEcOrderStatus(platform, dataEntity.getString("ecorderid_id"));
                dataEntity.set("orderstatus", (Object)JDOrderStatusEnum.CANCEL.getVal());
                DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entryCol) {
                    row.set("entrystatus", (Object)"F");
                }
                dataEntity.set("billstatus", (Object)"Z");
            }
        } else {
            dataEntity.set("jdorderstatus", (Object)JDOrderStatusEnum.CANCEL.getName());
            this.cancelJdOrder(dataEntity);
            this.setEcOrderStatus(platform, dataEntity.getString("jdorderid"));
        }
    }

    private void setEcOrderStatusByPartCancel(DynamicObject dataEntity) {
        String source = dataEntity.getString("platform");
        List<String> partEntryIds = this.getPartEntryIds(dataEntity);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet<Long> childOrderIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCol) {
            String ecOrderId = row.getString("order.id");
            if (StringUtils.isEmpty((CharSequence)ecOrderId) || !partEntryIds.contains(row.getString("id"))) continue;
            childOrderIds.add(Long.parseLong(ecOrderId));
            row.set("entrystatus", (Object)"F");
        }
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source)) {
            DynamicObject[] dyos;
            QFilter filter = new QFilter("id", "in", childOrderIds);
            for (DynamicObject bill : dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdorderstate", (QFilter[])new QFilter[]{filter})) {
                bill.set("jdorderstate", (Object)"0");
            }
            if (dyos.length > 0) {
                SaveServiceHelper.save((DynamicObject[])dyos);
            }
        }
    }

    private List<String> getMalrderEntryIds(DynamicObject dataEntity) {
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<String> needCancelEntryIds = new ArrayList<String>(16);
        for (DynamicObject row : entryCol) {
            if (row.getString("entrystatus").equals("F")) continue;
            needCancelEntryIds.add(row.getString("id"));
        }
        return needCancelEntryIds;
    }

    protected void cancelMalOrder4Ec(String platform, boolean defaultMalVersion, DynamicObject dataEntity) {
        String billStatus = this.getBillStatus(dataEntity);
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getVal())) {
            this.handleEcOrder(platform, defaultMalVersion, dataEntity);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getVal())) {
            DynamicObject[] purOrders = this.getPurOrderInfo(dataEntity);
            if (null == purOrders || purOrders.length == 0) {
                this.handleEcOrder(platform, defaultMalVersion, dataEntity);
            } else {
                OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
                Map paramMap = operation.getVariables();
                String entrIdListStr = (String)paramMap.get("entryIds");
                List entrIdList = new ArrayList(16);
                ArrayList srcEntryIds = new ArrayList();
                if (!StringUtils.isEmpty((CharSequence)entrIdListStr)) {
                    entrIdList = (List)SerializationUtils.fromJsonString((String)entrIdListStr, List.class);
                    srcEntryIds.addAll(entrIdList);
                } else {
                    DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryCols) {
                        srcEntryIds.add(row.getString("id"));
                    }
                }
                if (srcEntryIds.size() > 0) {
                    log.info("cancelMalOrder4Ec_srcEntryIds=" + SerializationUtils.toJsonString(srcEntryIds));
                    DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"cancelOrderUpdateStatus", (Object[])new Object[]{srcEntryIds});
                }
                DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
                boolean isAllCancel = true;
                for (DynamicObject row : entryCol) {
                    if ("F".equals(row.getString("entrystatus"))) continue;
                    isAllCancel = false;
                    break;
                }
                if (isAllCancel) {
                    dataEntity.set("billstatus", (Object)"Z");
                }
            }
        }
    }

    protected void cancelMalOrder4Self(DynamicObject dataEntity) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        String billStatus = this.getBillStatus(dataEntity);
        this.cancelGoodsLockInventory(dataEntity, billStatus, defaultMalVersion);
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getVal())) {
            this.setPurorderStatus(dataEntity, defaultMalVersion);
            log.info("@@@MalOrderCancelOp.cancelMalOrder4Self\u8bbe\u7f6e\u5546\u57ce\u8ba2\u5355\u7269\u6d41\u72b6\u6001\u6210\u529f");
            this.setMalOrderEntryStatus(dataEntity, defaultMalVersion);
            this.setMalOrderBillStatus(dataEntity, defaultMalVersion);
            log.info("@@@MalOrderCancelOp.cancelMalOrder4Self\u8bbe\u7f6e\u534f\u540c\u8ba2\u5355\u72b6\u6001\u6210\u529f");
            this.setMalOrderLogisticStatus(dataEntity, defaultMalVersion);
        } else {
            dataEntity.set("billstatus", (Object)"Z");
            DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryCols) {
                row.set("entrystatus", (Object)"F");
            }
        }
    }

    private void setPurorderStatus(DynamicObject dataEntity, boolean defaultMalVersion) {
        List<String> partEntryIds = this.getPartEntryIds(dataEntity);
        String source = dataEntity.getString("platform");
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<String> srcEntryIds = new ArrayList<String>();
        if (defaultMalVersion && this.isPartCancelOrder(source, dataEntity)) {
            srcEntryIds.addAll(partEntryIds);
        } else {
            for (DynamicObject row : entryCols) {
                srcEntryIds.add(row.getString("id"));
            }
        }
        if (srcEntryIds.size() > 0) {
            log.info("srcEntryIds=" + SerializationUtils.toJsonString(srcEntryIds));
            DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"cancelOrderUpdateStatus", (Object[])new Object[]{srcEntryIds});
        }
    }

    private void setMalOrderBillStatus(DynamicObject dataEntity, boolean defaultMalVersion) {
        String source = dataEntity.getString("platform");
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
        if (defaultMalVersion && this.isPartCancelOrder(source, dataEntity)) {
            boolean isPart = false;
            for (DynamicObject row : entryCols) {
                if (row.getString("entrystatus").equals("F")) continue;
                isPart = true;
            }
            if (!isPart) {
                dataEntity.set("billstatus", (Object)"Z");
            }
        } else {
            dataEntity.set("billstatus", (Object)"Z");
        }
    }

    private void setMalOrderEntryStatus(DynamicObject dataEntity, boolean defaultMalVersion) {
        List<String> partEntryIds = this.getPartEntryIds(dataEntity);
        String source = dataEntity.getString("platform");
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
        if (defaultMalVersion && this.isPartCancelOrder(source, dataEntity)) {
            for (DynamicObject row : entryCols) {
                if (!partEntryIds.contains(row.getString("id"))) continue;
                row.set("entrystatus", (Object)"F");
            }
        } else {
            for (DynamicObject row : entryCols) {
                row.set("entrystatus", (Object)"F");
            }
        }
    }

    private String getBillStatus(DynamicObject dataEntity) {
        DynamicObject dyo = QueryServiceHelper.queryOne((String)dataEntity.getDataEntityType().getName(), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataEntity.getLong("id"))});
        return dyo.getString("billstatus");
    }

    private void cancelGoodsLockInventory(DynamicObject dynamicObject, String billStatus, boolean malVersion) {
        if (malVersion) {
            GoodsInventoryHandleParam goodsInventoryHandleParam = new GoodsInventoryHandleParam();
            ArrayList<GoodsInventoryHandleOrder> orderList = new ArrayList<GoodsInventoryHandleOrder>();
            GoodsInventoryHandleOrder goodsInventoryHandleOrder = new GoodsInventoryHandleOrder();
            goodsInventoryHandleOrder.setOperationName("cancel");
            goodsInventoryHandleOrder.setEntityName("mal_order");
            goodsInventoryHandleOrder.setBillNo(dynamicObject.getString("billno"));
            goodsInventoryHandleOrder.setAuditDate(dynamicObject.getDate("auditdate"));
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dynamicObjectCollection.size());
            List<String> entrIdList = this.getPartEntryIds(dynamicObject);
            for (DynamicObject entry : dynamicObjectCollection) {
                if (entrIdList.size() > 0 && !entrIdList.contains(entry.getString("id"))) continue;
                long goodsId = entry.getLong("goods_id");
                GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
                sku.setGoodsId(Long.valueOf(goodsId));
                sku.setGoodsNumber(entry.getDynamicObject("goods").getString("number"));
                sku.setQty(entry.getBigDecimal("qty"));
                skuList.add(sku);
            }
            goodsInventoryHandleOrder.setSkuList(skuList);
            orderList.add(goodsInventoryHandleOrder);
            goodsInventoryHandleParam.setGoodsInventoryHandleOrderList(orderList);
            if (!orderList.isEmpty()) {
                if (BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
                    DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"cancelGoodsLockInventoryQty", (Object[])new Object[]{goodsInventoryHandleParam});
                } else if (BillStatusEnum.AUDIT.getVal().equals(billStatus)) {
                    DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"addGoodsCurrentInventoryQty", (Object[])new Object[]{goodsInventoryHandleParam});
                }
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MalOrderValidator());
    }

    public void handleCancelMalOrder(DynamicObject dataEntity) {
    }

    private void setMalOrderLogisticStatus(DynamicObject dataEntity, boolean defaultMalVersion) {
        DynamicObjectCollection entryDyoCol = dataEntity.getDynamicObjectCollection("entryentity");
        boolean isPartCancelOrder = this.isPartCancelOrder(dataEntity.getString("platform"), dataEntity);
        List<String> entrIdList = this.getPartEntryIds(dataEntity);
        HashSet<String> erpNos = new HashSet<String>(16);
        for (DynamicObject entryDyo : entryDyoCol) {
            if (!StringUtils.isNotEmpty((CharSequence)entryDyo.getString("erpbillnumber")) || !defaultMalVersion || entrIdList.size() <= 0 || entrIdList.contains(entryDyo.getString("id")) || "F".equals(entryDyo.getString("entrystatus"))) continue;
            erpNos.add(entryDyo.getString("erpbillnumber"));
        }
        HashSet<String> cancelRrpNos = new HashSet<String>(16);
        for (DynamicObject entryDyo : entryDyoCol) {
            if (!StringUtils.isNotEmpty((CharSequence)entryDyo.getString("erpbillnumber")) || defaultMalVersion && isPartCancelOrder && entrIdList.size() > 0 && (!entrIdList.contains(entryDyo.getString("id")) || erpNos.contains(entryDyo.getString("erpbillnumber")))) continue;
            cancelRrpNos.add(entryDyo.getString("erpbillnumber"));
        }
        for (DynamicObject entryDyo : entryDyoCol) {
            if (!StringUtils.isNotEmpty((CharSequence)entryDyo.getString("erpbillnumber")) || cancelRrpNos.size() <= 0 || !cancelRrpNos.contains(entryDyo.getString("erpbillnumber"))) continue;
            entryDyo.set("erpbillstatus", (Object)BillStatusEnum.CANCELED.getVal());
            entryDyo.set("erplogstatus", (Object)"");
        }
    }

    private void abandonWorkflow(String orderId) {
        Long procInstId;
        if (WorkflowServiceHelper.inProcess((String)orderId) && null != (procInstId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)orderId))) {
            for (int i = 0; i < 3; ++i) {
                try {
                    WorkflowServiceHelper.abandon((Long)procInstId);
                    log.info("\u7ec8\u6b62\u6d41\u7a0b\u6210\u529f\uff1a" + orderId);
                    return;
                }
                catch (KDException e) {
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u6d41\u8f6c\uff0c\u65e0\u6cd5\u5f3a\u5236\u7ec8\u6b62\u3002", (String)"MalOrderCancelOp_3", (String)"scm-mal-opplugin", (Object[])new Object[0]);
                    if (msg.equals(e.getMessage())) {
                        try {
                            Thread.sleep(2000L);
                            WorkflowServiceHelper.abandon((Long)procInstId);
                        }
                        catch (InterruptedException interruptedException) {
                            log.warn("\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u6d41\u8f6c\uff0c\u65e0\u6cd5\u5f3a\u5236\u7ec8\u6b62,\u7b49\u5f852s\u5f02\u5e38");
                        }
                        continue;
                    }
                    log.error("\u7ec8\u6b62\u670d\u52a1\u6d41\u7a0b\u5f02\u5e38\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                    return;
                }
            }
        }
    }

    public void cancelJdOrder(DynamicObject dataEntity) {
        String jdOrderId = dataEntity.getString("jdorderid");
        if (StringUtils.isNotBlank((CharSequence)jdOrderId)) {
            String enterpriseId = RequestContext.getOrCreate().getTenantId();
            Long adminOrgId = RequestContext.getOrCreate().getOrgId();
            String token = JDAccessTokenUtil.getAccessTokenByOrgID((String)String.valueOf(adminOrgId), (String)enterpriseId);
            String reason = ResManager.loadKDString((String)"\u540c\u610f\u53d6\u6d88", (String)"MalOrderCancelOp_4", (String)"scm-mal-opplugin", (Object[])new Object[0]);
            String data = "token=" + token + "&jdOrderId=" + jdOrderId + "&cancelReason=" + reason;
            String json = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/order/cancel", (String)data);
            log.info("@@@cancalJdOrder:" + json);
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success")) {
                log.info("\u53d6\u6d88\u4eac\u4e1c\u8ba2\u5355 " + jdOrderId + "\u6210\u529f\uff01");
            } else {
                log.error("@@@cancalJdOrder:" + json);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderCancelOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObject[] getPurOrderInfo(DynamicObject dataEntity) {
        HashSet<String> noSet = new HashSet<String>();
        DynamicObjectCollection entryDyoCol = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDyo : entryDyoCol) {
            String purOrderNo = entryDyo.getString("erpbillnumber");
            if (!StringUtils.isNotBlank((CharSequence)purOrderNo)) continue;
            noSet.add(purOrderNo);
        }
        QFilter filter = new QFilter("billno", "in", noSet);
        return BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billstatus,billno,materialentry.qty,cfmstatus", (QFilter[])new QFilter[]{filter});
    }

    private boolean isPartCancelOrder(String source, DynamicObject malOrder) {
        boolean isallcancelFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"ispartcancel").and(new QFilter("paramvalue", "=", (Object)"N"))});
        if (!ApiConfigUtil.hasCQScmConfig() && isallcancelFlag) {
            return false;
        }
        List<String> partEntryIds = this.getPartEntryIds(malOrder);
        if (partEntryIds.size() == 0) {
            return false;
        }
        DynamicObjectCollection entryCol = malOrder.getDynamicObjectCollection("entryentity");
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            HashSet<String> childrenOrderIds = new HashSet<String>(16);
            for (DynamicObject row : entryCol) {
                if (!partEntryIds.contains(row.getString("id")) || null == row.get("order")) continue;
                childrenOrderIds.add(row.getString("order.id"));
            }
            if (null != malOrder.get("ecorderid")) {
                for (DynamicObject row : entryCol) {
                    String orderId = row.getString("order.id");
                    if (row.getString("entrystatus").equals("F") || childrenOrderIds.contains(orderId)) continue;
                    return true;
                }
                return false;
            }
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            HashSet<String> cancelBilnos = new HashSet<String>(16);
            for (DynamicObject row : entryCol) {
                String erpbillstatus;
                if (!partEntryIds.contains(row.getString("id")) || !"A".equals(erpbillstatus = row.getString("erpbillstatus")) && !"B".equals(erpbillstatus)) continue;
                cancelBilnos.add(row.getString("erpbillnumber"));
            }
            for (DynamicObject row : entryCol) {
                String erpbillnumber = row.getString("erpbillnumber");
                if (row.getString("entrystatus").equals("F") || cancelBilnos.contains(erpbillnumber)) continue;
                return true;
            }
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            for (DynamicObject row : entryCol) {
                if (row.getString("entrystatus").equals("F") || partEntryIds.contains(row.getString("id"))) continue;
                return true;
            }
        }
        return false;
    }

    private void cancelMalOrder(DynamicObject malOrder) {
        String source = malOrder.getString("platform");
        if (this.isPartCancelOrder(source, malOrder)) {
            this.doPartCancelMalOrder(source, malOrder);
        } else {
            OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
            Map paramMap = operation.getVariables();
            String ismsg = (String)paramMap.get("ismsg");
            if (!StringUtils.isEmpty((CharSequence)ismsg)) {
                return;
            }
            String orderPkId = malOrder.get("ecorderid_id").toString();
            String parentOrderId = MalPlaceOrderUtils.getOrderId((String)source, (String)orderPkId);
            HashMap<String, String> request = new HashMap<String, String>();
            request.put(source, parentOrderId);
            Map data = EcGroupApiUtil.cancelEcOrder(request);
            if (null != data && ((Boolean)data.get(source)).booleanValue()) {
                log.info(EcPlatformEnum.fromVal((String)source).getName() + "\u53d6\u6d88\u8ba2\u5355 " + parentOrderId + "\u6210\u529f\uff01");
            } else {
                String msg = ResManager.loadKDString((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderCancelOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0]);
                throw new KDBizException(EcPlatformEnum.fromVal((String)source).getName() + msg);
            }
        }
    }

    private void doPartCancelMalOrder(String source, DynamicObject malOrder) {
        List<String> partEntryIds = this.getPartEntryIds(malOrder);
        DynamicObjectCollection entryCol = malOrder.getDynamicObjectCollection("entryentity");
        HashSet<Long> childOrderIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCol) {
            String ecOrderId = row.getString("order.id");
            if (StringUtils.isEmpty((CharSequence)ecOrderId) || !partEntryIds.contains(row.getString("id"))) continue;
            childOrderIds.add(Long.parseLong(ecOrderId));
        }
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String ismsg = (String)paramMap.get("ismsg");
        if (childOrderIds.size() > 0 && !StringUtils.isEmpty((CharSequence)ismsg)) {
            QFilter qFilter = new QFilter("id", "in", childOrderIds);
            DynamicObjectCollection jdOrders = QueryServiceHelper.query((String)"pbd_jdorder", (String)"number", (QFilter[])qFilter.toArray());
            StringBuilder logStr = new StringBuilder();
            for (DynamicObject jdOrder : jdOrders) {
                String ecOrderId = jdOrder.getString("number");
                if (StringUtils.isEmpty((CharSequence)ecOrderId)) continue;
                HashMap<String, String> request = new HashMap<String, String>();
                request.put(source, ecOrderId);
                Map data = EcGroupApiUtil.cancelEcOrder(request);
                if (null != data && ((Boolean)data.get(source)).booleanValue()) {
                    logStr.append(EcPlatformEnum.fromVal((String)source).getName()).append("cancel order ").append(ecOrderId).append("success\uff01").append(System.lineSeparator());
                    continue;
                }
                String msg = ResManager.loadKDString((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderCancelOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0]);
                throw new KDBizException(EcPlatformEnum.fromVal((String)source).getName() + msg);
            }
            log.info(logStr.toString());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        HashMap<String, BigDecimal> erpSourceEntryIdQtyMap = new HashMap<String, BigDecimal>();
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String entrIdListStr = (String)paramMap.get("closeentryIds");
        List closeentryIds = new ArrayList(16);
        if (!StringUtils.isEmpty((CharSequence)entrIdListStr)) {
            closeentryIds = (List)SerializationUtils.fromJsonString((String)entrIdListStr, List.class);
        }
        StringBuilder logStr = new StringBuilder();
        logStr.append("closeentryIds=").append(SerializationUtils.toJsonString(closeentryIds)).append(System.lineSeparator());
        logStr.append("cancelEntryIdMap=").append(SerializationUtils.toJsonString(this.cancelEntryIdMap)).append(System.lineSeparator());
        for (DynamicObject obj : e.getDataEntities()) {
            String billstatus = obj.getString("billstatus");
            List<String> partEntryIds = this.getPartEntryIds(obj);
            logStr.append("partEntryIds=").append(SerializationUtils.toJsonString(partEntryIds)).append(System.lineSeparator());
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            Set<Long> entryIds = this.cancelEntryIdMap.get(obj.getLong("id"));
            for (DynamicObject entry : entryCol) {
                if (!StringUtils.isNotEmpty((CharSequence)entry.getString("erpsourceentryid"))) continue;
                if (defaultMalVersion && !"Z".equals(billstatus)) {
                    if (!partEntryIds.contains(entry.getString("id"))) continue;
                    erpSourceEntryIdQtyMap.put(entry.getString("erpsourceentryid"), entry.getBigDecimal("qty").negate());
                    continue;
                }
                if (entryIds.size() > 0) {
                    if (partEntryIds.size() > 0 && partEntryIds.contains(entry.getString("id"))) {
                        erpSourceEntryIdQtyMap.put(entry.getString("erpsourceentryid"), entry.getBigDecimal("qty").negate());
                    }
                    if (partEntryIds.size() != 0 || closeentryIds.size() != 0 && !closeentryIds.contains(entry.getString("id"))) continue;
                    erpSourceEntryIdQtyMap.put(entry.getString("erpsourceentryid"), entry.getBigDecimal("qty").negate());
                    continue;
                }
                erpSourceEntryIdQtyMap.put(entry.getString("erpsourceentryid"), entry.getBigDecimal("qty").negate());
            }
        }
        logStr.append("erpSourceEntryIdQtyMap=").append(SerializationUtils.toJsonString(erpSourceEntryIdQtyMap));
        log.info(logStr.toString());
        this.writeBackMalPlan(erpSourceEntryIdQtyMap);
        for (DynamicObject obj : e.getDataEntities()) {
            this.abandonWorkflow(obj.getString("id"));
        }
    }

    private void writeBackMalPlan(Map<String, BigDecimal> erpSourceEntryIdQtyMap) {
        if (erpSourceEntryIdQtyMap.isEmpty()) {
            return;
        }
        MalPlan.batchUpdateJoinQtyAndQty(erpSourceEntryIdQtyMap);
    }
}

