/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.service.MalEcSubmitOrderService;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.opplugin.validator.MalGoodsStatusValidator;
import kd.scm.mal.opplugin.validator.MalLicenseValidator;
import kd.scm.mal.opplugin.validator.MalOrderRowLimitValidator;
import kd.scm.mal.opplugin.validator.MalSaleableValidator;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;
import kd.scm.malcore.cache.MalSimpleObject;

public class MalOrderSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)MalOrderSaveOp.class.getName());
    private static final String CACHE_KEYS = "cacheKeys";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("entryentity.purtype");
        e.getFieldKeys().add("entryentity.linetype");
        e.getFieldKeys().add("businesstype");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("material.id");
        e.getFieldKeys().add("goods.id");
        e.getFieldKeys().add("goods.number");
        e.getFieldKeys().add("platform");
        e.getFieldKeys().add("deporg");
        e.getFieldKeys().add("rcvorg");
        e.getFieldKeys().add("settleorg");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("malinvtype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        for (ExtendedDataEntity obj : e.getValidExtDataEntities()) {
            MalEcSubmitOrderService malEcSubmitOrderService;
            DynamicObject malOrderDyn = obj.getDataEntity();
            String platform = malOrderDyn.getString("platform");
            if (!defaultMalVersion || malOrderDyn.getLong("id") != 0L || EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) || (malEcSubmitOrderService = (MalEcSubmitOrderService)MalBusinessFactory.serviceOf(MalEcSubmitOrderService.class, (String)platform)) == null) continue;
            MalEcSubmitOrderResult malEcSubmitOrderResult = malEcSubmitOrderService.submitEcOrder(malEcSubmitOrderService.prepareSubmitOrderParam(malOrderDyn));
            DynamicObject ecOrderDyn = malEcSubmitOrderService.saveEcOrder(malEcSubmitOrderResult);
            this.updateMalOrderByEcSubmitResult(malEcSubmitOrderResult, malOrderDyn, ecOrderDyn);
        }
    }

    private void updateMalOrderByEcSubmitResult(MalEcSubmitOrderResult malEcSubmitOrderResult, DynamicObject malOrderDyn, DynamicObject ecOrderDyn) {
        String platform = malOrderDyn.getString("platform");
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)) {
            if (malOrderDyn.getInt("paytype") == 4) {
                malOrderDyn.set("jdorderstatus", (Object)JDOrderStatusEnum.CONFIRM.getName());
            } else {
                malOrderDyn.set("jdorderstatus", (Object)JDOrderStatusEnum.CREATE.getName());
            }
        }
        malOrderDyn.set("jdorderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        malOrderDyn.set("ecorderid_id", ecOrderDyn.getPkValue());
        malOrderDyn.set("ecorderid", (Object)ecOrderDyn);
        MalEcSubmitOrderService malEcSubmitOrderService = (MalEcSubmitOrderService)MalBusinessFactory.serviceOf(MalEcSubmitOrderService.class, (String)platform);
        if (malEcSubmitOrderService != null) {
            String orderStatusFieldKey = malEcSubmitOrderService.getOrderStatusFieldKey();
            malOrderDyn.set("orderstatus", (Object)EmalStatusUtil.getNumber((String)ecOrderDyn.get(orderStatusFieldKey).toString(), (String)"1", (String)platform));
        }
        for (DynamicObject entry : malOrderDyn.getDynamicObjectCollection("entryentity")) {
            Long goodsId = entry.getLong("goods_id");
            for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
                if (!goodsId.equals(sku.getGoodsId())) continue;
                if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform) || EcPlatformEnum.ECPLATFORM_XY.getVal().equals(platform)) {
                    entry.set("taxprice", (Object)sku.getTaxPrice());
                }
                if (!ObjectUtils.isEmpty((Object)sku.getTaxRate())) {
                    entry.set("taxrate", (Object)sku.getTaxRate());
                }
                entry.set("order_id", ecOrderDyn.getPkValue());
                entry.set("order", ecOrderDyn.getPkValue());
            }
        }
        Cal4DynamicObj.reCalBill((DynamicObject)malOrderDyn, (String)"entryentity");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        HashMap<Long, Long> prodAndMaterialMap = new HashMap<Long, Long>(e.getDataEntities().length << 4);
        for (DynamicObject obj : e.getDataEntities()) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (0L == entry.getLong("goods_id") || 0L == entry.getLong("material_id")) continue;
                prodAndMaterialMap.put(entry.getLong("goods_id"), entry.getLong("material_id"));
            }
        }
        if (!prodAndMaterialMap.isEmpty()) {
            log.info("\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f:" + prodAndMaterialMap);
            try {
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmMatMappingService", (String)"syncProdMaterialMapping", (Object[])new Object[]{prodAndMaterialMap});
            }
            catch (Exception exception) {
                log.error(ExceptionUtil.getStackTrace((Throwable)exception));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((Object)1317361223599179776L, (String)"bos_billtype");
        for (DynamicObject malOrderDyn : e.getDataEntities()) {
            if (malOrderDyn.getLong("billtype_id") != 0L) continue;
            malOrderDyn.set("billtype_id", (Object)1317361223599179776L);
            malOrderDyn.set("billtype", (Object)billType);
        }
        if (MalOrderUtil.getDefaultMalVersion()) {
            e.addValidator((AbstractValidator)new MalLicenseValidator());
            e.addValidator((AbstractValidator)new MalGoodsStatusValidator());
            e.addValidator((AbstractValidator)new MalSaleableValidator());
            e.addValidator((AbstractValidator)new MalOrderRowLimitValidator());
            DynamicObject[] dataEntities = e.getDataEntities();
            ArrayList<String> cacheKeys = new ArrayList<String>();
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(dataEntities.length * 16);
            final HashMap<Long, BigDecimal> goodsIdToQtyMap = new HashMap<Long, BigDecimal>();
            long depOrgId = 0L;
            for (DynamicObject malOrderDyn : dataEntities) {
                DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
                depOrgId = malOrderDyn.getLong("deporg.id");
                for (DynamicObject entry : entryCol) {
                    MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.buildGeneralParam((Long)entry.getLong("goods_id"), (String)malOrderDyn.getString("platform"), (BigDecimal)entry.getBigDecimal("qty"), (String)malOrderDyn.getString("receipt.address"), (Long)depOrgId);
                    malMatGoodsInitParam.setQueryPriceFromApi(true);
                    malMatGoodsInitParams.add(malMatGoodsInitParam);
                    goodsIdToQtyMap.put(entry.getLong("goods_id"), entry.getBigDecimal("qty"));
                    cacheKeys.add(CacheKeyHelper.keyForTrace((String)entry.getString("goods_id")));
                }
            }
            final long orgId = depOrgId;
            final Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            AbstractValidator placeOrderValidator = new AbstractValidator(){

                public void validate() {
                    MalPlaceOrderValidateResult malPlaceOrderValidateResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).validateGoodsForPlaceOrder(goodsIdToQtyMap, malGoodsMap, true, orgId);
                    if (!malPlaceOrderValidateResult.getErrorInfos().isEmpty()) {
                        throw new KDBizException(String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()));
                    }
                }
            };
            e.addValidator(placeOrderValidator);
            this.cacheGoodsInfo(cacheKeys, malGoodsMap);
        } else {
            MalBizFowUtil.setBizTypeByPurtype(Arrays.asList(e.getDataEntities()));
            HashSet<Long> receiptIdSet = new HashSet<Long>(16);
            HashSet<Long> goodsIdSet = new HashSet<Long>(32);
            for (DynamicObject malOrderDyn : e.getDataEntities()) {
                if (StringUtils.isNotBlank((Object)malOrderDyn.get("receipt"))) {
                    receiptIdSet.add(malOrderDyn.getLong("receipt"));
                }
                DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    if (!StringUtils.isNotBlank((Object)entry.get("goods"))) continue;
                    goodsIdSet.add(entry.getLong("goods"));
                }
            }
            Map malAddressDynMap = BusinessDataServiceHelper.loadFromCache((Object[])receiptIdSet.toArray(), (String)"mal_address");
            Map goodsDynMap = BusinessDataServiceHelper.loadFromCache((Object[])goodsIdSet.toArray(), (String)"pmm_prodmanage");
            for (DynamicObject malOrderDyn : e.getDataEntities()) {
                if (StringUtils.isNotBlank((Object)malOrderDyn.get("receipt"))) {
                    malOrderDyn.set("receipt", malAddressDynMap.get(malOrderDyn.getLong("receipt")));
                }
                DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    entry.set("goods", goodsDynMap.get(entry.getLong("goods")));
                }
            }
        }
    }

    private void cacheGoodsInfo(List<String> cacheKeys, Map<Long, MalGoods> malGoodsMap) {
        MalObjectCache<MalCacheGoodsInfo> goodsInfoCache = this.getGoodsInfoCache();
        for (MalGoods malGoods : malGoodsMap.values()) {
            MalCacheGoodsInfo malCacheGoodsInfo = new MalCacheGoodsInfo();
            malCacheGoodsInfo.setGoodsId(malGoods.getId());
            malCacheGoodsInfo.setProductNumber(malGoods.getProductNumber());
            malCacheGoodsInfo.setMinOrderQty(malGoods.getMinOrderQty());
            malCacheGoodsInfo.setPrice(malGoods.getPrice());
            malCacheGoodsInfo.setTaxPrice(malGoods.getTaxPrice());
            malCacheGoodsInfo.setTaxRate(malGoods.getTaxRate());
            malCacheGoodsInfo.setEcPrice(malGoods.getEcPrice());
            goodsInfoCache.put(CacheKeyHelper.keyForTrace((String)String.valueOf(malGoods.getId())), (MalSimpleObject)malCacheGoodsInfo);
        }
        this.getOption().setVariableValue(CACHE_KEYS, SerializationUtils.toJsonString(cacheKeys));
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        String cacheKeys;
        if (MalOrderUtil.getDefaultMalVersion() && StringUtils.isNotBlank((CharSequence)(cacheKeys = this.getOption().getVariableValue(CACHE_KEYS)))) {
            List cacheKeyList = (List)SerializationUtils.fromJsonString((String)cacheKeys, List.class);
            MalObjectCache<MalCacheGoodsInfo> goodsInfoCache = this.getGoodsInfoCache();
            goodsInfoCache.remove(cacheKeyList.toArray(new String[0]));
        }
    }

    private MalObjectCache<MalCacheGoodsInfo> getGoodsInfoCache() {
        return MalObjectCache.get(MalCacheGoodsInfo.class);
    }
}

