/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.opplugin.validator.MalOrderSubmitValidator;
import kd.scm.malcore.domain.GoodsInventoryHandleOrder;
import kd.scm.malcore.domain.GoodsInventoryHandleParam;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;

public class MalOrderSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.goods");
        e.getFieldKeys().add("platform");
        e.getFieldKeys().add("entryentity.erpsourceentryid");
        e.getFieldKeys().add("entryentity.qty");
        e.getFieldKeys().add("deporg");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("receipt.address.id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MalOrderSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (MalOrderParamUtil.getDefaultMalVersion()) {
            DynamicObject[] dynamicObjects = e.getDataEntities();
            GoodsInventoryHandleParam goodsInventoryHandleParam = new GoodsInventoryHandleParam();
            ArrayList<GoodsInventoryHandleOrder> orderList = new ArrayList<GoodsInventoryHandleOrder>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(dynamicObject.getString("platform"))) continue;
                GoodsInventoryHandleOrder goodsInventoryHandleOrder = new GoodsInventoryHandleOrder();
                goodsInventoryHandleOrder.setOperationName("submit");
                goodsInventoryHandleOrder.setEntityName("mal_order");
                goodsInventoryHandleOrder.setBillNo(dynamicObject.getString("billno"));
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dynamicObjectCollection.size());
                for (DynamicObject entry : dynamicObjectCollection) {
                    long goodsId = entry.getLong("goods_id");
                    GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
                    sku.setGoodsId(Long.valueOf(goodsId));
                    sku.setGoodsNumber(entry.getDynamicObject("goods").getString("number"));
                    sku.setQty(entry.getBigDecimal("qty"));
                    skuList.add(sku);
                }
                goodsInventoryHandleOrder.setSkuList(skuList);
                orderList.add(goodsInventoryHandleOrder);
            }
            goodsInventoryHandleParam.setGoodsInventoryHandleOrderList(orderList);
            if (!orderList.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"addGoodsLockInventoryQty", (Object[])new Object[]{goodsInventoryHandleParam});
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        HashMap<String, BigDecimal> erpSourceEntryIdQtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject obj : e.getDataEntities()) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (!StringUtils.isNotEmpty((CharSequence)entry.getString("erpsourceentryid"))) continue;
                erpSourceEntryIdQtyMap.put(entry.getString("erpsourceentryid"), entry.getBigDecimal("qty"));
            }
        }
        MalPlan.batchUpdateJoinQtyAndQty(erpSourceEntryIdQtyMap);
    }
}

