/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.shopcart.vo.MalAddCartParam;

public class MalPurSchemeAddCartOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("goodsentry");
        e.getFieldKeys().add("goods.id");
        e.getFieldKeys().add("goods.source");
        e.getFieldKeys().add("goods.number");
        e.getFieldKeys().add("goodsentry.qty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        HashSet<Object> selectedGoodsIdsSet = new HashSet();
        if (option.containsVariable("selectedGoodsIds")) {
            String selectedGoodsIds = option.getVariableValue("selectedGoodsIds");
            String[] selectedGoodsIdsArr = selectedGoodsIds.split(",");
            selectedGoodsIdsSet = new HashSet<String>(Arrays.asList(selectedGoodsIdsArr));
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<MalAddCartParam> malAddCartParams = new ArrayList<MalAddCartParam>();
        for (DynamicObject dyn : dataEntities) {
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("goodsentry");
            for (DynamicObject entry : entryCol) {
                DynamicObject goodsDyn = entry.getDynamicObject("goods");
                if (goodsDyn == null || !selectedGoodsIdsSet.isEmpty() && !selectedGoodsIdsSet.contains(goodsDyn.getString("id"))) continue;
                MalAddCartParam malAddCartParam = new MalAddCartParam();
                malAddCartParam.setGoodsId(Long.valueOf(goodsDyn.getLong("id")));
                malAddCartParam.setGoodsNumber(goodsDyn.getString("number"));
                malAddCartParam.setPlatform(goodsDyn.getString("source"));
                malAddCartParam.setQty(entry.getBigDecimal("qty"));
                malAddCartParams.add(malAddCartParam);
            }
        }
        ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).batchAddToCart(malAddCartParams);
    }
}

