/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.mal.common.util.MalAddressUtil;
import net.sf.json.JSONObject;

public class MalRepairJdAdrOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(MalRepairJdAdrOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("jdaddressnum");
        e.getFieldKeys().add("address");
        e.getFieldKeys().add("mapaddress");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] addrDynArr = e.getDataEntities();
        HashMap<String, String> adrAdmindMap = new HashMap<String, String>();
        for (DynamicObject dyn : addrDynArr) {
            if (!adrAdmindMap.containsKey(dyn.getString("address"))) {
                String jdAdrNum = this.getJdAdrNum(dyn);
                adrAdmindMap.put(dyn.getString("address"), jdAdrNum);
                dyn.set("jdaddressnum", (Object)jdAdrNum);
                continue;
            }
            dyn.set("jdaddressnum", adrAdmindMap.get(dyn.getString("address")));
        }
        SaveServiceHelper.save((DynamicObject[])addrDynArr);
    }

    public String getJdAdrNum(DynamicObject dyn) {
        try {
            DynamicObject addressDyn = MalAddressUtil.getAdmindivisionById((String)dyn.getString("address"));
            if (addressDyn != null && addressDyn.getString("fullname").split("_").length > 2) {
                JSONObject jdAdr = JSONObject.fromObject((Object)JdApiUtil.getAddressJonString((String)(addressDyn.getString("fullname") + "_" + dyn.getString("mapaddress"))));
                StringBuilder sb = new StringBuilder();
                sb.append(jdAdr.getString("provinceId")).append('_').append(jdAdr.getString("cityId")).append('_').append(jdAdr.getString("countyId")).append('_');
                if ("null".equals(jdAdr.getString("townId"))) {
                    sb.append('0');
                } else {
                    sb.append(jdAdr.getString("townId"));
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u5931\u8d25\u3002\n" + e.getMessage(), (Throwable)e);
            return " ";
        }
        return " ";
    }
}

