/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.mal.common.aftersale.AfterSaleFactory;
import kd.scm.mal.common.aftersale.IAfterSaleService;

public class MalReturnReqAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(MalReturnReqAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("jdserviceid");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("platform");
        e.getFieldKeys().add("goods.number");
        e.getFieldKeys().add("settleorg.id");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("address");
        e.getFieldKeys().add("linkman");
        e.getFieldKeys().add("phone");
        e.getFieldKeys().add("email");
        e.getFieldKeys().add("pickwaretype");
        e.getFieldKeys().add("goods.qty");
        e.getFieldKeys().add("taxprice");
        e.getFieldKeys().add("returntype");
        e.getFieldKeys().add("jdchildorderid");
        e.getFieldKeys().add("retreason");
        e.getFieldKeys().add("retreasoncode");
        e.getFieldKeys().add("bank");
        e.getFieldKeys().add("cardusername");
        e.getFieldKeys().add("cardnumber");
        e.getFieldKeys().add("ecsource");
        e.getFieldKeys().add("ecorder");
        e.getFieldKeys().add("admindivision");
        e.getFieldKeys().add("aftersaleentry");
        e.getFieldKeys().add("servicetime");
        e.getFieldKeys().add("aftersaleentry.afservicebill");
        e.getFieldKeys().add("aftersaleentry.afservicebill.id");
        e.getFieldKeys().add("aftersaleentry.afservicebill.number");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        for (DynamicObject dyn : e.getDataEntities()) {
            String source = dyn.getString("platform");
            IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
            if (null == afterSaleService) continue;
            afterSaleService.submitAfterSale(dyn);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        HashMap<String, BigDecimal> returnQtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject dyn : e.getDataEntities()) {
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                returnQtyMap.put(entry.getString("srcentryid"), entry.getBigDecimal("qty"));
            }
        }
        this.writeBackOrderReturnQty(returnQtyMap);
    }

    private void writeBackOrderReturnQty(Map<String, BigDecimal> returnQtyMap) {
        String selectMalOrderField = "entryentity,entryentity.sumreturnreqqty,entryentity.returnamount,entryentity.taxprice,platform";
        HashSet malOrderEntryIdSet = new HashSet(returnQtyMap.size() * 2);
        returnQtyMap.keySet().forEach(entryId -> malOrderEntryIdSet.add(Long.valueOf(entryId)));
        DynamicObject[] malOrderCol = BusinessDataServiceHelper.load((String)"mal_order", (String)selectMalOrderField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malOrderEntryIdSet)});
        for (int i = 0; i < malOrderCol.length; ++i) {
            DynamicObjectCollection entryCol = malOrderCol[i].getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (!returnQtyMap.containsKey(entry.getString("id"))) continue;
                BigDecimal returnQty = returnQtyMap.get(entry.getString("id"));
                BigDecimal oldSumReturnReqQty = entry.getBigDecimal("sumreturnreqqty");
                BigDecimal newSumReturnReqQty = returnQty.add(oldSumReturnReqQty);
                if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(malOrderCol[i].getString("platform"))) {
                    BigDecimal returnAmount = newSumReturnReqQty.multiply(entry.getBigDecimal("taxprice"));
                    entry.set("returnamount", (Object)returnAmount);
                }
                entry.set("sumreturnreqqty", (Object)newSumReturnReqQty);
            }
        }
        SaveServiceHelper.save((DynamicObject[])malOrderCol);
        log.info("@@\u53cd\u5199\u5546\u57ce\u8ba2\u5355\u9000\u8d27\u6570\u91cf\u548c\u9000\u8d27\u91d1\u989d\u6210\u529f");
        String selectPurOrderField = "materialentry,materialentry.sumreturnreqqty,materialentry.srcentryid";
        DynamicObject[] purOrderCol = BusinessDataServiceHelper.load((String)"pur_order", (String)selectPurOrderField, (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", returnQtyMap.keySet())});
        for (int i = 0; i < purOrderCol.length; ++i) {
            DynamicObjectCollection entryCol = purOrderCol[i].getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                if (!returnQtyMap.containsKey(entry.getString("srcentryid"))) continue;
                BigDecimal returnQty = returnQtyMap.get(entry.getString("srcentryid"));
                BigDecimal oldSumReturnReqQty = entry.getBigDecimal("sumreturnreqqty");
                BigDecimal newSumReturnReqQty = returnQty.add(oldSumReturnReqQty);
                entry.set("sumreturnreqqty", (Object)newSumReturnReqQty);
            }
        }
        SaveServiceHelper.save((DynamicObject[])purOrderCol);
        log.info("@@\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u9000\u8d27\u6570\u91cf\u6210\u529f");
    }
}

