/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.mal.common.aftersale.AfterSaleFactory;
import kd.scm.mal.common.aftersale.IAfterSaleService;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.opplugin.validator.MalReqCancelValidator;

public class MalRreturnReqCancelOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(MalRreturnReqCancelOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("jdserviceid");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("platform");
        e.getFieldKeys().add("jdchildorderid");
        e.getFieldKeys().add("aftersaleentry");
        e.getFieldKeys().add("aftersaleentry.afservicebill");
        e.getFieldKeys().add("aftersaleentry.afservicebill.id");
        e.getFieldKeys().add("aftersaleentry.afservicebill.number");
        e.getFieldKeys().add("aftersaleentry.afservicebill.orderid");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.ecorder");
        e.getFieldKeys().add("entryentity.goods");
        e.getFieldKeys().add("entryentity.goods.number");
        e.getFieldKeys().add("entryentity.returntype");
        e.getFieldKeys().add("billno");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List objs = e.getValidExtDataEntities();
        ArrayList<String> serviceIDlist = new ArrayList<String>();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        ArrayList<String> ecOrders = new ArrayList<String>(objs.size());
        StringBuilder logString = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : objs) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            dynamicObjectCollection.add((Object)obj);
            String source = obj.getString("platform");
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                DynamicObjectCollection ecAfterSaleEntryCol = obj.getDynamicObjectCollection("aftersaleentry");
                DynamicObjectCollection entryentityCol = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject ecAfterSaleEntry : ecAfterSaleEntryCol) {
                    serviceIDlist.add(ecAfterSaleEntry.getString("afservicebill.number"));
                    ecOrders.add(ecAfterSaleEntry.getString("afservicebill.orderid"));
                }
                IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)obj.getString("platform"));
                if (null != afterSaleService) {
                    if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
                        DynamicObject[] afsBills;
                        List successCancelServIds = afterSaleService.cancelAfterSale(ecOrders, serviceIDlist);
                        logString.append("successCancelServIds:").append(successCancelServIds).append(System.lineSeparator());
                        if (successCancelServIds.isEmpty()) {
                            e.setCancel(true);
                            e.setCancelMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u552e\u540e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalRreturnReqCancelOp_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        HashSet successCancelServIdSet = new HashSet(successCancelServIds.size());
                        successCancelServIds.forEach(id -> successCancelServIdSet.add(String.valueOf(id)));
                        QFilter numberFilter = new QFilter("number", "in", successCancelServIdSet);
                        for (DynamicObject afsBill : afsBills = BusinessDataServiceHelper.load((String)"pbd_eafservicebill", (String)"afsservicestep,cancelstatus", (QFilter[])new QFilter[]{numberFilter})) {
                            afsBill.set("afsservicestep", (Object)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MalRreturnReqCancelOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                            afsBill.set("cancelstatus", (Object)"0");
                        }
                        SaveServiceHelper.save((DynamicObject[])afsBills);
                    } else {
                        DynamicObject returnreqDyn = QueryServiceHelper.queryOne((String)"mal_returnreq", (String)"entryentity.ecorder", (QFilter[])new QFilter[]{new QFilter("id", "=", obj.getPkValue())});
                        String ecOrderPk = returnreqDyn.getString("entryentity.ecorder");
                        DynamicObject ecOrderDyn = null;
                        if (StringUtils.isNotEmpty((CharSequence)ecOrderPk) && !"0".equals(ecOrderPk)) {
                            ecOrderDyn = MalPlaceOrderUtils.getOrderDyn((String)ecOrderPk, (String)source);
                        }
                        if (ecOrderDyn != null) {
                            HashMap<String, String> orderItemIdSkuIdMap = new HashMap<String, String>();
                            orderItemIdSkuIdMap.put(ecOrderDyn.getString("orderid"), ((DynamicObject)entryentityCol.get(0)).getString("goods.number"));
                            afterSaleService.cancelAfterSale(orderItemIdSkuIdMap, ecOrderDyn.getString("porderid"), ((DynamicObject)entryentityCol.get(0)).getString("returntype"), ((DynamicObject)ecAfterSaleEntryCol.get(0)).getString("afservicebill.number"));
                        } else {
                            logString.append(ResManager.loadKDString((String)"@@\u7535\u5546\u8ba2\u5355ecOrderDyn\u4e3a\u7a7a\u3002", (String)"MalRreturnReqCancelOp_3", (String)"scm-mal-opplugin", (Object[])new Object[0])).append(ecOrderPk).append("\n");
                        }
                    }
                }
                logString.append("ecOrder\uff1a").append(ecOrders).append(",serviceIDlist:").append(serviceIDlist);
            }
            AfterSaleUtil.writeBackMalOrderAndPurOrder((DynamicObjectCollection)dynamicObjectCollection);
            obj.set("cfmstatus", (Object)"E");
        }
        log.info(logString.toString());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MalReqCancelValidator());
    }
}

